<?php
class mxDb {
    private $db;
    private $qry;
    public $insertID = 0;
    public $numRows = 0;
    public $pre = "mx_";
    public $row = array();
    public $rows = array();
    public $affectedRows = 0;
    public $table = "";
    public $cols = array();
    public $data = array();
    public $updateParam = array();

    function __construct($DBHOST, $DBNAME, $DBUSER, $DBPASS) {
        try {
            $this->db = new PDO("mysql:host={$DBHOST};dbname={$DBNAME};charset=UTF8", $DBUSER, $DBPASS);
        } catch (PDOException $e) {
            //echo "Error: " . $e->getMessage();
            die("Cannot connect to mySql Server.");
        }
    }

    private function dbReset() {
        $this->insertID = 0;
        $this->numRows = 0;
        $this->row = array();
        $this->rows = array();
        $this->affectedRows = 0;
        $this->table = "";
        $this->cols = array();
    }

    private function parseIn() {
        $q = $this->db->prepare("DESCRIBE {$this->table}");
        $q->execute();
        $tableFields = $q->fetchAll(PDO::FETCH_COLUMN);
        $arr = array();
        if (!empty($this->data)) {
            foreach ($this->data as $k => $v) {
                if (in_array($k, $tableFields)) {
                    $arr[$k] = ($v != "") ? $v : "";
                }
            }
            $this->data = $arr;
        }
    }

    public function dbQuery($sql) {
        
        if ($sql) {
            try {
                if ($this->qry = $this->db->prepare($sql)) {
                    $this->qry->execute($this->data);
                    $this->numRows = $this->qry->rowCount();
                    return true;
                }
            } catch (PDOException $e) {
                die($sql . "<br>$sql<br>" . $e->getMessage());
            }
        } else {
            return false;
        }
    }

    public function dbInsert() {
        $this->parseIn();
        if ($this->data) {
            try {
                $values = $fields = array();
                foreach ($this->data as $k => $v) {
                    $fields[] = $k;
                    $values[] = ":{$k}";
                }
                $fields = implode(', ', $fields);
                $values = implode(', ', $values);
                $sql = "INSERT INTO `$this->table` ($fields) VALUES ({$values})";
				$stmt = $this->db->prepare($sql);
                $stmt->execute($this->data);
                $this->insertID = $this->db->lastInsertId();
                $this->affectedRow = $stmt->rowCount();
            } catch (PDOException $e) {
                die($sql . "<br>$sql<br>" . $e->getMessage());
            }
            return true;
        }
    }

    public function dbUpdate($where) {
        $this->parseIn();
        if (!empty($this->data) && !empty($where)) {
            try {
                $sql = $sep = '';
                foreach ($this->data as $k => $v) {
                    $sql .= "{$sep}{$k} = :{$k}";
                    $sep = ", ";
                }
                $sql = "UPDATE `$this->table` SET $sql WHERE $where";
                $stmt = $this->db->prepare($sql);
                $this->data = array_merge($this->data, $this->updateParam);
                $stmt->execute($this->data);
                $this->affectedRow = $stmt->rowCount();
            } catch (PDOException $e) {
                die($sql . "<br>$sql<br>" . $e->getMessage());
            }
        }
        return true;
    }

    public function dbRows($sql) {
        $this->dbReset();
        if ($sql) {
            try {
                $this->dbQuery($sql);
                if ($this->numRows > 0) {
                    $this->rows = $this->qry->fetchAll(PDO::FETCH_ASSOC);
                }
                return $this->rows;
            } catch (PDOException $e) {
                die($sql . "<br>$sql<br>" . $e->getMessage());
            }
        }
    }

    public function dbRow($sql) {
        $this->dbReset();
        if ($sql) {
            try {
                $this->dbQuery($sql);
                if ($this->numRows > 0) {
                    $this->row = $this->qry->fetch(PDO::FETCH_ASSOC);
                }
                return $this->row;
            } catch (PDOException $e) {
                die($sql . "<br>$sql<br>" . $e->getMessage());
            }
        }
    }

}

?>