/*
Navicat MySQL Data Transfer

Source Server         : expert script
Source Server Version : 50051
Source Host           : localhost:3306
Source Database       : sorat

Target Server Type    : MYSQL
Target Server Version : 50051
File Encoding         : 65001

Date: 2023-08-28 11:54:30
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `mx_account_type`
-- ----------------------------
DROP TABLE IF EXISTS `mx_account_type`;
CREATE TABLE `mx_account_type` (
  `acTypeID` int(11) NOT NULL auto_increment,
  `acName` varchar(255) default NULL,
  `monthlyCharge` int(11) default '0',
  `price` decimal(7,2) default NULL,
  `dateAdded` datetime default NULL,
  `dateModified` datetime default NULL,
  `status` tinyint(1) default '1',
  PRIMARY KEY  (`acTypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_account_type
-- ----------------------------
INSERT INTO `mx_account_type` VALUES ('1', 'Basic', '0', null, '2015-07-10 11:49:51', '2015-07-10 11:50:01', '1');
INSERT INTO `mx_account_type` VALUES ('2', 'Silver', '1', '0.03', '2015-07-10 11:50:08', '2015-07-10 15:17:36', '1');
INSERT INTO `mx_account_type` VALUES ('3', 'Gold', '1', '0.07', '2015-07-10 11:50:16', '2015-07-10 15:17:54', '1');
INSERT INTO `mx_account_type` VALUES ('4', 'Premium', '1', '0.10', '2015-07-10 11:51:03', '2015-07-10 15:18:08', '1');

-- ----------------------------
-- Table structure for `mx_admin_language`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_language`;
CREATE TABLE `mx_admin_language` (
  `languageID` int(11) NOT NULL auto_increment,
  `langName` varchar(100) NOT NULL,
  `langCode` varchar(5) NOT NULL,
  `langDefault` tinyint(1) NOT NULL default '0',
  `imageName` varchar(100) NOT NULL,
  `dateAdded` datetime NOT NULL default '0000-00-00 00:00:00',
  `dateModified` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`languageID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_language
-- ----------------------------
INSERT INTO `mx_admin_language` VALUES ('1', 'English', 'en', '1', '0600292001360744979.png', '2013-02-12 08:58:28', '2013-02-21 12:03:24', '1');
INSERT INTO `mx_admin_language` VALUES ('2', 'French', 'fr', '0', '0957502001360745002.png', '2013-02-12 09:10:47', '2013-02-21 12:03:11', '1');
INSERT INTO `mx_admin_language` VALUES ('5', 'German', 'gr', '0', '0108572001360745013.png', '2013-02-12 09:27:57', '2013-02-13 14:13:33', '1');

-- ----------------------------
-- Table structure for `mx_admin_menu`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_menu`;
CREATE TABLE `mx_admin_menu` (
  `adminMenuID` int(10) unsigned NOT NULL auto_increment,
  `menuType` tinyint(1) NOT NULL default '0',
  `menuTitle` varchar(100) character set utf8 collate utf8_unicode_ci NOT NULL,
  `seoUri` varchar(100) character set utf8 collate utf8_unicode_ci NOT NULL default '#',
  `xOrder` int(3) NOT NULL default '0',
  `parentID` int(11) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`adminMenuID`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_menu
-- ----------------------------
INSERT INTO `mx_admin_menu` VALUES ('4', '0', 'Dashboard', 'dashboard', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('13', '0', 'State', 'state', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('17', '0', 'District', 'district', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('20', '0', 'Home gallery', 'home-gallery', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('21', '0', 'Menu', 'menu', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('22', '0', 'Page', 'page', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('24', '0', 'Plan', 'plan', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('25', '0', 'Registration', 'registration', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('26', '0', 'Seminar schedule', 'seminar-schedule', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('27', '0', 'Product', 'product', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('28', '0', 'Epin', 'epin', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('29', '0', 'Send epin', 'send-epin', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('30', '0', 'Place', 'place', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('32', '0', 'Balance', 'balance', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('33', '0', 'Wallet', 'wallet', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('34', '0', 'Payment request', 'payment-request', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('35', '0', '   close', '---close', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('36', '0', 'Binary close', 'binary-close', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('37', '0', 'Weekly binary close', 'weekly-binary-close', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('38', '0', 'Royalti balance', 'royalti-balance', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('39', '0', 'Order', 'order', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('40', '0', 'Order delivered', 'order-delivered', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('41', '0', 'Payment paid', 'payment-paid', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('42', '0', 'News', 'news', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('43', '0', 'Contact', 'contact', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('44', '0', 'Bank report roi', 'bank-report-roi', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('45', '0', 'Bank report', 'bank-report', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('46', '0', 'Balance roi', 'balance-roi', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('47', '0', 'Royalti close', 'royalti-close', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('48', '0', 'Bank', 'bank', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('49', '0', 'Fund', 'fund', '0', '0', '1');
INSERT INTO `mx_admin_menu` VALUES ('50', '0', 'Sms panel', 'sms-panel', '0', '0', '1');

-- ----------------------------
-- Table structure for `mx_admin_meta_setting`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_meta_setting`;
CREATE TABLE `mx_admin_meta_setting` (
  `metaSettingID` int(11) NOT NULL auto_increment,
  `sitePage` varchar(100) NOT NULL,
  `adminMod` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`metaSettingID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_meta_setting
-- ----------------------------
INSERT INTO `mx_admin_meta_setting` VALUES ('2', '/home', 'home', '1');

-- ----------------------------
-- Table structure for `mx_admin_role`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_role`;
CREATE TABLE `mx_admin_role` (
  `roleAID` int(10) unsigned NOT NULL auto_increment,
  `roleName` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `roleEmail` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`roleAID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_role
-- ----------------------------
INSERT INTO `mx_admin_role` VALUES ('1', 'Admin', '', '1');
INSERT INTO `mx_admin_role` VALUES ('2', 'Excutive', '', '1');

-- ----------------------------
-- Table structure for `mx_admin_setting`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_setting`;
CREATE TABLE `mx_admin_setting` (
  `settingID` int(11) NOT NULL auto_increment,
  `settingName` varchar(100) NOT NULL,
  `seoUri` varchar(100) NOT NULL,
  `settingVal` varchar(255) NOT NULL,
  `settingDefault` varchar(255) NOT NULL,
  PRIMARY KEY  (`settingID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_setting
-- ----------------------------
INSERT INTO `mx_admin_setting` VALUES ('1', 'Logo', 'logo', '0705662001524656054.png', 'logo.png');
INSERT INTO `mx_admin_setting` VALUES ('2', 'Favicon', 'favicon', 'favicon.png', 'favicon.png');
INSERT INTO `mx_admin_setting` VALUES ('3', 'Page Title', 'page-title', 'Expert Script', 'Expert Script');
INSERT INTO `mx_admin_setting` VALUES ('4', 'Theme', 'theme', 'maxdigi', 'default');
INSERT INTO `mx_admin_setting` VALUES ('5', 'Default Page', 'default-page', 'dashboard', 'admin-user');
INSERT INTO `mx_admin_setting` VALUES ('6', 'Editor', 'editor', 'Full', 'Full');
INSERT INTO `mx_admin_setting` VALUES ('7', 'Language On', 'lang', '0', 'en');

-- ----------------------------
-- Table structure for `mx_admin_site_meta`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_site_meta`;
CREATE TABLE `mx_admin_site_meta` (
  `siteMetaID` int(11) NOT NULL auto_increment,
  `sitePage` varchar(100) NOT NULL,
  `adminMod` varchar(100) NOT NULL,
  `metaID` int(11) NOT NULL,
  `seoUri` varchar(256) NOT NULL,
  `metaTitle` varchar(256) NOT NULL,
  `metaKeyword` varchar(165) NOT NULL,
  `metaDesc` varchar(256) NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`siteMetaID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_site_meta
-- ----------------------------
INSERT INTO `mx_admin_site_meta` VALUES ('6', '/home', 'home', '0', '', 'Ariha', 'emall', 'mall', '1');

-- ----------------------------
-- Table structure for `mx_admin_user`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_user`;
CREATE TABLE `mx_admin_user` (
  `userID` int(10) unsigned NOT NULL auto_increment,
  `roleAID` int(5) NOT NULL default '0',
  `displayName` varchar(100) character set utf8 collate utf8_unicode_ci NOT NULL,
  `lastName` varchar(100) character set utf8 collate utf8_unicode_ci NOT NULL,
  `userName` varchar(100) character set utf8 collate utf8_unicode_ci NOT NULL,
  `userPass` varchar(100) character set utf8 collate utf8_unicode_ci NOT NULL,
  `userEmail` varchar(100) character set utf8 collate utf8_unicode_ci NOT NULL,
  `isPremiumUser` tinyint(1) NOT NULL default '0',
  `imageName` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `dateAdded` datetime NOT NULL default '0000-00-00 00:00:00',
  `dateModified` datetime NOT NULL default '0000-00-00 00:00:00',
  `dateLogin` datetime NOT NULL default '0000-00-00 00:00:00',
  `loginKey` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `isRemember` tinyint(1) NOT NULL default '0',
  `remoteAddress` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `activationKey` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `dailyNotifyDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `weeklyNotifyDate` date NOT NULL default '0000-00-00',
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`userID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_user
-- ----------------------------
INSERT INTO `mx_admin_user` VALUES ('1', '1', 'Ideal Trading', '', 'admin', '21232f297a57a5a743894a0e4a801fc3', 'fdgouje@gmail.com', '0', '0964573001404197279.png', '2014-05-29 00:17:12', '2020-09-19 04:51:10', '2020-09-19 09:08:36', '', '0', '', '', '0000-00-00 00:00:00', '0000-00-00', '1');

-- ----------------------------
-- Table structure for `mx_admin_user_access`
-- ----------------------------
DROP TABLE IF EXISTS `mx_admin_user_access`;
CREATE TABLE `mx_admin_user_access` (
  `userAccessID` int(11) NOT NULL auto_increment,
  `roleAID` int(11) NOT NULL,
  `adminMenuID` int(11) NOT NULL,
  `accessType` text character set utf8 collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`userAccessID`)
) ENGINE=InnoDB AUTO_INCREMENT=458 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_admin_user_access
-- ----------------------------
INSERT INTO `mx_admin_user_access` VALUES ('277', '2', '4', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('278', '2', '36', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('436', '1', '4', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('437', '1', '36', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('438', '1', '41', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('439', '1', '42', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('440', '1', '44', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('441', '1', '45', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('442', '1', '46', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('443', '1', '47', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('444', '1', '48', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('445', '1', '49', '[\"view\",\"add\",\"edit\",\"delete\",\"trash\",\"restore\"]');
INSERT INTO `mx_admin_user_access` VALUES ('446', '1', '13', '[\"add\",\"edit\",\"delete\",\"trash\",\"restore\"]');
INSERT INTO `mx_admin_user_access` VALUES ('447', '1', '17', '[\"add\",\"edit\",\"delete\",\"trash\",\"restore\"]');
INSERT INTO `mx_admin_user_access` VALUES ('448', '1', '20', '[\"view\",\"add\",\"edit\",\"delete\",\"trash\",\"restore\"]');
INSERT INTO `mx_admin_user_access` VALUES ('449', '1', '21', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('450', '1', '25', '[\"view\",\"edit\"]');
INSERT INTO `mx_admin_user_access` VALUES ('451', '1', '28', '[\"view\",\"add\",\"edit\",\"delete\",\"trash\",\"restore\"]');
INSERT INTO `mx_admin_user_access` VALUES ('452', '1', '29', '[\"view\",\"add\",\"restore\"]');
INSERT INTO `mx_admin_user_access` VALUES ('453', '1', '30', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('454', '1', '32', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('455', '1', '33', '[\"view\"]');
INSERT INTO `mx_admin_user_access` VALUES ('456', '1', '50', '[\"view\",\"add\"]');
INSERT INTO `mx_admin_user_access` VALUES ('457', '1', '100001', '[\"view\",\"add\",\"edit\",\"delete\",\"trash\",\"restore\"]');

-- ----------------------------
-- Table structure for `mx_agent`
-- ----------------------------
DROP TABLE IF EXISTS `mx_agent`;
CREATE TABLE `mx_agent` (
  `userID` int(11) NOT NULL auto_increment,
  `userCode` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `password` varchar(255) default NULL,
  `mobileNo` varchar(20) default NULL,
  `userType` int(11) default NULL,
  `underHead` int(11) default NULL,
  `winRate` varchar(100) default NULL,
  `commssion` decimal(5,2) default NULL,
  `bonus` decimal(5,2) default NULL,
  `limit` int(11) default NULL,
  `remark` text,
  `createdBy` int(11) default NULL,
  `isActive` tinyint(1) default '0',
  `dateAdded` datetime default NULL,
  `dateModified` datetime default NULL,
  `status` tinyint(1) default '1',
  PRIMARY KEY  (`userID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_agent
-- ----------------------------

-- ----------------------------
-- Table structure for `mx_balance`
-- ----------------------------
DROP TABLE IF EXISTS `mx_balance`;
CREATE TABLE `mx_balance` (
  `balanceID` int(11) NOT NULL auto_increment,
  `userCode` varchar(255) character set utf8 collate utf8_unicode_ci default NULL,
  `balance` decimal(11,2) default NULL,
  PRIMARY KEY  (`balanceID`),
  KEY `idx1` (`userCode`)
) ENGINE=InnoDB AUTO_INCREMENT=10115 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_balance
-- ----------------------------
INSERT INTO `mx_balance` VALUES ('1', 'ag11', '20000.00');
INSERT INTO `mx_balance` VALUES ('2', 'ret1', '19900.00');
INSERT INTO `mx_balance` VALUES ('3', 'ret1', '19800.00');
INSERT INTO `mx_balance` VALUES ('4', 'ret1', '19700.00');
INSERT INTO `mx_balance` VALUES ('5', 'ret1', '19600.00');
INSERT INTO `mx_balance` VALUES ('6', 'ret1', '19500.00');
INSERT INTO `mx_balance` VALUES ('7', 'ret1', '19900.00');
INSERT INTO `mx_balance` VALUES ('8', 'ret1', '19900.00');
INSERT INTO `mx_balance` VALUES ('9', 'ret1', '19900.00');
INSERT INTO `mx_balance` VALUES ('10', 'ret1', '19800.00');
INSERT INTO `mx_balance` VALUES ('11', 'ret1', '19700.00');
INSERT INTO `mx_balance` VALUES ('12', 'ret1', '19600.00');
INSERT INTO `mx_balance` VALUES ('13', 'ret1', '19500.00');
INSERT INTO `mx_balance` VALUES ('14', 'ret1', '19400.00');
INSERT INTO `mx_balance` VALUES ('15', 'ret1', '19300.00');
INSERT INTO `mx_balance` VALUES ('16', 'ret1', '19250.00');
INSERT INTO `mx_balance` VALUES ('17', 'ret1', '19200.00');
INSERT INTO `mx_balance` VALUES ('18', 'ret1', '19150.00');
INSERT INTO `mx_balance` VALUES ('19', 'ret1', '19050.00');
INSERT INTO `mx_balance` VALUES ('20', 'ret1', '18950.00');
INSERT INTO `mx_balance` VALUES ('21', 'ret1', '18930.00');
INSERT INTO `mx_balance` VALUES ('22', 'ret1', '18880.00');
INSERT INTO `mx_balance` VALUES ('23', 'ret1', '18830.00');
INSERT INTO `mx_balance` VALUES ('24', 'ret1', '18640.00');
INSERT INTO `mx_balance` VALUES ('25', 'ret1', '18300.00');
INSERT INTO `mx_balance` VALUES ('26', 'ret1', '18150.00');
INSERT INTO `mx_balance` VALUES ('27', 'ret1', '17980.00');
INSERT INTO `mx_balance` VALUES ('28', 'ret1', '16980.00');
INSERT INTO `mx_balance` VALUES ('29', 'ret1', '16800.00');
INSERT INTO `mx_balance` VALUES ('30', 'ret1', '16800.00');
INSERT INTO `mx_balance` VALUES ('31', 'ret1', '16800.00');
INSERT INTO `mx_balance` VALUES ('32', 'ret1', '16800.00');
INSERT INTO `mx_balance` VALUES ('33', 'ret1', '16760.00');
INSERT INTO `mx_balance` VALUES ('34', 'ret1', '16740.00');
INSERT INTO `mx_balance` VALUES ('35', 'ret1', '16710.00');
INSERT INTO `mx_balance` VALUES ('36', 'ret1', '16660.00');
INSERT INTO `mx_balance` VALUES ('37', 'ret1', '16430.00');
INSERT INTO `mx_balance` VALUES ('38', 'ret1', '16000.00');
INSERT INTO `mx_balance` VALUES ('39', 'ret1', '17000.00');
INSERT INTO `mx_balance` VALUES ('40', 'ret1', '16000.00');
INSERT INTO `mx_balance` VALUES ('41', 'ret1', '17000.00');
INSERT INTO `mx_balance` VALUES ('42', 'AG11', '19000.00');
INSERT INTO `mx_balance` VALUES ('43', 'ret1', '16000.00');
INSERT INTO `mx_balance` VALUES ('44', 'ret1', '15950.00');
INSERT INTO `mx_balance` VALUES ('45', 'ret1', '15850.00');
INSERT INTO `mx_balance` VALUES ('46', 'ret1', '14850.00');
INSERT INTO `mx_balance` VALUES ('47', 'ret1', '14750.00');
INSERT INTO `mx_balance` VALUES ('48', 'ret1', '14650.00');
INSERT INTO `mx_balance` VALUES ('49', 'ret1', '14650.00');
INSERT INTO `mx_balance` VALUES ('50', 'ret1', '13650.00');
INSERT INTO `mx_balance` VALUES ('51', 'ret1', '15650.00');
INSERT INTO `mx_balance` VALUES ('52', 'ret1', '15640.00');
INSERT INTO `mx_balance` VALUES ('53', 'ret1', '15630.00');
INSERT INTO `mx_balance` VALUES ('54', 'ret1', '15580.00');
INSERT INTO `mx_balance` VALUES ('55', 'ret1', '15550.00');
INSERT INTO `mx_balance` VALUES ('56', 'ret1', '15540.00');
INSERT INTO `mx_balance` VALUES ('57', 'ret1', '15500.00');
INSERT INTO `mx_balance` VALUES ('58', 'ret1', '14000.00');
INSERT INTO `mx_balance` VALUES ('59', 'ret1', '15000.00');
INSERT INTO `mx_balance` VALUES ('60', 'ret1', '14000.00');
INSERT INTO `mx_balance` VALUES ('61', 'ret1', '12320.00');
INSERT INTO `mx_balance` VALUES ('62', 'ret1', '11320.00');
INSERT INTO `mx_balance` VALUES ('63', '021001001', '10320.00');
INSERT INTO `mx_balance` VALUES ('64', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('65', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('66', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('68', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('69', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('70', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('71', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('72', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('73', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('74', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('75', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('76', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('77', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('78', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('79', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('80', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('81', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('82', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('83', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('84', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('85', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('86', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('87', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('88', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('89', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('90', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('91', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('92', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('93', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('94', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('95', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('96', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('97', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('98', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('99', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('100', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('101', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('102', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('103', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('104', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('105', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('106', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('107', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('108', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('109', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('110', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('111', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('112', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('113', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('114', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('115', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('116', 'ret1', '11320.00');
INSERT INTO `mx_balance` VALUES ('117', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('118', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('119', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('120', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('121', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('122', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('123', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('124', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('125', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('126', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('127', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('128', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('129', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('130', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('131', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('132', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('133', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('134', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('135', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('136', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('137', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('138', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('139', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('140', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('141', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('142', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('143', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('144', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('145', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('146', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('147', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('148', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('149', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('150', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('151', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('152', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('153', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('154', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('155', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('156', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('157', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('158', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('159', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('160', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('161', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('162', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('163', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('164', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('165', 'ret1', '12320.00');
INSERT INTO `mx_balance` VALUES ('166', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('167', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('168', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('169', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('170', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('171', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('172', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('173', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('174', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('175', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('176', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('177', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('178', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('179', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('180', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('181', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('182', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('183', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('184', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('185', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('186', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('187', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('188', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('189', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('190', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('191', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('192', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('193', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('194', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('195', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('196', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('197', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('198', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('199', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('200', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('201', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('202', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('203', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('204', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('205', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('206', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('207', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('208', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('209', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('210', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('211', 'ret1', '2320.00');
INSERT INTO `mx_balance` VALUES ('212', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('213', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('214', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('215', 'ret1', '2320.00');
INSERT INTO `mx_balance` VALUES ('216', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('217', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('218', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('219', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('220', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('221', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('222', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('223', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('224', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('225', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('226', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('227', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('228', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('229', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('230', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('231', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('232', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('233', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('234', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('235', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('236', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('237', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('238', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('239', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('240', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('241', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('242', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('243', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('244', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('245', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('246', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('247', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('248', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('249', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('250', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('251', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('252', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('253', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('254', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('255', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('256', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('257', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('258', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('259', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('260', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('261', 'ret1', '1320.00');
INSERT INTO `mx_balance` VALUES ('262', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('263', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('264', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('265', 'ret1', '2320.00');
INSERT INTO `mx_balance` VALUES ('266', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('267', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('268', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('269', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('270', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('271', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('272', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('273', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('274', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('275', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('276', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('277', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('278', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('279', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('280', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('281', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('282', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('283', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('284', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('285', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('286', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('287', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('288', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('289', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('290', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('291', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('292', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('293', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('294', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('295', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('296', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('297', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('298', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('299', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('300', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('301', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('302', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('303', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('304', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('305', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('306', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('307', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('308', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('309', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('310', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('311', 'ret1', '2270.00');
INSERT INTO `mx_balance` VALUES ('312', 'ret1', '2180.00');
INSERT INTO `mx_balance` VALUES ('313', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('314', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('315', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('316', 'ret1', '2180.00');
INSERT INTO `mx_balance` VALUES ('317', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('318', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('319', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('320', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('321', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('322', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('323', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('324', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('325', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('326', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('327', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('328', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('329', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('330', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('331', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('332', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('333', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('334', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('335', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('336', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('337', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('338', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('339', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('340', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('341', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('342', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('343', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('344', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('345', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('346', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('347', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('348', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('349', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('350', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('351', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('352', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('353', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('354', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('355', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('356', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('357', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('358', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('359', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('360', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('361', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('362', 'ret1', '2020.00');
INSERT INTO `mx_balance` VALUES ('363', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('364', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('365', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('366', 'ret1', '2020.00');
INSERT INTO `mx_balance` VALUES ('367', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('368', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('369', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('370', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('371', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('372', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('373', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('374', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('375', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('376', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('377', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('378', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('379', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('380', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('381', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('382', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('383', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('384', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('385', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('386', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('387', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('388', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('389', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('390', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('391', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('392', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('393', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('394', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('395', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('396', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('397', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('398', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('399', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('400', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('401', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('402', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('403', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('404', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('405', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('406', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('407', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('408', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('409', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('410', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('411', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('412', 'ret1', '2000.00');
INSERT INTO `mx_balance` VALUES ('413', 'ret1', '1990.00');
INSERT INTO `mx_balance` VALUES ('414', 'ret1', '1980.00');
INSERT INTO `mx_balance` VALUES ('415', 'ret1', '1960.00');
INSERT INTO `mx_balance` VALUES ('416', 'ret1', '1950.00');
INSERT INTO `mx_balance` VALUES ('417', 'ret1', '1930.00');
INSERT INTO `mx_balance` VALUES ('418', 'ret1', '1920.00');
INSERT INTO `mx_balance` VALUES ('419', 'ret1', '1900.00');
INSERT INTO `mx_balance` VALUES ('420', 'ret1', '1890.00');
INSERT INTO `mx_balance` VALUES ('421', 'ret1', '1880.00');
INSERT INTO `mx_balance` VALUES ('422', 'ret1', '1870.00');
INSERT INTO `mx_balance` VALUES ('423', 'ret1', '1860.00');
INSERT INTO `mx_balance` VALUES ('424', 'ret1', '1850.00');
INSERT INTO `mx_balance` VALUES ('425', 'ret1', '1830.00');
INSERT INTO `mx_balance` VALUES ('426', 'ret1', '1810.00');
INSERT INTO `mx_balance` VALUES ('427', 'ret1', '1800.00');
INSERT INTO `mx_balance` VALUES ('428', 'ret1', '1790.00');
INSERT INTO `mx_balance` VALUES ('429', 'ret1', '1780.00');
INSERT INTO `mx_balance` VALUES ('430', 'ret1', '1770.00');
INSERT INTO `mx_balance` VALUES ('431', 'ret1', '1760.00');
INSERT INTO `mx_balance` VALUES ('432', 'ret1', '1750.00');
INSERT INTO `mx_balance` VALUES ('433', 'ret1', '1740.00');
INSERT INTO `mx_balance` VALUES ('434', 'ret1', '1730.00');
INSERT INTO `mx_balance` VALUES ('435', 'ret1', '1720.00');
INSERT INTO `mx_balance` VALUES ('436', 'ret1', '1710.00');
INSERT INTO `mx_balance` VALUES ('437', 'ret1', '1700.00');
INSERT INTO `mx_balance` VALUES ('438', 'ret1', '1690.00');
INSERT INTO `mx_balance` VALUES ('439', 'ret1', '1680.00');
INSERT INTO `mx_balance` VALUES ('440', 'ret1', '1670.00');
INSERT INTO `mx_balance` VALUES ('441', 'ret1', '1660.00');
INSERT INTO `mx_balance` VALUES ('442', 'ret1', '1650.00');
INSERT INTO `mx_balance` VALUES ('443', 'ret1', '1640.00');
INSERT INTO `mx_balance` VALUES ('444', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('445', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('446', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('447', 'ret1', '1740.00');
INSERT INTO `mx_balance` VALUES ('448', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('449', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('450', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('451', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('452', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('453', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('454', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('455', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('456', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('457', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('458', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('459', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('460', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('461', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('462', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('463', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('464', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('465', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('466', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('467', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('468', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('469', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('470', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('471', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('472', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('473', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('474', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('475', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('476', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('477', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('478', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('479', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('480', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('481', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('482', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('483', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('484', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('485', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('486', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('487', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('488', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('489', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('490', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('491', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('492', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('493', 'ret1', '1730.00');
INSERT INTO `mx_balance` VALUES ('494', 'ret1', '1720.00');
INSERT INTO `mx_balance` VALUES ('495', 'ret1', '1700.00');
INSERT INTO `mx_balance` VALUES ('496', 'ret1', '1690.00');
INSERT INTO `mx_balance` VALUES ('497', 'ret1', '1670.00');
INSERT INTO `mx_balance` VALUES ('498', 'ret1', '1660.00');
INSERT INTO `mx_balance` VALUES ('499', 'ret1', '1630.00');
INSERT INTO `mx_balance` VALUES ('500', 'ret1', '1600.00');
INSERT INTO `mx_balance` VALUES ('501', 'BB', '0.00');
INSERT INTO `mx_balance` VALUES ('502', 'AG11', '0.00');
INSERT INTO `mx_balance` VALUES ('503', 'AG2', '0.00');
INSERT INTO `mx_balance` VALUES ('504', 'ret1', '1700.00');
INSERT INTO `mx_balance` VALUES ('505', 'rd', '0.00');
INSERT INTO `mx_balance` VALUES ('506', 'bk100', '0.00');
INSERT INTO `mx_balance` VALUES ('507', 'bk101', '0.00');
INSERT INTO `mx_balance` VALUES ('508', 'bk103', '0.00');
INSERT INTO `mx_balance` VALUES ('509', 'sk100', '0.00');
INSERT INTO `mx_balance` VALUES ('510', 'MCA', '0.00');
INSERT INTO `mx_balance` VALUES ('511', 'Om1', '0.00');
INSERT INTO `mx_balance` VALUES ('512', 'Gavrav1', '0.00');
INSERT INTO `mx_balance` VALUES ('513', 'NZ1', '0.00');
INSERT INTO `mx_balance` VALUES ('514', 'Nz2', '0.00');
INSERT INTO `mx_balance` VALUES ('515', 'Ram1', '0.00');
INSERT INTO `mx_balance` VALUES ('516', 'Man1', '0.00');
INSERT INTO `mx_balance` VALUES ('517', 'Golden1', '0.00');
INSERT INTO `mx_balance` VALUES ('518', 'Golden2', '0.00');
INSERT INTO `mx_balance` VALUES ('519', 'Manish10', '0.00');
INSERT INTO `mx_balance` VALUES ('520', 'Auv', '0.00');
INSERT INTO `mx_balance` VALUES ('521', 'aka100', '0.00');
INSERT INTO `mx_balance` VALUES ('522', 'AD01', '0.00');
INSERT INTO `mx_balance` VALUES ('523', 'AD02', '0.00');
INSERT INTO `mx_balance` VALUES ('524', 'Bari', '0.00');
INSERT INTO `mx_balance` VALUES ('525', 'MS001', '0.00');
INSERT INTO `mx_balance` VALUES ('526', 'zade1', '0.00');
INSERT INTO `mx_balance` VALUES ('527', 'Gz1', '0.00');
INSERT INTO `mx_balance` VALUES ('528', 'G2', '0.00');
INSERT INTO `mx_balance` VALUES ('529', 'Ro.B1', '0.00');
INSERT INTO `mx_balance` VALUES ('530', 'RoAMT1', '0.00');
INSERT INTO `mx_balance` VALUES ('531', 'RoAMT2', '0.00');
INSERT INTO `mx_balance` VALUES ('532', 'rp1', '0.00');
INSERT INTO `mx_balance` VALUES ('533', 'Sopnil1', '0.00');
INSERT INTO `mx_balance` VALUES ('534', 'Roamt3', '0.00');
INSERT INTO `mx_balance` VALUES ('535', 'Sopnil2', '0.00');
INSERT INTO `mx_balance` VALUES ('536', 'App1', '0.00');
INSERT INTO `mx_balance` VALUES ('537', 'shri', '0.00');
INSERT INTO `mx_balance` VALUES ('538', 'shri12', '0.00');
INSERT INTO `mx_balance` VALUES ('539', 'new12', '0.00');
INSERT INTO `mx_balance` VALUES ('540', 'mamt1', '0.00');
INSERT INTO `mx_balance` VALUES ('541', 'mamt2', '0.00');
INSERT INTO `mx_balance` VALUES ('542', 'Dev1', '0.00');
INSERT INTO `mx_balance` VALUES ('543', 'Dev2', '0.00');
INSERT INTO `mx_balance` VALUES ('544', 'Sc1', '0.00');
INSERT INTO `mx_balance` VALUES ('545', 'At1', '0.00');
INSERT INTO `mx_balance` VALUES ('546', 'nitin', '0.00');
INSERT INTO `mx_balance` VALUES ('547', 'nitinret', '0.00');
INSERT INTO `mx_balance` VALUES ('548', 'a', '0.00');
INSERT INTO `mx_balance` VALUES ('549', 'lk', '0.00');
INSERT INTO `mx_balance` VALUES ('550', 'ret1', '1690.00');
INSERT INTO `mx_balance` VALUES ('551', 'ret1', '1680.00');
INSERT INTO `mx_balance` VALUES ('552', 'ret1', '1630.00');
INSERT INTO `mx_balance` VALUES ('553', 'ret1', '1600.00');
INSERT INTO `mx_balance` VALUES ('554', 'ret1', '1570.00');
INSERT INTO `mx_balance` VALUES ('555', 'ret1', '1560.00');
INSERT INTO `mx_balance` VALUES ('556', 'ret1', '1550.00');
INSERT INTO `mx_balance` VALUES ('557', 'ret1', '1540.00');
INSERT INTO `mx_balance` VALUES ('558', 'ret1', '1530.00');
INSERT INTO `mx_balance` VALUES ('559', 'ret1', '1520.00');
INSERT INTO `mx_balance` VALUES ('560', 'ret1', '1510.00');
INSERT INTO `mx_balance` VALUES ('561', 'ret1', '1500.00');
INSERT INTO `mx_balance` VALUES ('562', 'ret1', '1490.00');
INSERT INTO `mx_balance` VALUES ('563', 'ret1', '1480.00');
INSERT INTO `mx_balance` VALUES ('564', 'ret1', '1470.00');
INSERT INTO `mx_balance` VALUES ('565', 'ret1', '1430.00');
INSERT INTO `mx_balance` VALUES ('566', 'ret1', '1390.00');
INSERT INTO `mx_balance` VALUES ('567', 'ret1', '1290.00');
INSERT INTO `mx_balance` VALUES ('568', 'ret1', '1090.00');
INSERT INTO `mx_balance` VALUES ('569', 'ret1', '990.00');
INSERT INTO `mx_balance` VALUES ('570', 'ret1', '890.00');
INSERT INTO `mx_balance` VALUES ('571', 'ret1', '880.00');
INSERT INTO `mx_balance` VALUES ('572', 'ret1', '850.00');
INSERT INTO `mx_balance` VALUES ('573', 'ret1', '830.00');
INSERT INTO `mx_balance` VALUES ('574', 'ret1', '810.00');
INSERT INTO `mx_balance` VALUES ('575', 'ret1', '790.00');
INSERT INTO `mx_balance` VALUES ('576', 'ret1', '780.00');
INSERT INTO `mx_balance` VALUES ('577', 'ret1', '730.00');
INSERT INTO `mx_balance` VALUES ('578', 'ret1', '680.00');
INSERT INTO `mx_balance` VALUES ('579', 'ret1', '630.00');
INSERT INTO `mx_balance` VALUES ('580', 'ret1', '580.00');
INSERT INTO `mx_balance` VALUES ('581', 'ret1', '570.00');
INSERT INTO `mx_balance` VALUES ('582', 'ret1', '560.00');
INSERT INTO `mx_balance` VALUES ('583', 'ret1', '550.00');
INSERT INTO `mx_balance` VALUES ('584', 'ret1', '510.00');
INSERT INTO `mx_balance` VALUES ('585', 'ret1', '490.00');
INSERT INTO `mx_balance` VALUES ('586', 'ret1', '480.00');
INSERT INTO `mx_balance` VALUES ('587', 'ret1', '470.00');
INSERT INTO `mx_balance` VALUES ('588', 'ret1', '460.00');
INSERT INTO `mx_balance` VALUES ('589', 'ret1', '450.00');
INSERT INTO `mx_balance` VALUES ('590', 'ret1', '440.00');
INSERT INTO `mx_balance` VALUES ('591', 'ret1', '430.00');
INSERT INTO `mx_balance` VALUES ('592', 'ret1', '420.00');
INSERT INTO `mx_balance` VALUES ('593', 'ret1', '410.00');
INSERT INTO `mx_balance` VALUES ('594', 'ret1', '310.00');
INSERT INTO `mx_balance` VALUES ('595', 'ret1', '300.00');
INSERT INTO `mx_balance` VALUES ('596', 'ret1', '290.00');
INSERT INTO `mx_balance` VALUES ('597', 'ret1', '280.00');
INSERT INTO `mx_balance` VALUES ('598', 'ret1', '270.00');
INSERT INTO `mx_balance` VALUES ('599', 'ret1', '260.00');
INSERT INTO `mx_balance` VALUES ('600', 'ret1', '230.00');
INSERT INTO `mx_balance` VALUES ('601', 'ret1', '220.00');
INSERT INTO `mx_balance` VALUES ('602', 'ret1', '210.00');
INSERT INTO `mx_balance` VALUES ('603', 'ret1', '190.00');
INSERT INTO `mx_balance` VALUES ('604', 'ret1', '180.00');
INSERT INTO `mx_balance` VALUES ('605', 'ret1', '170.00');
INSERT INTO `mx_balance` VALUES ('606', 'ret1', '140.00');
INSERT INTO `mx_balance` VALUES ('607', 'ret1', '130.00');
INSERT INTO `mx_balance` VALUES ('608', 'ret1', '120.00');
INSERT INTO `mx_balance` VALUES ('609', 'ret1', '110.00');
INSERT INTO `mx_balance` VALUES ('610', 'ret1', '100.00');
INSERT INTO `mx_balance` VALUES ('611', 'ret1', '90.00');
INSERT INTO `mx_balance` VALUES ('612', 'ret1', '80.00');
INSERT INTO `mx_balance` VALUES ('613', 'ret1', '70.00');
INSERT INTO `mx_balance` VALUES ('614', 'ret1', '60.00');
INSERT INTO `mx_balance` VALUES ('615', 'ret1', '40.00');
INSERT INTO `mx_balance` VALUES ('616', 'ret1', '10000.00');
INSERT INTO `mx_balance` VALUES ('617', 'ret1', '9950.00');
INSERT INTO `mx_balance` VALUES ('618', 'ret1', '9930.00');
INSERT INTO `mx_balance` VALUES ('619', 'ret1', '9920.00');
INSERT INTO `mx_balance` VALUES ('620', 'ret1', '9870.00');
INSERT INTO `mx_balance` VALUES ('621', 'ret1', '9860.00');
INSERT INTO `mx_balance` VALUES ('622', 'ret1', '9810.00');
INSERT INTO `mx_balance` VALUES ('623', 'ret1', '9800.00');
INSERT INTO `mx_balance` VALUES ('624', 'ret1', '9790.00');
INSERT INTO `mx_balance` VALUES ('625', 'ret1', '9780.00');
INSERT INTO `mx_balance` VALUES ('626', 'ret1', '9770.00');
INSERT INTO `mx_balance` VALUES ('627', 'ret1', '9720.00');
INSERT INTO `mx_balance` VALUES ('628', 'ret1', '9700.00');
INSERT INTO `mx_balance` VALUES ('629', 'ret1', '9690.00');
INSERT INTO `mx_balance` VALUES ('630', 'ret1', '9630.00');
INSERT INTO `mx_balance` VALUES ('631', 'ret1', '9570.00');
INSERT INTO `mx_balance` VALUES ('632', 'ret1', '9510.00');
INSERT INTO `mx_balance` VALUES ('633', 'ret1', '9450.00');
INSERT INTO `mx_balance` VALUES ('634', 'ret1', '9390.00');
INSERT INTO `mx_balance` VALUES ('635', 'ret1', '9330.00');
INSERT INTO `mx_balance` VALUES ('636', 'ret1', '9270.00');
INSERT INTO `mx_balance` VALUES ('637', 'ret1', '9220.00');
INSERT INTO `mx_balance` VALUES ('638', 'ret1', '9200.00');
INSERT INTO `mx_balance` VALUES ('639', 'ret1', '9180.00');
INSERT INTO `mx_balance` VALUES ('640', 'ret1', '9160.00');
INSERT INTO `mx_balance` VALUES ('641', 'ret1', '9140.00');
INSERT INTO `mx_balance` VALUES ('642', 'ret1', '9120.00');
INSERT INTO `mx_balance` VALUES ('643', 'ret1', '9100.00');
INSERT INTO `mx_balance` VALUES ('644', 'ret1', '9040.00');
INSERT INTO `mx_balance` VALUES ('645', 'ret1', '8980.00');
INSERT INTO `mx_balance` VALUES ('646', 'ret1', '8920.00');
INSERT INTO `mx_balance` VALUES ('647', 'ret1', '8860.00');
INSERT INTO `mx_balance` VALUES ('648', 'ret1', '8800.00');
INSERT INTO `mx_balance` VALUES ('649', 'ret1', '8740.00');
INSERT INTO `mx_balance` VALUES ('650', 'ret1', '8690.00');
INSERT INTO `mx_balance` VALUES ('651', 'ret1', '8640.00');
INSERT INTO `mx_balance` VALUES ('652', 'ret1', '8540.00');
INSERT INTO `mx_balance` VALUES ('653', 'ret1', '8440.00');
INSERT INTO `mx_balance` VALUES ('654', 'ret1', '8380.00');
INSERT INTO `mx_balance` VALUES ('655', 'ret1', '8330.00');
INSERT INTO `mx_balance` VALUES ('656', 'ret1', '8280.00');
INSERT INTO `mx_balance` VALUES ('657', 'ret1', '8230.00');
INSERT INTO `mx_balance` VALUES ('658', 'ret1', '8180.00');
INSERT INTO `mx_balance` VALUES ('659', 'ret1', '8130.00');
INSERT INTO `mx_balance` VALUES ('660', 'ret1', '8080.00');
INSERT INTO `mx_balance` VALUES ('661', 'ret1', '8030.00');
INSERT INTO `mx_balance` VALUES ('662', 'ret1', '7980.00');
INSERT INTO `mx_balance` VALUES ('663', 'ret1', '7920.00');
INSERT INTO `mx_balance` VALUES ('664', 'ret1', '7860.00');
INSERT INTO `mx_balance` VALUES ('665', 'ret1', '7810.00');
INSERT INTO `mx_balance` VALUES ('666', 'ret1', '7760.00');
INSERT INTO `mx_balance` VALUES ('667', 'ret1', '7710.00');
INSERT INTO `mx_balance` VALUES ('668', 'ret1', '7660.00');
INSERT INTO `mx_balance` VALUES ('669', 'ret1', '8560.00');
INSERT INTO `mx_balance` VALUES ('670', 'ret1', '8650.00');
INSERT INTO `mx_balance` VALUES ('671', 'ret1', '8590.00');
INSERT INTO `mx_balance` VALUES ('672', 'ret1', '8530.00');
INSERT INTO `mx_balance` VALUES ('673', 'ret1', '9530.00');
INSERT INTO `mx_balance` VALUES ('674', 'ret1', '9630.00');
INSERT INTO `mx_balance` VALUES ('675', 'ret1', '9580.00');
INSERT INTO `mx_balance` VALUES ('676', 'ret1', '9530.00');
INSERT INTO `mx_balance` VALUES ('677', 'ret1', '9520.00');
INSERT INTO `mx_balance` VALUES ('678', 'ret1', '9460.00');
INSERT INTO `mx_balance` VALUES ('679', 'ret1', '9430.00');
INSERT INTO `mx_balance` VALUES ('680', 'ret1', '9380.00');
INSERT INTO `mx_balance` VALUES ('681', 'ret1', '9320.00');
INSERT INTO `mx_balance` VALUES ('682', 'ret1', '9270.00');
INSERT INTO `mx_balance` VALUES ('683', 'ret1', '9220.00');
INSERT INTO `mx_balance` VALUES ('684', 'ret1', '9160.00');
INSERT INTO `mx_balance` VALUES ('685', 'ret1', '9100.00');
INSERT INTO `mx_balance` VALUES ('686', 'ret1', '9050.00');
INSERT INTO `mx_balance` VALUES ('687', 'ret1', '9020.00');
INSERT INTO `mx_balance` VALUES ('688', 'ret1', '8990.00');
INSERT INTO `mx_balance` VALUES ('689', 'ret1', '8960.00');
INSERT INTO `mx_balance` VALUES ('690', 'ret1', '8910.00');
INSERT INTO `mx_balance` VALUES ('691', 'ret1', '8860.00');
INSERT INTO `mx_balance` VALUES ('692', 'ret1', '8810.00');
INSERT INTO `mx_balance` VALUES ('693', 'ret1', '8760.00');
INSERT INTO `mx_balance` VALUES ('694', 'ret1', '8710.00');
INSERT INTO `mx_balance` VALUES ('695', 'ret1', '8660.00');
INSERT INTO `mx_balance` VALUES ('696', 'ret1', '8610.00');
INSERT INTO `mx_balance` VALUES ('697', 'ret1', '8560.00');
INSERT INTO `mx_balance` VALUES ('698', 'ret1', '8510.00');
INSERT INTO `mx_balance` VALUES ('699', 'ret1', '8460.00');
INSERT INTO `mx_balance` VALUES ('700', 'ret1', '8410.00');
INSERT INTO `mx_balance` VALUES ('701', 'ret1', '8360.00');
INSERT INTO `mx_balance` VALUES ('702', 'ret1', '8310.00');
INSERT INTO `mx_balance` VALUES ('703', 'ret1', '8260.00');
INSERT INTO `mx_balance` VALUES ('704', 'ret1', '8210.00');
INSERT INTO `mx_balance` VALUES ('705', 'ret1', '8160.00');
INSERT INTO `mx_balance` VALUES ('706', 'ret1', '8110.00');
INSERT INTO `mx_balance` VALUES ('707', 'ret1', '8060.00');
INSERT INTO `mx_balance` VALUES ('708', 'ret1', '8010.00');
INSERT INTO `mx_balance` VALUES ('709', 'ret1', '7980.00');
INSERT INTO `mx_balance` VALUES ('710', 'ret1', '7950.00');
INSERT INTO `mx_balance` VALUES ('711', 'ret1', '7920.00');
INSERT INTO `mx_balance` VALUES ('712', 'ret1', '7890.00');
INSERT INTO `mx_balance` VALUES ('713', 'ret1', '7840.00');
INSERT INTO `mx_balance` VALUES ('714', 'ret1', '7780.00');
INSERT INTO `mx_balance` VALUES ('715', 'ret1', '7730.00');
INSERT INTO `mx_balance` VALUES ('716', 'ret1', '7670.00');
INSERT INTO `mx_balance` VALUES ('717', 'ret1', '7660.00');
INSERT INTO `mx_balance` VALUES ('718', 'sn701', '10000.00');
INSERT INTO `mx_balance` VALUES ('719', 'sn702', '10000.00');
INSERT INTO `mx_balance` VALUES ('720', 'sn701', '9950.00');
INSERT INTO `mx_balance` VALUES ('721', 'sn702', '9990.00');
INSERT INTO `mx_balance` VALUES ('722', 'sn702', '9970.00');
INSERT INTO `mx_balance` VALUES ('723', 'sn702', '9960.00');
INSERT INTO `mx_balance` VALUES ('724', 'sn702', '9950.00');
INSERT INTO `mx_balance` VALUES ('725', 'sn702', '9940.00');
INSERT INTO `mx_balance` VALUES ('726', 'sn702', '9930.00');
INSERT INTO `mx_balance` VALUES ('727', 'sn702', '9920.00');
INSERT INTO `mx_balance` VALUES ('728', 'sn702', '9910.00');
INSERT INTO `mx_balance` VALUES ('729', 'sn701', '9940.00');
INSERT INTO `mx_balance` VALUES ('730', 'sn701', '9930.00');
INSERT INTO `mx_balance` VALUES ('731', 'sn701', '9920.00');
INSERT INTO `mx_balance` VALUES ('732', 'sn701', '9910.00');
INSERT INTO `mx_balance` VALUES ('733', 'sn701', '9900.00');
INSERT INTO `mx_balance` VALUES ('734', 'sn702', '9900.00');
INSERT INTO `mx_balance` VALUES ('735', 'sn702', '9890.00');
INSERT INTO `mx_balance` VALUES ('736', 'sn701', '9850.00');
INSERT INTO `mx_balance` VALUES ('737', 'sn701', '9780.00');
INSERT INTO `mx_balance` VALUES ('738', 'sn701', '9750.00');
INSERT INTO `mx_balance` VALUES ('739', 'sn701', '9630.00');
INSERT INTO `mx_balance` VALUES ('740', 'sn701', '9600.00');
INSERT INTO `mx_balance` VALUES ('741', 'sn702', '9880.00');
INSERT INTO `mx_balance` VALUES ('742', 'sn702', '9870.00');
INSERT INTO `mx_balance` VALUES ('743', 'sn702', '9820.00');
INSERT INTO `mx_balance` VALUES ('744', 'sn701', '9550.00');
INSERT INTO `mx_balance` VALUES ('745', 'sn701', '9500.00');
INSERT INTO `mx_balance` VALUES ('746', 'sn701', '9490.00');
INSERT INTO `mx_balance` VALUES ('747', 'sn702', '9810.00');
INSERT INTO `mx_balance` VALUES ('748', 'sn702', '9760.00');
INSERT INTO `mx_balance` VALUES ('749', 'sn701', '9440.00');
INSERT INTO `mx_balance` VALUES ('750', 'sn701', '9390.00');
INSERT INTO `mx_balance` VALUES ('751', 'sn701', '9380.00');
INSERT INTO `mx_balance` VALUES ('752', 'sn701', '9280.00');
INSERT INTO `mx_balance` VALUES ('753', 'sn701', '9260.00');
INSERT INTO `mx_balance` VALUES ('754', 'sn701', '9360.00');
INSERT INTO `mx_balance` VALUES ('755', 'sn701', '9460.00');
INSERT INTO `mx_balance` VALUES ('756', 'sn701', '9560.00');
INSERT INTO `mx_balance` VALUES ('757', 'sn701', '9460.00');
INSERT INTO `mx_balance` VALUES ('758', 'sn701', '9340.00');
INSERT INTO `mx_balance` VALUES ('759', 'sn702', '9750.00');
INSERT INTO `mx_balance` VALUES ('760', 'sn701', '9290.00');
INSERT INTO `mx_balance` VALUES ('761', 'sn701', '9490.00');
INSERT INTO `mx_balance` VALUES ('762', 'sn701', '9690.00');
INSERT INTO `mx_balance` VALUES ('763', 'sn701', '9890.00');
INSERT INTO `mx_balance` VALUES ('764', 'sn701', '10090.00');
INSERT INTO `mx_balance` VALUES ('765', 'sn701', '10290.00');
INSERT INTO `mx_balance` VALUES ('766', 'sn701', '10490.00');
INSERT INTO `mx_balance` VALUES ('767', 'sn701', '10690.00');
INSERT INTO `mx_balance` VALUES ('768', 'sn701', '10890.00');
INSERT INTO `mx_balance` VALUES ('769', 'sn701', '10870.00');
INSERT INTO `mx_balance` VALUES ('770', 'sn701', '10860.00');
INSERT INTO `mx_balance` VALUES ('771', 'sn701', '10850.00');
INSERT INTO `mx_balance` VALUES ('772', 'ret1', '7610.00');
INSERT INTO `mx_balance` VALUES ('773', 'sn701', '11050.00');
INSERT INTO `mx_balance` VALUES ('774', 'ret1', '7560.00');
INSERT INTO `mx_balance` VALUES ('775', 'sn702', '9730.00');
INSERT INTO `mx_balance` VALUES ('776', 'sn702', '9690.00');
INSERT INTO `mx_balance` VALUES ('777', 'sn702', '9670.00');
INSERT INTO `mx_balance` VALUES ('778', 'sn702', '9650.00');
INSERT INTO `mx_balance` VALUES ('779', 'ret1', '7510.00');
INSERT INTO `mx_balance` VALUES ('780', 'ret1', '7450.00');
INSERT INTO `mx_balance` VALUES ('781', 'sn701', '11040.00');
INSERT INTO `mx_balance` VALUES ('782', 'sn701', '10990.00');
INSERT INTO `mx_balance` VALUES ('783', 'sn701', '10960.00');
INSERT INTO `mx_balance` VALUES ('784', 'sn701', '10940.00');
INSERT INTO `mx_balance` VALUES ('785', 'sn701', '11030.00');
INSERT INTO `mx_balance` VALUES ('786', 'sn701', '10990.00');
INSERT INTO `mx_balance` VALUES ('787', 'sn701', '10960.00');
INSERT INTO `mx_balance` VALUES ('788', 'sn701', '10930.00');
INSERT INTO `mx_balance` VALUES ('789', 'sn701', '10890.00');
INSERT INTO `mx_balance` VALUES ('790', 'sn701', '10850.00');
INSERT INTO `mx_balance` VALUES ('791', 'sn701', '10810.00');
INSERT INTO `mx_balance` VALUES ('792', 'sn701', '10900.00');
INSERT INTO `mx_balance` VALUES ('793', 'sn701', '10850.00');
INSERT INTO `mx_balance` VALUES ('794', 'sn701', '10800.00');
INSERT INTO `mx_balance` VALUES ('795', 'sn701', '10740.00');
INSERT INTO `mx_balance` VALUES ('796', 'sn701', '10680.00');
INSERT INTO `mx_balance` VALUES ('797', 'sn701', '10770.00');
INSERT INTO `mx_balance` VALUES ('798', 'sn701', '10870.00');
INSERT INTO `mx_balance` VALUES ('799', 'sn701', '10820.00');
INSERT INTO `mx_balance` VALUES ('800', 'sn701', '10770.00');
INSERT INTO `mx_balance` VALUES ('801', 'sn701', '10860.00');
INSERT INTO `mx_balance` VALUES ('802', 'sn701', '10840.00');
INSERT INTO `mx_balance` VALUES ('803', 'sn701', '10830.00');
INSERT INTO `mx_balance` VALUES ('804', 'sn701', '10810.00');
INSERT INTO `mx_balance` VALUES ('805', 'sn701', '10760.00');
INSERT INTO `mx_balance` VALUES ('806', 'sn701', '10690.00');
INSERT INTO `mx_balance` VALUES ('807', 'sn701', '10590.00');
INSERT INTO `mx_balance` VALUES ('808', 'sn701', '10540.00');
INSERT INTO `mx_balance` VALUES ('809', 'sn701', '10380.00');
INSERT INTO `mx_balance` VALUES ('810', 'sn701', '10370.00');
INSERT INTO `mx_balance` VALUES ('811', 'sn701', '10170.00');
INSERT INTO `mx_balance` VALUES ('812', 'sn701', '10160.00');
INSERT INTO `mx_balance` VALUES ('813', 'sn701', '10150.00');
INSERT INTO `mx_balance` VALUES ('814', 'sn701', '10140.00');
INSERT INTO `mx_balance` VALUES ('815', 'sn701', '10120.00');
INSERT INTO `mx_balance` VALUES ('816', 'sn701', '9920.00');
INSERT INTO `mx_balance` VALUES ('817', 'sn701', '9910.00');
INSERT INTO `mx_balance` VALUES ('818', 'sn701', '9900.00');
INSERT INTO `mx_balance` VALUES ('819', 'sn701', '9890.00');
INSERT INTO `mx_balance` VALUES ('820', 'sn701', '9870.00');
INSERT INTO `mx_balance` VALUES ('821', 'sn701', '9570.00');
INSERT INTO `mx_balance` VALUES ('822', 'sn701', '9270.00');
INSERT INTO `mx_balance` VALUES ('823', 'sn701', '9260.00');
INSERT INTO `mx_balance` VALUES ('824', 'sn701', '9250.00');
INSERT INTO `mx_balance` VALUES ('825', 'sn701', '9230.00');
INSERT INTO `mx_balance` VALUES ('826', 'sn701', '9180.00');
INSERT INTO `mx_balance` VALUES ('827', 'sn701', '9160.00');
INSERT INTO `mx_balance` VALUES ('828', 'sn701', '8960.00');
INSERT INTO `mx_balance` VALUES ('829', 'sn701', '8910.00');
INSERT INTO `mx_balance` VALUES ('830', 'sn701', '8890.00');
INSERT INTO `mx_balance` VALUES ('831', 'sn701', '8870.00');
INSERT INTO `mx_balance` VALUES ('832', 'sn701', '8850.00');
INSERT INTO `mx_balance` VALUES ('833', 'sn701', '8400.00');
INSERT INTO `mx_balance` VALUES ('834', 'sn701', '8390.00');
INSERT INTO `mx_balance` VALUES ('835', 'sn701', '8340.00');
INSERT INTO `mx_balance` VALUES ('836', 'sn701', '8330.00');
INSERT INTO `mx_balance` VALUES ('837', 'sn701', '8310.00');
INSERT INTO `mx_balance` VALUES ('838', 'sn701', '8290.00');
INSERT INTO `mx_balance` VALUES ('839', 'sn701', '8390.00');
INSERT INTO `mx_balance` VALUES ('840', 'sn701', '8490.00');
INSERT INTO `mx_balance` VALUES ('841', 'sn701', '8590.00');
INSERT INTO `mx_balance` VALUES ('842', 'sn701', '8690.00');
INSERT INTO `mx_balance` VALUES ('843', 'sn701', '8790.00');
INSERT INTO `mx_balance` VALUES ('844', 'sn701', '8890.00');
INSERT INTO `mx_balance` VALUES ('845', 'sn701', '8840.00');
INSERT INTO `mx_balance` VALUES ('846', 'sn701', '8830.00');
INSERT INTO `mx_balance` VALUES ('847', 'sn701', '8430.00');
INSERT INTO `mx_balance` VALUES ('848', 'sn701', '8390.00');
INSERT INTO `mx_balance` VALUES ('849', 'sn701', '7990.00');
INSERT INTO `mx_balance` VALUES ('850', 'sn701', '7690.00');
INSERT INTO `mx_balance` VALUES ('851', 'sn701', '7780.00');
INSERT INTO `mx_balance` VALUES ('852', 'sn701', '7180.00');
INSERT INTO `mx_balance` VALUES ('853', 'sn701', '7170.00');
INSERT INTO `mx_balance` VALUES ('854', 'sn701', '7160.00');
INSERT INTO `mx_balance` VALUES ('855', 'sn701', '7140.00');
INSERT INTO `mx_balance` VALUES ('856', 'sn701', '7120.00');
INSERT INTO `mx_balance` VALUES ('857', 'sn701', '7100.00');
INSERT INTO `mx_balance` VALUES ('858', 'sn701', '6950.00');
INSERT INTO `mx_balance` VALUES ('859', 'sn701', '6890.00');
INSERT INTO `mx_balance` VALUES ('860', 'sn701', '6740.00');
INSERT INTO `mx_balance` VALUES ('861', 'sn701', '6590.00');
INSERT INTO `mx_balance` VALUES ('862', 'sn701', '6520.00');
INSERT INTO `mx_balance` VALUES ('863', 'sn701', '6470.00');
INSERT INTO `mx_balance` VALUES ('864', 'sn701', '6420.00');
INSERT INTO `mx_balance` VALUES ('865', 'sn701', '6320.00');
INSERT INTO `mx_balance` VALUES ('866', 'sn701', '6300.00');
INSERT INTO `mx_balance` VALUES ('867', 'sn701', '6180.00');
INSERT INTO `mx_balance` VALUES ('868', 'sn701', '6170.00');
INSERT INTO `mx_balance` VALUES ('869', 'sn701', '6120.00');
INSERT INTO `mx_balance` VALUES ('870', 'sn701', '6070.00');
INSERT INTO `mx_balance` VALUES ('871', 'sn701', '6160.00');
INSERT INTO `mx_balance` VALUES ('872', 'sn701', '6100.00');
INSERT INTO `mx_balance` VALUES ('873', 'sn701', '6060.00');
INSERT INTO `mx_balance` VALUES ('874', 'sn701', '6020.00');
INSERT INTO `mx_balance` VALUES ('875', 'sn701', '5980.00');
INSERT INTO `mx_balance` VALUES ('876', 'sn701', '5970.00');
INSERT INTO `mx_balance` VALUES ('877', 'sn701', '5960.00');
INSERT INTO `mx_balance` VALUES ('878', 'sn701', '5940.00');
INSERT INTO `mx_balance` VALUES ('879', 'sn701', '5890.00');
INSERT INTO `mx_balance` VALUES ('880', 'sn701', '5790.00');
INSERT INTO `mx_balance` VALUES ('881', 'sn701', '5780.00');
INSERT INTO `mx_balance` VALUES ('882', 'sn701', '5740.00');
INSERT INTO `mx_balance` VALUES ('883', 'sn701', '5720.00');
INSERT INTO `mx_balance` VALUES ('884', 'sn701', '5660.00');
INSERT INTO `mx_balance` VALUES ('885', 'sn701', '5630.00');
INSERT INTO `mx_balance` VALUES ('886', 'sn701', '5580.00');
INSERT INTO `mx_balance` VALUES ('887', 'sn701', '5480.00');
INSERT INTO `mx_balance` VALUES ('888', 'sn701', '5440.00');
INSERT INTO `mx_balance` VALUES ('889', 'sn701', '5390.00');
INSERT INTO `mx_balance` VALUES ('890', 'sn701', '5330.00');
INSERT INTO `mx_balance` VALUES ('891', 'sn701', '5280.00');
INSERT INTO `mx_balance` VALUES ('892', 'sn701', '5240.00');
INSERT INTO `mx_balance` VALUES ('893', 'sn701', '5190.00');
INSERT INTO `mx_balance` VALUES ('894', 'sn701', '5150.00');
INSERT INTO `mx_balance` VALUES ('895', 'sn701', '5140.00');
INSERT INTO `mx_balance` VALUES ('896', 'sn701', '5100.00');
INSERT INTO `mx_balance` VALUES ('897', 'sn701', '5060.00');
INSERT INTO `mx_balance` VALUES ('898', 'sn701', '5160.00');
INSERT INTO `mx_balance` VALUES ('899', 'sn701', '5110.00');
INSERT INTO `mx_balance` VALUES ('900', 'sn701', '5060.00');
INSERT INTO `mx_balance` VALUES ('901', 'sn701', '5020.00');
INSERT INTO `mx_balance` VALUES ('902', 'sn701', '4980.00');
INSERT INTO `mx_balance` VALUES ('903', 'sn701', '4970.00');
INSERT INTO `mx_balance` VALUES ('904', 'sn701', '4920.00');
INSERT INTO `mx_balance` VALUES ('905', 'sn701', '4880.00');
INSERT INTO `mx_balance` VALUES ('906', 'sn701', '4870.00');
INSERT INTO `mx_balance` VALUES ('907', 'sn701', '4840.00');
INSERT INTO `mx_balance` VALUES ('908', 'sn701', '4770.00');
INSERT INTO `mx_balance` VALUES ('909', 'sn701', '4730.00');
INSERT INTO `mx_balance` VALUES ('910', 'sn701', '4710.00');
INSERT INTO `mx_balance` VALUES ('911', 'sn701', '4800.00');
INSERT INTO `mx_balance` VALUES ('912', 'sn701', '4750.00');
INSERT INTO `mx_balance` VALUES ('913', 'sn701', '4700.00');
INSERT INTO `mx_balance` VALUES ('914', 'sn701', '4670.00');
INSERT INTO `mx_balance` VALUES ('915', 'sn701', '4640.00');
INSERT INTO `mx_balance` VALUES ('916', 'sn701', '4590.00');
INSERT INTO `mx_balance` VALUES ('917', 'sn701', '4540.00');
INSERT INTO `mx_balance` VALUES ('918', 'sn701', '4480.00');
INSERT INTO `mx_balance` VALUES ('919', 'sn701', '4440.00');
INSERT INTO `mx_balance` VALUES ('920', 'sn701', '4400.00');
INSERT INTO `mx_balance` VALUES ('921', 'sn701', '4340.00');
INSERT INTO `mx_balance` VALUES ('922', 'sn701', '4310.00');
INSERT INTO `mx_balance` VALUES ('923', 'sn701', '4280.00');
INSERT INTO `mx_balance` VALUES ('924', 'sn701', '4260.00');
INSERT INTO `mx_balance` VALUES ('925', 'sn701', '4220.00');
INSERT INTO `mx_balance` VALUES ('926', 'sn701', '4200.00');
INSERT INTO `mx_balance` VALUES ('927', 'sn701', '4190.00');
INSERT INTO `mx_balance` VALUES ('928', 'sn701', '4170.00');
INSERT INTO `mx_balance` VALUES ('929', 'sn701', '4150.00');
INSERT INTO `mx_balance` VALUES ('930', 'sn701', '3950.00');
INSERT INTO `mx_balance` VALUES ('931', 'sn701', '3940.00');
INSERT INTO `mx_balance` VALUES ('932', 'sn701', '4340.00');
INSERT INTO `mx_balance` VALUES ('933', 'sn701', '4330.00');
INSERT INTO `mx_balance` VALUES ('934', 'sn701', '4170.00');
INSERT INTO `mx_balance` VALUES ('935', 'sn701', '4090.00');
INSERT INTO `mx_balance` VALUES ('936', 'sn701', '4030.00');
INSERT INTO `mx_balance` VALUES ('937', 'sn701', '4010.00');
INSERT INTO `mx_balance` VALUES ('938', 'sn701', '3970.00');
INSERT INTO `mx_balance` VALUES ('939', 'sn701', '3950.00');
INSERT INTO `mx_balance` VALUES ('940', 'sn701', '3940.00');
INSERT INTO `mx_balance` VALUES ('941', 'sn701', '3900.00');
INSERT INTO `mx_balance` VALUES ('942', 'sn701', '4000.00');
INSERT INTO `mx_balance` VALUES ('943', 'sn701', '3960.00');
INSERT INTO `mx_balance` VALUES ('944', 'sn701', '3950.00');
INSERT INTO `mx_balance` VALUES ('945', 'sn701', '3900.00');
INSERT INTO `mx_balance` VALUES ('946', 'sn701', '3860.00');
INSERT INTO `mx_balance` VALUES ('947', 'sn701', '3960.00');
INSERT INTO `mx_balance` VALUES ('948', 'sn701', '3920.00');
INSERT INTO `mx_balance` VALUES ('949', 'sn701', '3870.00');
INSERT INTO `mx_balance` VALUES ('950', 'sn701', '3830.00');
INSERT INTO `mx_balance` VALUES ('951', 'sn701', '3790.00');
INSERT INTO `mx_balance` VALUES ('952', 'sn701', '3780.00');
INSERT INTO `mx_balance` VALUES ('953', 'sn701', '3760.00');
INSERT INTO `mx_balance` VALUES ('954', 'sn701', '3860.00');
INSERT INTO `mx_balance` VALUES ('955', 'sn701', '3830.00');
INSERT INTO `mx_balance` VALUES ('956', 'sn701', '3780.00');
INSERT INTO `mx_balance` VALUES ('957', 'sn701', '3730.00');
INSERT INTO `mx_balance` VALUES ('958', 'sn701', '3630.00');
INSERT INTO `mx_balance` VALUES ('959', 'sn701', '3600.00');
INSERT INTO `mx_balance` VALUES ('960', 'sn701', '3590.00');
INSERT INTO `mx_balance` VALUES ('961', 'sn701', '3560.00');
INSERT INTO `mx_balance` VALUES ('962', 'sn701', '3480.00');
INSERT INTO `mx_balance` VALUES ('963', 'sn701', '3420.00');
INSERT INTO `mx_balance` VALUES ('964', 'sn701', '3360.00');
INSERT INTO `mx_balance` VALUES ('965', 'sn701', '3340.00');
INSERT INTO `mx_balance` VALUES ('966', 'sn701', '3330.00');
INSERT INTO `mx_balance` VALUES ('967', 'sn701', '3320.00');
INSERT INTO `mx_balance` VALUES ('968', 'sn701', '3310.00');
INSERT INTO `mx_balance` VALUES ('969', 'sn701', '3290.00');
INSERT INTO `mx_balance` VALUES ('970', 'sn701', '3270.00');
INSERT INTO `mx_balance` VALUES ('971', 'sn701', '3240.00');
INSERT INTO `mx_balance` VALUES ('972', 'sn701', '3220.00');
INSERT INTO `mx_balance` VALUES ('973', 'sn701', '3130.00');
INSERT INTO `mx_balance` VALUES ('974', 'sn701', '3120.00');
INSERT INTO `mx_balance` VALUES ('975', 'sn701', '3110.00');
INSERT INTO `mx_balance` VALUES ('976', 'sn701', '3010.00');
INSERT INTO `mx_balance` VALUES ('977', 'sn701', '2980.00');
INSERT INTO `mx_balance` VALUES ('978', 'sn701', '2960.00');
INSERT INTO `mx_balance` VALUES ('979', 'sn701', '2860.00');
INSERT INTO `mx_balance` VALUES ('980', 'sn701', '2830.00');
INSERT INTO `mx_balance` VALUES ('981', 'sn701', '2810.00');
INSERT INTO `mx_balance` VALUES ('982', 'sn701', '2790.00');
INSERT INTO `mx_balance` VALUES ('983', 'sn701', '2740.00');
INSERT INTO `mx_balance` VALUES ('984', 'sn701', '2720.00');
INSERT INTO `mx_balance` VALUES ('985', 'sn701', '2700.00');
INSERT INTO `mx_balance` VALUES ('986', 'sn701', '2680.00');
INSERT INTO `mx_balance` VALUES ('987', 'sn701', '2670.00');
INSERT INTO `mx_balance` VALUES ('988', 'sn701', '2650.00');
INSERT INTO `mx_balance` VALUES ('989', 'sn701', '2550.00');
INSERT INTO `mx_balance` VALUES ('990', 'sn701', '2520.00');
INSERT INTO `mx_balance` VALUES ('991', 'sn701', '2480.00');
INSERT INTO `mx_balance` VALUES ('992', 'sn701', '2470.00');
INSERT INTO `mx_balance` VALUES ('993', 'sn701', '2450.00');
INSERT INTO `mx_balance` VALUES ('994', 'sn701', '2440.00');
INSERT INTO `mx_balance` VALUES ('995', 'sn701', '2420.00');
INSERT INTO `mx_balance` VALUES ('996', 'sn701', '2370.00');
INSERT INTO `mx_balance` VALUES ('997', 'sn701', '2320.00');
INSERT INTO `mx_balance` VALUES ('998', 'sn701', '2820.00');
INSERT INTO `mx_balance` VALUES ('999', 'sn701', '3320.00');
INSERT INTO `mx_balance` VALUES ('1000', 'sn701', '3310.00');
INSERT INTO `mx_balance` VALUES ('1001', 'sn701', '3260.00');
INSERT INTO `mx_balance` VALUES ('1002', 'sn701', '3240.00');
INSERT INTO `mx_balance` VALUES ('1003', 'sn701', '3220.00');
INSERT INTO `mx_balance` VALUES ('1004', 'sn701', '3210.00');
INSERT INTO `mx_balance` VALUES ('1005', 'sn701', '3200.00');
INSERT INTO `mx_balance` VALUES ('1006', 'sn701', '3150.00');
INSERT INTO `mx_balance` VALUES ('1007', 'sn701', '3110.00');
INSERT INTO `mx_balance` VALUES ('1008', 'sn701', '3100.00');
INSERT INTO `mx_balance` VALUES ('1009', 'sn701', '3070.00');
INSERT INTO `mx_balance` VALUES ('1010', 'sn701', '2970.00');
INSERT INTO `mx_balance` VALUES ('1011', 'sn701', '3070.00');
INSERT INTO `mx_balance` VALUES ('1012', 'sn701', '3170.00');
INSERT INTO `mx_balance` VALUES ('1013', 'sn701', '3160.00');
INSERT INTO `mx_balance` VALUES ('1014', 'sn701', '3100.00');
INSERT INTO `mx_balance` VALUES ('1015', 'sn701', '3000.00');
INSERT INTO `mx_balance` VALUES ('1016', 'sn701', '2950.00');
INSERT INTO `mx_balance` VALUES ('1017', 'sn701', '2880.00');
INSERT INTO `mx_balance` VALUES ('1018', 'sn701', '2850.00');
INSERT INTO `mx_balance` VALUES ('1019', 'sn701', '2750.00');
INSERT INTO `mx_balance` VALUES ('1020', 'sn701', '2740.00');
INSERT INTO `mx_balance` VALUES ('1021', 'sn701', '2840.00');
INSERT INTO `mx_balance` VALUES ('1022', 'sn701', '3140.00');
INSERT INTO `mx_balance` VALUES ('1023', 'sn701', '3120.00');
INSERT INTO `mx_balance` VALUES ('1024', 'sn701', '3020.00');
INSERT INTO `mx_balance` VALUES ('1025', 'sn701', '2920.00');
INSERT INTO `mx_balance` VALUES ('1026', 'sn701', '2820.00');
INSERT INTO `mx_balance` VALUES ('1027', 'sn701', '2700.00');
INSERT INTO `mx_balance` VALUES ('1028', 'sn701', '2680.00');
INSERT INTO `mx_balance` VALUES ('1029', 'sn701', '2660.00');
INSERT INTO `mx_balance` VALUES ('1030', 'sn701', '2560.00');
INSERT INTO `mx_balance` VALUES ('1031', 'sn701', '2500.00');
INSERT INTO `mx_balance` VALUES ('1032', 'sn701', '2400.00');
INSERT INTO `mx_balance` VALUES ('1033', 'sn701', '2360.00');
INSERT INTO `mx_balance` VALUES ('1034', 'sn701', '2310.00');
INSERT INTO `mx_balance` VALUES ('1035', 'sn701', '2210.00');
INSERT INTO `mx_balance` VALUES ('1036', 'sn701', '2200.00');
INSERT INTO `mx_balance` VALUES ('1037', 'sn701', '2190.00');
INSERT INTO `mx_balance` VALUES ('1038', 'sn701', '2140.00');
INSERT INTO `mx_balance` VALUES ('1039', 'sn701', '2130.00');
INSERT INTO `mx_balance` VALUES ('1040', 'sn701', '2120.00');
INSERT INTO `mx_balance` VALUES ('1041', 'sn701', '2110.00');
INSERT INTO `mx_balance` VALUES ('1042', 'sn701', '2100.00');
INSERT INTO `mx_balance` VALUES ('1043', 'sn701', '2050.00');
INSERT INTO `mx_balance` VALUES ('1044', 'sn701', '2020.00');
INSERT INTO `mx_balance` VALUES ('1045', 'sn701', '2120.00');
INSERT INTO `mx_balance` VALUES ('1046', 'sn701', '2070.00');
INSERT INTO `mx_balance` VALUES ('1047', 'sn701', '2050.00');
INSERT INTO `mx_balance` VALUES ('1048', 'sn701', '2000.00');
INSERT INTO `mx_balance` VALUES ('1049', 'sn701', '1980.00');
INSERT INTO `mx_balance` VALUES ('1050', 'sn701', '1960.00');
INSERT INTO `mx_balance` VALUES ('1051', 'sn701', '1860.00');
INSERT INTO `mx_balance` VALUES ('1052', 'sn701', '1790.00');
INSERT INTO `mx_balance` VALUES ('1053', 'sn701', '1740.00');
INSERT INTO `mx_balance` VALUES ('1054', 'sn701', '1640.00');
INSERT INTO `mx_balance` VALUES ('1055', 'sn701', '1630.00');
INSERT INTO `mx_balance` VALUES ('1056', 'sn701', '1580.00');
INSERT INTO `mx_balance` VALUES ('1057', 'sn701', '1480.00');
INSERT INTO `mx_balance` VALUES ('1058', 'sn701', '1460.00');
INSERT INTO `mx_balance` VALUES ('1059', 'sn701', '1360.00');
INSERT INTO `mx_balance` VALUES ('1060', 'sn701', '1260.00');
INSERT INTO `mx_balance` VALUES ('1061', 'sn701', '1230.00');
INSERT INTO `mx_balance` VALUES ('1062', 'sn701', '1070.00');
INSERT INTO `mx_balance` VALUES ('1063', 'sn701', '1020.00');
INSERT INTO `mx_balance` VALUES ('1064', 'sn701', '1220.00');
INSERT INTO `mx_balance` VALUES ('1065', 'sn701', '1720.00');
INSERT INTO `mx_balance` VALUES ('1066', 'sn701', '1620.00');
INSERT INTO `mx_balance` VALUES ('1067', 'sn701', '1580.00');
INSERT INTO `mx_balance` VALUES ('1068', 'sn701', '1570.00');
INSERT INTO `mx_balance` VALUES ('1069', 'sn701', '1550.00');
INSERT INTO `mx_balance` VALUES ('1070', 'sn701', '1500.00');
INSERT INTO `mx_balance` VALUES ('1071', 'sn701', '1480.00');
INSERT INTO `mx_balance` VALUES ('1072', 'sn701', '1400.00');
INSERT INTO `mx_balance` VALUES ('1073', 'sn701', '1380.00');
INSERT INTO `mx_balance` VALUES ('1074', 'sn701', '1360.00');
INSERT INTO `mx_balance` VALUES ('1075', 'sn701', '1260.00');
INSERT INTO `mx_balance` VALUES ('1076', 'sn701', '1200.00');
INSERT INTO `mx_balance` VALUES ('1077', 'sn701', '1150.00');
INSERT INTO `mx_balance` VALUES ('1078', 'sn701', '1130.00');
INSERT INTO `mx_balance` VALUES ('1079', 'sn701', '1220.00');
INSERT INTO `mx_balance` VALUES ('1080', 'sn701', '1060.00');
INSERT INTO `mx_balance` VALUES ('1081', 'sn701', '960.00');
INSERT INTO `mx_balance` VALUES ('1082', 'sn701', '920.00');
INSERT INTO `mx_balance` VALUES ('1083', 'sn701', '820.00');
INSERT INTO `mx_balance` VALUES ('1084', 'sn701', '720.00');
INSERT INTO `mx_balance` VALUES ('1085', 'sn701', '640.00');
INSERT INTO `mx_balance` VALUES ('1086', 'sn701', '480.00');
INSERT INTO `mx_balance` VALUES ('1087', 'sn701', '980.00');
INSERT INTO `mx_balance` VALUES ('1088', 'sn701', '900.00');
INSERT INTO `mx_balance` VALUES ('1089', 'sn701', '800.00');
INSERT INTO `mx_balance` VALUES ('1090', 'sn701', '740.00');
INSERT INTO `mx_balance` VALUES ('1091', 'sn701', '710.00');
INSERT INTO `mx_balance` VALUES ('1092', 'sn701', '670.00');
INSERT INTO `mx_balance` VALUES ('1093', 'sn701', '640.00');
INSERT INTO `mx_balance` VALUES ('1094', 'sn701', '550.00');
INSERT INTO `mx_balance` VALUES ('1095', 'sn701', '520.00');
INSERT INTO `mx_balance` VALUES ('1096', 'sn701', '490.00');
INSERT INTO `mx_balance` VALUES ('1097', 'sn701', '450.00');
INSERT INTO `mx_balance` VALUES ('1098', 'sn701', '290.00');
INSERT INTO `mx_balance` VALUES ('1099', 'sn701', '270.00');
INSERT INTO `mx_balance` VALUES ('1100', 'sn701', '370.00');
INSERT INTO `mx_balance` VALUES ('1101', 'sn701', '330.00');
INSERT INTO `mx_balance` VALUES ('1102', 'sn701', '310.00');
INSERT INTO `mx_balance` VALUES ('1103', 'sn701', '110.00');
INSERT INTO `mx_balance` VALUES ('1104', 'sn701', '90.00');
INSERT INTO `mx_balance` VALUES ('1105', 'sn701', '10090.00');
INSERT INTO `mx_balance` VALUES ('1106', 'sn701', '10790.00');
INSERT INTO `mx_balance` VALUES ('1107', 'sn701', '10690.00');
INSERT INTO `mx_balance` VALUES ('1108', 'sn701', '10650.00');
INSERT INTO `mx_balance` VALUES ('1109', 'sn701', '10640.00');
INSERT INTO `mx_balance` VALUES ('1110', 'sn701', '10610.00');
INSERT INTO `mx_balance` VALUES ('1111', 'sn701', '10580.00');
INSERT INTO `mx_balance` VALUES ('1112', 'sn701', '10550.00');
INSERT INTO `mx_balance` VALUES ('1113', 'sn701', '10450.00');
INSERT INTO `mx_balance` VALUES ('1114', 'sn701', '10550.00');
INSERT INTO `mx_balance` VALUES ('1115', 'sn701', '10650.00');
INSERT INTO `mx_balance` VALUES ('1116', 'sn701', '10620.00');
INSERT INTO `mx_balance` VALUES ('1117', 'sn701', '10420.00');
INSERT INTO `mx_balance` VALUES ('1118', 'sn701', '10410.00');
INSERT INTO `mx_balance` VALUES ('1119', 'sn701', '10910.00');
INSERT INTO `mx_balance` VALUES ('1120', 'sn701', '10810.00');
INSERT INTO `mx_balance` VALUES ('1121', 'sn701', '10710.00');
INSERT INTO `mx_balance` VALUES ('1122', 'sn701', '10610.00');
INSERT INTO `mx_balance` VALUES ('1123', 'sn701', '10510.00');
INSERT INTO `mx_balance` VALUES ('1124', 'sn701', '10710.00');
INSERT INTO `mx_balance` VALUES ('1125', 'sn701', '10910.00');
INSERT INTO `mx_balance` VALUES ('1126', 'sn701', '10810.00');
INSERT INTO `mx_balance` VALUES ('1127', 'sn701', '10710.00');
INSERT INTO `mx_balance` VALUES ('1128', 'sn701', '10680.00');
INSERT INTO `mx_balance` VALUES ('1129', 'sn701', '10880.00');
INSERT INTO `mx_balance` VALUES ('1130', 'sn701', '10780.00');
INSERT INTO `mx_balance` VALUES ('1131', 'sn701', '10750.00');
INSERT INTO `mx_balance` VALUES ('1132', 'sn701', '10650.00');
INSERT INTO `mx_balance` VALUES ('1133', 'sn701', '10550.00');
INSERT INTO `mx_balance` VALUES ('1134', 'sn701', '10540.00');
INSERT INTO `mx_balance` VALUES ('1135', 'sn701', '10440.00');
INSERT INTO `mx_balance` VALUES ('1136', 'sn701', '10640.00');
INSERT INTO `mx_balance` VALUES ('1137', 'sn701', '10840.00');
INSERT INTO `mx_balance` VALUES ('1138', 'sn701', '11040.00');
INSERT INTO `mx_balance` VALUES ('1139', 'sn701', '10990.00');
INSERT INTO `mx_balance` VALUES ('1140', 'sn701', '10940.00');
INSERT INTO `mx_balance` VALUES ('1141', 'sn701', '10910.00');
INSERT INTO `mx_balance` VALUES ('1142', 'sn701', '10880.00');
INSERT INTO `mx_balance` VALUES ('1143', 'sn701', '10850.00');
INSERT INTO `mx_balance` VALUES ('1144', 'sn701', '10820.00');
INSERT INTO `mx_balance` VALUES ('1145', 'sn701', '10920.00');
INSERT INTO `mx_balance` VALUES ('1146', 'sn701', '10890.00');
INSERT INTO `mx_balance` VALUES ('1147', 'sn701', '10870.00');
INSERT INTO `mx_balance` VALUES ('1148', 'sn701', '10840.00');
INSERT INTO `mx_balance` VALUES ('1149', 'sn701', '10790.00');
INSERT INTO `mx_balance` VALUES ('1150', 'sn701', '10780.00');
INSERT INTO `mx_balance` VALUES ('1151', 'sn701', '10760.00');
INSERT INTO `mx_balance` VALUES ('1152', 'sn701', '10620.00');
INSERT INTO `mx_balance` VALUES ('1153', 'sn701', '10560.00');
INSERT INTO `mx_balance` VALUES ('1154', 'sn701', '10520.00');
INSERT INTO `mx_balance` VALUES ('1155', 'sn701', '10320.00');
INSERT INTO `mx_balance` VALUES ('1156', 'sn701', '10170.00');
INSERT INTO `mx_balance` VALUES ('1157', 'sn701', '9960.00');
INSERT INTO `mx_balance` VALUES ('1158', 'sn701', '9880.00');
INSERT INTO `mx_balance` VALUES ('1159', 'sn701', '9760.00');
INSERT INTO `mx_balance` VALUES ('1160', 'sn701', '9520.00');
INSERT INTO `mx_balance` VALUES ('1161', 'sn701', '9400.00');
INSERT INTO `mx_balance` VALUES ('1162', 'sn701', '9300.00');
INSERT INTO `mx_balance` VALUES ('1163', 'sn701', '9200.00');
INSERT INTO `mx_balance` VALUES ('1164', 'sn701', '9160.00');
INSERT INTO `mx_balance` VALUES ('1165', 'sn701', '9140.00');
INSERT INTO `mx_balance` VALUES ('1166', 'sn701', '8990.00');
INSERT INTO `mx_balance` VALUES ('1167', 'sn701', '8980.00');
INSERT INTO `mx_balance` VALUES ('1168', 'sn701', '8840.00');
INSERT INTO `mx_balance` VALUES ('1169', 'sn701', '8770.00');
INSERT INTO `mx_balance` VALUES ('1170', 'sn701', '8710.00');
INSERT INTO `mx_balance` VALUES ('1171', 'sn701', '8590.00');
INSERT INTO `mx_balance` VALUES ('1172', 'sn701', '8410.00');
INSERT INTO `mx_balance` VALUES ('1173', 'ret1', '7400.00');
INSERT INTO `mx_balance` VALUES ('1174', 'ret1', '7340.00');
INSERT INTO `mx_balance` VALUES ('1175', 'sn701', '8350.00');
INSERT INTO `mx_balance` VALUES ('1176', 'sn701', '8300.00');
INSERT INTO `mx_balance` VALUES ('1177', 'sn701', '8200.00');
INSERT INTO `mx_balance` VALUES ('1178', 'sn701', '8180.00');
INSERT INTO `mx_balance` VALUES ('1179', 'sn701', '8120.00');
INSERT INTO `mx_balance` VALUES ('1180', 'sn701', '8110.00');
INSERT INTO `mx_balance` VALUES ('1181', 'sn701', '8100.00');
INSERT INTO `mx_balance` VALUES ('1182', 'sn701', '8080.00');
INSERT INTO `mx_balance` VALUES ('1183', 'sn701', '8060.00');
INSERT INTO `mx_balance` VALUES ('1184', 'sn701', '8050.00');
INSERT INTO `mx_balance` VALUES ('1185', 'sn701', '8030.00');
INSERT INTO `mx_balance` VALUES ('1186', 'sn701', '8020.00');
INSERT INTO `mx_balance` VALUES ('1187', 'sn701', '7990.00');
INSERT INTO `mx_balance` VALUES ('1188', 'sn701', '7970.00');
INSERT INTO `mx_balance` VALUES ('1189', 'sn701', '7930.00');
INSERT INTO `mx_balance` VALUES ('1190', 'sn701', '7920.00');
INSERT INTO `mx_balance` VALUES ('1191', 'sn701', '7890.00');
INSERT INTO `mx_balance` VALUES ('1192', 'sn701', '7840.00');
INSERT INTO `mx_balance` VALUES ('1193', 'ret1', '7240.00');
INSERT INTO `mx_balance` VALUES ('1194', 'ret1', '7230.00');
INSERT INTO `mx_balance` VALUES ('1195', 'ret1', '7190.00');
INSERT INTO `mx_balance` VALUES ('1196', 'sn701', '7830.00');
INSERT INTO `mx_balance` VALUES ('1197', 'sn701', '7820.00');
INSERT INTO `mx_balance` VALUES ('1198', 'sn701', '7810.00');
INSERT INTO `mx_balance` VALUES ('1199', 'sn701', '7780.00');
INSERT INTO `mx_balance` VALUES ('1200', 'sn701', '7760.00');
INSERT INTO `mx_balance` VALUES ('1201', 'sn701', '7750.00');
INSERT INTO `mx_balance` VALUES ('1202', 'sn701', '7740.00');
INSERT INTO `mx_balance` VALUES ('1203', 'sn701', '7730.00');
INSERT INTO `mx_balance` VALUES ('1204', 'sn701', '7680.00');
INSERT INTO `mx_balance` VALUES ('1205', 'sn701', '7670.00');
INSERT INTO `mx_balance` VALUES ('1206', 'sn701', '7660.00');
INSERT INTO `mx_balance` VALUES ('1207', 'sn701', '7650.00');
INSERT INTO `mx_balance` VALUES ('1208', 'sn701', '7640.00');
INSERT INTO `mx_balance` VALUES ('1209', 'sn701', '7620.00');
INSERT INTO `mx_balance` VALUES ('1210', 'sn702', '9640.00');
INSERT INTO `mx_balance` VALUES ('1211', 'sn701', '7600.00');
INSERT INTO `mx_balance` VALUES ('1212', 'sn701', '7570.00');
INSERT INTO `mx_balance` VALUES ('1213', 'sn701', '7540.00');
INSERT INTO `mx_balance` VALUES ('1214', 'sn701', '7520.00');
INSERT INTO `mx_balance` VALUES ('1215', 'sn701', '7500.00');
INSERT INTO `mx_balance` VALUES ('1216', 'sn701', '7460.00');
INSERT INTO `mx_balance` VALUES ('1217', 'sn701', '7440.00');
INSERT INTO `mx_balance` VALUES ('1218', 'sn701', '7430.00');
INSERT INTO `mx_balance` VALUES ('1219', 'sn701', '7370.00');
INSERT INTO `mx_balance` VALUES ('1220', 'sn701', '7340.00');
INSERT INTO `mx_balance` VALUES ('1221', 'sn701', '7220.00');
INSERT INTO `mx_balance` VALUES ('1222', 'sn701', '7170.00');
INSERT INTO `mx_balance` VALUES ('1223', 'sn701', '7140.00');
INSERT INTO `mx_balance` VALUES ('1224', 'sn701', '7080.00');
INSERT INTO `mx_balance` VALUES ('1225', 'sn701', '7030.00');
INSERT INTO `mx_balance` VALUES ('1226', 'sn701', '7020.00');
INSERT INTO `mx_balance` VALUES ('1227', 'sn701', '6980.00');
INSERT INTO `mx_balance` VALUES ('1228', 'sn701', '6930.00');
INSERT INTO `mx_balance` VALUES ('1229', 'sn701', '6900.00');
INSERT INTO `mx_balance` VALUES ('1230', 'sn701', '6870.00');
INSERT INTO `mx_balance` VALUES ('1231', 'sn701', '6670.00');
INSERT INTO `mx_balance` VALUES ('1232', 'sn701', '6660.00');
INSERT INTO `mx_balance` VALUES ('1233', 'sn701', '6460.00');
INSERT INTO `mx_balance` VALUES ('1234', 'sn701', '6420.00');
INSERT INTO `mx_balance` VALUES ('1235', 'sn701', '6120.00');
INSERT INTO `mx_balance` VALUES ('1236', 'sn701', '6070.00');
INSERT INTO `mx_balance` VALUES ('1237', 'sn701', '6060.00');
INSERT INTO `mx_balance` VALUES ('1238', 'sn701', '6050.00');
INSERT INTO `mx_balance` VALUES ('1239', 'sn701', '5850.00');
INSERT INTO `mx_balance` VALUES ('1240', 'sn701', '5840.00');
INSERT INTO `mx_balance` VALUES ('1241', 'sn701', '5750.00');
INSERT INTO `mx_balance` VALUES ('1242', 'sn701', '5550.00');
INSERT INTO `mx_balance` VALUES ('1243', 'sn701', '5540.00');
INSERT INTO `mx_balance` VALUES ('1244', 'sn701', '5530.00');
INSERT INTO `mx_balance` VALUES ('1245', 'sn701', '5330.00');
INSERT INTO `mx_balance` VALUES ('1246', 'sn701', '5130.00');
INSERT INTO `mx_balance` VALUES ('1247', 'sn701', '5120.00');
INSERT INTO `mx_balance` VALUES ('1248', 'sn701', '5110.00');
INSERT INTO `mx_balance` VALUES ('1249', 'sn701', '5010.00');
INSERT INTO `mx_balance` VALUES ('1250', 'sn701', '5000.00');
INSERT INTO `mx_balance` VALUES ('1251', 'sn701', '4600.00');
INSERT INTO `mx_balance` VALUES ('1252', 'sn701', '4590.00');
INSERT INTO `mx_balance` VALUES ('1253', 'sn701', '4580.00');
INSERT INTO `mx_balance` VALUES ('1254', 'sn701', '4570.00');
INSERT INTO `mx_balance` VALUES ('1255', 'ret1', '7150.00');
INSERT INTO `mx_balance` VALUES ('1256', 'sn701', '4550.00');
INSERT INTO `mx_balance` VALUES ('1257', 'sn701', '4450.00');
INSERT INTO `mx_balance` VALUES ('1258', 'sn701', '4420.00');
INSERT INTO `mx_balance` VALUES ('1259', 'sn701', '4410.00');
INSERT INTO `mx_balance` VALUES ('1260', 'sn701', '4400.00');
INSERT INTO `mx_balance` VALUES ('1261', 'sn701', '4350.00');
INSERT INTO `mx_balance` VALUES ('1262', 'sn701', '4200.00');
INSERT INTO `mx_balance` VALUES ('1263', 'sn701', '4180.00');
INSERT INTO `mx_balance` VALUES ('1264', 'sn701', '4030.00');
INSERT INTO `mx_balance` VALUES ('1265', 'sn701', '4000.00');
INSERT INTO `mx_balance` VALUES ('1266', 'sn701', '3980.00');
INSERT INTO `mx_balance` VALUES ('1267', 'sn701', '3800.00');
INSERT INTO `mx_balance` VALUES ('1268', 'sn701', '3780.00');
INSERT INTO `mx_balance` VALUES ('1269', 'sn701', '3760.00');
INSERT INTO `mx_balance` VALUES ('1270', 'sn701', '3460.00');
INSERT INTO `mx_balance` VALUES ('1271', 'sn701', '3450.00');
INSERT INTO `mx_balance` VALUES ('1272', 'sn701', '3290.00');
INSERT INTO `mx_balance` VALUES ('1273', 'sn701', '3110.00');
INSERT INTO `mx_balance` VALUES ('1274', 'sn701', '3090.00');
INSERT INTO `mx_balance` VALUES ('1275', 'sn701', '2790.00');
INSERT INTO `mx_balance` VALUES ('1276', 'sn701', '2610.00');
INSERT INTO `mx_balance` VALUES ('1277', 'sn702', '9630.00');
INSERT INTO `mx_balance` VALUES ('1278', 'sn701', '2810.00');
INSERT INTO `mx_balance` VALUES ('1279', 'ret1', '7110.00');
INSERT INTO `mx_balance` VALUES ('1280', 'ret1', '7070.00');
INSERT INTO `mx_balance` VALUES ('1281', 'ret1', '7030.00');
INSERT INTO `mx_balance` VALUES ('1282', 'ret1', '6990.00');
INSERT INTO `mx_balance` VALUES ('1283', 'ret1', '6950.00');
INSERT INTO `mx_balance` VALUES ('1284', 'ret1', '6910.00');
INSERT INTO `mx_balance` VALUES ('1285', 'ret1', '6870.00');
INSERT INTO `mx_balance` VALUES ('1286', 'ret1', '6830.00');
INSERT INTO `mx_balance` VALUES ('1287', 'ret1', '6790.00');
INSERT INTO `mx_balance` VALUES ('1288', 'ret1', '6750.00');
INSERT INTO `mx_balance` VALUES ('1289', 'ret1', '6710.00');
INSERT INTO `mx_balance` VALUES ('1290', 'ret1', '6670.00');
INSERT INTO `mx_balance` VALUES ('1291', 'ret1', '6630.00');
INSERT INTO `mx_balance` VALUES ('1292', 'ret1', '6590.00');
INSERT INTO `mx_balance` VALUES ('1293', 'ret1', '6550.00');
INSERT INTO `mx_balance` VALUES ('1294', 'ret1', '6510.00');
INSERT INTO `mx_balance` VALUES ('1295', 'ret1', '6470.00');
INSERT INTO `mx_balance` VALUES ('1296', 'ret1', '6430.00');
INSERT INTO `mx_balance` VALUES ('1297', 'ret1', '6390.00');
INSERT INTO `mx_balance` VALUES ('1298', 'ret1', '6350.00');
INSERT INTO `mx_balance` VALUES ('1299', 'ret1', '6310.00');
INSERT INTO `mx_balance` VALUES ('1300', 'ret1', '6270.00');
INSERT INTO `mx_balance` VALUES ('1301', 'ret1', '6230.00');
INSERT INTO `mx_balance` VALUES ('1302', 'ret1', '6190.00');
INSERT INTO `mx_balance` VALUES ('1303', 'ret1', '6150.00');
INSERT INTO `mx_balance` VALUES ('1304', 'ret1', '6110.00');
INSERT INTO `mx_balance` VALUES ('1305', 'ret1', '6070.00');
INSERT INTO `mx_balance` VALUES ('1306', 'ret1', '6030.00');
INSERT INTO `mx_balance` VALUES ('1307', 'ret1', '5990.00');
INSERT INTO `mx_balance` VALUES ('1308', 'ret1', '5950.00');
INSERT INTO `mx_balance` VALUES ('1309', 'ret1', '5910.00');
INSERT INTO `mx_balance` VALUES ('1310', 'ret1', '5870.00');
INSERT INTO `mx_balance` VALUES ('1311', 'ret1', '5830.00');
INSERT INTO `mx_balance` VALUES ('1312', 'ret1', '5790.00');
INSERT INTO `mx_balance` VALUES ('1313', 'ret1', '5750.00');
INSERT INTO `mx_balance` VALUES ('1314', 'sn701', '2790.00');
INSERT INTO `mx_balance` VALUES ('1315', 'sn701', '2780.00');
INSERT INTO `mx_balance` VALUES ('1316', 'sn701', '2740.00');
INSERT INTO `mx_balance` VALUES ('1317', 'sn701', '2720.00');
INSERT INTO `mx_balance` VALUES ('1318', 'sn701', '2700.00');
INSERT INTO `mx_balance` VALUES ('1319', 'sn701', '2660.00');
INSERT INTO `mx_balance` VALUES ('1320', 'ret1', '5710.00');
INSERT INTO `mx_balance` VALUES ('1321', 'sn701', '2650.00');
INSERT INTO `mx_balance` VALUES ('1322', 'sn701', '2640.00');
INSERT INTO `mx_balance` VALUES ('1323', 'sn701', '2590.00');
INSERT INTO `mx_balance` VALUES ('1324', 'ret1', '5670.00');
INSERT INTO `mx_balance` VALUES ('1325', 'ret1', '5630.00');
INSERT INTO `mx_balance` VALUES ('1326', 'sn701', '2490.00');
INSERT INTO `mx_balance` VALUES ('1327', 'sn701', '2470.00');
INSERT INTO `mx_balance` VALUES ('1328', 'sn701', '2440.00');
INSERT INTO `mx_balance` VALUES ('1329', 'sn701', '2430.00');
INSERT INTO `mx_balance` VALUES ('1330', 'sn701', '2420.00');
INSERT INTO `mx_balance` VALUES ('1331', 'sn701', '2410.00');
INSERT INTO `mx_balance` VALUES ('1332', 'sn701', '2390.00');
INSERT INTO `mx_balance` VALUES ('1333', 'sn701', '2370.00');
INSERT INTO `mx_balance` VALUES ('1334', 'sn701', '2330.00');
INSERT INTO `mx_balance` VALUES ('1335', 'sn701', '2290.00');
INSERT INTO `mx_balance` VALUES ('1336', 'sn701', '2270.00');
INSERT INTO `mx_balance` VALUES ('1337', 'sn701', '2250.00');
INSERT INTO `mx_balance` VALUES ('1338', 'sn701', '2240.00');
INSERT INTO `mx_balance` VALUES ('1339', 'sn701', '2230.00');
INSERT INTO `mx_balance` VALUES ('1340', 'sn701', '2220.00');
INSERT INTO `mx_balance` VALUES ('1341', 'sn701', '2200.00');
INSERT INTO `mx_balance` VALUES ('1342', 'sn701', '2180.00');
INSERT INTO `mx_balance` VALUES ('1343', 'sn701', '2150.00');
INSERT INTO `mx_balance` VALUES ('1344', 'sn701', '2110.00');
INSERT INTO `mx_balance` VALUES ('1345', 'sn701', '2100.00');
INSERT INTO `mx_balance` VALUES ('1346', 'sn701', '2090.00');
INSERT INTO `mx_balance` VALUES ('1347', 'sn701', '2080.00');
INSERT INTO `mx_balance` VALUES ('1348', 'sn701', '2040.00');
INSERT INTO `mx_balance` VALUES ('1349', 'sn701', '2030.00');
INSERT INTO `mx_balance` VALUES ('1350', 'sn701', '1990.00');
INSERT INTO `mx_balance` VALUES ('1351', 'sn701', '1980.00');
INSERT INTO `mx_balance` VALUES ('1352', 'sn701', '1970.00');
INSERT INTO `mx_balance` VALUES ('1353', 'sn701', '1930.00');
INSERT INTO `mx_balance` VALUES ('1354', 'sn701', '1920.00');
INSERT INTO `mx_balance` VALUES ('1355', 'sn701', '1860.00');
INSERT INTO `mx_balance` VALUES ('1356', 'sn701', '1850.00');
INSERT INTO `mx_balance` VALUES ('1357', 'sn701', '1810.00');
INSERT INTO `mx_balance` VALUES ('1358', 'sn701', '1800.00');
INSERT INTO `mx_balance` VALUES ('1359', 'sn701', '1700.00');
INSERT INTO `mx_balance` VALUES ('1360', 'sn701', '1600.00');
INSERT INTO `mx_balance` VALUES ('1361', 'sn701', '1570.00');
INSERT INTO `mx_balance` VALUES ('1362', 'sn701', '1560.00');
INSERT INTO `mx_balance` VALUES ('1363', 'sn701', '1450.00');
INSERT INTO `mx_balance` VALUES ('1364', 'sn701', '1410.00');
INSERT INTO `mx_balance` VALUES ('1365', 'sn701', '1400.00');
INSERT INTO `mx_balance` VALUES ('1366', 'sn701', '1330.00');
INSERT INTO `mx_balance` VALUES ('1367', 'sn701', '1280.00');
INSERT INTO `mx_balance` VALUES ('1368', 'sn702', '9600.00');
INSERT INTO `mx_balance` VALUES ('1369', 'sn701', '1080.00');
INSERT INTO `mx_balance` VALUES ('1370', 'sn702', '9570.00');
INSERT INTO `mx_balance` VALUES ('1371', 'sn701', '1030.00');
INSERT INTO `mx_balance` VALUES ('1372', 'sn702', '9550.00');
INSERT INTO `mx_balance` VALUES ('1373', 'sn701', '830.00');
INSERT INTO `mx_balance` VALUES ('1374', 'sn702', '9530.00');
INSERT INTO `mx_balance` VALUES ('1375', 'sn702', '9490.00');
INSERT INTO `mx_balance` VALUES ('1376', 'sn702', '9480.00');
INSERT INTO `mx_balance` VALUES ('1377', 'sn701', '780.00');
INSERT INTO `mx_balance` VALUES ('1378', 'sn701', '760.00');
INSERT INTO `mx_balance` VALUES ('1379', 'sn701', '540.00');
INSERT INTO `mx_balance` VALUES ('1380', 'sn702', '9460.00');
INSERT INTO `mx_balance` VALUES ('1381', 'sn702', '9430.00');
INSERT INTO `mx_balance` VALUES ('1382', 'sn702', '9370.00');
INSERT INTO `mx_balance` VALUES ('1383', 'sn702', '9270.00');
INSERT INTO `mx_balance` VALUES ('1384', 'sn702', '9260.00');
INSERT INTO `mx_balance` VALUES ('1385', 'sn702', '9240.00');
INSERT INTO `mx_balance` VALUES ('1386', 'sn701', '390.00');
INSERT INTO `mx_balance` VALUES ('1387', 'sn702', '9200.00');
INSERT INTO `mx_balance` VALUES ('1388', 'sn701', '240.00');
INSERT INTO `mx_balance` VALUES ('1389', 'sn701', '90.00');
INSERT INTO `mx_balance` VALUES ('1390', 'sn701', '10.00');
INSERT INTO `mx_balance` VALUES ('1391', 'sn701', '20010.00');
INSERT INTO `mx_balance` VALUES ('1392', 'sn701', '19970.00');
INSERT INTO `mx_balance` VALUES ('1393', 'sn701', '19890.00');
INSERT INTO `mx_balance` VALUES ('1394', 'sn701', '19840.00');
INSERT INTO `mx_balance` VALUES ('1395', 'sn701', '19690.00');
INSERT INTO `mx_balance` VALUES ('1396', 'sn701', '19540.00');
INSERT INTO `mx_balance` VALUES ('1397', 'sn702', '9160.00');
INSERT INTO `mx_balance` VALUES ('1398', 'sn701', '19500.00');
INSERT INTO `mx_balance` VALUES ('1399', 'sn701', '19310.00');
INSERT INTO `mx_balance` VALUES ('1400', 'sn701', '19110.00');
INSERT INTO `mx_balance` VALUES ('1401', 'sn701', '19060.00');
INSERT INTO `mx_balance` VALUES ('1402', 'sn701', '19020.00');
INSERT INTO `mx_balance` VALUES ('1403', 'sn701', '18960.00');
INSERT INTO `mx_balance` VALUES ('1404', 'sn701', '18900.00');
INSERT INTO `mx_balance` VALUES ('1405', 'sn701', '18810.00');
INSERT INTO `mx_balance` VALUES ('1406', 'sn701', '18510.00');
INSERT INTO `mx_balance` VALUES ('1407', 'sn701', '18490.00');
INSERT INTO `mx_balance` VALUES ('1408', 'sn701', '18390.00');
INSERT INTO `mx_balance` VALUES ('1409', 'sn701', '18300.00');
INSERT INTO `mx_balance` VALUES ('1410', 'sn701', '18290.00');
INSERT INTO `mx_balance` VALUES ('1411', 'sn701', '18190.00');
INSERT INTO `mx_balance` VALUES ('1412', 'sn701', '18170.00');
INSERT INTO `mx_balance` VALUES ('1413', 'sn701', '18070.00');
INSERT INTO `mx_balance` VALUES ('1414', 'sn701', '17970.00');
INSERT INTO `mx_balance` VALUES ('1415', 'sn701', '17750.00');
INSERT INTO `mx_balance` VALUES ('1416', 'sn701', '17650.00');
INSERT INTO `mx_balance` VALUES ('1417', 'sn701', '17550.00');
INSERT INTO `mx_balance` VALUES ('1418', 'sn701', '17500.00');
INSERT INTO `mx_balance` VALUES ('1419', 'sn701', '17320.00');
INSERT INTO `mx_balance` VALUES ('1420', 'sn702', '9150.00');
INSERT INTO `mx_balance` VALUES ('1421', 'sn702', '9140.00');
INSERT INTO `mx_balance` VALUES ('1422', 'sn701', '17290.00');
INSERT INTO `mx_balance` VALUES ('1423', 'sn702', '9040.00');
INSERT INTO `mx_balance` VALUES ('1424', 'sn701', '17260.00');
INSERT INTO `mx_balance` VALUES ('1425', 'sn701', '17160.00');
INSERT INTO `mx_balance` VALUES ('1426', 'sn701', '17140.00');
INSERT INTO `mx_balance` VALUES ('1427', 'sn702', '9000.00');
INSERT INTO `mx_balance` VALUES ('1428', 'sn702', '8990.00');
INSERT INTO `mx_balance` VALUES ('1429', 'sn702', '8980.00');
INSERT INTO `mx_balance` VALUES ('1430', 'sn702', '8950.00');
INSERT INTO `mx_balance` VALUES ('1431', 'sn702', '8910.00');
INSERT INTO `mx_balance` VALUES ('1432', 'sn702', '8880.00');
INSERT INTO `mx_balance` VALUES ('1433', 'sn702', '8870.00');
INSERT INTO `mx_balance` VALUES ('1434', 'sn702', '8860.00');
INSERT INTO `mx_balance` VALUES ('1435', 'sn702', '8840.00');
INSERT INTO `mx_balance` VALUES ('1436', 'ret1', '5580.00');
INSERT INTO `mx_balance` VALUES ('1437', 'sn701', '17120.00');
INSERT INTO `mx_balance` VALUES ('1438', 'sn701', '17090.00');
INSERT INTO `mx_balance` VALUES ('1439', 'sn701', '17080.00');
INSERT INTO `mx_balance` VALUES ('1440', 'sn701', '17070.00');
INSERT INTO `mx_balance` VALUES ('1441', 'sn701', '17050.00');
INSERT INTO `mx_balance` VALUES ('1442', 'sn701', '17030.00');
INSERT INTO `mx_balance` VALUES ('1443', 'sn701', '16940.00');
INSERT INTO `mx_balance` VALUES ('1444', 'sn701', '16900.00');
INSERT INTO `mx_balance` VALUES ('1445', 'sn701', '16820.00');
INSERT INTO `mx_balance` VALUES ('1446', 'sn701', '16720.00');
INSERT INTO `mx_balance` VALUES ('1447', 'sn701', '16640.00');
INSERT INTO `mx_balance` VALUES ('1448', 'sn701', '16620.00');
INSERT INTO `mx_balance` VALUES ('1449', 'sn701', '16520.00');
INSERT INTO `mx_balance` VALUES ('1450', 'sn701', '16460.00');
INSERT INTO `mx_balance` VALUES ('1451', 'sn701', '16400.00');
INSERT INTO `mx_balance` VALUES ('1452', 'sn701', '16380.00');
INSERT INTO `mx_balance` VALUES ('1453', 'sn701', '16340.00');
INSERT INTO `mx_balance` VALUES ('1454', 'sn701', '16330.00');
INSERT INTO `mx_balance` VALUES ('1455', 'sn701', '16280.00');
INSERT INTO `mx_balance` VALUES ('1456', 'sn701', '16230.00');
INSERT INTO `mx_balance` VALUES ('1457', 'sn701', '16220.00');
INSERT INTO `mx_balance` VALUES ('1458', 'sn701', '16200.00');
INSERT INTO `mx_balance` VALUES ('1459', 'sn701', '16180.00');
INSERT INTO `mx_balance` VALUES ('1460', 'ret1', '5540.00');
INSERT INTO `mx_balance` VALUES ('1461', 'sn701', '16150.00');
INSERT INTO `mx_balance` VALUES ('1462', 'sn701', '16130.00');
INSERT INTO `mx_balance` VALUES ('1463', 'sn701', '16110.00');
INSERT INTO `mx_balance` VALUES ('1464', 'sn701', '16090.00');
INSERT INTO `mx_balance` VALUES ('1465', 'sn701', '16080.00');
INSERT INTO `mx_balance` VALUES ('1466', 'ret1', '5500.00');
INSERT INTO `mx_balance` VALUES ('1467', 'ret1', '5460.00');
INSERT INTO `mx_balance` VALUES ('1468', 'ret1', '5420.00');
INSERT INTO `mx_balance` VALUES ('1469', 'ret1', '5380.00');
INSERT INTO `mx_balance` VALUES ('1470', 'ret1', '5340.00');
INSERT INTO `mx_balance` VALUES ('1471', 'ret1', '5300.00');
INSERT INTO `mx_balance` VALUES ('1472', 'ret1', '5260.00');
INSERT INTO `mx_balance` VALUES ('1473', 'ret1', '5220.00');
INSERT INTO `mx_balance` VALUES ('1474', 'ret1', '5180.00');
INSERT INTO `mx_balance` VALUES ('1475', 'ret1', '5140.00');
INSERT INTO `mx_balance` VALUES ('1476', 'ret1', '5100.00');
INSERT INTO `mx_balance` VALUES ('1477', 'ret1', '5060.00');
INSERT INTO `mx_balance` VALUES ('1478', 'ret1', '5020.00');
INSERT INTO `mx_balance` VALUES ('1479', 'ret1', '4980.00');
INSERT INTO `mx_balance` VALUES ('1480', 'ret1', '4940.00');
INSERT INTO `mx_balance` VALUES ('1481', 'ret1', '4900.00');
INSERT INTO `mx_balance` VALUES ('1482', 'ret1', '4860.00');
INSERT INTO `mx_balance` VALUES ('1483', 'ret1', '4820.00');
INSERT INTO `mx_balance` VALUES ('1484', 'ret1', '4780.00');
INSERT INTO `mx_balance` VALUES ('1485', 'ret1', '4740.00');
INSERT INTO `mx_balance` VALUES ('1486', 'ret1', '4700.00');
INSERT INTO `mx_balance` VALUES ('1487', 'ret1', '4660.00');
INSERT INTO `mx_balance` VALUES ('1488', 'ret1', '4620.00');
INSERT INTO `mx_balance` VALUES ('1489', 'ret1', '4580.00');
INSERT INTO `mx_balance` VALUES ('1490', 'ret1', '4540.00');
INSERT INTO `mx_balance` VALUES ('1491', 'ret1', '4500.00');
INSERT INTO `mx_balance` VALUES ('1492', 'ret1', '4460.00');
INSERT INTO `mx_balance` VALUES ('1493', 'ret1', '4420.00');
INSERT INTO `mx_balance` VALUES ('1494', 'sn701', '16060.00');
INSERT INTO `mx_balance` VALUES ('1495', 'sn701', '16040.00');
INSERT INTO `mx_balance` VALUES ('1496', 'sn701', '15890.00');
INSERT INTO `mx_balance` VALUES ('1497', 'ret1', '4380.00');
INSERT INTO `mx_balance` VALUES ('1498', 'sn702', '8830.00');
INSERT INTO `mx_balance` VALUES ('1499', 'sn702', '8810.00');
INSERT INTO `mx_balance` VALUES ('1500', 'sn702', '8800.00');
INSERT INTO `mx_balance` VALUES ('1501', 'sn701', '15870.00');
INSERT INTO `mx_balance` VALUES ('1502', 'ret1', '4280.00');
INSERT INTO `mx_balance` VALUES ('1503', 'sn701', '15800.00');
INSERT INTO `mx_balance` VALUES ('1504', 'sn701', '15770.00');
INSERT INTO `mx_balance` VALUES ('1505', 'sn701', '15750.00');
INSERT INTO `mx_balance` VALUES ('1506', 'sn701', '15740.00');
INSERT INTO `mx_balance` VALUES ('1507', 'sn702', '8770.00');
INSERT INTO `mx_balance` VALUES ('1508', 'sn702', '8740.00');
INSERT INTO `mx_balance` VALUES ('1509', 'sn702', '8710.00');
INSERT INTO `mx_balance` VALUES ('1510', 'sn702', '8700.00');
INSERT INTO `mx_balance` VALUES ('1511', 'sn702', '8670.00');
INSERT INTO `mx_balance` VALUES ('1512', 'sn701', '15700.00');
INSERT INTO `mx_balance` VALUES ('1513', 'sn701', '15660.00');
INSERT INTO `mx_balance` VALUES ('1514', 'sn701', '15620.00');
INSERT INTO `mx_balance` VALUES ('1515', 'sn701', '15570.00');
INSERT INTO `mx_balance` VALUES ('1516', 'sn701', '15560.00');
INSERT INTO `mx_balance` VALUES ('1517', 'sn701', '15660.00');
INSERT INTO `mx_balance` VALUES ('1518', 'sn701', '15760.00');
INSERT INTO `mx_balance` VALUES ('1519', 'sn701', '15740.00');
INSERT INTO `mx_balance` VALUES ('1520', 'sn702', '8660.00');
INSERT INTO `mx_balance` VALUES ('1521', 'sn702', '8650.00');
INSERT INTO `mx_balance` VALUES ('1522', 'sn702', '8620.00');
INSERT INTO `mx_balance` VALUES ('1523', 'sn701', '15680.00');
INSERT INTO `mx_balance` VALUES ('1524', 'sn701', '15660.00');
INSERT INTO `mx_balance` VALUES ('1525', 'sn701', '15620.00');
INSERT INTO `mx_balance` VALUES ('1526', 'sn701', '15570.00');
INSERT INTO `mx_balance` VALUES ('1527', 'sn701', '15560.00');
INSERT INTO `mx_balance` VALUES ('1528', 'sn701', '15540.00');
INSERT INTO `mx_balance` VALUES ('1529', 'sn701', '15500.00');
INSERT INTO `mx_balance` VALUES ('1530', 'sn702', '8600.00');
INSERT INTO `mx_balance` VALUES ('1531', 'sn701', '15460.00');
INSERT INTO `mx_balance` VALUES ('1532', 'sn702', '8580.00');
INSERT INTO `mx_balance` VALUES ('1533', 'sn701', '15450.00');
INSERT INTO `mx_balance` VALUES ('1534', 'sn701', '15440.00');
INSERT INTO `mx_balance` VALUES ('1535', 'sn701', '15420.00');
INSERT INTO `mx_balance` VALUES ('1536', 'sn701', '15360.00');
INSERT INTO `mx_balance` VALUES ('1537', 'sn701', '15350.00');
INSERT INTO `mx_balance` VALUES ('1538', 'ret1', '4230.00');
INSERT INTO `mx_balance` VALUES ('1539', 'ret1', '4180.00');
INSERT INTO `mx_balance` VALUES ('1540', 'ret1', '4130.00');
INSERT INTO `mx_balance` VALUES ('1541', 'ret1', '4080.00');
INSERT INTO `mx_balance` VALUES ('1542', 'sn702', '8530.00');
INSERT INTO `mx_balance` VALUES ('1543', 'ret1', '4030.00');
INSERT INTO `mx_balance` VALUES ('1544', 'ret1', '3980.00');
INSERT INTO `mx_balance` VALUES ('1545', 'ret1', '3930.00');
INSERT INTO `mx_balance` VALUES ('1546', 'ret1', '3880.00');
INSERT INTO `mx_balance` VALUES ('1547', 'ret1', '3830.00');
INSERT INTO `mx_balance` VALUES ('1548', 'ret1', '3780.00');
INSERT INTO `mx_balance` VALUES ('1549', 'ret1', '3730.00');
INSERT INTO `mx_balance` VALUES ('1550', 'ret1', '3720.00');
INSERT INTO `mx_balance` VALUES ('1551', 'ret1', '3670.00');
INSERT INTO `mx_balance` VALUES ('1552', 'sn701', '15450.00');
INSERT INTO `mx_balance` VALUES ('1553', 'sn701', '15430.00');
INSERT INTO `mx_balance` VALUES ('1554', 'ret1', '3650.00');
INSERT INTO `mx_balance` VALUES ('1555', 'ret1', '3600.00');
INSERT INTO `mx_balance` VALUES ('1556', 'sn701', '15420.00');
INSERT INTO `mx_balance` VALUES ('1557', 'sn701', '15400.00');
INSERT INTO `mx_balance` VALUES ('1558', 'expert132', '2000.00');
INSERT INTO `mx_balance` VALUES ('1559', 'expert132', '1950.00');
INSERT INTO `mx_balance` VALUES ('1560', 'expert132', '1900.00');
INSERT INTO `mx_balance` VALUES ('1561', 'expert132', '1850.00');
INSERT INTO `mx_balance` VALUES ('1562', 'sn701', '15390.00');
INSERT INTO `mx_balance` VALUES ('1563', 'sn702', '8470.00');
INSERT INTO `mx_balance` VALUES ('1564', 'sn701', '15340.00');
INSERT INTO `mx_balance` VALUES ('1565', 'sn701', '15330.00');
INSERT INTO `mx_balance` VALUES ('1566', 'sn702', '8450.00');
INSERT INTO `mx_balance` VALUES ('1567', 'sn702', '8430.00');
INSERT INTO `mx_balance` VALUES ('1568', 'sn701', '15310.00');
INSERT INTO `mx_balance` VALUES ('1569', 'sn701', '15290.00');
INSERT INTO `mx_balance` VALUES ('1570', 'sn701', '15270.00');
INSERT INTO `mx_balance` VALUES ('1571', 'sn701', '15250.00');
INSERT INTO `mx_balance` VALUES ('1572', 'sn701', '15230.00');
INSERT INTO `mx_balance` VALUES ('1573', 'sn701', '15210.00');
INSERT INTO `mx_balance` VALUES ('1574', 'sn701', '15190.00');
INSERT INTO `mx_balance` VALUES ('1575', 'sn701', '15170.00');
INSERT INTO `mx_balance` VALUES ('1576', 'sn701', '15150.00');
INSERT INTO `mx_balance` VALUES ('1577', 'sn701', '15130.00');
INSERT INTO `mx_balance` VALUES ('1578', 'sn701', '15080.00');
INSERT INTO `mx_balance` VALUES ('1579', 'sn701', '15030.00');
INSERT INTO `mx_balance` VALUES ('1580', 'sn701', '15010.00');
INSERT INTO `mx_balance` VALUES ('1581', 'sn701', '14940.00');
INSERT INTO `mx_balance` VALUES ('1582', 'sn701', '14930.00');
INSERT INTO `mx_balance` VALUES ('1583', 'sn701', '14890.00');
INSERT INTO `mx_balance` VALUES ('1584', 'sn701', '14820.00');
INSERT INTO `mx_balance` VALUES ('1585', 'sn701', '14810.00');
INSERT INTO `mx_balance` VALUES ('1586', 'sn701', '14760.00');
INSERT INTO `mx_balance` VALUES ('1587', 'sn701', '14750.00');
INSERT INTO `mx_balance` VALUES ('1588', 'sn701', '14740.00');
INSERT INTO `mx_balance` VALUES ('1589', 'sn701', '14720.00');
INSERT INTO `mx_balance` VALUES ('1590', 'sn701', '14710.00');
INSERT INTO `mx_balance` VALUES ('1591', 'sn701', '14700.00');
INSERT INTO `mx_balance` VALUES ('1592', 'sn701', '14650.00');
INSERT INTO `mx_balance` VALUES ('1593', 'sn701', '14640.00');
INSERT INTO `mx_balance` VALUES ('1594', 'sn701', '14610.00');
INSERT INTO `mx_balance` VALUES ('1595', 'sn701', '14600.00');
INSERT INTO `mx_balance` VALUES ('1596', 'sn701', '14560.00');
INSERT INTO `mx_balance` VALUES ('1597', 'sn701', '14550.00');
INSERT INTO `mx_balance` VALUES ('1598', 'sn701', '14500.00');
INSERT INTO `mx_balance` VALUES ('1599', 'sn701', '14490.00');
INSERT INTO `mx_balance` VALUES ('1600', 'sn701', '14580.00');
INSERT INTO `mx_balance` VALUES ('1601', 'sn701', '14530.00');
INSERT INTO `mx_balance` VALUES ('1602', 'sn701', '14510.00');
INSERT INTO `mx_balance` VALUES ('1603', 'sn701', '14500.00');
INSERT INTO `mx_balance` VALUES ('1604', 'sn701', '14450.00');
INSERT INTO `mx_balance` VALUES ('1605', 'sn701', '13950.00');
INSERT INTO `mx_balance` VALUES ('1606', 'expert132', '1800.00');
INSERT INTO `mx_balance` VALUES ('1607', 'sn701', '13940.00');
INSERT INTO `mx_balance` VALUES ('1608', 'sn701', '13820.00');
INSERT INTO `mx_balance` VALUES ('1609', 'sn701', '13770.00');
INSERT INTO `mx_balance` VALUES ('1610', 'sn701', '13730.00');
INSERT INTO `mx_balance` VALUES ('1611', 'sn701', '13710.00');
INSERT INTO `mx_balance` VALUES ('1612', 'sn701', '13700.00');
INSERT INTO `mx_balance` VALUES ('1613', 'sn701', '13800.00');
INSERT INTO `mx_balance` VALUES ('1614', 'sn701', '13900.00');
INSERT INTO `mx_balance` VALUES ('1615', 'sn701', '14000.00');
INSERT INTO `mx_balance` VALUES ('1616', 'expert132', '1750.00');
INSERT INTO `mx_balance` VALUES ('1617', 'expert132', '1700.00');
INSERT INTO `mx_balance` VALUES ('1618', 'expert132', '1650.00');
INSERT INTO `mx_balance` VALUES ('1619', 'expert132', '1600.00');
INSERT INTO `mx_balance` VALUES ('1620', 'expert132', '1550.00');
INSERT INTO `mx_balance` VALUES ('1621', 'expert132', '1540.00');
INSERT INTO `mx_balance` VALUES ('1622', 'expert132', '1530.00');
INSERT INTO `mx_balance` VALUES ('1623', 'expert132', '1480.00');
INSERT INTO `mx_balance` VALUES ('1624', 'expert132', '1430.00');
INSERT INTO `mx_balance` VALUES ('1625', 'sn701', '14100.00');
INSERT INTO `mx_balance` VALUES ('1626', 'sn702', '8400.00');
INSERT INTO `mx_balance` VALUES ('1627', 'sn701', '14060.00');
INSERT INTO `mx_balance` VALUES ('1628', 'sn702', '8390.00');
INSERT INTO `mx_balance` VALUES ('1629', 'sn701', '14000.00');
INSERT INTO `mx_balance` VALUES ('1630', 'sn701', '13910.00');
INSERT INTO `mx_balance` VALUES ('1631', 'sn701', '13900.00');
INSERT INTO `mx_balance` VALUES ('1632', 'sn701', '13890.00');
INSERT INTO `mx_balance` VALUES ('1633', 'sn701', '13840.00');
INSERT INTO `mx_balance` VALUES ('1634', 'sn701', '13780.00');
INSERT INTO `mx_balance` VALUES ('1635', 'sn701', '13730.00');
INSERT INTO `mx_balance` VALUES ('1636', 'sn701', '13820.00');
INSERT INTO `mx_balance` VALUES ('1637', 'sn701', '13760.00');
INSERT INTO `mx_balance` VALUES ('1638', 'sn701', '13640.00');
INSERT INTO `mx_balance` VALUES ('1639', 'sn701', '13580.00');
INSERT INTO `mx_balance` VALUES ('1640', 'sn701', '13520.00');
INSERT INTO `mx_balance` VALUES ('1641', 'sn701', '13620.00');
INSERT INTO `mx_balance` VALUES ('1642', 'sn701', '13720.00');
INSERT INTO `mx_balance` VALUES ('1643', 'sn701', '13820.00');
INSERT INTO `mx_balance` VALUES ('1644', 'sn701', '13920.00');
INSERT INTO `mx_balance` VALUES ('1645', 'sn701', '13740.00');
INSERT INTO `mx_balance` VALUES ('1646', 'sn701', '13620.00');
INSERT INTO `mx_balance` VALUES ('1647', 'sn701', '13820.00');
INSERT INTO `mx_balance` VALUES ('1648', 'sn701', '13800.00');
INSERT INTO `mx_balance` VALUES ('1649', 'sn701', '13780.00');
INSERT INTO `mx_balance` VALUES ('1650', 'sn701', '13770.00');
INSERT INTO `mx_balance` VALUES ('1651', 'sn701', '13760.00');
INSERT INTO `mx_balance` VALUES ('1652', 'sn701', '13750.00');
INSERT INTO `mx_balance` VALUES ('1653', 'sn701', '13740.00');
INSERT INTO `mx_balance` VALUES ('1654', 'sn701', '13730.00');
INSERT INTO `mx_balance` VALUES ('1655', 'sn701', '13720.00');
INSERT INTO `mx_balance` VALUES ('1656', 'sn701', '13710.00');
INSERT INTO `mx_balance` VALUES ('1657', 'sn701', '13700.00');
INSERT INTO `mx_balance` VALUES ('1658', 'sn701', '13680.00');
INSERT INTO `mx_balance` VALUES ('1659', 'sn701', '13650.00');
INSERT INTO `mx_balance` VALUES ('1660', 'sn701', '13630.00');
INSERT INTO `mx_balance` VALUES ('1661', 'sn701', '13610.00');
INSERT INTO `mx_balance` VALUES ('1662', 'sn701', '13530.00');
INSERT INTO `mx_balance` VALUES ('1663', 'sn701', '13490.00');
INSERT INTO `mx_balance` VALUES ('1664', 'sn701', '13450.00');
INSERT INTO `mx_balance` VALUES ('1665', 'sn701', '13350.00');
INSERT INTO `mx_balance` VALUES ('1666', 'sn701', '13260.00');
INSERT INTO `mx_balance` VALUES ('1667', 'sn701', '13250.00');
INSERT INTO `mx_balance` VALUES ('1668', 'sn701', '13050.00');
INSERT INTO `mx_balance` VALUES ('1669', 'sn701', '13010.00');
INSERT INTO `mx_balance` VALUES ('1670', 'sn701', '13100.00');
INSERT INTO `mx_balance` VALUES ('1671', 'sn701', '12900.00');
INSERT INTO `mx_balance` VALUES ('1672', 'sn701', '12860.00');
INSERT INTO `mx_balance` VALUES ('1673', 'sn701', '12760.00');
INSERT INTO `mx_balance` VALUES ('1674', 'sn701', '12850.00');
INSERT INTO `mx_balance` VALUES ('1675', 'sn701', '12830.00');
INSERT INTO `mx_balance` VALUES ('1676', 'sn701', '12810.00');
INSERT INTO `mx_balance` VALUES ('1677', 'sn701', '12790.00');
INSERT INTO `mx_balance` VALUES ('1678', 'sn701', '12780.00');
INSERT INTO `mx_balance` VALUES ('1679', 'sn701', '12770.00');
INSERT INTO `mx_balance` VALUES ('1680', 'sn701', '12760.00');
INSERT INTO `mx_balance` VALUES ('1681', 'sn701', '12750.00');
INSERT INTO `mx_balance` VALUES ('1682', 'sn701', '12700.00');
INSERT INTO `mx_balance` VALUES ('1683', 'sn701', '12650.00');
INSERT INTO `mx_balance` VALUES ('1684', 'sn701', '12640.00');
INSERT INTO `mx_balance` VALUES ('1685', 'sn701', '12610.00');
INSERT INTO `mx_balance` VALUES ('1686', 'sn702', '8370.00');
INSERT INTO `mx_balance` VALUES ('1687', 'sn701', '12520.00');
INSERT INTO `mx_balance` VALUES ('1688', 'sn701', '12470.00');
INSERT INTO `mx_balance` VALUES ('1689', 'sn701', '12560.00');
INSERT INTO `mx_balance` VALUES ('1690', 'sn701', '12470.00');
INSERT INTO `mx_balance` VALUES ('1691', 'sn701', '12460.00');
INSERT INTO `mx_balance` VALUES ('1692', 'sn701', '12410.00');
INSERT INTO `mx_balance` VALUES ('1693', 'sn701', '12390.00');
INSERT INTO `mx_balance` VALUES ('1694', 'sn701', '12140.00');
INSERT INTO `mx_balance` VALUES ('1695', 'sn701', '12110.00');
INSERT INTO `mx_balance` VALUES ('1696', 'sn701', '12200.00');
INSERT INTO `mx_balance` VALUES ('1697', 'sn701', '12160.00');
INSERT INTO `mx_balance` VALUES ('1698', 'sn701', '12060.00');
INSERT INTO `mx_balance` VALUES ('1699', 'sn701', '12020.00');
INSERT INTO `mx_balance` VALUES ('1700', 'sn701', '11990.00');
INSERT INTO `mx_balance` VALUES ('1701', 'sn701', '11980.00');
INSERT INTO `mx_balance` VALUES ('1702', 'sn701', '11480.00');
INSERT INTO `mx_balance` VALUES ('1703', 'sn701', '11430.00');
INSERT INTO `mx_balance` VALUES ('1704', 'sn701', '11520.00');
INSERT INTO `mx_balance` VALUES ('1705', 'sn701', '11610.00');
INSERT INTO `mx_balance` VALUES ('1706', 'sn701', '11560.00');
INSERT INTO `mx_balance` VALUES ('1707', 'sn701', '11480.00');
INSERT INTO `mx_balance` VALUES ('1708', 'sn701', '11680.00');
INSERT INTO `mx_balance` VALUES ('1709', 'sn701', '11430.00');
INSERT INTO `mx_balance` VALUES ('1710', 'sn701', '11380.00');
INSERT INTO `mx_balance` VALUES ('1711', 'sn701', '11360.00');
INSERT INTO `mx_balance` VALUES ('1712', 'sn701', '11310.00');
INSERT INTO `mx_balance` VALUES ('1713', 'sn701', '11400.00');
INSERT INTO `mx_balance` VALUES ('1714', 'sn701', '11360.00');
INSERT INTO `mx_balance` VALUES ('1715', 'sn701', '11300.00');
INSERT INTO `mx_balance` VALUES ('1716', 'sn701', '11290.00');
INSERT INTO `mx_balance` VALUES ('1717', 'sn701', '11190.00');
INSERT INTO `mx_balance` VALUES ('1718', 'sn701', '11150.00');
INSERT INTO `mx_balance` VALUES ('1719', 'sn701', '11050.00');
INSERT INTO `mx_balance` VALUES ('1720', 'sn701', '10950.00');
INSERT INTO `mx_balance` VALUES ('1721', 'sn701', '10930.00');
INSERT INTO `mx_balance` VALUES ('1722', 'sn701', '10850.00');
INSERT INTO `mx_balance` VALUES ('1723', 'sn701', '10670.00');
INSERT INTO `mx_balance` VALUES ('1724', 'sn701', '10660.00');
INSERT INTO `mx_balance` VALUES ('1725', 'sn701', '10510.00');
INSERT INTO `mx_balance` VALUES ('1726', 'sn701', '10460.00');
INSERT INTO `mx_balance` VALUES ('1727', 'sn701', '10450.00');
INSERT INTO `mx_balance` VALUES ('1728', 'sn701', '10440.00');
INSERT INTO `mx_balance` VALUES ('1729', 'sn702', '8350.00');
INSERT INTO `mx_balance` VALUES ('1730', 'sn702', '8320.00');
INSERT INTO `mx_balance` VALUES ('1731', 'sn702', '8300.00');
INSERT INTO `mx_balance` VALUES ('1732', 'sn702', '8270.00');
INSERT INTO `mx_balance` VALUES ('1733', 'sn701', '10430.00');
INSERT INTO `mx_balance` VALUES ('1734', 'sn701', '10330.00');
INSERT INTO `mx_balance` VALUES ('1735', 'sn701', '10260.00');
INSERT INTO `mx_balance` VALUES ('1736', 'sn701', '10460.00');
INSERT INTO `mx_balance` VALUES ('1737', 'sn701', '10660.00');
INSERT INTO `mx_balance` VALUES ('1738', 'sn702', '8260.00');
INSERT INTO `mx_balance` VALUES ('1739', 'sn702', '8240.00');
INSERT INTO `mx_balance` VALUES ('1740', 'sn702', '8220.00');
INSERT INTO `mx_balance` VALUES ('1741', 'sn702', '8200.00');
INSERT INTO `mx_balance` VALUES ('1742', 'sn702', '8180.00');
INSERT INTO `mx_balance` VALUES ('1743', 'sn702', '8150.00');
INSERT INTO `mx_balance` VALUES ('1744', 'sn702', '8130.00');
INSERT INTO `mx_balance` VALUES ('1745', 'sn702', '8110.00');
INSERT INTO `mx_balance` VALUES ('1746', 'sn701', '10610.00');
INSERT INTO `mx_balance` VALUES ('1747', 'sn701', '10590.00');
INSERT INTO `mx_balance` VALUES ('1748', 'sn702', '8030.00');
INSERT INTO `mx_balance` VALUES ('1749', 'sn702', '8020.00');
INSERT INTO `mx_balance` VALUES ('1750', 'sn702', '8010.00');
INSERT INTO `mx_balance` VALUES ('1751', 'sn702', '7990.00');
INSERT INTO `mx_balance` VALUES ('1752', 'sn702', '7970.00');
INSERT INTO `mx_balance` VALUES ('1753', 'sn702', '7940.00');
INSERT INTO `mx_balance` VALUES ('1754', 'sn701', '10580.00');
INSERT INTO `mx_balance` VALUES ('1755', 'sn701', '10550.00');
INSERT INTO `mx_balance` VALUES ('1756', 'sn701', '10530.00');
INSERT INTO `mx_balance` VALUES ('1757', 'sn701', '10520.00');
INSERT INTO `mx_balance` VALUES ('1758', 'sn701', '10470.00');
INSERT INTO `mx_balance` VALUES ('1759', 'sn701', '10450.00');
INSERT INTO `mx_balance` VALUES ('1760', 'sn701', '10430.00');
INSERT INTO `mx_balance` VALUES ('1761', 'sn701', '10420.00');
INSERT INTO `mx_balance` VALUES ('1762', 'sn701', '10390.00');
INSERT INTO `mx_balance` VALUES ('1763', 'sn701', '10380.00');
INSERT INTO `mx_balance` VALUES ('1764', 'sn701', '10370.00');
INSERT INTO `mx_balance` VALUES ('1765', 'sn701', '10360.00');
INSERT INTO `mx_balance` VALUES ('1766', 'sn701', '10310.00');
INSERT INTO `mx_balance` VALUES ('1767', 'sn701', '10290.00');
INSERT INTO `mx_balance` VALUES ('1768', 'sn701', '10270.00');
INSERT INTO `mx_balance` VALUES ('1769', 'sn702', '7840.00');
INSERT INTO `mx_balance` VALUES ('1770', 'sn701', '10210.00');
INSERT INTO `mx_balance` VALUES ('1771', 'sn701', '10170.00');
INSERT INTO `mx_balance` VALUES ('1772', 'sn702', '7640.00');
INSERT INTO `mx_balance` VALUES ('1773', 'sn702', '7440.00');
INSERT INTO `mx_balance` VALUES ('1774', 'sn702', '7240.00');
INSERT INTO `mx_balance` VALUES ('1775', 'sn701', '10150.00');
INSERT INTO `mx_balance` VALUES ('1776', 'sn701', '10140.00');
INSERT INTO `mx_balance` VALUES ('1777', 'sn701', '10130.00');
INSERT INTO `mx_balance` VALUES ('1778', 'sn701', '10080.00');
INSERT INTO `mx_balance` VALUES ('1779', 'sn701', '9880.00');
INSERT INTO `mx_balance` VALUES ('1780', 'sn702', '7230.00');
INSERT INTO `mx_balance` VALUES ('1781', 'sn702', '7220.00');
INSERT INTO `mx_balance` VALUES ('1782', 'sn702', '7180.00');
INSERT INTO `mx_balance` VALUES ('1783', 'sn702', '7120.00');
INSERT INTO `mx_balance` VALUES ('1784', 'sn702', '7020.00');
INSERT INTO `mx_balance` VALUES ('1785', 'sn702', '7000.00');
INSERT INTO `mx_balance` VALUES ('1786', 'sn702', '6950.00');
INSERT INTO `mx_balance` VALUES ('1787', 'sn702', '6940.00');
INSERT INTO `mx_balance` VALUES ('1788', 'sn702', '6880.00');
INSERT INTO `mx_balance` VALUES ('1789', 'sn702', '6870.00');
INSERT INTO `mx_balance` VALUES ('1790', 'sn702', '6860.00');
INSERT INTO `mx_balance` VALUES ('1791', 'sn702', '6850.00');
INSERT INTO `mx_balance` VALUES ('1792', 'sn702', '6830.00');
INSERT INTO `mx_balance` VALUES ('1793', 'sn702', '6730.00');
INSERT INTO `mx_balance` VALUES ('1794', 'sn702', '6720.00');
INSERT INTO `mx_balance` VALUES ('1795', 'sn702', '6620.00');
INSERT INTO `mx_balance` VALUES ('1796', 'sn702', '6570.00');
INSERT INTO `mx_balance` VALUES ('1797', 'sn702', '6550.00');
INSERT INTO `mx_balance` VALUES ('1798', 'sn702', '6530.00');
INSERT INTO `mx_balance` VALUES ('1799', 'sn702', '6510.00');
INSERT INTO `mx_balance` VALUES ('1800', 'sn702', '6480.00');
INSERT INTO `mx_balance` VALUES ('1801', 'sn702', '6450.00');
INSERT INTO `mx_balance` VALUES ('1802', 'sn702', '6430.00');
INSERT INTO `mx_balance` VALUES ('1803', 'sn702', '6410.00');
INSERT INTO `mx_balance` VALUES ('1804', 'sn702', '6400.00');
INSERT INTO `mx_balance` VALUES ('1805', 'sn702', '6310.00');
INSERT INTO `mx_balance` VALUES ('1806', 'sn702', '6270.00');
INSERT INTO `mx_balance` VALUES ('1807', 'sn702', '6240.00');
INSERT INTO `mx_balance` VALUES ('1808', 'sn702', '6230.00');
INSERT INTO `mx_balance` VALUES ('1809', 'sn702', '6110.00');
INSERT INTO `mx_balance` VALUES ('1810', 'sn702', '6080.00');
INSERT INTO `mx_balance` VALUES ('1811', 'sn702', '6050.00');
INSERT INTO `mx_balance` VALUES ('1812', 'sn702', '6010.00');
INSERT INTO `mx_balance` VALUES ('1813', 'sn702', '5970.00');
INSERT INTO `mx_balance` VALUES ('1814', 'sn702', '5930.00');
INSERT INTO `mx_balance` VALUES ('1815', 'sn702', '5850.00');
INSERT INTO `mx_balance` VALUES ('1816', 'sn702', '5810.00');
INSERT INTO `mx_balance` VALUES ('1817', 'sn702', '5780.00');
INSERT INTO `mx_balance` VALUES ('1818', 'sn702', '5720.00');
INSERT INTO `mx_balance` VALUES ('1819', 'sn702', '5680.00');
INSERT INTO `mx_balance` VALUES ('1820', 'sn702', '5580.00');
INSERT INTO `mx_balance` VALUES ('1821', 'sn702', '5480.00');
INSERT INTO `mx_balance` VALUES ('1822', 'sn702', '5360.00');
INSERT INTO `mx_balance` VALUES ('1823', 'sn702', '5160.00');
INSERT INTO `mx_balance` VALUES ('1824', 'sn702', '5110.00');
INSERT INTO `mx_balance` VALUES ('1825', 'sn702', '4910.00');
INSERT INTO `mx_balance` VALUES ('1826', 'sn702', '4810.00');
INSERT INTO `mx_balance` VALUES ('1827', 'sn702', '4750.00');
INSERT INTO `mx_balance` VALUES ('1828', 'sn702', '4700.00');
INSERT INTO `mx_balance` VALUES ('1829', 'sn702', '4570.00');
INSERT INTO `mx_balance` VALUES ('1830', 'sn702', '4460.00');
INSERT INTO `mx_balance` VALUES ('1831', 'sn702', '4320.00');
INSERT INTO `mx_balance` VALUES ('1832', 'sn702', '4190.00');
INSERT INTO `mx_balance` VALUES ('1833', 'sn702', '4180.00');
INSERT INTO `mx_balance` VALUES ('1834', 'sn702', '4150.00');
INSERT INTO `mx_balance` VALUES ('1835', 'sn702', '4120.00');
INSERT INTO `mx_balance` VALUES ('1836', 'sn702', '4080.00');
INSERT INTO `mx_balance` VALUES ('1837', 'sn702', '3980.00');
INSERT INTO `mx_balance` VALUES ('1838', 'sn702', '3960.00');
INSERT INTO `mx_balance` VALUES ('1839', 'sn702', '3950.00');
INSERT INTO `mx_balance` VALUES ('1840', 'sn702', '3940.00');
INSERT INTO `mx_balance` VALUES ('1841', 'sn702', '3930.00');
INSERT INTO `mx_balance` VALUES ('1842', 'sn702', '3910.00');
INSERT INTO `mx_balance` VALUES ('1843', 'sn702', '3810.00');
INSERT INTO `mx_balance` VALUES ('1844', 'sn702', '3710.00');
INSERT INTO `mx_balance` VALUES ('1845', 'sn702', '3670.00');
INSERT INTO `mx_balance` VALUES ('1846', 'sn702', '3590.00');
INSERT INTO `mx_balance` VALUES ('1847', 'sn702', '3490.00');
INSERT INTO `mx_balance` VALUES ('1848', 'sn701', '9870.00');
INSERT INTO `mx_balance` VALUES ('1849', 'sn701', '9860.00');
INSERT INTO `mx_balance` VALUES ('1850', 'sn701', '9820.00');
INSERT INTO `mx_balance` VALUES ('1851', 'sn701', '9780.00');
INSERT INTO `mx_balance` VALUES ('1852', 'sn701', '9740.00');
INSERT INTO `mx_balance` VALUES ('1853', 'sn701', '9680.00');
INSERT INTO `mx_balance` VALUES ('1854', 'sn701', '9630.00');
INSERT INTO `mx_balance` VALUES ('1855', 'sn701', '9590.00');
INSERT INTO `mx_balance` VALUES ('1856', 'sn701', '9540.00');
INSERT INTO `mx_balance` VALUES ('1857', 'sn701', '9470.00');
INSERT INTO `mx_balance` VALUES ('1858', 'sn701', '9390.00');
INSERT INTO `mx_balance` VALUES ('1859', 'sn701', '9310.00');
INSERT INTO `mx_balance` VALUES ('1860', 'sn701', '9290.00');
INSERT INTO `mx_balance` VALUES ('1861', 'sn701', '9270.00');
INSERT INTO `mx_balance` VALUES ('1862', 'sn701', '9190.00');
INSERT INTO `mx_balance` VALUES ('1863', 'sn701', '9090.00');
INSERT INTO `mx_balance` VALUES ('1864', 'sn701', '9010.00');
INSERT INTO `mx_balance` VALUES ('1865', 'sn701', '8890.00');
INSERT INTO `mx_balance` VALUES ('1866', 'sn701', '8830.00');
INSERT INTO `mx_balance` VALUES ('1867', 'sn701', '8770.00');
INSERT INTO `mx_balance` VALUES ('1868', 'sn701', '8710.00');
INSERT INTO `mx_balance` VALUES ('1869', 'sn701', '8810.00');
INSERT INTO `mx_balance` VALUES ('1870', 'sn701', '8910.00');
INSERT INTO `mx_balance` VALUES ('1871', 'sn702', '3480.00');
INSERT INTO `mx_balance` VALUES ('1872', 'sn702', '3470.00');
INSERT INTO `mx_balance` VALUES ('1873', 'sn702', '3450.00');
INSERT INTO `mx_balance` VALUES ('1874', 'sn702', '3440.00');
INSERT INTO `mx_balance` VALUES ('1875', 'sn702', '3410.00');
INSERT INTO `mx_balance` VALUES ('1876', 'sn702', '3390.00');
INSERT INTO `mx_balance` VALUES ('1877', 'sn702', '3380.00');
INSERT INTO `mx_balance` VALUES ('1878', 'sn702', '3370.00');
INSERT INTO `mx_balance` VALUES ('1879', 'sn702', '3320.00');
INSERT INTO `mx_balance` VALUES ('1880', 'sn702', '3310.00');
INSERT INTO `mx_balance` VALUES ('1881', 'sn702', '3210.00');
INSERT INTO `mx_balance` VALUES ('1882', 'sn702', '3180.00');
INSERT INTO `mx_balance` VALUES ('1883', 'sn701', '8900.00');
INSERT INTO `mx_balance` VALUES ('1884', 'sn701', '8880.00');
INSERT INTO `mx_balance` VALUES ('1885', 'sn701', '8850.00');
INSERT INTO `mx_balance` VALUES ('1886', 'sn701', '8820.00');
INSERT INTO `mx_balance` VALUES ('1887', 'sn702', '3130.00');
INSERT INTO `mx_balance` VALUES ('1888', 'sn701', '8790.00');
INSERT INTO `mx_balance` VALUES ('1889', 'sn701', '8770.00');
INSERT INTO `mx_balance` VALUES ('1890', 'sn701', '8740.00');
INSERT INTO `mx_balance` VALUES ('1891', 'sn702', '3120.00');
INSERT INTO `mx_balance` VALUES ('1892', 'sn702', '3080.00');
INSERT INTO `mx_balance` VALUES ('1893', 'sn701', '8720.00');
INSERT INTO `mx_balance` VALUES ('1894', 'sn702', '3070.00');
INSERT INTO `mx_balance` VALUES ('1895', 'sn702', '3060.00');
INSERT INTO `mx_balance` VALUES ('1896', 'sn702', '3040.00');
INSERT INTO `mx_balance` VALUES ('1897', 'sn702', '3030.00');
INSERT INTO `mx_balance` VALUES ('1898', 'sn702', '3010.00');
INSERT INTO `mx_balance` VALUES ('1899', 'sn702', '2990.00');
INSERT INTO `mx_balance` VALUES ('1900', 'sn702', '2970.00');
INSERT INTO `mx_balance` VALUES ('1901', 'sn701', '8820.00');
INSERT INTO `mx_balance` VALUES ('1902', 'sn701', '8810.00');
INSERT INTO `mx_balance` VALUES ('1903', 'sn702', '2940.00');
INSERT INTO `mx_balance` VALUES ('1904', 'sn701', '8800.00');
INSERT INTO `mx_balance` VALUES ('1905', 'sn701', '8780.00');
INSERT INTO `mx_balance` VALUES ('1906', 'sn701', '8760.00');
INSERT INTO `mx_balance` VALUES ('1907', 'sn701', '8740.00');
INSERT INTO `mx_balance` VALUES ('1908', 'sn701', '8730.00');
INSERT INTO `mx_balance` VALUES ('1909', 'sn701', '8720.00');
INSERT INTO `mx_balance` VALUES ('1910', 'sn701', '8710.00');
INSERT INTO `mx_balance` VALUES ('1911', 'sn701', '8700.00');
INSERT INTO `mx_balance` VALUES ('1912', 'sn701', '8670.00');
INSERT INTO `mx_balance` VALUES ('1913', 'sn701', '8630.00');
INSERT INTO `mx_balance` VALUES ('1914', 'sn701', '8580.00');
INSERT INTO `mx_balance` VALUES ('1915', 'sn701', '8530.00');
INSERT INTO `mx_balance` VALUES ('1916', 'sn701', '8520.00');
INSERT INTO `mx_balance` VALUES ('1917', 'sn702', '2850.00');
INSERT INTO `mx_balance` VALUES ('1918', 'sn702', '2740.00');
INSERT INTO `mx_balance` VALUES ('1919', 'sn702', '2640.00');
INSERT INTO `mx_balance` VALUES ('1920', 'sn702', '2540.00');
INSERT INTO `mx_balance` VALUES ('1921', 'sn702', '2440.00');
INSERT INTO `mx_balance` VALUES ('1922', 'sn702', '2290.00');
INSERT INTO `mx_balance` VALUES ('1923', 'sn702', '2140.00');
INSERT INTO `mx_balance` VALUES ('1924', 'sn702', '2090.00');
INSERT INTO `mx_balance` VALUES ('1925', 'sn702', '2070.00');
INSERT INTO `mx_balance` VALUES ('1926', 'sn702', '1870.00');
INSERT INTO `mx_balance` VALUES ('1927', 'sn702', '1850.00');
INSERT INTO `mx_balance` VALUES ('1928', 'sn702', '1820.00');
INSERT INTO `mx_balance` VALUES ('1929', 'sn702', '1810.00');
INSERT INTO `mx_balance` VALUES ('1930', 'sn702', '1800.00');
INSERT INTO `mx_balance` VALUES ('1931', 'sn701', '8510.00');
INSERT INTO `mx_balance` VALUES ('1932', 'sn701', '8480.00');
INSERT INTO `mx_balance` VALUES ('1933', 'sn701', '8440.00');
INSERT INTO `mx_balance` VALUES ('1934', 'sn702', '1760.00');
INSERT INTO `mx_balance` VALUES ('1935', 'sn701', '8400.00');
INSERT INTO `mx_balance` VALUES ('1936', 'sn701', '8390.00');
INSERT INTO `mx_balance` VALUES ('1937', 'sn701', '8340.00');
INSERT INTO `mx_balance` VALUES ('1938', 'sn701', '8310.00');
INSERT INTO `mx_balance` VALUES ('1939', 'sn701', '8170.00');
INSERT INTO `mx_balance` VALUES ('1940', 'sn701', '8160.00');
INSERT INTO `mx_balance` VALUES ('1941', 'sn701', '8140.00');
INSERT INTO `mx_balance` VALUES ('1942', 'sn701', '8130.00');
INSERT INTO `mx_balance` VALUES ('1943', 'sn701', '8110.00');
INSERT INTO `mx_balance` VALUES ('1944', 'sn701', '8090.00');
INSERT INTO `mx_balance` VALUES ('1945', 'sn701', '8050.00');
INSERT INTO `mx_balance` VALUES ('1946', 'sn701', '8030.00');
INSERT INTO `mx_balance` VALUES ('1947', 'sn701', '8020.00');
INSERT INTO `mx_balance` VALUES ('1948', 'sn701', '8010.00');
INSERT INTO `mx_balance` VALUES ('1949', 'sn701', '8000.00');
INSERT INTO `mx_balance` VALUES ('1950', 'sn701', '7990.00');
INSERT INTO `mx_balance` VALUES ('1951', 'sn701', '7970.00');
INSERT INTO `mx_balance` VALUES ('1952', 'sn701', '7960.00');
INSERT INTO `mx_balance` VALUES ('1953', 'sn701', '7910.00');
INSERT INTO `mx_balance` VALUES ('1954', 'sn701', '7890.00');
INSERT INTO `mx_balance` VALUES ('1955', 'sn701', '7880.00');
INSERT INTO `mx_balance` VALUES ('1956', 'sn701', '7870.00');
INSERT INTO `mx_balance` VALUES ('1957', 'sn701', '7820.00');
INSERT INTO `mx_balance` VALUES ('1958', 'sn701', '7810.00');
INSERT INTO `mx_balance` VALUES ('1959', 'sn701', '7800.00');
INSERT INTO `mx_balance` VALUES ('1960', 'sn701', '7790.00');
INSERT INTO `mx_balance` VALUES ('1961', 'sn701', '7770.00');
INSERT INTO `mx_balance` VALUES ('1962', 'sn701', '7760.00');
INSERT INTO `mx_balance` VALUES ('1963', 'sn701', '7750.00');
INSERT INTO `mx_balance` VALUES ('1964', 'sn701', '7700.00');
INSERT INTO `mx_balance` VALUES ('1965', 'sn701', '7680.00');
INSERT INTO `mx_balance` VALUES ('1966', 'sn701', '7630.00');
INSERT INTO `mx_balance` VALUES ('1967', 'sn701', '7610.00');
INSERT INTO `mx_balance` VALUES ('1968', 'sn701', '7600.00');
INSERT INTO `mx_balance` VALUES ('1969', 'sn701', '7560.00');
INSERT INTO `mx_balance` VALUES ('1970', 'sn702', '1710.00');
INSERT INTO `mx_balance` VALUES ('1971', 'sn701', '7540.00');
INSERT INTO `mx_balance` VALUES ('1972', 'sn701', '7450.00');
INSERT INTO `mx_balance` VALUES ('1973', 'sn701', '7420.00');
INSERT INTO `mx_balance` VALUES ('1974', 'sn701', '7380.00');
INSERT INTO `mx_balance` VALUES ('1975', 'sn702', '1600.00');
INSERT INTO `mx_balance` VALUES ('1976', 'sn701', '7340.00');
INSERT INTO `mx_balance` VALUES ('1977', 'sn701', '7320.00');
INSERT INTO `mx_balance` VALUES ('1978', 'sn701', '7230.00');
INSERT INTO `mx_balance` VALUES ('1979', 'sn701', '7210.00');
INSERT INTO `mx_balance` VALUES ('1980', 'sn701', '7170.00');
INSERT INTO `mx_balance` VALUES ('1981', 'sn701', '7050.00');
INSERT INTO `mx_balance` VALUES ('1982', 'sn701', '6930.00');
INSERT INTO `mx_balance` VALUES ('1983', 'sn701', '6900.00');
INSERT INTO `mx_balance` VALUES ('1984', 'sn701', '6860.00');
INSERT INTO `mx_balance` VALUES ('1985', 'sn701', '6800.00');
INSERT INTO `mx_balance` VALUES ('1986', 'sn701', '6740.00');
INSERT INTO `mx_balance` VALUES ('1987', 'sn701', '6630.00');
INSERT INTO `mx_balance` VALUES ('1988', 'sn701', '6620.00');
INSERT INTO `mx_balance` VALUES ('1989', 'sn701', '6610.00');
INSERT INTO `mx_balance` VALUES ('1990', 'sn701', '6520.00');
INSERT INTO `mx_balance` VALUES ('1991', 'sn701', '6430.00');
INSERT INTO `mx_balance` VALUES ('1992', 'sn701', '6420.00');
INSERT INTO `mx_balance` VALUES ('1993', 'sn701', '6330.00');
INSERT INTO `mx_balance` VALUES ('1994', 'sn701', '6240.00');
INSERT INTO `mx_balance` VALUES ('1995', 'sn701', '6220.00');
INSERT INTO `mx_balance` VALUES ('1996', 'sn701', '6200.00');
INSERT INTO `mx_balance` VALUES ('1997', 'sn701', '6090.00');
INSERT INTO `mx_balance` VALUES ('1998', 'sn701', '6070.00');
INSERT INTO `mx_balance` VALUES ('1999', 'sn701', '6040.00');
INSERT INTO `mx_balance` VALUES ('2000', 'sn701', '5950.00');
INSERT INTO `mx_balance` VALUES ('2001', 'sn701', '5940.00');
INSERT INTO `mx_balance` VALUES ('2002', 'sn701', '5930.00');
INSERT INTO `mx_balance` VALUES ('2003', 'sn701', '5910.00');
INSERT INTO `mx_balance` VALUES ('2004', 'sn701', '5900.00');
INSERT INTO `mx_balance` VALUES ('2005', 'sn701', '5810.00');
INSERT INTO `mx_balance` VALUES ('2006', 'sn701', '5800.00');
INSERT INTO `mx_balance` VALUES ('2007', 'sn701', '5790.00');
INSERT INTO `mx_balance` VALUES ('2008', 'sn701', '5770.00');
INSERT INTO `mx_balance` VALUES ('2009', 'sn701', '5740.00');
INSERT INTO `mx_balance` VALUES ('2010', 'sn701', '5660.00');
INSERT INTO `mx_balance` VALUES ('2011', 'sn701', '5640.00');
INSERT INTO `mx_balance` VALUES ('2012', 'sn701', '5620.00');
INSERT INTO `mx_balance` VALUES ('2013', 'sn701', '5560.00');
INSERT INTO `mx_balance` VALUES ('2014', 'sn701', '5520.00');
INSERT INTO `mx_balance` VALUES ('2015', 'sn701', '5490.00');
INSERT INTO `mx_balance` VALUES ('2016', 'sn701', '5400.00');
INSERT INTO `mx_balance` VALUES ('2017', 'sn701', '5380.00');
INSERT INTO `mx_balance` VALUES ('2018', 'sn701', '5280.00');
INSERT INTO `mx_balance` VALUES ('2019', 'sn701', '5240.00');
INSERT INTO `mx_balance` VALUES ('2020', 'sn701', '5210.00');
INSERT INTO `mx_balance` VALUES ('2021', 'sn701', '5190.00');
INSERT INTO `mx_balance` VALUES ('2022', 'sn701', '5150.00');
INSERT INTO `mx_balance` VALUES ('2023', 'sn701', '5140.00');
INSERT INTO `mx_balance` VALUES ('2024', 'sn701', '5100.00');
INSERT INTO `mx_balance` VALUES ('2025', 'sn701', '5090.00');
INSERT INTO `mx_balance` VALUES ('2026', 'sn701', '5040.00');
INSERT INTO `mx_balance` VALUES ('2027', 'sn701', '5000.00');
INSERT INTO `mx_balance` VALUES ('2028', 'sn701', '4970.00');
INSERT INTO `mx_balance` VALUES ('2029', 'sn701', '4920.00');
INSERT INTO `mx_balance` VALUES ('2030', 'sn701', '4880.00');
INSERT INTO `mx_balance` VALUES ('2031', 'sn701', '4830.00');
INSERT INTO `mx_balance` VALUES ('2032', 'sn701', '4790.00');
INSERT INTO `mx_balance` VALUES ('2033', 'sn701', '4770.00');
INSERT INTO `mx_balance` VALUES ('2034', 'sn701', '4720.00');
INSERT INTO `mx_balance` VALUES ('2035', 'sn701', '4700.00');
INSERT INTO `mx_balance` VALUES ('2036', 'sn701', '4650.00');
INSERT INTO `mx_balance` VALUES ('2037', 'sn701', '4590.00');
INSERT INTO `mx_balance` VALUES ('2038', 'sn701', '4570.00');
INSERT INTO `mx_balance` VALUES ('2039', 'sn701', '4550.00');
INSERT INTO `mx_balance` VALUES ('2040', 'sn701', '4650.00');
INSERT INTO `mx_balance` VALUES ('2041', 'sn701', '4610.00');
INSERT INTO `mx_balance` VALUES ('2042', 'sn701', '4600.00');
INSERT INTO `mx_balance` VALUES ('2043', 'sn701', '4550.00');
INSERT INTO `mx_balance` VALUES ('2044', 'sn701', '4460.00');
INSERT INTO `mx_balance` VALUES ('2045', 'sn701', '4450.00');
INSERT INTO `mx_balance` VALUES ('2046', 'sn701', '4440.00');
INSERT INTO `mx_balance` VALUES ('2047', 'sn701', '4420.00');
INSERT INTO `mx_balance` VALUES ('2048', 'sn701', '4390.00');
INSERT INTO `mx_balance` VALUES ('2049', 'sn701', '4280.00');
INSERT INTO `mx_balance` VALUES ('2050', 'sn701', '4260.00');
INSERT INTO `mx_balance` VALUES ('2051', 'sn701', '4240.00');
INSERT INTO `mx_balance` VALUES ('2052', 'sn701', '4230.00');
INSERT INTO `mx_balance` VALUES ('2053', 'sn701', '4330.00');
INSERT INTO `mx_balance` VALUES ('2054', 'sn701', '4430.00');
INSERT INTO `mx_balance` VALUES ('2055', 'sn701', '4530.00');
INSERT INTO `mx_balance` VALUES ('2056', 'sn701', '4630.00');
INSERT INTO `mx_balance` VALUES ('2057', 'sn701', '4730.00');
INSERT INTO `mx_balance` VALUES ('2058', 'sn701', '4710.00');
INSERT INTO `mx_balance` VALUES ('2059', 'sn701', '4690.00');
INSERT INTO `mx_balance` VALUES ('2060', 'sn701', '4670.00');
INSERT INTO `mx_balance` VALUES ('2061', 'sn701', '4660.00');
INSERT INTO `mx_balance` VALUES ('2062', 'sn701', '4600.00');
INSERT INTO `mx_balance` VALUES ('2063', 'sn701', '4550.00');
INSERT INTO `mx_balance` VALUES ('2064', 'sn701', '4510.00');
INSERT INTO `mx_balance` VALUES ('2065', 'sn701', '4490.00');
INSERT INTO `mx_balance` VALUES ('2066', 'sn701', '4440.00');
INSERT INTO `mx_balance` VALUES ('2067', 'sn701', '4410.00');
INSERT INTO `mx_balance` VALUES ('2068', 'sn701', '4350.00');
INSERT INTO `mx_balance` VALUES ('2069', 'sn701', '4330.00');
INSERT INTO `mx_balance` VALUES ('2070', 'sn701', '4270.00');
INSERT INTO `mx_balance` VALUES ('2071', 'sn701', '4230.00');
INSERT INTO `mx_balance` VALUES ('2072', 'sn701', '4180.00');
INSERT INTO `mx_balance` VALUES ('2073', 'sn701', '4170.00');
INSERT INTO `mx_balance` VALUES ('2074', 'sn701', '4140.00');
INSERT INTO `mx_balance` VALUES ('2075', 'sn701', '4120.00');
INSERT INTO `mx_balance` VALUES ('2076', 'sn701', '4100.00');
INSERT INTO `mx_balance` VALUES ('2077', 'sn701', '3990.00');
INSERT INTO `mx_balance` VALUES ('2078', 'sn701', '3940.00');
INSERT INTO `mx_balance` VALUES ('2079', 'sn701', '3900.00');
INSERT INTO `mx_balance` VALUES ('2080', 'sn701', '3820.00');
INSERT INTO `mx_balance` VALUES ('2081', 'sn701', '3790.00');
INSERT INTO `mx_balance` VALUES ('2082', 'sn701', '3770.00');
INSERT INTO `mx_balance` VALUES ('2083', 'sn701', '3750.00');
INSERT INTO `mx_balance` VALUES ('2084', 'sn701', '3730.00');
INSERT INTO `mx_balance` VALUES ('2085', 'sn701', '3720.00');
INSERT INTO `mx_balance` VALUES ('2086', 'sn701', '3680.00');
INSERT INTO `mx_balance` VALUES ('2087', 'sn701', '3650.00');
INSERT INTO `mx_balance` VALUES ('2088', 'sn701', '3600.00');
INSERT INTO `mx_balance` VALUES ('2089', 'sn701', '3580.00');
INSERT INTO `mx_balance` VALUES ('2090', 'sn701', '3560.00');
INSERT INTO `mx_balance` VALUES ('2091', 'sn701', '3550.00');
INSERT INTO `mx_balance` VALUES ('2092', 'sn701', '3500.00');
INSERT INTO `mx_balance` VALUES ('2093', 'sn701', '3410.00');
INSERT INTO `mx_balance` VALUES ('2094', 'sn701', '3400.00');
INSERT INTO `mx_balance` VALUES ('2095', 'sn701', '3380.00');
INSERT INTO `mx_balance` VALUES ('2096', 'sn701', '3290.00');
INSERT INTO `mx_balance` VALUES ('2097', 'sn701', '3280.00');
INSERT INTO `mx_balance` VALUES ('2098', 'sn701', '3270.00');
INSERT INTO `mx_balance` VALUES ('2099', 'sn701', '3210.00');
INSERT INTO `mx_balance` VALUES ('2100', 'sn701', '3150.00');
INSERT INTO `mx_balance` VALUES ('2101', 'sn701', '3060.00');
INSERT INTO `mx_balance` VALUES ('2102', 'sn701', '2970.00');
INSERT INTO `mx_balance` VALUES ('2103', 'sn701', '2910.00');
INSERT INTO `mx_balance` VALUES ('2104', 'sn701', '2900.00');
INSERT INTO `mx_balance` VALUES ('2105', 'sn701', '2860.00');
INSERT INTO `mx_balance` VALUES ('2106', 'sn701', '2840.00');
INSERT INTO `mx_balance` VALUES ('2107', 'sn701', '2930.00');
INSERT INTO `mx_balance` VALUES ('2108', 'sn701', '2830.00');
INSERT INTO `mx_balance` VALUES ('2109', 'sn701', '2810.00');
INSERT INTO `mx_balance` VALUES ('2110', 'sn701', '2750.00');
INSERT INTO `mx_balance` VALUES ('2111', 'sn701', '2740.00');
INSERT INTO `mx_balance` VALUES ('2112', 'sn701', '2730.00');
INSERT INTO `mx_balance` VALUES ('2113', 'sn701', '2720.00');
INSERT INTO `mx_balance` VALUES ('2114', 'sn701', '2590.00');
INSERT INTO `mx_balance` VALUES ('2115', 'sn701', '2580.00');
INSERT INTO `mx_balance` VALUES ('2116', 'sn701', '2520.00');
INSERT INTO `mx_balance` VALUES ('2117', 'sn701', '2420.00');
INSERT INTO `mx_balance` VALUES ('2118', 'sn701', '2380.00');
INSERT INTO `mx_balance` VALUES ('2119', 'sn701', '2330.00');
INSERT INTO `mx_balance` VALUES ('2120', 'sn701', '2310.00');
INSERT INTO `mx_balance` VALUES ('2121', 'sn701', '2280.00');
INSERT INTO `mx_balance` VALUES ('2122', 'sn702', '1550.00');
INSERT INTO `mx_balance` VALUES ('2123', 'sn701', '2180.00');
INSERT INTO `mx_balance` VALUES ('2124', 'sn701', '2170.00');
INSERT INTO `mx_balance` VALUES ('2125', 'sn701', '2070.00');
INSERT INTO `mx_balance` VALUES ('2126', 'sn701', '1970.00');
INSERT INTO `mx_balance` VALUES ('2127', 'sn701', '1960.00');
INSERT INTO `mx_balance` VALUES ('2128', 'sn701', '1950.00');
INSERT INTO `mx_balance` VALUES ('2129', 'sn701', '1890.00');
INSERT INTO `mx_balance` VALUES ('2130', 'sn701', '1830.00');
INSERT INTO `mx_balance` VALUES ('2131', 'sn701', '1930.00');
INSERT INTO `mx_balance` VALUES ('2132', 'sn701', '2030.00');
INSERT INTO `mx_balance` VALUES ('2133', 'sn701', '2020.00');
INSERT INTO `mx_balance` VALUES ('2134', 'sn701', '2000.00');
INSERT INTO `mx_balance` VALUES ('2135', 'sn701', '1940.00');
INSERT INTO `mx_balance` VALUES ('2136', 'sn701', '1900.00');
INSERT INTO `mx_balance` VALUES ('2137', 'sn701', '1820.00');
INSERT INTO `mx_balance` VALUES ('2138', 'sn701', '1770.00');
INSERT INTO `mx_balance` VALUES ('2139', 'sn701', '1710.00');
INSERT INTO `mx_balance` VALUES ('2140', 'sn701', '1690.00');
INSERT INTO `mx_balance` VALUES ('2141', 'sn701', '1660.00');
INSERT INTO `mx_balance` VALUES ('2142', 'sn701', '1560.00');
INSERT INTO `mx_balance` VALUES ('2143', 'sn701', '1520.00');
INSERT INTO `mx_balance` VALUES ('2144', 'sn701', '1460.00');
INSERT INTO `mx_balance` VALUES ('2145', 'sn701', '1440.00');
INSERT INTO `mx_balance` VALUES ('2146', 'sn702', '1530.00');
INSERT INTO `mx_balance` VALUES ('2147', 'sn701', '1420.00');
INSERT INTO `mx_balance` VALUES ('2148', 'sn701', '1410.00');
INSERT INTO `mx_balance` VALUES ('2149', 'sn701', '1350.00');
INSERT INTO `mx_balance` VALUES ('2150', 'sn701', '1330.00');
INSERT INTO `mx_balance` VALUES ('2151', 'sn701', '1310.00');
INSERT INTO `mx_balance` VALUES ('2152', 'sn701', '1290.00');
INSERT INTO `mx_balance` VALUES ('2153', 'sn701', '21290.00');
INSERT INTO `mx_balance` VALUES ('2154', 'sn701', '21230.00');
INSERT INTO `mx_balance` VALUES ('2155', 'sn701', '21210.00');
INSERT INTO `mx_balance` VALUES ('2156', 'sn701', '21170.00');
INSERT INTO `mx_balance` VALUES ('2157', 'sn701', '21270.00');
INSERT INTO `mx_balance` VALUES ('2158', 'sn701', '21370.00');
INSERT INTO `mx_balance` VALUES ('2159', 'sn701', '21360.00');
INSERT INTO `mx_balance` VALUES ('2160', 'sn701', '21350.00');
INSERT INTO `mx_balance` VALUES ('2161', 'sn701', '21340.00');
INSERT INTO `mx_balance` VALUES ('2162', 'sn701', '21310.00');
INSERT INTO `mx_balance` VALUES ('2163', 'sn701', '21290.00');
INSERT INTO `mx_balance` VALUES ('2164', 'sn701', '21280.00');
INSERT INTO `mx_balance` VALUES ('2165', 'sn701', '21240.00');
INSERT INTO `mx_balance` VALUES ('2166', 'sn701', '21200.00');
INSERT INTO `mx_balance` VALUES ('2167', 'sn701', '21300.00');
INSERT INTO `mx_balance` VALUES ('2168', 'sn701', '21290.00');
INSERT INTO `mx_balance` VALUES ('2169', 'sn701', '21270.00');
INSERT INTO `mx_balance` VALUES ('2170', 'sn701', '21170.00');
INSERT INTO `mx_balance` VALUES ('2171', 'sn701', '21150.00');
INSERT INTO `mx_balance` VALUES ('2172', 'sn701', '21130.00');
INSERT INTO `mx_balance` VALUES ('2173', 'sn701', '21110.00');
INSERT INTO `mx_balance` VALUES ('2174', 'sn701', '21090.00');
INSERT INTO `mx_balance` VALUES ('2175', 'sn701', '21070.00');
INSERT INTO `mx_balance` VALUES ('2176', 'sn701', '21060.00');
INSERT INTO `mx_balance` VALUES ('2177', 'sn701', '21050.00');
INSERT INTO `mx_balance` VALUES ('2178', 'sn701', '21040.00');
INSERT INTO `mx_balance` VALUES ('2179', 'sn701', '21030.00');
INSERT INTO `mx_balance` VALUES ('2180', 'sn701', '21020.00');
INSERT INTO `mx_balance` VALUES ('2181', 'sn701', '21000.00');
INSERT INTO `mx_balance` VALUES ('2182', 'sn701', '20980.00');
INSERT INTO `mx_balance` VALUES ('2183', 'sn701', '20970.00');
INSERT INTO `mx_balance` VALUES ('2184', 'sn701', '20960.00');
INSERT INTO `mx_balance` VALUES ('2185', 'sn701', '20950.00');
INSERT INTO `mx_balance` VALUES ('2186', 'sn701', '20940.00');
INSERT INTO `mx_balance` VALUES ('2187', 'sn701', '20930.00');
INSERT INTO `mx_balance` VALUES ('2188', 'sn701', '20920.00');
INSERT INTO `mx_balance` VALUES ('2189', 'sn701', '20910.00');
INSERT INTO `mx_balance` VALUES ('2190', 'sn701', '20900.00');
INSERT INTO `mx_balance` VALUES ('2191', 'sn701', '20890.00');
INSERT INTO `mx_balance` VALUES ('2192', 'sn701', '20880.00');
INSERT INTO `mx_balance` VALUES ('2193', 'sn701', '20870.00');
INSERT INTO `mx_balance` VALUES ('2194', 'sn701', '20860.00');
INSERT INTO `mx_balance` VALUES ('2195', 'sn701', '20850.00');
INSERT INTO `mx_balance` VALUES ('2196', 'sn701', '20840.00');
INSERT INTO `mx_balance` VALUES ('2197', 'sn701', '20830.00');
INSERT INTO `mx_balance` VALUES ('2198', 'sn701', '20780.00');
INSERT INTO `mx_balance` VALUES ('2199', 'sn701', '20880.00');
INSERT INTO `mx_balance` VALUES ('2200', 'sn701', '20860.00');
INSERT INTO `mx_balance` VALUES ('2201', 'sn701', '20850.00');
INSERT INTO `mx_balance` VALUES ('2202', 'sn701', '20830.00');
INSERT INTO `mx_balance` VALUES ('2203', 'sn702', '1490.00');
INSERT INTO `mx_balance` VALUES ('2204', 'sn702', '1450.00');
INSERT INTO `mx_balance` VALUES ('2205', 'sn701', '20820.00');
INSERT INTO `mx_balance` VALUES ('2206', 'sn701', '20800.00');
INSERT INTO `mx_balance` VALUES ('2207', 'sn702', '1370.00');
INSERT INTO `mx_balance` VALUES ('2208', 'sn702', '1350.00');
INSERT INTO `mx_balance` VALUES ('2209', 'sn701', '20790.00');
INSERT INTO `mx_balance` VALUES ('2210', 'sn701', '20780.00');
INSERT INTO `mx_balance` VALUES ('2211', 'sn701', '20770.00');
INSERT INTO `mx_balance` VALUES ('2212', 'sn702', '1300.00');
INSERT INTO `mx_balance` VALUES ('2213', 'sn701', '20760.00');
INSERT INTO `mx_balance` VALUES ('2214', 'sn701', '20720.00');
INSERT INTO `mx_balance` VALUES ('2215', 'sn702', '1270.00');
INSERT INTO `mx_balance` VALUES ('2216', 'sn702', '1250.00');
INSERT INTO `mx_balance` VALUES ('2217', 'sn702', '1220.00');
INSERT INTO `mx_balance` VALUES ('2218', 'sn701', '20700.00');
INSERT INTO `mx_balance` VALUES ('2219', 'sn701', '20690.00');
INSERT INTO `mx_balance` VALUES ('2220', 'sn701', '20670.00');
INSERT INTO `mx_balance` VALUES ('2221', 'sn702', '1210.00');
INSERT INTO `mx_balance` VALUES ('2222', 'sn702', '1190.00');
INSERT INTO `mx_balance` VALUES ('2223', 'sn701', '20640.00');
INSERT INTO `mx_balance` VALUES ('2224', 'sn701', '20630.00');
INSERT INTO `mx_balance` VALUES ('2225', 'sn701', '20620.00');
INSERT INTO `mx_balance` VALUES ('2226', 'sn701', '20610.00');
INSERT INTO `mx_balance` VALUES ('2227', 'sn702', '1170.00');
INSERT INTO `mx_balance` VALUES ('2228', 'sn702', '1160.00');
INSERT INTO `mx_balance` VALUES ('2229', 'sn702', '1140.00');
INSERT INTO `mx_balance` VALUES ('2230', 'sn702', '1110.00');
INSERT INTO `mx_balance` VALUES ('2231', 'sn701', '20600.00');
INSERT INTO `mx_balance` VALUES ('2232', 'sn702', '1090.00');
INSERT INTO `mx_balance` VALUES ('2233', 'sn702', '1060.00');
INSERT INTO `mx_balance` VALUES ('2234', 'sn701', '20590.00');
INSERT INTO `mx_balance` VALUES ('2235', 'sn701', '20580.00');
INSERT INTO `mx_balance` VALUES ('2236', 'sn701', '20560.00');
INSERT INTO `mx_balance` VALUES ('2237', 'sn701', '20550.00');
INSERT INTO `mx_balance` VALUES ('2238', 'sn701', '20540.00');
INSERT INTO `mx_balance` VALUES ('2239', 'sn701', '20530.00');
INSERT INTO `mx_balance` VALUES ('2240', 'sn701', '20490.00');
INSERT INTO `mx_balance` VALUES ('2241', 'sn701', '20450.00');
INSERT INTO `mx_balance` VALUES ('2242', 'sn701', '20430.00');
INSERT INTO `mx_balance` VALUES ('2243', 'sn701', '20400.00');
INSERT INTO `mx_balance` VALUES ('2244', 'sn701', '20340.00');
INSERT INTO `mx_balance` VALUES ('2245', 'sn701', '20240.00');
INSERT INTO `mx_balance` VALUES ('2246', 'sn701', '20190.00');
INSERT INTO `mx_balance` VALUES ('2247', 'sn701', '20150.00');
INSERT INTO `mx_balance` VALUES ('2248', 'sn701', '20130.00');
INSERT INTO `mx_balance` VALUES ('2249', 'sn701', '20010.00');
INSERT INTO `mx_balance` VALUES ('2250', 'sn701', '19970.00');
INSERT INTO `mx_balance` VALUES ('2251', 'sn701', '19850.00');
INSERT INTO `mx_balance` VALUES ('2252', 'sn701', '19840.00');
INSERT INTO `mx_balance` VALUES ('2253', 'sn701', '19800.00');
INSERT INTO `mx_balance` VALUES ('2254', 'sn701', '19780.00');
INSERT INTO `mx_balance` VALUES ('2255', 'sn701', '19770.00');
INSERT INTO `mx_balance` VALUES ('2256', 'sn701', '19860.00');
INSERT INTO `mx_balance` VALUES ('2257', 'sn701', '19800.00');
INSERT INTO `mx_balance` VALUES ('2258', 'sn701', '19670.00');
INSERT INTO `mx_balance` VALUES ('2259', 'sn701', '19650.00');
INSERT INTO `mx_balance` VALUES ('2260', 'sn701', '19620.00');
INSERT INTO `mx_balance` VALUES ('2261', 'sn701', '19610.00');
INSERT INTO `mx_balance` VALUES ('2262', 'sn701', '19460.00');
INSERT INTO `mx_balance` VALUES ('2263', 'sn701', '19370.00');
INSERT INTO `mx_balance` VALUES ('2264', 'sn701', '19460.00');
INSERT INTO `mx_balance` VALUES ('2265', 'sn701', '19410.00');
INSERT INTO `mx_balance` VALUES ('2266', 'sn701', '19370.00');
INSERT INTO `mx_balance` VALUES ('2267', 'sn701', '19350.00');
INSERT INTO `mx_balance` VALUES ('2268', 'sn701', '19300.00');
INSERT INTO `mx_balance` VALUES ('2269', 'sn701', '19270.00');
INSERT INTO `mx_balance` VALUES ('2270', 'sn701', '19220.00');
INSERT INTO `mx_balance` VALUES ('2271', 'sn701', '19200.00');
INSERT INTO `mx_balance` VALUES ('2272', 'sn701', '19190.00');
INSERT INTO `mx_balance` VALUES ('2273', 'sn701', '19180.00');
INSERT INTO `mx_balance` VALUES ('2274', 'sn701', '19170.00');
INSERT INTO `mx_balance` VALUES ('2275', 'sn701', '19160.00');
INSERT INTO `mx_balance` VALUES ('2276', 'sn701', '19140.00');
INSERT INTO `mx_balance` VALUES ('2277', 'sn701', '19120.00');
INSERT INTO `mx_balance` VALUES ('2278', 'sn701', '19080.00');
INSERT INTO `mx_balance` VALUES ('2279', 'sn701', '19070.00');
INSERT INTO `mx_balance` VALUES ('2280', 'sn701', '19060.00');
INSERT INTO `mx_balance` VALUES ('2281', 'sn701', '19020.00');
INSERT INTO `mx_balance` VALUES ('2282', 'sn701', '19110.00');
INSERT INTO `mx_balance` VALUES ('2283', 'sn701', '19200.00');
INSERT INTO `mx_balance` VALUES ('2284', 'sn701', '19380.00');
INSERT INTO `mx_balance` VALUES ('2285', 'sn701', '19370.00');
INSERT INTO `mx_balance` VALUES ('2286', 'sn701', '19310.00');
INSERT INTO `mx_balance` VALUES ('2287', 'sn701', '19280.00');
INSERT INTO `mx_balance` VALUES ('2288', 'sn701', '19260.00');
INSERT INTO `mx_balance` VALUES ('2289', 'sn701', '19240.00');
INSERT INTO `mx_balance` VALUES ('2290', 'sn701', '19220.00');
INSERT INTO `mx_balance` VALUES ('2291', 'sn701', '19160.00');
INSERT INTO `mx_balance` VALUES ('2292', 'sn701', '19150.00');
INSERT INTO `mx_balance` VALUES ('2293', 'sn701', '19110.00');
INSERT INTO `mx_balance` VALUES ('2294', 'sn701', '19100.00');
INSERT INTO `mx_balance` VALUES ('2295', 'sn701', '19040.00');
INSERT INTO `mx_balance` VALUES ('2296', 'sn701', '19020.00');
INSERT INTO `mx_balance` VALUES ('2297', 'sn701', '19010.00');
INSERT INTO `mx_balance` VALUES ('2298', 'sn701', '18910.00');
INSERT INTO `mx_balance` VALUES ('2299', 'sn701', '18860.00');
INSERT INTO `mx_balance` VALUES ('2300', 'sn701', '18840.00');
INSERT INTO `mx_balance` VALUES ('2301', 'sn701', '18810.00');
INSERT INTO `mx_balance` VALUES ('2302', 'sn701', '18790.00');
INSERT INTO `mx_balance` VALUES ('2303', 'sn701', '18770.00');
INSERT INTO `mx_balance` VALUES ('2304', 'sn701', '18730.00');
INSERT INTO `mx_balance` VALUES ('2305', 'sn701', '18540.00');
INSERT INTO `mx_balance` VALUES ('2306', 'sn701', '18500.00');
INSERT INTO `mx_balance` VALUES ('2307', 'sn701', '18200.00');
INSERT INTO `mx_balance` VALUES ('2308', 'sn701', '17900.00');
INSERT INTO `mx_balance` VALUES ('2309', 'sn701', '18400.00');
INSERT INTO `mx_balance` VALUES ('2310', 'sn701', '18900.00');
INSERT INTO `mx_balance` VALUES ('2311', 'sn702', '960.00');
INSERT INTO `mx_balance` VALUES ('2312', 'sn702', '950.00');
INSERT INTO `mx_balance` VALUES ('2313', 'sn702', '850.00');
INSERT INTO `mx_balance` VALUES ('2314', 'sn701', '18890.00');
INSERT INTO `mx_balance` VALUES ('2315', 'sn702', '820.00');
INSERT INTO `mx_balance` VALUES ('2316', 'sn702', '810.00');
INSERT INTO `mx_balance` VALUES ('2317', 'sn702', '780.00');
INSERT INTO `mx_balance` VALUES ('2318', 'sn702', '750.00');
INSERT INTO `mx_balance` VALUES ('2319', 'sn702', '740.00');
INSERT INTO `mx_balance` VALUES ('2320', 'sn702', '710.00');
INSERT INTO `mx_balance` VALUES ('2321', 'sn702', '680.00');
INSERT INTO `mx_balance` VALUES ('2322', 'sn702', '590.00');
INSERT INTO `mx_balance` VALUES ('2323', 'sn702', '550.00');
INSERT INTO `mx_balance` VALUES ('2324', 'sn701', '18880.00');
INSERT INTO `mx_balance` VALUES ('2325', 'sn701', '18870.00');
INSERT INTO `mx_balance` VALUES ('2326', 'sn701', '18850.00');
INSERT INTO `mx_balance` VALUES ('2327', 'sn701', '18830.00');
INSERT INTO `mx_balance` VALUES ('2328', 'sn701', '18810.00');
INSERT INTO `mx_balance` VALUES ('2329', 'sn702', '450.00');
INSERT INTO `mx_balance` VALUES ('2330', 'sn701', '18800.00');
INSERT INTO `mx_balance` VALUES ('2331', 'sn701', '18790.00');
INSERT INTO `mx_balance` VALUES ('2332', 'sn702', '430.00');
INSERT INTO `mx_balance` VALUES ('2333', 'sn702', '420.00');
INSERT INTO `mx_balance` VALUES ('2334', 'sn702', '410.00');
INSERT INTO `mx_balance` VALUES ('2335', 'sn701', '18780.00');
INSERT INTO `mx_balance` VALUES ('2336', 'sn702', '400.00');
INSERT INTO `mx_balance` VALUES ('2337', 'sn701', '18680.00');
INSERT INTO `mx_balance` VALUES ('2338', 'sn701', '18630.00');
INSERT INTO `mx_balance` VALUES ('2339', 'sn701', '18720.00');
INSERT INTO `mx_balance` VALUES ('2340', 'sn702', '20400.00');
INSERT INTO `mx_balance` VALUES ('2341', 'sn702', '20390.00');
INSERT INTO `mx_balance` VALUES ('2342', 'sn702', '20290.00');
INSERT INTO `mx_balance` VALUES ('2343', 'sn702', '20250.00');
INSERT INTO `mx_balance` VALUES ('2344', 'sn702', '20150.00');
INSERT INTO `mx_balance` VALUES ('2345', 'sn702', '20090.00');
INSERT INTO `mx_balance` VALUES ('2346', 'sn702', '20070.00');
INSERT INTO `mx_balance` VALUES ('2347', 'sn702', '19970.00');
INSERT INTO `mx_balance` VALUES ('2348', 'sn702', '19950.00');
INSERT INTO `mx_balance` VALUES ('2349', 'sn702', '19850.00');
INSERT INTO `mx_balance` VALUES ('2350', 'sn702', '19820.00');
INSERT INTO `mx_balance` VALUES ('2351', 'sn702', '19780.00');
INSERT INTO `mx_balance` VALUES ('2352', 'sn702', '19770.00');
INSERT INTO `mx_balance` VALUES ('2353', 'sn702', '19760.00');
INSERT INTO `mx_balance` VALUES ('2354', 'sn702', '19730.00');
INSERT INTO `mx_balance` VALUES ('2355', 'sn702', '19700.00');
INSERT INTO `mx_balance` VALUES ('2356', 'sn702', '19690.00');
INSERT INTO `mx_balance` VALUES ('2357', 'sn702', '19640.00');
INSERT INTO `mx_balance` VALUES ('2358', 'sn702', '19590.00');
INSERT INTO `mx_balance` VALUES ('2359', 'sn702', '19490.00');
INSERT INTO `mx_balance` VALUES ('2360', 'sn702', '19390.00');
INSERT INTO `mx_balance` VALUES ('2361', 'sn702', '19300.00');
INSERT INTO `mx_balance` VALUES ('2362', 'sn702', '19250.00');
INSERT INTO `mx_balance` VALUES ('2363', 'sn702', '19240.00');
INSERT INTO `mx_balance` VALUES ('2364', 'sn701', '18710.00');
INSERT INTO `mx_balance` VALUES ('2365', 'sn701', '18680.00');
INSERT INTO `mx_balance` VALUES ('2366', 'sn701', '18670.00');
INSERT INTO `mx_balance` VALUES ('2367', 'sn701', '18650.00');
INSERT INTO `mx_balance` VALUES ('2368', 'sn701', '18630.00');
INSERT INTO `mx_balance` VALUES ('2369', 'sn701', '18530.00');
INSERT INTO `mx_balance` VALUES ('2370', 'sn701', '18520.00');
INSERT INTO `mx_balance` VALUES ('2371', 'sn701', '18500.00');
INSERT INTO `mx_balance` VALUES ('2372', 'sn701', '18480.00');
INSERT INTO `mx_balance` VALUES ('2373', 'sn701', '18460.00');
INSERT INTO `mx_balance` VALUES ('2374', 'sn702', '19230.00');
INSERT INTO `mx_balance` VALUES ('2375', 'sn702', '19220.00');
INSERT INTO `mx_balance` VALUES ('2376', 'sn701', '18400.00');
INSERT INTO `mx_balance` VALUES ('2377', 'sn701', '18360.00');
INSERT INTO `mx_balance` VALUES ('2378', 'sn701', '18350.00');
INSERT INTO `mx_balance` VALUES ('2379', 'sn701', '18330.00');
INSERT INTO `mx_balance` VALUES ('2380', 'sn701', '18290.00');
INSERT INTO `mx_balance` VALUES ('2381', 'sn702', '19190.00');
INSERT INTO `mx_balance` VALUES ('2382', 'sn701', '18270.00');
INSERT INTO `mx_balance` VALUES ('2383', 'sn701', '18210.00');
INSERT INTO `mx_balance` VALUES ('2384', 'sn701', '18190.00');
INSERT INTO `mx_balance` VALUES ('2385', 'sn701', '18150.00');
INSERT INTO `mx_balance` VALUES ('2386', 'sn701', '18130.00');
INSERT INTO `mx_balance` VALUES ('2387', 'sn701', '18090.00');
INSERT INTO `mx_balance` VALUES ('2388', 'sn701', '18050.00');
INSERT INTO `mx_balance` VALUES ('2389', 'sn701', '18040.00');
INSERT INTO `mx_balance` VALUES ('2390', 'sn701', '17940.00');
INSERT INTO `mx_balance` VALUES ('2391', 'sn701', '17930.00');
INSERT INTO `mx_balance` VALUES ('2392', 'sn701', '17900.00');
INSERT INTO `mx_balance` VALUES ('2393', 'sn701', '17890.00');
INSERT INTO `mx_balance` VALUES ('2394', 'sn701', '18070.00');
INSERT INTO `mx_balance` VALUES ('2395', 'sn701', '18060.00');
INSERT INTO `mx_balance` VALUES ('2396', 'sn701', '18010.00');
INSERT INTO `mx_balance` VALUES ('2397', 'sn701', '17990.00');
INSERT INTO `mx_balance` VALUES ('2398', 'sn701', '17980.00');
INSERT INTO `mx_balance` VALUES ('2399', 'sn701', '17970.00');
INSERT INTO `mx_balance` VALUES ('2400', 'sn701', '17950.00');
INSERT INTO `mx_balance` VALUES ('2401', 'sn701', '17930.00');
INSERT INTO `mx_balance` VALUES ('2402', 'sn701', '17910.00');
INSERT INTO `mx_balance` VALUES ('2403', 'sn701', '17890.00');
INSERT INTO `mx_balance` VALUES ('2404', 'sn701', '17860.00');
INSERT INTO `mx_balance` VALUES ('2405', 'sn702', '19170.00');
INSERT INTO `mx_balance` VALUES ('2406', 'sn701', '17840.00');
INSERT INTO `mx_balance` VALUES ('2407', 'sn701', '17820.00');
INSERT INTO `mx_balance` VALUES ('2408', 'sn701', '17810.00');
INSERT INTO `mx_balance` VALUES ('2409', 'sn701', '17800.00');
INSERT INTO `mx_balance` VALUES ('2410', 'sn701', '17790.00');
INSERT INTO `mx_balance` VALUES ('2411', 'sn702', '19140.00');
INSERT INTO `mx_balance` VALUES ('2412', 'sn701', '17770.00');
INSERT INTO `mx_balance` VALUES ('2413', 'sn701', '17710.00');
INSERT INTO `mx_balance` VALUES ('2414', 'sn701', '17650.00');
INSERT INTO `mx_balance` VALUES ('2415', 'sn701', '17610.00');
INSERT INTO `mx_balance` VALUES ('2416', 'sn701', '17600.00');
INSERT INTO `mx_balance` VALUES ('2417', 'sn701', '17550.00');
INSERT INTO `mx_balance` VALUES ('2418', 'sn701', '17640.00');
INSERT INTO `mx_balance` VALUES ('2419', 'sn701', '17580.00');
INSERT INTO `mx_balance` VALUES ('2420', 'sn701', '17500.00');
INSERT INTO `mx_balance` VALUES ('2421', 'sn701', '17440.00');
INSERT INTO `mx_balance` VALUES ('2422', 'sn702', '19130.00');
INSERT INTO `mx_balance` VALUES ('2423', 'sn702', '19120.00');
INSERT INTO `mx_balance` VALUES ('2424', 'sn701', '17400.00');
INSERT INTO `mx_balance` VALUES ('2425', 'sn701', '17300.00');
INSERT INTO `mx_balance` VALUES ('2426', 'sn701', '17250.00');
INSERT INTO `mx_balance` VALUES ('2427', 'sn701', '17210.00');
INSERT INTO `mx_balance` VALUES ('2428', 'sn701', '17300.00');
INSERT INTO `mx_balance` VALUES ('2429', 'sn701', '17220.00');
INSERT INTO `mx_balance` VALUES ('2430', 'sn701', '17160.00');
INSERT INTO `mx_balance` VALUES ('2431', 'sn701', '17250.00');
INSERT INTO `mx_balance` VALUES ('2432', 'sn701', '17240.00');
INSERT INTO `mx_balance` VALUES ('2433', 'sn701', '17160.00');
INSERT INTO `mx_balance` VALUES ('2434', 'sn701', '17100.00');
INSERT INTO `mx_balance` VALUES ('2435', 'sn701', '17190.00');
INSERT INTO `mx_balance` VALUES ('2436', 'sn701', '17370.00');
INSERT INTO `mx_balance` VALUES ('2437', 'sn701', '17320.00');
INSERT INTO `mx_balance` VALUES ('2438', 'sn701', '17310.00');
INSERT INTO `mx_balance` VALUES ('2439', 'sn701', '17280.00');
INSERT INTO `mx_balance` VALUES ('2440', 'sn701', '17260.00');
INSERT INTO `mx_balance` VALUES ('2441', 'sn701', '17250.00');
INSERT INTO `mx_balance` VALUES ('2442', 'sn701', '17150.00');
INSERT INTO `mx_balance` VALUES ('2443', 'sn701', '17100.00');
INSERT INTO `mx_balance` VALUES ('2444', 'sn701', '17190.00');
INSERT INTO `mx_balance` VALUES ('2445', 'sn701', '17120.00');
INSERT INTO `mx_balance` VALUES ('2446', 'sn701', '17110.00');
INSERT INTO `mx_balance` VALUES ('2447', 'sn701', '17040.00');
INSERT INTO `mx_balance` VALUES ('2448', 'sn701', '17010.00');
INSERT INTO `mx_balance` VALUES ('2449', 'sn701', '16970.00');
INSERT INTO `mx_balance` VALUES ('2450', 'sn701', '17060.00');
INSERT INTO `mx_balance` VALUES ('2451', 'sn701', '17030.00');
INSERT INTO `mx_balance` VALUES ('2452', 'sn701', '17010.00');
INSERT INTO `mx_balance` VALUES ('2453', 'sn701', '16980.00');
INSERT INTO `mx_balance` VALUES ('2454', 'sn701', '16900.00');
INSERT INTO `mx_balance` VALUES ('2455', 'sn701', '16880.00');
INSERT INTO `mx_balance` VALUES ('2456', 'sn701', '16830.00');
INSERT INTO `mx_balance` VALUES ('2457', 'sn701', '16780.00');
INSERT INTO `mx_balance` VALUES ('2458', 'sn701', '16680.00');
INSERT INTO `mx_balance` VALUES ('2459', 'sn701', '16630.00');
INSERT INTO `mx_balance` VALUES ('2460', 'sn701', '16570.00');
INSERT INTO `mx_balance` VALUES ('2461', 'sn701', '16660.00');
INSERT INTO `mx_balance` VALUES ('2462', 'sn701', '16620.00');
INSERT INTO `mx_balance` VALUES ('2463', 'sn701', '16580.00');
INSERT INTO `mx_balance` VALUES ('2464', 'sn701', '16560.00');
INSERT INTO `mx_balance` VALUES ('2465', 'sn701', '16530.00');
INSERT INTO `mx_balance` VALUES ('2466', 'sn701', '16510.00');
INSERT INTO `mx_balance` VALUES ('2467', 'sn701', '16500.00');
INSERT INTO `mx_balance` VALUES ('2468', 'sn701', '16480.00');
INSERT INTO `mx_balance` VALUES ('2469', 'sn701', '16420.00');
INSERT INTO `mx_balance` VALUES ('2470', 'sn701', '16400.00');
INSERT INTO `mx_balance` VALUES ('2471', 'sn701', '16340.00');
INSERT INTO `mx_balance` VALUES ('2472', 'sn701', '16280.00');
INSERT INTO `mx_balance` VALUES ('2473', 'sn701', '16270.00');
INSERT INTO `mx_balance` VALUES ('2474', 'sn701', '16250.00');
INSERT INTO `mx_balance` VALUES ('2475', 'sn701', '16230.00');
INSERT INTO `mx_balance` VALUES ('2476', 'sn701', '16220.00');
INSERT INTO `mx_balance` VALUES ('2477', 'sn701', '16210.00');
INSERT INTO `mx_balance` VALUES ('2478', 'sn701', '16190.00');
INSERT INTO `mx_balance` VALUES ('2479', 'sn701', '16170.00');
INSERT INTO `mx_balance` VALUES ('2480', 'sn701', '16150.00');
INSERT INTO `mx_balance` VALUES ('2481', 'sn701', '16130.00');
INSERT INTO `mx_balance` VALUES ('2482', 'sn701', '16080.00');
INSERT INTO `mx_balance` VALUES ('2483', 'sn701', '16060.00');
INSERT INTO `mx_balance` VALUES ('2484', 'sn701', '16040.00');
INSERT INTO `mx_balance` VALUES ('2485', 'sn702', '19110.00');
INSERT INTO `mx_balance` VALUES ('2486', 'sn701', '16020.00');
INSERT INTO `mx_balance` VALUES ('2487', 'sn701', '15970.00');
INSERT INTO `mx_balance` VALUES ('2488', 'sn701', '15880.00');
INSERT INTO `mx_balance` VALUES ('2489', 'sn701', '15830.00');
INSERT INTO `mx_balance` VALUES ('2490', 'sn701', '15770.00');
INSERT INTO `mx_balance` VALUES ('2491', 'sn701', '15730.00');
INSERT INTO `mx_balance` VALUES ('2492', 'sn701', '15720.00');
INSERT INTO `mx_balance` VALUES ('2493', 'sn701', '15710.00');
INSERT INTO `mx_balance` VALUES ('2494', 'sn701', '15690.00');
INSERT INTO `mx_balance` VALUES ('2495', 'sn701', '15680.00');
INSERT INTO `mx_balance` VALUES ('2496', 'sn701', '15660.00');
INSERT INTO `mx_balance` VALUES ('2497', 'sn702', '19100.00');
INSERT INTO `mx_balance` VALUES ('2498', 'sn702', '19090.00');
INSERT INTO `mx_balance` VALUES ('2499', 'sn702', '19080.00');
INSERT INTO `mx_balance` VALUES ('2500', 'sn702', '19060.00');
INSERT INTO `mx_balance` VALUES ('2501', 'sn702', '19040.00');
INSERT INTO `mx_balance` VALUES ('2502', 'sn702', '19020.00');
INSERT INTO `mx_balance` VALUES ('2503', 'sn701', '15420.00');
INSERT INTO `mx_balance` VALUES ('2504', 'sn702', '18980.00');
INSERT INTO `mx_balance` VALUES ('2505', 'sn701', '15180.00');
INSERT INTO `mx_balance` VALUES ('2506', 'sn702', '18940.00');
INSERT INTO `mx_balance` VALUES ('2507', 'sn702', '18920.00');
INSERT INTO `mx_balance` VALUES ('2508', 'sn701', '15580.00');
INSERT INTO `mx_balance` VALUES ('2509', 'sn701', '15980.00');
INSERT INTO `mx_balance` VALUES ('2510', 'sn702', '18910.00');
INSERT INTO `mx_balance` VALUES ('2511', 'sn702', '18900.00');
INSERT INTO `mx_balance` VALUES ('2512', 'sn702', '18880.00');
INSERT INTO `mx_balance` VALUES ('2513', 'sn702', '18860.00');
INSERT INTO `mx_balance` VALUES ('2514', 'sn701', '15950.00');
INSERT INTO `mx_balance` VALUES ('2515', 'sn701', '15940.00');
INSERT INTO `mx_balance` VALUES ('2516', 'sn701', '15930.00');
INSERT INTO `mx_balance` VALUES ('2517', 'sn701', '15920.00');
INSERT INTO `mx_balance` VALUES ('2518', 'sn701', '15900.00');
INSERT INTO `mx_balance` VALUES ('2519', 'sn701', '15890.00');
INSERT INTO `mx_balance` VALUES ('2520', 'sn701', '15880.00');
INSERT INTO `mx_balance` VALUES ('2521', 'sn701', '15860.00');
INSERT INTO `mx_balance` VALUES ('2522', 'sn701', '15840.00');
INSERT INTO `mx_balance` VALUES ('2523', 'sn701', '15830.00');
INSERT INTO `mx_balance` VALUES ('2524', 'sn701', '15820.00');
INSERT INTO `mx_balance` VALUES ('2525', 'sn701', '15810.00');
INSERT INTO `mx_balance` VALUES ('2526', 'sn701', '15800.00');
INSERT INTO `mx_balance` VALUES ('2527', 'sn701', '15770.00');
INSERT INTO `mx_balance` VALUES ('2528', 'sn701', '15760.00');
INSERT INTO `mx_balance` VALUES ('2529', 'sn701', '15720.00');
INSERT INTO `mx_balance` VALUES ('2530', 'sn701', '15710.00');
INSERT INTO `mx_balance` VALUES ('2531', 'sn701', '15690.00');
INSERT INTO `mx_balance` VALUES ('2532', 'sn702', '18850.00');
INSERT INTO `mx_balance` VALUES ('2533', 'sn702', '18840.00');
INSERT INTO `mx_balance` VALUES ('2534', 'sn702', '18830.00');
INSERT INTO `mx_balance` VALUES ('2535', 'sn702', '18820.00');
INSERT INTO `mx_balance` VALUES ('2536', 'sn702', '18810.00');
INSERT INTO `mx_balance` VALUES ('2537', 'sn702', '18790.00');
INSERT INTO `mx_balance` VALUES ('2538', 'sn702', '18770.00');
INSERT INTO `mx_balance` VALUES ('2539', 'sn702', '18750.00');
INSERT INTO `mx_balance` VALUES ('2540', 'sn701', '15680.00');
INSERT INTO `mx_balance` VALUES ('2541', 'sn702', '18740.00');
INSERT INTO `mx_balance` VALUES ('2542', 'sn701', '15650.00');
INSERT INTO `mx_balance` VALUES ('2543', 'sn701', '15590.00');
INSERT INTO `mx_balance` VALUES ('2544', 'sn701', '15570.00');
INSERT INTO `mx_balance` VALUES ('2545', 'sn701', '15520.00');
INSERT INTO `mx_balance` VALUES ('2546', 'sn701', '15610.00');
INSERT INTO `mx_balance` VALUES ('2547', 'sn701', '15550.00');
INSERT INTO `mx_balance` VALUES ('2548', 'sn701', '15530.00');
INSERT INTO `mx_balance` VALUES ('2549', 'sn701', '15480.00');
INSERT INTO `mx_balance` VALUES ('2550', 'sn701', '15420.00');
INSERT INTO `mx_balance` VALUES ('2551', 'sn701', '15350.00');
INSERT INTO `mx_balance` VALUES ('2552', 'sn701', '15320.00');
INSERT INTO `mx_balance` VALUES ('2553', 'sn701', '15220.00');
INSERT INTO `mx_balance` VALUES ('2554', 'sn701', '15170.00');
INSERT INTO `mx_balance` VALUES ('2555', 'sn701', '15160.00');
INSERT INTO `mx_balance` VALUES ('2556', 'sn701', '15250.00');
INSERT INTO `mx_balance` VALUES ('2557', 'sn701', '15340.00');
INSERT INTO `mx_balance` VALUES ('2558', 'sn702', '18720.00');
INSERT INTO `mx_balance` VALUES ('2559', 'sn702', '18700.00');
INSERT INTO `mx_balance` VALUES ('2560', 'sn701', '15240.00');
INSERT INTO `mx_balance` VALUES ('2561', 'sn702', '18680.00');
INSERT INTO `mx_balance` VALUES ('2562', 'sn701', '15180.00');
INSERT INTO `mx_balance` VALUES ('2563', 'sn701', '15140.00');
INSERT INTO `mx_balance` VALUES ('2564', 'sn701', '15130.00');
INSERT INTO `mx_balance` VALUES ('2565', 'sn702', '18670.00');
INSERT INTO `mx_balance` VALUES ('2566', 'sn701', '15110.00');
INSERT INTO `mx_balance` VALUES ('2567', 'sn701', '15070.00');
INSERT INTO `mx_balance` VALUES ('2568', 'sn701', '15030.00');
INSERT INTO `mx_balance` VALUES ('2569', 'sn702', '18660.00');
INSERT INTO `mx_balance` VALUES ('2570', 'sn701', '15020.00');
INSERT INTO `mx_balance` VALUES ('2571', 'sn701', '15000.00');
INSERT INTO `mx_balance` VALUES ('2572', 'sn701', '14990.00');
INSERT INTO `mx_balance` VALUES ('2573', 'sn701', '14930.00');
INSERT INTO `mx_balance` VALUES ('2574', 'sn702', '18560.00');
INSERT INTO `mx_balance` VALUES ('2575', 'sn702', '18360.00');
INSERT INTO `mx_balance` VALUES ('2576', 'sn701', '14920.00');
INSERT INTO `mx_balance` VALUES ('2577', 'sn702', '18060.00');
INSERT INTO `mx_balance` VALUES ('2578', 'sn701', '14820.00');
INSERT INTO `mx_balance` VALUES ('2579', 'sn701', '14720.00');
INSERT INTO `mx_balance` VALUES ('2580', 'sn702', '18000.00');
INSERT INTO `mx_balance` VALUES ('2581', 'sn701', '14680.00');
INSERT INTO `mx_balance` VALUES ('2582', 'sn701', '14420.00');
INSERT INTO `mx_balance` VALUES ('2583', 'sn701', '14120.00');
INSERT INTO `mx_balance` VALUES ('2584', 'sn701', '13840.00');
INSERT INTO `mx_balance` VALUES ('2585', 'sn701', '13930.00');
INSERT INTO `mx_balance` VALUES ('2586', 'sn701', '14110.00');
INSERT INTO `mx_balance` VALUES ('2587', 'sn701', '14290.00');
INSERT INTO `mx_balance` VALUES ('2588', 'sn702', '17980.00');
INSERT INTO `mx_balance` VALUES ('2589', 'sn701', '14170.00');
INSERT INTO `mx_balance` VALUES ('2590', 'sn701', '14050.00');
INSERT INTO `mx_balance` VALUES ('2591', 'sn701', '14250.00');
INSERT INTO `mx_balance` VALUES ('2592', 'sn701', '14450.00');
INSERT INTO `mx_balance` VALUES ('2593', 'sn702', '17940.00');
INSERT INTO `mx_balance` VALUES ('2594', 'sn701', '14440.00');
INSERT INTO `mx_balance` VALUES ('2595', 'sn702', '17920.00');
INSERT INTO `mx_balance` VALUES ('2596', 'sn701', '14410.00');
INSERT INTO `mx_balance` VALUES ('2597', 'sn701', '14390.00');
INSERT INTO `mx_balance` VALUES ('2598', 'sn701', '14350.00');
INSERT INTO `mx_balance` VALUES ('2599', 'sn701', '14140.00');
INSERT INTO `mx_balance` VALUES ('2600', 'sn701', '14130.00');
INSERT INTO `mx_balance` VALUES ('2601', 'sn701', '14070.00');
INSERT INTO `mx_balance` VALUES ('2602', 'sn701', '14050.00');
INSERT INTO `mx_balance` VALUES ('2603', 'sn701', '14030.00');
INSERT INTO `mx_balance` VALUES ('2604', 'sn701', '14120.00');
INSERT INTO `mx_balance` VALUES ('2605', 'sn701', '14080.00');
INSERT INTO `mx_balance` VALUES ('2606', 'sn701', '14070.00');
INSERT INTO `mx_balance` VALUES ('2607', 'sn701', '14060.00');
INSERT INTO `mx_balance` VALUES ('2608', 'sn702', '17900.00');
INSERT INTO `mx_balance` VALUES ('2609', 'sn702', '17880.00');
INSERT INTO `mx_balance` VALUES ('2610', 'sn702', '17780.00');
INSERT INTO `mx_balance` VALUES ('2611', 'sn701', '14030.00');
INSERT INTO `mx_balance` VALUES ('2612', 'sn701', '14000.00');
INSERT INTO `mx_balance` VALUES ('2613', 'sn701', '13990.00');
INSERT INTO `mx_balance` VALUES ('2614', 'sn701', '13970.00');
INSERT INTO `mx_balance` VALUES ('2615', 'sn702', '17720.00');
INSERT INTO `mx_balance` VALUES ('2616', 'sn701', '13950.00');
INSERT INTO `mx_balance` VALUES ('2617', 'sn701', '13910.00');
INSERT INTO `mx_balance` VALUES ('2618', 'sn701', '13870.00');
INSERT INTO `mx_balance` VALUES ('2619', 'sn701', '13830.00');
INSERT INTO `mx_balance` VALUES ('2620', 'sn701', '13820.00');
INSERT INTO `mx_balance` VALUES ('2621', 'sn701', '13790.00');
INSERT INTO `mx_balance` VALUES ('2622', 'sn701', '13770.00');
INSERT INTO `mx_balance` VALUES ('2623', 'sn701', '13750.00');
INSERT INTO `mx_balance` VALUES ('2624', 'sn701', '13730.00');
INSERT INTO `mx_balance` VALUES ('2625', 'sn701', '13680.00');
INSERT INTO `mx_balance` VALUES ('2626', 'sn701', '13670.00');
INSERT INTO `mx_balance` VALUES ('2627', 'sn701', '13650.00');
INSERT INTO `mx_balance` VALUES ('2628', 'sn701', '13630.00');
INSERT INTO `mx_balance` VALUES ('2629', 'sn701', '13610.00');
INSERT INTO `mx_balance` VALUES ('2630', 'sn701', '13570.00');
INSERT INTO `mx_balance` VALUES ('2631', 'sn702', '17690.00');
INSERT INTO `mx_balance` VALUES ('2632', 'sn702', '17630.00');
INSERT INTO `mx_balance` VALUES ('2633', 'sn702', '17620.00');
INSERT INTO `mx_balance` VALUES ('2634', 'sn702', '17610.00');
INSERT INTO `mx_balance` VALUES ('2635', 'sn702', '17570.00');
INSERT INTO `mx_balance` VALUES ('2636', 'sn702', '17530.00');
INSERT INTO `mx_balance` VALUES ('2637', 'sn702', '17510.00');
INSERT INTO `mx_balance` VALUES ('2638', 'sn702', '17500.00');
INSERT INTO `mx_balance` VALUES ('2639', 'sn702', '17490.00');
INSERT INTO `mx_balance` VALUES ('2640', 'sn702', '17480.00');
INSERT INTO `mx_balance` VALUES ('2641', 'sn702', '17460.00');
INSERT INTO `mx_balance` VALUES ('2642', 'sn702', '17440.00');
INSERT INTO `mx_balance` VALUES ('2643', 'sn702', '17400.00');
INSERT INTO `mx_balance` VALUES ('2644', 'sn702', '17360.00');
INSERT INTO `mx_balance` VALUES ('2645', 'sn702', '17310.00');
INSERT INTO `mx_balance` VALUES ('2646', 'sn702', '17300.00');
INSERT INTO `mx_balance` VALUES ('2647', 'sn702', '17290.00');
INSERT INTO `mx_balance` VALUES ('2648', 'sn702', '17280.00');
INSERT INTO `mx_balance` VALUES ('2649', 'sn701', '13470.00');
INSERT INTO `mx_balance` VALUES ('2650', 'sn701', '13370.00');
INSERT INTO `mx_balance` VALUES ('2651', 'sn701', '13340.00');
INSERT INTO `mx_balance` VALUES ('2652', 'sn702', '17180.00');
INSERT INTO `mx_balance` VALUES ('2653', 'sn702', '17170.00');
INSERT INTO `mx_balance` VALUES ('2654', 'sn701', '13140.00');
INSERT INTO `mx_balance` VALUES ('2655', 'sn701', '13130.00');
INSERT INTO `mx_balance` VALUES ('2656', 'sn701', '13080.00');
INSERT INTO `mx_balance` VALUES ('2657', 'sn701', '13030.00');
INSERT INTO `mx_balance` VALUES ('2658', 'sn701', '12930.00');
INSERT INTO `mx_balance` VALUES ('2659', 'sn701', '12910.00');
INSERT INTO `mx_balance` VALUES ('2660', 'sn701', '12810.00');
INSERT INTO `mx_balance` VALUES ('2661', 'sn701', '12800.00');
INSERT INTO `mx_balance` VALUES ('2662', 'sn702', '17160.00');
INSERT INTO `mx_balance` VALUES ('2663', 'sn701', '12500.00');
INSERT INTO `mx_balance` VALUES ('2664', 'sn701', '12600.00');
INSERT INTO `mx_balance` VALUES ('2665', 'sn701', '11900.00');
INSERT INTO `mx_balance` VALUES ('2666', 'sn701', '12400.00');
INSERT INTO `mx_balance` VALUES ('2667', 'sn701', '12900.00');
INSERT INTO `mx_balance` VALUES ('2668', 'sn701', '12890.00');
INSERT INTO `mx_balance` VALUES ('2669', 'sn702', '17150.00');
INSERT INTO `mx_balance` VALUES ('2670', 'sn702', '17050.00');
INSERT INTO `mx_balance` VALUES ('2671', 'sn701', '12880.00');
INSERT INTO `mx_balance` VALUES ('2672', 'sn701', '12780.00');
INSERT INTO `mx_balance` VALUES ('2673', 'sn701', '12740.00');
INSERT INTO `mx_balance` VALUES ('2674', 'sn701', '12710.00');
INSERT INTO `mx_balance` VALUES ('2675', 'sn701', '12680.00');
INSERT INTO `mx_balance` VALUES ('2676', 'sn701', '12770.00');
INSERT INTO `mx_balance` VALUES ('2677', 'sn701', '12860.00');
INSERT INTO `mx_balance` VALUES ('2678', 'sn702', '17030.00');
INSERT INTO `mx_balance` VALUES ('2679', 'sn702', '17020.00');
INSERT INTO `mx_balance` VALUES ('2680', 'sn701', '12850.00');
INSERT INTO `mx_balance` VALUES ('2681', 'sn701', '12700.00');
INSERT INTO `mx_balance` VALUES ('2682', 'sn701', '12680.00');
INSERT INTO `mx_balance` VALUES ('2683', 'sn701', '12640.00');
INSERT INTO `mx_balance` VALUES ('2684', 'sn701', '12540.00');
INSERT INTO `mx_balance` VALUES ('2685', 'sn701', '12510.00');
INSERT INTO `mx_balance` VALUES ('2686', 'sn701', '12410.00');
INSERT INTO `mx_balance` VALUES ('2687', 'sn701', '12390.00');
INSERT INTO `mx_balance` VALUES ('2688', 'sn701', '12360.00');
INSERT INTO `mx_balance` VALUES ('2689', 'sn702', '16980.00');
INSERT INTO `mx_balance` VALUES ('2690', 'sn701', '12320.00');
INSERT INTO `mx_balance` VALUES ('2691', 'sn701', '12290.00');
INSERT INTO `mx_balance` VALUES ('2692', 'sn702', '16930.00');
INSERT INTO `mx_balance` VALUES ('2693', 'sn701', '12260.00');
INSERT INTO `mx_balance` VALUES ('2694', 'sn701', '12200.00');
INSERT INTO `mx_balance` VALUES ('2695', 'sn702', '16830.00');
INSERT INTO `mx_balance` VALUES ('2696', 'sn701', '12140.00');
INSERT INTO `mx_balance` VALUES ('2697', 'sn701', '12120.00');
INSERT INTO `mx_balance` VALUES ('2698', 'sn701', '12080.00');
INSERT INTO `mx_balance` VALUES ('2699', 'sn702', '16630.00');
INSERT INTO `mx_balance` VALUES ('2700', 'sn701', '11980.00');
INSERT INTO `mx_balance` VALUES ('2701', 'sn701', '11880.00');
INSERT INTO `mx_balance` VALUES ('2702', 'sn701', '11780.00');
INSERT INTO `mx_balance` VALUES ('2703', 'sn701', '11760.00');
INSERT INTO `mx_balance` VALUES ('2704', 'sn701', '11690.00');
INSERT INTO `mx_balance` VALUES ('2705', 'sn701', '11680.00');
INSERT INTO `mx_balance` VALUES ('2706', 'sn701', '11660.00');
INSERT INTO `mx_balance` VALUES ('2707', 'sn701', '11640.00');
INSERT INTO `mx_balance` VALUES ('2708', 'sn701', '11460.00');
INSERT INTO `mx_balance` VALUES ('2709', 'sn701', '11280.00');
INSERT INTO `mx_balance` VALUES ('2710', 'sn701', '11580.00');
INSERT INTO `mx_balance` VALUES ('2711', 'sn701', '11880.00');
INSERT INTO `mx_balance` VALUES ('2712', 'sn702', '16530.00');
INSERT INTO `mx_balance` VALUES ('2713', 'sn701', '11860.00');
INSERT INTO `mx_balance` VALUES ('2714', 'sn701', '11830.00');
INSERT INTO `mx_balance` VALUES ('2715', 'sn701', '11820.00');
INSERT INTO `mx_balance` VALUES ('2716', 'sn701', '11780.00');
INSERT INTO `mx_balance` VALUES ('2717', 'sn701', '11740.00');
INSERT INTO `mx_balance` VALUES ('2718', 'sn701', '11710.00');
INSERT INTO `mx_balance` VALUES ('2719', 'sn701', '11700.00');
INSERT INTO `mx_balance` VALUES ('2720', 'sn701', '11670.00');
INSERT INTO `mx_balance` VALUES ('2721', 'sn701', '11640.00');
INSERT INTO `mx_balance` VALUES ('2722', 'sn701', '11620.00');
INSERT INTO `mx_balance` VALUES ('2723', 'sn701', '11590.00');
INSERT INTO `mx_balance` VALUES ('2724', 'sn701', '11580.00');
INSERT INTO `mx_balance` VALUES ('2725', 'sn701', '11560.00');
INSERT INTO `mx_balance` VALUES ('2726', 'sn701', '11510.00');
INSERT INTO `mx_balance` VALUES ('2727', 'sn701', '11460.00');
INSERT INTO `mx_balance` VALUES ('2728', 'sn701', '11430.00');
INSERT INTO `mx_balance` VALUES ('2729', 'expert132', '1380.00');
INSERT INTO `mx_balance` VALUES ('2730', 'sn701', '11370.00');
INSERT INTO `mx_balance` VALUES ('2731', 'sn701', '11360.00');
INSERT INTO `mx_balance` VALUES ('2732', 'sn701', '11350.00');
INSERT INTO `mx_balance` VALUES ('2733', 'expert132', '1334.00');
INSERT INTO `mx_balance` VALUES ('2734', 'expert132', '1315.60');
INSERT INTO `mx_balance` VALUES ('2735', 'expert132', '1297.20');
INSERT INTO `mx_balance` VALUES ('2736', 'expert132', '1278.80');
INSERT INTO `mx_balance` VALUES ('2737', 'expert132', '1260.40');
INSERT INTO `mx_balance` VALUES ('2738', 'expert132', '1242.00');
INSERT INTO `mx_balance` VALUES ('2739', 'expert132', '1186.80');
INSERT INTO `mx_balance` VALUES ('2740', 'sn702', '16510.00');
INSERT INTO `mx_balance` VALUES ('2741', 'sn702', '16460.00');
INSERT INTO `mx_balance` VALUES ('2742', 'sn702', '16410.00');
INSERT INTO `mx_balance` VALUES ('2743', 'expert132', '1159.20');
INSERT INTO `mx_balance` VALUES ('2744', 'expert132', '1131.60');
INSERT INTO `mx_balance` VALUES ('2745', 'expert132', '1104.00');
INSERT INTO `mx_balance` VALUES ('2746', 'expert132', '1076.40');
INSERT INTO `mx_balance` VALUES ('2747', 'expert132', '1048.80');
INSERT INTO `mx_balance` VALUES ('2748', 'sn701', '11320.00');
INSERT INTO `mx_balance` VALUES ('2749', 'sn702', '16360.00');
INSERT INTO `mx_balance` VALUES ('2750', 'sn701', '11300.00');
INSERT INTO `mx_balance` VALUES ('2751', 'sn701', '11180.00');
INSERT INTO `mx_balance` VALUES ('2752', 'sn701', '11060.00');
INSERT INTO `mx_balance` VALUES ('2753', 'sn701', '11050.00');
INSERT INTO `mx_balance` VALUES ('2754', 'sn701', '11040.00');
INSERT INTO `mx_balance` VALUES ('2755', 'sn702', '16330.00');
INSERT INTO `mx_balance` VALUES ('2756', 'sn702', '16320.00');
INSERT INTO `mx_balance` VALUES ('2757', 'sn701', '11010.00');
INSERT INTO `mx_balance` VALUES ('2758', 'sn701', '10960.00');
INSERT INTO `mx_balance` VALUES ('2759', 'sn701', '10950.00');
INSERT INTO `mx_balance` VALUES ('2760', 'sn701', '10910.00');
INSERT INTO `mx_balance` VALUES ('2761', 'sn701', '10870.00');
INSERT INTO `mx_balance` VALUES ('2762', 'sn701', '10860.00');
INSERT INTO `mx_balance` VALUES ('2763', 'sn701', '10770.00');
INSERT INTO `mx_balance` VALUES ('2764', 'sn701', '10760.00');
INSERT INTO `mx_balance` VALUES ('2765', 'sn701', '10750.00');
INSERT INTO `mx_balance` VALUES ('2766', 'sn702', '16310.00');
INSERT INTO `mx_balance` VALUES ('2767', 'sn701', '10740.00');
INSERT INTO `mx_balance` VALUES ('2768', 'expert132', '993.60');
INSERT INTO `mx_balance` VALUES ('2769', 'expert132', '947.60');
INSERT INTO `mx_balance` VALUES ('2770', 'expert132', '892.40');
INSERT INTO `mx_balance` VALUES ('2771', 'expert132', '846.40');
INSERT INTO `mx_balance` VALUES ('2772', 'expert132', '796.40');
INSERT INTO `mx_balance` VALUES ('2773', 'expert132', '746.40');
INSERT INTO `mx_balance` VALUES ('2774', 'expert132', '696.40');
INSERT INTO `mx_balance` VALUES ('2775', 'expert132', '646.40');
INSERT INTO `mx_balance` VALUES ('2776', 'expert132', '596.40');
INSERT INTO `mx_balance` VALUES ('2777', 'expert132', '546.40');
INSERT INTO `mx_balance` VALUES ('2778', 'expert132', '496.40');
INSERT INTO `mx_balance` VALUES ('2779', 'expert132', '446.40');
INSERT INTO `mx_balance` VALUES ('2780', 'expert132', '400.40');
INSERT INTO `mx_balance` VALUES ('2781', 'sn701', '10690.00');
INSERT INTO `mx_balance` VALUES ('2782', 'sn701', '10680.00');
INSERT INTO `mx_balance` VALUES ('2783', 'sn701', '10670.00');
INSERT INTO `mx_balance` VALUES ('2784', 'sn701', '10660.00');
INSERT INTO `mx_balance` VALUES ('2785', 'sn701', '10650.00');
INSERT INTO `mx_balance` VALUES ('2786', 'sn701', '10630.00');
INSERT INTO `mx_balance` VALUES ('2787', 'sn701', '10610.00');
INSERT INTO `mx_balance` VALUES ('2788', 'sn702', '16250.00');
INSERT INTO `mx_balance` VALUES ('2789', 'sn702', '16210.00');
INSERT INTO `mx_balance` VALUES ('2790', 'sn702', '16190.00');
INSERT INTO `mx_balance` VALUES ('2791', 'sn702', '16150.00');
INSERT INTO `mx_balance` VALUES ('2792', 'sn702', '16130.00');
INSERT INTO `mx_balance` VALUES ('2793', 'sn702', '16110.00');
INSERT INTO `mx_balance` VALUES ('2794', 'sn702', '16070.00');
INSERT INTO `mx_balance` VALUES ('2795', 'sn702', '16030.00');
INSERT INTO `mx_balance` VALUES ('2796', 'sn702', '16010.00');
INSERT INTO `mx_balance` VALUES ('2797', 'sn701', '10360.00');
INSERT INTO `mx_balance` VALUES ('2798', 'sn702', '15980.00');
INSERT INTO `mx_balance` VALUES ('2799', 'sn701', '10310.00');
INSERT INTO `mx_balance` VALUES ('2800', 'sn701', '10190.00');
INSERT INTO `mx_balance` VALUES ('2801', 'sn701', '10070.00');
INSERT INTO `mx_balance` VALUES ('2802', 'sn701', '10270.00');
INSERT INTO `mx_balance` VALUES ('2803', 'sn701', '10470.00');
INSERT INTO `mx_balance` VALUES ('2804', 'sn701', '10460.00');
INSERT INTO `mx_balance` VALUES ('2805', 'sn701', '10440.00');
INSERT INTO `mx_balance` VALUES ('2806', 'sn701', '10430.00');
INSERT INTO `mx_balance` VALUES ('2807', 'sn701', '10380.00');
INSERT INTO `mx_balance` VALUES ('2808', 'sn701', '10360.00');
INSERT INTO `mx_balance` VALUES ('2809', 'sn701', '10350.00');
INSERT INTO `mx_balance` VALUES ('2810', 'sn701', '10290.00');
INSERT INTO `mx_balance` VALUES ('2811', 'sn701', '10230.00');
INSERT INTO `mx_balance` VALUES ('2812', 'sn701', '10170.00');
INSERT INTO `mx_balance` VALUES ('2813', 'sn701', '10160.00');
INSERT INTO `mx_balance` VALUES ('2814', 'sn701', '10150.00');
INSERT INTO `mx_balance` VALUES ('2815', 'sn701', '10140.00');
INSERT INTO `mx_balance` VALUES ('2816', 'sn701', '10110.00');
INSERT INTO `mx_balance` VALUES ('2817', 'sn701', '10010.00');
INSERT INTO `mx_balance` VALUES ('2818', 'sn701', '9980.00');
INSERT INTO `mx_balance` VALUES ('2819', 'sn701', '9960.00');
INSERT INTO `mx_balance` VALUES ('2820', 'sn701', '9940.00');
INSERT INTO `mx_balance` VALUES ('2821', 'sn701', '9840.00');
INSERT INTO `mx_balance` VALUES ('2822', 'sn702', '15830.00');
INSERT INTO `mx_balance` VALUES ('2823', 'sn701', '9790.00');
INSERT INTO `mx_balance` VALUES ('2824', 'sn701', '9880.00');
INSERT INTO `mx_balance` VALUES ('2825', 'sn702', '15780.00');
INSERT INTO `mx_balance` VALUES ('2826', 'sn701', '9830.00');
INSERT INTO `mx_balance` VALUES ('2827', 'sn701', '9820.00');
INSERT INTO `mx_balance` VALUES ('2828', 'sn702', '15760.00');
INSERT INTO `mx_balance` VALUES ('2829', 'sn702', '15720.00');
INSERT INTO `mx_balance` VALUES ('2830', 'sn702', '15680.00');
INSERT INTO `mx_balance` VALUES ('2831', 'sn702', '15580.00');
INSERT INTO `mx_balance` VALUES ('2832', 'sn701', '9800.00');
INSERT INTO `mx_balance` VALUES ('2833', 'sn701', '9780.00');
INSERT INTO `mx_balance` VALUES ('2834', 'sn701', '9760.00');
INSERT INTO `mx_balance` VALUES ('2835', 'sn701', '9740.00');
INSERT INTO `mx_balance` VALUES ('2836', 'sn701', '9720.00');
INSERT INTO `mx_balance` VALUES ('2837', 'sn701', '9710.00');
INSERT INTO `mx_balance` VALUES ('2838', 'sn701', '9700.00');
INSERT INTO `mx_balance` VALUES ('2839', 'sn701', '9690.00');
INSERT INTO `mx_balance` VALUES ('2840', 'sn701', '9670.00');
INSERT INTO `mx_balance` VALUES ('2841', 'sn701', '9660.00');
INSERT INTO `mx_balance` VALUES ('2842', 'sn701', '9640.00');
INSERT INTO `mx_balance` VALUES ('2843', 'sn701', '9600.00');
INSERT INTO `mx_balance` VALUES ('2844', 'sn701', '9570.00');
INSERT INTO `mx_balance` VALUES ('2845', 'sn701', '9560.00');
INSERT INTO `mx_balance` VALUES ('2846', 'sn701', '9510.00');
INSERT INTO `mx_balance` VALUES ('2847', 'sn701', '9500.00');
INSERT INTO `mx_balance` VALUES ('2848', 'sn701', '9480.00');
INSERT INTO `mx_balance` VALUES ('2849', 'sn701', '9440.00');
INSERT INTO `mx_balance` VALUES ('2850', 'sn701', '9410.00');
INSERT INTO `mx_balance` VALUES ('2851', 'sn701', '9380.00');
INSERT INTO `mx_balance` VALUES ('2852', 'sn701', '9280.00');
INSERT INTO `mx_balance` VALUES ('2853', 'sn701', '9240.00');
INSERT INTO `mx_balance` VALUES ('2854', 'sn701', '9230.00');
INSERT INTO `mx_balance` VALUES ('2855', 'sn701', '9200.00');
INSERT INTO `mx_balance` VALUES ('2856', 'sn701', '9180.00');
INSERT INTO `mx_balance` VALUES ('2857', 'sn701', '9150.00');
INSERT INTO `mx_balance` VALUES ('2858', 'sn701', '9130.00');
INSERT INTO `mx_balance` VALUES ('2859', 'sn701', '9110.00');
INSERT INTO `mx_balance` VALUES ('2860', 'sn701', '9090.00');
INSERT INTO `mx_balance` VALUES ('2861', 'sn701', '9080.00');
INSERT INTO `mx_balance` VALUES ('2862', 'sn701', '9070.00');
INSERT INTO `mx_balance` VALUES ('2863', 'sn702', '15560.00');
INSERT INTO `mx_balance` VALUES ('2864', 'sn701', '8970.00');
INSERT INTO `mx_balance` VALUES ('2865', 'sn702', '15540.00');
INSERT INTO `mx_balance` VALUES ('2866', 'sn702', '15520.00');
INSERT INTO `mx_balance` VALUES ('2867', 'sn702', '15480.00');
INSERT INTO `mx_balance` VALUES ('2868', 'sn702', '15420.00');
INSERT INTO `mx_balance` VALUES ('2869', 'sn702', '15400.00');
INSERT INTO `mx_balance` VALUES ('2870', 'sn702', '15350.00');
INSERT INTO `mx_balance` VALUES ('2871', 'sn701', '8950.00');
INSERT INTO `mx_balance` VALUES ('2872', 'sn701', '8930.00');
INSERT INTO `mx_balance` VALUES ('2873', 'sn702', '15300.00');
INSERT INTO `mx_balance` VALUES ('2874', 'sn701', '8910.00');
INSERT INTO `mx_balance` VALUES ('2875', 'sn702', '15280.00');
INSERT INTO `mx_balance` VALUES ('2876', 'sn701', '8870.00');
INSERT INTO `mx_balance` VALUES ('2877', 'sn702', '15230.00');
INSERT INTO `mx_balance` VALUES ('2878', 'sn702', '15190.00');
INSERT INTO `mx_balance` VALUES ('2879', 'sn702', '15130.00');
INSERT INTO `mx_balance` VALUES ('2880', 'expert132', '372.80');
INSERT INTO `mx_balance` VALUES ('2881', 'sn701', '8860.00');
INSERT INTO `mx_balance` VALUES ('2882', 'sn701', '8840.00');
INSERT INTO `mx_balance` VALUES ('2883', 'sn701', '8830.00');
INSERT INTO `mx_balance` VALUES ('2884', 'sn701', '8810.00');
INSERT INTO `mx_balance` VALUES ('2885', 'sn701', '8800.00');
INSERT INTO `mx_balance` VALUES ('2886', 'sn701', '8790.00');
INSERT INTO `mx_balance` VALUES ('2887', 'sn701', '8770.00');
INSERT INTO `mx_balance` VALUES ('2888', 'sn702', '15050.00');
INSERT INTO `mx_balance` VALUES ('2889', 'sn702', '15030.00');
INSERT INTO `mx_balance` VALUES ('2890', 'sn702', '14950.00');
INSERT INTO `mx_balance` VALUES ('2891', 'sn702', '14930.00');
INSERT INTO `mx_balance` VALUES ('2892', 'sn701', '8760.00');
INSERT INTO `mx_balance` VALUES ('2893', 'sn701', '8640.00');
INSERT INTO `mx_balance` VALUES ('2894', 'sn702', '14920.00');
INSERT INTO `mx_balance` VALUES ('2895', 'sn702', '14890.00');
INSERT INTO `mx_balance` VALUES ('2896', 'sn702', '14850.00');
INSERT INTO `mx_balance` VALUES ('2897', 'sn702', '14840.00');
INSERT INTO `mx_balance` VALUES ('2898', 'sn702', '14800.00');
INSERT INTO `mx_balance` VALUES ('2899', 'sn702', '14780.00');
INSERT INTO `mx_balance` VALUES ('2900', 'sn702', '14760.00');
INSERT INTO `mx_balance` VALUES ('2901', 'sn702', '14740.00');
INSERT INTO `mx_balance` VALUES ('2902', 'expert132', '326.80');
INSERT INTO `mx_balance` VALUES ('2903', 'expert132', '280.80');
INSERT INTO `mx_balance` VALUES ('2904', 'expert132', '234.80');
INSERT INTO `mx_balance` VALUES ('2905', 'expert132', '179.60');
INSERT INTO `mx_balance` VALUES ('2906', 'expert132', '87.60');
INSERT INTO `mx_balance` VALUES ('2907', 'expert132', '41.60');
INSERT INTO `mx_balance` VALUES ('2908', 'expert132', '32.40');
INSERT INTO `mx_balance` VALUES ('2909', 'expert132', '14.00');
INSERT INTO `mx_balance` VALUES ('2910', 'expert132', '4.00');
INSERT INTO `mx_balance` VALUES ('2911', 'sn701', '8440.00');
INSERT INTO `mx_balance` VALUES ('2912', 'sn701', '8290.00');
INSERT INTO `mx_balance` VALUES ('2913', 'sn701', '8270.00');
INSERT INTO `mx_balance` VALUES ('2914', 'sn701', '8240.00');
INSERT INTO `mx_balance` VALUES ('2915', 'sn701', '8220.00');
INSERT INTO `mx_balance` VALUES ('2916', 'sn701', '8200.00');
INSERT INTO `mx_balance` VALUES ('2917', 'sn701', '8160.00');
INSERT INTO `mx_balance` VALUES ('2918', 'sn702', '14650.00');
INSERT INTO `mx_balance` VALUES ('2919', 'sn702', '14640.00');
INSERT INTO `mx_balance` VALUES ('2920', 'sn702', '14590.00');
INSERT INTO `mx_balance` VALUES ('2921', 'sn702', '14530.00');
INSERT INTO `mx_balance` VALUES ('2922', 'sn702', '14440.00');
INSERT INTO `mx_balance` VALUES ('2923', 'sn702', '14380.00');
INSERT INTO `mx_balance` VALUES ('2924', 'sn703', '10000.00');
INSERT INTO `mx_balance` VALUES ('2925', 'sn703', '10100.00');
INSERT INTO `mx_balance` VALUES ('2926', 'sn701', '8120.00');
INSERT INTO `mx_balance` VALUES ('2927', 'sn701', '8100.00');
INSERT INTO `mx_balance` VALUES ('2928', 'sn701', '8070.00');
INSERT INTO `mx_balance` VALUES ('2929', 'sn703', '10050.00');
INSERT INTO `mx_balance` VALUES ('2930', 'sn701', '8040.00');
INSERT INTO `mx_balance` VALUES ('2931', 'sn703', '10000.00');
INSERT INTO `mx_balance` VALUES ('2932', 'sn703', '9950.00');
INSERT INTO `mx_balance` VALUES ('2933', 'sn701', '8030.00');
INSERT INTO `mx_balance` VALUES ('2934', 'sn703', '9900.00');
INSERT INTO `mx_balance` VALUES ('2935', 'sn703', '9850.00');
INSERT INTO `mx_balance` VALUES ('2936', 'sn703', '9830.00');
INSERT INTO `mx_balance` VALUES ('2937', 'sn703', '9810.00');
INSERT INTO `mx_balance` VALUES ('2938', 'sn703', '9790.00');
INSERT INTO `mx_balance` VALUES ('2939', 'sn703', '10000.00');
INSERT INTO `mx_balance` VALUES ('2940', 'sn702', '14330.00');
INSERT INTO `mx_balance` VALUES ('2941', 'sn702', '14310.00');
INSERT INTO `mx_balance` VALUES ('2942', 'sn702', '14280.00');
INSERT INTO `mx_balance` VALUES ('2943', 'sn701', '7930.00');
INSERT INTO `mx_balance` VALUES ('2944', 'sn701', '7830.00');
INSERT INTO `mx_balance` VALUES ('2945', 'sn701', '7730.00');
INSERT INTO `mx_balance` VALUES ('2946', 'sn701', '7630.00');
INSERT INTO `mx_balance` VALUES ('2947', 'sn701', '7530.00');
INSERT INTO `mx_balance` VALUES ('2948', 'sn701', '7430.00');
INSERT INTO `mx_balance` VALUES ('2949', 'sn702', '14180.00');
INSERT INTO `mx_balance` VALUES ('2950', 'sn701', '7400.00');
INSERT INTO `mx_balance` VALUES ('2951', 'sn701', '7390.00');
INSERT INTO `mx_balance` VALUES ('2952', 'sn701', '7380.00');
INSERT INTO `mx_balance` VALUES ('2953', 'sn701', '7360.00');
INSERT INTO `mx_balance` VALUES ('2954', 'sn701', '7350.00');
INSERT INTO `mx_balance` VALUES ('2955', 'sn701', '7310.00');
INSERT INTO `mx_balance` VALUES ('2956', 'sn701', '7300.00');
INSERT INTO `mx_balance` VALUES ('2957', 'sn701', '7220.00');
INSERT INTO `mx_balance` VALUES ('2958', 'sn701', '7150.00');
INSERT INTO `mx_balance` VALUES ('2959', 'sn701', '7140.00');
INSERT INTO `mx_balance` VALUES ('2960', 'sn702', '14140.00');
INSERT INTO `mx_balance` VALUES ('2961', 'sn702', '14060.00');
INSERT INTO `mx_balance` VALUES ('2962', 'sn701', '7120.00');
INSERT INTO `mx_balance` VALUES ('2963', 'sn701', '7100.00');
INSERT INTO `mx_balance` VALUES ('2964', 'sn702', '13960.00');
INSERT INTO `mx_balance` VALUES ('2965', 'sn702', '13910.00');
INSERT INTO `mx_balance` VALUES ('2966', 'sn702', '13810.00');
INSERT INTO `mx_balance` VALUES ('2967', 'sn702', '13720.00');
INSERT INTO `mx_balance` VALUES ('2968', 'sn702', '13630.00');
INSERT INTO `mx_balance` VALUES ('2969', 'sn702', '13720.00');
INSERT INTO `mx_balance` VALUES ('2970', 'sn702', '13700.00');
INSERT INTO `mx_balance` VALUES ('2971', 'sn701', '7090.00');
INSERT INTO `mx_balance` VALUES ('2972', 'sn701', '7040.00');
INSERT INTO `mx_balance` VALUES ('2973', 'sn702', '13490.00');
INSERT INTO `mx_balance` VALUES ('2974', 'sn702', '13290.00');
INSERT INTO `mx_balance` VALUES ('2975', 'sn702', '13280.00');
INSERT INTO `mx_balance` VALUES ('2976', 'sn702', '13180.00');
INSERT INTO `mx_balance` VALUES ('2977', 'sn701', '7000.00');
INSERT INTO `mx_balance` VALUES ('2978', 'sn701', '6970.00');
INSERT INTO `mx_balance` VALUES ('2979', 'sn701', '6950.00');
INSERT INTO `mx_balance` VALUES ('2980', 'sn702', '13110.00');
INSERT INTO `mx_balance` VALUES ('2981', 'sn701', '6930.00');
INSERT INTO `mx_balance` VALUES ('2982', 'sn701', '6880.00');
INSERT INTO `mx_balance` VALUES ('2983', 'sn701', '6780.00');
INSERT INTO `mx_balance` VALUES ('2984', 'sn701', '6730.00');
INSERT INTO `mx_balance` VALUES ('2985', 'sn701', '6690.00');
INSERT INTO `mx_balance` VALUES ('2986', 'sn701', '6780.00');
INSERT INTO `mx_balance` VALUES ('2987', 'sn702', '13100.00');
INSERT INTO `mx_balance` VALUES ('2988', 'sn702', '13090.00');
INSERT INTO `mx_balance` VALUES ('2989', 'sn701', '6760.00');
INSERT INTO `mx_balance` VALUES ('2990', 'sn702', '13070.00');
INSERT INTO `mx_balance` VALUES ('2991', 'sn702', '13060.00');
INSERT INTO `mx_balance` VALUES ('2992', 'sn702', '13050.00');
INSERT INTO `mx_balance` VALUES ('2993', 'sn702', '13030.00');
INSERT INTO `mx_balance` VALUES ('2994', 'sn702', '13020.00');
INSERT INTO `mx_balance` VALUES ('2995', 'sn702', '13000.00');
INSERT INTO `mx_balance` VALUES ('2996', 'sn702', '12980.00');
INSERT INTO `mx_balance` VALUES ('2997', 'sn702', '12960.00');
INSERT INTO `mx_balance` VALUES ('2998', 'sn702', '12920.00');
INSERT INTO `mx_balance` VALUES ('2999', 'sn702', '12880.00');
INSERT INTO `mx_balance` VALUES ('3000', 'sn702', '12860.00');
INSERT INTO `mx_balance` VALUES ('3001', 'sn701', '6710.00');
INSERT INTO `mx_balance` VALUES ('3002', 'sn701', '6690.00');
INSERT INTO `mx_balance` VALUES ('3003', 'sn701', '6650.00');
INSERT INTO `mx_balance` VALUES ('3004', 'sn701', '6610.00');
INSERT INTO `mx_balance` VALUES ('3005', 'sn701', '6560.00');
INSERT INTO `mx_balance` VALUES ('3006', 'sn701', '6510.00');
INSERT INTO `mx_balance` VALUES ('3007', 'sn701', '6490.00');
INSERT INTO `mx_balance` VALUES ('3008', 'sn701', '6470.00');
INSERT INTO `mx_balance` VALUES ('3009', 'sn701', '6370.00');
INSERT INTO `mx_balance` VALUES ('3010', 'sn702', '12850.00');
INSERT INTO `mx_balance` VALUES ('3011', 'sn701', '6330.00');
INSERT INTO `mx_balance` VALUES ('3012', 'sn702', '12830.00');
INSERT INTO `mx_balance` VALUES ('3013', 'sn702', '12790.00');
INSERT INTO `mx_balance` VALUES ('3014', 'sn702', '12780.00');
INSERT INTO `mx_balance` VALUES ('3015', 'sn701', '6320.00');
INSERT INTO `mx_balance` VALUES ('3016', 'sn701', '6310.00');
INSERT INTO `mx_balance` VALUES ('3017', 'sn701', '6290.00');
INSERT INTO `mx_balance` VALUES ('3018', 'sn701', '6250.00');
INSERT INTO `mx_balance` VALUES ('3019', 'sn701', '6240.00');
INSERT INTO `mx_balance` VALUES ('3020', 'sn701', '6210.00');
INSERT INTO `mx_balance` VALUES ('3021', 'sn701', '6200.00');
INSERT INTO `mx_balance` VALUES ('3022', 'sn701', '6180.00');
INSERT INTO `mx_balance` VALUES ('3023', 'sn701', '6170.00');
INSERT INTO `mx_balance` VALUES ('3024', 'sn701', '6160.00');
INSERT INTO `mx_balance` VALUES ('3025', 'sn701', '6150.00');
INSERT INTO `mx_balance` VALUES ('3026', 'sn702', '12770.00');
INSERT INTO `mx_balance` VALUES ('3027', 'sn702', '12750.00');
INSERT INTO `mx_balance` VALUES ('3028', 'sn702', '12740.00');
INSERT INTO `mx_balance` VALUES ('3029', 'sn701', '6140.00');
INSERT INTO `mx_balance` VALUES ('3030', 'sn701', '6120.00');
INSERT INTO `mx_balance` VALUES ('3031', 'sn701', '6090.00');
INSERT INTO `mx_balance` VALUES ('3032', 'sn701', '6060.00');
INSERT INTO `mx_balance` VALUES ('3033', 'sn701', '5940.00');
INSERT INTO `mx_balance` VALUES ('3034', 'sn701', '5910.00');
INSERT INTO `mx_balance` VALUES ('3035', 'sn701', '5890.00');
INSERT INTO `mx_balance` VALUES ('3036', 'sn701', '5870.00');
INSERT INTO `mx_balance` VALUES ('3037', 'sn701', '5850.00');
INSERT INTO `mx_balance` VALUES ('3038', 'sn701', '5810.00');
INSERT INTO `mx_balance` VALUES ('3039', 'sn701', '5800.00');
INSERT INTO `mx_balance` VALUES ('3040', 'sn702', '12700.00');
INSERT INTO `mx_balance` VALUES ('3041', 'sn701', '5780.00');
INSERT INTO `mx_balance` VALUES ('3042', 'sn702', '12680.00');
INSERT INTO `mx_balance` VALUES ('3043', 'sn701', '5750.00');
INSERT INTO `mx_balance` VALUES ('3044', 'sn701', '5720.00');
INSERT INTO `mx_balance` VALUES ('3045', 'sn702', '12660.00');
INSERT INTO `mx_balance` VALUES ('3046', 'sn702', '12640.00');
INSERT INTO `mx_balance` VALUES ('3047', 'sn701', '5700.00');
INSERT INTO `mx_balance` VALUES ('3048', 'sn701', '5680.00');
INSERT INTO `mx_balance` VALUES ('3049', 'sn701', '5660.00');
INSERT INTO `mx_balance` VALUES ('3050', 'sn701', '5640.00');
INSERT INTO `mx_balance` VALUES ('3051', 'sn701', '5600.00');
INSERT INTO `mx_balance` VALUES ('3052', 'sn701', '5580.00');
INSERT INTO `mx_balance` VALUES ('3053', 'sn701', '5520.00');
INSERT INTO `mx_balance` VALUES ('3054', 'sn701', '5460.00');
INSERT INTO `mx_balance` VALUES ('3055', 'sn701', '5410.00');
INSERT INTO `mx_balance` VALUES ('3056', 'sn701', '5500.00');
INSERT INTO `mx_balance` VALUES ('3057', 'sn701', '5490.00');
INSERT INTO `mx_balance` VALUES ('3058', 'sn701', '5470.00');
INSERT INTO `mx_balance` VALUES ('3059', 'sn701', '5450.00');
INSERT INTO `mx_balance` VALUES ('3060', 'sn701', '5430.00');
INSERT INTO `mx_balance` VALUES ('3061', 'sn701', '5420.00');
INSERT INTO `mx_balance` VALUES ('3062', 'sn701', '5360.00');
INSERT INTO `mx_balance` VALUES ('3063', 'sn701', '5300.00');
INSERT INTO `mx_balance` VALUES ('3064', 'sn701', '5280.00');
INSERT INTO `mx_balance` VALUES ('3065', 'sn702', '12540.00');
INSERT INTO `mx_balance` VALUES ('3066', 'sn701', '5200.00');
INSERT INTO `mx_balance` VALUES ('3067', 'sn701', '5160.00');
INSERT INTO `mx_balance` VALUES ('3068', 'sn701', '5140.00');
INSERT INTO `mx_balance` VALUES ('3069', 'sn701', '5100.00');
INSERT INTO `mx_balance` VALUES ('3070', 'sn701', '5040.00');
INSERT INTO `mx_balance` VALUES ('3071', 'sn701', '5010.00');
INSERT INTO `mx_balance` VALUES ('3072', 'sn701', '4990.00');
INSERT INTO `mx_balance` VALUES ('3073', 'sn701', '4910.00');
INSERT INTO `mx_balance` VALUES ('3074', 'sn701', '4870.00');
INSERT INTO `mx_balance` VALUES ('3075', 'sn701', '4850.00');
INSERT INTO `mx_balance` VALUES ('3076', 'sn701', '4750.00');
INSERT INTO `mx_balance` VALUES ('3077', 'sn701', '4710.00');
INSERT INTO `mx_balance` VALUES ('3078', 'sn701', '4700.00');
INSERT INTO `mx_balance` VALUES ('3079', 'sn701', '4680.00');
INSERT INTO `mx_balance` VALUES ('3080', 'sn701', '4660.00');
INSERT INTO `mx_balance` VALUES ('3081', 'sn701', '4640.00');
INSERT INTO `mx_balance` VALUES ('3082', 'sn701', '4620.00');
INSERT INTO `mx_balance` VALUES ('3083', 'sn701', '4600.00');
INSERT INTO `mx_balance` VALUES ('3084', 'sn701', '4590.00');
INSERT INTO `mx_balance` VALUES ('3085', 'sn701', '4550.00');
INSERT INTO `mx_balance` VALUES ('3086', 'sn701', '4530.00');
INSERT INTO `mx_balance` VALUES ('3087', 'sn701', '4500.00');
INSERT INTO `mx_balance` VALUES ('3088', 'sn701', '4480.00');
INSERT INTO `mx_balance` VALUES ('3089', 'sn701', '4460.00');
INSERT INTO `mx_balance` VALUES ('3090', 'sn701', '4450.00');
INSERT INTO `mx_balance` VALUES ('3091', 'sn701', '4440.00');
INSERT INTO `mx_balance` VALUES ('3092', 'sn701', '4420.00');
INSERT INTO `mx_balance` VALUES ('3093', 'sn701', '4410.00');
INSERT INTO `mx_balance` VALUES ('3094', 'sn701', '4380.00');
INSERT INTO `mx_balance` VALUES ('3095', 'sn701', '4280.00');
INSERT INTO `mx_balance` VALUES ('3096', 'sn701', '4220.00');
INSERT INTO `mx_balance` VALUES ('3097', 'sn701', '4160.00');
INSERT INTO `mx_balance` VALUES ('3098', 'sn701', '4250.00');
INSERT INTO `mx_balance` VALUES ('3099', 'sn701', '4350.00');
INSERT INTO `mx_balance` VALUES ('3100', 'sn701', '4450.00');
INSERT INTO `mx_balance` VALUES ('3101', 'sn702', '12490.00');
INSERT INTO `mx_balance` VALUES ('3102', 'sn701', '4430.00');
INSERT INTO `mx_balance` VALUES ('3103', 'sn701', '4530.00');
INSERT INTO `mx_balance` VALUES ('3104', 'sn702', '12480.00');
INSERT INTO `mx_balance` VALUES ('3105', 'sn702', '12430.00');
INSERT INTO `mx_balance` VALUES ('3106', 'sn701', '4510.00');
INSERT INTO `mx_balance` VALUES ('3107', 'sn701', '4450.00');
INSERT INTO `mx_balance` VALUES ('3108', 'sn701', '4440.00');
INSERT INTO `mx_balance` VALUES ('3109', 'sn701', '4430.00');
INSERT INTO `mx_balance` VALUES ('3110', 'sn701', '4420.00');
INSERT INTO `mx_balance` VALUES ('3111', 'sn701', '4410.00');
INSERT INTO `mx_balance` VALUES ('3112', 'sn701', '4330.00');
INSERT INTO `mx_balance` VALUES ('3113', 'sn701', '4310.00');
INSERT INTO `mx_balance` VALUES ('3114', 'sn701', '4280.00');
INSERT INTO `mx_balance` VALUES ('3115', 'sn701', '4220.00');
INSERT INTO `mx_balance` VALUES ('3116', 'sn701', '4200.00');
INSERT INTO `mx_balance` VALUES ('3117', 'sn701', '4170.00');
INSERT INTO `mx_balance` VALUES ('3118', 'sn701', '4150.00');
INSERT INTO `mx_balance` VALUES ('3119', 'sn701', '4120.00');
INSERT INTO `mx_balance` VALUES ('3120', 'sn701', '4100.00');
INSERT INTO `mx_balance` VALUES ('3121', 'sn701', '4070.00');
INSERT INTO `mx_balance` VALUES ('3122', 'sn701', '4030.00');
INSERT INTO `mx_balance` VALUES ('3123', 'sn701', '3990.00');
INSERT INTO `mx_balance` VALUES ('3124', 'sn702', '12330.00');
INSERT INTO `mx_balance` VALUES ('3125', 'sn701', '3970.00');
INSERT INTO `mx_balance` VALUES ('3126', 'sn701', '3950.00');
INSERT INTO `mx_balance` VALUES ('3127', 'sn701', '3910.00');
INSERT INTO `mx_balance` VALUES ('3128', 'sn701', '3900.00');
INSERT INTO `mx_balance` VALUES ('3129', 'sn701', '3890.00');
INSERT INTO `mx_balance` VALUES ('3130', 'sn701', '3880.00');
INSERT INTO `mx_balance` VALUES ('3131', 'sn701', '3860.00');
INSERT INTO `mx_balance` VALUES ('3132', 'sn701', '3850.00');
INSERT INTO `mx_balance` VALUES ('3133', 'sn702', '12230.00');
INSERT INTO `mx_balance` VALUES ('3134', 'sn702', '12210.00');
INSERT INTO `mx_balance` VALUES ('3135', 'sn702', '12190.00');
INSERT INTO `mx_balance` VALUES ('3136', 'sn702', '12180.00');
INSERT INTO `mx_balance` VALUES ('3137', 'sn702', '12120.00');
INSERT INTO `mx_balance` VALUES ('3138', 'sn702', '12060.00');
INSERT INTO `mx_balance` VALUES ('3139', 'sn701', '3820.00');
INSERT INTO `mx_balance` VALUES ('3140', 'sn701', '3780.00');
INSERT INTO `mx_balance` VALUES ('3141', 'sn701', '3740.00');
INSERT INTO `mx_balance` VALUES ('3142', 'sn701', '3720.00');
INSERT INTO `mx_balance` VALUES ('3143', 'sn702', '12010.00');
INSERT INTO `mx_balance` VALUES ('3144', 'sn701', '3680.00');
INSERT INTO `mx_balance` VALUES ('3145', 'sn701', '3660.00');
INSERT INTO `mx_balance` VALUES ('3146', 'sn702', '11810.00');
INSERT INTO `mx_balance` VALUES ('3147', 'sn702', '11560.00');
INSERT INTO `mx_balance` VALUES ('3148', 'sn701', '3630.00');
INSERT INTO `mx_balance` VALUES ('3149', 'sn702', '11520.00');
INSERT INTO `mx_balance` VALUES ('3150', 'sn702', '11490.00');
INSERT INTO `mx_balance` VALUES ('3151', 'sn702', '11460.00');
INSERT INTO `mx_balance` VALUES ('3152', 'sn701', '3590.00');
INSERT INTO `mx_balance` VALUES ('3153', 'sn701', '3490.00');
INSERT INTO `mx_balance` VALUES ('3154', 'sn701', '3430.00');
INSERT INTO `mx_balance` VALUES ('3155', 'sn701', '3400.00');
INSERT INTO `mx_balance` VALUES ('3156', 'sn701', '3340.00');
INSERT INTO `mx_balance` VALUES ('3157', 'sn701', '3160.00');
INSERT INTO `mx_balance` VALUES ('3158', 'sn701', '3140.00');
INSERT INTO `mx_balance` VALUES ('3159', 'sn701', '2640.00');
INSERT INTO `mx_balance` VALUES ('3160', 'sn701', '2390.00');
INSERT INTO `mx_balance` VALUES ('3161', 'sn701', '2290.00');
INSERT INTO `mx_balance` VALUES ('3162', 'sn701', '2240.00');
INSERT INTO `mx_balance` VALUES ('3163', 'sn701', '1740.00');
INSERT INTO `mx_balance` VALUES ('3164', 'sn701', '1490.00');
INSERT INTO `mx_balance` VALUES ('3165', 'sn701', '21490.00');
INSERT INTO `mx_balance` VALUES ('3166', 'sn701', '21480.00');
INSERT INTO `mx_balance` VALUES ('3167', 'sn701', '20980.00');
INSERT INTO `mx_balance` VALUES ('3168', 'sn701', '20730.00');
INSERT INTO `mx_balance` VALUES ('3169', 'sn701', '20230.00');
INSERT INTO `mx_balance` VALUES ('3170', 'sn701', '19680.00');
INSERT INTO `mx_balance` VALUES ('3171', 'sn701', '19430.00');
INSERT INTO `mx_balance` VALUES ('3172', 'sn701', '17430.00');
INSERT INTO `mx_balance` VALUES ('3173', 'sn701', '16930.00');
INSERT INTO `mx_balance` VALUES ('3174', 'sn701', '17830.00');
INSERT INTO `mx_balance` VALUES ('3175', 'sn701', '18280.00');
INSERT INTO `mx_balance` VALUES ('3176', 'sn701', '18730.00');
INSERT INTO `mx_balance` VALUES ('3177', 'sn701', '19180.00');
INSERT INTO `mx_balance` VALUES ('3178', 'sn701', '19630.00');
INSERT INTO `mx_balance` VALUES ('3179', 'sn701', '19610.00');
INSERT INTO `mx_balance` VALUES ('3180', 'sn701', '19590.00');
INSERT INTO `mx_balance` VALUES ('3181', 'sn701', '19540.00');
INSERT INTO `mx_balance` VALUES ('3182', 'sn701', '19470.00');
INSERT INTO `mx_balance` VALUES ('3183', 'sn701', '19440.00');
INSERT INTO `mx_balance` VALUES ('3184', 'sn701', '19380.00');
INSERT INTO `mx_balance` VALUES ('3185', 'sn702', '11450.00');
INSERT INTO `mx_balance` VALUES ('3186', 'sn702', '11440.00');
INSERT INTO `mx_balance` VALUES ('3187', 'sn702', '11430.00');
INSERT INTO `mx_balance` VALUES ('3188', 'sn702', '11410.00');
INSERT INTO `mx_balance` VALUES ('3189', 'sn701', '19360.00');
INSERT INTO `mx_balance` VALUES ('3190', 'sn701', '19270.00');
INSERT INTO `mx_balance` VALUES ('3191', 'sn701', '19220.00');
INSERT INTO `mx_balance` VALUES ('3192', 'sn701', '19170.00');
INSERT INTO `mx_balance` VALUES ('3193', 'sn701', '19160.00');
INSERT INTO `mx_balance` VALUES ('3194', 'sn701', '19150.00');
INSERT INTO `mx_balance` VALUES ('3195', 'sn701', '19140.00');
INSERT INTO `mx_balance` VALUES ('3196', 'sn701', '19130.00');
INSERT INTO `mx_balance` VALUES ('3197', 'sn701', '19090.00');
INSERT INTO `mx_balance` VALUES ('3198', 'sn701', '19040.00');
INSERT INTO `mx_balance` VALUES ('3199', 'sn702', '11390.00');
INSERT INTO `mx_balance` VALUES ('3200', 'sn702', '11370.00');
INSERT INTO `mx_balance` VALUES ('3201', 'sn701', '19030.00');
INSERT INTO `mx_balance` VALUES ('3202', 'sn701', '18990.00');
INSERT INTO `mx_balance` VALUES ('3203', 'sn701', '18980.00');
INSERT INTO `mx_balance` VALUES ('3204', 'sn701', '18970.00');
INSERT INTO `mx_balance` VALUES ('3205', 'sn701', '18960.00');
INSERT INTO `mx_balance` VALUES ('3206', 'sn701', '18950.00');
INSERT INTO `mx_balance` VALUES ('3207', 'sn701', '18920.00');
INSERT INTO `mx_balance` VALUES ('3208', 'sn701', '18900.00');
INSERT INTO `mx_balance` VALUES ('3209', 'sn701', '18870.00');
INSERT INTO `mx_balance` VALUES ('3210', 'sn701', '18850.00');
INSERT INTO `mx_balance` VALUES ('3211', 'sn701', '18840.00');
INSERT INTO `mx_balance` VALUES ('3212', 'sn701', '18820.00');
INSERT INTO `mx_balance` VALUES ('3213', 'sn701', '18790.00');
INSERT INTO `mx_balance` VALUES ('3214', 'sn701', '18730.00');
INSERT INTO `mx_balance` VALUES ('3215', 'sn702', '11270.00');
INSERT INTO `mx_balance` VALUES ('3216', 'sn702', '11170.00');
INSERT INTO `mx_balance` VALUES ('3217', 'sn702', '11070.00');
INSERT INTO `mx_balance` VALUES ('3218', 'sn702', '11020.00');
INSERT INTO `mx_balance` VALUES ('3219', 'sn702', '10880.00');
INSERT INTO `mx_balance` VALUES ('3220', 'sn702', '11060.00');
INSERT INTO `mx_balance` VALUES ('3221', 'sn701', '18720.00');
INSERT INTO `mx_balance` VALUES ('3222', 'sn701', '18700.00');
INSERT INTO `mx_balance` VALUES ('3223', 'sn701', '18200.00');
INSERT INTO `mx_balance` VALUES ('3224', 'sn701', '17950.00');
INSERT INTO `mx_balance` VALUES ('3225', 'sn701', '17930.00');
INSERT INTO `mx_balance` VALUES ('3226', 'sn701', '17430.00');
INSERT INTO `mx_balance` VALUES ('3227', 'sn701', '17180.00');
INSERT INTO `mx_balance` VALUES ('3228', 'sn701', '16930.00');
INSERT INTO `mx_balance` VALUES ('3229', 'sn701', '16730.00');
INSERT INTO `mx_balance` VALUES ('3230', 'sn702', '10960.00');
INSERT INTO `mx_balance` VALUES ('3231', 'sn702', '10860.00');
INSERT INTO `mx_balance` VALUES ('3232', 'sn702', '10740.00');
INSERT INTO `mx_balance` VALUES ('3233', 'sn702', '10640.00');
INSERT INTO `mx_balance` VALUES ('3234', 'sn702', '10540.00');
INSERT INTO `mx_balance` VALUES ('3235', 'sn702', '10500.00');
INSERT INTO `mx_balance` VALUES ('3236', 'sn702', '10400.00');
INSERT INTO `mx_balance` VALUES ('3237', 'sn702', '10300.00');
INSERT INTO `mx_balance` VALUES ('3238', 'sn702', '10160.00');
INSERT INTO `mx_balance` VALUES ('3239', 'sn702', '10040.00');
INSERT INTO `mx_balance` VALUES ('3240', 'sn702', '10000.00');
INSERT INTO `mx_balance` VALUES ('3241', 'sn702', '10180.00');
INSERT INTO `mx_balance` VALUES ('3242', 'sn702', '10360.00');
INSERT INTO `mx_balance` VALUES ('3243', 'sn701', '17090.00');
INSERT INTO `mx_balance` VALUES ('3244', 'sn701', '17540.00');
INSERT INTO `mx_balance` VALUES ('3245', 'sn701', '17990.00');
INSERT INTO `mx_balance` VALUES ('3246', 'sn702', '10350.00');
INSERT INTO `mx_balance` VALUES ('3247', 'sn702', '10340.00');
INSERT INTO `mx_balance` VALUES ('3248', 'sn701', '17980.00');
INSERT INTO `mx_balance` VALUES ('3249', 'sn701', '17970.00');
INSERT INTO `mx_balance` VALUES ('3250', 'sn701', '17950.00');
INSERT INTO `mx_balance` VALUES ('3251', 'sn702', '10280.00');
INSERT INTO `mx_balance` VALUES ('3252', 'sn702', '10180.00');
INSERT INTO `mx_balance` VALUES ('3253', 'sn702', '9940.00');
INSERT INTO `mx_balance` VALUES ('3254', 'sn702', '10210.00');
INSERT INTO `mx_balance` VALUES ('3255', 'sn702', '10170.00');
INSERT INTO `mx_balance` VALUES ('3256', 'sn702', '10160.00');
INSERT INTO `mx_balance` VALUES ('3257', 'sn702', '10060.00');
INSERT INTO `mx_balance` VALUES ('3258', 'sn702', '9960.00');
INSERT INTO `mx_balance` VALUES ('3259', 'sn701', '17930.00');
INSERT INTO `mx_balance` VALUES ('3260', 'sn701', '17910.00');
INSERT INTO `mx_balance` VALUES ('3261', 'sn701', '17900.00');
INSERT INTO `mx_balance` VALUES ('3262', 'sn701', '17880.00');
INSERT INTO `mx_balance` VALUES ('3263', 'sn701', '17850.00');
INSERT INTO `mx_balance` VALUES ('3264', 'sn701', '17820.00');
INSERT INTO `mx_balance` VALUES ('3265', 'sn701', '17760.00');
INSERT INTO `mx_balance` VALUES ('3266', 'sn701', '17720.00');
INSERT INTO `mx_balance` VALUES ('3267', 'sn701', '17670.00');
INSERT INTO `mx_balance` VALUES ('3268', 'sn701', '17650.00');
INSERT INTO `mx_balance` VALUES ('3269', 'sn701', '17630.00');
INSERT INTO `mx_balance` VALUES ('3270', 'sn701', '17620.00');
INSERT INTO `mx_balance` VALUES ('3271', 'sn702', '9950.00');
INSERT INTO `mx_balance` VALUES ('3272', 'sn702', '9940.00');
INSERT INTO `mx_balance` VALUES ('3273', 'sn701', '17590.00');
INSERT INTO `mx_balance` VALUES ('3274', 'sn701', '17580.00');
INSERT INTO `mx_balance` VALUES ('3275', 'sn701', '17570.00');
INSERT INTO `mx_balance` VALUES ('3276', 'sn701', '17520.00');
INSERT INTO `mx_balance` VALUES ('3277', 'sn701', '17470.00');
INSERT INTO `mx_balance` VALUES ('3278', 'sn701', '17420.00');
INSERT INTO `mx_balance` VALUES ('3279', 'sn701', '17360.00');
INSERT INTO `mx_balance` VALUES ('3280', 'sn701', '17300.00');
INSERT INTO `mx_balance` VALUES ('3281', 'sn702', '9880.00');
INSERT INTO `mx_balance` VALUES ('3282', 'sn702', '9860.00');
INSERT INTO `mx_balance` VALUES ('3283', 'sn702', '9810.00');
INSERT INTO `mx_balance` VALUES ('3284', 'sn701', '17260.00');
INSERT INTO `mx_balance` VALUES ('3285', 'sn701', '17220.00');
INSERT INTO `mx_balance` VALUES ('3286', 'sn701', '17200.00');
INSERT INTO `mx_balance` VALUES ('3287', 'sn701', '17190.00');
INSERT INTO `mx_balance` VALUES ('3288', 'sn701', '17090.00');
INSERT INTO `mx_balance` VALUES ('3289', 'sn701', '16980.00');
INSERT INTO `mx_balance` VALUES ('3290', 'sn701', '16960.00');
INSERT INTO `mx_balance` VALUES ('3291', 'sn701', '16940.00');
INSERT INTO `mx_balance` VALUES ('3292', 'sn701', '16890.00');
INSERT INTO `mx_balance` VALUES ('3293', 'sn701', '16870.00');
INSERT INTO `mx_balance` VALUES ('3294', 'sn701', '16850.00');
INSERT INTO `mx_balance` VALUES ('3295', 'sn701', '16790.00');
INSERT INTO `mx_balance` VALUES ('3296', 'sn701', '16750.00');
INSERT INTO `mx_balance` VALUES ('3297', 'sn701', '16710.00');
INSERT INTO `mx_balance` VALUES ('3298', 'sn701', '16660.00');
INSERT INTO `mx_balance` VALUES ('3299', 'sn701', '16600.00');
INSERT INTO `mx_balance` VALUES ('3300', 'sn701', '16570.00');
INSERT INTO `mx_balance` VALUES ('3301', 'sn701', '16540.00');
INSERT INTO `mx_balance` VALUES ('3302', 'sn701', '16480.00');
INSERT INTO `mx_balance` VALUES ('3303', 'sn701', '16460.00');
INSERT INTO `mx_balance` VALUES ('3304', 'sn701', '16400.00');
INSERT INTO `mx_balance` VALUES ('3305', 'sn701', '16320.00');
INSERT INTO `mx_balance` VALUES ('3306', 'sn701', '16290.00');
INSERT INTO `mx_balance` VALUES ('3307', 'sn701', '16250.00');
INSERT INTO `mx_balance` VALUES ('3308', 'sn702', '9780.00');
INSERT INTO `mx_balance` VALUES ('3309', 'sn702', '9720.00');
INSERT INTO `mx_balance` VALUES ('3310', 'sn702', '9360.00');
INSERT INTO `mx_balance` VALUES ('3311', 'sn702', '9720.00');
INSERT INTO `mx_balance` VALUES ('3312', 'sn702', '9690.00');
INSERT INTO `mx_balance` VALUES ('3313', 'sn702', '9670.00');
INSERT INTO `mx_balance` VALUES ('3314', 'sn702', '9630.00');
INSERT INTO `mx_balance` VALUES ('3315', 'sn702', '9590.00');
INSERT INTO `mx_balance` VALUES ('3316', 'sn701', '16220.00');
INSERT INTO `mx_balance` VALUES ('3317', 'sn702', '9560.00');
INSERT INTO `mx_balance` VALUES ('3318', 'sn701', '16120.00');
INSERT INTO `mx_balance` VALUES ('3319', 'sn701', '16100.00');
INSERT INTO `mx_balance` VALUES ('3320', 'sn701', '16090.00');
INSERT INTO `mx_balance` VALUES ('3321', 'sn701', '16040.00');
INSERT INTO `mx_balance` VALUES ('3322', 'sn701', '15920.00');
INSERT INTO `mx_balance` VALUES ('3323', 'sn701', '16010.00');
INSERT INTO `mx_balance` VALUES ('3324', 'sn701', '15910.00');
INSERT INTO `mx_balance` VALUES ('3325', 'sn701', '15890.00');
INSERT INTO `mx_balance` VALUES ('3326', 'sn701', '15840.00');
INSERT INTO `mx_balance` VALUES ('3327', 'sn701', '15690.00');
INSERT INTO `mx_balance` VALUES ('3328', 'sn701', '15780.00');
INSERT INTO `mx_balance` VALUES ('3329', 'sn701', '15740.00');
INSERT INTO `mx_balance` VALUES ('3330', 'sn701', '15640.00');
INSERT INTO `mx_balance` VALUES ('3331', 'sn701', '15490.00');
INSERT INTO `mx_balance` VALUES ('3332', 'sn701', '15390.00');
INSERT INTO `mx_balance` VALUES ('3333', 'sn701', '15240.00');
INSERT INTO `mx_balance` VALUES ('3334', 'sn701', '15210.00');
INSERT INTO `mx_balance` VALUES ('3335', 'sn701', '15170.00');
INSERT INTO `mx_balance` VALUES ('3336', 'sn701', '15130.00');
INSERT INTO `mx_balance` VALUES ('3337', 'sn701', '15030.00');
INSERT INTO `mx_balance` VALUES ('3338', 'sn701', '15010.00');
INSERT INTO `mx_balance` VALUES ('3339', 'sn701', '14990.00');
INSERT INTO `mx_balance` VALUES ('3340', 'sn701', '14890.00');
INSERT INTO `mx_balance` VALUES ('3341', 'sn701', '14870.00');
INSERT INTO `mx_balance` VALUES ('3342', 'sn701', '14860.00');
INSERT INTO `mx_balance` VALUES ('3343', 'sn701', '14850.00');
INSERT INTO `mx_balance` VALUES ('3344', 'sn701', '14840.00');
INSERT INTO `mx_balance` VALUES ('3345', 'sn701', '14830.00');
INSERT INTO `mx_balance` VALUES ('3346', 'sn701', '14800.00');
INSERT INTO `mx_balance` VALUES ('3347', 'sn701', '14780.00');
INSERT INTO `mx_balance` VALUES ('3348', 'sn701', '14770.00');
INSERT INTO `mx_balance` VALUES ('3349', 'sn701', '14760.00');
INSERT INTO `mx_balance` VALUES ('3350', 'sn701', '14740.00');
INSERT INTO `mx_balance` VALUES ('3351', 'sn701', '14700.00');
INSERT INTO `mx_balance` VALUES ('3352', 'sn701', '14690.00');
INSERT INTO `mx_balance` VALUES ('3353', 'sn701', '14670.00');
INSERT INTO `mx_balance` VALUES ('3354', 'sn701', '14640.00');
INSERT INTO `mx_balance` VALUES ('3355', 'sn701', '14620.00');
INSERT INTO `mx_balance` VALUES ('3356', 'sn701', '14610.00');
INSERT INTO `mx_balance` VALUES ('3357', 'sn702', '9550.00');
INSERT INTO `mx_balance` VALUES ('3358', 'sn701', '14590.00');
INSERT INTO `mx_balance` VALUES ('3359', 'sn702', '9510.00');
INSERT INTO `mx_balance` VALUES ('3360', 'sn702', '9490.00');
INSERT INTO `mx_balance` VALUES ('3361', 'sn702', '9480.00');
INSERT INTO `mx_balance` VALUES ('3362', 'sn701', '14530.00');
INSERT INTO `mx_balance` VALUES ('3363', 'sn701', '14520.00');
INSERT INTO `mx_balance` VALUES ('3364', 'sn701', '14500.00');
INSERT INTO `mx_balance` VALUES ('3365', 'sn702', '9430.00');
INSERT INTO `mx_balance` VALUES ('3366', 'sn702', '9400.00');
INSERT INTO `mx_balance` VALUES ('3367', 'sn701', '14480.00');
INSERT INTO `mx_balance` VALUES ('3368', 'sn701', '14460.00');
INSERT INTO `mx_balance` VALUES ('3369', 'sn701', '14440.00');
INSERT INTO `mx_balance` VALUES ('3370', 'sn701', '14430.00');
INSERT INTO `mx_balance` VALUES ('3371', 'sn701', '14410.00');
INSERT INTO `mx_balance` VALUES ('3372', 'sn701', '14390.00');
INSERT INTO `mx_balance` VALUES ('3373', 'sn701', '14370.00');
INSERT INTO `mx_balance` VALUES ('3374', 'sn701', '14360.00');
INSERT INTO `mx_balance` VALUES ('3375', 'sn701', '14350.00');
INSERT INTO `mx_balance` VALUES ('3376', 'sn702', '9380.00');
INSERT INTO `mx_balance` VALUES ('3377', 'sn702', '9320.00');
INSERT INTO `mx_balance` VALUES ('3378', 'sn701', '14340.00');
INSERT INTO `mx_balance` VALUES ('3379', 'sn701', '14330.00');
INSERT INTO `mx_balance` VALUES ('3380', 'sn701', '14320.00');
INSERT INTO `mx_balance` VALUES ('3381', 'sn701', '14300.00');
INSERT INTO `mx_balance` VALUES ('3382', 'sn701', '14270.00');
INSERT INTO `mx_balance` VALUES ('3383', 'sn701', '14250.00');
INSERT INTO `mx_balance` VALUES ('3384', 'sn701', '14220.00');
INSERT INTO `mx_balance` VALUES ('3385', 'sn701', '14210.00');
INSERT INTO `mx_balance` VALUES ('3386', 'sn701', '14170.00');
INSERT INTO `mx_balance` VALUES ('3387', 'sn701', '14150.00');
INSERT INTO `mx_balance` VALUES ('3388', 'sn702', '9300.00');
INSERT INTO `mx_balance` VALUES ('3389', 'sn702', '9240.00');
INSERT INTO `mx_balance` VALUES ('3390', 'sn701', '14120.00');
INSERT INTO `mx_balance` VALUES ('3391', 'sn702', '9090.00');
INSERT INTO `mx_balance` VALUES ('3392', 'sn702', '8870.00');
INSERT INTO `mx_balance` VALUES ('3393', 'sn702', '8570.00');
INSERT INTO `mx_balance` VALUES ('3394', 'sn702', '9110.00');
INSERT INTO `mx_balance` VALUES ('3395', 'sn702', '9090.00');
INSERT INTO `mx_balance` VALUES ('3396', 'sn702', '9060.00');
INSERT INTO `mx_balance` VALUES ('3397', 'sn702', '9000.00');
INSERT INTO `mx_balance` VALUES ('3398', 'sn702', '8940.00');
INSERT INTO `mx_balance` VALUES ('3399', 'sn702', '8870.00');
INSERT INTO `mx_balance` VALUES ('3400', 'sn702', '8850.00');
INSERT INTO `mx_balance` VALUES ('3401', 'sn702', '8820.00');
INSERT INTO `mx_balance` VALUES ('3402', 'sn702', '8770.00');
INSERT INTO `mx_balance` VALUES ('3403', 'sn701', '14110.00');
INSERT INTO `mx_balance` VALUES ('3404', 'sn701', '14100.00');
INSERT INTO `mx_balance` VALUES ('3405', 'sn701', '14090.00');
INSERT INTO `mx_balance` VALUES ('3406', 'sn701', '14080.00');
INSERT INTO `mx_balance` VALUES ('3407', 'sn701', '14070.00');
INSERT INTO `mx_balance` VALUES ('3408', 'sn701', '14060.00');
INSERT INTO `mx_balance` VALUES ('3409', 'sn701', '14040.00');
INSERT INTO `mx_balance` VALUES ('3410', 'sn701', '14020.00');
INSERT INTO `mx_balance` VALUES ('3411', 'sn701', '14010.00');
INSERT INTO `mx_balance` VALUES ('3412', 'sn701', '14000.00');
INSERT INTO `mx_balance` VALUES ('3413', 'sn701', '13990.00');
INSERT INTO `mx_balance` VALUES ('3414', 'sn701', '13980.00');
INSERT INTO `mx_balance` VALUES ('3415', 'sn701', '13970.00');
INSERT INTO `mx_balance` VALUES ('3416', 'sn701', '13960.00');
INSERT INTO `mx_balance` VALUES ('3417', 'sn701', '13950.00');
INSERT INTO `mx_balance` VALUES ('3418', 'sn701', '13930.00');
INSERT INTO `mx_balance` VALUES ('3419', 'sn701', '13900.00');
INSERT INTO `mx_balance` VALUES ('3420', 'sn701', '13890.00');
INSERT INTO `mx_balance` VALUES ('3421', 'sn701', '13880.00');
INSERT INTO `mx_balance` VALUES ('3422', 'sn701', '13860.00');
INSERT INTO `mx_balance` VALUES ('3423', 'sn701', '13850.00');
INSERT INTO `mx_balance` VALUES ('3424', 'sn701', '13810.00');
INSERT INTO `mx_balance` VALUES ('3425', 'sn701', '13800.00');
INSERT INTO `mx_balance` VALUES ('3426', 'sn701', '13790.00');
INSERT INTO `mx_balance` VALUES ('3427', 'sn701', '13770.00');
INSERT INTO `mx_balance` VALUES ('3428', 'sn701', '13760.00');
INSERT INTO `mx_balance` VALUES ('3429', 'sn701', '13750.00');
INSERT INTO `mx_balance` VALUES ('3430', 'sn701', '13730.00');
INSERT INTO `mx_balance` VALUES ('3431', 'sn701', '13700.00');
INSERT INTO `mx_balance` VALUES ('3432', 'sn701', '13690.00');
INSERT INTO `mx_balance` VALUES ('3433', 'sn701', '13640.00');
INSERT INTO `mx_balance` VALUES ('3434', 'sn701', '13630.00');
INSERT INTO `mx_balance` VALUES ('3435', 'sn701', '13580.00');
INSERT INTO `mx_balance` VALUES ('3436', 'sn701', '13550.00');
INSERT INTO `mx_balance` VALUES ('3437', 'sn701', '13540.00');
INSERT INTO `mx_balance` VALUES ('3438', 'sn701', '13440.00');
INSERT INTO `mx_balance` VALUES ('3439', 'sn701', '13430.00');
INSERT INTO `mx_balance` VALUES ('3440', 'sn701', '13400.00');
INSERT INTO `mx_balance` VALUES ('3441', 'sn701', '13370.00');
INSERT INTO `mx_balance` VALUES ('3442', 'sn701', '13360.00');
INSERT INTO `mx_balance` VALUES ('3443', 'sn701', '13350.00');
INSERT INTO `mx_balance` VALUES ('3444', 'sn701', '13340.00');
INSERT INTO `mx_balance` VALUES ('3445', 'sn701', '13330.00');
INSERT INTO `mx_balance` VALUES ('3446', 'sn701', '13320.00');
INSERT INTO `mx_balance` VALUES ('3447', 'sn702', '8760.00');
INSERT INTO `mx_balance` VALUES ('3448', 'sn701', '13300.00');
INSERT INTO `mx_balance` VALUES ('3449', 'sn701', '13100.00');
INSERT INTO `mx_balance` VALUES ('3450', 'sn701', '13080.00');
INSERT INTO `mx_balance` VALUES ('3451', 'sn701', '13040.00');
INSERT INTO `mx_balance` VALUES ('3452', 'sn701', '13030.00');
INSERT INTO `mx_balance` VALUES ('3453', 'sn701', '12980.00');
INSERT INTO `mx_balance` VALUES ('3454', 'sn701', '12970.00');
INSERT INTO `mx_balance` VALUES ('3455', 'sn701', '12940.00');
INSERT INTO `mx_balance` VALUES ('3456', 'sn702', '8750.00');
INSERT INTO `mx_balance` VALUES ('3457', 'sn701', '12920.00');
INSERT INTO `mx_balance` VALUES ('3458', 'sn701', '12910.00');
INSERT INTO `mx_balance` VALUES ('3459', 'sn701', '12860.00');
INSERT INTO `mx_balance` VALUES ('3460', 'sn701', '12840.00');
INSERT INTO `mx_balance` VALUES ('3461', 'sn701', '12830.00');
INSERT INTO `mx_balance` VALUES ('3462', 'sn701', '12810.00');
INSERT INTO `mx_balance` VALUES ('3463', 'sn701', '12800.00');
INSERT INTO `mx_balance` VALUES ('3464', 'sn701', '12790.00');
INSERT INTO `mx_balance` VALUES ('3465', 'sn701', '12770.00');
INSERT INTO `mx_balance` VALUES ('3466', 'sn701', '12750.00');
INSERT INTO `mx_balance` VALUES ('3467', 'sn701', '12740.00');
INSERT INTO `mx_balance` VALUES ('3468', 'sn701', '12730.00');
INSERT INTO `mx_balance` VALUES ('3469', 'sn701', '12720.00');
INSERT INTO `mx_balance` VALUES ('3470', 'sn701', '12700.00');
INSERT INTO `mx_balance` VALUES ('3471', 'sn702', '8690.00');
INSERT INTO `mx_balance` VALUES ('3472', 'sn701', '12690.00');
INSERT INTO `mx_balance` VALUES ('3473', 'sn701', '12680.00');
INSERT INTO `mx_balance` VALUES ('3474', 'sn701', '12650.00');
INSERT INTO `mx_balance` VALUES ('3475', 'sn701', '12640.00');
INSERT INTO `mx_balance` VALUES ('3476', 'sn702', '8660.00');
INSERT INTO `mx_balance` VALUES ('3477', 'sn701', '12610.00');
INSERT INTO `mx_balance` VALUES ('3478', 'sn701', '12590.00');
INSERT INTO `mx_balance` VALUES ('3479', 'sn701', '12560.00');
INSERT INTO `mx_balance` VALUES ('3480', 'sn701', '12540.00');
INSERT INTO `mx_balance` VALUES ('3481', 'sn701', '12490.00');
INSERT INTO `mx_balance` VALUES ('3482', 'sn701', '12450.00');
INSERT INTO `mx_balance` VALUES ('3483', 'sn701', '12400.00');
INSERT INTO `mx_balance` VALUES ('3484', 'sn701', '12380.00');
INSERT INTO `mx_balance` VALUES ('3485', 'sn701', '12330.00');
INSERT INTO `mx_balance` VALUES ('3486', 'sn701', '12320.00');
INSERT INTO `mx_balance` VALUES ('3487', 'sn701', '12270.00');
INSERT INTO `mx_balance` VALUES ('3488', 'sn701', '12190.00');
INSERT INTO `mx_balance` VALUES ('3489', 'sn701', '12110.00');
INSERT INTO `mx_balance` VALUES ('3490', 'sn701', '12030.00');
INSERT INTO `mx_balance` VALUES ('3491', 'sn701', '12230.00');
INSERT INTO `mx_balance` VALUES ('3492', 'sn701', '12430.00');
INSERT INTO `mx_balance` VALUES ('3493', 'sn701', '12420.00');
INSERT INTO `mx_balance` VALUES ('3494', 'sn701', '12370.00');
INSERT INTO `mx_balance` VALUES ('3495', 'sn701', '12290.00');
INSERT INTO `mx_balance` VALUES ('3496', 'sn701', '12270.00');
INSERT INTO `mx_balance` VALUES ('3497', 'sn701', '12260.00');
INSERT INTO `mx_balance` VALUES ('3498', 'sn701', '12230.00');
INSERT INTO `mx_balance` VALUES ('3499', 'sn701', '12220.00');
INSERT INTO `mx_balance` VALUES ('3500', 'sn701', '12210.00');
INSERT INTO `mx_balance` VALUES ('3501', 'sn701', '12180.00');
INSERT INTO `mx_balance` VALUES ('3502', 'sn701', '12160.00');
INSERT INTO `mx_balance` VALUES ('3503', 'sn701', '12150.00');
INSERT INTO `mx_balance` VALUES ('3504', 'sn701', '12130.00');
INSERT INTO `mx_balance` VALUES ('3505', 'sn701', '12050.00');
INSERT INTO `mx_balance` VALUES ('3506', 'sn701', '12030.00');
INSERT INTO `mx_balance` VALUES ('3507', 'sn701', '12000.00');
INSERT INTO `mx_balance` VALUES ('3508', 'sn701', '11970.00');
INSERT INTO `mx_balance` VALUES ('3509', 'sn701', '11960.00');
INSERT INTO `mx_balance` VALUES ('3510', 'sn701', '11950.00');
INSERT INTO `mx_balance` VALUES ('3511', 'sn701', '11940.00');
INSERT INTO `mx_balance` VALUES ('3512', 'sn701', '11900.00');
INSERT INTO `mx_balance` VALUES ('3513', 'sn701', '11890.00');
INSERT INTO `mx_balance` VALUES ('3514', 'sn702', '8620.00');
INSERT INTO `mx_balance` VALUES ('3515', 'sn702', '8610.00');
INSERT INTO `mx_balance` VALUES ('3516', 'sn701', '11880.00');
INSERT INTO `mx_balance` VALUES ('3517', 'sn701', '12080.00');
INSERT INTO `mx_balance` VALUES ('3518', 'sn702', '8600.00');
INSERT INTO `mx_balance` VALUES ('3519', 'sn702', '8590.00');
INSERT INTO `mx_balance` VALUES ('3520', 'sn701', '12040.00');
INSERT INTO `mx_balance` VALUES ('3521', 'sn701', '12010.00');
INSERT INTO `mx_balance` VALUES ('3522', 'sn701', '12000.00');
INSERT INTO `mx_balance` VALUES ('3523', 'sn701', '11970.00');
INSERT INTO `mx_balance` VALUES ('3524', 'sn701', '11960.00');
INSERT INTO `mx_balance` VALUES ('3525', 'sn701', '11930.00');
INSERT INTO `mx_balance` VALUES ('3526', 'sn701', '11910.00');
INSERT INTO `mx_balance` VALUES ('3527', 'sn701', '11890.00');
INSERT INTO `mx_balance` VALUES ('3528', 'sn701', '11870.00');
INSERT INTO `mx_balance` VALUES ('3529', 'sn701', '11850.00');
INSERT INTO `mx_balance` VALUES ('3530', 'sn701', '11830.00');
INSERT INTO `mx_balance` VALUES ('3531', 'sn701', '11770.00');
INSERT INTO `mx_balance` VALUES ('3532', 'sn701', '11760.00');
INSERT INTO `mx_balance` VALUES ('3533', 'sn701', '11720.00');
INSERT INTO `mx_balance` VALUES ('3534', 'sn701', '11700.00');
INSERT INTO `mx_balance` VALUES ('3535', 'sn701', '11640.00');
INSERT INTO `mx_balance` VALUES ('3536', 'sn702', '8570.00');
INSERT INTO `mx_balance` VALUES ('3537', 'sn702', '8550.00');
INSERT INTO `mx_balance` VALUES ('3538', 'sn701', '11630.00');
INSERT INTO `mx_balance` VALUES ('3539', 'sn702', '8530.00');
INSERT INTO `mx_balance` VALUES ('3540', 'sn701', '11620.00');
INSERT INTO `mx_balance` VALUES ('3541', 'sn701', '11610.00');
INSERT INTO `mx_balance` VALUES ('3542', 'sn701', '11590.00');
INSERT INTO `mx_balance` VALUES ('3543', 'sn701', '11580.00');
INSERT INTO `mx_balance` VALUES ('3544', 'sn701', '11570.00');
INSERT INTO `mx_balance` VALUES ('3545', 'sn701', '11560.00');
INSERT INTO `mx_balance` VALUES ('3546', 'sn701', '11550.00');
INSERT INTO `mx_balance` VALUES ('3547', 'sn701', '11540.00');
INSERT INTO `mx_balance` VALUES ('3548', 'sn701', '11510.00');
INSERT INTO `mx_balance` VALUES ('3549', 'sn701', '11490.00');
INSERT INTO `mx_balance` VALUES ('3550', 'sn701', '11480.00');
INSERT INTO `mx_balance` VALUES ('3551', 'sn701', '11470.00');
INSERT INTO `mx_balance` VALUES ('3552', 'sn701', '11440.00');
INSERT INTO `mx_balance` VALUES ('3553', 'sn701', '11420.00');
INSERT INTO `mx_balance` VALUES ('3554', 'sn701', '11400.00');
INSERT INTO `mx_balance` VALUES ('3555', 'sn701', '11390.00');
INSERT INTO `mx_balance` VALUES ('3556', 'sn701', '11370.00');
INSERT INTO `mx_balance` VALUES ('3557', 'sn701', '11350.00');
INSERT INTO `mx_balance` VALUES ('3558', 'sn701', '11330.00');
INSERT INTO `mx_balance` VALUES ('3559', 'sn701', '11310.00');
INSERT INTO `mx_balance` VALUES ('3560', 'sn701', '11300.00');
INSERT INTO `mx_balance` VALUES ('3561', 'sn701', '11280.00');
INSERT INTO `mx_balance` VALUES ('3562', 'sn701', '11260.00');
INSERT INTO `mx_balance` VALUES ('3563', 'sn701', '11250.00');
INSERT INTO `mx_balance` VALUES ('3564', 'sn701', '11220.00');
INSERT INTO `mx_balance` VALUES ('3565', 'sn701', '11210.00');
INSERT INTO `mx_balance` VALUES ('3566', 'sn701', '11180.00');
INSERT INTO `mx_balance` VALUES ('3567', 'sn701', '11160.00');
INSERT INTO `mx_balance` VALUES ('3568', 'sn701', '11150.00');
INSERT INTO `mx_balance` VALUES ('3569', 'sn701', '11140.00');
INSERT INTO `mx_balance` VALUES ('3570', 'sn701', '11120.00');
INSERT INTO `mx_balance` VALUES ('3571', 'sn701', '11110.00');
INSERT INTO `mx_balance` VALUES ('3572', 'sn701', '11100.00');
INSERT INTO `mx_balance` VALUES ('3573', 'sn701', '11070.00');
INSERT INTO `mx_balance` VALUES ('3574', 'sn701', '11020.00');
INSERT INTO `mx_balance` VALUES ('3575', 'sn701', '11000.00');
INSERT INTO `mx_balance` VALUES ('3576', 'sn701', '10980.00');
INSERT INTO `mx_balance` VALUES ('3577', 'sn701', '10970.00');
INSERT INTO `mx_balance` VALUES ('3578', 'sn701', '10930.00');
INSERT INTO `mx_balance` VALUES ('3579', 'sn701', '10920.00');
INSERT INTO `mx_balance` VALUES ('3580', 'sn701', '10900.00');
INSERT INTO `mx_balance` VALUES ('3581', 'sn701', '10860.00');
INSERT INTO `mx_balance` VALUES ('3582', 'sn701', '10840.00');
INSERT INTO `mx_balance` VALUES ('3583', 'sn701', '10830.00');
INSERT INTO `mx_balance` VALUES ('3584', 'sn701', '10810.00');
INSERT INTO `mx_balance` VALUES ('3585', 'sn701', '10800.00');
INSERT INTO `mx_balance` VALUES ('3586', 'sn701', '10790.00');
INSERT INTO `mx_balance` VALUES ('3587', 'sn701', '10750.00');
INSERT INTO `mx_balance` VALUES ('3588', 'sn701', '10740.00');
INSERT INTO `mx_balance` VALUES ('3589', 'sn701', '10680.00');
INSERT INTO `mx_balance` VALUES ('3590', 'sn702', '8510.00');
INSERT INTO `mx_balance` VALUES ('3591', 'sn701', '10620.00');
INSERT INTO `mx_balance` VALUES ('3592', 'sn701', '10610.00');
INSERT INTO `mx_balance` VALUES ('3593', 'sn701', '10600.00');
INSERT INTO `mx_balance` VALUES ('3594', 'sn701', '10590.00');
INSERT INTO `mx_balance` VALUES ('3595', 'sn701', '10560.00');
INSERT INTO `mx_balance` VALUES ('3596', 'sn701', '10540.00');
INSERT INTO `mx_balance` VALUES ('3597', 'sn701', '10530.00');
INSERT INTO `mx_balance` VALUES ('3598', 'sn701', '10490.00');
INSERT INTO `mx_balance` VALUES ('3599', 'sn701', '10480.00');
INSERT INTO `mx_balance` VALUES ('3600', 'sn701', '10470.00');
INSERT INTO `mx_balance` VALUES ('3601', 'sn701', '10380.00');
INSERT INTO `mx_balance` VALUES ('3602', 'sn701', '10290.00');
INSERT INTO `mx_balance` VALUES ('3603', 'sn701', '10200.00');
INSERT INTO `mx_balance` VALUES ('3604', 'sn701', '10140.00');
INSERT INTO `mx_balance` VALUES ('3605', 'sn701', '10120.00');
INSERT INTO `mx_balance` VALUES ('3606', 'sn701', '10100.00');
INSERT INTO `mx_balance` VALUES ('3607', 'sn701', '10090.00');
INSERT INTO `mx_balance` VALUES ('3608', 'sn701', '10060.00');
INSERT INTO `mx_balance` VALUES ('3609', 'sn701', '10050.00');
INSERT INTO `mx_balance` VALUES ('3610', 'sn701', '10040.00');
INSERT INTO `mx_balance` VALUES ('3611', 'sn701', '10020.00');
INSERT INTO `mx_balance` VALUES ('3612', 'sn701', '10010.00');
INSERT INTO `mx_balance` VALUES ('3613', 'sn701', '9860.00');
INSERT INTO `mx_balance` VALUES ('3614', 'sn701', '9850.00');
INSERT INTO `mx_balance` VALUES ('3615', 'sn701', '9830.00');
INSERT INTO `mx_balance` VALUES ('3616', 'sn701', '9820.00');
INSERT INTO `mx_balance` VALUES ('3617', 'sn701', '9800.00');
INSERT INTO `mx_balance` VALUES ('3618', 'sn701', '9790.00');
INSERT INTO `mx_balance` VALUES ('3619', 'sn701', '9780.00');
INSERT INTO `mx_balance` VALUES ('3620', 'sn701', '9770.00');
INSERT INTO `mx_balance` VALUES ('3621', 'sn701', '9730.00');
INSERT INTO `mx_balance` VALUES ('3622', 'sn701', '9720.00');
INSERT INTO `mx_balance` VALUES ('3623', 'sn701', '9710.00');
INSERT INTO `mx_balance` VALUES ('3624', 'sn701', '9690.00');
INSERT INTO `mx_balance` VALUES ('3625', 'sn701', '9670.00');
INSERT INTO `mx_balance` VALUES ('3626', 'sn701', '9640.00');
INSERT INTO `mx_balance` VALUES ('3627', 'sn701', '9620.00');
INSERT INTO `mx_balance` VALUES ('3628', 'sn701', '9600.00');
INSERT INTO `mx_balance` VALUES ('3629', 'sn701', '9570.00');
INSERT INTO `mx_balance` VALUES ('3630', 'sn701', '9550.00');
INSERT INTO `mx_balance` VALUES ('3631', 'sn701', '9520.00');
INSERT INTO `mx_balance` VALUES ('3632', 'sn701', '9500.00');
INSERT INTO `mx_balance` VALUES ('3633', 'sn701', '9490.00');
INSERT INTO `mx_balance` VALUES ('3634', 'sn701', '9330.00');
INSERT INTO `mx_balance` VALUES ('3635', 'sn701', '9170.00');
INSERT INTO `mx_balance` VALUES ('3636', 'sn701', '9010.00');
INSERT INTO `mx_balance` VALUES ('3637', 'sn701', '9410.00');
INSERT INTO `mx_balance` VALUES ('3638', 'sn701', '9810.00');
INSERT INTO `mx_balance` VALUES ('3639', 'sn701', '9790.00');
INSERT INTO `mx_balance` VALUES ('3640', 'sn701', '9760.00');
INSERT INTO `mx_balance` VALUES ('3641', 'sn701', '9560.00');
INSERT INTO `mx_balance` VALUES ('3642', 'sn701', '9510.00');
INSERT INTO `mx_balance` VALUES ('3643', 'sn701', '9480.00');
INSERT INTO `mx_balance` VALUES ('3644', 'sn701', '9430.00');
INSERT INTO `mx_balance` VALUES ('3645', 'sn701', '9410.00');
INSERT INTO `mx_balance` VALUES ('3646', 'sn701', '9390.00');
INSERT INTO `mx_balance` VALUES ('3647', 'sn701', '9370.00');
INSERT INTO `mx_balance` VALUES ('3648', 'sn701', '9270.00');
INSERT INTO `mx_balance` VALUES ('3649', 'sn701', '9260.00');
INSERT INTO `mx_balance` VALUES ('3650', 'sn701', '9350.00');
INSERT INTO `mx_balance` VALUES ('3651', 'sn701', '9340.00');
INSERT INTO `mx_balance` VALUES ('3652', 'sn701', '9320.00');
INSERT INTO `mx_balance` VALUES ('3653', 'sn701', '9270.00');
INSERT INTO `mx_balance` VALUES ('3654', 'sn701', '9250.00');
INSERT INTO `mx_balance` VALUES ('3655', 'sn701', '9200.00');
INSERT INTO `mx_balance` VALUES ('3656', 'sn701', '9180.00');
INSERT INTO `mx_balance` VALUES ('3657', 'sn701', '9170.00');
INSERT INTO `mx_balance` VALUES ('3658', 'sn701', '9150.00');
INSERT INTO `mx_balance` VALUES ('3659', 'sn701', '9140.00');
INSERT INTO `mx_balance` VALUES ('3660', 'sn701', '9120.00');
INSERT INTO `mx_balance` VALUES ('3661', 'sn701', '9110.00');
INSERT INTO `mx_balance` VALUES ('3662', 'sn701', '9090.00');
INSERT INTO `mx_balance` VALUES ('3663', 'sn701', '9080.00');
INSERT INTO `mx_balance` VALUES ('3664', 'sn701', '9070.00');
INSERT INTO `mx_balance` VALUES ('3665', 'sn701', '9010.00');
INSERT INTO `mx_balance` VALUES ('3666', 'sn701', '8990.00');
INSERT INTO `mx_balance` VALUES ('3667', 'sn701', '8890.00');
INSERT INTO `mx_balance` VALUES ('3668', 'sn701', '8860.00');
INSERT INTO `mx_balance` VALUES ('3669', 'sn701', '8830.00');
INSERT INTO `mx_balance` VALUES ('3670', 'sn701', '8790.00');
INSERT INTO `mx_balance` VALUES ('3671', 'sn701', '8770.00');
INSERT INTO `mx_balance` VALUES ('3672', 'sn701', '8760.00');
INSERT INTO `mx_balance` VALUES ('3673', 'sn701', '8720.00');
INSERT INTO `mx_balance` VALUES ('3674', 'sn701', '8680.00');
INSERT INTO `mx_balance` VALUES ('3675', 'sn701', '8640.00');
INSERT INTO `mx_balance` VALUES ('3676', 'sn701', '8630.00');
INSERT INTO `mx_balance` VALUES ('3677', 'sn701', '8590.00');
INSERT INTO `mx_balance` VALUES ('3678', 'sn701', '8570.00');
INSERT INTO `mx_balance` VALUES ('3679', 'sn701', '8550.00');
INSERT INTO `mx_balance` VALUES ('3680', 'sn701', '8540.00');
INSERT INTO `mx_balance` VALUES ('3681', 'sn701', '8520.00');
INSERT INTO `mx_balance` VALUES ('3682', 'sn701', '8500.00');
INSERT INTO `mx_balance` VALUES ('3683', 'sn701', '8480.00');
INSERT INTO `mx_balance` VALUES ('3684', 'sn701', '8470.00');
INSERT INTO `mx_balance` VALUES ('3685', 'sn701', '8450.00');
INSERT INTO `mx_balance` VALUES ('3686', 'sn701', '8440.00');
INSERT INTO `mx_balance` VALUES ('3687', 'sn701', '8430.00');
INSERT INTO `mx_balance` VALUES ('3688', 'sn701', '8400.00');
INSERT INTO `mx_balance` VALUES ('3689', 'sn701', '8390.00');
INSERT INTO `mx_balance` VALUES ('3690', 'sn701', '8380.00');
INSERT INTO `mx_balance` VALUES ('3691', 'sn701', '8360.00');
INSERT INTO `mx_balance` VALUES ('3692', 'sn701', '8350.00');
INSERT INTO `mx_balance` VALUES ('3693', 'sn701', '8340.00');
INSERT INTO `mx_balance` VALUES ('3694', 'sn701', '8330.00');
INSERT INTO `mx_balance` VALUES ('3695', 'sn701', '8320.00');
INSERT INTO `mx_balance` VALUES ('3696', 'sn701', '8310.00');
INSERT INTO `mx_balance` VALUES ('3697', 'sn701', '8300.00');
INSERT INTO `mx_balance` VALUES ('3698', 'sn701', '8290.00');
INSERT INTO `mx_balance` VALUES ('3699', 'sn701', '8240.00');
INSERT INTO `mx_balance` VALUES ('3700', 'sn701', '8230.00');
INSERT INTO `mx_balance` VALUES ('3701', 'sn701', '8210.00');
INSERT INTO `mx_balance` VALUES ('3702', 'sn701', '8200.00');
INSERT INTO `mx_balance` VALUES ('3703', 'sn701', '8190.00');
INSERT INTO `mx_balance` VALUES ('3704', 'sn701', '8180.00');
INSERT INTO `mx_balance` VALUES ('3705', 'sn701', '8160.00');
INSERT INTO `mx_balance` VALUES ('3706', 'sn701', '8150.00');
INSERT INTO `mx_balance` VALUES ('3707', 'sn701', '8130.00');
INSERT INTO `mx_balance` VALUES ('3708', 'sn701', '8110.00');
INSERT INTO `mx_balance` VALUES ('3709', 'sn701', '8090.00');
INSERT INTO `mx_balance` VALUES ('3710', 'sn701', '8070.00');
INSERT INTO `mx_balance` VALUES ('3711', 'sn701', '8050.00');
INSERT INTO `mx_balance` VALUES ('3712', 'sn701', '7950.00');
INSERT INTO `mx_balance` VALUES ('3713', 'sn701', '7850.00');
INSERT INTO `mx_balance` VALUES ('3714', 'sn701', '7810.00');
INSERT INTO `mx_balance` VALUES ('3715', 'sn701', '7770.00');
INSERT INTO `mx_balance` VALUES ('3716', 'sn701', '7860.00');
INSERT INTO `mx_balance` VALUES ('3717', 'sn701', '7660.00');
INSERT INTO `mx_balance` VALUES ('3718', 'sn701', '7630.00');
INSERT INTO `mx_balance` VALUES ('3719', 'sn701', '7620.00');
INSERT INTO `mx_balance` VALUES ('3720', 'sn701', '7610.00');
INSERT INTO `mx_balance` VALUES ('3721', 'sn701', '7590.00');
INSERT INTO `mx_balance` VALUES ('3722', 'sn701', '7580.00');
INSERT INTO `mx_balance` VALUES ('3723', 'sn701', '7550.00');
INSERT INTO `mx_balance` VALUES ('3724', 'sn701', '7520.00');
INSERT INTO `mx_balance` VALUES ('3725', 'sn701', '7500.00');
INSERT INTO `mx_balance` VALUES ('3726', 'sn701', '7450.00');
INSERT INTO `mx_balance` VALUES ('3727', 'sn701', '7420.00');
INSERT INTO `mx_balance` VALUES ('3728', 'sn701', '7410.00');
INSERT INTO `mx_balance` VALUES ('3729', 'sn701', '7370.00');
INSERT INTO `mx_balance` VALUES ('3730', 'sn701', '7310.00');
INSERT INTO `mx_balance` VALUES ('3731', 'sn701', '7250.00');
INSERT INTO `mx_balance` VALUES ('3732', 'sn701', '7230.00');
INSERT INTO `mx_balance` VALUES ('3733', 'sn701', '7210.00');
INSERT INTO `mx_balance` VALUES ('3734', 'sn701', '7200.00');
INSERT INTO `mx_balance` VALUES ('3735', 'sn701', '7160.00');
INSERT INTO `mx_balance` VALUES ('3736', 'sn701', '7140.00');
INSERT INTO `mx_balance` VALUES ('3737', 'sn701', '7060.00');
INSERT INTO `mx_balance` VALUES ('3738', 'sn701', '7040.00');
INSERT INTO `mx_balance` VALUES ('3739', 'sn701', '7010.00');
INSERT INTO `mx_balance` VALUES ('3740', 'sn701', '6990.00');
INSERT INTO `mx_balance` VALUES ('3741', 'sn701', '6970.00');
INSERT INTO `mx_balance` VALUES ('3742', 'sn701', '6940.00');
INSERT INTO `mx_balance` VALUES ('3743', 'sn701', '6900.00');
INSERT INTO `mx_balance` VALUES ('3744', 'sn701', '6890.00');
INSERT INTO `mx_balance` VALUES ('3745', 'sn701', '6850.00');
INSERT INTO `mx_balance` VALUES ('3746', 'sn701', '6830.00');
INSERT INTO `mx_balance` VALUES ('3747', 'sn701', '6820.00');
INSERT INTO `mx_balance` VALUES ('3748', 'sn701', '6810.00');
INSERT INTO `mx_balance` VALUES ('3749', 'sn701', '6740.00');
INSERT INTO `mx_balance` VALUES ('3750', 'sn701', '6680.00');
INSERT INTO `mx_balance` VALUES ('3751', 'sn701', '6620.00');
INSERT INTO `mx_balance` VALUES ('3752', 'sn701', '6600.00');
INSERT INTO `mx_balance` VALUES ('3753', 'sn701', '6590.00');
INSERT INTO `mx_balance` VALUES ('3754', 'sn701', '6530.00');
INSERT INTO `mx_balance` VALUES ('3755', 'sn701', '6490.00');
INSERT INTO `mx_balance` VALUES ('3756', 'sn701', '6480.00');
INSERT INTO `mx_balance` VALUES ('3757', 'sn701', '6470.00');
INSERT INTO `mx_balance` VALUES ('3758', 'sn701', '6440.00');
INSERT INTO `mx_balance` VALUES ('3759', 'sn701', '6430.00');
INSERT INTO `mx_balance` VALUES ('3760', 'sn701', '6390.00');
INSERT INTO `mx_balance` VALUES ('3761', 'sn701', '6370.00');
INSERT INTO `mx_balance` VALUES ('3762', 'sn701', '6340.00');
INSERT INTO `mx_balance` VALUES ('3763', 'sn701', '6330.00');
INSERT INTO `mx_balance` VALUES ('3764', 'sn701', '6270.00');
INSERT INTO `mx_balance` VALUES ('3765', 'sn701', '6200.00');
INSERT INTO `mx_balance` VALUES ('3766', 'sn701', '6180.00');
INSERT INTO `mx_balance` VALUES ('3767', 'sn701', '6170.00');
INSERT INTO `mx_balance` VALUES ('3768', 'sn701', '6160.00');
INSERT INTO `mx_balance` VALUES ('3769', 'sn701', '6150.00');
INSERT INTO `mx_balance` VALUES ('3770', 'sn701', '6140.00');
INSERT INTO `mx_balance` VALUES ('3771', 'sn701', '6120.00');
INSERT INTO `mx_balance` VALUES ('3772', 'sn701', '6060.00');
INSERT INTO `mx_balance` VALUES ('3773', 'sn701', '6030.00');
INSERT INTO `mx_balance` VALUES ('3774', 'sn701', '6010.00');
INSERT INTO `mx_balance` VALUES ('3775', 'sn701', '5710.00');
INSERT INTO `mx_balance` VALUES ('3776', 'sn701', '5410.00');
INSERT INTO `mx_balance` VALUES ('3777', 'sn701', '5400.00');
INSERT INTO `mx_balance` VALUES ('3778', 'sn701', '5380.00');
INSERT INTO `mx_balance` VALUES ('3779', 'sn701', '5320.00');
INSERT INTO `mx_balance` VALUES ('3780', 'sn701', '5310.00');
INSERT INTO `mx_balance` VALUES ('3781', 'sn701', '5290.00');
INSERT INTO `mx_balance` VALUES ('3782', 'sn701', '5280.00');
INSERT INTO `mx_balance` VALUES ('3783', 'sn701', '5180.00');
INSERT INTO `mx_balance` VALUES ('3784', 'sn701', '5170.00');
INSERT INTO `mx_balance` VALUES ('3785', 'sn701', '5160.00');
INSERT INTO `mx_balance` VALUES ('3786', 'sn701', '5150.00');
INSERT INTO `mx_balance` VALUES ('3787', 'sn701', '5090.00');
INSERT INTO `mx_balance` VALUES ('3788', 'sn701', '5080.00');
INSERT INTO `mx_balance` VALUES ('3789', 'sn701', '5060.00');
INSERT INTO `mx_balance` VALUES ('3790', 'sn701', '5050.00');
INSERT INTO `mx_balance` VALUES ('3791', 'sn701', '5030.00');
INSERT INTO `mx_balance` VALUES ('3792', 'sn701', '5020.00');
INSERT INTO `mx_balance` VALUES ('3793', 'sn701', '4980.00');
INSERT INTO `mx_balance` VALUES ('3794', 'sn701', '4970.00');
INSERT INTO `mx_balance` VALUES ('3795', 'sn701', '4940.00');
INSERT INTO `mx_balance` VALUES ('3796', 'sn701', '4920.00');
INSERT INTO `mx_balance` VALUES ('3797', 'sn701', '4900.00');
INSERT INTO `mx_balance` VALUES ('3798', 'sn701', '4870.00');
INSERT INTO `mx_balance` VALUES ('3799', 'sn701', '4860.00');
INSERT INTO `mx_balance` VALUES ('3800', 'sn701', '4840.00');
INSERT INTO `mx_balance` VALUES ('3801', 'sn701', '4810.00');
INSERT INTO `mx_balance` VALUES ('3802', 'sn701', '5310.00');
INSERT INTO `mx_balance` VALUES ('3803', 'sn701', '5810.00');
INSERT INTO `mx_balance` VALUES ('3804', 'sn701', '5770.00');
INSERT INTO `mx_balance` VALUES ('3805', 'sn701', '5720.00');
INSERT INTO `mx_balance` VALUES ('3806', 'sn701', '5690.00');
INSERT INTO `mx_balance` VALUES ('3807', 'sn701', '5680.00');
INSERT INTO `mx_balance` VALUES ('3808', 'sn701', '5640.00');
INSERT INTO `mx_balance` VALUES ('3809', 'sn701', '5610.00');
INSERT INTO `mx_balance` VALUES ('3810', 'sn701', '5600.00');
INSERT INTO `mx_balance` VALUES ('3811', 'sn701', '5590.00');
INSERT INTO `mx_balance` VALUES ('3812', 'sn701', '5560.00');
INSERT INTO `mx_balance` VALUES ('3813', 'sn701', '5550.00');
INSERT INTO `mx_balance` VALUES ('3814', 'sn701', '5540.00');
INSERT INTO `mx_balance` VALUES ('3815', 'sn701', '5520.00');
INSERT INTO `mx_balance` VALUES ('3816', 'sn701', '5500.00');
INSERT INTO `mx_balance` VALUES ('3817', 'sn701', '5470.00');
INSERT INTO `mx_balance` VALUES ('3818', 'sn701', '5460.00');
INSERT INTO `mx_balance` VALUES ('3819', 'sn701', '5430.00');
INSERT INTO `mx_balance` VALUES ('3820', 'sn701', '5420.00');
INSERT INTO `mx_balance` VALUES ('3821', 'sn701', '5410.00');
INSERT INTO `mx_balance` VALUES ('3822', 'sn701', '5400.00');
INSERT INTO `mx_balance` VALUES ('3823', 'sn701', '5390.00');
INSERT INTO `mx_balance` VALUES ('3824', 'sn701', '5380.00');
INSERT INTO `mx_balance` VALUES ('3825', 'sn701', '5370.00');
INSERT INTO `mx_balance` VALUES ('3826', 'sn702', '8500.00');
INSERT INTO `mx_balance` VALUES ('3827', 'sn701', '5360.00');
INSERT INTO `mx_balance` VALUES ('3828', 'sn701', '5350.00');
INSERT INTO `mx_balance` VALUES ('3829', 'sn701', '5340.00');
INSERT INTO `mx_balance` VALUES ('3830', 'sn701', '5330.00');
INSERT INTO `mx_balance` VALUES ('3831', 'sn701', '5320.00');
INSERT INTO `mx_balance` VALUES ('3832', 'sn701', '5310.00');
INSERT INTO `mx_balance` VALUES ('3833', 'sn701', '5300.00');
INSERT INTO `mx_balance` VALUES ('3834', 'sn701', '5290.00');
INSERT INTO `mx_balance` VALUES ('3835', 'sn701', '5280.00');
INSERT INTO `mx_balance` VALUES ('3836', 'sn701', '5270.00');
INSERT INTO `mx_balance` VALUES ('3837', 'sn701', '5250.00');
INSERT INTO `mx_balance` VALUES ('3838', 'sn701', '5230.00');
INSERT INTO `mx_balance` VALUES ('3839', 'sn701', '5210.00');
INSERT INTO `mx_balance` VALUES ('3840', 'sn701', '5190.00');
INSERT INTO `mx_balance` VALUES ('3841', 'sn701', '5180.00');
INSERT INTO `mx_balance` VALUES ('3842', 'sn701', '5170.00');
INSERT INTO `mx_balance` VALUES ('3843', 'sn701', '5150.00');
INSERT INTO `mx_balance` VALUES ('3844', 'sn701', '5110.00');
INSERT INTO `mx_balance` VALUES ('3845', 'sn701', '5080.00');
INSERT INTO `mx_balance` VALUES ('3846', 'sn701', '5050.00');
INSERT INTO `mx_balance` VALUES ('3847', 'sn701', '5030.00');
INSERT INTO `mx_balance` VALUES ('3848', 'sn701', '5010.00');
INSERT INTO `mx_balance` VALUES ('3849', 'sn701', '5000.00');
INSERT INTO `mx_balance` VALUES ('3850', 'sn701', '4980.00');
INSERT INTO `mx_balance` VALUES ('3851', 'sn701', '4970.00');
INSERT INTO `mx_balance` VALUES ('3852', 'sn701', '4960.00');
INSERT INTO `mx_balance` VALUES ('3853', 'sn701', '4950.00');
INSERT INTO `mx_balance` VALUES ('3854', 'sn701', '4940.00');
INSERT INTO `mx_balance` VALUES ('3855', 'sn701', '4930.00');
INSERT INTO `mx_balance` VALUES ('3856', 'sn701', '4890.00');
INSERT INTO `mx_balance` VALUES ('3857', 'sn701', '4880.00');
INSERT INTO `mx_balance` VALUES ('3858', 'sn701', '4870.00');
INSERT INTO `mx_balance` VALUES ('3859', 'sn701', '4860.00');
INSERT INTO `mx_balance` VALUES ('3860', 'sn701', '4850.00');
INSERT INTO `mx_balance` VALUES ('3861', 'sn701', '4840.00');
INSERT INTO `mx_balance` VALUES ('3862', 'sn701', '4830.00');
INSERT INTO `mx_balance` VALUES ('3863', 'sn701', '4820.00');
INSERT INTO `mx_balance` VALUES ('3864', 'sn701', '4760.00');
INSERT INTO `mx_balance` VALUES ('3865', 'sn701', '4660.00');
INSERT INTO `mx_balance` VALUES ('3866', 'sn701', '4560.00');
INSERT INTO `mx_balance` VALUES ('3867', 'sn701', '4530.00');
INSERT INTO `mx_balance` VALUES ('3868', 'sn701', '4470.00');
INSERT INTO `mx_balance` VALUES ('3869', 'sn701', '4440.00');
INSERT INTO `mx_balance` VALUES ('3870', 'sn701', '4420.00');
INSERT INTO `mx_balance` VALUES ('3871', 'sn701', '4390.00');
INSERT INTO `mx_balance` VALUES ('3872', 'sn701', '4240.00');
INSERT INTO `mx_balance` VALUES ('3873', 'sn701', '4180.00');
INSERT INTO `mx_balance` VALUES ('3874', 'sn701', '4140.00');
INSERT INTO `mx_balance` VALUES ('3875', 'sn701', '4130.00');
INSERT INTO `mx_balance` VALUES ('3876', 'sn701', '4120.00');
INSERT INTO `mx_balance` VALUES ('3877', 'sn701', '4100.00');
INSERT INTO `mx_balance` VALUES ('3878', 'sn701', '4090.00');
INSERT INTO `mx_balance` VALUES ('3879', 'sn701', '4080.00');
INSERT INTO `mx_balance` VALUES ('3880', 'sn701', '4070.00');
INSERT INTO `mx_balance` VALUES ('3881', 'sn701', '4060.00');
INSERT INTO `mx_balance` VALUES ('3882', 'sn701', '4020.00');
INSERT INTO `mx_balance` VALUES ('3883', 'sn701', '4000.00');
INSERT INTO `mx_balance` VALUES ('3884', 'sn701', '3990.00');
INSERT INTO `mx_balance` VALUES ('3885', 'sn701', '3930.00');
INSERT INTO `mx_balance` VALUES ('3886', 'sn701', '3900.00');
INSERT INTO `mx_balance` VALUES ('3887', 'sn701', '3860.00');
INSERT INTO `mx_balance` VALUES ('3888', 'sn701', '3840.00');
INSERT INTO `mx_balance` VALUES ('3889', 'sn701', '3820.00');
INSERT INTO `mx_balance` VALUES ('3890', 'sn701', '3810.00');
INSERT INTO `mx_balance` VALUES ('3891', 'sn701', '3800.00');
INSERT INTO `mx_balance` VALUES ('3892', 'sn701', '3780.00');
INSERT INTO `mx_balance` VALUES ('3893', 'sn701', '3760.00');
INSERT INTO `mx_balance` VALUES ('3894', 'sn701', '3750.00');
INSERT INTO `mx_balance` VALUES ('3895', 'sn701', '3730.00');
INSERT INTO `mx_balance` VALUES ('3896', 'sn701', '3710.00');
INSERT INTO `mx_balance` VALUES ('3897', 'sn701', '3700.00');
INSERT INTO `mx_balance` VALUES ('3898', 'sn701', '3690.00');
INSERT INTO `mx_balance` VALUES ('3899', 'sn701', '3680.00');
INSERT INTO `mx_balance` VALUES ('3900', 'sn701', '3670.00');
INSERT INTO `mx_balance` VALUES ('3901', 'sn701', '3660.00');
INSERT INTO `mx_balance` VALUES ('3902', 'sn701', '3650.00');
INSERT INTO `mx_balance` VALUES ('3903', 'sn701', '3640.00');
INSERT INTO `mx_balance` VALUES ('3904', 'sn701', '3620.00');
INSERT INTO `mx_balance` VALUES ('3905', 'sn701', '3610.00');
INSERT INTO `mx_balance` VALUES ('3906', 'sn701', '3590.00');
INSERT INTO `mx_balance` VALUES ('3907', 'sn701', '3570.00');
INSERT INTO `mx_balance` VALUES ('3908', 'sn701', '3560.00');
INSERT INTO `mx_balance` VALUES ('3909', 'sn701', '3540.00');
INSERT INTO `mx_balance` VALUES ('3910', 'sn701', '3520.00');
INSERT INTO `mx_balance` VALUES ('3911', 'sn701', '3500.00');
INSERT INTO `mx_balance` VALUES ('3912', 'sn701', '3480.00');
INSERT INTO `mx_balance` VALUES ('3913', 'sn701', '3470.00');
INSERT INTO `mx_balance` VALUES ('3914', 'sn701', '3450.00');
INSERT INTO `mx_balance` VALUES ('3915', 'sn701', '3440.00');
INSERT INTO `mx_balance` VALUES ('3916', 'sn701', '3430.00');
INSERT INTO `mx_balance` VALUES ('3917', 'sn701', '3420.00');
INSERT INTO `mx_balance` VALUES ('3918', 'sn701', '3400.00');
INSERT INTO `mx_balance` VALUES ('3919', 'sn701', '3390.00');
INSERT INTO `mx_balance` VALUES ('3920', 'sn701', '3370.00');
INSERT INTO `mx_balance` VALUES ('3921', 'sn701', '3360.00');
INSERT INTO `mx_balance` VALUES ('3922', 'sn701', '3350.00');
INSERT INTO `mx_balance` VALUES ('3923', 'sn701', '3340.00');
INSERT INTO `mx_balance` VALUES ('3924', 'sn701', '3330.00');
INSERT INTO `mx_balance` VALUES ('3925', 'sn701', '3310.00');
INSERT INTO `mx_balance` VALUES ('3926', 'sn701', '3290.00');
INSERT INTO `mx_balance` VALUES ('3927', 'sn701', '3270.00');
INSERT INTO `mx_balance` VALUES ('3928', 'sn701', '3250.00');
INSERT INTO `mx_balance` VALUES ('3929', 'sn701', '3240.00');
INSERT INTO `mx_balance` VALUES ('3930', 'sn701', '3230.00');
INSERT INTO `mx_balance` VALUES ('3931', 'sn701', '3200.00');
INSERT INTO `mx_balance` VALUES ('3932', 'sn701', '3170.00');
INSERT INTO `mx_balance` VALUES ('3933', 'sn701', '3130.00');
INSERT INTO `mx_balance` VALUES ('3934', 'sn701', '3100.00');
INSERT INTO `mx_balance` VALUES ('3935', 'sn701', '3090.00');
INSERT INTO `mx_balance` VALUES ('3936', 'sn701', '3080.00');
INSERT INTO `mx_balance` VALUES ('3937', 'sn701', '2990.00');
INSERT INTO `mx_balance` VALUES ('3938', 'sn701', '2890.00');
INSERT INTO `mx_balance` VALUES ('3939', 'sn701', '2790.00');
INSERT INTO `mx_balance` VALUES ('3940', 'sn701', '2750.00');
INSERT INTO `mx_balance` VALUES ('3941', 'sn701', '2730.00');
INSERT INTO `mx_balance` VALUES ('3942', 'sn701', '2720.00');
INSERT INTO `mx_balance` VALUES ('3943', 'sn701', '2700.00');
INSERT INTO `mx_balance` VALUES ('3944', 'sn701', '2690.00');
INSERT INTO `mx_balance` VALUES ('3945', 'sn701', '2680.00');
INSERT INTO `mx_balance` VALUES ('3946', 'sn701', '2670.00');
INSERT INTO `mx_balance` VALUES ('3947', 'sn701', '2650.00');
INSERT INTO `mx_balance` VALUES ('3948', 'sn701', '2630.00');
INSERT INTO `mx_balance` VALUES ('3949', 'sn701', '2620.00');
INSERT INTO `mx_balance` VALUES ('3950', 'sn701', '2610.00');
INSERT INTO `mx_balance` VALUES ('3951', 'sn701', '2600.00');
INSERT INTO `mx_balance` VALUES ('3952', 'sn701', '2590.00');
INSERT INTO `mx_balance` VALUES ('3953', 'sn701', '2550.00');
INSERT INTO `mx_balance` VALUES ('3954', 'sn701', '2540.00');
INSERT INTO `mx_balance` VALUES ('3955', 'sn701', '2530.00');
INSERT INTO `mx_balance` VALUES ('3956', 'sn701', '2520.00');
INSERT INTO `mx_balance` VALUES ('3957', 'sn701', '2510.00');
INSERT INTO `mx_balance` VALUES ('3958', 'sn701', '2500.00');
INSERT INTO `mx_balance` VALUES ('3959', 'sn701', '2490.00');
INSERT INTO `mx_balance` VALUES ('3960', 'sn701', '2470.00');
INSERT INTO `mx_balance` VALUES ('3961', 'sn701', '2460.00');
INSERT INTO `mx_balance` VALUES ('3962', 'sn701', '2440.00');
INSERT INTO `mx_balance` VALUES ('3963', 'sn701', '2430.00');
INSERT INTO `mx_balance` VALUES ('3964', 'sn701', '2420.00');
INSERT INTO `mx_balance` VALUES ('3965', 'sn701', '2380.00');
INSERT INTO `mx_balance` VALUES ('3966', 'sn701', '2340.00');
INSERT INTO `mx_balance` VALUES ('3967', 'sn701', '2330.00');
INSERT INTO `mx_balance` VALUES ('3968', 'sn701', '2290.00');
INSERT INTO `mx_balance` VALUES ('3969', 'sn701', '2280.00');
INSERT INTO `mx_balance` VALUES ('3970', 'sn701', '2270.00');
INSERT INTO `mx_balance` VALUES ('3971', 'sn701', '2250.00');
INSERT INTO `mx_balance` VALUES ('3972', 'sn701', '2240.00');
INSERT INTO `mx_balance` VALUES ('3973', 'sn701', '2230.00');
INSERT INTO `mx_balance` VALUES ('3974', 'sn701', '2200.00');
INSERT INTO `mx_balance` VALUES ('3975', 'sn701', '2190.00');
INSERT INTO `mx_balance` VALUES ('3976', 'sn701', '2170.00');
INSERT INTO `mx_balance` VALUES ('3977', 'sn701', '2150.00');
INSERT INTO `mx_balance` VALUES ('3978', 'sn701', '2120.00');
INSERT INTO `mx_balance` VALUES ('3979', 'sn701', '2100.00');
INSERT INTO `mx_balance` VALUES ('3980', 'sn701', '2080.00');
INSERT INTO `mx_balance` VALUES ('3981', 'sn701', '2050.00');
INSERT INTO `mx_balance` VALUES ('3982', 'sn701', '1940.00');
INSERT INTO `mx_balance` VALUES ('3983', 'sn701', '1920.00');
INSERT INTO `mx_balance` VALUES ('3984', 'sn701', '1870.00');
INSERT INTO `mx_balance` VALUES ('3985', 'sn701', '1820.00');
INSERT INTO `mx_balance` VALUES ('3986', 'sn701', '1800.00');
INSERT INTO `mx_balance` VALUES ('3987', 'sn701', '1720.00');
INSERT INTO `mx_balance` VALUES ('3988', 'sn701', '1710.00');
INSERT INTO `mx_balance` VALUES ('3989', 'sn701', '1700.00');
INSERT INTO `mx_balance` VALUES ('3990', 'sn701', '1660.00');
INSERT INTO `mx_balance` VALUES ('3991', 'sn701', '1560.00');
INSERT INTO `mx_balance` VALUES ('3992', 'sn701', '1520.00');
INSERT INTO `mx_balance` VALUES ('3993', 'sn701', '1510.00');
INSERT INTO `mx_balance` VALUES ('3994', 'sn701', '1410.00');
INSERT INTO `mx_balance` VALUES ('3995', 'sn701', '1390.00');
INSERT INTO `mx_balance` VALUES ('3996', 'sn701', '1160.00');
INSERT INTO `mx_balance` VALUES ('3997', 'sn701', '1140.00');
INSERT INTO `mx_balance` VALUES ('3998', 'sn701', '1120.00');
INSERT INTO `mx_balance` VALUES ('3999', 'sn701', '1050.00');
INSERT INTO `mx_balance` VALUES ('4000', 'sn701', '1000.00');
INSERT INTO `mx_balance` VALUES ('4001', 'sn701', '1090.00');
INSERT INTO `mx_balance` VALUES ('4002', 'sn701', '1060.00');
INSERT INTO `mx_balance` VALUES ('4003', 'sn701', '1010.00');
INSERT INTO `mx_balance` VALUES ('4004', 'sn701', '980.00');
INSERT INTO `mx_balance` VALUES ('4005', 'sn701', '900.00');
INSERT INTO `mx_balance` VALUES ('4006', 'sn701', '790.00');
INSERT INTO `mx_balance` VALUES ('4007', 'sn701', '780.00');
INSERT INTO `mx_balance` VALUES ('4008', 'sn701', '390.00');
INSERT INTO `mx_balance` VALUES ('4009', 'sn702', '8430.00');
INSERT INTO `mx_balance` VALUES ('4010', 'sn702', '8420.00');
INSERT INTO `mx_balance` VALUES ('4011', 'sn702', '8310.00');
INSERT INTO `mx_balance` VALUES ('4012', 'sn702', '8270.00');
INSERT INTO `mx_balance` VALUES ('4013', 'sn702', '8240.00');
INSERT INTO `mx_balance` VALUES ('4014', 'sn702', '8150.00');
INSERT INTO `mx_balance` VALUES ('4015', 'sn702', '8100.00');
INSERT INTO `mx_balance` VALUES ('4016', 'sn702', '8090.00');
INSERT INTO `mx_balance` VALUES ('4017', 'sn702', '8080.00');
INSERT INTO `mx_balance` VALUES ('4018', 'sn702', '8060.00');
INSERT INTO `mx_balance` VALUES ('4019', 'sn701', '90.00');
INSERT INTO `mx_balance` VALUES ('4020', 'sn702', '7760.00');
INSERT INTO `mx_balance` VALUES ('4021', 'sn701', '590.00');
INSERT INTO `mx_balance` VALUES ('4022', 'sn701', '1090.00');
INSERT INTO `mx_balance` VALUES ('4023', 'sn701', '1080.00');
INSERT INTO `mx_balance` VALUES ('4024', 'sn701', '1060.00');
INSERT INTO `mx_balance` VALUES ('4025', 'sn701', '1050.00');
INSERT INTO `mx_balance` VALUES ('4026', 'sn701', '51050.00');
INSERT INTO `mx_balance` VALUES ('4027', 'sn702', '57760.00');
INSERT INTO `mx_balance` VALUES ('4028', 'sn701', '51030.00');
INSERT INTO `mx_balance` VALUES ('4029', 'sn701', '51010.00');
INSERT INTO `mx_balance` VALUES ('4030', 'sn701', '51000.00');
INSERT INTO `mx_balance` VALUES ('4031', 'sn701', '50970.00');
INSERT INTO `mx_balance` VALUES ('4032', 'sn702', '57710.00');
INSERT INTO `mx_balance` VALUES ('4033', 'sn702', '57660.00');
INSERT INTO `mx_balance` VALUES ('4034', 'sn702', '57750.00');
INSERT INTO `mx_balance` VALUES ('4035', 'sn701', '50960.00');
INSERT INTO `mx_balance` VALUES ('4036', 'sn701', '50930.00');
INSERT INTO `mx_balance` VALUES ('4037', 'sn701', '50910.00');
INSERT INTO `mx_balance` VALUES ('4038', 'sn701', '50900.00');
INSERT INTO `mx_balance` VALUES ('4039', 'sn701', '50850.00');
INSERT INTO `mx_balance` VALUES ('4040', 'sn701', '50820.00');
INSERT INTO `mx_balance` VALUES ('4041', 'sn701', '50800.00');
INSERT INTO `mx_balance` VALUES ('4042', 'sn701', '50780.00');
INSERT INTO `mx_balance` VALUES ('4043', 'sn701', '50750.00');
INSERT INTO `mx_balance` VALUES ('4044', 'sn701', '50710.00');
INSERT INTO `mx_balance` VALUES ('4045', 'sn701', '50690.00');
INSERT INTO `mx_balance` VALUES ('4046', 'sn701', '50670.00');
INSERT INTO `mx_balance` VALUES ('4047', 'sn701', '50660.00');
INSERT INTO `mx_balance` VALUES ('4048', 'sn701', '50640.00');
INSERT INTO `mx_balance` VALUES ('4049', 'sn701', '50620.00');
INSERT INTO `mx_balance` VALUES ('4050', 'sn701', '50580.00');
INSERT INTO `mx_balance` VALUES ('4051', 'sn701', '50540.00');
INSERT INTO `mx_balance` VALUES ('4052', 'sn701', '50510.00');
INSERT INTO `mx_balance` VALUES ('4053', 'sn701', '50460.00');
INSERT INTO `mx_balance` VALUES ('4054', 'sn701', '50440.00');
INSERT INTO `mx_balance` VALUES ('4055', 'sn701', '50430.00');
INSERT INTO `mx_balance` VALUES ('4056', 'sn701', '50410.00');
INSERT INTO `mx_balance` VALUES ('4057', 'sn701', '50400.00');
INSERT INTO `mx_balance` VALUES ('4058', 'sn701', '50370.00');
INSERT INTO `mx_balance` VALUES ('4059', 'sn701', '50360.00');
INSERT INTO `mx_balance` VALUES ('4060', 'sn701', '50350.00');
INSERT INTO `mx_balance` VALUES ('4061', 'sn701', '50330.00');
INSERT INTO `mx_balance` VALUES ('4062', 'sn701', '50320.00');
INSERT INTO `mx_balance` VALUES ('4063', 'sn701', '50300.00');
INSERT INTO `mx_balance` VALUES ('4064', 'sn701', '50290.00');
INSERT INTO `mx_balance` VALUES ('4065', 'sn701', '50260.00');
INSERT INTO `mx_balance` VALUES ('4066', 'sn701', '50230.00');
INSERT INTO `mx_balance` VALUES ('4067', 'sn701', '50220.00');
INSERT INTO `mx_balance` VALUES ('4068', 'sn701', '50200.00');
INSERT INTO `mx_balance` VALUES ('4069', 'sn701', '50180.00');
INSERT INTO `mx_balance` VALUES ('4070', 'sn701', '50170.00');
INSERT INTO `mx_balance` VALUES ('4071', 'sn701', '50160.00');
INSERT INTO `mx_balance` VALUES ('4072', 'sn701', '50150.00');
INSERT INTO `mx_balance` VALUES ('4073', 'sn701', '50130.00');
INSERT INTO `mx_balance` VALUES ('4074', 'sn701', '50110.00');
INSERT INTO `mx_balance` VALUES ('4075', 'sn701', '50090.00');
INSERT INTO `mx_balance` VALUES ('4076', 'sn701', '50070.00');
INSERT INTO `mx_balance` VALUES ('4077', 'sn701', '50060.00');
INSERT INTO `mx_balance` VALUES ('4078', 'sn701', '50000.00');
INSERT INTO `mx_balance` VALUES ('4079', 'sn701', '49970.00');
INSERT INTO `mx_balance` VALUES ('4080', 'sn701', '49930.00');
INSERT INTO `mx_balance` VALUES ('4081', 'sn701', '49920.00');
INSERT INTO `mx_balance` VALUES ('4082', 'sn701', '49860.00');
INSERT INTO `mx_balance` VALUES ('4083', 'sn701', '49800.00');
INSERT INTO `mx_balance` VALUES ('4084', 'sn701', '49780.00');
INSERT INTO `mx_balance` VALUES ('4085', 'sn701', '49730.00');
INSERT INTO `mx_balance` VALUES ('4086', 'sn701', '49710.00');
INSERT INTO `mx_balance` VALUES ('4087', 'sn701', '49690.00');
INSERT INTO `mx_balance` VALUES ('4088', 'sn701', '49680.00');
INSERT INTO `mx_balance` VALUES ('4089', 'sn701', '49630.00');
INSERT INTO `mx_balance` VALUES ('4090', 'sn701', '49620.00');
INSERT INTO `mx_balance` VALUES ('4091', 'sn701', '49610.00');
INSERT INTO `mx_balance` VALUES ('4092', 'sn701', '49580.00');
INSERT INTO `mx_balance` VALUES ('4093', 'sn701', '49570.00');
INSERT INTO `mx_balance` VALUES ('4094', 'sn701', '49540.00');
INSERT INTO `mx_balance` VALUES ('4095', 'sn701', '49520.00');
INSERT INTO `mx_balance` VALUES ('4096', 'sn701', '49510.00');
INSERT INTO `mx_balance` VALUES ('4097', 'sn701', '49480.00');
INSERT INTO `mx_balance` VALUES ('4098', 'sn701', '49460.00');
INSERT INTO `mx_balance` VALUES ('4099', 'sn701', '49440.00');
INSERT INTO `mx_balance` VALUES ('4100', 'sn701', '49410.00');
INSERT INTO `mx_balance` VALUES ('4101', 'sn701', '49380.00');
INSERT INTO `mx_balance` VALUES ('4102', 'sn701', '49360.00');
INSERT INTO `mx_balance` VALUES ('4103', 'sn701', '49350.00');
INSERT INTO `mx_balance` VALUES ('4104', 'sn701', '49330.00');
INSERT INTO `mx_balance` VALUES ('4105', 'sn701', '49310.00');
INSERT INTO `mx_balance` VALUES ('4106', 'sn701', '49260.00');
INSERT INTO `mx_balance` VALUES ('4107', 'sn701', '49240.00');
INSERT INTO `mx_balance` VALUES ('4108', 'sn701', '49210.00');
INSERT INTO `mx_balance` VALUES ('4109', 'sn701', '49190.00');
INSERT INTO `mx_balance` VALUES ('4110', 'sn701', '49160.00');
INSERT INTO `mx_balance` VALUES ('4111', 'sn701', '49130.00');
INSERT INTO `mx_balance` VALUES ('4112', 'sn701', '49120.00');
INSERT INTO `mx_balance` VALUES ('4113', 'sn701', '48960.00');
INSERT INTO `mx_balance` VALUES ('4114', 'sn701', '48800.00');
INSERT INTO `mx_balance` VALUES ('4115', 'sn701', '48640.00');
INSERT INTO `mx_balance` VALUES ('4116', 'sn701', '49040.00');
INSERT INTO `mx_balance` VALUES ('4117', 'sn701', '49440.00');
INSERT INTO `mx_balance` VALUES ('4118', 'sn701', '49430.00');
INSERT INTO `mx_balance` VALUES ('4119', 'sn701', '49420.00');
INSERT INTO `mx_balance` VALUES ('4120', 'sn701', '49410.00');
INSERT INTO `mx_balance` VALUES ('4121', 'sn701', '49390.00');
INSERT INTO `mx_balance` VALUES ('4122', 'sn701', '49380.00');
INSERT INTO `mx_balance` VALUES ('4123', 'sn701', '49360.00');
INSERT INTO `mx_balance` VALUES ('4124', 'sn701', '49350.00');
INSERT INTO `mx_balance` VALUES ('4125', 'sn701', '49340.00');
INSERT INTO `mx_balance` VALUES ('4126', 'sn701', '49330.00');
INSERT INTO `mx_balance` VALUES ('4127', 'sn701', '49320.00');
INSERT INTO `mx_balance` VALUES ('4128', 'sn701', '49310.00');
INSERT INTO `mx_balance` VALUES ('4129', 'sn701', '49300.00');
INSERT INTO `mx_balance` VALUES ('4130', 'sn701', '49290.00');
INSERT INTO `mx_balance` VALUES ('4131', 'sn701', '49270.00');
INSERT INTO `mx_balance` VALUES ('4132', 'sn701', '49260.00');
INSERT INTO `mx_balance` VALUES ('4133', 'sn701', '49240.00');
INSERT INTO `mx_balance` VALUES ('4134', 'sn701', '49210.00');
INSERT INTO `mx_balance` VALUES ('4135', 'sn701', '49190.00');
INSERT INTO `mx_balance` VALUES ('4136', 'sn701', '49150.00');
INSERT INTO `mx_balance` VALUES ('4137', 'sn701', '49110.00');
INSERT INTO `mx_balance` VALUES ('4138', 'sn701', '49100.00');
INSERT INTO `mx_balance` VALUES ('4139', 'sn701', '49090.00');
INSERT INTO `mx_balance` VALUES ('4140', 'sn701', '49080.00');
INSERT INTO `mx_balance` VALUES ('4141', 'sn701', '49060.00');
INSERT INTO `mx_balance` VALUES ('4142', 'sn701', '49020.00');
INSERT INTO `mx_balance` VALUES ('4143', 'sn701', '49000.00');
INSERT INTO `mx_balance` VALUES ('4144', 'sn701', '48950.00');
INSERT INTO `mx_balance` VALUES ('4145', 'sn701', '48940.00');
INSERT INTO `mx_balance` VALUES ('4146', 'sn702', '57740.00');
INSERT INTO `mx_balance` VALUES ('4147', 'sn702', '57700.00');
INSERT INTO `mx_balance` VALUES ('4148', 'sn702', '57660.00');
INSERT INTO `mx_balance` VALUES ('4149', 'sn702', '57620.00');
INSERT INTO `mx_balance` VALUES ('4150', 'sn702', '57580.00');
INSERT INTO `mx_balance` VALUES ('4151', 'sn702', '57550.00');
INSERT INTO `mx_balance` VALUES ('4152', 'sn702', '57520.00');
INSERT INTO `mx_balance` VALUES ('4153', 'sn702', '57610.00');
INSERT INTO `mx_balance` VALUES ('4154', 'sn702', '57700.00');
INSERT INTO `mx_balance` VALUES ('4155', 'sn702', '57790.00');
INSERT INTO `mx_balance` VALUES ('4156', 'sn701', '48930.00');
INSERT INTO `mx_balance` VALUES ('4157', 'sn701', '48910.00');
INSERT INTO `mx_balance` VALUES ('4158', 'sn701', '48900.00');
INSERT INTO `mx_balance` VALUES ('4159', 'sn701', '48890.00');
INSERT INTO `mx_balance` VALUES ('4160', 'sn701', '48880.00');
INSERT INTO `mx_balance` VALUES ('4161', 'sn701', '48840.00');
INSERT INTO `mx_balance` VALUES ('4162', 'sn701', '48830.00');
INSERT INTO `mx_balance` VALUES ('4163', 'sn701', '48820.00');
INSERT INTO `mx_balance` VALUES ('4164', 'sn701', '48800.00');
INSERT INTO `mx_balance` VALUES ('4165', 'sn701', '48770.00');
INSERT INTO `mx_balance` VALUES ('4166', 'sn701', '48730.00');
INSERT INTO `mx_balance` VALUES ('4167', 'sn701', '48700.00');
INSERT INTO `mx_balance` VALUES ('4168', 'sn701', '48690.00');
INSERT INTO `mx_balance` VALUES ('4169', 'sn701', '48670.00');
INSERT INTO `mx_balance` VALUES ('4170', 'sn701', '48640.00');
INSERT INTO `mx_balance` VALUES ('4171', 'sn701', '48630.00');
INSERT INTO `mx_balance` VALUES ('4172', 'sn702', '57710.00');
INSERT INTO `mx_balance` VALUES ('4173', 'sn701', '48620.00');
INSERT INTO `mx_balance` VALUES ('4174', 'sn701', '48610.00');
INSERT INTO `mx_balance` VALUES ('4175', 'sn701', '48590.00');
INSERT INTO `mx_balance` VALUES ('4176', 'sn701', '48580.00');
INSERT INTO `mx_balance` VALUES ('4177', 'sn701', '48570.00');
INSERT INTO `mx_balance` VALUES ('4178', 'sn701', '48530.00');
INSERT INTO `mx_balance` VALUES ('4179', 'sn701', '48500.00');
INSERT INTO `mx_balance` VALUES ('4180', 'sn701', '48480.00');
INSERT INTO `mx_balance` VALUES ('4181', 'sn701', '48450.00');
INSERT INTO `mx_balance` VALUES ('4182', 'sn701', '48420.00');
INSERT INTO `mx_balance` VALUES ('4183', 'sn701', '48360.00');
INSERT INTO `mx_balance` VALUES ('4184', 'sn701', '48300.00');
INSERT INTO `mx_balance` VALUES ('4185', 'sn701', '48290.00');
INSERT INTO `mx_balance` VALUES ('4186', 'sn701', '48260.00');
INSERT INTO `mx_balance` VALUES ('4187', 'sn701', '48220.00');
INSERT INTO `mx_balance` VALUES ('4188', 'sn701', '48210.00');
INSERT INTO `mx_balance` VALUES ('4189', 'sn701', '48190.00');
INSERT INTO `mx_balance` VALUES ('4190', 'sn701', '48180.00');
INSERT INTO `mx_balance` VALUES ('4191', 'sn701', '48150.00');
INSERT INTO `mx_balance` VALUES ('4192', 'sn701', '48130.00');
INSERT INTO `mx_balance` VALUES ('4193', 'sn701', '48030.00');
INSERT INTO `mx_balance` VALUES ('4194', 'sn701', '48000.00');
INSERT INTO `mx_balance` VALUES ('4195', 'sn701', '47980.00');
INSERT INTO `mx_balance` VALUES ('4196', 'sn701', '47950.00');
INSERT INTO `mx_balance` VALUES ('4197', 'sn701', '47900.00');
INSERT INTO `mx_balance` VALUES ('4198', 'sn701', '47800.00');
INSERT INTO `mx_balance` VALUES ('4199', 'sn701', '47770.00');
INSERT INTO `mx_balance` VALUES ('4200', 'sn701', '47710.00');
INSERT INTO `mx_balance` VALUES ('4201', 'sn701', '47670.00');
INSERT INTO `mx_balance` VALUES ('4202', 'sn701', '47640.00');
INSERT INTO `mx_balance` VALUES ('4203', 'sn701', '47620.00');
INSERT INTO `mx_balance` VALUES ('4204', 'sn701', '47600.00');
INSERT INTO `mx_balance` VALUES ('4205', 'sn701', '47560.00');
INSERT INTO `mx_balance` VALUES ('4206', 'sn701', '47520.00');
INSERT INTO `mx_balance` VALUES ('4207', 'sn701', '47500.00');
INSERT INTO `mx_balance` VALUES ('4208', 'sn701', '47480.00');
INSERT INTO `mx_balance` VALUES ('4209', 'sn701', '47470.00');
INSERT INTO `mx_balance` VALUES ('4210', 'sn701', '47410.00');
INSERT INTO `mx_balance` VALUES ('4211', 'sn701', '47390.00');
INSERT INTO `mx_balance` VALUES ('4212', 'sn701', '47380.00');
INSERT INTO `mx_balance` VALUES ('4213', 'sn701', '47360.00');
INSERT INTO `mx_balance` VALUES ('4214', 'sn701', '47340.00');
INSERT INTO `mx_balance` VALUES ('4215', 'sn701', '47330.00');
INSERT INTO `mx_balance` VALUES ('4216', 'sn701', '47320.00');
INSERT INTO `mx_balance` VALUES ('4217', 'sn701', '47310.00');
INSERT INTO `mx_balance` VALUES ('4218', 'sn701', '47300.00');
INSERT INTO `mx_balance` VALUES ('4219', 'sn701', '47290.00');
INSERT INTO `mx_balance` VALUES ('4220', 'sn701', '47280.00');
INSERT INTO `mx_balance` VALUES ('4221', 'sn701', '47270.00');
INSERT INTO `mx_balance` VALUES ('4222', 'sn701', '47260.00');
INSERT INTO `mx_balance` VALUES ('4223', 'sn701', '47250.00');
INSERT INTO `mx_balance` VALUES ('4224', 'sn701', '47240.00');
INSERT INTO `mx_balance` VALUES ('4225', 'sn701', '47230.00');
INSERT INTO `mx_balance` VALUES ('4226', 'sn701', '47220.00');
INSERT INTO `mx_balance` VALUES ('4227', 'sn701', '47210.00');
INSERT INTO `mx_balance` VALUES ('4228', 'sn701', '47200.00');
INSERT INTO `mx_balance` VALUES ('4229', 'sn701', '47180.00');
INSERT INTO `mx_balance` VALUES ('4230', 'sn701', '47170.00');
INSERT INTO `mx_balance` VALUES ('4231', 'sn701', '47160.00');
INSERT INTO `mx_balance` VALUES ('4232', 'sn701', '47150.00');
INSERT INTO `mx_balance` VALUES ('4233', 'sn701', '47140.00');
INSERT INTO `mx_balance` VALUES ('4234', 'sn701', '47130.00');
INSERT INTO `mx_balance` VALUES ('4235', 'sn701', '47120.00');
INSERT INTO `mx_balance` VALUES ('4236', 'sn701', '47110.00');
INSERT INTO `mx_balance` VALUES ('4237', 'sn701', '47100.00');
INSERT INTO `mx_balance` VALUES ('4238', 'sn701', '47090.00');
INSERT INTO `mx_balance` VALUES ('4239', 'sn701', '47080.00');
INSERT INTO `mx_balance` VALUES ('4240', 'sn701', '47070.00');
INSERT INTO `mx_balance` VALUES ('4241', 'sn701', '47060.00');
INSERT INTO `mx_balance` VALUES ('4242', 'sn701', '47050.00');
INSERT INTO `mx_balance` VALUES ('4243', 'sn701', '47030.00');
INSERT INTO `mx_balance` VALUES ('4244', 'sn701', '47020.00');
INSERT INTO `mx_balance` VALUES ('4245', 'sn701', '47010.00');
INSERT INTO `mx_balance` VALUES ('4246', 'sn701', '47000.00');
INSERT INTO `mx_balance` VALUES ('4247', 'sn701', '46990.00');
INSERT INTO `mx_balance` VALUES ('4248', 'sn701', '46980.00');
INSERT INTO `mx_balance` VALUES ('4249', 'sn701', '46960.00');
INSERT INTO `mx_balance` VALUES ('4250', 'sn701', '46950.00');
INSERT INTO `mx_balance` VALUES ('4251', 'sn701', '46940.00');
INSERT INTO `mx_balance` VALUES ('4252', 'sn701', '46920.00');
INSERT INTO `mx_balance` VALUES ('4253', 'sn701', '46910.00');
INSERT INTO `mx_balance` VALUES ('4254', 'sn701', '46900.00');
INSERT INTO `mx_balance` VALUES ('4255', 'sn701', '46880.00');
INSERT INTO `mx_balance` VALUES ('4256', 'sn701', '46860.00');
INSERT INTO `mx_balance` VALUES ('4257', 'sn701', '46850.00');
INSERT INTO `mx_balance` VALUES ('4258', 'sn701', '46840.00');
INSERT INTO `mx_balance` VALUES ('4259', 'sn701', '46830.00');
INSERT INTO `mx_balance` VALUES ('4260', 'sn701', '46810.00');
INSERT INTO `mx_balance` VALUES ('4261', 'sn701', '46800.00');
INSERT INTO `mx_balance` VALUES ('4262', 'sn701', '46790.00');
INSERT INTO `mx_balance` VALUES ('4263', 'sn701', '46690.00');
INSERT INTO `mx_balance` VALUES ('4264', 'sn701', '46590.00');
INSERT INTO `mx_balance` VALUES ('4265', 'sn701', '46560.00');
INSERT INTO `mx_balance` VALUES ('4266', 'sn701', '46550.00');
INSERT INTO `mx_balance` VALUES ('4267', 'sn701', '46530.00');
INSERT INTO `mx_balance` VALUES ('4268', 'sn701', '46520.00');
INSERT INTO `mx_balance` VALUES ('4269', 'sn701', '46500.00');
INSERT INTO `mx_balance` VALUES ('4270', 'sn701', '46480.00');
INSERT INTO `mx_balance` VALUES ('4271', 'sn701', '46460.00');
INSERT INTO `mx_balance` VALUES ('4272', 'sn701', '46430.00');
INSERT INTO `mx_balance` VALUES ('4273', 'sn701', '46420.00');
INSERT INTO `mx_balance` VALUES ('4274', 'sn701', '46390.00');
INSERT INTO `mx_balance` VALUES ('4275', 'sn701', '46340.00');
INSERT INTO `mx_balance` VALUES ('4276', 'sn701', '46310.00');
INSERT INTO `mx_balance` VALUES ('4277', 'sn701', '46300.00');
INSERT INTO `mx_balance` VALUES ('4278', 'sn701', '46280.00');
INSERT INTO `mx_balance` VALUES ('4279', 'sn701', '46250.00');
INSERT INTO `mx_balance` VALUES ('4280', 'sn701', '46230.00');
INSERT INTO `mx_balance` VALUES ('4281', 'sn701', '46220.00');
INSERT INTO `mx_balance` VALUES ('4282', 'sn701', '46210.00');
INSERT INTO `mx_balance` VALUES ('4283', 'sn701', '46200.00');
INSERT INTO `mx_balance` VALUES ('4284', 'sn701', '46140.00');
INSERT INTO `mx_balance` VALUES ('4285', 'sn701', '46130.00');
INSERT INTO `mx_balance` VALUES ('4286', 'sn701', '46120.00');
INSERT INTO `mx_balance` VALUES ('4287', 'sn701', '46110.00');
INSERT INTO `mx_balance` VALUES ('4288', 'sn701', '46050.00');
INSERT INTO `mx_balance` VALUES ('4289', 'sn701', '46040.00');
INSERT INTO `mx_balance` VALUES ('4290', 'sn701', '46030.00');
INSERT INTO `mx_balance` VALUES ('4291', 'sn701', '46020.00');
INSERT INTO `mx_balance` VALUES ('4292', 'sn701', '45980.00');
INSERT INTO `mx_balance` VALUES ('4293', 'sn701', '45970.00');
INSERT INTO `mx_balance` VALUES ('4294', 'sn701', '45960.00');
INSERT INTO `mx_balance` VALUES ('4295', 'sn701', '45910.00');
INSERT INTO `mx_balance` VALUES ('4296', 'sn701', '45810.00');
INSERT INTO `mx_balance` VALUES ('4297', 'sn701', '45790.00');
INSERT INTO `mx_balance` VALUES ('4298', 'sn701', '45780.00');
INSERT INTO `mx_balance` VALUES ('4299', 'sn701', '45730.00');
INSERT INTO `mx_balance` VALUES ('4300', 'sn701', '45700.00');
INSERT INTO `mx_balance` VALUES ('4301', 'sn701', '45680.00');
INSERT INTO `mx_balance` VALUES ('4302', 'sn701', '45660.00');
INSERT INTO `mx_balance` VALUES ('4303', 'sn701', '45640.00');
INSERT INTO `mx_balance` VALUES ('4304', 'sn701', '45620.00');
INSERT INTO `mx_balance` VALUES ('4305', 'sn701', '45580.00');
INSERT INTO `mx_balance` VALUES ('4306', 'sn701', '45550.00');
INSERT INTO `mx_balance` VALUES ('4307', 'sn701', '45490.00');
INSERT INTO `mx_balance` VALUES ('4308', 'sn701', '45450.00');
INSERT INTO `mx_balance` VALUES ('4309', 'sn701', '45430.00');
INSERT INTO `mx_balance` VALUES ('4310', 'sn701', '45410.00');
INSERT INTO `mx_balance` VALUES ('4311', 'sn701', '45400.00');
INSERT INTO `mx_balance` VALUES ('4312', 'sn701', '45380.00');
INSERT INTO `mx_balance` VALUES ('4313', 'sn701', '45370.00');
INSERT INTO `mx_balance` VALUES ('4314', 'sn701', '45350.00');
INSERT INTO `mx_balance` VALUES ('4315', 'sn701', '45330.00');
INSERT INTO `mx_balance` VALUES ('4316', 'sn701', '45310.00');
INSERT INTO `mx_balance` VALUES ('4317', 'sn701', '45290.00');
INSERT INTO `mx_balance` VALUES ('4318', 'sn701', '45270.00');
INSERT INTO `mx_balance` VALUES ('4319', 'sn701', '45260.00');
INSERT INTO `mx_balance` VALUES ('4320', 'sn701', '45250.00');
INSERT INTO `mx_balance` VALUES ('4321', 'sn701', '45220.00');
INSERT INTO `mx_balance` VALUES ('4322', 'sn701', '45210.00');
INSERT INTO `mx_balance` VALUES ('4323', 'sn701', '45190.00');
INSERT INTO `mx_balance` VALUES ('4324', 'sn701', '45110.00');
INSERT INTO `mx_balance` VALUES ('4325', 'sn701', '45090.00');
INSERT INTO `mx_balance` VALUES ('4326', 'sn701', '45080.00');
INSERT INTO `mx_balance` VALUES ('4327', 'sn701', '45060.00');
INSERT INTO `mx_balance` VALUES ('4328', 'sn701', '45040.00');
INSERT INTO `mx_balance` VALUES ('4329', 'sn701', '45000.00');
INSERT INTO `mx_balance` VALUES ('4330', 'sn701', '44990.00');
INSERT INTO `mx_balance` VALUES ('4331', 'sn701', '44980.00');
INSERT INTO `mx_balance` VALUES ('4332', 'sn701', '44930.00');
INSERT INTO `mx_balance` VALUES ('4333', 'sn701', '44920.00');
INSERT INTO `mx_balance` VALUES ('4334', 'sn701', '44900.00');
INSERT INTO `mx_balance` VALUES ('4335', 'sn701', '44860.00');
INSERT INTO `mx_balance` VALUES ('4336', 'sn701', '44840.00');
INSERT INTO `mx_balance` VALUES ('4337', 'sn701', '44820.00');
INSERT INTO `mx_balance` VALUES ('4338', 'sn701', '44800.00');
INSERT INTO `mx_balance` VALUES ('4339', 'sn701', '44780.00');
INSERT INTO `mx_balance` VALUES ('4340', 'sn701', '44770.00');
INSERT INTO `mx_balance` VALUES ('4341', 'sn701', '44750.00');
INSERT INTO `mx_balance` VALUES ('4342', 'sn701', '44730.00');
INSERT INTO `mx_balance` VALUES ('4343', 'sn701', '44710.00');
INSERT INTO `mx_balance` VALUES ('4344', 'sn701', '44670.00');
INSERT INTO `mx_balance` VALUES ('4345', 'sn701', '44760.00');
INSERT INTO `mx_balance` VALUES ('4346', 'sn701', '44850.00');
INSERT INTO `mx_balance` VALUES ('4347', 'sn701', '44830.00');
INSERT INTO `mx_balance` VALUES ('4348', 'sn701', '44790.00');
INSERT INTO `mx_balance` VALUES ('4349', 'sn701', '44770.00');
INSERT INTO `mx_balance` VALUES ('4350', 'sn701', '44470.00');
INSERT INTO `mx_balance` VALUES ('4351', 'sn701', '44170.00');
INSERT INTO `mx_balance` VALUES ('4352', 'sn701', '44670.00');
INSERT INTO `mx_balance` VALUES ('4353', 'sn701', '45170.00');
INSERT INTO `mx_balance` VALUES ('4354', 'sn701', '45150.00');
INSERT INTO `mx_balance` VALUES ('4355', 'sn701', '45130.00');
INSERT INTO `mx_balance` VALUES ('4356', 'sn701', '45110.00');
INSERT INTO `mx_balance` VALUES ('4357', 'sn701', '45100.00');
INSERT INTO `mx_balance` VALUES ('4358', 'sn701', '45080.00');
INSERT INTO `mx_balance` VALUES ('4359', 'sn701', '45070.00');
INSERT INTO `mx_balance` VALUES ('4360', 'sn701', '45050.00');
INSERT INTO `mx_balance` VALUES ('4361', 'sn701', '45010.00');
INSERT INTO `mx_balance` VALUES ('4362', 'sn701', '44980.00');
INSERT INTO `mx_balance` VALUES ('4363', 'sn701', '44960.00');
INSERT INTO `mx_balance` VALUES ('4364', 'sn701', '44920.00');
INSERT INTO `mx_balance` VALUES ('4365', 'sn701', '44900.00');
INSERT INTO `mx_balance` VALUES ('4366', 'sn701', '44870.00');
INSERT INTO `mx_balance` VALUES ('4367', 'sn701', '44860.00');
INSERT INTO `mx_balance` VALUES ('4368', 'sn701', '44850.00');
INSERT INTO `mx_balance` VALUES ('4369', 'sn701', '44840.00');
INSERT INTO `mx_balance` VALUES ('4370', 'sn701', '44830.00');
INSERT INTO `mx_balance` VALUES ('4371', 'sn701', '44810.00');
INSERT INTO `mx_balance` VALUES ('4372', 'sn701', '44790.00');
INSERT INTO `mx_balance` VALUES ('4373', 'sn701', '44780.00');
INSERT INTO `mx_balance` VALUES ('4374', 'sn701', '44760.00');
INSERT INTO `mx_balance` VALUES ('4375', 'sn701', '44740.00');
INSERT INTO `mx_balance` VALUES ('4376', 'sn701', '44720.00');
INSERT INTO `mx_balance` VALUES ('4377', 'sn701', '44710.00');
INSERT INTO `mx_balance` VALUES ('4378', 'sn701', '44690.00');
INSERT INTO `mx_balance` VALUES ('4379', 'sn701', '44670.00');
INSERT INTO `mx_balance` VALUES ('4380', 'sn701', '44660.00');
INSERT INTO `mx_balance` VALUES ('4381', 'sn701', '44630.00');
INSERT INTO `mx_balance` VALUES ('4382', 'sn701', '44620.00');
INSERT INTO `mx_balance` VALUES ('4383', 'sn701', '44600.00');
INSERT INTO `mx_balance` VALUES ('4384', 'sn701', '44570.00');
INSERT INTO `mx_balance` VALUES ('4385', 'sn701', '44550.00');
INSERT INTO `mx_balance` VALUES ('4386', 'sn701', '44540.00');
INSERT INTO `mx_balance` VALUES ('4387', 'sn701', '44490.00');
INSERT INTO `mx_balance` VALUES ('4388', 'sn701', '44470.00');
INSERT INTO `mx_balance` VALUES ('4389', 'sn701', '44420.00');
INSERT INTO `mx_balance` VALUES ('4390', 'sn701', '44400.00');
INSERT INTO `mx_balance` VALUES ('4391', 'sn701', '44390.00');
INSERT INTO `mx_balance` VALUES ('4392', 'sn701', '44380.00');
INSERT INTO `mx_balance` VALUES ('4393', 'sn701', '44340.00');
INSERT INTO `mx_balance` VALUES ('4394', 'sn701', '44330.00');
INSERT INTO `mx_balance` VALUES ('4395', 'sn701', '44300.00');
INSERT INTO `mx_balance` VALUES ('4396', 'sn701', '44280.00');
INSERT INTO `mx_balance` VALUES ('4397', 'sn701', '44270.00');
INSERT INTO `mx_balance` VALUES ('4398', 'sn701', '44260.00');
INSERT INTO `mx_balance` VALUES ('4399', 'sn701', '44250.00');
INSERT INTO `mx_balance` VALUES ('4400', 'sn701', '44240.00');
INSERT INTO `mx_balance` VALUES ('4401', 'sn701', '44190.00');
INSERT INTO `mx_balance` VALUES ('4402', 'sn701', '44180.00');
INSERT INTO `mx_balance` VALUES ('4403', 'sn701', '44130.00');
INSERT INTO `mx_balance` VALUES ('4404', 'sn701', '44110.00');
INSERT INTO `mx_balance` VALUES ('4405', 'sn701', '44050.00');
INSERT INTO `mx_balance` VALUES ('4406', 'sn701', '43980.00');
INSERT INTO `mx_balance` VALUES ('4407', 'sn701', '43970.00');
INSERT INTO `mx_balance` VALUES ('4408', 'sn701', '43960.00');
INSERT INTO `mx_balance` VALUES ('4409', 'sn701', '43950.00');
INSERT INTO `mx_balance` VALUES ('4410', 'sn701', '43920.00');
INSERT INTO `mx_balance` VALUES ('4411', 'sn701', '43890.00');
INSERT INTO `mx_balance` VALUES ('4412', 'sn701', '43860.00');
INSERT INTO `mx_balance` VALUES ('4413', 'sn701', '43850.00');
INSERT INTO `mx_balance` VALUES ('4414', 'sn701', '43820.00');
INSERT INTO `mx_balance` VALUES ('4415', 'sn701', '43800.00');
INSERT INTO `mx_balance` VALUES ('4416', 'sn701', '43770.00');
INSERT INTO `mx_balance` VALUES ('4417', 'sn701', '43750.00');
INSERT INTO `mx_balance` VALUES ('4418', 'sn701', '43730.00');
INSERT INTO `mx_balance` VALUES ('4419', 'sn701', '43710.00');
INSERT INTO `mx_balance` VALUES ('4420', 'sn701', '43690.00');
INSERT INTO `mx_balance` VALUES ('4421', 'sn701', '43670.00');
INSERT INTO `mx_balance` VALUES ('4422', 'sn701', '43610.00');
INSERT INTO `mx_balance` VALUES ('4423', 'sn701', '43590.00');
INSERT INTO `mx_balance` VALUES ('4424', 'sn701', '43550.00');
INSERT INTO `mx_balance` VALUES ('4425', 'sn701', '43530.00');
INSERT INTO `mx_balance` VALUES ('4426', 'sn701', '43520.00');
INSERT INTO `mx_balance` VALUES ('4427', 'sn701', '43500.00');
INSERT INTO `mx_balance` VALUES ('4428', 'sn701', '43470.00');
INSERT INTO `mx_balance` VALUES ('4429', 'sn701', '43450.00');
INSERT INTO `mx_balance` VALUES ('4430', 'sn701', '43420.00');
INSERT INTO `mx_balance` VALUES ('4431', 'sn701', '43400.00');
INSERT INTO `mx_balance` VALUES ('4432', 'sn701', '43390.00');
INSERT INTO `mx_balance` VALUES ('4433', 'sn701', '43370.00');
INSERT INTO `mx_balance` VALUES ('4434', 'sn701', '43350.00');
INSERT INTO `mx_balance` VALUES ('4435', 'sn701', '43340.00');
INSERT INTO `mx_balance` VALUES ('4436', 'sn701', '43320.00');
INSERT INTO `mx_balance` VALUES ('4437', 'sn701', '43310.00');
INSERT INTO `mx_balance` VALUES ('4438', 'sn701', '43290.00');
INSERT INTO `mx_balance` VALUES ('4439', 'sn701', '43240.00');
INSERT INTO `mx_balance` VALUES ('4440', 'sn701', '43220.00');
INSERT INTO `mx_balance` VALUES ('4441', 'sn701', '43200.00');
INSERT INTO `mx_balance` VALUES ('4442', 'sn701', '43180.00');
INSERT INTO `mx_balance` VALUES ('4443', 'sn701', '43160.00');
INSERT INTO `mx_balance` VALUES ('4444', 'sn701', '43140.00');
INSERT INTO `mx_balance` VALUES ('4445', 'sn701', '43120.00');
INSERT INTO `mx_balance` VALUES ('4446', 'sn701', '43070.00');
INSERT INTO `mx_balance` VALUES ('4447', 'sn701', '43050.00');
INSERT INTO `mx_balance` VALUES ('4448', 'sn701', '43000.00');
INSERT INTO `mx_balance` VALUES ('4449', 'sn701', '42980.00');
INSERT INTO `mx_balance` VALUES ('4450', 'sn701', '42950.00');
INSERT INTO `mx_balance` VALUES ('4451', 'sn701', '42940.00');
INSERT INTO `mx_balance` VALUES ('4452', 'sn701', '42930.00');
INSERT INTO `mx_balance` VALUES ('4453', 'sn701', '42910.00');
INSERT INTO `mx_balance` VALUES ('4454', 'sn701', '42900.00');
INSERT INTO `mx_balance` VALUES ('4455', 'sn701', '42880.00');
INSERT INTO `mx_balance` VALUES ('4456', 'sn701', '42870.00');
INSERT INTO `mx_balance` VALUES ('4457', 'sn701', '42850.00');
INSERT INTO `mx_balance` VALUES ('4458', 'sn701', '42820.00');
INSERT INTO `mx_balance` VALUES ('4459', 'sn701', '42760.00');
INSERT INTO `mx_balance` VALUES ('4460', 'sn701', '42740.00');
INSERT INTO `mx_balance` VALUES ('4461', 'sn701', '42720.00');
INSERT INTO `mx_balance` VALUES ('4462', 'sn701', '42660.00');
INSERT INTO `mx_balance` VALUES ('4463', 'sn701', '42620.00');
INSERT INTO `mx_balance` VALUES ('4464', 'sn701', '42600.00');
INSERT INTO `mx_balance` VALUES ('4465', 'sn701', '42590.00');
INSERT INTO `mx_balance` VALUES ('4466', 'sn701', '42510.00');
INSERT INTO `mx_balance` VALUES ('4467', 'sn701', '42490.00');
INSERT INTO `mx_balance` VALUES ('4468', 'sn701', '42460.00');
INSERT INTO `mx_balance` VALUES ('4469', 'sn701', '42450.00');
INSERT INTO `mx_balance` VALUES ('4470', 'sn701', '42420.00');
INSERT INTO `mx_balance` VALUES ('4471', 'sn701', '42390.00');
INSERT INTO `mx_balance` VALUES ('4472', 'sn701', '42360.00');
INSERT INTO `mx_balance` VALUES ('4473', 'sn701', '42330.00');
INSERT INTO `mx_balance` VALUES ('4474', 'sn701', '42260.00');
INSERT INTO `mx_balance` VALUES ('4475', 'sn701', '42250.00');
INSERT INTO `mx_balance` VALUES ('4476', 'sn701', '42220.00');
INSERT INTO `mx_balance` VALUES ('4477', 'sn701', '42190.00');
INSERT INTO `mx_balance` VALUES ('4478', 'sn701', '42140.00');
INSERT INTO `mx_balance` VALUES ('4479', 'sn701', '42100.00');
INSERT INTO `mx_balance` VALUES ('4480', 'sn701', '42060.00');
INSERT INTO `mx_balance` VALUES ('4481', 'sn701', '42040.00');
INSERT INTO `mx_balance` VALUES ('4482', 'sn701', '42030.00');
INSERT INTO `mx_balance` VALUES ('4483', 'sn701', '42010.00');
INSERT INTO `mx_balance` VALUES ('4484', 'sn701', '42000.00');
INSERT INTO `mx_balance` VALUES ('4485', 'sn701', '41960.00');
INSERT INTO `mx_balance` VALUES ('4486', 'sn701', '41950.00');
INSERT INTO `mx_balance` VALUES ('4487', 'sn701', '41910.00');
INSERT INTO `mx_balance` VALUES ('4488', 'sn701', '41870.00');
INSERT INTO `mx_balance` VALUES ('4489', 'sn701', '41830.00');
INSERT INTO `mx_balance` VALUES ('4490', 'sn701', '41770.00');
INSERT INTO `mx_balance` VALUES ('4491', 'sn701', '41690.00');
INSERT INTO `mx_balance` VALUES ('4492', 'sn701', '41680.00');
INSERT INTO `mx_balance` VALUES ('4493', 'sn701', '41670.00');
INSERT INTO `mx_balance` VALUES ('4494', 'sn701', '41660.00');
INSERT INTO `mx_balance` VALUES ('4495', 'sn701', '41630.00');
INSERT INTO `mx_balance` VALUES ('4496', 'sn701', '41550.00');
INSERT INTO `mx_balance` VALUES ('4497', 'sn701', '41530.00');
INSERT INTO `mx_balance` VALUES ('4498', 'sn701', '41430.00');
INSERT INTO `mx_balance` VALUES ('4499', 'sn701', '41400.00');
INSERT INTO `mx_balance` VALUES ('4500', 'sn701', '41370.00');
INSERT INTO `mx_balance` VALUES ('4501', 'sn701', '41340.00');
INSERT INTO `mx_balance` VALUES ('4502', 'sn701', '41240.00');
INSERT INTO `mx_balance` VALUES ('4503', 'sn701', '41190.00');
INSERT INTO `mx_balance` VALUES ('4504', 'sn701', '41160.00');
INSERT INTO `mx_balance` VALUES ('4505', 'sn701', '41140.00');
INSERT INTO `mx_balance` VALUES ('4506', 'sn701', '41110.00');
INSERT INTO `mx_balance` VALUES ('4507', 'sn701', '41030.00');
INSERT INTO `mx_balance` VALUES ('4508', 'sn701', '40930.00');
INSERT INTO `mx_balance` VALUES ('4509', 'sn701', '40900.00');
INSERT INTO `mx_balance` VALUES ('4510', 'sn701', '40800.00');
INSERT INTO `mx_balance` VALUES ('4511', 'sn701', '40780.00');
INSERT INTO `mx_balance` VALUES ('4512', 'sn701', '40770.00');
INSERT INTO `mx_balance` VALUES ('4513', 'sn701', '40740.00');
INSERT INTO `mx_balance` VALUES ('4514', 'sn701', '40730.00');
INSERT INTO `mx_balance` VALUES ('4515', 'sn701', '40710.00');
INSERT INTO `mx_balance` VALUES ('4516', 'sn701', '40660.00');
INSERT INTO `mx_balance` VALUES ('4517', 'sn701', '40630.00');
INSERT INTO `mx_balance` VALUES ('4518', 'sn701', '40610.00');
INSERT INTO `mx_balance` VALUES ('4519', 'sn701', '40510.00');
INSERT INTO `mx_balance` VALUES ('4520', 'sn701', '40420.00');
INSERT INTO `mx_balance` VALUES ('4521', 'sn701', '40410.00');
INSERT INTO `mx_balance` VALUES ('4522', 'sn701', '40380.00');
INSERT INTO `mx_balance` VALUES ('4523', 'sn701', '40370.00');
INSERT INTO `mx_balance` VALUES ('4524', 'sn701', '40360.00');
INSERT INTO `mx_balance` VALUES ('4525', 'sn701', '40340.00');
INSERT INTO `mx_balance` VALUES ('4526', 'sn701', '40310.00');
INSERT INTO `mx_balance` VALUES ('4527', 'sn701', '40290.00');
INSERT INTO `mx_balance` VALUES ('4528', 'sn701', '40270.00');
INSERT INTO `mx_balance` VALUES ('4529', 'sn701', '40250.00');
INSERT INTO `mx_balance` VALUES ('4530', 'sn701', '40230.00');
INSERT INTO `mx_balance` VALUES ('4531', 'sn701', '40200.00');
INSERT INTO `mx_balance` VALUES ('4532', 'sn701', '40190.00');
INSERT INTO `mx_balance` VALUES ('4533', 'sn701', '40180.00');
INSERT INTO `mx_balance` VALUES ('4534', 'sn701', '40170.00');
INSERT INTO `mx_balance` VALUES ('4535', 'sn701', '40160.00');
INSERT INTO `mx_balance` VALUES ('4536', 'sn701', '40150.00');
INSERT INTO `mx_balance` VALUES ('4537', 'sn701', '40120.00');
INSERT INTO `mx_balance` VALUES ('4538', 'sn701', '40100.00');
INSERT INTO `mx_balance` VALUES ('4539', 'sn701', '40090.00');
INSERT INTO `mx_balance` VALUES ('4540', 'sn701', '40080.00');
INSERT INTO `mx_balance` VALUES ('4541', 'sn701', '40060.00');
INSERT INTO `mx_balance` VALUES ('4542', 'sn701', '40050.00');
INSERT INTO `mx_balance` VALUES ('4543', 'sn701', '40040.00');
INSERT INTO `mx_balance` VALUES ('4544', 'sn701', '40030.00');
INSERT INTO `mx_balance` VALUES ('4545', 'sn701', '40020.00');
INSERT INTO `mx_balance` VALUES ('4546', 'sn701', '40010.00');
INSERT INTO `mx_balance` VALUES ('4547', 'sn701', '39990.00');
INSERT INTO `mx_balance` VALUES ('4548', 'sn701', '39960.00');
INSERT INTO `mx_balance` VALUES ('4549', 'sn701', '39900.00');
INSERT INTO `mx_balance` VALUES ('4550', 'sn701', '39800.00');
INSERT INTO `mx_balance` VALUES ('4551', 'sn701', '39770.00');
INSERT INTO `mx_balance` VALUES ('4552', 'sn701', '39670.00');
INSERT INTO `mx_balance` VALUES ('4553', 'sn701', '39650.00');
INSERT INTO `mx_balance` VALUES ('4554', 'sn701', '39620.00');
INSERT INTO `mx_balance` VALUES ('4555', 'sn701', '39590.00');
INSERT INTO `mx_balance` VALUES ('4556', 'sn701', '39530.00');
INSERT INTO `mx_balance` VALUES ('4557', 'sn701', '39470.00');
INSERT INTO `mx_balance` VALUES ('4558', 'sn701', '39440.00');
INSERT INTO `mx_balance` VALUES ('4559', 'sn701', '39430.00');
INSERT INTO `mx_balance` VALUES ('4560', 'sn701', '39390.00');
INSERT INTO `mx_balance` VALUES ('4561', 'sn701', '39360.00');
INSERT INTO `mx_balance` VALUES ('4562', 'sn701', '39300.00');
INSERT INTO `mx_balance` VALUES ('4563', 'sn701', '39200.00');
INSERT INTO `mx_balance` VALUES ('4564', 'sn701', '39180.00');
INSERT INTO `mx_balance` VALUES ('4565', 'sn701', '39160.00');
INSERT INTO `mx_balance` VALUES ('4566', 'sn701', '39150.00');
INSERT INTO `mx_balance` VALUES ('4567', 'sn701', '39140.00');
INSERT INTO `mx_balance` VALUES ('4568', 'sn701', '39130.00');
INSERT INTO `mx_balance` VALUES ('4569', 'sn701', '39120.00');
INSERT INTO `mx_balance` VALUES ('4570', 'sn701', '39110.00');
INSERT INTO `mx_balance` VALUES ('4571', 'sn701', '39100.00');
INSERT INTO `mx_balance` VALUES ('4572', 'sn701', '39090.00');
INSERT INTO `mx_balance` VALUES ('4573', 'sn701', '39060.00');
INSERT INTO `mx_balance` VALUES ('4574', 'sn701', '39040.00');
INSERT INTO `mx_balance` VALUES ('4575', 'sn701', '39030.00');
INSERT INTO `mx_balance` VALUES ('4576', 'sn701', '39020.00');
INSERT INTO `mx_balance` VALUES ('4577', 'sn701', '39010.00');
INSERT INTO `mx_balance` VALUES ('4578', 'sn701', '38980.00');
INSERT INTO `mx_balance` VALUES ('4579', 'sn701', '38960.00');
INSERT INTO `mx_balance` VALUES ('4580', 'sn701', '38910.00');
INSERT INTO `mx_balance` VALUES ('4581', 'sn701', '38890.00');
INSERT INTO `mx_balance` VALUES ('4582', 'sn701', '38590.00');
INSERT INTO `mx_balance` VALUES ('4583', 'sn701', '38290.00');
INSERT INTO `mx_balance` VALUES ('4584', 'sn701', '38790.00');
INSERT INTO `mx_balance` VALUES ('4585', 'sn701', '38760.00');
INSERT INTO `mx_balance` VALUES ('4586', 'sn701', '39260.00');
INSERT INTO `mx_balance` VALUES ('4587', 'sn701', '39240.00');
INSERT INTO `mx_balance` VALUES ('4588', 'sn701', '39220.00');
INSERT INTO `mx_balance` VALUES ('4589', 'sn701', '39210.00');
INSERT INTO `mx_balance` VALUES ('4590', 'sn701', '39200.00');
INSERT INTO `mx_balance` VALUES ('4591', 'sn701', '39190.00');
INSERT INTO `mx_balance` VALUES ('4592', 'sn701', '39180.00');
INSERT INTO `mx_balance` VALUES ('4593', 'sn701', '39160.00');
INSERT INTO `mx_balance` VALUES ('4594', 'sn701', '39140.00');
INSERT INTO `mx_balance` VALUES ('4595', 'sn701', '39120.00');
INSERT INTO `mx_balance` VALUES ('4596', 'sn701', '39090.00');
INSERT INTO `mx_balance` VALUES ('4597', 'sn701', '39060.00');
INSERT INTO `mx_balance` VALUES ('4598', 'sn701', '39030.00');
INSERT INTO `mx_balance` VALUES ('4599', 'sn701', '39020.00');
INSERT INTO `mx_balance` VALUES ('4600', 'sn701', '39000.00');
INSERT INTO `mx_balance` VALUES ('4601', 'sn701', '38990.00');
INSERT INTO `mx_balance` VALUES ('4602', 'sn701', '38940.00');
INSERT INTO `mx_balance` VALUES ('4603', 'sn701', '38890.00');
INSERT INTO `mx_balance` VALUES ('4604', 'sn701', '38870.00');
INSERT INTO `mx_balance` VALUES ('4605', 'sn701', '38850.00');
INSERT INTO `mx_balance` VALUES ('4606', 'sn701', '38800.00');
INSERT INTO `mx_balance` VALUES ('4607', 'sn701', '38770.00');
INSERT INTO `mx_balance` VALUES ('4608', 'sn701', '38670.00');
INSERT INTO `mx_balance` VALUES ('4609', 'sn701', '38640.00');
INSERT INTO `mx_balance` VALUES ('4610', 'sn701', '38610.00');
INSERT INTO `mx_balance` VALUES ('4611', 'sn701', '38590.00');
INSERT INTO `mx_balance` VALUES ('4612', 'sn701', '38580.00');
INSERT INTO `mx_balance` VALUES ('4613', 'sn701', '38540.00');
INSERT INTO `mx_balance` VALUES ('4614', 'sn701', '38520.00');
INSERT INTO `mx_balance` VALUES ('4615', 'sn701', '38490.00');
INSERT INTO `mx_balance` VALUES ('4616', 'sn701', '38470.00');
INSERT INTO `mx_balance` VALUES ('4617', 'sn701', '38450.00');
INSERT INTO `mx_balance` VALUES ('4618', 'sn701', '38430.00');
INSERT INTO `mx_balance` VALUES ('4619', 'sn701', '38420.00');
INSERT INTO `mx_balance` VALUES ('4620', 'sn701', '38400.00');
INSERT INTO `mx_balance` VALUES ('4621', 'sn701', '38390.00');
INSERT INTO `mx_balance` VALUES ('4622', 'sn701', '38370.00');
INSERT INTO `mx_balance` VALUES ('4623', 'sn701', '38350.00');
INSERT INTO `mx_balance` VALUES ('4624', 'sn701', '38340.00');
INSERT INTO `mx_balance` VALUES ('4625', 'sn701', '38320.00');
INSERT INTO `mx_balance` VALUES ('4626', 'sn701', '38300.00');
INSERT INTO `mx_balance` VALUES ('4627', 'sn701', '38280.00');
INSERT INTO `mx_balance` VALUES ('4628', 'sn701', '38260.00');
INSERT INTO `mx_balance` VALUES ('4629', 'sn701', '38250.00');
INSERT INTO `mx_balance` VALUES ('4630', 'sn701', '38230.00');
INSERT INTO `mx_balance` VALUES ('4631', 'sn701', '38220.00');
INSERT INTO `mx_balance` VALUES ('4632', 'sn701', '38180.00');
INSERT INTO `mx_balance` VALUES ('4633', 'sn701', '38140.00');
INSERT INTO `mx_balance` VALUES ('4634', 'sn701', '38100.00');
INSERT INTO `mx_balance` VALUES ('4635', 'sn701', '38060.00');
INSERT INTO `mx_balance` VALUES ('4636', 'sn701', '38040.00');
INSERT INTO `mx_balance` VALUES ('4637', 'sn701', '38000.00');
INSERT INTO `mx_balance` VALUES ('4638', 'sn701', '37990.00');
INSERT INTO `mx_balance` VALUES ('4639', 'sn701', '37980.00');
INSERT INTO `mx_balance` VALUES ('4640', 'sn701', '37960.00');
INSERT INTO `mx_balance` VALUES ('4641', 'sn701', '37950.00');
INSERT INTO `mx_balance` VALUES ('4642', 'sn701', '37940.00');
INSERT INTO `mx_balance` VALUES ('4643', 'sn701', '37920.00');
INSERT INTO `mx_balance` VALUES ('4644', 'sn701', '37900.00');
INSERT INTO `mx_balance` VALUES ('4645', 'sn701', '37880.00');
INSERT INTO `mx_balance` VALUES ('4646', 'sn701', '37840.00');
INSERT INTO `mx_balance` VALUES ('4647', 'sn701', '37780.00');
INSERT INTO `mx_balance` VALUES ('4648', 'testsorat', '5000.00');
INSERT INTO `mx_balance` VALUES ('4649', 'sn701', '37750.00');
INSERT INTO `mx_balance` VALUES ('4650', 'sn701', '37720.00');
INSERT INTO `mx_balance` VALUES ('4651', 'sn701', '37690.00');
INSERT INTO `mx_balance` VALUES ('4652', 'sn701', '37680.00');
INSERT INTO `mx_balance` VALUES ('4653', 'sn701', '37670.00');
INSERT INTO `mx_balance` VALUES ('4654', 'sn701', '37650.00');
INSERT INTO `mx_balance` VALUES ('4655', 'sn701', '37620.00');
INSERT INTO `mx_balance` VALUES ('4656', 'sn701', '37580.00');
INSERT INTO `mx_balance` VALUES ('4657', 'testsorat', '4800.00');
INSERT INTO `mx_balance` VALUES ('4658', 'testsorat', '4600.00');
INSERT INTO `mx_balance` VALUES ('4659', 'sn701', '37530.00');
INSERT INTO `mx_balance` VALUES ('4660', 'sn701', '37480.00');
INSERT INTO `mx_balance` VALUES ('4661', 'testsorat', '4780.00');
INSERT INTO `mx_balance` VALUES ('4662', 'testsorat', '4960.00');
INSERT INTO `mx_balance` VALUES ('4663', 'sn701', '37430.00');
INSERT INTO `mx_balance` VALUES ('4664', 'sn701', '37380.00');
INSERT INTO `mx_balance` VALUES ('4665', 'testsorat', '4700.00');
INSERT INTO `mx_balance` VALUES ('4666', 'sn701', '37360.00');
INSERT INTO `mx_balance` VALUES ('4667', 'sn701', '37340.00');
INSERT INTO `mx_balance` VALUES ('4668', 'sn701', '37320.00');
INSERT INTO `mx_balance` VALUES ('4669', 'sn701', '37300.00');
INSERT INTO `mx_balance` VALUES ('4670', 'sn701', '37280.00');
INSERT INTO `mx_balance` VALUES ('4671', 'sn701', '37260.00');
INSERT INTO `mx_balance` VALUES ('4672', 'sn701', '37240.00');
INSERT INTO `mx_balance` VALUES ('4673', 'sn701', '37210.00');
INSERT INTO `mx_balance` VALUES ('4674', 'sn701', '37160.00');
INSERT INTO `mx_balance` VALUES ('4675', 'sn701', '37150.00');
INSERT INTO `mx_balance` VALUES ('4676', 'sn701', '37130.00');
INSERT INTO `mx_balance` VALUES ('4677', 'sn701', '37120.00');
INSERT INTO `mx_balance` VALUES ('4678', 'sn701', '37100.00');
INSERT INTO `mx_balance` VALUES ('4679', 'sn701', '37090.00');
INSERT INTO `mx_balance` VALUES ('4680', 'sn701', '37050.00');
INSERT INTO `mx_balance` VALUES ('4681', 'sn701', '37030.00');
INSERT INTO `mx_balance` VALUES ('4682', 'sn701', '37010.00');
INSERT INTO `mx_balance` VALUES ('4683', 'sn701', '36990.00');
INSERT INTO `mx_balance` VALUES ('4684', 'sn701', '36960.00');
INSERT INTO `mx_balance` VALUES ('4685', 'sn701', '36950.00');
INSERT INTO `mx_balance` VALUES ('4686', 'sn701', '36910.00');
INSERT INTO `mx_balance` VALUES ('4687', 'sn701', '36890.00');
INSERT INTO `mx_balance` VALUES ('4688', 'sn701', '36870.00');
INSERT INTO `mx_balance` VALUES ('4689', 'sn701', '36860.00');
INSERT INTO `mx_balance` VALUES ('4690', 'sn701', '36850.00');
INSERT INTO `mx_balance` VALUES ('4691', 'sn701', '36840.00');
INSERT INTO `mx_balance` VALUES ('4692', 'sn701', '36820.00');
INSERT INTO `mx_balance` VALUES ('4693', 'sn701', '36810.00');
INSERT INTO `mx_balance` VALUES ('4694', 'sn701', '36790.00');
INSERT INTO `mx_balance` VALUES ('4695', 'sn701', '36780.00');
INSERT INTO `mx_balance` VALUES ('4696', 'sn701', '36770.00');
INSERT INTO `mx_balance` VALUES ('4697', 'sn701', '36750.00');
INSERT INTO `mx_balance` VALUES ('4698', 'sn701', '36740.00');
INSERT INTO `mx_balance` VALUES ('4699', 'sn701', '36730.00');
INSERT INTO `mx_balance` VALUES ('4700', 'sn701', '36710.00');
INSERT INTO `mx_balance` VALUES ('4701', 'sn701', '36700.00');
INSERT INTO `mx_balance` VALUES ('4702', 'sn701', '36690.00');
INSERT INTO `mx_balance` VALUES ('4703', 'sn701', '36670.00');
INSERT INTO `mx_balance` VALUES ('4704', 'sn701', '36660.00');
INSERT INTO `mx_balance` VALUES ('4705', 'sn701', '36650.00');
INSERT INTO `mx_balance` VALUES ('4706', 'sn701', '36640.00');
INSERT INTO `mx_balance` VALUES ('4707', 'sn701', '36620.00');
INSERT INTO `mx_balance` VALUES ('4708', 'sn701', '36610.00');
INSERT INTO `mx_balance` VALUES ('4709', 'sn701', '36600.00');
INSERT INTO `mx_balance` VALUES ('4710', 'sn701', '36590.00');
INSERT INTO `mx_balance` VALUES ('4711', 'sn701', '36570.00');
INSERT INTO `mx_balance` VALUES ('4712', 'sn701', '36550.00');
INSERT INTO `mx_balance` VALUES ('4713', 'sn701', '36540.00');
INSERT INTO `mx_balance` VALUES ('4714', 'sn701', '36530.00');
INSERT INTO `mx_balance` VALUES ('4715', 'sn701', '36520.00');
INSERT INTO `mx_balance` VALUES ('4716', 'sn701', '36500.00');
INSERT INTO `mx_balance` VALUES ('4717', 'sn701', '36490.00');
INSERT INTO `mx_balance` VALUES ('4718', 'sn701', '36470.00');
INSERT INTO `mx_balance` VALUES ('4719', 'sn701', '36450.00');
INSERT INTO `mx_balance` VALUES ('4720', 'sn701', '36440.00');
INSERT INTO `mx_balance` VALUES ('4721', 'sn701', '36420.00');
INSERT INTO `mx_balance` VALUES ('4722', 'sn701', '36410.00');
INSERT INTO `mx_balance` VALUES ('4723', 'sn701', '36380.00');
INSERT INTO `mx_balance` VALUES ('4724', 'sn701', '36360.00');
INSERT INTO `mx_balance` VALUES ('4725', 'sn701', '36340.00');
INSERT INTO `mx_balance` VALUES ('4726', 'sn701', '36320.00');
INSERT INTO `mx_balance` VALUES ('4727', 'sn701', '36310.00');
INSERT INTO `mx_balance` VALUES ('4728', 'sn701', '36300.00');
INSERT INTO `mx_balance` VALUES ('4729', 'sn701', '36280.00');
INSERT INTO `mx_balance` VALUES ('4730', 'sn701', '36260.00');
INSERT INTO `mx_balance` VALUES ('4731', 'sn701', '36240.00');
INSERT INTO `mx_balance` VALUES ('4732', 'sn701', '36220.00');
INSERT INTO `mx_balance` VALUES ('4733', 'sn701', '36210.00');
INSERT INTO `mx_balance` VALUES ('4734', 'sn701', '36200.00');
INSERT INTO `mx_balance` VALUES ('4735', 'sn701', '36190.00');
INSERT INTO `mx_balance` VALUES ('4736', 'sn701', '36160.00');
INSERT INTO `mx_balance` VALUES ('4737', 'sn701', '36140.00');
INSERT INTO `mx_balance` VALUES ('4738', 'sn701', '36120.00');
INSERT INTO `mx_balance` VALUES ('4739', 'sn701', '36100.00');
INSERT INTO `mx_balance` VALUES ('4740', 'sn701', '36040.00');
INSERT INTO `mx_balance` VALUES ('4741', 'sn701', '36030.00');
INSERT INTO `mx_balance` VALUES ('4742', 'sn701', '35970.00');
INSERT INTO `mx_balance` VALUES ('4743', 'sn701', '35950.00');
INSERT INTO `mx_balance` VALUES ('4744', 'sn701', '35930.00');
INSERT INTO `mx_balance` VALUES ('4745', 'sn701', '35900.00');
INSERT INTO `mx_balance` VALUES ('4746', 'sn701', '35880.00');
INSERT INTO `mx_balance` VALUES ('4747', 'sn701', '35850.00');
INSERT INTO `mx_balance` VALUES ('4748', 'sn701', '35840.00');
INSERT INTO `mx_balance` VALUES ('4749', 'sn701', '35830.00');
INSERT INTO `mx_balance` VALUES ('4750', 'sn701', '35730.00');
INSERT INTO `mx_balance` VALUES ('4751', 'sn701', '35720.00');
INSERT INTO `mx_balance` VALUES ('4752', 'sn701', '35700.00');
INSERT INTO `mx_balance` VALUES ('4753', 'sn701', '35680.00');
INSERT INTO `mx_balance` VALUES ('4754', 'sn701', '35660.00');
INSERT INTO `mx_balance` VALUES ('4755', 'sn701', '35650.00');
INSERT INTO `mx_balance` VALUES ('4756', 'sn701', '35640.00');
INSERT INTO `mx_balance` VALUES ('4757', 'sn701', '35630.00');
INSERT INTO `mx_balance` VALUES ('4758', 'sn701', '35610.00');
INSERT INTO `mx_balance` VALUES ('4759', 'sn701', '35580.00');
INSERT INTO `mx_balance` VALUES ('4760', 'sn701', '35560.00');
INSERT INTO `mx_balance` VALUES ('4761', 'sn701', '35540.00');
INSERT INTO `mx_balance` VALUES ('4762', 'sn701', '35530.00');
INSERT INTO `mx_balance` VALUES ('4763', 'sn701', '35520.00');
INSERT INTO `mx_balance` VALUES ('4764', 'sn701', '35510.00');
INSERT INTO `mx_balance` VALUES ('4765', 'sn701', '35490.00');
INSERT INTO `mx_balance` VALUES ('4766', 'sn701', '35480.00');
INSERT INTO `mx_balance` VALUES ('4767', 'sn701', '35440.00');
INSERT INTO `mx_balance` VALUES ('4768', 'sn701', '35420.00');
INSERT INTO `mx_balance` VALUES ('4769', 'sn701', '35410.00');
INSERT INTO `mx_balance` VALUES ('4770', 'sn701', '35380.00');
INSERT INTO `mx_balance` VALUES ('4771', 'sn701', '35360.00');
INSERT INTO `mx_balance` VALUES ('4772', 'sn701', '35350.00');
INSERT INTO `mx_balance` VALUES ('4773', 'sn701', '35330.00');
INSERT INTO `mx_balance` VALUES ('4774', 'sn701', '35320.00');
INSERT INTO `mx_balance` VALUES ('4775', 'sn701', '35310.00');
INSERT INTO `mx_balance` VALUES ('4776', 'sn701', '35290.00');
INSERT INTO `mx_balance` VALUES ('4777', 'sn701', '35280.00');
INSERT INTO `mx_balance` VALUES ('4778', 'sn701', '35250.00');
INSERT INTO `mx_balance` VALUES ('4779', 'sn701', '35200.00');
INSERT INTO `mx_balance` VALUES ('4780', 'sn701', '35180.00');
INSERT INTO `mx_balance` VALUES ('4781', 'sn701', '35090.00');
INSERT INTO `mx_balance` VALUES ('4782', 'sn701', '35080.00');
INSERT INTO `mx_balance` VALUES ('4783', 'sn701', '35060.00');
INSERT INTO `mx_balance` VALUES ('4784', 'sn701', '35030.00');
INSERT INTO `mx_balance` VALUES ('4785', 'sn701', '34970.00');
INSERT INTO `mx_balance` VALUES ('4786', 'sn701', '34910.00');
INSERT INTO `mx_balance` VALUES ('4787', 'sn701', '34880.00');
INSERT INTO `mx_balance` VALUES ('4788', 'sn701', '34870.00');
INSERT INTO `mx_balance` VALUES ('4789', 'sn701', '34850.00');
INSERT INTO `mx_balance` VALUES ('4790', 'sn701', '34840.00');
INSERT INTO `mx_balance` VALUES ('4791', 'sn701', '34820.00');
INSERT INTO `mx_balance` VALUES ('4792', 'sn701', '34790.00');
INSERT INTO `mx_balance` VALUES ('4793', 'sn701', '34760.00');
INSERT INTO `mx_balance` VALUES ('4794', 'sn701', '34700.00');
INSERT INTO `mx_balance` VALUES ('4795', 'sn701', '34690.00');
INSERT INTO `mx_balance` VALUES ('4796', 'sn701', '34680.00');
INSERT INTO `mx_balance` VALUES ('4797', 'sn701', '34650.00');
INSERT INTO `mx_balance` VALUES ('4798', 'sn701', '34620.00');
INSERT INTO `mx_balance` VALUES ('4799', 'sn701', '34560.00');
INSERT INTO `mx_balance` VALUES ('4800', 'sn701', '34540.00');
INSERT INTO `mx_balance` VALUES ('4801', 'sn701', '34520.00');
INSERT INTO `mx_balance` VALUES ('4802', 'sn701', '34500.00');
INSERT INTO `mx_balance` VALUES ('4803', 'sn701', '34490.00');
INSERT INTO `mx_balance` VALUES ('4804', 'sn701', '34470.00');
INSERT INTO `mx_balance` VALUES ('4805', 'sn701', '34460.00');
INSERT INTO `mx_balance` VALUES ('4806', 'sn701', '34450.00');
INSERT INTO `mx_balance` VALUES ('4807', 'sn701', '34430.00');
INSERT INTO `mx_balance` VALUES ('4808', 'sn701', '34420.00');
INSERT INTO `mx_balance` VALUES ('4809', 'sn701', '34400.00');
INSERT INTO `mx_balance` VALUES ('4810', 'sn701', '34380.00');
INSERT INTO `mx_balance` VALUES ('4811', 'sn701', '34360.00');
INSERT INTO `mx_balance` VALUES ('4812', 'sn701', '34350.00');
INSERT INTO `mx_balance` VALUES ('4813', 'sn701', '34300.00');
INSERT INTO `mx_balance` VALUES ('4814', 'sn701', '34280.00');
INSERT INTO `mx_balance` VALUES ('4815', 'sn701', '34220.00');
INSERT INTO `mx_balance` VALUES ('4816', 'sn701', '34210.00');
INSERT INTO `mx_balance` VALUES ('4817', 'sn701', '34150.00');
INSERT INTO `mx_balance` VALUES ('4818', 'sn701', '34100.00');
INSERT INTO `mx_balance` VALUES ('4819', 'sn701', '34050.00');
INSERT INTO `mx_balance` VALUES ('4820', 'sn701', '34000.00');
INSERT INTO `mx_balance` VALUES ('4821', 'sn701', '33950.00');
INSERT INTO `mx_balance` VALUES ('4822', 'sn701', '33910.00');
INSERT INTO `mx_balance` VALUES ('4823', 'sn701', '33890.00');
INSERT INTO `mx_balance` VALUES ('4824', 'sn701', '33870.00');
INSERT INTO `mx_balance` VALUES ('4825', 'sn701', '33850.00');
INSERT INTO `mx_balance` VALUES ('4826', 'sn701', '33820.00');
INSERT INTO `mx_balance` VALUES ('4827', 'sn701', '33790.00');
INSERT INTO `mx_balance` VALUES ('4828', 'sn701', '33760.00');
INSERT INTO `mx_balance` VALUES ('4829', 'sn701', '33730.00');
INSERT INTO `mx_balance` VALUES ('4830', 'sn701', '33680.00');
INSERT INTO `mx_balance` VALUES ('4831', 'sn701', '33620.00');
INSERT INTO `mx_balance` VALUES ('4832', 'sn701', '33550.00');
INSERT INTO `mx_balance` VALUES ('4833', 'sn701', '33510.00');
INSERT INTO `mx_balance` VALUES ('4834', 'sn701', '33460.00');
INSERT INTO `mx_balance` VALUES ('4835', 'sn701', '33440.00');
INSERT INTO `mx_balance` VALUES ('4836', 'sn701', '33430.00');
INSERT INTO `mx_balance` VALUES ('4837', 'sn701', '33410.00');
INSERT INTO `mx_balance` VALUES ('4838', 'sn701', '33370.00');
INSERT INTO `mx_balance` VALUES ('4839', 'sn701', '33360.00');
INSERT INTO `mx_balance` VALUES ('4840', 'sn701', '33340.00');
INSERT INTO `mx_balance` VALUES ('4841', 'sn701', '33330.00');
INSERT INTO `mx_balance` VALUES ('4842', 'sn701', '33320.00');
INSERT INTO `mx_balance` VALUES ('4843', 'sn701', '33310.00');
INSERT INTO `mx_balance` VALUES ('4844', 'sn701', '33290.00');
INSERT INTO `mx_balance` VALUES ('4845', 'sn701', '33280.00');
INSERT INTO `mx_balance` VALUES ('4846', 'sn701', '33260.00');
INSERT INTO `mx_balance` VALUES ('4847', 'sn701', '33230.00');
INSERT INTO `mx_balance` VALUES ('4848', 'sn701', '33210.00');
INSERT INTO `mx_balance` VALUES ('4849', 'sn701', '33190.00');
INSERT INTO `mx_balance` VALUES ('4850', 'sn701', '33170.00');
INSERT INTO `mx_balance` VALUES ('4851', 'sn701', '33160.00');
INSERT INTO `mx_balance` VALUES ('4852', 'sn701', '33150.00');
INSERT INTO `mx_balance` VALUES ('4853', 'sn701', '33130.00');
INSERT INTO `mx_balance` VALUES ('4854', 'sn701', '33120.00');
INSERT INTO `mx_balance` VALUES ('4855', 'sn701', '33110.00');
INSERT INTO `mx_balance` VALUES ('4856', 'sn701', '33100.00');
INSERT INTO `mx_balance` VALUES ('4857', 'sn701', '33090.00');
INSERT INTO `mx_balance` VALUES ('4858', 'sn701', '33080.00');
INSERT INTO `mx_balance` VALUES ('4859', 'sn701', '32840.00');
INSERT INTO `mx_balance` VALUES ('4860', 'sn701', '32600.00');
INSERT INTO `mx_balance` VALUES ('4861', 'sn701', '33000.00');
INSERT INTO `mx_balance` VALUES ('4862', 'sn701', '33400.00');
INSERT INTO `mx_balance` VALUES ('4863', 'sn701', '33390.00');
INSERT INTO `mx_balance` VALUES ('4864', 'sn701', '33380.00');
INSERT INTO `mx_balance` VALUES ('4865', 'sn701', '33340.00');
INSERT INTO `mx_balance` VALUES ('4866', 'sn701', '33320.00');
INSERT INTO `mx_balance` VALUES ('4867', 'sn701', '33310.00');
INSERT INTO `mx_balance` VALUES ('4868', 'sn701', '33270.00');
INSERT INTO `mx_balance` VALUES ('4869', 'sn701', '33220.00');
INSERT INTO `mx_balance` VALUES ('4870', 'sn701', '33210.00');
INSERT INTO `mx_balance` VALUES ('4871', 'sn701', '33180.00');
INSERT INTO `mx_balance` VALUES ('4872', 'sn701', '33170.00');
INSERT INTO `mx_balance` VALUES ('4873', 'sn701', '33160.00');
INSERT INTO `mx_balance` VALUES ('4874', 'sn701', '33150.00');
INSERT INTO `mx_balance` VALUES ('4875', 'sn701', '33120.00');
INSERT INTO `mx_balance` VALUES ('4876', 'sn701', '33110.00');
INSERT INTO `mx_balance` VALUES ('4877', 'sn701', '33100.00');
INSERT INTO `mx_balance` VALUES ('4878', 'sn701', '33050.00');
INSERT INTO `mx_balance` VALUES ('4879', 'sn701', '33030.00');
INSERT INTO `mx_balance` VALUES ('4880', 'sn701', '33010.00');
INSERT INTO `mx_balance` VALUES ('4881', 'sn701', '32970.00');
INSERT INTO `mx_balance` VALUES ('4882', 'sn701', '32950.00');
INSERT INTO `mx_balance` VALUES ('4883', 'sn701', '32940.00');
INSERT INTO `mx_balance` VALUES ('4884', 'sn701', '32890.00');
INSERT INTO `mx_balance` VALUES ('4885', 'sn701', '32840.00');
INSERT INTO `mx_balance` VALUES ('4886', 'sn701', '32820.00');
INSERT INTO `mx_balance` VALUES ('4887', 'sn701', '32810.00');
INSERT INTO `mx_balance` VALUES ('4888', 'sn701', '32790.00');
INSERT INTO `mx_balance` VALUES ('4889', 'sn701', '32780.00');
INSERT INTO `mx_balance` VALUES ('4890', 'sn701', '32760.00');
INSERT INTO `mx_balance` VALUES ('4891', 'sn701', '32730.00');
INSERT INTO `mx_balance` VALUES ('4892', 'sn701', '32700.00');
INSERT INTO `mx_balance` VALUES ('4893', 'sn701', '32600.00');
INSERT INTO `mx_balance` VALUES ('4894', 'sn701', '32500.00');
INSERT INTO `mx_balance` VALUES ('4895', 'sn701', '32490.00');
INSERT INTO `mx_balance` VALUES ('4896', 'sn701', '32480.00');
INSERT INTO `mx_balance` VALUES ('4897', 'sn701', '32460.00');
INSERT INTO `mx_balance` VALUES ('4898', 'sn701', '32440.00');
INSERT INTO `mx_balance` VALUES ('4899', 'sn701', '32430.00');
INSERT INTO `mx_balance` VALUES ('4900', 'sn701', '32410.00');
INSERT INTO `mx_balance` VALUES ('4901', 'sn701', '32400.00');
INSERT INTO `mx_balance` VALUES ('4902', 'sn701', '32380.00');
INSERT INTO `mx_balance` VALUES ('4903', 'sn701', '32360.00');
INSERT INTO `mx_balance` VALUES ('4904', 'sn701', '32350.00');
INSERT INTO `mx_balance` VALUES ('4905', 'sn701', '32340.00');
INSERT INTO `mx_balance` VALUES ('4906', 'sn701', '32330.00');
INSERT INTO `mx_balance` VALUES ('4907', 'sn701', '32320.00');
INSERT INTO `mx_balance` VALUES ('4908', 'sn701', '32300.00');
INSERT INTO `mx_balance` VALUES ('4909', 'sn701', '32270.00');
INSERT INTO `mx_balance` VALUES ('4910', 'sn701', '32250.00');
INSERT INTO `mx_balance` VALUES ('4911', 'sn701', '32230.00');
INSERT INTO `mx_balance` VALUES ('4912', 'sn701', '32210.00');
INSERT INTO `mx_balance` VALUES ('4913', 'sn701', '32180.00');
INSERT INTO `mx_balance` VALUES ('4914', 'sn701', '32170.00');
INSERT INTO `mx_balance` VALUES ('4915', 'sn701', '32160.00');
INSERT INTO `mx_balance` VALUES ('4916', 'sn701', '32150.00');
INSERT INTO `mx_balance` VALUES ('4917', 'sn701', '32120.00');
INSERT INTO `mx_balance` VALUES ('4918', 'sn701', '32070.00');
INSERT INTO `mx_balance` VALUES ('4919', 'sn701', '32040.00');
INSERT INTO `mx_balance` VALUES ('4920', 'sn701', '32030.00');
INSERT INTO `mx_balance` VALUES ('4921', 'sn701', '32010.00');
INSERT INTO `mx_balance` VALUES ('4922', 'sn701', '31990.00');
INSERT INTO `mx_balance` VALUES ('4923', 'sn701', '31940.00');
INSERT INTO `mx_balance` VALUES ('4924', 'sn701', '31910.00');
INSERT INTO `mx_balance` VALUES ('4925', 'sn701', '31890.00');
INSERT INTO `mx_balance` VALUES ('4926', 'sn701', '31860.00');
INSERT INTO `mx_balance` VALUES ('4927', 'sn701', '31830.00');
INSERT INTO `mx_balance` VALUES ('4928', 'sn701', '31810.00');
INSERT INTO `mx_balance` VALUES ('4929', 'sn701', '31790.00');
INSERT INTO `mx_balance` VALUES ('4930', 'sn701', '31760.00');
INSERT INTO `mx_balance` VALUES ('4931', 'sn701', '31680.00');
INSERT INTO `mx_balance` VALUES ('4932', 'sn701', '31640.00');
INSERT INTO `mx_balance` VALUES ('4933', 'sn701', '31630.00');
INSERT INTO `mx_balance` VALUES ('4934', 'sn701', '31620.00');
INSERT INTO `mx_balance` VALUES ('4935', 'sn701', '31600.00');
INSERT INTO `mx_balance` VALUES ('4936', 'sn701', '31590.00');
INSERT INTO `mx_balance` VALUES ('4937', 'sn701', '31570.00');
INSERT INTO `mx_balance` VALUES ('4938', 'sn701', '31560.00');
INSERT INTO `mx_balance` VALUES ('4939', 'sn701', '31540.00');
INSERT INTO `mx_balance` VALUES ('4940', 'sn701', '31520.00');
INSERT INTO `mx_balance` VALUES ('4941', 'sn701', '31500.00');
INSERT INTO `mx_balance` VALUES ('4942', 'sn701', '31480.00');
INSERT INTO `mx_balance` VALUES ('4943', 'sn701', '31470.00');
INSERT INTO `mx_balance` VALUES ('4944', 'sn701', '31460.00');
INSERT INTO `mx_balance` VALUES ('4945', 'sn701', '31420.00');
INSERT INTO `mx_balance` VALUES ('4946', 'sn701', '31380.00');
INSERT INTO `mx_balance` VALUES ('4947', 'sn701', '31360.00');
INSERT INTO `mx_balance` VALUES ('4948', 'sn701', '31450.00');
INSERT INTO `mx_balance` VALUES ('4949', 'sn701', '31420.00');
INSERT INTO `mx_balance` VALUES ('4950', 'sn701', '31380.00');
INSERT INTO `mx_balance` VALUES ('4951', 'sn701', '31370.00');
INSERT INTO `mx_balance` VALUES ('4952', 'sn701', '31360.00');
INSERT INTO `mx_balance` VALUES ('4953', 'sn701', '31340.00');
INSERT INTO `mx_balance` VALUES ('4954', 'sn701', '31330.00');
INSERT INTO `mx_balance` VALUES ('4955', 'sn701', '31320.00');
INSERT INTO `mx_balance` VALUES ('4956', 'sn701', '31300.00');
INSERT INTO `mx_balance` VALUES ('4957', 'sn701', '31270.00');
INSERT INTO `mx_balance` VALUES ('4958', 'sn701', '31240.00');
INSERT INTO `mx_balance` VALUES ('4959', 'sn701', '31220.00');
INSERT INTO `mx_balance` VALUES ('4960', 'sn701', '31200.00');
INSERT INTO `mx_balance` VALUES ('4961', 'sn701', '31180.00');
INSERT INTO `mx_balance` VALUES ('4962', 'sn701', '31160.00');
INSERT INTO `mx_balance` VALUES ('4963', 'sn701', '31140.00');
INSERT INTO `mx_balance` VALUES ('4964', 'sn701', '31120.00');
INSERT INTO `mx_balance` VALUES ('4965', 'sn701', '31100.00');
INSERT INTO `mx_balance` VALUES ('4966', 'sn701', '31090.00');
INSERT INTO `mx_balance` VALUES ('4967', 'sn701', '31080.00');
INSERT INTO `mx_balance` VALUES ('4968', 'sn701', '31070.00');
INSERT INTO `mx_balance` VALUES ('4969', 'sn701', '31020.00');
INSERT INTO `mx_balance` VALUES ('4970', 'sn701', '31000.00');
INSERT INTO `mx_balance` VALUES ('4971', 'sn701', '30990.00');
INSERT INTO `mx_balance` VALUES ('4972', 'sn701', '30980.00');
INSERT INTO `mx_balance` VALUES ('4973', 'sn701', '30940.00');
INSERT INTO `mx_balance` VALUES ('4974', 'sn704', '50000.00');
INSERT INTO `mx_balance` VALUES ('4975', 'sn701', '30910.00');
INSERT INTO `mx_balance` VALUES ('4976', 'sn701', '30900.00');
INSERT INTO `mx_balance` VALUES ('4977', 'sn701', '30840.00');
INSERT INTO `mx_balance` VALUES ('4978', 'sn701', '30820.00');
INSERT INTO `mx_balance` VALUES ('4979', 'sn701', '30790.00');
INSERT INTO `mx_balance` VALUES ('4980', 'sn701', '30780.00');
INSERT INTO `mx_balance` VALUES ('4981', 'sn701', '30760.00');
INSERT INTO `mx_balance` VALUES ('4982', 'sn701', '30730.00');
INSERT INTO `mx_balance` VALUES ('4983', 'sn701', '30710.00');
INSERT INTO `mx_balance` VALUES ('4984', 'sn701', '30670.00');
INSERT INTO `mx_balance` VALUES ('4985', 'sn701', '30660.00');
INSERT INTO `mx_balance` VALUES ('4986', 'sn701', '30640.00');
INSERT INTO `mx_balance` VALUES ('4987', 'sn701', '30610.00');
INSERT INTO `mx_balance` VALUES ('4988', 'sn701', '30590.00');
INSERT INTO `mx_balance` VALUES ('4989', 'sn701', '30570.00');
INSERT INTO `mx_balance` VALUES ('4990', 'sn701', '30560.00');
INSERT INTO `mx_balance` VALUES ('4991', 'sn701', '30510.00');
INSERT INTO `mx_balance` VALUES ('4992', 'sn701', '30480.00');
INSERT INTO `mx_balance` VALUES ('4993', 'sn701', '30440.00');
INSERT INTO `mx_balance` VALUES ('4994', 'sn701', '30400.00');
INSERT INTO `mx_balance` VALUES ('4995', 'sn701', '30380.00');
INSERT INTO `mx_balance` VALUES ('4996', 'sn701', '30360.00');
INSERT INTO `mx_balance` VALUES ('4997', 'sn701', '30350.00');
INSERT INTO `mx_balance` VALUES ('4998', 'sn704', '49990.00');
INSERT INTO `mx_balance` VALUES ('4999', 'sn704', '49980.00');
INSERT INTO `mx_balance` VALUES ('5000', 'sn701', '30310.00');
INSERT INTO `mx_balance` VALUES ('5001', 'sn704', '49950.00');
INSERT INTO `mx_balance` VALUES ('5002', 'sn701', '30250.00');
INSERT INTO `mx_balance` VALUES ('5003', 'sn701', '30220.00');
INSERT INTO `mx_balance` VALUES ('5004', 'sn701', '30160.00');
INSERT INTO `mx_balance` VALUES ('5005', 'sn701', '30130.00');
INSERT INTO `mx_balance` VALUES ('5006', 'sn704', '49940.00');
INSERT INTO `mx_balance` VALUES ('5007', 'sn704', '49920.00');
INSERT INTO `mx_balance` VALUES ('5008', 'sn701', '30110.00');
INSERT INTO `mx_balance` VALUES ('5009', 'sn701', '30090.00');
INSERT INTO `mx_balance` VALUES ('5010', 'sn701', '30030.00');
INSERT INTO `mx_balance` VALUES ('5011', 'sn701', '29950.00');
INSERT INTO `mx_balance` VALUES ('5012', 'sn701', '29870.00');
INSERT INTO `mx_balance` VALUES ('5013', 'sn701', '29790.00');
INSERT INTO `mx_balance` VALUES ('5014', 'sn701', '29610.00');
INSERT INTO `mx_balance` VALUES ('5015', 'sn701', '29590.00');
INSERT INTO `mx_balance` VALUES ('5016', 'sn701', '29580.00');
INSERT INTO `mx_balance` VALUES ('5017', 'sn701', '29570.00');
INSERT INTO `mx_balance` VALUES ('5018', 'sn701', '29840.00');
INSERT INTO `mx_balance` VALUES ('5019', 'sn704', '49910.00');
INSERT INTO `mx_balance` VALUES ('5020', 'sn704', '49900.00');
INSERT INTO `mx_balance` VALUES ('5021', 'sn701', '29790.00');
INSERT INTO `mx_balance` VALUES ('5022', 'sn701', '29750.00');
INSERT INTO `mx_balance` VALUES ('5023', 'sn701', '29740.00');
INSERT INTO `mx_balance` VALUES ('5024', 'sn701', '29730.00');
INSERT INTO `mx_balance` VALUES ('5025', 'sn701', '29680.00');
INSERT INTO `mx_balance` VALUES ('5026', 'sn701', '29660.00');
INSERT INTO `mx_balance` VALUES ('5027', 'sn701', '29650.00');
INSERT INTO `mx_balance` VALUES ('5028', 'sn701', '29640.00');
INSERT INTO `mx_balance` VALUES ('5029', 'sn704', '49890.00');
INSERT INTO `mx_balance` VALUES ('5030', 'sn704', '49870.00');
INSERT INTO `mx_balance` VALUES ('5031', 'sn704', '49860.00');
INSERT INTO `mx_balance` VALUES ('5032', 'sn704', '49850.00');
INSERT INTO `mx_balance` VALUES ('5033', 'sn704', '49830.00');
INSERT INTO `mx_balance` VALUES ('5034', 'sn704', '49820.00');
INSERT INTO `mx_balance` VALUES ('5035', 'sn701', '29620.00');
INSERT INTO `mx_balance` VALUES ('5036', 'sn701', '29600.00');
INSERT INTO `mx_balance` VALUES ('5037', 'sn701', '29560.00');
INSERT INTO `mx_balance` VALUES ('5038', 'sn701', '29550.00');
INSERT INTO `mx_balance` VALUES ('5039', 'sn701', '29510.00');
INSERT INTO `mx_balance` VALUES ('5040', 'sn701', '29500.00');
INSERT INTO `mx_balance` VALUES ('5041', 'sn701', '29440.00');
INSERT INTO `mx_balance` VALUES ('5042', 'sn701', '29410.00');
INSERT INTO `mx_balance` VALUES ('5043', 'sn701', '29390.00');
INSERT INTO `mx_balance` VALUES ('5044', 'sn701', '29350.00');
INSERT INTO `mx_balance` VALUES ('5045', 'sn701', '29330.00');
INSERT INTO `mx_balance` VALUES ('5046', 'sn701', '29310.00');
INSERT INTO `mx_balance` VALUES ('5047', 'sn701', '29250.00');
INSERT INTO `mx_balance` VALUES ('5048', 'sn701', '29230.00');
INSERT INTO `mx_balance` VALUES ('5049', 'sn701', '29150.00');
INSERT INTO `mx_balance` VALUES ('5050', 'sn701', '29130.00');
INSERT INTO `mx_balance` VALUES ('5051', 'sn701', '29100.00');
INSERT INTO `mx_balance` VALUES ('5052', 'sn701', '29080.00');
INSERT INTO `mx_balance` VALUES ('5053', 'sn701', '29070.00');
INSERT INTO `mx_balance` VALUES ('5054', 'sn701', '29060.00');
INSERT INTO `mx_balance` VALUES ('5055', 'sn701', '29040.00');
INSERT INTO `mx_balance` VALUES ('5056', 'sn701', '29020.00');
INSERT INTO `mx_balance` VALUES ('5057', 'sn701', '29010.00');
INSERT INTO `mx_balance` VALUES ('5058', 'sn701', '28990.00');
INSERT INTO `mx_balance` VALUES ('5059', 'sn701', '28940.00');
INSERT INTO `mx_balance` VALUES ('5060', 'sn701', '28920.00');
INSERT INTO `mx_balance` VALUES ('5061', 'sn701', '28820.00');
INSERT INTO `mx_balance` VALUES ('5062', 'sn701', '28810.00');
INSERT INTO `mx_balance` VALUES ('5063', 'sn701', '28790.00');
INSERT INTO `mx_balance` VALUES ('5064', 'sn701', '28690.00');
INSERT INTO `mx_balance` VALUES ('5065', 'sn701', '28680.00');
INSERT INTO `mx_balance` VALUES ('5066', 'sn701', '28670.00');
INSERT INTO `mx_balance` VALUES ('5067', 'sn701', '28660.00');
INSERT INTO `mx_balance` VALUES ('5068', 'sn701', '28640.00');
INSERT INTO `mx_balance` VALUES ('5069', 'sn701', '28610.00');
INSERT INTO `mx_balance` VALUES ('5070', 'sn701', '28600.00');
INSERT INTO `mx_balance` VALUES ('5071', 'sn701', '28590.00');
INSERT INTO `mx_balance` VALUES ('5072', 'sn701', '28540.00');
INSERT INTO `mx_balance` VALUES ('5073', 'sn701', '28520.00');
INSERT INTO `mx_balance` VALUES ('5074', 'sn701', '28500.00');
INSERT INTO `mx_balance` VALUES ('5075', 'sn701', '28490.00');
INSERT INTO `mx_balance` VALUES ('5076', 'sn701', '28440.00');
INSERT INTO `mx_balance` VALUES ('5077', 'sn701', '28420.00');
INSERT INTO `mx_balance` VALUES ('5078', 'sn701', '28400.00');
INSERT INTO `mx_balance` VALUES ('5079', 'sn701', '28380.00');
INSERT INTO `mx_balance` VALUES ('5080', 'sn701', '28370.00');
INSERT INTO `mx_balance` VALUES ('5081', 'sn701', '28360.00');
INSERT INTO `mx_balance` VALUES ('5082', 'sn701', '28330.00');
INSERT INTO `mx_balance` VALUES ('5083', 'sn701', '28290.00');
INSERT INTO `mx_balance` VALUES ('5084', 'sn701', '28250.00');
INSERT INTO `mx_balance` VALUES ('5085', 'sn701', '28220.00');
INSERT INTO `mx_balance` VALUES ('5086', 'sn701', '28210.00');
INSERT INTO `mx_balance` VALUES ('5087', 'sn701', '28190.00');
INSERT INTO `mx_balance` VALUES ('5088', 'sn701', '28150.00');
INSERT INTO `mx_balance` VALUES ('5089', 'sn701', '28130.00');
INSERT INTO `mx_balance` VALUES ('5090', 'sn701', '28120.00');
INSERT INTO `mx_balance` VALUES ('5091', 'sn701', '28100.00');
INSERT INTO `mx_balance` VALUES ('5092', 'sn701', '28090.00');
INSERT INTO `mx_balance` VALUES ('5093', 'sn701', '28080.00');
INSERT INTO `mx_balance` VALUES ('5094', 'sn701', '28060.00');
INSERT INTO `mx_balance` VALUES ('5095', 'sn701', '28040.00');
INSERT INTO `mx_balance` VALUES ('5096', 'sn701', '28020.00');
INSERT INTO `mx_balance` VALUES ('5097', 'sn701', '28010.00');
INSERT INTO `mx_balance` VALUES ('5098', 'sn701', '27990.00');
INSERT INTO `mx_balance` VALUES ('5099', 'sn701', '27980.00');
INSERT INTO `mx_balance` VALUES ('5100', 'sn701', '27960.00');
INSERT INTO `mx_balance` VALUES ('5101', 'sn701', '27910.00');
INSERT INTO `mx_balance` VALUES ('5102', 'sn701', '27900.00');
INSERT INTO `mx_balance` VALUES ('5103', 'sn701', '27850.00');
INSERT INTO `mx_balance` VALUES ('5104', 'sn701', '27700.00');
INSERT INTO `mx_balance` VALUES ('5105', 'sn701', '27670.00');
INSERT INTO `mx_balance` VALUES ('5106', 'sn701', '27610.00');
INSERT INTO `mx_balance` VALUES ('5107', 'sn701', '27570.00');
INSERT INTO `mx_balance` VALUES ('5108', 'sn701', '27540.00');
INSERT INTO `mx_balance` VALUES ('5109', 'sn701', '27520.00');
INSERT INTO `mx_balance` VALUES ('5110', 'sn701', '27490.00');
INSERT INTO `mx_balance` VALUES ('5111', 'sn701', '27400.00');
INSERT INTO `mx_balance` VALUES ('5112', 'sn701', '27390.00');
INSERT INTO `mx_balance` VALUES ('5113', 'sn701', '27360.00');
INSERT INTO `mx_balance` VALUES ('5114', 'sn701', '27350.00');
INSERT INTO `mx_balance` VALUES ('5115', 'sn701', '27290.00');
INSERT INTO `mx_balance` VALUES ('5116', 'sn701', '27270.00');
INSERT INTO `mx_balance` VALUES ('5117', 'sn701', '27240.00');
INSERT INTO `mx_balance` VALUES ('5118', 'sn701', '27140.00');
INSERT INTO `mx_balance` VALUES ('5119', 'sn701', '27040.00');
INSERT INTO `mx_balance` VALUES ('5120', 'sn701', '26940.00');
INSERT INTO `mx_balance` VALUES ('5121', 'sn701', '26840.00');
INSERT INTO `mx_balance` VALUES ('5122', 'sn701', '26810.00');
INSERT INTO `mx_balance` VALUES ('5123', 'sn701', '26770.00');
INSERT INTO `mx_balance` VALUES ('5124', 'sn701', '26710.00');
INSERT INTO `mx_balance` VALUES ('5125', 'sn701', '26680.00');
INSERT INTO `mx_balance` VALUES ('5126', 'sn701', '26670.00');
INSERT INTO `mx_balance` VALUES ('5127', 'sn701', '26620.00');
INSERT INTO `mx_balance` VALUES ('5128', 'sn701', '26570.00');
INSERT INTO `mx_balance` VALUES ('5129', 'sn701', '26510.00');
INSERT INTO `mx_balance` VALUES ('5130', 'sn701', '26480.00');
INSERT INTO `mx_balance` VALUES ('5131', 'sn701', '26440.00');
INSERT INTO `mx_balance` VALUES ('5132', 'sn701', '26380.00');
INSERT INTO `mx_balance` VALUES ('5133', 'sn701', '26280.00');
INSERT INTO `mx_balance` VALUES ('5134', 'sn701', '25980.00');
INSERT INTO `mx_balance` VALUES ('5135', 'sn701', '25820.00');
INSERT INTO `mx_balance` VALUES ('5136', 'sn701', '25320.00');
INSERT INTO `mx_balance` VALUES ('5137', 'sn701', '24720.00');
INSERT INTO `mx_balance` VALUES ('5138', 'sn701', '25620.00');
INSERT INTO `mx_balance` VALUES ('5139', 'sn701', '25980.00');
INSERT INTO `mx_balance` VALUES ('5140', 'sn701', '25960.00');
INSERT INTO `mx_balance` VALUES ('5141', 'sn701', '25950.00');
INSERT INTO `mx_balance` VALUES ('5142', 'sn701', '25940.00');
INSERT INTO `mx_balance` VALUES ('5143', 'sn701', '25930.00');
INSERT INTO `mx_balance` VALUES ('5144', 'sn701', '25920.00');
INSERT INTO `mx_balance` VALUES ('5145', 'sn701', '25880.00');
INSERT INTO `mx_balance` VALUES ('5146', 'sn701', '25870.00');
INSERT INTO `mx_balance` VALUES ('5147', 'sn701', '25840.00');
INSERT INTO `mx_balance` VALUES ('5148', 'sn701', '25820.00');
INSERT INTO `mx_balance` VALUES ('5149', 'sn701', '25770.00');
INSERT INTO `mx_balance` VALUES ('5150', 'sn701', '25760.00');
INSERT INTO `mx_balance` VALUES ('5151', 'sn701', '25750.00');
INSERT INTO `mx_balance` VALUES ('5152', 'sn701', '25650.00');
INSERT INTO `mx_balance` VALUES ('5153', 'sn701', '25630.00');
INSERT INTO `mx_balance` VALUES ('5154', 'sn701', '25540.00');
INSERT INTO `mx_balance` VALUES ('5155', 'sn701', '25520.00');
INSERT INTO `mx_balance` VALUES ('5156', 'sn701', '25510.00');
INSERT INTO `mx_balance` VALUES ('5157', 'sn701', '25500.00');
INSERT INTO `mx_balance` VALUES ('5158', 'sn701', '25480.00');
INSERT INTO `mx_balance` VALUES ('5159', 'sn701', '25420.00');
INSERT INTO `mx_balance` VALUES ('5160', 'sn701', '25300.00');
INSERT INTO `mx_balance` VALUES ('5161', 'sn701', '25260.00');
INSERT INTO `mx_balance` VALUES ('5162', 'sn701', '25160.00');
INSERT INTO `mx_balance` VALUES ('5163', 'sn701', '25250.00');
INSERT INTO `mx_balance` VALUES ('5164', 'sn701', '25200.00');
INSERT INTO `mx_balance` VALUES ('5165', 'sn701', '25150.00');
INSERT INTO `mx_balance` VALUES ('5166', 'sn701', '25050.00');
INSERT INTO `mx_balance` VALUES ('5167', 'sn701', '24950.00');
INSERT INTO `mx_balance` VALUES ('5168', 'sn701', '24850.00');
INSERT INTO `mx_balance` VALUES ('5169', 'sn701', '24750.00');
INSERT INTO `mx_balance` VALUES ('5170', 'sn701', '24650.00');
INSERT INTO `mx_balance` VALUES ('5171', 'sn701', '24550.00');
INSERT INTO `mx_balance` VALUES ('5172', 'sn701', '24500.00');
INSERT INTO `mx_balance` VALUES ('5173', 'sn701', '24400.00');
INSERT INTO `mx_balance` VALUES ('5174', 'sn701', '24300.00');
INSERT INTO `mx_balance` VALUES ('5175', 'sn701', '24200.00');
INSERT INTO `mx_balance` VALUES ('5176', 'sn701', '24100.00');
INSERT INTO `mx_balance` VALUES ('5177', 'sn701', '24000.00');
INSERT INTO `mx_balance` VALUES ('5178', 'sn701', '23950.00');
INSERT INTO `mx_balance` VALUES ('5179', 'sn701', '24040.00');
INSERT INTO `mx_balance` VALUES ('5180', 'sn701', '23940.00');
INSERT INTO `mx_balance` VALUES ('5181', 'sn701', '23890.00');
INSERT INTO `mx_balance` VALUES ('5182', 'sn701', '23980.00');
INSERT INTO `mx_balance` VALUES ('5183', 'sn701', '23880.00');
INSERT INTO `mx_balance` VALUES ('5184', 'sn701', '23780.00');
INSERT INTO `mx_balance` VALUES ('5185', 'sn701', '23960.00');
INSERT INTO `mx_balance` VALUES ('5186', 'sn701', '23860.00');
INSERT INTO `mx_balance` VALUES ('5187', 'sn701', '23760.00');
INSERT INTO `mx_balance` VALUES ('5188', 'sn701', '23940.00');
INSERT INTO `mx_balance` VALUES ('5189', 'sn701', '23840.00');
INSERT INTO `mx_balance` VALUES ('5190', 'sn701', '23740.00');
INSERT INTO `mx_balance` VALUES ('5191', 'sn701', '23690.00');
INSERT INTO `mx_balance` VALUES ('5192', 'sn701', '23780.00');
INSERT INTO `mx_balance` VALUES ('5193', 'sn701', '23660.00');
INSERT INTO `mx_balance` VALUES ('5194', 'sn701', '23510.00');
INSERT INTO `mx_balance` VALUES ('5195', 'sn701', '23380.00');
INSERT INTO `mx_balance` VALUES ('5196', 'sn701', '23230.00');
INSERT INTO `mx_balance` VALUES ('5197', 'sn701', '23080.00');
INSERT INTO `mx_balance` VALUES ('5198', 'sn701', '22930.00');
INSERT INTO `mx_balance` VALUES ('5199', 'sn701', '22780.00');
INSERT INTO `mx_balance` VALUES ('5200', 'sn701', '22630.00');
INSERT INTO `mx_balance` VALUES ('5201', 'sn701', '22500.00');
INSERT INTO `mx_balance` VALUES ('5202', 'sn701', '22400.00');
INSERT INTO `mx_balance` VALUES ('5203', 'sn701', '22360.00');
INSERT INTO `mx_balance` VALUES ('5204', 'sn701', '22330.00');
INSERT INTO `mx_balance` VALUES ('5205', 'sn701', '22280.00');
INSERT INTO `mx_balance` VALUES ('5206', 'sn701', '22190.00');
INSERT INTO `mx_balance` VALUES ('5207', 'sn701', '22050.00');
INSERT INTO `mx_balance` VALUES ('5208', 'sn701', '21950.00');
INSERT INTO `mx_balance` VALUES ('5209', 'sn701', '21800.00');
INSERT INTO `mx_balance` VALUES ('5210', 'sn701', '21750.00');
INSERT INTO `mx_balance` VALUES ('5211', 'sn701', '21620.00');
INSERT INTO `mx_balance` VALUES ('5212', 'sn701', '21470.00');
INSERT INTO `mx_balance` VALUES ('5213', 'sn701', '21310.00');
INSERT INTO `mx_balance` VALUES ('5214', 'sn701', '21160.00');
INSERT INTO `mx_balance` VALUES ('5215', 'sn701', '21010.00');
INSERT INTO `mx_balance` VALUES ('5216', 'sn701', '20910.00');
INSERT INTO `mx_balance` VALUES ('5217', 'sn701', '20750.00');
INSERT INTO `mx_balance` VALUES ('5218', 'sn701', '20520.00');
INSERT INTO `mx_balance` VALUES ('5219', 'sn701', '20420.00');
INSERT INTO `mx_balance` VALUES ('5220', 'sn701', '20600.00');
INSERT INTO `mx_balance` VALUES ('5221', 'sn701', '20390.00');
INSERT INTO `mx_balance` VALUES ('5222', 'sn701', '20290.00');
INSERT INTO `mx_balance` VALUES ('5223', 'sn701', '20470.00');
INSERT INTO `mx_balance` VALUES ('5224', 'sn701', '20270.00');
INSERT INTO `mx_balance` VALUES ('5225', 'sn701', '20070.00');
INSERT INTO `mx_balance` VALUES ('5226', 'sn701', '19970.00');
INSERT INTO `mx_balance` VALUES ('5227', 'sn701', '19800.00');
INSERT INTO `mx_balance` VALUES ('5228', 'sn701', '19700.00');
INSERT INTO `mx_balance` VALUES ('5229', 'sn701', '19880.00');
INSERT INTO `mx_balance` VALUES ('5230', 'sn701', '19670.00');
INSERT INTO `mx_balance` VALUES ('5231', 'sn701', '19570.00');
INSERT INTO `mx_balance` VALUES ('5232', 'sn701', '19470.00');
INSERT INTO `mx_balance` VALUES ('5233', 'sn701', '19240.00');
INSERT INTO `mx_balance` VALUES ('5234', 'sn701', '19140.00');
INSERT INTO `mx_balance` VALUES ('5235', 'sn701', '19040.00');
INSERT INTO `mx_balance` VALUES ('5236', 'sn701', '19220.00');
INSERT INTO `mx_balance` VALUES ('5237', 'sn701', '19400.00');
INSERT INTO `mx_balance` VALUES ('5238', 'sn701', '19350.00');
INSERT INTO `mx_balance` VALUES ('5239', 'sn701', '19300.00');
INSERT INTO `mx_balance` VALUES ('5240', 'sn701', '19250.00');
INSERT INTO `mx_balance` VALUES ('5241', 'sn701', '19340.00');
INSERT INTO `mx_balance` VALUES ('5242', 'sn701', '19040.00');
INSERT INTO `mx_balance` VALUES ('5243', 'sn701', '18740.00');
INSERT INTO `mx_balance` VALUES ('5244', 'sn701', '19240.00');
INSERT INTO `mx_balance` VALUES ('5245', 'sn701', '19740.00');
INSERT INTO `mx_balance` VALUES ('5246', 'sn701', '19720.00');
INSERT INTO `mx_balance` VALUES ('5247', 'sn701', '19710.00');
INSERT INTO `mx_balance` VALUES ('5248', 'sn701', '19600.00');
INSERT INTO `mx_balance` VALUES ('5249', 'sn701', '19480.00');
INSERT INTO `mx_balance` VALUES ('5250', 'sn701', '19580.00');
INSERT INTO `mx_balance` VALUES ('5251', 'sn701', '19570.00');
INSERT INTO `mx_balance` VALUES ('5252', 'sn701', '19540.00');
INSERT INTO `mx_balance` VALUES ('5253', 'sn701', '19530.00');
INSERT INTO `mx_balance` VALUES ('5254', 'sn701', '19510.00');
INSERT INTO `mx_balance` VALUES ('5255', 'sn701', '19500.00');
INSERT INTO `mx_balance` VALUES ('5256', 'sn701', '19450.00');
INSERT INTO `mx_balance` VALUES ('5257', 'sn701', '19430.00');
INSERT INTO `mx_balance` VALUES ('5258', 'sn701', '19420.00');
INSERT INTO `mx_balance` VALUES ('5259', 'sn704', '49810.00');
INSERT INTO `mx_balance` VALUES ('5260', 'sn704', '49800.00');
INSERT INTO `mx_balance` VALUES ('5261', 'sn701', '19320.00');
INSERT INTO `mx_balance` VALUES ('5262', 'sn701', '19220.00');
INSERT INTO `mx_balance` VALUES ('5263', 'sn701', '19160.00');
INSERT INTO `mx_balance` VALUES ('5264', 'sn701', '19120.00');
INSERT INTO `mx_balance` VALUES ('5265', 'sn701', '19110.00');
INSERT INTO `mx_balance` VALUES ('5266', 'sn701', '19070.00');
INSERT INTO `mx_balance` VALUES ('5267', 'sn701', '19010.00');
INSERT INTO `mx_balance` VALUES ('5268', 'sn701', '18970.00');
INSERT INTO `mx_balance` VALUES ('5269', 'sn701', '18930.00');
INSERT INTO `mx_balance` VALUES ('5270', 'sn701', '18920.00');
INSERT INTO `mx_balance` VALUES ('5271', 'sn701', '18900.00');
INSERT INTO `mx_balance` VALUES ('5272', 'sn701', '18880.00');
INSERT INTO `mx_balance` VALUES ('5273', 'sn701', '18870.00');
INSERT INTO `mx_balance` VALUES ('5274', 'sn701', '18850.00');
INSERT INTO `mx_balance` VALUES ('5275', 'sn701', '18840.00');
INSERT INTO `mx_balance` VALUES ('5276', 'sn701', '18830.00');
INSERT INTO `mx_balance` VALUES ('5277', 'sn701', '18790.00');
INSERT INTO `mx_balance` VALUES ('5278', 'sn701', '18750.00');
INSERT INTO `mx_balance` VALUES ('5279', 'sn701', '18710.00');
INSERT INTO `mx_balance` VALUES ('5280', 'sn701', '18610.00');
INSERT INTO `mx_balance` VALUES ('5281', 'sn701', '18590.00');
INSERT INTO `mx_balance` VALUES ('5282', 'sn701', '18550.00');
INSERT INTO `mx_balance` VALUES ('5283', 'sn701', '18490.00');
INSERT INTO `mx_balance` VALUES ('5284', 'sn701', '18460.00');
INSERT INTO `mx_balance` VALUES ('5285', 'sn701', '18430.00');
INSERT INTO `mx_balance` VALUES ('5286', 'sn701', '18410.00');
INSERT INTO `mx_balance` VALUES ('5287', 'sn701', '18370.00');
INSERT INTO `mx_balance` VALUES ('5288', 'sn701', '18340.00');
INSERT INTO `mx_balance` VALUES ('5289', 'sn701', '18320.00');
INSERT INTO `mx_balance` VALUES ('5290', 'sn701', '18280.00');
INSERT INTO `mx_balance` VALUES ('5291', 'sn701', '18220.00');
INSERT INTO `mx_balance` VALUES ('5292', 'sn701', '18210.00');
INSERT INTO `mx_balance` VALUES ('5293', 'sn701', '18200.00');
INSERT INTO `mx_balance` VALUES ('5294', 'sn701', '18170.00');
INSERT INTO `mx_balance` VALUES ('5295', 'sn701', '18140.00');
INSERT INTO `mx_balance` VALUES ('5296', 'sn701', '18120.00');
INSERT INTO `mx_balance` VALUES ('5297', 'sn701', '18090.00');
INSERT INTO `mx_balance` VALUES ('5298', 'sn701', '18080.00');
INSERT INTO `mx_balance` VALUES ('5299', 'sn701', '18060.00');
INSERT INTO `mx_balance` VALUES ('5300', 'sn701', '18010.00');
INSERT INTO `mx_balance` VALUES ('5301', 'sn701', '18000.00');
INSERT INTO `mx_balance` VALUES ('5302', 'sn701', '17990.00');
INSERT INTO `mx_balance` VALUES ('5303', 'sn704', '49790.00');
INSERT INTO `mx_balance` VALUES ('5304', 'sn701', '17940.00');
INSERT INTO `mx_balance` VALUES ('5305', 'sn701', '17890.00');
INSERT INTO `mx_balance` VALUES ('5306', 'sn701', '17880.00');
INSERT INTO `mx_balance` VALUES ('5307', 'sn701', '17830.00');
INSERT INTO `mx_balance` VALUES ('5308', 'sn701', '17820.00');
INSERT INTO `mx_balance` VALUES ('5309', 'sn704', '49780.00');
INSERT INTO `mx_balance` VALUES ('5310', 'sn701', '17780.00');
INSERT INTO `mx_balance` VALUES ('5311', 'sn701', '17770.00');
INSERT INTO `mx_balance` VALUES ('5312', 'sn701', '17750.00');
INSERT INTO `mx_balance` VALUES ('5313', 'sn701', '17700.00');
INSERT INTO `mx_balance` VALUES ('5314', 'sn701', '17680.00');
INSERT INTO `mx_balance` VALUES ('5315', 'sn701', '17630.00');
INSERT INTO `mx_balance` VALUES ('5316', 'sn701', '17610.00');
INSERT INTO `mx_balance` VALUES ('5317', 'sn701', '17600.00');
INSERT INTO `mx_balance` VALUES ('5318', 'sn701', '17590.00');
INSERT INTO `mx_balance` VALUES ('5319', 'sn701', '17580.00');
INSERT INTO `mx_balance` VALUES ('5320', 'sn704', '49770.00');
INSERT INTO `mx_balance` VALUES ('5321', 'sn704', '49670.00');
INSERT INTO `mx_balance` VALUES ('5322', 'sn701', '17570.00');
INSERT INTO `mx_balance` VALUES ('5323', 'sn704', '49850.00');
INSERT INTO `mx_balance` VALUES ('5324', 'sn701', '17550.00');
INSERT INTO `mx_balance` VALUES ('5325', 'sn704', '49750.00');
INSERT INTO `mx_balance` VALUES ('5326', 'sn701', '17530.00');
INSERT INTO `mx_balance` VALUES ('5327', 'sn704', '49840.00');
INSERT INTO `mx_balance` VALUES ('5328', 'sn701', '17510.00');
INSERT INTO `mx_balance` VALUES ('5329', 'sn701', '17490.00');
INSERT INTO `mx_balance` VALUES ('5330', 'sn701', '17450.00');
INSERT INTO `mx_balance` VALUES ('5331', 'sn701', '17430.00');
INSERT INTO `mx_balance` VALUES ('5332', 'sn701', '17400.00');
INSERT INTO `mx_balance` VALUES ('5333', 'sn701', '17380.00');
INSERT INTO `mx_balance` VALUES ('5334', 'sn701', '17360.00');
INSERT INTO `mx_balance` VALUES ('5335', 'sn701', '17340.00');
INSERT INTO `mx_balance` VALUES ('5336', 'sn704', '49820.00');
INSERT INTO `mx_balance` VALUES ('5337', 'sn701', '17320.00');
INSERT INTO `mx_balance` VALUES ('5338', 'sn704', '49720.00');
INSERT INTO `mx_balance` VALUES ('5339', 'sn704', '49810.00');
INSERT INTO `mx_balance` VALUES ('5340', 'sn704', '49710.00');
INSERT INTO `mx_balance` VALUES ('5341', 'sn704', '49800.00');
INSERT INTO `mx_balance` VALUES ('5342', 'sn701', '17280.00');
INSERT INTO `mx_balance` VALUES ('5343', 'sn704', '49770.00');
INSERT INTO `mx_balance` VALUES ('5344', 'sn704', '49740.00');
INSERT INTO `mx_balance` VALUES ('5345', 'sn704', '49710.00');
INSERT INTO `mx_balance` VALUES ('5346', 'sn704', '49700.00');
INSERT INTO `mx_balance` VALUES ('5347', 'sn701', '17220.00');
INSERT INTO `mx_balance` VALUES ('5348', 'sn704', '49660.00');
INSERT INTO `mx_balance` VALUES ('5349', 'sn704', '49620.00');
INSERT INTO `mx_balance` VALUES ('5350', 'sn704', '49590.00');
INSERT INTO `mx_balance` VALUES ('5351', 'sn704', '49560.00');
INSERT INTO `mx_balance` VALUES ('5352', 'sn704', '49550.00');
INSERT INTO `mx_balance` VALUES ('5353', 'sn704', '49510.00');
INSERT INTO `mx_balance` VALUES ('5354', 'sn704', '49480.00');
INSERT INTO `mx_balance` VALUES ('5355', 'sn704', '49420.00');
INSERT INTO `mx_balance` VALUES ('5356', 'sn704', '49400.00');
INSERT INTO `mx_balance` VALUES ('5357', 'sn704', '49320.00');
INSERT INTO `mx_balance` VALUES ('5358', 'sn704', '49240.00');
INSERT INTO `mx_balance` VALUES ('5359', 'sn704', '49220.00');
INSERT INTO `mx_balance` VALUES ('5360', 'sn704', '49200.00');
INSERT INTO `mx_balance` VALUES ('5361', 'sn704', '49180.00');
INSERT INTO `mx_balance` VALUES ('5362', 'sn704', '49080.00');
INSERT INTO `mx_balance` VALUES ('5363', 'sn704', '49000.00');
INSERT INTO `mx_balance` VALUES ('5364', 'sn704', '48920.00');
INSERT INTO `mx_balance` VALUES ('5365', 'sn704', '48910.00');
INSERT INTO `mx_balance` VALUES ('5366', 'sn701', '17120.00');
INSERT INTO `mx_balance` VALUES ('5367', 'sn704', '48900.00');
INSERT INTO `mx_balance` VALUES ('5368', 'sn701', '17100.00');
INSERT INTO `mx_balance` VALUES ('5369', 'sn701', '17020.00');
INSERT INTO `mx_balance` VALUES ('5370', 'sn701', '16920.00');
INSERT INTO `mx_balance` VALUES ('5371', 'sn701', '16890.00');
INSERT INTO `mx_balance` VALUES ('5372', 'sn704', '48890.00');
INSERT INTO `mx_balance` VALUES ('5373', 'sn704', '48880.00');
INSERT INTO `mx_balance` VALUES ('5374', 'sn704', '48860.00');
INSERT INTO `mx_balance` VALUES ('5375', 'sn701', '16870.00');
INSERT INTO `mx_balance` VALUES ('5376', 'sn701', '16850.00');
INSERT INTO `mx_balance` VALUES ('5377', 'sn701', '16830.00');
INSERT INTO `mx_balance` VALUES ('5378', 'sn701', '16780.00');
INSERT INTO `mx_balance` VALUES ('5379', 'sn701', '16720.00');
INSERT INTO `mx_balance` VALUES ('5380', 'sn701', '16690.00');
INSERT INTO `mx_balance` VALUES ('5381', 'sn701', '16680.00');
INSERT INTO `mx_balance` VALUES ('5382', 'sn701', '16670.00');
INSERT INTO `mx_balance` VALUES ('5383', 'sn701', '16640.00');
INSERT INTO `mx_balance` VALUES ('5384', 'sn701', '16620.00');
INSERT INTO `mx_balance` VALUES ('5385', 'sn701', '16610.00');
INSERT INTO `mx_balance` VALUES ('5386', 'sn701', '16570.00');
INSERT INTO `mx_balance` VALUES ('5387', 'sn701', '16470.00');
INSERT INTO `mx_balance` VALUES ('5388', 'sn701', '16420.00');
INSERT INTO `mx_balance` VALUES ('5389', 'sn701', '16410.00');
INSERT INTO `mx_balance` VALUES ('5390', 'sn701', '16380.00');
INSERT INTO `mx_balance` VALUES ('5391', 'sn701', '16360.00');
INSERT INTO `mx_balance` VALUES ('5392', 'sn701', '16320.00');
INSERT INTO `mx_balance` VALUES ('5393', 'sn701', '16260.00');
INSERT INTO `mx_balance` VALUES ('5394', 'sn704', '48840.00');
INSERT INTO `mx_balance` VALUES ('5395', 'sn704', '48830.00');
INSERT INTO `mx_balance` VALUES ('5396', 'sn704', '48820.00');
INSERT INTO `mx_balance` VALUES ('5397', 'sn704', '48810.00');
INSERT INTO `mx_balance` VALUES ('5398', 'sn704', '48800.00');
INSERT INTO `mx_balance` VALUES ('5399', 'sn704', '48700.00');
INSERT INTO `mx_balance` VALUES ('5400', 'sn704', '48690.00');
INSERT INTO `mx_balance` VALUES ('5401', 'sn701', '16240.00');
INSERT INTO `mx_balance` VALUES ('5402', 'sn701', '16210.00');
INSERT INTO `mx_balance` VALUES ('5403', 'sn701', '16180.00');
INSERT INTO `mx_balance` VALUES ('5404', 'sn701', '16160.00');
INSERT INTO `mx_balance` VALUES ('5405', 'sn701', '16140.00');
INSERT INTO `mx_balance` VALUES ('5406', 'sn701', '16130.00');
INSERT INTO `mx_balance` VALUES ('5407', 'sn701', '16120.00');
INSERT INTO `mx_balance` VALUES ('5408', 'sn701', '16100.00');
INSERT INTO `mx_balance` VALUES ('5409', 'sn704', '48640.00');
INSERT INTO `mx_balance` VALUES ('5410', 'sn701', '16000.00');
INSERT INTO `mx_balance` VALUES ('5411', 'sn701', '15990.00');
INSERT INTO `mx_balance` VALUES ('5412', 'sn701', '15970.00');
INSERT INTO `mx_balance` VALUES ('5413', 'sn701', '15950.00');
INSERT INTO `mx_balance` VALUES ('5414', 'sn701', '15930.00');
INSERT INTO `mx_balance` VALUES ('5415', 'sn701', '15880.00');
INSERT INTO `mx_balance` VALUES ('5416', 'sn701', '15860.00');
INSERT INTO `mx_balance` VALUES ('5417', 'sn701', '15810.00');
INSERT INTO `mx_balance` VALUES ('5418', 'sn701', '15760.00');
INSERT INTO `mx_balance` VALUES ('5419', 'sn701', '15710.00');
INSERT INTO `mx_balance` VALUES ('5420', 'sn701', '15690.00');
INSERT INTO `mx_balance` VALUES ('5421', 'sn701', '15640.00');
INSERT INTO `mx_balance` VALUES ('5422', 'sn701', '15590.00');
INSERT INTO `mx_balance` VALUES ('5423', 'sn701', '15580.00');
INSERT INTO `mx_balance` VALUES ('5424', 'sn701', '15570.00');
INSERT INTO `mx_balance` VALUES ('5425', 'sn701', '15520.00');
INSERT INTO `mx_balance` VALUES ('5426', 'sn701', '15490.00');
INSERT INTO `mx_balance` VALUES ('5427', 'sn701', '15440.00');
INSERT INTO `mx_balance` VALUES ('5428', 'sn701', '15420.00');
INSERT INTO `mx_balance` VALUES ('5429', 'sn701', '15410.00');
INSERT INTO `mx_balance` VALUES ('5430', 'sn701', '15400.00');
INSERT INTO `mx_balance` VALUES ('5431', 'sn701', '15390.00');
INSERT INTO `mx_balance` VALUES ('5432', 'sn701', '15380.00');
INSERT INTO `mx_balance` VALUES ('5433', 'sn701', '15360.00');
INSERT INTO `mx_balance` VALUES ('5434', 'sn701', '15350.00');
INSERT INTO `mx_balance` VALUES ('5435', 'sn701', '15340.00');
INSERT INTO `mx_balance` VALUES ('5436', 'sn704', '48630.00');
INSERT INTO `mx_balance` VALUES ('5437', 'sn704', '48620.00');
INSERT INTO `mx_balance` VALUES ('5438', 'sn704', '48570.00');
INSERT INTO `mx_balance` VALUES ('5439', 'sn704', '48550.00');
INSERT INTO `mx_balance` VALUES ('5440', 'expert132', '1004.00');
INSERT INTO `mx_balance` VALUES ('5441', 'expert132', '2004.00');
INSERT INTO `mx_balance` VALUES ('5442', 'expert132', '1904.00');
INSERT INTO `mx_balance` VALUES ('5443', 'expert132', '1784.00');
INSERT INTO `mx_balance` VALUES ('5444', 'sn701', '15290.00');
INSERT INTO `mx_balance` VALUES ('5445', 'sn701', '15280.00');
INSERT INTO `mx_balance` VALUES ('5446', 'sn701', '15260.00');
INSERT INTO `mx_balance` VALUES ('5447', 'sn701', '15160.00');
INSERT INTO `mx_balance` VALUES ('5448', 'sn701', '15060.00');
INSERT INTO `mx_balance` VALUES ('5449', 'sn701', '14960.00');
INSERT INTO `mx_balance` VALUES ('5450', 'sn701', '14760.00');
INSERT INTO `mx_balance` VALUES ('5451', 'sn701', '14710.00');
INSERT INTO `mx_balance` VALUES ('5452', 'sn701', '14560.00');
INSERT INTO `mx_balance` VALUES ('5453', 'sn701', '14510.00');
INSERT INTO `mx_balance` VALUES ('5454', 'sn701', '14470.00');
INSERT INTO `mx_balance` VALUES ('5455', 'sn701', '14420.00');
INSERT INTO `mx_balance` VALUES ('5456', 'sn701', '14410.00');
INSERT INTO `mx_balance` VALUES ('5457', 'sn701', '14360.00');
INSERT INTO `mx_balance` VALUES ('5458', 'sn701', '14350.00');
INSERT INTO `mx_balance` VALUES ('5459', 'sn701', '14340.00');
INSERT INTO `mx_balance` VALUES ('5460', 'sn701', '14310.00');
INSERT INTO `mx_balance` VALUES ('5461', 'sn701', '14280.00');
INSERT INTO `mx_balance` VALUES ('5462', 'sn701', '14270.00');
INSERT INTO `mx_balance` VALUES ('5463', 'sn701', '14220.00');
INSERT INTO `mx_balance` VALUES ('5464', 'sn701', '14210.00');
INSERT INTO `mx_balance` VALUES ('5465', 'sn701', '14200.00');
INSERT INTO `mx_balance` VALUES ('5466', 'sn701', '13950.00');
INSERT INTO `mx_balance` VALUES ('5467', 'sn701', '13890.00');
INSERT INTO `mx_balance` VALUES ('5468', 'sn701', '13870.00');
INSERT INTO `mx_balance` VALUES ('5469', 'sn701', '13860.00');
INSERT INTO `mx_balance` VALUES ('5470', 'sn701', '13850.00');
INSERT INTO `mx_balance` VALUES ('5471', 'sn701', '13750.00');
INSERT INTO `mx_balance` VALUES ('5472', 'sn701', '13660.00');
INSERT INTO `mx_balance` VALUES ('5473', 'sn701', '13600.00');
INSERT INTO `mx_balance` VALUES ('5474', 'sn701', '13550.00');
INSERT INTO `mx_balance` VALUES ('5475', 'sn701', '13450.00');
INSERT INTO `mx_balance` VALUES ('5476', 'sn701', '13350.00');
INSERT INTO `mx_balance` VALUES ('5477', 'sn701', '13300.00');
INSERT INTO `mx_balance` VALUES ('5478', 'sn701', '13100.00');
INSERT INTO `mx_balance` VALUES ('5479', 'sn701', '12990.00');
INSERT INTO `mx_balance` VALUES ('5480', 'sn701', '12970.00');
INSERT INTO `mx_balance` VALUES ('5481', 'sn701', '12920.00');
INSERT INTO `mx_balance` VALUES ('5482', 'sn701', '12820.00');
INSERT INTO `mx_balance` VALUES ('5483', 'sn701', '12800.00');
INSERT INTO `mx_balance` VALUES ('5484', 'sn701', '12760.00');
INSERT INTO `mx_balance` VALUES ('5485', 'sn701', '12700.00');
INSERT INTO `mx_balance` VALUES ('5486', 'sn701', '12660.00');
INSERT INTO `mx_balance` VALUES ('5487', 'sn701', '12610.00');
INSERT INTO `mx_balance` VALUES ('5488', 'sn701', '12590.00');
INSERT INTO `mx_balance` VALUES ('5489', 'sn701', '12530.00');
INSERT INTO `mx_balance` VALUES ('5490', 'sn701', '12430.00');
INSERT INTO `mx_balance` VALUES ('5491', 'sn701', '12330.00');
INSERT INTO `mx_balance` VALUES ('5492', 'sn701', '12300.00');
INSERT INTO `mx_balance` VALUES ('5493', 'sn701', '12260.00');
INSERT INTO `mx_balance` VALUES ('5494', 'sn701', '12230.00');
INSERT INTO `mx_balance` VALUES ('5495', 'sn701', '12210.00');
INSERT INTO `mx_balance` VALUES ('5496', 'sn701', '12180.00');
INSERT INTO `mx_balance` VALUES ('5497', 'sn701', '12160.00');
INSERT INTO `mx_balance` VALUES ('5498', 'sn701', '12140.00');
INSERT INTO `mx_balance` VALUES ('5499', 'sn701', '12100.00');
INSERT INTO `mx_balance` VALUES ('5500', 'sn701', '12080.00');
INSERT INTO `mx_balance` VALUES ('5501', 'sn701', '12050.00');
INSERT INTO `mx_balance` VALUES ('5502', 'sn701', '12020.00');
INSERT INTO `mx_balance` VALUES ('5503', 'sn701', '11970.00');
INSERT INTO `mx_balance` VALUES ('5504', 'sn701', '11950.00');
INSERT INTO `mx_balance` VALUES ('5505', 'sn701', '11910.00');
INSERT INTO `mx_balance` VALUES ('5506', 'sn701', '11890.00');
INSERT INTO `mx_balance` VALUES ('5507', 'sn701', '11850.00');
INSERT INTO `mx_balance` VALUES ('5508', 'sn701', '11790.00');
INSERT INTO `mx_balance` VALUES ('5509', 'sn701', '11780.00');
INSERT INTO `mx_balance` VALUES ('5510', 'sn701', '11770.00');
INSERT INTO `mx_balance` VALUES ('5511', 'sn701', '11670.00');
INSERT INTO `mx_balance` VALUES ('5512', 'sn701', '11570.00');
INSERT INTO `mx_balance` VALUES ('5513', 'sn701', '11490.00');
INSERT INTO `mx_balance` VALUES ('5514', 'sn701', '11450.00');
INSERT INTO `mx_balance` VALUES ('5515', 'sn701', '11420.00');
INSERT INTO `mx_balance` VALUES ('5516', 'sn701', '11400.00');
INSERT INTO `mx_balance` VALUES ('5517', 'sn701', '11380.00');
INSERT INTO `mx_balance` VALUES ('5518', 'sn701', '11350.00');
INSERT INTO `mx_balance` VALUES ('5519', 'sn701', '11330.00');
INSERT INTO `mx_balance` VALUES ('5520', 'sn701', '11300.00');
INSERT INTO `mx_balance` VALUES ('5521', 'sn701', '11280.00');
INSERT INTO `mx_balance` VALUES ('5522', 'sn701', '11270.00');
INSERT INTO `mx_balance` VALUES ('5523', 'sn701', '11250.00');
INSERT INTO `mx_balance` VALUES ('5524', 'sn701', '11230.00');
INSERT INTO `mx_balance` VALUES ('5525', 'sn701', '11210.00');
INSERT INTO `mx_balance` VALUES ('5526', 'sn701', '11160.00');
INSERT INTO `mx_balance` VALUES ('5527', 'sn701', '11150.00');
INSERT INTO `mx_balance` VALUES ('5528', 'sn701', '11140.00');
INSERT INTO `mx_balance` VALUES ('5529', 'sn701', '11120.00');
INSERT INTO `mx_balance` VALUES ('5530', 'sn701', '11110.00');
INSERT INTO `mx_balance` VALUES ('5531', 'sn701', '11050.00');
INSERT INTO `mx_balance` VALUES ('5532', 'sn701', '10990.00');
INSERT INTO `mx_balance` VALUES ('5533', 'sn701', '10930.00');
INSERT INTO `mx_balance` VALUES ('5534', 'sn701', '10870.00');
INSERT INTO `mx_balance` VALUES ('5535', 'sn701', '10840.00');
INSERT INTO `mx_balance` VALUES ('5536', 'sn701', '10820.00');
INSERT INTO `mx_balance` VALUES ('5537', 'sn701', '10800.00');
INSERT INTO `mx_balance` VALUES ('5538', 'sn701', '10740.00');
INSERT INTO `mx_balance` VALUES ('5539', 'sn701', '10730.00');
INSERT INTO `mx_balance` VALUES ('5540', 'sn701', '10670.00');
INSERT INTO `mx_balance` VALUES ('5541', 'sn701', '10580.00');
INSERT INTO `mx_balance` VALUES ('5542', 'sn701', '10520.00');
INSERT INTO `mx_balance` VALUES ('5543', 'sn701', '10430.00');
INSERT INTO `mx_balance` VALUES ('5544', 'sn701', '10410.00');
INSERT INTO `mx_balance` VALUES ('5545', 'sn701', '10370.00');
INSERT INTO `mx_balance` VALUES ('5546', 'sn701', '10350.00');
INSERT INTO `mx_balance` VALUES ('5547', 'sn701', '10330.00');
INSERT INTO `mx_balance` VALUES ('5548', 'sn701', '10290.00');
INSERT INTO `mx_balance` VALUES ('5549', 'sn701', '10270.00');
INSERT INTO `mx_balance` VALUES ('5550', 'sn701', '10170.00');
INSERT INTO `mx_balance` VALUES ('5551', 'sn701', '10070.00');
INSERT INTO `mx_balance` VALUES ('5552', 'sn701', '10060.00');
INSERT INTO `mx_balance` VALUES ('5553', 'sn701', '10010.00');
INSERT INTO `mx_balance` VALUES ('5554', 'sn701', '9910.00');
INSERT INTO `mx_balance` VALUES ('5555', 'sn701', '9760.00');
INSERT INTO `mx_balance` VALUES ('5556', 'sn701', '9660.00');
INSERT INTO `mx_balance` VALUES ('5557', 'sn701', '9600.00');
INSERT INTO `mx_balance` VALUES ('5558', 'sn701', '9560.00');
INSERT INTO `mx_balance` VALUES ('5559', 'sn701', '9540.00');
INSERT INTO `mx_balance` VALUES ('5560', 'sn701', '9520.00');
INSERT INTO `mx_balance` VALUES ('5561', 'sn701', '9510.00');
INSERT INTO `mx_balance` VALUES ('5562', 'sn701', '9360.00');
INSERT INTO `mx_balance` VALUES ('5563', 'sn701', '9270.00');
INSERT INTO `mx_balance` VALUES ('5564', 'sn701', '9240.00');
INSERT INTO `mx_balance` VALUES ('5565', 'sn701', '9150.00');
INSERT INTO `mx_balance` VALUES ('5566', 'sn701', '9140.00');
INSERT INTO `mx_balance` VALUES ('5567', 'sn701', '9130.00');
INSERT INTO `mx_balance` VALUES ('5568', 'sn701', '9120.00');
INSERT INTO `mx_balance` VALUES ('5569', 'sn701', '9110.00');
INSERT INTO `mx_balance` VALUES ('5570', 'sn701', '9090.00');
INSERT INTO `mx_balance` VALUES ('5571', 'sn701', '9040.00');
INSERT INTO `mx_balance` VALUES ('5572', 'sn701', '8990.00');
INSERT INTO `mx_balance` VALUES ('5573', 'sn701', '8980.00');
INSERT INTO `mx_balance` VALUES ('5574', 'sn701', '8960.00');
INSERT INTO `mx_balance` VALUES ('5575', 'sn701', '8950.00');
INSERT INTO `mx_balance` VALUES ('5576', 'sn701', '8940.00');
INSERT INTO `mx_balance` VALUES ('5577', 'sn701', '8930.00');
INSERT INTO `mx_balance` VALUES ('5578', 'sn701', '8910.00');
INSERT INTO `mx_balance` VALUES ('5579', 'sn701', '8890.00');
INSERT INTO `mx_balance` VALUES ('5580', 'sn701', '8870.00');
INSERT INTO `mx_balance` VALUES ('5581', 'sn701', '8850.00');
INSERT INTO `mx_balance` VALUES ('5582', 'sn701', '8830.00');
INSERT INTO `mx_balance` VALUES ('5583', 'sn701', '8810.00');
INSERT INTO `mx_balance` VALUES ('5584', 'sn701', '8790.00');
INSERT INTO `mx_balance` VALUES ('5585', 'sn701', '8780.00');
INSERT INTO `mx_balance` VALUES ('5586', 'sn701', '8740.00');
INSERT INTO `mx_balance` VALUES ('5587', 'sn701', '8720.00');
INSERT INTO `mx_balance` VALUES ('5588', 'sn701', '8690.00');
INSERT INTO `mx_balance` VALUES ('5589', 'sn701', '8670.00');
INSERT INTO `mx_balance` VALUES ('5590', 'sn701', '8630.00');
INSERT INTO `mx_balance` VALUES ('5591', 'sn701', '8610.00');
INSERT INTO `mx_balance` VALUES ('5592', 'sn701', '8590.00');
INSERT INTO `mx_balance` VALUES ('5593', 'sn701', '8570.00');
INSERT INTO `mx_balance` VALUES ('5594', 'sn701', '8560.00');
INSERT INTO `mx_balance` VALUES ('5595', 'sn701', '8540.00');
INSERT INTO `mx_balance` VALUES ('5596', 'sn701', '8520.00');
INSERT INTO `mx_balance` VALUES ('5597', 'sn701', '8490.00');
INSERT INTO `mx_balance` VALUES ('5598', 'sn701', '8450.00');
INSERT INTO `mx_balance` VALUES ('5599', 'sn701', '8440.00');
INSERT INTO `mx_balance` VALUES ('5600', 'sn701', '8420.00');
INSERT INTO `mx_balance` VALUES ('5601', 'sn701', '8380.00');
INSERT INTO `mx_balance` VALUES ('5602', 'sn701', '8370.00');
INSERT INTO `mx_balance` VALUES ('5603', 'sn701', '8350.00');
INSERT INTO `mx_balance` VALUES ('5604', 'sn701', '8340.00');
INSERT INTO `mx_balance` VALUES ('5605', 'sn701', '8310.00');
INSERT INTO `mx_balance` VALUES ('5606', 'sn701', '8300.00');
INSERT INTO `mx_balance` VALUES ('5607', 'sn701', '8280.00');
INSERT INTO `mx_balance` VALUES ('5608', 'sn701', '8250.00');
INSERT INTO `mx_balance` VALUES ('5609', 'sn701', '8240.00');
INSERT INTO `mx_balance` VALUES ('5610', 'sn701', '8220.00');
INSERT INTO `mx_balance` VALUES ('5611', 'sn701', '8190.00');
INSERT INTO `mx_balance` VALUES ('5612', 'sn701', '8160.00');
INSERT INTO `mx_balance` VALUES ('5613', 'sn701', '8120.00');
INSERT INTO `mx_balance` VALUES ('5614', 'sn701', '8100.00');
INSERT INTO `mx_balance` VALUES ('5615', 'sn701', '8080.00');
INSERT INTO `mx_balance` VALUES ('5616', 'sn701', '8060.00');
INSERT INTO `mx_balance` VALUES ('5617', 'sn701', '8040.00');
INSERT INTO `mx_balance` VALUES ('5618', 'sn701', '8020.00');
INSERT INTO `mx_balance` VALUES ('5619', 'sn701', '7990.00');
INSERT INTO `mx_balance` VALUES ('5620', 'sn701', '7980.00');
INSERT INTO `mx_balance` VALUES ('5621', 'sn701', '7970.00');
INSERT INTO `mx_balance` VALUES ('5622', 'sn701', '7950.00');
INSERT INTO `mx_balance` VALUES ('5623', 'sn701', '7940.00');
INSERT INTO `mx_balance` VALUES ('5624', 'sn701', '7930.00');
INSERT INTO `mx_balance` VALUES ('5625', 'sn701', '7910.00');
INSERT INTO `mx_balance` VALUES ('5626', 'sn701', '7870.00');
INSERT INTO `mx_balance` VALUES ('5627', 'sn701', '7830.00');
INSERT INTO `mx_balance` VALUES ('5628', 'sn701', '7730.00');
INSERT INTO `mx_balance` VALUES ('5629', 'sn701', '7710.00');
INSERT INTO `mx_balance` VALUES ('5630', 'sn701', '7670.00');
INSERT INTO `mx_balance` VALUES ('5631', 'sn701', '7640.00');
INSERT INTO `mx_balance` VALUES ('5632', 'sn701', '7530.00');
INSERT INTO `mx_balance` VALUES ('5633', 'sn701', '7500.00');
INSERT INTO `mx_balance` VALUES ('5634', 'sn701', '7470.00');
INSERT INTO `mx_balance` VALUES ('5635', 'sn701', '7410.00');
INSERT INTO `mx_balance` VALUES ('5636', 'sn701', '7390.00');
INSERT INTO `mx_balance` VALUES ('5637', 'sn701', '7370.00');
INSERT INTO `mx_balance` VALUES ('5638', 'sn701', '7360.00');
INSERT INTO `mx_balance` VALUES ('5639', 'sn701', '7310.00');
INSERT INTO `mx_balance` VALUES ('5640', 'sn701', '7280.00');
INSERT INTO `mx_balance` VALUES ('5641', 'sn701', '7230.00');
INSERT INTO `mx_balance` VALUES ('5642', 'sn701', '7210.00');
INSERT INTO `mx_balance` VALUES ('5643', 'sn701', '7200.00');
INSERT INTO `mx_balance` VALUES ('5644', 'sn701', '7180.00');
INSERT INTO `mx_balance` VALUES ('5645', 'sn701', '7130.00');
INSERT INTO `mx_balance` VALUES ('5646', 'sn701', '7100.00');
INSERT INTO `mx_balance` VALUES ('5647', 'sn701', '7090.00');
INSERT INTO `mx_balance` VALUES ('5648', 'sn701', '7060.00');
INSERT INTO `mx_balance` VALUES ('5649', 'sn701', '7040.00');
INSERT INTO `mx_balance` VALUES ('5650', 'sn701', '7020.00');
INSERT INTO `mx_balance` VALUES ('5651', 'sn701', '6990.00');
INSERT INTO `mx_balance` VALUES ('5652', 'sn701', '6950.00');
INSERT INTO `mx_balance` VALUES ('5653', 'sn701', '6930.00');
INSERT INTO `mx_balance` VALUES ('5654', 'sn701', '6910.00');
INSERT INTO `mx_balance` VALUES ('5655', 'sn701', '6890.00');
INSERT INTO `mx_balance` VALUES ('5656', 'sn701', '6870.00');
INSERT INTO `mx_balance` VALUES ('5657', 'sn701', '6850.00');
INSERT INTO `mx_balance` VALUES ('5658', 'sn701', '6840.00');
INSERT INTO `mx_balance` VALUES ('5659', 'sn701', '6820.00');
INSERT INTO `mx_balance` VALUES ('5660', 'sn701', '6810.00');
INSERT INTO `mx_balance` VALUES ('5661', 'sn701', '6800.00');
INSERT INTO `mx_balance` VALUES ('5662', 'sn701', '6790.00');
INSERT INTO `mx_balance` VALUES ('5663', 'sn701', '6770.00');
INSERT INTO `mx_balance` VALUES ('5664', 'sn701', '6750.00');
INSERT INTO `mx_balance` VALUES ('5665', 'sn701', '6730.00');
INSERT INTO `mx_balance` VALUES ('5666', 'sn701', '6710.00');
INSERT INTO `mx_balance` VALUES ('5667', 'sn701', '6700.00');
INSERT INTO `mx_balance` VALUES ('5668', 'sn701', '6680.00');
INSERT INTO `mx_balance` VALUES ('5669', 'sn704', '48540.00');
INSERT INTO `mx_balance` VALUES ('5670', 'sn701', '6670.00');
INSERT INTO `mx_balance` VALUES ('5671', 'sn701', '6660.00');
INSERT INTO `mx_balance` VALUES ('5672', 'sn704', '48530.00');
INSERT INTO `mx_balance` VALUES ('5673', 'sn701', '6630.00');
INSERT INTO `mx_balance` VALUES ('5674', 'sn701', '6610.00');
INSERT INTO `mx_balance` VALUES ('5675', 'sn701', '6590.00');
INSERT INTO `mx_balance` VALUES ('5676', 'sn701', '6570.00');
INSERT INTO `mx_balance` VALUES ('5677', 'sn701', '6550.00');
INSERT INTO `mx_balance` VALUES ('5678', 'sn701', '6540.00');
INSERT INTO `mx_balance` VALUES ('5679', 'sn701', '6490.00');
INSERT INTO `mx_balance` VALUES ('5680', 'sn701', '6480.00');
INSERT INTO `mx_balance` VALUES ('5681', 'sn701', '6450.00');
INSERT INTO `mx_balance` VALUES ('5682', 'sn701', '6420.00');
INSERT INTO `mx_balance` VALUES ('5683', 'sn701', '6400.00');
INSERT INTO `mx_balance` VALUES ('5684', 'sn701', '6380.00');
INSERT INTO `mx_balance` VALUES ('5685', 'sn701', '6370.00');
INSERT INTO `mx_balance` VALUES ('5686', 'sn701', '6350.00');
INSERT INTO `mx_balance` VALUES ('5687', 'sn701', '6340.00');
INSERT INTO `mx_balance` VALUES ('5688', 'sn701', '6320.00');
INSERT INTO `mx_balance` VALUES ('5689', 'sn701', '6250.00');
INSERT INTO `mx_balance` VALUES ('5690', 'sn701', '6240.00');
INSERT INTO `mx_balance` VALUES ('5691', 'sn701', '6190.00');
INSERT INTO `mx_balance` VALUES ('5692', 'sn701', '6140.00');
INSERT INTO `mx_balance` VALUES ('5693', 'sn701', '6120.00');
INSERT INTO `mx_balance` VALUES ('5694', 'sn701', '6110.00');
INSERT INTO `mx_balance` VALUES ('5695', 'sn701', '6100.00');
INSERT INTO `mx_balance` VALUES ('5696', 'sn701', '6090.00');
INSERT INTO `mx_balance` VALUES ('5697', 'sn701', '6050.00');
INSERT INTO `mx_balance` VALUES ('5698', 'sn701', '5990.00');
INSERT INTO `mx_balance` VALUES ('5699', 'sn701', '5840.00');
INSERT INTO `mx_balance` VALUES ('5700', 'sn704', '48520.00');
INSERT INTO `mx_balance` VALUES ('5701', 'sn704', '48510.00');
INSERT INTO `mx_balance` VALUES ('5702', 'sn701', '5820.00');
INSERT INTO `mx_balance` VALUES ('5703', 'sn701', '5800.00');
INSERT INTO `mx_balance` VALUES ('5704', 'sn701', '5780.00');
INSERT INTO `mx_balance` VALUES ('5705', 'sn704', '48490.00');
INSERT INTO `mx_balance` VALUES ('5706', 'sn701', '5760.00');
INSERT INTO `mx_balance` VALUES ('5707', 'sn701', '5680.00');
INSERT INTO `mx_balance` VALUES ('5708', 'sn701', '5590.00');
INSERT INTO `mx_balance` VALUES ('5709', 'sn704', '48440.00');
INSERT INTO `mx_balance` VALUES ('5710', 'sn704', '48430.00');
INSERT INTO `mx_balance` VALUES ('5711', 'sn704', '48410.00');
INSERT INTO `mx_balance` VALUES ('5712', 'sn704', '48390.00');
INSERT INTO `mx_balance` VALUES ('5713', 'sn704', '48360.00');
INSERT INTO `mx_balance` VALUES ('5714', 'sn704', '48300.00');
INSERT INTO `mx_balance` VALUES ('5715', 'sn704', '48280.00');
INSERT INTO `mx_balance` VALUES ('5716', 'sn704', '48240.00');
INSERT INTO `mx_balance` VALUES ('5717', 'sn704', '48220.00');
INSERT INTO `mx_balance` VALUES ('5718', 'sn701', '5440.00');
INSERT INTO `mx_balance` VALUES ('5719', 'sn704', '48210.00');
INSERT INTO `mx_balance` VALUES ('5720', 'sn701', '5410.00');
INSERT INTO `mx_balance` VALUES ('5721', 'sn701', '5380.00');
INSERT INTO `mx_balance` VALUES ('5722', 'sn704', '48200.00');
INSERT INTO `mx_balance` VALUES ('5723', 'sn704', '48180.00');
INSERT INTO `mx_balance` VALUES ('5724', 'sn704', '48100.00');
INSERT INTO `mx_balance` VALUES ('5725', 'sn704', '48080.00');
INSERT INTO `mx_balance` VALUES ('5726', 'sn704', '48060.00');
INSERT INTO `mx_balance` VALUES ('5727', 'sn701', '5320.00');
INSERT INTO `mx_balance` VALUES ('5728', 'sn701', '5260.00');
INSERT INTO `mx_balance` VALUES ('5729', 'sn701', '5230.00');
INSERT INTO `mx_balance` VALUES ('5730', 'sn701', '5210.00');
INSERT INTO `mx_balance` VALUES ('5731', 'sn701', '5180.00');
INSERT INTO `mx_balance` VALUES ('5732', 'sn701', '5090.00');
INSERT INTO `mx_balance` VALUES ('5733', 'sn701', '5030.00');
INSERT INTO `mx_balance` VALUES ('5734', 'sn701', '5020.00');
INSERT INTO `mx_balance` VALUES ('5735', 'sn701', '5000.00');
INSERT INTO `mx_balance` VALUES ('5736', 'sn701', '4980.00');
INSERT INTO `mx_balance` VALUES ('5737', 'sn701', '4970.00');
INSERT INTO `mx_balance` VALUES ('5738', 'sn701', '4960.00');
INSERT INTO `mx_balance` VALUES ('5739', 'sn701', '4930.00');
INSERT INTO `mx_balance` VALUES ('5740', 'sn701', '4880.00');
INSERT INTO `mx_balance` VALUES ('5741', 'sn701', '4830.00');
INSERT INTO `mx_balance` VALUES ('5742', 'sn704', '48020.00');
INSERT INTO `mx_balance` VALUES ('5743', 'sn704', '47960.00');
INSERT INTO `mx_balance` VALUES ('5744', 'sn701', '4820.00');
INSERT INTO `mx_balance` VALUES ('5745', 'sn704', '47940.00');
INSERT INTO `mx_balance` VALUES ('5746', 'sn701', '4810.00');
INSERT INTO `mx_balance` VALUES ('5747', 'sn701', '4800.00');
INSERT INTO `mx_balance` VALUES ('5748', 'sn701', '4780.00');
INSERT INTO `mx_balance` VALUES ('5749', 'sn701', '4760.00');
INSERT INTO `mx_balance` VALUES ('5750', 'sn701', '4740.00');
INSERT INTO `mx_balance` VALUES ('5751', 'sn701', '4730.00');
INSERT INTO `mx_balance` VALUES ('5752', 'sn701', '4720.00');
INSERT INTO `mx_balance` VALUES ('5753', 'sn701', '4700.00');
INSERT INTO `mx_balance` VALUES ('5754', 'sn704', '47930.00');
INSERT INTO `mx_balance` VALUES ('5755', 'sn704', '47920.00');
INSERT INTO `mx_balance` VALUES ('5756', 'sn704', '47910.00');
INSERT INTO `mx_balance` VALUES ('5757', 'sn704', '47900.00');
INSERT INTO `mx_balance` VALUES ('5758', 'sn704', '47890.00');
INSERT INTO `mx_balance` VALUES ('5759', 'sn704', '47840.00');
INSERT INTO `mx_balance` VALUES ('5760', 'sn704', '47830.00');
INSERT INTO `mx_balance` VALUES ('5761', 'sn704', '47810.00');
INSERT INTO `mx_balance` VALUES ('5762', 'sn704', '47790.00');
INSERT INTO `mx_balance` VALUES ('5763', 'sn704', '47780.00');
INSERT INTO `mx_balance` VALUES ('5764', 'sn704', '47760.00');
INSERT INTO `mx_balance` VALUES ('5765', 'sn704', '47740.00');
INSERT INTO `mx_balance` VALUES ('5766', 'sn704', '47730.00');
INSERT INTO `mx_balance` VALUES ('5767', 'sn704', '47720.00');
INSERT INTO `mx_balance` VALUES ('5768', 'sn704', '47700.00');
INSERT INTO `mx_balance` VALUES ('5769', 'sn704', '47680.00');
INSERT INTO `mx_balance` VALUES ('5770', 'sn704', '47660.00');
INSERT INTO `mx_balance` VALUES ('5771', 'sn704', '47650.00');
INSERT INTO `mx_balance` VALUES ('5772', 'sn704', '47620.00');
INSERT INTO `mx_balance` VALUES ('5773', 'sn704', '47580.00');
INSERT INTO `mx_balance` VALUES ('5774', 'sn704', '47530.00');
INSERT INTO `mx_balance` VALUES ('5775', 'sn704', '47510.00');
INSERT INTO `mx_balance` VALUES ('5776', 'sn704', '47500.00');
INSERT INTO `mx_balance` VALUES ('5777', 'sn704', '47490.00');
INSERT INTO `mx_balance` VALUES ('5778', 'sn704', '47470.00');
INSERT INTO `mx_balance` VALUES ('5779', 'sn701', '4660.00');
INSERT INTO `mx_balance` VALUES ('5780', 'sn701', '4630.00');
INSERT INTO `mx_balance` VALUES ('5781', 'sn704', '47450.00');
INSERT INTO `mx_balance` VALUES ('5782', 'sn704', '47440.00');
INSERT INTO `mx_balance` VALUES ('5783', 'sn701', '4620.00');
INSERT INTO `mx_balance` VALUES ('5784', 'sn704', '47430.00');
INSERT INTO `mx_balance` VALUES ('5785', 'sn704', '47410.00');
INSERT INTO `mx_balance` VALUES ('5786', 'sn704', '47380.00');
INSERT INTO `mx_balance` VALUES ('5787', 'sn704', '47340.00');
INSERT INTO `mx_balance` VALUES ('5788', 'sn704', '47320.00');
INSERT INTO `mx_balance` VALUES ('5789', 'sn704', '47260.00');
INSERT INTO `mx_balance` VALUES ('5790', 'sn704', '47160.00');
INSERT INTO `mx_balance` VALUES ('5791', 'sn704', '47140.00');
INSERT INTO `mx_balance` VALUES ('5792', 'sn704', '47020.00');
INSERT INTO `mx_balance` VALUES ('5793', 'sn704', '46940.00');
INSERT INTO `mx_balance` VALUES ('5794', 'sn704', '46910.00');
INSERT INTO `mx_balance` VALUES ('5795', 'sn704', '46710.00');
INSERT INTO `mx_balance` VALUES ('5796', 'sn704', '46590.00');
INSERT INTO `mx_balance` VALUES ('5797', 'sn704', '46570.00');
INSERT INTO `mx_balance` VALUES ('5798', 'sn704', '46520.00');
INSERT INTO `mx_balance` VALUES ('5799', 'sn704', '46470.00');
INSERT INTO `mx_balance` VALUES ('5800', 'sn704', '46260.00');
INSERT INTO `mx_balance` VALUES ('5801', 'sn704', '46240.00');
INSERT INTO `mx_balance` VALUES ('5802', 'sn704', '46230.00');
INSERT INTO `mx_balance` VALUES ('5803', 'sn704', '46140.00');
INSERT INTO `mx_balance` VALUES ('5804', 'sn704', '46130.00');
INSERT INTO `mx_balance` VALUES ('5805', 'sn704', '46220.00');
INSERT INTO `mx_balance` VALUES ('5806', 'sn701', '4560.00');
INSERT INTO `mx_balance` VALUES ('5807', 'sn701', '4530.00');
INSERT INTO `mx_balance` VALUES ('5808', 'sn701', '4490.00');
INSERT INTO `mx_balance` VALUES ('5809', 'sn701', '4470.00');
INSERT INTO `mx_balance` VALUES ('5810', 'sn701', '4460.00');
INSERT INTO `mx_balance` VALUES ('5811', 'sn701', '4450.00');
INSERT INTO `mx_balance` VALUES ('5812', 'sn701', '4440.00');
INSERT INTO `mx_balance` VALUES ('5813', 'sn701', '4430.00');
INSERT INTO `mx_balance` VALUES ('5814', 'sn701', '4420.00');
INSERT INTO `mx_balance` VALUES ('5815', 'sn701', '4400.00');
INSERT INTO `mx_balance` VALUES ('5816', 'sn701', '4390.00');
INSERT INTO `mx_balance` VALUES ('5817', 'sn701', '4380.00');
INSERT INTO `mx_balance` VALUES ('5818', 'sn701', '4370.00');
INSERT INTO `mx_balance` VALUES ('5819', 'sn701', '4360.00');
INSERT INTO `mx_balance` VALUES ('5820', 'sn701', '4350.00');
INSERT INTO `mx_balance` VALUES ('5821', 'sn701', '4340.00');
INSERT INTO `mx_balance` VALUES ('5822', 'sn701', '4330.00');
INSERT INTO `mx_balance` VALUES ('5823', 'sn701', '4320.00');
INSERT INTO `mx_balance` VALUES ('5824', 'sn701', '4310.00');
INSERT INTO `mx_balance` VALUES ('5825', 'sn701', '4300.00');
INSERT INTO `mx_balance` VALUES ('5826', 'sn701', '4280.00');
INSERT INTO `mx_balance` VALUES ('5827', 'sn701', '4260.00');
INSERT INTO `mx_balance` VALUES ('5828', 'sn701', '4250.00');
INSERT INTO `mx_balance` VALUES ('5829', 'sn701', '4230.00');
INSERT INTO `mx_balance` VALUES ('5830', 'sn701', '4210.00');
INSERT INTO `mx_balance` VALUES ('5831', 'sn701', '4200.00');
INSERT INTO `mx_balance` VALUES ('5832', 'sn701', '4180.00');
INSERT INTO `mx_balance` VALUES ('5833', 'sn701', '4170.00');
INSERT INTO `mx_balance` VALUES ('5834', 'sn701', '4150.00');
INSERT INTO `mx_balance` VALUES ('5835', 'sn701', '4130.00');
INSERT INTO `mx_balance` VALUES ('5836', 'sn701', '4100.00');
INSERT INTO `mx_balance` VALUES ('5837', 'sn701', '4090.00');
INSERT INTO `mx_balance` VALUES ('5838', 'sn701', '4070.00');
INSERT INTO `mx_balance` VALUES ('5839', 'sn701', '4050.00');
INSERT INTO `mx_balance` VALUES ('5840', 'sn701', '4030.00');
INSERT INTO `mx_balance` VALUES ('5841', 'sn701', '4010.00');
INSERT INTO `mx_balance` VALUES ('5842', 'sn701', '3990.00');
INSERT INTO `mx_balance` VALUES ('5843', 'sn701', '3980.00');
INSERT INTO `mx_balance` VALUES ('5844', 'sn701', '3970.00');
INSERT INTO `mx_balance` VALUES ('5845', 'sn701', '3960.00');
INSERT INTO `mx_balance` VALUES ('5846', 'sn701', '3940.00');
INSERT INTO `mx_balance` VALUES ('5847', 'sn701', '3920.00');
INSERT INTO `mx_balance` VALUES ('5848', 'sn701', '3900.00');
INSERT INTO `mx_balance` VALUES ('5849', 'sn701', '3890.00');
INSERT INTO `mx_balance` VALUES ('5850', 'sn701', '3880.00');
INSERT INTO `mx_balance` VALUES ('5851', 'sn701', '3870.00');
INSERT INTO `mx_balance` VALUES ('5852', 'sn701', '3860.00');
INSERT INTO `mx_balance` VALUES ('5853', 'sn701', '3840.00');
INSERT INTO `mx_balance` VALUES ('5854', 'sn701', '3830.00');
INSERT INTO `mx_balance` VALUES ('5855', 'sn701', '3820.00');
INSERT INTO `mx_balance` VALUES ('5856', 'sn701', '3800.00');
INSERT INTO `mx_balance` VALUES ('5857', 'sn701', '3790.00');
INSERT INTO `mx_balance` VALUES ('5858', 'sn701', '3690.00');
INSERT INTO `mx_balance` VALUES ('5859', 'sn701', '3600.00');
INSERT INTO `mx_balance` VALUES ('5860', 'sn701', '3500.00');
INSERT INTO `mx_balance` VALUES ('5861', 'sn701', '3400.00');
INSERT INTO `mx_balance` VALUES ('5862', 'sn701', '3380.00');
INSERT INTO `mx_balance` VALUES ('5863', 'sn701', '3360.00');
INSERT INTO `mx_balance` VALUES ('5864', 'sn701', '3350.00');
INSERT INTO `mx_balance` VALUES ('5865', 'sn701', '3320.00');
INSERT INTO `mx_balance` VALUES ('5866', 'sn701', '3310.00');
INSERT INTO `mx_balance` VALUES ('5867', 'sn701', '3280.00');
INSERT INTO `mx_balance` VALUES ('5868', 'sn701', '3250.00');
INSERT INTO `mx_balance` VALUES ('5869', 'sn701', '3230.00');
INSERT INTO `mx_balance` VALUES ('5870', 'sn701', '3210.00');
INSERT INTO `mx_balance` VALUES ('5871', 'sn701', '3190.00');
INSERT INTO `mx_balance` VALUES ('5872', 'sn701', '3180.00');
INSERT INTO `mx_balance` VALUES ('5873', 'sn701', '3150.00');
INSERT INTO `mx_balance` VALUES ('5874', 'sn701', '3140.00');
INSERT INTO `mx_balance` VALUES ('5875', 'sn701', '3130.00');
INSERT INTO `mx_balance` VALUES ('5876', 'sn701', '3120.00');
INSERT INTO `mx_balance` VALUES ('5877', 'sn701', '3100.00');
INSERT INTO `mx_balance` VALUES ('5878', 'sn701', '3080.00');
INSERT INTO `mx_balance` VALUES ('5879', 'sn701', '3070.00');
INSERT INTO `mx_balance` VALUES ('5880', 'sn701', '3050.00');
INSERT INTO `mx_balance` VALUES ('5881', 'sn701', '3040.00');
INSERT INTO `mx_balance` VALUES ('5882', 'sn701', '2990.00');
INSERT INTO `mx_balance` VALUES ('5883', 'sn701', '2960.00');
INSERT INTO `mx_balance` VALUES ('5884', 'sn701', '2950.00');
INSERT INTO `mx_balance` VALUES ('5885', 'sn701', '2940.00');
INSERT INTO `mx_balance` VALUES ('5886', 'sn701', '2930.00');
INSERT INTO `mx_balance` VALUES ('5887', 'sn704', '46130.00');
INSERT INTO `mx_balance` VALUES ('5888', 'sn701', '2820.00');
INSERT INTO `mx_balance` VALUES ('5889', 'sn701', '2810.00');
INSERT INTO `mx_balance` VALUES ('5890', 'sn701', '2790.00');
INSERT INTO `mx_balance` VALUES ('5891', 'sn701', '2780.00');
INSERT INTO `mx_balance` VALUES ('5892', 'sn701', '2750.00');
INSERT INTO `mx_balance` VALUES ('5893', 'sn701', '2680.00');
INSERT INTO `mx_balance` VALUES ('5894', 'sn701', '2770.00');
INSERT INTO `mx_balance` VALUES ('5895', 'sn701', '2710.00');
INSERT INTO `mx_balance` VALUES ('5896', 'sn701', '2700.00');
INSERT INTO `mx_balance` VALUES ('5897', 'sn701', '2690.00');
INSERT INTO `mx_balance` VALUES ('5898', 'sn701', '2640.00');
INSERT INTO `mx_balance` VALUES ('5899', 'sn701', '2630.00');
INSERT INTO `mx_balance` VALUES ('5900', 'sn701', '2590.00');
INSERT INTO `mx_balance` VALUES ('5901', 'sn701', '2570.00');
INSERT INTO `mx_balance` VALUES ('5902', 'sn701', '2560.00');
INSERT INTO `mx_balance` VALUES ('5903', 'sn701', '2540.00');
INSERT INTO `mx_balance` VALUES ('5904', 'sn701', '2520.00');
INSERT INTO `mx_balance` VALUES ('5905', 'sn701', '2510.00');
INSERT INTO `mx_balance` VALUES ('5906', 'sn701', '2500.00');
INSERT INTO `mx_balance` VALUES ('5907', 'sn701', '2480.00');
INSERT INTO `mx_balance` VALUES ('5908', 'sn701', '2470.00');
INSERT INTO `mx_balance` VALUES ('5909', 'sn701', '2460.00');
INSERT INTO `mx_balance` VALUES ('5910', 'sn701', '2430.00');
INSERT INTO `mx_balance` VALUES ('5911', 'sn701', '2420.00');
INSERT INTO `mx_balance` VALUES ('5912', 'sn701', '2410.00');
INSERT INTO `mx_balance` VALUES ('5913', 'sn701', '2360.00');
INSERT INTO `mx_balance` VALUES ('5914', 'sn701', '2310.00');
INSERT INTO `mx_balance` VALUES ('5915', 'sn701', '2290.00');
INSERT INTO `mx_balance` VALUES ('5916', 'sn701', '2280.00');
INSERT INTO `mx_balance` VALUES ('5917', 'sn701', '2270.00');
INSERT INTO `mx_balance` VALUES ('5918', 'sn701', '2260.00');
INSERT INTO `mx_balance` VALUES ('5919', 'sn701', '2240.00');
INSERT INTO `mx_balance` VALUES ('5920', 'sn701', '2180.00');
INSERT INTO `mx_balance` VALUES ('5921', 'sn701', '2170.00');
INSERT INTO `mx_balance` VALUES ('5922', 'sn701', '2160.00');
INSERT INTO `mx_balance` VALUES ('5923', 'sn701', '2140.00');
INSERT INTO `mx_balance` VALUES ('5924', 'sn701', '2130.00');
INSERT INTO `mx_balance` VALUES ('5925', 'sn701', '2050.00');
INSERT INTO `mx_balance` VALUES ('5926', 'sn701', '2030.00');
INSERT INTO `mx_balance` VALUES ('5927', 'sn701', '2010.00');
INSERT INTO `mx_balance` VALUES ('5928', 'sn701', '1990.00');
INSERT INTO `mx_balance` VALUES ('5929', 'sn701', '1940.00');
INSERT INTO `mx_balance` VALUES ('5930', 'sn701', '1910.00');
INSERT INTO `mx_balance` VALUES ('5931', 'sn701', '1890.00');
INSERT INTO `mx_balance` VALUES ('5932', 'sn701', '1870.00');
INSERT INTO `mx_balance` VALUES ('5933', 'sn701', '1840.00');
INSERT INTO `mx_balance` VALUES ('5934', 'sn701', '1780.00');
INSERT INTO `mx_balance` VALUES ('5935', 'sn701', '1720.00');
INSERT INTO `mx_balance` VALUES ('5936', 'sn701', '1710.00');
INSERT INTO `mx_balance` VALUES ('5937', 'sn701', '1690.00');
INSERT INTO `mx_balance` VALUES ('5938', 'sn701', '1670.00');
INSERT INTO `mx_balance` VALUES ('5939', 'sn701', '1650.00');
INSERT INTO `mx_balance` VALUES ('5940', 'sn701', '1620.00');
INSERT INTO `mx_balance` VALUES ('5941', 'sn701', '1610.00');
INSERT INTO `mx_balance` VALUES ('5942', 'sn701', '1590.00');
INSERT INTO `mx_balance` VALUES ('5943', 'sn701', '1560.00');
INSERT INTO `mx_balance` VALUES ('5944', 'sn701', '1530.00');
INSERT INTO `mx_balance` VALUES ('5945', 'sn701', '1290.00');
INSERT INTO `mx_balance` VALUES ('5946', 'sn701', '1690.00');
INSERT INTO `mx_balance` VALUES ('5947', 'sn701', '2090.00');
INSERT INTO `mx_balance` VALUES ('5948', 'sn701', '2490.00');
INSERT INTO `mx_balance` VALUES ('5949', 'sn701', '2890.00');
INSERT INTO `mx_balance` VALUES ('5950', 'sn701', '3290.00');
INSERT INTO `mx_balance` VALUES ('5951', 'sn701', '3690.00');
INSERT INTO `mx_balance` VALUES ('5952', 'sn701', '4090.00');
INSERT INTO `mx_balance` VALUES ('5953', 'sn701', '4490.00');
INSERT INTO `mx_balance` VALUES ('5954', 'sn701', '4890.00');
INSERT INTO `mx_balance` VALUES ('5955', 'sn701', '5290.00');
INSERT INTO `mx_balance` VALUES ('5956', 'sn701', '5690.00');
INSERT INTO `mx_balance` VALUES ('5957', 'sn701', '6090.00');
INSERT INTO `mx_balance` VALUES ('5958', 'sn701', '6490.00');
INSERT INTO `mx_balance` VALUES ('5959', 'sn701', '6890.00');
INSERT INTO `mx_balance` VALUES ('5960', 'sn701', '7290.00');
INSERT INTO `mx_balance` VALUES ('5961', 'sn701', '7690.00');
INSERT INTO `mx_balance` VALUES ('5962', 'sn701', '8090.00');
INSERT INTO `mx_balance` VALUES ('5963', 'sn701', '8490.00');
INSERT INTO `mx_balance` VALUES ('5964', 'sn701', '8890.00');
INSERT INTO `mx_balance` VALUES ('5965', 'sn701', '9290.00');
INSERT INTO `mx_balance` VALUES ('5966', 'sn701', '9690.00');
INSERT INTO `mx_balance` VALUES ('5967', 'sn701', '10090.00');
INSERT INTO `mx_balance` VALUES ('5968', 'sn701', '9880.00');
INSERT INTO `mx_balance` VALUES ('5969', 'sn701', '10060.00');
INSERT INTO `mx_balance` VALUES ('5970', 'sn701', '9560.00');
INSERT INTO `mx_balance` VALUES ('5971', 'sn701', '10010.00');
INSERT INTO `mx_balance` VALUES ('5972', 'sn701', '9010.00');
INSERT INTO `mx_balance` VALUES ('5973', 'sn701', '8710.00');
INSERT INTO `mx_balance` VALUES ('5974', 'sn701', '10510.00');
INSERT INTO `mx_balance` VALUES ('5975', 'sn701', '10490.00');
INSERT INTO `mx_balance` VALUES ('5976', 'sn704', '46100.00');
INSERT INTO `mx_balance` VALUES ('5977', 'sn701', '10290.00');
INSERT INTO `mx_balance` VALUES ('5978', 'sn701', '10470.00');
INSERT INTO `mx_balance` VALUES ('5979', 'sn704', '46090.00');
INSERT INTO `mx_balance` VALUES ('5980', 'sn704', '46070.00');
INSERT INTO `mx_balance` VALUES ('5981', 'sn704', '46060.00');
INSERT INTO `mx_balance` VALUES ('5982', 'sn704', '46010.00');
INSERT INTO `mx_balance` VALUES ('5983', 'sn704', '45970.00');
INSERT INTO `mx_balance` VALUES ('5984', 'sn704', '45930.00');
INSERT INTO `mx_balance` VALUES ('5985', 'sn704', '45910.00');
INSERT INTO `mx_balance` VALUES ('5986', 'sn704', '45880.00');
INSERT INTO `mx_balance` VALUES ('5987', 'sn704', '45870.00');
INSERT INTO `mx_balance` VALUES ('5988', 'sn704', '45860.00');
INSERT INTO `mx_balance` VALUES ('5989', 'sn704', '45840.00');
INSERT INTO `mx_balance` VALUES ('5990', 'sn704', '45820.00');
INSERT INTO `mx_balance` VALUES ('5991', 'sn704', '45800.00');
INSERT INTO `mx_balance` VALUES ('5992', 'sn704', '45790.00');
INSERT INTO `mx_balance` VALUES ('5993', 'sn704', '45770.00');
INSERT INTO `mx_balance` VALUES ('5994', 'sn704', '45750.00');
INSERT INTO `mx_balance` VALUES ('5995', 'sn704', '45740.00');
INSERT INTO `mx_balance` VALUES ('5996', 'sn704', '45730.00');
INSERT INTO `mx_balance` VALUES ('5997', 'sn704', '45720.00');
INSERT INTO `mx_balance` VALUES ('5998', 'sn704', '45710.00');
INSERT INTO `mx_balance` VALUES ('5999', 'sn704', '45700.00');
INSERT INTO `mx_balance` VALUES ('6000', 'sn704', '45680.00');
INSERT INTO `mx_balance` VALUES ('6001', 'sn704', '45650.00');
INSERT INTO `mx_balance` VALUES ('6002', 'sn704', '45640.00');
INSERT INTO `mx_balance` VALUES ('6003', 'sn704', '45630.00');
INSERT INTO `mx_balance` VALUES ('6004', 'sn704', '45620.00');
INSERT INTO `mx_balance` VALUES ('6005', 'sn704', '45610.00');
INSERT INTO `mx_balance` VALUES ('6006', 'sn704', '45600.00');
INSERT INTO `mx_balance` VALUES ('6007', 'sn704', '45590.00');
INSERT INTO `mx_balance` VALUES ('6008', 'sn704', '45580.00');
INSERT INTO `mx_balance` VALUES ('6009', 'sn704', '45570.00');
INSERT INTO `mx_balance` VALUES ('6010', 'sn704', '45560.00');
INSERT INTO `mx_balance` VALUES ('6011', 'sn704', '45550.00');
INSERT INTO `mx_balance` VALUES ('6012', 'sn704', '45530.00');
INSERT INTO `mx_balance` VALUES ('6013', 'sn704', '45480.00');
INSERT INTO `mx_balance` VALUES ('6014', 'sn704', '45450.00');
INSERT INTO `mx_balance` VALUES ('6015', 'sn704', '45420.00');
INSERT INTO `mx_balance` VALUES ('6016', 'sn704', '45400.00');
INSERT INTO `mx_balance` VALUES ('6017', 'sn704', '45380.00');
INSERT INTO `mx_balance` VALUES ('6018', 'sn704', '45330.00');
INSERT INTO `mx_balance` VALUES ('6019', 'sn704', '45280.00');
INSERT INTO `mx_balance` VALUES ('6020', 'sn704', '45270.00');
INSERT INTO `mx_balance` VALUES ('6021', 'sn704', '45210.00');
INSERT INTO `mx_balance` VALUES ('6022', 'sn704', '45150.00');
INSERT INTO `mx_balance` VALUES ('6023', 'sn704', '45140.00');
INSERT INTO `mx_balance` VALUES ('6024', 'sn704', '45130.00');
INSERT INTO `mx_balance` VALUES ('6025', 'sn704', '45120.00');
INSERT INTO `mx_balance` VALUES ('6026', 'sn704', '45100.00');
INSERT INTO `mx_balance` VALUES ('6027', 'sn704', '45090.00');
INSERT INTO `mx_balance` VALUES ('6028', 'sn704', '45070.00');
INSERT INTO `mx_balance` VALUES ('6029', 'sn704', '45060.00');
INSERT INTO `mx_balance` VALUES ('6030', 'sn704', '45040.00');
INSERT INTO `mx_balance` VALUES ('6031', 'sn704', '45000.00');
INSERT INTO `mx_balance` VALUES ('6032', 'sn704', '44980.00');
INSERT INTO `mx_balance` VALUES ('6033', 'sn704', '44970.00');
INSERT INTO `mx_balance` VALUES ('6034', 'sn704', '44960.00');
INSERT INTO `mx_balance` VALUES ('6035', 'sn704', '44950.00');
INSERT INTO `mx_balance` VALUES ('6036', 'sn704', '44920.00');
INSERT INTO `mx_balance` VALUES ('6037', 'sn704', '44890.00');
INSERT INTO `mx_balance` VALUES ('6038', 'sn704', '44880.00');
INSERT INTO `mx_balance` VALUES ('6039', 'sn704', '44860.00');
INSERT INTO `mx_balance` VALUES ('6040', 'sn704', '44840.00');
INSERT INTO `mx_balance` VALUES ('6041', 'sn704', '44820.00');
INSERT INTO `mx_balance` VALUES ('6042', 'sn704', '44800.00');
INSERT INTO `mx_balance` VALUES ('6043', 'sn704', '44790.00');
INSERT INTO `mx_balance` VALUES ('6044', 'sn704', '44780.00');
INSERT INTO `mx_balance` VALUES ('6045', 'sn704', '44760.00');
INSERT INTO `mx_balance` VALUES ('6046', 'sn704', '44750.00');
INSERT INTO `mx_balance` VALUES ('6047', 'sn704', '44740.00');
INSERT INTO `mx_balance` VALUES ('6048', 'sn704', '44730.00');
INSERT INTO `mx_balance` VALUES ('6049', 'sn704', '44710.00');
INSERT INTO `mx_balance` VALUES ('6050', 'sn704', '44690.00');
INSERT INTO `mx_balance` VALUES ('6051', 'sn704', '44670.00');
INSERT INTO `mx_balance` VALUES ('6052', 'sn704', '44650.00');
INSERT INTO `mx_balance` VALUES ('6053', 'sn704', '44630.00');
INSERT INTO `mx_balance` VALUES ('6054', 'sn704', '44600.00');
INSERT INTO `mx_balance` VALUES ('6055', 'sn704', '44590.00');
INSERT INTO `mx_balance` VALUES ('6056', 'sn704', '44550.00');
INSERT INTO `mx_balance` VALUES ('6057', 'sn704', '44540.00');
INSERT INTO `mx_balance` VALUES ('6058', 'sn704', '44530.00');
INSERT INTO `mx_balance` VALUES ('6059', 'sn704', '44520.00');
INSERT INTO `mx_balance` VALUES ('6060', 'sn704', '44500.00');
INSERT INTO `mx_balance` VALUES ('6061', 'sn704', '44490.00');
INSERT INTO `mx_balance` VALUES ('6062', 'sn704', '44470.00');
INSERT INTO `mx_balance` VALUES ('6063', 'sn704', '44450.00');
INSERT INTO `mx_balance` VALUES ('6064', 'sn704', '44430.00');
INSERT INTO `mx_balance` VALUES ('6065', 'sn704', '44420.00');
INSERT INTO `mx_balance` VALUES ('6066', 'sn704', '44410.00');
INSERT INTO `mx_balance` VALUES ('6067', 'sn704', '44400.00');
INSERT INTO `mx_balance` VALUES ('6068', 'sn704', '44390.00');
INSERT INTO `mx_balance` VALUES ('6069', 'sn704', '44380.00');
INSERT INTO `mx_balance` VALUES ('6070', 'sn704', '44360.00');
INSERT INTO `mx_balance` VALUES ('6071', 'sn704', '44340.00');
INSERT INTO `mx_balance` VALUES ('6072', 'sn704', '44330.00');
INSERT INTO `mx_balance` VALUES ('6073', 'sn704', '44320.00');
INSERT INTO `mx_balance` VALUES ('6074', 'sn704', '44280.00');
INSERT INTO `mx_balance` VALUES ('6075', 'sn704', '44270.00');
INSERT INTO `mx_balance` VALUES ('6076', 'sn704', '44240.00');
INSERT INTO `mx_balance` VALUES ('6077', 'sn704', '44210.00');
INSERT INTO `mx_balance` VALUES ('6078', 'sn704', '44200.00');
INSERT INTO `mx_balance` VALUES ('6079', 'sn704', '44190.00');
INSERT INTO `mx_balance` VALUES ('6080', 'sn704', '44170.00');
INSERT INTO `mx_balance` VALUES ('6081', 'sn704', '44120.00');
INSERT INTO `mx_balance` VALUES ('6082', 'sn704', '44100.00');
INSERT INTO `mx_balance` VALUES ('6083', 'sn704', '44090.00');
INSERT INTO `mx_balance` VALUES ('6084', 'sn704', '44080.00');
INSERT INTO `mx_balance` VALUES ('6085', 'sn704', '44070.00');
INSERT INTO `mx_balance` VALUES ('6086', 'sn704', '44020.00');
INSERT INTO `mx_balance` VALUES ('6087', 'sn704', '43970.00');
INSERT INTO `mx_balance` VALUES ('6088', 'sn704', '43920.00');
INSERT INTO `mx_balance` VALUES ('6089', 'sn704', '43910.00');
INSERT INTO `mx_balance` VALUES ('6090', 'sn704', '43890.00');
INSERT INTO `mx_balance` VALUES ('6091', 'sn704', '43880.00');
INSERT INTO `mx_balance` VALUES ('6092', 'sn704', '43870.00');
INSERT INTO `mx_balance` VALUES ('6093', 'sn704', '43860.00');
INSERT INTO `mx_balance` VALUES ('6094', 'sn704', '43840.00');
INSERT INTO `mx_balance` VALUES ('6095', 'sn704', '43820.00');
INSERT INTO `mx_balance` VALUES ('6096', 'sn704', '43810.00');
INSERT INTO `mx_balance` VALUES ('6097', 'sn704', '43790.00');
INSERT INTO `mx_balance` VALUES ('6098', 'sn704', '43780.00');
INSERT INTO `mx_balance` VALUES ('6099', 'sn704', '43760.00');
INSERT INTO `mx_balance` VALUES ('6100', 'sn704', '43740.00');
INSERT INTO `mx_balance` VALUES ('6101', 'sn704', '43720.00');
INSERT INTO `mx_balance` VALUES ('6102', 'sn704', '43700.00');
INSERT INTO `mx_balance` VALUES ('6103', 'sn704', '43680.00');
INSERT INTO `mx_balance` VALUES ('6104', 'sn704', '43670.00');
INSERT INTO `mx_balance` VALUES ('6105', 'sn704', '43660.00');
INSERT INTO `mx_balance` VALUES ('6106', 'sn704', '43640.00');
INSERT INTO `mx_balance` VALUES ('6107', 'sn704', '43630.00');
INSERT INTO `mx_balance` VALUES ('6108', 'sn704', '43620.00');
INSERT INTO `mx_balance` VALUES ('6109', 'sn704', '43570.00');
INSERT INTO `mx_balance` VALUES ('6110', 'sn704', '43560.00');
INSERT INTO `mx_balance` VALUES ('6111', 'sn704', '43550.00');
INSERT INTO `mx_balance` VALUES ('6112', 'sn704', '43540.00');
INSERT INTO `mx_balance` VALUES ('6113', 'sn704', '43530.00');
INSERT INTO `mx_balance` VALUES ('6114', 'sn704', '43520.00');
INSERT INTO `mx_balance` VALUES ('6115', 'sn704', '43480.00');
INSERT INTO `mx_balance` VALUES ('6116', 'sn704', '43440.00');
INSERT INTO `mx_balance` VALUES ('6117', 'sn704', '43390.00');
INSERT INTO `mx_balance` VALUES ('6118', 'sn704', '43370.00');
INSERT INTO `mx_balance` VALUES ('6119', 'sn704', '43360.00');
INSERT INTO `mx_balance` VALUES ('6120', 'sn704', '43330.00');
INSERT INTO `mx_balance` VALUES ('6121', 'sn704', '43320.00');
INSERT INTO `mx_balance` VALUES ('6122', 'sn704', '43300.00');
INSERT INTO `mx_balance` VALUES ('6123', 'sn704', '43270.00');
INSERT INTO `mx_balance` VALUES ('6124', 'sn704', '43250.00');
INSERT INTO `mx_balance` VALUES ('6125', 'sn704', '43240.00');
INSERT INTO `mx_balance` VALUES ('6126', 'sn704', '43190.00');
INSERT INTO `mx_balance` VALUES ('6127', 'sn704', '43180.00');
INSERT INTO `mx_balance` VALUES ('6128', 'sn704', '43170.00');
INSERT INTO `mx_balance` VALUES ('6129', 'sn704', '43150.00');
INSERT INTO `mx_balance` VALUES ('6130', 'sn704', '43140.00');
INSERT INTO `mx_balance` VALUES ('6131', 'sn704', '43120.00');
INSERT INTO `mx_balance` VALUES ('6132', 'sn704', '43080.00');
INSERT INTO `mx_balance` VALUES ('6133', 'sn704', '43060.00');
INSERT INTO `mx_balance` VALUES ('6134', '', '10370.00');
INSERT INTO `mx_balance` VALUES ('6135', '', '10370.00');
INSERT INTO `mx_balance` VALUES ('6136', 'sn701', '10370.00');
INSERT INTO `mx_balance` VALUES ('6137', 'sn701', '10270.00');
INSERT INTO `mx_balance` VALUES ('6138', 'sn701', '10170.00');
INSERT INTO `mx_balance` VALUES ('6139', 'sn701', '10070.00');
INSERT INTO `mx_balance` VALUES ('6140', 'sn701', '9970.00');
INSERT INTO `mx_balance` VALUES ('6141', '', '9870.00');
INSERT INTO `mx_balance` VALUES ('6142', '', '9470.00');
INSERT INTO `mx_balance` VALUES ('6143', '', '8220.00');
INSERT INTO `mx_balance` VALUES ('6144', '', '9220.00');
INSERT INTO `mx_balance` VALUES ('6145', '', '6970.00');
INSERT INTO `mx_balance` VALUES ('6146', '', '9870.00');
INSERT INTO `mx_balance` VALUES ('6147', '', '9870.00');
INSERT INTO `mx_balance` VALUES ('6148', '', '9870.00');
INSERT INTO `mx_balance` VALUES ('6149', '', '9112.00');
INSERT INTO `mx_balance` VALUES ('6150', '', '4460.00');
INSERT INTO `mx_balance` VALUES ('6151', '', '1610.00');
INSERT INTO `mx_balance` VALUES ('6152', 'sn701', '9990.00');
INSERT INTO `mx_balance` VALUES ('6153', 'sn701', '10090.00');
INSERT INTO `mx_balance` VALUES ('6154', 'sn701', '9990.00');
INSERT INTO `mx_balance` VALUES ('6155', 'sn701', '8320.00');
INSERT INTO `mx_balance` VALUES ('6156', 'sn701', '6650.00');
INSERT INTO `mx_balance` VALUES ('6157', 'sn701', '4980.00');
INSERT INTO `mx_balance` VALUES ('6158', 'sn701', '3310.00');
INSERT INTO `mx_balance` VALUES ('6159', 'sn701', '1640.00');
INSERT INTO `mx_balance` VALUES ('6160', '', '1390.00');
INSERT INTO `mx_balance` VALUES ('6161', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6162', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6163', 'sn701', '1740.00');
INSERT INTO `mx_balance` VALUES ('6164', '', '1590.00');
INSERT INTO `mx_balance` VALUES ('6165', 'sn701', '1640.00');
INSERT INTO `mx_balance` VALUES ('6166', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6167', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6168', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6169', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6170', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6171', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6172', '', '1540.00');
INSERT INTO `mx_balance` VALUES ('6173', 'sn701', '1540.00');
INSERT INTO `mx_balance` VALUES ('6174', 'sn701', '1440.00');
INSERT INTO `mx_balance` VALUES ('6175', 'sn701', '1340.00');
INSERT INTO `mx_balance` VALUES ('6176', 'sn701', '1440.00');
INSERT INTO `mx_balance` VALUES ('6177', 'sn701', '1340.00');
INSERT INTO `mx_balance` VALUES ('6178', 'sn701', '1440.00');
INSERT INTO `mx_balance` VALUES ('6179', 'sn701', '1340.00');
INSERT INTO `mx_balance` VALUES ('6180', 'sn701', '1440.00');
INSERT INTO `mx_balance` VALUES ('6181', 'sn701', '1540.00');
INSERT INTO `mx_balance` VALUES ('6182', 'sn701', '1640.00');
INSERT INTO `mx_balance` VALUES ('6183', 'sn701', '1740.00');
INSERT INTO `mx_balance` VALUES ('6184', 'sn701', '1840.00');
INSERT INTO `mx_balance` VALUES ('6185', 'sn701', '1940.00');
INSERT INTO `mx_balance` VALUES ('6186', 'sn701', '2040.00');
INSERT INTO `mx_balance` VALUES ('6187', 'sn701', '2140.00');
INSERT INTO `mx_balance` VALUES ('6188', 'sn701', '1770.00');
INSERT INTO `mx_balance` VALUES ('6189', 'sn701', '1400.00');
INSERT INTO `mx_balance` VALUES ('6190', 'sn701', '1030.00');
INSERT INTO `mx_balance` VALUES ('6191', 'sn701', '660.00');
INSERT INTO `mx_balance` VALUES ('6192', 'sn701', '290.00');
INSERT INTO `mx_balance` VALUES ('6193', 'sn701', '80.00');
INSERT INTO `mx_balance` VALUES ('6194', 'sn701', '100.00');
INSERT INTO `mx_balance` VALUES ('6195', 'sn701', '20000.00');
INSERT INTO `mx_balance` VALUES ('6196', 'sn701', '19872.00');
INSERT INTO `mx_balance` VALUES ('6197', 'sn701', '19744.00');
INSERT INTO `mx_balance` VALUES ('6198', 'sn701', '19616.00');
INSERT INTO `mx_balance` VALUES ('6199', 'sn701', '19488.00');
INSERT INTO `mx_balance` VALUES ('6200', 'sn701', '19360.00');
INSERT INTO `mx_balance` VALUES ('6201', 'sn701', '19335.00');
INSERT INTO `mx_balance` VALUES ('6202', 'sn701', '19294.00');
INSERT INTO `mx_balance` VALUES ('6203', 'sn701', '19253.00');
INSERT INTO `mx_balance` VALUES ('6204', 'sn701', '19263.00');
INSERT INTO `mx_balance` VALUES ('6205', 'sn701', '19135.00');
INSERT INTO `mx_balance` VALUES ('6206', 'sn701', '19007.00');
INSERT INTO `mx_balance` VALUES ('6207', 'sn701', '18879.00');
INSERT INTO `mx_balance` VALUES ('6208', 'sn701', '18751.00');
INSERT INTO `mx_balance` VALUES ('6209', 'sn701', '18623.00');
INSERT INTO `mx_balance` VALUES ('6210', 'sn701', '18495.00');
INSERT INTO `mx_balance` VALUES ('6211', 'sn701', '18367.00');
INSERT INTO `mx_balance` VALUES ('6212', 'sn701', '18239.00');
INSERT INTO `mx_balance` VALUES ('6213', 'sn701', '17689.00');
INSERT INTO `mx_balance` VALUES ('6214', 'sn701', '17439.00');
INSERT INTO `mx_balance` VALUES ('6215', 'sn701', '17539.00');
INSERT INTO `mx_balance` VALUES ('6216', 'sn701', '17639.00');
INSERT INTO `mx_balance` VALUES ('6217', 'sn701', '7639.00');
INSERT INTO `mx_balance` VALUES ('6218', 'sn701', '7489.00');
INSERT INTO `mx_balance` VALUES ('6219', 'sn701', '7339.00');
INSERT INTO `mx_balance` VALUES ('6220', 'sn701', '7439.00');
INSERT INTO `mx_balance` VALUES ('6221', '', '1490.00');
INSERT INTO `mx_balance` VALUES ('6222', '', '1240.00');
INSERT INTO `mx_balance` VALUES ('6223', '', '1215.00');
INSERT INTO `mx_balance` VALUES ('6224', '', '1190.00');
INSERT INTO `mx_balance` VALUES ('6225', '', '1165.00');
INSERT INTO `mx_balance` VALUES ('6226', '', '1140.00');
INSERT INTO `mx_balance` VALUES ('6227', '', '1115.00');
INSERT INTO `mx_balance` VALUES ('6228', '', '1105.00');
INSERT INTO `mx_balance` VALUES ('6229', '', '1095.00');
INSERT INTO `mx_balance` VALUES ('6230', '', '1085.00');
INSERT INTO `mx_balance` VALUES ('6231', '', '1075.00');
INSERT INTO `mx_balance` VALUES ('6232', '', '1065.00');
INSERT INTO `mx_balance` VALUES ('6233', 'sn701', '7414.00');
INSERT INTO `mx_balance` VALUES ('6234', 'sn701', '7389.00');
INSERT INTO `mx_balance` VALUES ('6235', 'sn701', '7364.00');
INSERT INTO `mx_balance` VALUES ('6236', 'sn701', '7339.00');
INSERT INTO `mx_balance` VALUES ('6237', 'sn701', '7314.00');
INSERT INTO `mx_balance` VALUES ('6238', 'sn701', '7313.00');
INSERT INTO `mx_balance` VALUES ('6239', 'sn701', '7312.00');
INSERT INTO `mx_balance` VALUES ('6240', 'sn701', '7311.00');
INSERT INTO `mx_balance` VALUES ('6241', 'sn701', '7310.00');
INSERT INTO `mx_balance` VALUES ('6242', 'sn701', '7295.00');
INSERT INTO `mx_balance` VALUES ('6243', 'sn701', '7270.00');
INSERT INTO `mx_balance` VALUES ('6244', 'sn701', '7245.00');
INSERT INTO `mx_balance` VALUES ('6245', 'sn701', '6995.00');
INSERT INTO `mx_balance` VALUES ('6246', 'sn701', '6745.00');
INSERT INTO `mx_balance` VALUES ('6247', 'sn701', '6595.00');
INSERT INTO `mx_balance` VALUES ('6248', 'sn701', '6445.00');
INSERT INTO `mx_balance` VALUES ('6249', 'sn701', '5895.00');
INSERT INTO `mx_balance` VALUES ('6250', 'sn701', '5345.00');
INSERT INTO `mx_balance` VALUES ('6251', 'sn701', '4795.00');
INSERT INTO `mx_balance` VALUES ('6252', 'sn701', '4645.00');
INSERT INTO `mx_balance` VALUES ('6253', 'sn701', '4095.00');
INSERT INTO `mx_balance` VALUES ('6254', 'sn701', '4085.00');
INSERT INTO `mx_balance` VALUES ('6255', 'sn701', '4055.00');
INSERT INTO `mx_balance` VALUES ('6256', 'sn701', '3505.00');
INSERT INTO `mx_balance` VALUES ('6257', 'sn701', '3605.00');
INSERT INTO `mx_balance` VALUES ('6258', 'sn701', '3705.00');
INSERT INTO `mx_balance` VALUES ('6259', 'sn701', '3805.00');
INSERT INTO `mx_balance` VALUES ('6260', 'sn701', '3905.00');
INSERT INTO `mx_balance` VALUES ('6261', 'sn701', '4005.00');
INSERT INTO `mx_balance` VALUES ('6262', 'sn701', '4105.00');
INSERT INTO `mx_balance` VALUES ('6263', 'sn701', '4005.00');
INSERT INTO `mx_balance` VALUES ('6264', 'sn701', '3905.00');
INSERT INTO `mx_balance` VALUES ('6265', 'sn701', '3805.00');
INSERT INTO `mx_balance` VALUES ('6266', 'sn701', '3905.00');
INSERT INTO `mx_balance` VALUES ('6267', 'sn701', '4005.00');
INSERT INTO `mx_balance` VALUES ('6268', 'sn701', '4105.00');
INSERT INTO `mx_balance` VALUES ('6269', 'sn701', '3555.00');
INSERT INTO `mx_balance` VALUES ('6270', 'sn701', '3405.00');
INSERT INTO `mx_balance` VALUES ('6271', 'sn701', '3255.00');
INSERT INTO `mx_balance` VALUES ('6272', 'sn701', '3105.00');
INSERT INTO `mx_balance` VALUES ('6273', 'sn701', '2955.00');
INSERT INTO `mx_balance` VALUES ('6274', 'sn701', '2805.00');
INSERT INTO `mx_balance` VALUES ('6275', 'sn701', '2795.00');
INSERT INTO `mx_balance` VALUES ('6276', 'sn701', '2785.00');
INSERT INTO `mx_balance` VALUES ('6277', 'sn701', '2635.00');
INSERT INTO `mx_balance` VALUES ('6278', 'sn701', '2485.00');
INSERT INTO `mx_balance` VALUES ('6279', 'sn701', '2335.00');
INSERT INTO `mx_balance` VALUES ('6280', 'sn701', '2185.00');
INSERT INTO `mx_balance` VALUES ('6281', 'sn701', '2035.00');
INSERT INTO `mx_balance` VALUES ('6282', 'sn701', '1585.00');
INSERT INTO `mx_balance` VALUES ('6283', 'sn701', '1135.00');
INSERT INTO `mx_balance` VALUES ('6284', 'sn701', '1235.00');
INSERT INTO `mx_balance` VALUES ('6285', 'sn701', '1335.00');
INSERT INTO `mx_balance` VALUES ('6286', 'sn701', '785.00');
INSERT INTO `mx_balance` VALUES ('6287', 'sn701', '685.00');
INSERT INTO `mx_balance` VALUES ('6288', 'sn701', '585.00');
INSERT INTO `mx_balance` VALUES ('6289', 'sn701', '485.00');
INSERT INTO `mx_balance` VALUES ('6290', 'sn701', '38500.00');
INSERT INTO `mx_balance` VALUES ('6291', 'sn701', '38400.00');
INSERT INTO `mx_balance` VALUES ('6292', 'sn701', '38300.00');
INSERT INTO `mx_balance` VALUES ('6293', 'sn701', '38200.00');
INSERT INTO `mx_balance` VALUES ('6294', 'sn701', '38100.00');
INSERT INTO `mx_balance` VALUES ('6295', 'sn701', '38200.00');
INSERT INTO `mx_balance` VALUES ('6296', 'sn701', '38300.00');
INSERT INTO `mx_balance` VALUES ('6297', 'sn701', '38400.00');
INSERT INTO `mx_balance` VALUES ('6298', 'sn701', '38500.00');
INSERT INTO `mx_balance` VALUES ('6299', 'sn701', '38600.00');
INSERT INTO `mx_balance` VALUES ('6300', 'sn701', '38700.00');
INSERT INTO `mx_balance` VALUES ('6301', 'sn701', '38800.00');
INSERT INTO `mx_balance` VALUES ('6302', 'sn701', '38790.00');
INSERT INTO `mx_balance` VALUES ('6303', 'sn701', '38780.00');
INSERT INTO `mx_balance` VALUES ('6304', 'sn701', '38770.00');
INSERT INTO `mx_balance` VALUES ('6305', 'sn701', '38760.00');
INSERT INTO `mx_balance` VALUES ('6306', 'sn701', '38750.00');
INSERT INTO `mx_balance` VALUES ('6307', 'sn701', '38740.00');
INSERT INTO `mx_balance` VALUES ('6308', 'sn701', '38730.00');
INSERT INTO `mx_balance` VALUES ('6309', 'sn701', '38720.00');
INSERT INTO `mx_balance` VALUES ('6310', 'sn701', '38715.00');
INSERT INTO `mx_balance` VALUES ('6311', 'sn701', '38710.00');
INSERT INTO `mx_balance` VALUES ('6312', 'sn701', '38705.00');
INSERT INTO `mx_balance` VALUES ('6313', 'sn701', '38700.00');
INSERT INTO `mx_balance` VALUES ('6314', 'sn701', '38695.00');
INSERT INTO `mx_balance` VALUES ('6315', 'sn701', '38690.00');
INSERT INTO `mx_balance` VALUES ('6316', 'sn701', '38685.00');
INSERT INTO `mx_balance` VALUES ('6317', 'sn701', '38680.00');
INSERT INTO `mx_balance` VALUES ('6318', 'sn701', '38675.00');
INSERT INTO `mx_balance` VALUES ('6319', 'sn701', '38670.00');
INSERT INTO `mx_balance` VALUES ('6320', 'sn701', '38665.00');
INSERT INTO `mx_balance` VALUES ('6321', 'sn701', '38660.00');
INSERT INTO `mx_balance` VALUES ('6322', 'sn701', '38655.00');
INSERT INTO `mx_balance` VALUES ('6323', 'sn701', '38650.00');
INSERT INTO `mx_balance` VALUES ('6324', 'sn701', '38646.00');
INSERT INTO `mx_balance` VALUES ('6325', 'sn701', '38641.00');
INSERT INTO `mx_balance` VALUES ('6326', 'sn701', '38636.00');
INSERT INTO `mx_balance` VALUES ('6327', 'sn701', '38631.00');
INSERT INTO `mx_balance` VALUES ('6328', 'sn701', '38626.00');
INSERT INTO `mx_balance` VALUES ('6329', 'sn701', '38621.00');
INSERT INTO `mx_balance` VALUES ('6330', 'sn701', '38616.00');
INSERT INTO `mx_balance` VALUES ('6331', 'sn701', '38611.00');
INSERT INTO `mx_balance` VALUES ('6332', 'sn701', '38606.00');
INSERT INTO `mx_balance` VALUES ('6333', 'sn701', '38601.00');
INSERT INTO `mx_balance` VALUES ('6334', 'sn701', '38596.00');
INSERT INTO `mx_balance` VALUES ('6335', 'sn701', '38591.00');
INSERT INTO `mx_balance` VALUES ('6336', 'sn701', '38586.00');
INSERT INTO `mx_balance` VALUES ('6337', 'sn701', '38581.00');
INSERT INTO `mx_balance` VALUES ('6338', 'sn701', '38576.00');
INSERT INTO `mx_balance` VALUES ('6339', 'sn701', '38476.00');
INSERT INTO `mx_balance` VALUES ('6340', 'sn701', '38376.00');
INSERT INTO `mx_balance` VALUES ('6341', 'sn701', '37826.00');
INSERT INTO `mx_balance` VALUES ('6342', 'sn701', '37676.00');
INSERT INTO `mx_balance` VALUES ('6343', 'sn701', '37526.00');
INSERT INTO `mx_balance` VALUES ('6344', 'sn701', '37521.00');
INSERT INTO `mx_balance` VALUES ('6345', 'sn701', '37516.00');
INSERT INTO `mx_balance` VALUES ('6346', 'sn701', '37511.00');
INSERT INTO `mx_balance` VALUES ('6347', 'sn701', '37506.00');
INSERT INTO `mx_balance` VALUES ('6348', 'sn701', '37406.00');
INSERT INTO `mx_balance` VALUES ('6349', 'sn701', '37356.00');
INSERT INTO `mx_balance` VALUES ('6350', 'sn701', '37351.00');
INSERT INTO `mx_balance` VALUES ('6351', 'sn701', '37301.00');
INSERT INTO `mx_balance` VALUES ('6352', '', '1065.00');
INSERT INTO `mx_balance` VALUES ('6353', 'sn701', '37296.00');
INSERT INTO `mx_balance` VALUES ('6354', 'sn701', '37291.00');
INSERT INTO `mx_balance` VALUES ('6355', 'sn701', '37241.00');
INSERT INTO `mx_balance` VALUES ('6356', 'sn701', '37236.00');
INSERT INTO `mx_balance` VALUES ('6357', 'sn701', '37231.00');
INSERT INTO `mx_balance` VALUES ('6358', 'sn701', '37225.00');
INSERT INTO `mx_balance` VALUES ('6359', 'sn701', '37175.00');
INSERT INTO `mx_balance` VALUES ('6360', 'sn701', '37075.00');
INSERT INTO `mx_balance` VALUES ('6361', 'sn701', '37070.00');
INSERT INTO `mx_balance` VALUES ('6362', 'sn701', '37060.00');
INSERT INTO `mx_balance` VALUES ('6363', 'sn701', '36960.00');
INSERT INTO `mx_balance` VALUES ('6364', 'sn701', '36950.00');
INSERT INTO `mx_balance` VALUES ('6365', 'sn701', '36940.00');
INSERT INTO `mx_balance` VALUES ('6366', 'sn701', '36934.00');
INSERT INTO `mx_balance` VALUES ('6367', 'sn701', '36929.00');
INSERT INTO `mx_balance` VALUES ('6368', 'sn701', '36829.00');
INSERT INTO `mx_balance` VALUES ('6369', 'sn701', '36824.00');
INSERT INTO `mx_balance` VALUES ('6370', 'sn701', '36817.00');
INSERT INTO `mx_balance` VALUES ('6371', 'sn701', '36807.00');
INSERT INTO `mx_balance` VALUES ('6372', 'sn701', '36907.00');
INSERT INTO `mx_balance` VALUES ('6373', 'sn701', '37007.00');
INSERT INTO `mx_balance` VALUES ('6374', 'sn701', '36907.00');
INSERT INTO `mx_balance` VALUES ('6375', 'sn701', '36917.00');
INSERT INTO `mx_balance` VALUES ('6376', 'sn701', '36927.00');
INSERT INTO `mx_balance` VALUES ('6377', 'sn701', '37027.00');
INSERT INTO `mx_balance` VALUES ('6378', 'sn701', '37037.00');
INSERT INTO `mx_balance` VALUES ('6379', 'sn701', '37047.00');
INSERT INTO `mx_balance` VALUES ('6380', 'sn701', '37057.00');
INSERT INTO `mx_balance` VALUES ('6381', 'sn701', '36957.00');
INSERT INTO `mx_balance` VALUES ('6382', 'sn701', '36857.00');
INSERT INTO `mx_balance` VALUES ('6383', 'sn701', '36757.00');
INSERT INTO `mx_balance` VALUES ('6384', 'sn701', '36657.00');
INSERT INTO `mx_balance` VALUES ('6385', 'sn701', '36557.00');
INSERT INTO `mx_balance` VALUES ('6386', 'sn701', '36457.00');
INSERT INTO `mx_balance` VALUES ('6387', 'sn701', '36357.00');
INSERT INTO `mx_balance` VALUES ('6388', 'sn701', '36257.00');
INSERT INTO `mx_balance` VALUES ('6389', 'sn701', '36157.00');
INSERT INTO `mx_balance` VALUES ('6390', 'sn701', '36057.00');
INSERT INTO `mx_balance` VALUES ('6391', 'sn701', '35957.00');
INSERT INTO `mx_balance` VALUES ('6392', 'sn701', '35857.00');
INSERT INTO `mx_balance` VALUES ('6393', 'sn701', '35757.00');
INSERT INTO `mx_balance` VALUES ('6394', 'sn701', '35657.00');
INSERT INTO `mx_balance` VALUES ('6395', 'sn701', '35557.00');
INSERT INTO `mx_balance` VALUES ('6396', 'sn701', '35457.00');
INSERT INTO `mx_balance` VALUES ('6397', 'sn701', '35357.00');
INSERT INTO `mx_balance` VALUES ('6398', 'sn701', '35257.00');
INSERT INTO `mx_balance` VALUES ('6399', 'sn701', '35157.00');
INSERT INTO `mx_balance` VALUES ('6400', 'sn701', '35057.00');
INSERT INTO `mx_balance` VALUES ('6401', 'sn701', '34957.00');
INSERT INTO `mx_balance` VALUES ('6402', 'sn701', '34857.00');
INSERT INTO `mx_balance` VALUES ('6403', 'sn701', '34757.00');
INSERT INTO `mx_balance` VALUES ('6404', 'sn701', '34657.00');
INSERT INTO `mx_balance` VALUES ('6405', 'sn701', '34557.00');
INSERT INTO `mx_balance` VALUES ('6406', 'sn701', '34507.00');
INSERT INTO `mx_balance` VALUES ('6407', 'sn701', '34457.00');
INSERT INTO `mx_balance` VALUES ('6408', 'sn701', '34407.00');
INSERT INTO `mx_balance` VALUES ('6409', 'sn701', '34357.00');
INSERT INTO `mx_balance` VALUES ('6410', 'sn701', '34307.00');
INSERT INTO `mx_balance` VALUES ('6411', 'sn701', '34407.00');
INSERT INTO `mx_balance` VALUES ('6412', 'sn701', '34507.00');
INSERT INTO `mx_balance` VALUES ('6413', 'sn701', '34607.00');
INSERT INTO `mx_balance` VALUES ('6414', 'sn701', '34707.00');
INSERT INTO `mx_balance` VALUES ('6415', 'sn701', '34807.00');
INSERT INTO `mx_balance` VALUES ('6416', 'sn701', '34907.00');
INSERT INTO `mx_balance` VALUES ('6417', 'sn701', '34857.00');
INSERT INTO `mx_balance` VALUES ('6418', 'sn701', '34757.00');
INSERT INTO `mx_balance` VALUES ('6419', 'sn701', '34657.00');
INSERT INTO `mx_balance` VALUES ('6420', 'sn701', '34757.00');
INSERT INTO `mx_balance` VALUES ('6421', 'sn701', '34707.00');
INSERT INTO `mx_balance` VALUES ('6422', 'sn701', '34757.00');
INSERT INTO `mx_balance` VALUES ('6423', 'sn701', '34657.00');
INSERT INTO `mx_balance` VALUES ('6424', 'sn701', '34757.00');
INSERT INTO `mx_balance` VALUES ('6425', 'sn701', '34751.00');
INSERT INTO `mx_balance` VALUES ('6426', 'sn701', '34757.00');
INSERT INTO `mx_balance` VALUES ('6427', 'sn701', '34747.00');
INSERT INTO `mx_balance` VALUES ('6428', 'sn701', '34737.00');
INSERT INTO `mx_balance` VALUES ('6429', 'sn701', '34747.00');
INSERT INTO `mx_balance` VALUES ('6430', 'sn701', '34737.00');
INSERT INTO `mx_balance` VALUES ('6431', 'sn701', '34732.00');
INSERT INTO `mx_balance` VALUES ('6432', 'sn701', '34742.00');
INSERT INTO `mx_balance` VALUES ('6433', 'sn701', '34737.00');
INSERT INTO `mx_balance` VALUES ('6434', 'sn701', '34732.00');
INSERT INTO `mx_balance` VALUES ('6435', 'sn701', '34737.00');
INSERT INTO `mx_balance` VALUES ('6436', 'sn701', '34732.00');
INSERT INTO `mx_balance` VALUES ('6437', 'sn701', '34727.00');
INSERT INTO `mx_balance` VALUES ('6438', 'sn701', '34721.00');
INSERT INTO `mx_balance` VALUES ('6439', 'sn701', '34726.00');
INSERT INTO `mx_balance` VALUES ('6440', 'sn701', '34721.00');
INSERT INTO `mx_balance` VALUES ('6441', 'sn701', '34726.00');
INSERT INTO `mx_balance` VALUES ('6442', 'sn701', '34826.00');
INSERT INTO `mx_balance` VALUES ('6443', 'sn701', '34926.00');
INSERT INTO `mx_balance` VALUES ('6444', 'sn701', '35026.00');
INSERT INTO `mx_balance` VALUES ('6445', 'sn701', '35126.00');
INSERT INTO `mx_balance` VALUES ('6446', 'sn701', '35226.00');
INSERT INTO `mx_balance` VALUES ('6447', 'sn701', '35326.00');
INSERT INTO `mx_balance` VALUES ('6448', 'sn701', '35426.00');
INSERT INTO `mx_balance` VALUES ('6449', 'sn701', '35526.00');
INSERT INTO `mx_balance` VALUES ('6450', 'sn701', '35626.00');
INSERT INTO `mx_balance` VALUES ('6451', 'sn701', '35636.00');
INSERT INTO `mx_balance` VALUES ('6452', 'sn701', '35736.00');
INSERT INTO `mx_balance` VALUES ('6453', 'sn701', '35836.00');
INSERT INTO `mx_balance` VALUES ('6454', 'sn701', '35936.00');
INSERT INTO `mx_balance` VALUES ('6455', 'sn701', '36036.00');
INSERT INTO `mx_balance` VALUES ('6456', 'sn701', '36136.00');
INSERT INTO `mx_balance` VALUES ('6457', 'sn701', '36236.00');
INSERT INTO `mx_balance` VALUES ('6458', 'sn701', '36336.00');
INSERT INTO `mx_balance` VALUES ('6459', 'sn701', '36436.00');
INSERT INTO `mx_balance` VALUES ('6460', 'sn701', '36536.00');
INSERT INTO `mx_balance` VALUES ('6461', 'sn701', '36636.00');
INSERT INTO `mx_balance` VALUES ('6462', 'sn701', '36736.00');
INSERT INTO `mx_balance` VALUES ('6463', 'sn701', '36836.00');
INSERT INTO `mx_balance` VALUES ('6464', 'sn701', '36736.00');
INSERT INTO `mx_balance` VALUES ('6465', 'sn701', '36836.00');
INSERT INTO `mx_balance` VALUES ('6466', 'sn701', '36936.00');
INSERT INTO `mx_balance` VALUES ('6467', 'sn701', '37036.00');
INSERT INTO `mx_balance` VALUES ('6468', 'sn701', '37136.00');
INSERT INTO `mx_balance` VALUES ('6469', 'sn701', '37236.00');
INSERT INTO `mx_balance` VALUES ('6470', 'sn701', '37336.00');
INSERT INTO `mx_balance` VALUES ('6471', 'sn701', '37436.00');
INSERT INTO `mx_balance` VALUES ('6472', 'sn701', '37536.00');
INSERT INTO `mx_balance` VALUES ('6473', 'sn701', '37636.00');
INSERT INTO `mx_balance` VALUES ('6474', 'sn701', '37736.00');
INSERT INTO `mx_balance` VALUES ('6475', 'sn701', '37836.00');
INSERT INTO `mx_balance` VALUES ('6476', 'sn701', '37936.00');
INSERT INTO `mx_balance` VALUES ('6477', 'sn701', '38036.00');
INSERT INTO `mx_balance` VALUES ('6478', 'sn701', '38136.00');
INSERT INTO `mx_balance` VALUES ('6479', 'sn701', '38236.00');
INSERT INTO `mx_balance` VALUES ('6480', 'sn701', '38336.00');
INSERT INTO `mx_balance` VALUES ('6481', 'sn701', '38436.00');
INSERT INTO `mx_balance` VALUES ('6482', 'sn701', '38336.00');
INSERT INTO `mx_balance` VALUES ('6483', 'sn701', '38436.00');
INSERT INTO `mx_balance` VALUES ('6484', 'sn701', '8436.00');
INSERT INTO `mx_balance` VALUES ('6485', 'sn701', '8336.00');
INSERT INTO `mx_balance` VALUES ('6486', 'sn701', '50000.00');
INSERT INTO `mx_balance` VALUES ('6487', 'sn702', '50000.00');
INSERT INTO `mx_balance` VALUES ('6488', 'sn703', '50000.00');
INSERT INTO `mx_balance` VALUES ('6489', 'sn701', '49900.00');
INSERT INTO `mx_balance` VALUES ('6490', 'sn701', '49800.00');
INSERT INTO `mx_balance` VALUES ('6491', 'sn701', '49900.00');
INSERT INTO `mx_balance` VALUES ('6492', 'sn701', '50000.00');
INSERT INTO `mx_balance` VALUES ('6493', 'sn701', '50100.00');
INSERT INTO `mx_balance` VALUES ('6494', 'sn701', '50070.00');
INSERT INTO `mx_balance` VALUES ('6495', 'sn701', '50050.00');
INSERT INTO `mx_balance` VALUES ('6496', 'sn701', '50030.00');
INSERT INTO `mx_balance` VALUES ('6497', 'sn701', '50010.00');
INSERT INTO `mx_balance` VALUES ('6498', 'sn701', '49990.00');
INSERT INTO `mx_balance` VALUES ('6499', 'sn701', '49970.00');
INSERT INTO `mx_balance` VALUES ('6500', 'sn701', '49960.00');
INSERT INTO `mx_balance` VALUES ('6501', 'sn701', '49940.00');
INSERT INTO `mx_balance` VALUES ('6502', 'sn702', '49900.00');
INSERT INTO `mx_balance` VALUES ('6503', 'sn702', '50000.00');
INSERT INTO `mx_balance` VALUES ('6504', 'sn701', '49930.00');
INSERT INTO `mx_balance` VALUES ('6505', 'sn701', '49910.00');
INSERT INTO `mx_balance` VALUES ('6506', 'sn701', '49900.00');
INSERT INTO `mx_balance` VALUES ('6507', 'sn701', '49880.00');
INSERT INTO `mx_balance` VALUES ('6508', 'sn701', '49860.00');
INSERT INTO `mx_balance` VALUES ('6509', 'sn701', '49850.00');
INSERT INTO `mx_balance` VALUES ('6510', 'sn701', '49840.00');
INSERT INTO `mx_balance` VALUES ('6511', 'sn701', '49830.00');
INSERT INTO `mx_balance` VALUES ('6512', 'sn701', '49810.00');
INSERT INTO `mx_balance` VALUES ('6513', 'sn701', '49790.00');
INSERT INTO `mx_balance` VALUES ('6514', 'sn701', '49770.00');
INSERT INTO `mx_balance` VALUES ('6515', 'sn701', '49760.00');
INSERT INTO `mx_balance` VALUES ('6516', 'sn701', '49750.00');
INSERT INTO `mx_balance` VALUES ('6517', 'sn701', '49730.00');
INSERT INTO `mx_balance` VALUES ('6518', 'sn701', '49720.00');
INSERT INTO `mx_balance` VALUES ('6519', 'sn701', '49670.00');
INSERT INTO `mx_balance` VALUES ('6520', 'expert132', '1744.00');
INSERT INTO `mx_balance` VALUES ('6521', 'expert132', '1704.00');
INSERT INTO `mx_balance` VALUES ('6522', 'expert132', '1664.00');
INSERT INTO `mx_balance` VALUES ('6523', 'expert132', '1624.00');
INSERT INTO `mx_balance` VALUES ('6524', 'expert132', '1594.00');
INSERT INTO `mx_balance` VALUES ('6525', 'expert132', '1694.00');
INSERT INTO `mx_balance` VALUES ('6526', 'expert132', '1654.00');
INSERT INTO `mx_balance` VALUES ('6527', 'sn701', '49680.00');
INSERT INTO `mx_balance` VALUES ('6528', 'sn701', '49675.00');
INSERT INTO `mx_balance` VALUES ('6529', 'sn701', '49669.00');
INSERT INTO `mx_balance` VALUES ('6530', 'sn701', '49663.00');
INSERT INTO `mx_balance` VALUES ('6531', 'sn701', '49658.00');
INSERT INTO `mx_balance` VALUES ('6532', 'sn701', '49653.00');
INSERT INTO `mx_balance` VALUES ('6533', 'sn701', '49646.00');
INSERT INTO `mx_balance` VALUES ('6534', 'sn701', '49631.00');
INSERT INTO `mx_balance` VALUES ('6535', 'sn701', '49626.00');
INSERT INTO `mx_balance` VALUES ('6536', 'sn701', '49621.00');
INSERT INTO `mx_balance` VALUES ('6537', 'sn701', '49616.00');
INSERT INTO `mx_balance` VALUES ('6538', 'sn701', '49596.00');
INSERT INTO `mx_balance` VALUES ('6539', 'expert132', '1554.00');
INSERT INTO `mx_balance` VALUES ('6540', 'expert132', '1514.00');
INSERT INTO `mx_balance` VALUES ('6541', 'expert132', '1474.00');
INSERT INTO `mx_balance` VALUES ('6542', 'expert132', '1434.00');
INSERT INTO `mx_balance` VALUES ('6543', 'expert132', '1374.00');
INSERT INTO `mx_balance` VALUES ('6544', 'expert132', '1334.00');
INSERT INTO `mx_balance` VALUES ('6545', 'expert132', '1314.00');
INSERT INTO `mx_balance` VALUES ('6546', 'expert132', '1294.00');
INSERT INTO `mx_balance` VALUES ('6547', 'expert132', '1264.00');
INSERT INTO `mx_balance` VALUES ('6548', 'sn701', '49593.00');
INSERT INTO `mx_balance` VALUES ('6549', 'sn701', '49543.00');
INSERT INTO `mx_balance` VALUES ('6550', 'sn701', '49537.00');
INSERT INTO `mx_balance` VALUES ('6551', 'sn701', '49531.00');
INSERT INTO `mx_balance` VALUES ('6552', 'sn701', '49525.00');
INSERT INTO `mx_balance` VALUES ('6553', 'sn701', '49520.00');
INSERT INTO `mx_balance` VALUES ('6554', 'sn701', '49515.00');
INSERT INTO `mx_balance` VALUES ('6555', 'sn701', '49465.00');
INSERT INTO `mx_balance` VALUES ('6556', 'sn702', '49900.00');
INSERT INTO `mx_balance` VALUES ('6557', 'sn701', '49365.00');
INSERT INTO `mx_balance` VALUES ('6558', 'sn701', '49465.00');
INSERT INTO `mx_balance` VALUES ('6559', 'sn702', '50000.00');
INSERT INTO `mx_balance` VALUES ('6560', 'sn701', '49445.00');
INSERT INTO `mx_balance` VALUES ('6561', 'expert132', '1234.00');
INSERT INTO `mx_balance` VALUES ('6562', 'expert132', '1204.00');
INSERT INTO `mx_balance` VALUES ('6563', 'sn701', '49425.00');
INSERT INTO `mx_balance` VALUES ('6564', 'sn701', '49415.00');
INSERT INTO `mx_balance` VALUES ('6565', 'sn701', '49395.00');
INSERT INTO `mx_balance` VALUES ('6566', 'expert132', '1174.00');
INSERT INTO `mx_balance` VALUES ('6567', 'expert132', '1134.00');
INSERT INTO `mx_balance` VALUES ('6568', 'sn701', '49385.00');
INSERT INTO `mx_balance` VALUES ('6569', 'expert132', '1126.00');
INSERT INTO `mx_balance` VALUES ('6570', 'sn701', '49375.00');
INSERT INTO `mx_balance` VALUES ('6571', 'sn703', '49999.00');
INSERT INTO `mx_balance` VALUES ('6572', 'sn703', '49998.00');
INSERT INTO `mx_balance` VALUES ('6573', 'sn703', '49996.00');
INSERT INTO `mx_balance` VALUES ('6574', 'sn703', '49994.00');
INSERT INTO `mx_balance` VALUES ('6575', 'sn701', '49355.00');
INSERT INTO `mx_balance` VALUES ('6576', 'expert132', '1096.00');
INSERT INTO `mx_balance` VALUES ('6577', 'sn703', '49993.00');
INSERT INTO `mx_balance` VALUES ('6578', 'expert132', '1036.00');
INSERT INTO `mx_balance` VALUES ('6579', 'sn701', '49335.00');
INSERT INTO `mx_balance` VALUES ('6580', 'sn701', '49325.00');
INSERT INTO `mx_balance` VALUES ('6581', 'expert132', '996.00');
INSERT INTO `mx_balance` VALUES ('6582', 'sn701', '49295.00');
INSERT INTO `mx_balance` VALUES ('6583', 'expert132', '896.00');
INSERT INTO `mx_balance` VALUES ('6584', 'expert132', '996.00');
INSERT INTO `mx_balance` VALUES ('6585', 'sn701', '49265.00');
INSERT INTO `mx_balance` VALUES ('6586', 'sn701', '49235.00');
INSERT INTO `mx_balance` VALUES ('6587', 'sn701', '49205.00');
INSERT INTO `mx_balance` VALUES ('6588', 'sn701', '49175.00');
INSERT INTO `mx_balance` VALUES ('6589', 'expert132', '966.00');
INSERT INTO `mx_balance` VALUES ('6590', 'expert132', '926.00');
INSERT INTO `mx_balance` VALUES ('6591', 'expert132', '896.00');
INSERT INTO `mx_balance` VALUES ('6592', 'expert132', '856.00');
INSERT INTO `mx_balance` VALUES ('6593', 'expert132', '816.00');
INSERT INTO `mx_balance` VALUES ('6594', 'expert132', '766.00');
INSERT INTO `mx_balance` VALUES ('6595', 'expert132', '716.00');
INSERT INTO `mx_balance` VALUES ('6596', 'sn701', '49125.00');
INSERT INTO `mx_balance` VALUES ('6597', 'expert132', '816.00');
INSERT INTO `mx_balance` VALUES ('6598', 'sn701', '49115.00');
INSERT INTO `mx_balance` VALUES ('6599', 'sn701', '49105.00');
INSERT INTO `mx_balance` VALUES ('6600', 'sn701', '49115.00');
INSERT INTO `mx_balance` VALUES ('6601', 'sn701', '49105.00');
INSERT INTO `mx_balance` VALUES ('6602', 'expert132', '916.00');
INSERT INTO `mx_balance` VALUES ('6603', 'expert132', '866.00');
INSERT INTO `mx_balance` VALUES ('6604', 'sn701', '49005.00');
INSERT INTO `mx_balance` VALUES ('6605', 'sn701', '48505.00');
INSERT INTO `mx_balance` VALUES ('6606', 'sn701', '50005.00');
INSERT INTO `mx_balance` VALUES ('6607', 'sn701', '50105.00');
INSERT INTO `mx_balance` VALUES ('6608', 'sn703', '49943.00');
INSERT INTO `mx_balance` VALUES ('6609', 'sn703', '49993.00');
INSERT INTO `mx_balance` VALUES ('6610', 'sn703', '49943.00');
INSERT INTO `mx_balance` VALUES ('6611', 'sn702', '49950.00');
INSERT INTO `mx_balance` VALUES ('6612', 'sn701', '49655.00');
INSERT INTO `mx_balance` VALUES ('6613', 'sn701', '49205.00');
INSERT INTO `mx_balance` VALUES ('6614', 'expert132', '766.00');
INSERT INTO `mx_balance` VALUES ('6615', 'expert132', '666.00');
INSERT INTO `mx_balance` VALUES ('6616', 'expert132', '616.00');
INSERT INTO `mx_balance` VALUES ('6617', 'expert132', '716.00');
INSERT INTO `mx_balance` VALUES ('6618', 'sn703', '49853.00');
INSERT INTO `mx_balance` VALUES ('6619', 'sn703', '49403.00');
INSERT INTO `mx_balance` VALUES ('6620', 'sn703', '49453.00');
INSERT INTO `mx_balance` VALUES ('6621', 'sn703', '49553.00');
INSERT INTO `mx_balance` VALUES ('6622', 'sn703', '48713.00');
INSERT INTO `mx_balance` VALUES ('6623', 'sn703', '48613.00');
INSERT INTO `mx_balance` VALUES ('6624', 'sn703', '43613.00');
INSERT INTO `mx_balance` VALUES ('6625', 'sn703', '43593.00');
INSERT INTO `mx_balance` VALUES ('6626', 'sn703', '43583.00');
INSERT INTO `mx_balance` VALUES ('6627', 'sn703', '43593.00');
INSERT INTO `mx_balance` VALUES ('6628', 'sn703', '48593.00');
INSERT INTO `mx_balance` VALUES ('6629', 'sn703', '48693.00');
INSERT INTO `mx_balance` VALUES ('6630', 'sn703', '48713.00');
INSERT INTO `mx_balance` VALUES ('6631', 'sn703', '49413.00');
INSERT INTO `mx_balance` VALUES ('6632', 'sn703', '49363.00');
INSERT INTO `mx_balance` VALUES ('6633', 'sn703', '49263.00');
INSERT INTO `mx_balance` VALUES ('6634', 'sn703', '49363.00');
INSERT INTO `mx_balance` VALUES ('6635', 'expert132', '616.00');
INSERT INTO `mx_balance` VALUES ('6636', 'expert132', '716.00');
INSERT INTO `mx_balance` VALUES ('6637', 'expert132', '616.00');
INSERT INTO `mx_balance` VALUES ('6638', 'expert132', '716.00');
INSERT INTO `mx_balance` VALUES ('6639', 'expert132', '616.00');
INSERT INTO `mx_balance` VALUES ('6640', 'expert132', '516.00');
INSERT INTO `mx_balance` VALUES ('6641', 'expert132', '616.00');
INSERT INTO `mx_balance` VALUES ('6642', 'sn703', '48363.00');
INSERT INTO `mx_balance` VALUES ('6643', 'sn703', '43363.00');
INSERT INTO `mx_balance` VALUES ('6644', 'expert132', '516.00');
INSERT INTO `mx_balance` VALUES ('6645', 'expert132', '916.00');
INSERT INTO `mx_balance` VALUES ('6646', 'sn703', '48363.00');
INSERT INTO `mx_balance` VALUES ('6647', 'sn703', '49363.00');
INSERT INTO `mx_balance` VALUES ('6648', 'expert132', '816.00');
INSERT INTO `mx_balance` VALUES ('6649', 'expert132', '916.00');
INSERT INTO `mx_balance` VALUES ('6650', 'expert132', '50916.00');
INSERT INTO `mx_balance` VALUES ('6651', 'expert132', '45916.00');
INSERT INTO `mx_balance` VALUES ('6652', 'expert132', '40916.00');
INSERT INTO `mx_balance` VALUES ('6653', 'expert132', '30916.00');
INSERT INTO `mx_balance` VALUES ('6654', 'expert132', '70916.00');
INSERT INTO `mx_balance` VALUES ('6655', 'expert132', '90916.00');
INSERT INTO `mx_balance` VALUES ('6656', 'expert132', '95916.00');
INSERT INTO `mx_balance` VALUES ('6657', 'sn703', '48363.00');
INSERT INTO `mx_balance` VALUES ('6658', 'sn703', '47363.00');
INSERT INTO `mx_balance` VALUES ('6659', 'sn703', '37363.00');
INSERT INTO `mx_balance` VALUES ('6660', 'sn703', '32363.00');
INSERT INTO `mx_balance` VALUES ('6661', 'sn703', '52363.00');
INSERT INTO `mx_balance` VALUES ('6662', 'sn703', '92363.00');
INSERT INTO `mx_balance` VALUES ('6663', 'sn703', '96363.00');
INSERT INTO `mx_balance` VALUES ('6664', 'sn703', '100363.00');
INSERT INTO `mx_balance` VALUES ('6665', 'sn703', '100263.00');
INSERT INTO `mx_balance` VALUES ('6666', 'sn703', '100363.00');
INSERT INTO `mx_balance` VALUES ('6667', 'sn703', '99363.00');
INSERT INTO `mx_balance` VALUES ('6668', 'sn703', '89363.00');
INSERT INTO `mx_balance` VALUES ('6669', 'sn703', '84363.00');
INSERT INTO `mx_balance` VALUES ('6670', 'sn703', '84353.00');
INSERT INTO `mx_balance` VALUES ('6671', 'sn703', '84333.00');
INSERT INTO `mx_balance` VALUES ('6672', 'sn703', '84283.00');
INSERT INTO `mx_balance` VALUES ('6673', 'sn703', '84483.00');
INSERT INTO `mx_balance` VALUES ('6674', 'sn703', '84563.00');
INSERT INTO `mx_balance` VALUES ('6675', 'sn703', '124563.00');
INSERT INTO `mx_balance` VALUES ('6676', 'sn703', '128563.00');
INSERT INTO `mx_balance` VALUES ('6677', 'sn703', '148563.00');
INSERT INTO `mx_balance` VALUES ('6678', 'sn703', '148603.00');
INSERT INTO `mx_balance` VALUES ('6679', 'sn703', '148593.00');
INSERT INTO `mx_balance` VALUES ('6680', 'sn703', '148603.00');
INSERT INTO `mx_balance` VALUES ('6681', 'expert132', '94916.00');
INSERT INTO `mx_balance` VALUES ('6682', 'expert132', '93916.00');
INSERT INTO `mx_balance` VALUES ('6683', 'expert132', '92916.00');
INSERT INTO `mx_balance` VALUES ('6684', 'expert132', '94916.00');
INSERT INTO `mx_balance` VALUES ('6685', 'expert132', '96916.00');
INSERT INTO `mx_balance` VALUES ('6686', 'expert132', '98916.00');
INSERT INTO `mx_balance` VALUES ('6687', 'expert132', '99016.00');
INSERT INTO `mx_balance` VALUES ('6688', 'sn703', '138603.00');
INSERT INTO `mx_balance` VALUES ('6689', 'sn703', '137603.00');
INSERT INTO `mx_balance` VALUES ('6690', 'sn703', '137593.00');
INSERT INTO `mx_balance` VALUES ('6691', 'sn703', '137573.00');
INSERT INTO `mx_balance` VALUES ('6692', 'sn703', '137473.00');
INSERT INTO `mx_balance` VALUES ('6693', 'sn703', '137873.00');
INSERT INTO `mx_balance` VALUES ('6694', 'sn703', '137953.00');
INSERT INTO `mx_balance` VALUES ('6695', 'sn703', '137993.00');
INSERT INTO `mx_balance` VALUES ('6696', 'sn703', '141993.00');
INSERT INTO `mx_balance` VALUES ('6697', 'sn703', '181993.00');
INSERT INTO `mx_balance` VALUES ('6698', 'expert132', '98016.00');
INSERT INTO `mx_balance` VALUES ('6699', 'expert132', '99016.00');
INSERT INTO `mx_balance` VALUES ('6700', 'expert132', '98016.00');
INSERT INTO `mx_balance` VALUES ('6701', 'expert132', '99016.00');
INSERT INTO `mx_balance` VALUES ('6702', 'expert132', '89016.00');
INSERT INTO `mx_balance` VALUES ('6703', 'expert132', '99016.00');
INSERT INTO `mx_balance` VALUES ('6704', 'sn703', '171993.00');
INSERT INTO `mx_balance` VALUES ('6705', 'sn703', '166993.00');
INSERT INTO `mx_balance` VALUES ('6706', 'sn703', '165993.00');
INSERT INTO `mx_balance` VALUES ('6707', 'sn703', '165983.00');
INSERT INTO `mx_balance` VALUES ('6708', 'sn703', '165993.00');
INSERT INTO `mx_balance` VALUES ('6709', 'sn703', '166993.00');
INSERT INTO `mx_balance` VALUES ('6710', 'sn703', '171993.00');
INSERT INTO `mx_balance` VALUES ('6711', 'sn703', '181993.00');
INSERT INTO `mx_balance` VALUES ('6712', 'expert132', '98916.00');
INSERT INTO `mx_balance` VALUES ('6713', 'expert132', '99016.00');
INSERT INTO `mx_balance` VALUES ('6714', 'expert132', '98916.00');
INSERT INTO `mx_balance` VALUES ('6715', 'expert132', '99016.00');
INSERT INTO `mx_balance` VALUES ('6716', 'sn703', '181893.00');
INSERT INTO `mx_balance` VALUES ('6717', 'sn703', '182293.00');
INSERT INTO `mx_balance` VALUES ('6718', 'sn703', '181793.00');
INSERT INTO `mx_balance` VALUES ('6719', 'sn703', '183793.00');
INSERT INTO `mx_balance` VALUES ('6720', 'expert132', '89016.00');
INSERT INTO `mx_balance` VALUES ('6721', 'expert132', '129016.00');
INSERT INTO `mx_balance` VALUES ('6722', 'sn701', '49185.00');
INSERT INTO `mx_balance` VALUES ('6723', 'sn701', '49165.00');
INSERT INTO `mx_balance` VALUES ('6724', 'sn701', '49155.00');
INSERT INTO `mx_balance` VALUES ('6725', 'sn701', '49135.00');
INSERT INTO `mx_balance` VALUES ('6726', 'sn701', '49115.00');
INSERT INTO `mx_balance` VALUES ('6727', 'sn701', '50000.00');
INSERT INTO `mx_balance` VALUES ('6728', 'sn702', '50000.00');
INSERT INTO `mx_balance` VALUES ('6729', 'sn703', '133793.00');
INSERT INTO `mx_balance` VALUES ('6730', 'sn703', '83793.00');
INSERT INTO `mx_balance` VALUES ('6731', 'sn703', '53793.00');
INSERT INTO `mx_balance` VALUES ('6732', 'sn703', '23793.00');
INSERT INTO `mx_balance` VALUES ('6733', 'sn703', '51100.00');
INSERT INTO `mx_balance` VALUES ('6734', 'sn703', '50000.00');
INSERT INTO `mx_balance` VALUES ('6735', 'sn701', '49980.00');
INSERT INTO `mx_balance` VALUES ('6736', 'sn701', '49960.00');
INSERT INTO `mx_balance` VALUES ('6737', 'sn701', '49920.00');
INSERT INTO `mx_balance` VALUES ('6738', 'sn703', '49960.00');
INSERT INTO `mx_balance` VALUES ('6739', 'sn703', '49930.00');
INSERT INTO `mx_balance` VALUES ('6740', 'sn703', '49900.00');
INSERT INTO `mx_balance` VALUES ('6741', 'sn703', '49870.00');
INSERT INTO `mx_balance` VALUES ('6742', 'sn703', '49860.00');
INSERT INTO `mx_balance` VALUES ('6743', 'sn703', '49830.00');
INSERT INTO `mx_balance` VALUES ('6744', 'sn703', '49820.00');
INSERT INTO `mx_balance` VALUES ('6745', 'sn702', '49990.00');
INSERT INTO `mx_balance` VALUES ('6746', 'sn702', '49960.00');
INSERT INTO `mx_balance` VALUES ('6747', 'sn703', '49800.00');
INSERT INTO `mx_balance` VALUES ('6748', 'sn703', '49780.00');
INSERT INTO `mx_balance` VALUES ('6749', 'sn702', '49940.00');
INSERT INTO `mx_balance` VALUES ('6750', 'sn702', '49920.00');
INSERT INTO `mx_balance` VALUES ('6751', 'sn702', '49900.00');
INSERT INTO `mx_balance` VALUES ('6752', 'sn703', '49760.00');
INSERT INTO `mx_balance` VALUES ('6753', 'sn703', '49740.00');
INSERT INTO `mx_balance` VALUES ('6754', 'sn702', '49890.00');
INSERT INTO `mx_balance` VALUES ('6755', 'sn702', '49870.00');
INSERT INTO `mx_balance` VALUES ('6756', 'sn703', '49720.00');
INSERT INTO `mx_balance` VALUES ('6757', 'sn702', '49850.00');
INSERT INTO `mx_balance` VALUES ('6758', 'sn703', '49710.00');
INSERT INTO `mx_balance` VALUES ('6759', 'sn702', '49830.00');
INSERT INTO `mx_balance` VALUES ('6760', 'sn703', '49690.00');
INSERT INTO `mx_balance` VALUES ('6761', 'sn702', '49780.00');
INSERT INTO `mx_balance` VALUES ('6762', 'sn702', '49770.00');
INSERT INTO `mx_balance` VALUES ('6763', 'sn702', '49740.00');
INSERT INTO `mx_balance` VALUES ('6764', 'sn703', '49670.00');
INSERT INTO `mx_balance` VALUES ('6765', 'sn702', '49720.00');
INSERT INTO `mx_balance` VALUES ('6766', 'sn703', '49640.00');
INSERT INTO `mx_balance` VALUES ('6767', 'sn702', '49690.00');
INSERT INTO `mx_balance` VALUES ('6768', 'sn701', '49900.00');
INSERT INTO `mx_balance` VALUES ('6769', 'sn701', '49880.00');
INSERT INTO `mx_balance` VALUES ('6770', 'sn703', '49620.00');
INSERT INTO `mx_balance` VALUES ('6771', 'sn702', '49670.00');
INSERT INTO `mx_balance` VALUES ('6772', 'sn702', '49660.00');
INSERT INTO `mx_balance` VALUES ('6773', 'sn701', '49850.00');
INSERT INTO `mx_balance` VALUES ('6774', 'sn703', '49600.00');
INSERT INTO `mx_balance` VALUES ('6775', 'sn702', '49630.00');
INSERT INTO `mx_balance` VALUES ('6776', 'sn701', '49820.00');
INSERT INTO `mx_balance` VALUES ('6777', 'sn703', '49580.00');
INSERT INTO `mx_balance` VALUES ('6778', 'sn701', '49790.00');
INSERT INTO `mx_balance` VALUES ('6779', 'sn701', '49740.00');
INSERT INTO `mx_balance` VALUES ('6780', 'sn701', '49730.00');
INSERT INTO `mx_balance` VALUES ('6781', 'sn701', '49700.00');
INSERT INTO `mx_balance` VALUES ('6782', 'sn703', '49560.00');
INSERT INTO `mx_balance` VALUES ('6783', 'sn703', '49540.00');
INSERT INTO `mx_balance` VALUES ('6784', 'sn701', '49670.00');
INSERT INTO `mx_balance` VALUES ('6785', 'sn701', '49640.00');
INSERT INTO `mx_balance` VALUES ('6786', 'sn703', '49510.00');
INSERT INTO `mx_balance` VALUES ('6787', 'sn702', '49600.00');
INSERT INTO `mx_balance` VALUES ('6788', 'sn703', '49500.00');
INSERT INTO `mx_balance` VALUES ('6789', 'sn702', '49580.00');
INSERT INTO `mx_balance` VALUES ('6790', 'sn701', '49610.00');
INSERT INTO `mx_balance` VALUES ('6791', 'sn703', '49480.00');
INSERT INTO `mx_balance` VALUES ('6792', 'sn703', '49460.00');
INSERT INTO `mx_balance` VALUES ('6793', 'sn702', '49530.00');
INSERT INTO `mx_balance` VALUES ('6794', 'sn702', '49470.00');
INSERT INTO `mx_balance` VALUES ('6795', 'sn702', '49430.00');
INSERT INTO `mx_balance` VALUES ('6796', 'sn702', '49400.00');
INSERT INTO `mx_balance` VALUES ('6797', 'expert132', '128966.00');
INSERT INTO `mx_balance` VALUES ('6798', 'expert132', '128916.00');
INSERT INTO `mx_balance` VALUES ('6799', 'expert132', '128866.00');
INSERT INTO `mx_balance` VALUES ('6800', 'expert132', '128806.00');
INSERT INTO `mx_balance` VALUES ('6801', 'expert132', '128715.00');
INSERT INTO `mx_balance` VALUES ('6802', 'sn701', '49600.00');
INSERT INTO `mx_balance` VALUES ('6803', 'sn701', '49580.00');
INSERT INTO `mx_balance` VALUES ('6804', 'sn701', '49570.00');
INSERT INTO `mx_balance` VALUES ('6805', 'sn703', '49450.00');
INSERT INTO `mx_balance` VALUES ('6806', 'sn701', '49560.00');
INSERT INTO `mx_balance` VALUES ('6807', 'sn701', '49540.00');
INSERT INTO `mx_balance` VALUES ('6808', 'sn701', '49530.00');
INSERT INTO `mx_balance` VALUES ('6809', 'sn701', '49500.00');
INSERT INTO `mx_balance` VALUES ('6810', 'sn703', '49440.00');
INSERT INTO `mx_balance` VALUES ('6811', 'sn701', '49470.00');
INSERT INTO `mx_balance` VALUES ('6812', 'sn701', '49460.00');
INSERT INTO `mx_balance` VALUES ('6813', 'expert132', '128665.00');
INSERT INTO `mx_balance` VALUES ('6814', 'sn703', '49430.00');
INSERT INTO `mx_balance` VALUES ('6815', 'sn701', '49420.00');
INSERT INTO `mx_balance` VALUES ('6816', 'sn701', '49410.00');
INSERT INTO `mx_balance` VALUES ('6817', 'sn703', '49420.00');
INSERT INTO `mx_balance` VALUES ('6818', 'sn701', '49390.00');
INSERT INTO `mx_balance` VALUES ('6819', 'sn701', '49370.00');
INSERT INTO `mx_balance` VALUES ('6820', 'sn701', '49350.00');
INSERT INTO `mx_balance` VALUES ('6821', 'sn703', '49370.00');
INSERT INTO `mx_balance` VALUES ('6822', 'sn701', '49320.00');
INSERT INTO `mx_balance` VALUES ('6823', 'sn701', '49310.00');
INSERT INTO `mx_balance` VALUES ('6824', 'sn701', '49290.00');
INSERT INTO `mx_balance` VALUES ('6825', 'sn704', '43050.00');
INSERT INTO `mx_balance` VALUES ('6826', 'sn701', '49270.00');
INSERT INTO `mx_balance` VALUES ('6827', 'sn703', '49320.00');
INSERT INTO `mx_balance` VALUES ('6828', 'sn701', '49250.00');
INSERT INTO `mx_balance` VALUES ('6829', 'sn701', '49220.00');
INSERT INTO `mx_balance` VALUES ('6830', 'sn701', '49180.00');
INSERT INTO `mx_balance` VALUES ('6831', 'sn701', '49160.00');
INSERT INTO `mx_balance` VALUES ('6832', 'sn703', '49310.00');
INSERT INTO `mx_balance` VALUES ('6833', 'sn701', '49140.00');
INSERT INTO `mx_balance` VALUES ('6834', 'sn701', '49130.00');
INSERT INTO `mx_balance` VALUES ('6835', 'sn701', '49090.00');
INSERT INTO `mx_balance` VALUES ('6836', 'sn701', '49060.00');
INSERT INTO `mx_balance` VALUES ('6837', 'sn701', '49030.00');
INSERT INTO `mx_balance` VALUES ('6838', 'sn701', '49020.00');
INSERT INTO `mx_balance` VALUES ('6839', 'sn701', '49000.00');
INSERT INTO `mx_balance` VALUES ('6840', 'sn701', '48970.00');
INSERT INTO `mx_balance` VALUES ('6841', 'sn701', '48950.00');
INSERT INTO `mx_balance` VALUES ('6842', 'sn701', '48930.00');
INSERT INTO `mx_balance` VALUES ('6843', 'sn703', '49270.00');
INSERT INTO `mx_balance` VALUES ('6844', 'sn703', '49210.00');
INSERT INTO `mx_balance` VALUES ('6845', 'sn703', '49130.00');
INSERT INTO `mx_balance` VALUES ('6846', 'sn703', '49050.00');
INSERT INTO `mx_balance` VALUES ('6847', 'sn703', '48970.00');
INSERT INTO `mx_balance` VALUES ('6848', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('6849', 'sn703', '48860.00');
INSERT INTO `mx_balance` VALUES ('6850', 'sn703', '48780.00');
INSERT INTO `mx_balance` VALUES ('6851', 'yogi', '500.00');
INSERT INTO `mx_balance` VALUES ('6852', 'sn701', '48920.00');
INSERT INTO `mx_balance` VALUES ('6853', 'sn703', '48660.00');
INSERT INTO `mx_balance` VALUES ('6854', 'sn703', '48640.00');
INSERT INTO `mx_balance` VALUES ('6855', 'sn703', '48610.00');
INSERT INTO `mx_balance` VALUES ('6856', 'sn703', '48590.00');
INSERT INTO `mx_balance` VALUES ('6857', 'sn703', '48560.00');
INSERT INTO `mx_balance` VALUES ('6858', 'sn703', '48510.00');
INSERT INTO `mx_balance` VALUES ('6859', 'sn703', '48370.00');
INSERT INTO `mx_balance` VALUES ('6860', 'sn703', '48350.00');
INSERT INTO `mx_balance` VALUES ('6861', 'sn703', '48340.00');
INSERT INTO `mx_balance` VALUES ('6862', 'sn703', '48300.00');
INSERT INTO `mx_balance` VALUES ('6863', 'sn703', '48280.00');
INSERT INTO `mx_balance` VALUES ('6864', 'sn703', '48240.00');
INSERT INTO `mx_balance` VALUES ('6865', 'sn703', '48340.00');
INSERT INTO `mx_balance` VALUES ('6866', 'sn703', '48640.00');
INSERT INTO `mx_balance` VALUES ('6867', 'sn703', '48840.00');
INSERT INTO `mx_balance` VALUES ('6868', 'sn703', '48940.00');
INSERT INTO `mx_balance` VALUES ('6869', 'sn703', '49040.00');
INSERT INTO `mx_balance` VALUES ('6870', 'sn703', '49020.00');
INSERT INTO `mx_balance` VALUES ('6871', 'sn703', '49000.00');
INSERT INTO `mx_balance` VALUES ('6872', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('6873', 'sn703', '48940.00');
INSERT INTO `mx_balance` VALUES ('6874', 'sn703', '48930.00');
INSERT INTO `mx_balance` VALUES ('6875', 'sn703', '48680.00');
INSERT INTO `mx_balance` VALUES ('6876', 'sn703', '48430.00');
INSERT INTO `mx_balance` VALUES ('6877', 'expert132', '128615.00');
INSERT INTO `mx_balance` VALUES ('6878', 'sn703', '48410.00');
INSERT INTO `mx_balance` VALUES ('6879', 'sn703', '48390.00');
INSERT INTO `mx_balance` VALUES ('6880', 'sn703', '48360.00');
INSERT INTO `mx_balance` VALUES ('6881', 'sn703', '48330.00');
INSERT INTO `mx_balance` VALUES ('6882', 'sn703', '48310.00');
INSERT INTO `mx_balance` VALUES ('6883', 'sn703', '48060.00');
INSERT INTO `mx_balance` VALUES ('6884', 'sn703', '47810.00');
INSERT INTO `mx_balance` VALUES ('6885', 'sn704', '43040.00');
INSERT INTO `mx_balance` VALUES ('6886', 'sn703', '47710.00');
INSERT INTO `mx_balance` VALUES ('6887', 'sn703', '47700.00');
INSERT INTO `mx_balance` VALUES ('6888', 'expert132', '128515.00');
INSERT INTO `mx_balance` VALUES ('6889', 'sn703', '47690.00');
INSERT INTO `mx_balance` VALUES ('6890', 'expert132', '128415.00');
INSERT INTO `mx_balance` VALUES ('6891', 'sn704', '42940.00');
INSERT INTO `mx_balance` VALUES ('6892', 'sn704', '42930.00');
INSERT INTO `mx_balance` VALUES ('6893', 'sn703', '47670.00');
INSERT INTO `mx_balance` VALUES ('6894', 'sn704', '42910.00');
INSERT INTO `mx_balance` VALUES ('6895', 'sn703', '47650.00');
INSERT INTO `mx_balance` VALUES ('6896', 'sn703', '47630.00');
INSERT INTO `mx_balance` VALUES ('6897', 'sn703', '47610.00');
INSERT INTO `mx_balance` VALUES ('6898', 'sn703', '47590.00');
INSERT INTO `mx_balance` VALUES ('6899', 'sn703', '47580.00');
INSERT INTO `mx_balance` VALUES ('6900', 'sn704', '42860.00');
INSERT INTO `mx_balance` VALUES ('6901', 'expert132', '128615.00');
INSERT INTO `mx_balance` VALUES ('6902', 'sn701', '48910.00');
INSERT INTO `mx_balance` VALUES ('6903', 'sn704', '42960.00');
INSERT INTO `mx_balance` VALUES ('6904', 'sn703', '47570.00');
INSERT INTO `mx_balance` VALUES ('6905', 'sn703', '47420.00');
INSERT INTO `mx_balance` VALUES ('6906', 'sn703', '47270.00');
INSERT INTO `mx_balance` VALUES ('6907', 'sn702', '49380.00');
INSERT INTO `mx_balance` VALUES ('6908', 'sn701', '48900.00');
INSERT INTO `mx_balance` VALUES ('6909', 'sn704', '42990.00');
INSERT INTO `mx_balance` VALUES ('6910', 'sn704', '43000.00');
INSERT INTO `mx_balance` VALUES ('6911', 'sn704', '43200.00');
INSERT INTO `mx_balance` VALUES ('6912', 'sn704', '43240.00');
INSERT INTO `mx_balance` VALUES ('6913', 'sn704', '43260.00');
INSERT INTO `mx_balance` VALUES ('6914', 'sn702', '49360.00');
INSERT INTO `mx_balance` VALUES ('6915', 'sn703', '47250.00');
INSERT INTO `mx_balance` VALUES ('6916', 'sn701', '48880.00');
INSERT INTO `mx_balance` VALUES ('6917', 'sn703', '47220.00');
INSERT INTO `mx_balance` VALUES ('6918', 'sn703', '47200.00');
INSERT INTO `mx_balance` VALUES ('6919', 'sn703', '47170.00');
INSERT INTO `mx_balance` VALUES ('6920', 'sn703', '47150.00');
INSERT INTO `mx_balance` VALUES ('6921', 'sn701', '48870.00');
INSERT INTO `mx_balance` VALUES ('6922', 'sn703', '47140.00');
INSERT INTO `mx_balance` VALUES ('6923', 'sn701', '48860.00');
INSERT INTO `mx_balance` VALUES ('6924', 'sn701', '48840.00');
INSERT INTO `mx_balance` VALUES ('6925', 'sn703', '47040.00');
INSERT INTO `mx_balance` VALUES ('6926', 'sn703', '46940.00');
INSERT INTO `mx_balance` VALUES ('6927', 'sn703', '46920.00');
INSERT INTO `mx_balance` VALUES ('6928', 'expert132', '128515.00');
INSERT INTO `mx_balance` VALUES ('6929', 'sn703', '46870.00');
INSERT INTO `mx_balance` VALUES ('6930', 'sn703', '46820.00');
INSERT INTO `mx_balance` VALUES ('6931', 'sn703', '46800.00');
INSERT INTO `mx_balance` VALUES ('6932', 'expert132', '128915.00');
INSERT INTO `mx_balance` VALUES ('6933', 'sn701', '48820.00');
INSERT INTO `mx_balance` VALUES ('6934', 'sn703', '46750.00');
INSERT INTO `mx_balance` VALUES ('6935', 'sn703', '46700.00');
INSERT INTO `mx_balance` VALUES ('6936', 'sn701', '48810.00');
INSERT INTO `mx_balance` VALUES ('6937', 'sn703', '46680.00');
INSERT INTO `mx_balance` VALUES ('6938', 'sn701', '48800.00');
INSERT INTO `mx_balance` VALUES ('6939', 'sn702', '49350.00');
INSERT INTO `mx_balance` VALUES ('6940', 'sn703', '46630.00');
INSERT INTO `mx_balance` VALUES ('6941', 'sn703', '46580.00');
INSERT INTO `mx_balance` VALUES ('6942', 'sn703', '46570.00');
INSERT INTO `mx_balance` VALUES ('6943', 'sn703', '46560.00');
INSERT INTO `mx_balance` VALUES ('6944', 'sn703', '46550.00');
INSERT INTO `mx_balance` VALUES ('6945', 'sn703', '46650.00');
INSERT INTO `mx_balance` VALUES ('6946', 'sn703', '46750.00');
INSERT INTO `mx_balance` VALUES ('6947', 'sn703', '47150.00');
INSERT INTO `mx_balance` VALUES ('6948', 'sn703', '47250.00');
INSERT INTO `mx_balance` VALUES ('6949', 'sn703', '47750.00');
INSERT INTO `mx_balance` VALUES ('6950', 'sn703', '48050.00');
INSERT INTO `mx_balance` VALUES ('6951', 'sn703', '48150.00');
INSERT INTO `mx_balance` VALUES ('6952', 'sn703', '48650.00');
INSERT INTO `mx_balance` VALUES ('6953', 'sn703', '48750.00');
INSERT INTO `mx_balance` VALUES ('6954', 'sn703', '48950.00');
INSERT INTO `mx_balance` VALUES ('6955', 'sn703', '49150.00');
INSERT INTO `mx_balance` VALUES ('6956', 'sn702', '49340.00');
INSERT INTO `mx_balance` VALUES ('6957', 'sn703', '49140.00');
INSERT INTO `mx_balance` VALUES ('6958', 'sn703', '49090.00');
INSERT INTO `mx_balance` VALUES ('6959', 'sn703', '49040.00');
INSERT INTO `mx_balance` VALUES ('6960', 'sn703', '49140.00');
INSERT INTO `mx_balance` VALUES ('6961', 'sn703', '49130.00');
INSERT INTO `mx_balance` VALUES ('6962', 'sn703', '49080.00');
INSERT INTO `mx_balance` VALUES ('6963', 'sn703', '49030.00');
INSERT INTO `mx_balance` VALUES ('6964', 'sn703', '49430.00');
INSERT INTO `mx_balance` VALUES ('6965', 'sn703', '49380.00');
INSERT INTO `mx_balance` VALUES ('6966', 'sn703', '49330.00');
INSERT INTO `mx_balance` VALUES ('6967', 'sn703', '49320.00');
INSERT INTO `mx_balance` VALUES ('6968', 'sn703', '49270.00');
INSERT INTO `mx_balance` VALUES ('6969', 'sn703', '49220.00');
INSERT INTO `mx_balance` VALUES ('6970', 'sn703', '49210.00');
INSERT INTO `mx_balance` VALUES ('6971', 'sn703', '49310.00');
INSERT INTO `mx_balance` VALUES ('6972', 'sn703', '49410.00');
INSERT INTO `mx_balance` VALUES ('6973', 'sn703', '49390.00');
INSERT INTO `mx_balance` VALUES ('6974', 'sn703', '49370.00');
INSERT INTO `mx_balance` VALUES ('6975', 'sn703', '49350.00');
INSERT INTO `mx_balance` VALUES ('6976', 'sn703', '49310.00');
INSERT INTO `mx_balance` VALUES ('6977', 'sn703', '49290.00');
INSERT INTO `mx_balance` VALUES ('6978', 'sn702', '49330.00');
INSERT INTO `mx_balance` VALUES ('6979', 'sn701', '48770.00');
INSERT INTO `mx_balance` VALUES ('6980', 'sn702', '49300.00');
INSERT INTO `mx_balance` VALUES ('6981', 'sn702', '49260.00');
INSERT INTO `mx_balance` VALUES ('6982', 'sn701', '48740.00');
INSERT INTO `mx_balance` VALUES ('6983', 'sn702', '49240.00');
INSERT INTO `mx_balance` VALUES ('6984', 'sn701', '48710.00');
INSERT INTO `mx_balance` VALUES ('6985', 'sn701', '48690.00');
INSERT INTO `mx_balance` VALUES ('6986', 'sn701', '48670.00');
INSERT INTO `mx_balance` VALUES ('6987', 'sn703', '49280.00');
INSERT INTO `mx_balance` VALUES ('6988', 'sn703', '49230.00');
INSERT INTO `mx_balance` VALUES ('6989', 'sn703', '49180.00');
INSERT INTO `mx_balance` VALUES ('6990', 'sn701', '48640.00');
INSERT INTO `mx_balance` VALUES ('6991', 'sn703', '49280.00');
INSERT INTO `mx_balance` VALUES ('6992', 'sn701', '48600.00');
INSERT INTO `mx_balance` VALUES ('6993', 'sn701', '48570.00');
INSERT INTO `mx_balance` VALUES ('6994', 'sn701', '48560.00');
INSERT INTO `mx_balance` VALUES ('6995', 'sn701', '48550.00');
INSERT INTO `mx_balance` VALUES ('6996', 'sn701', '48510.00');
INSERT INTO `mx_balance` VALUES ('6997', 'sn701', '48500.00');
INSERT INTO `mx_balance` VALUES ('6998', 'sn701', '48470.00');
INSERT INTO `mx_balance` VALUES ('6999', 'sn702', '49220.00');
INSERT INTO `mx_balance` VALUES ('7000', 'sn702', '49190.00');
INSERT INTO `mx_balance` VALUES ('7001', 'sn703', '49230.00');
INSERT INTO `mx_balance` VALUES ('7002', 'sn703', '49180.00');
INSERT INTO `mx_balance` VALUES ('7003', 'sn701', '48460.00');
INSERT INTO `mx_balance` VALUES ('7004', 'sn703', '49175.00');
INSERT INTO `mx_balance` VALUES ('7005', 'sn701', '48420.00');
INSERT INTO `mx_balance` VALUES ('7006', 'sn701', '48360.00');
INSERT INTO `mx_balance` VALUES ('7007', 'sn703', '49275.00');
INSERT INTO `mx_balance` VALUES ('7008', 'sn702', '49160.00');
INSERT INTO `mx_balance` VALUES ('7009', 'sn701', '48270.00');
INSERT INTO `mx_balance` VALUES ('7010', 'sn703', '49270.00');
INSERT INTO `mx_balance` VALUES ('7011', 'sn701', '48240.00');
INSERT INTO `mx_balance` VALUES ('7012', 'sn703', '49220.00');
INSERT INTO `mx_balance` VALUES ('7013', 'sn703', '49170.00');
INSERT INTO `mx_balance` VALUES ('7014', 'sn701', '48210.00');
INSERT INTO `mx_balance` VALUES ('7015', 'sn703', '49165.00');
INSERT INTO `mx_balance` VALUES ('7016', 'sn701', '48120.00');
INSERT INTO `mx_balance` VALUES ('7017', 'sn701', '48030.00');
INSERT INTO `mx_balance` VALUES ('7018', 'sn703', '49265.00');
INSERT INTO `mx_balance` VALUES ('7019', 'sn701', '48130.00');
INSERT INTO `mx_balance` VALUES ('7020', 'sn703', '49215.00');
INSERT INTO `mx_balance` VALUES ('7021', 'sn703', '49165.00');
INSERT INTO `mx_balance` VALUES ('7022', 'sn701', '48040.00');
INSERT INTO `mx_balance` VALUES ('7023', 'sn703', '49160.00');
INSERT INTO `mx_balance` VALUES ('7024', 'sn703', '49260.00');
INSERT INTO `mx_balance` VALUES ('7025', 'sn702', '49110.00');
INSERT INTO `mx_balance` VALUES ('7026', 'sn702', '49100.00');
INSERT INTO `mx_balance` VALUES ('7027', 'sn701', '47950.00');
INSERT INTO `mx_balance` VALUES ('7028', 'expert132', '129015.00');
INSERT INTO `mx_balance` VALUES ('7029', 'sn702', '49070.00');
INSERT INTO `mx_balance` VALUES ('7030', 'sn701', '47860.00');
INSERT INTO `mx_balance` VALUES ('7031', 'sn702', '49040.00');
INSERT INTO `mx_balance` VALUES ('7032', 'sn702', '49000.00');
INSERT INTO `mx_balance` VALUES ('7033', 'sn701', '47770.00');
INSERT INTO `mx_balance` VALUES ('7034', 'sn701', '47740.00');
INSERT INTO `mx_balance` VALUES ('7035', 'sn701', '47710.00');
INSERT INTO `mx_balance` VALUES ('7036', 'sn701', '47660.00');
INSERT INTO `mx_balance` VALUES ('7037', 'sn701', '47610.00');
INSERT INTO `mx_balance` VALUES ('7038', 'sn701', '47590.00');
INSERT INTO `mx_balance` VALUES ('7039', 'sn701', '47550.00');
INSERT INTO `mx_balance` VALUES ('7040', 'sn702', '48990.00');
INSERT INTO `mx_balance` VALUES ('7041', 'sn701', '47500.00');
INSERT INTO `mx_balance` VALUES ('7042', 'sn701', '47490.00');
INSERT INTO `mx_balance` VALUES ('7043', 'sn703', '49210.00');
INSERT INTO `mx_balance` VALUES ('7044', 'sn703', '49160.00');
INSERT INTO `mx_balance` VALUES ('7045', 'sn701', '47430.00');
INSERT INTO `mx_balance` VALUES ('7046', 'sn703', '49260.00');
INSERT INTO `mx_balance` VALUES ('7047', 'sn703', '49210.00');
INSERT INTO `mx_balance` VALUES ('7048', 'sn703', '49160.00');
INSERT INTO `mx_balance` VALUES ('7049', 'sn701', '47380.00');
INSERT INTO `mx_balance` VALUES ('7050', 'sn703', '49120.00');
INSERT INTO `mx_balance` VALUES ('7051', 'sn703', '49090.00');
INSERT INTO `mx_balance` VALUES ('7052', 'sn703', '49060.00');
INSERT INTO `mx_balance` VALUES ('7053', 'sn703', '49020.00');
INSERT INTO `mx_balance` VALUES ('7054', 'sn703', '48990.00');
INSERT INTO `mx_balance` VALUES ('7055', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('7056', 'sn703', '49060.00');
INSERT INTO `mx_balance` VALUES ('7057', 'sn703', '49160.00');
INSERT INTO `mx_balance` VALUES ('7058', 'sn701', '47330.00');
INSERT INTO `mx_balance` VALUES ('7059', 'sn701', '47300.00');
INSERT INTO `mx_balance` VALUES ('7060', 'sn701', '47270.00');
INSERT INTO `mx_balance` VALUES ('7061', 'sn701', '47260.00');
INSERT INTO `mx_balance` VALUES ('7062', 'sn701', '47250.00');
INSERT INTO `mx_balance` VALUES ('7063', 'sn701', '47236.00');
INSERT INTO `mx_balance` VALUES ('7064', 'sn701', '47232.00');
INSERT INTO `mx_balance` VALUES ('7065', 'sn701', '47212.00');
INSERT INTO `mx_balance` VALUES ('7066', 'sn701', '47192.00');
INSERT INTO `mx_balance` VALUES ('7067', 'sn701', '47172.00');
INSERT INTO `mx_balance` VALUES ('7068', 'sn703', '49155.00');
INSERT INTO `mx_balance` VALUES ('7069', 'sn703', '49150.00');
INSERT INTO `mx_balance` VALUES ('7070', 'sn701', '47142.00');
INSERT INTO `mx_balance` VALUES ('7071', 'sn701', '47132.00');
INSERT INTO `mx_balance` VALUES ('7072', 'sn701', '47112.00');
INSERT INTO `mx_balance` VALUES ('7073', 'sn701', '47092.00');
INSERT INTO `mx_balance` VALUES ('7074', 'sn701', '47052.00');
INSERT INTO `mx_balance` VALUES ('7075', 'sn701', '47012.00');
INSERT INTO `mx_balance` VALUES ('7076', 'sn701', '46972.00');
INSERT INTO `mx_balance` VALUES ('7077', 'sn701', '46952.00');
INSERT INTO `mx_balance` VALUES ('7078', 'sn703', '49100.00');
INSERT INTO `mx_balance` VALUES ('7079', 'sn703', '49050.00');
INSERT INTO `mx_balance` VALUES ('7080', 'sn701', '46942.00');
INSERT INTO `mx_balance` VALUES ('7081', 'sn702', '48970.00');
INSERT INTO `mx_balance` VALUES ('7082', 'sn703', '49000.00');
INSERT INTO `mx_balance` VALUES ('7083', 'sn703', '48950.00');
INSERT INTO `mx_balance` VALUES ('7084', 'sn703', '49050.00');
INSERT INTO `mx_balance` VALUES ('7085', 'sn703', '49150.00');
INSERT INTO `mx_balance` VALUES ('7086', 'sn701', '46882.00');
INSERT INTO `mx_balance` VALUES ('7087', 'sn701', '46862.00');
INSERT INTO `mx_balance` VALUES ('7088', 'sn701', '46812.00');
INSERT INTO `mx_balance` VALUES ('7089', 'sn701', '46802.00');
INSERT INTO `mx_balance` VALUES ('7090', 'sn701', '46782.00');
INSERT INTO `mx_balance` VALUES ('7091', 'sn701', '46772.00');
INSERT INTO `mx_balance` VALUES ('7092', 'sn701', '46762.00');
INSERT INTO `mx_balance` VALUES ('7093', 'sn701', '46742.00');
INSERT INTO `mx_balance` VALUES ('7094', 'sn701', '46732.00');
INSERT INTO `mx_balance` VALUES ('7095', 'sn701', '46682.00');
INSERT INTO `mx_balance` VALUES ('7096', 'sn701', '46582.00');
INSERT INTO `mx_balance` VALUES ('7097', 'sn701', '46552.00');
INSERT INTO `mx_balance` VALUES ('7098', 'sn701', '46532.00');
INSERT INTO `mx_balance` VALUES ('7099', 'sn701', '46512.00');
INSERT INTO `mx_balance` VALUES ('7100', 'sn701', '46432.00');
INSERT INTO `mx_balance` VALUES ('7101', 'sn701', '46392.00');
INSERT INTO `mx_balance` VALUES ('7102', 'sn701', '46362.00');
INSERT INTO `mx_balance` VALUES ('7103', 'sn701', '46352.00');
INSERT INTO `mx_balance` VALUES ('7104', 'sn701', '46342.00');
INSERT INTO `mx_balance` VALUES ('7105', 'sn701', '46322.00');
INSERT INTO `mx_balance` VALUES ('7106', 'sn701', '46272.00');
INSERT INTO `mx_balance` VALUES ('7107', 'sn701', '46262.00');
INSERT INTO `mx_balance` VALUES ('7108', 'sn701', '46252.00');
INSERT INTO `mx_balance` VALUES ('7109', 'sn701', '46242.00');
INSERT INTO `mx_balance` VALUES ('7110', 'sn701', '46212.00');
INSERT INTO `mx_balance` VALUES ('7111', 'sn701', '46202.00');
INSERT INTO `mx_balance` VALUES ('7112', 'sn701', '46182.00');
INSERT INTO `mx_balance` VALUES ('7113', 'sn701', '46162.00');
INSERT INTO `mx_balance` VALUES ('7114', 'sn703', '49100.00');
INSERT INTO `mx_balance` VALUES ('7115', 'sn703', '49050.00');
INSERT INTO `mx_balance` VALUES ('7116', 'sn701', '46142.00');
INSERT INTO `mx_balance` VALUES ('7117', 'sn701', '46132.00');
INSERT INTO `mx_balance` VALUES ('7118', 'sn701', '46102.00');
INSERT INTO `mx_balance` VALUES ('7119', 'sn701', '46092.00');
INSERT INTO `mx_balance` VALUES ('7120', 'sn703', '49150.00');
INSERT INTO `mx_balance` VALUES ('7121', 'sn701', '46072.00');
INSERT INTO `mx_balance` VALUES ('7122', 'sn703', '49100.00');
INSERT INTO `mx_balance` VALUES ('7123', 'sn701', '46042.00');
INSERT INTO `mx_balance` VALUES ('7124', 'sn703', '49050.00');
INSERT INTO `mx_balance` VALUES ('7125', 'sn701', '46032.00');
INSERT INTO `mx_balance` VALUES ('7126', 'sn701', '46022.00');
INSERT INTO `mx_balance` VALUES ('7127', 'sn701', '46002.00');
INSERT INTO `mx_balance` VALUES ('7128', 'sn701', '46102.00');
INSERT INTO `mx_balance` VALUES ('7129', 'sn701', '46202.00');
INSERT INTO `mx_balance` VALUES ('7130', 'sn701', '46172.00');
INSERT INTO `mx_balance` VALUES ('7131', 'sn701', '46152.00');
INSERT INTO `mx_balance` VALUES ('7132', 'sn701', '46142.00');
INSERT INTO `mx_balance` VALUES ('7133', 'sn703', '49020.00');
INSERT INTO `mx_balance` VALUES ('7134', 'sn701', '46092.00');
INSERT INTO `mx_balance` VALUES ('7135', 'sn701', '46042.00');
INSERT INTO `mx_balance` VALUES ('7136', 'sn701', '46032.00');
INSERT INTO `mx_balance` VALUES ('7137', 'sn703', '48970.00');
INSERT INTO `mx_balance` VALUES ('7138', 'sn703', '48920.00');
INSERT INTO `mx_balance` VALUES ('7139', 'sn701', '46002.00');
INSERT INTO `mx_balance` VALUES ('7140', 'sn701', '45992.00');
INSERT INTO `mx_balance` VALUES ('7141', 'sn703', '48910.00');
INSERT INTO `mx_balance` VALUES ('7142', 'sn701', '45972.00');
INSERT INTO `mx_balance` VALUES ('7143', 'sn701', '45952.00');
INSERT INTO `mx_balance` VALUES ('7144', 'sn701', '45942.00');
INSERT INTO `mx_balance` VALUES ('7145', 'sn703', '48870.00');
INSERT INTO `mx_balance` VALUES ('7146', 'sn703', '48820.00');
INSERT INTO `mx_balance` VALUES ('7147', 'sn703', '48920.00');
INSERT INTO `mx_balance` VALUES ('7148', 'sn703', '49020.00');
INSERT INTO `mx_balance` VALUES ('7149', 'sn703', '48970.00');
INSERT INTO `mx_balance` VALUES ('7150', 'sn703', '48920.00');
INSERT INTO `mx_balance` VALUES ('7151', 'sn703', '49020.00');
INSERT INTO `mx_balance` VALUES ('7152', 'sn701', '45922.00');
INSERT INTO `mx_balance` VALUES ('7153', 'sn703', '48970.00');
INSERT INTO `mx_balance` VALUES ('7154', 'sn703', '48920.00');
INSERT INTO `mx_balance` VALUES ('7155', 'sn701', '45892.00');
INSERT INTO `mx_balance` VALUES ('7156', 'sn701', '45882.00');
INSERT INTO `mx_balance` VALUES ('7157', 'sn701', '45772.00');
INSERT INTO `mx_balance` VALUES ('7158', 'sn701', '45692.00');
INSERT INTO `mx_balance` VALUES ('7159', 'sn701', '45672.00');
INSERT INTO `mx_balance` VALUES ('7160', 'sn701', '45662.00');
INSERT INTO `mx_balance` VALUES ('7161', 'sn701', '45562.00');
INSERT INTO `mx_balance` VALUES ('7162', 'sn702', '48960.00');
INSERT INTO `mx_balance` VALUES ('7163', 'sn701', '45462.00');
INSERT INTO `mx_balance` VALUES ('7164', 'sn702', '48940.00');
INSERT INTO `mx_balance` VALUES ('7165', 'sn701', '45262.00');
INSERT INTO `mx_balance` VALUES ('7166', 'sn701', '45252.00');
INSERT INTO `mx_balance` VALUES ('7167', 'sn701', '45192.00');
INSERT INTO `mx_balance` VALUES ('7168', 'sn701', '45182.00');
INSERT INTO `mx_balance` VALUES ('7169', 'sn701', '45172.00');
INSERT INTO `mx_balance` VALUES ('7170', 'sn701', '45132.00');
INSERT INTO `mx_balance` VALUES ('7171', 'sn703', '48870.00');
INSERT INTO `mx_balance` VALUES ('7172', 'sn703', '48820.00');
INSERT INTO `mx_balance` VALUES ('7173', 'sn701', '45122.00');
INSERT INTO `mx_balance` VALUES ('7174', 'sn701', '45112.00');
INSERT INTO `mx_balance` VALUES ('7175', 'sn701', '45092.00');
INSERT INTO `mx_balance` VALUES ('7176', 'sn701', '44992.00');
INSERT INTO `mx_balance` VALUES ('7177', 'sn703', '48920.00');
INSERT INTO `mx_balance` VALUES ('7178', 'sn703', '49020.00');
INSERT INTO `mx_balance` VALUES ('7179', 'sn701', '44962.00');
INSERT INTO `mx_balance` VALUES ('7180', 'sn701', '44942.00');
INSERT INTO `mx_balance` VALUES ('7181', 'sn701', '44922.00');
INSERT INTO `mx_balance` VALUES ('7182', 'sn702', '48840.00');
INSERT INTO `mx_balance` VALUES ('7183', 'sn701', '44902.00');
INSERT INTO `mx_balance` VALUES ('7184', 'sn701', '44882.00');
INSERT INTO `mx_balance` VALUES ('7185', 'sn701', '44862.00');
INSERT INTO `mx_balance` VALUES ('7186', 'sn701', '44852.00');
INSERT INTO `mx_balance` VALUES ('7187', 'sn701', '44812.00');
INSERT INTO `mx_balance` VALUES ('7188', 'sn701', '44772.00');
INSERT INTO `mx_balance` VALUES ('7189', 'sn701', '44752.00');
INSERT INTO `mx_balance` VALUES ('7190', 'sn701', '44702.00');
INSERT INTO `mx_balance` VALUES ('7191', 'sn701', '44682.00');
INSERT INTO `mx_balance` VALUES ('7192', 'sn701', '44672.00');
INSERT INTO `mx_balance` VALUES ('7193', 'sn701', '44667.00');
INSERT INTO `mx_balance` VALUES ('7194', 'expert132', '128915.00');
INSERT INTO `mx_balance` VALUES ('7195', 'expert132', '129215.00');
INSERT INTO `mx_balance` VALUES ('7196', 'expert132', '129115.00');
INSERT INTO `mx_balance` VALUES ('7197', 'expert132', '129415.00');
INSERT INTO `mx_balance` VALUES ('7198', 'sn703', '49010.00');
INSERT INTO `mx_balance` VALUES ('7199', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('7200', 'sn703', '48910.00');
INSERT INTO `mx_balance` VALUES ('7201', 'sn703', '49010.00');
INSERT INTO `mx_balance` VALUES ('7202', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('7203', 'sn703', '48910.00');
INSERT INTO `mx_balance` VALUES ('7204', 'sn703', '49010.00');
INSERT INTO `mx_balance` VALUES ('7205', 'sn701', '44637.00');
INSERT INTO `mx_balance` VALUES ('7206', 'sn701', '44577.00');
INSERT INTO `mx_balance` VALUES ('7207', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('7208', 'sn703', '48910.00');
INSERT INTO `mx_balance` VALUES ('7209', 'sn703', '49010.00');
INSERT INTO `mx_balance` VALUES ('7210', 'sn701', '44537.00');
INSERT INTO `mx_balance` VALUES ('7211', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('7212', 'sn703', '48910.00');
INSERT INTO `mx_balance` VALUES ('7213', 'sn703', '49010.00');
INSERT INTO `mx_balance` VALUES ('7214', 'sn701', '44517.00');
INSERT INTO `mx_balance` VALUES ('7215', 'sn701', '44457.00');
INSERT INTO `mx_balance` VALUES ('7216', 'sn701', '44447.00');
INSERT INTO `mx_balance` VALUES ('7217', 'sn701', '44417.00');
INSERT INTO `mx_balance` VALUES ('7218', 'sn701', '44347.00');
INSERT INTO `mx_balance` VALUES ('7219', 'sn701', '44307.00');
INSERT INTO `mx_balance` VALUES ('7220', 'sn701', '44207.00');
INSERT INTO `mx_balance` VALUES ('7221', 'sn701', '44107.00');
INSERT INTO `mx_balance` VALUES ('7222', 'sn701', '43957.00');
INSERT INTO `mx_balance` VALUES ('7223', 'sn701', '43757.00');
INSERT INTO `mx_balance` VALUES ('7224', 'sn701', '43717.00');
INSERT INTO `mx_balance` VALUES ('7225', 'sn703', '48960.00');
INSERT INTO `mx_balance` VALUES ('7226', 'sn703', '48910.00');
INSERT INTO `mx_balance` VALUES ('7227', 'sn701', '43657.00');
INSERT INTO `mx_balance` VALUES ('7228', 'sn701', '43617.00');
INSERT INTO `mx_balance` VALUES ('7229', 'sn701', '43417.00');
INSERT INTO `mx_balance` VALUES ('7230', 'sn703', '49010.00');
INSERT INTO `mx_balance` VALUES ('7231', 'sn703', '48985.00');
INSERT INTO `mx_balance` VALUES ('7232', 'sn703', '48915.00');
INSERT INTO `mx_balance` VALUES ('7233', 'sn703', '48865.00');
INSERT INTO `mx_balance` VALUES ('7234', 'sn703', '48815.00');
INSERT INTO `mx_balance` VALUES ('7235', 'sn703', '48915.00');
INSERT INTO `mx_balance` VALUES ('7236', 'sn701', '43317.00');
INSERT INTO `mx_balance` VALUES ('7237', 'expert132', '129405.00');
INSERT INTO `mx_balance` VALUES ('7238', 'expert132', '128905.00');
INSERT INTO `mx_balance` VALUES ('7239', 'expert132', '128405.00');
INSERT INTO `mx_balance` VALUES ('7240', 'expert132', '123405.00');
INSERT INTO `mx_balance` VALUES ('7241', 'expert132', '143405.00');
INSERT INTO `mx_balance` VALUES ('7242', 'expert132', '145405.00');
INSERT INTO `mx_balance` VALUES ('7243', 'expert132', '147405.00');
INSERT INTO `mx_balance` VALUES ('7244', 'expert132', '147445.00');
INSERT INTO `mx_balance` VALUES ('7245', 'expert132', '147395.00');
INSERT INTO `mx_balance` VALUES ('7246', 'expert132', '147345.00');
INSERT INTO `mx_balance` VALUES ('7247', 'expert132', '147295.00');
INSERT INTO `mx_balance` VALUES ('7248', 'expert132', '147245.00');
INSERT INTO `mx_balance` VALUES ('7249', 'expert132', '147195.00');
INSERT INTO `mx_balance` VALUES ('7250', 'expert132', '147145.00');
INSERT INTO `mx_balance` VALUES ('7251', 'expert132', '147095.00');
INSERT INTO `mx_balance` VALUES ('7252', 'expert132', '147045.00');
INSERT INTO `mx_balance` VALUES ('7253', 'expert132', '146995.00');
INSERT INTO `mx_balance` VALUES ('7254', 'sn704', '42760.00');
INSERT INTO `mx_balance` VALUES ('7255', 'expert132', '146895.00');
INSERT INTO `mx_balance` VALUES ('7256', 'sn704', '37760.00');
INSERT INTO `mx_balance` VALUES ('7257', 'expert132', '147095.00');
INSERT INTO `mx_balance` VALUES ('7258', 'sn704', '47760.00');
INSERT INTO `mx_balance` VALUES ('7259', 'sn704', '48760.00');
INSERT INTO `mx_balance` VALUES ('7260', 'expert132', '146995.00');
INSERT INTO `mx_balance` VALUES ('7261', 'expert132', '147295.00');
INSERT INTO `mx_balance` VALUES ('7262', 'expert132', '147290.00');
INSERT INTO `mx_balance` VALUES ('7263', 'expert132', '147275.00');
INSERT INTO `mx_balance` VALUES ('7264', 'expert132', '147270.00');
INSERT INTO `mx_balance` VALUES ('7265', 'expert132', '147265.00');
INSERT INTO `mx_balance` VALUES ('7266', 'expert132', '147260.00');
INSERT INTO `mx_balance` VALUES ('7267', 'sn701', '43297.00');
INSERT INTO `mx_balance` VALUES ('7268', 'sn701', '43257.00');
INSERT INTO `mx_balance` VALUES ('7269', 'expert132', '147210.00');
INSERT INTO `mx_balance` VALUES ('7270', 'expert132', '147160.00');
INSERT INTO `mx_balance` VALUES ('7271', 'expert132', '147110.00');
INSERT INTO `mx_balance` VALUES ('7272', 'expert132', '147060.00');
INSERT INTO `mx_balance` VALUES ('7273', 'expert132', '147010.00');
INSERT INTO `mx_balance` VALUES ('7274', 'sn701', '43207.00');
INSERT INTO `mx_balance` VALUES ('7275', 'sn701', '43187.00');
INSERT INTO `mx_balance` VALUES ('7276', 'sn701', '43167.00');
INSERT INTO `mx_balance` VALUES ('7277', 'sn701', '43127.00');
INSERT INTO `mx_balance` VALUES ('7278', 'sn701', '43047.00');
INSERT INTO `mx_balance` VALUES ('7279', 'sn701', '42947.00');
INSERT INTO `mx_balance` VALUES ('7280', 'expert132', '146760.00');
INSERT INTO `mx_balance` VALUES ('7281', 'expert132', '146510.00');
INSERT INTO `mx_balance` VALUES ('7282', 'sn701', '42937.00');
INSERT INTO `mx_balance` VALUES ('7283', 'expert132', '146460.00');
INSERT INTO `mx_balance` VALUES ('7284', 'sn704', '48660.00');
INSERT INTO `mx_balance` VALUES ('7285', 'sn704', '47660.00');
INSERT INTO `mx_balance` VALUES ('7286', 'sn704', '47600.00');
INSERT INTO `mx_balance` VALUES ('7287', 'sn704', '47000.00');
INSERT INTO `mx_balance` VALUES ('7288', 'sn704', '44640.00');
INSERT INTO `mx_balance` VALUES ('7289', 'sn704', '44600.00');
INSERT INTO `mx_balance` VALUES ('7290', 'sn704', '45000.00');
INSERT INTO `mx_balance` VALUES ('7291', 'expert132', '146210.00');
INSERT INTO `mx_balance` VALUES ('7292', 'sn704', '45100.00');
INSERT INTO `mx_balance` VALUES ('7293', 'sn704', '45200.00');
INSERT INTO `mx_balance` VALUES ('7294', 'sn704', '46200.00');
INSERT INTO `mx_balance` VALUES ('7295', 'expert132', '145960.00');
INSERT INTO `mx_balance` VALUES ('7296', 'sn701', '42932.00');
INSERT INTO `mx_balance` VALUES ('7297', 'sn701', '42927.00');
INSERT INTO `mx_balance` VALUES ('7298', 'sn701', '42922.00');
INSERT INTO `mx_balance` VALUES ('7299', 'sn701', '42917.00');
INSERT INTO `mx_balance` VALUES ('7300', 'sn701', '42912.00');
INSERT INTO `mx_balance` VALUES ('7301', 'sn701', '42907.00');
INSERT INTO `mx_balance` VALUES ('7302', 'expert132', '145910.00');
INSERT INTO `mx_balance` VALUES ('7303', 'expert132', '145860.00');
INSERT INTO `mx_balance` VALUES ('7304', 'expert132', '145810.00');
INSERT INTO `mx_balance` VALUES ('7305', 'expert132', '145760.00');
INSERT INTO `mx_balance` VALUES ('7306', 'expert132', '145860.00');
INSERT INTO `mx_balance` VALUES ('7307', 'expert132', '145960.00');
INSERT INTO `mx_balance` VALUES ('7308', 'expert132', '145860.00');
INSERT INTO `mx_balance` VALUES ('7309', 'expert132', '145760.00');
INSERT INTO `mx_balance` VALUES ('7310', 'expert132', '145660.00');
INSERT INTO `mx_balance` VALUES ('7311', 'expert132', '145560.00');
INSERT INTO `mx_balance` VALUES ('7312', 'expert132', '145460.00');
INSERT INTO `mx_balance` VALUES ('7313', 'expert132', '145360.00');
INSERT INTO `mx_balance` VALUES ('7314', 'expert132', '145460.00');
INSERT INTO `mx_balance` VALUES ('7315', 'expert132', '145560.00');
INSERT INTO `mx_balance` VALUES ('7316', 'expert132', '145660.00');
INSERT INTO `mx_balance` VALUES ('7317', 'expert132', '145760.00');
INSERT INTO `mx_balance` VALUES ('7318', 'expert132', '145860.00');
INSERT INTO `mx_balance` VALUES ('7319', 'expert132', '145960.00');
INSERT INTO `mx_balance` VALUES ('7320', 'expert132', '145910.00');
INSERT INTO `mx_balance` VALUES ('7321', 'sn701', '42902.00');
INSERT INTO `mx_balance` VALUES ('7322', 'sn701', '42897.00');
INSERT INTO `mx_balance` VALUES ('7323', 'expert132', '145810.00');
INSERT INTO `mx_balance` VALUES ('7324', 'expert132', '145710.00');
INSERT INTO `mx_balance` VALUES ('7325', 'expert132', '145610.00');
INSERT INTO `mx_balance` VALUES ('7326', 'expert132', '145510.00');
INSERT INTO `mx_balance` VALUES ('7327', 'expert132', '145610.00');
INSERT INTO `mx_balance` VALUES ('7328', 'expert132', '145710.00');
INSERT INTO `mx_balance` VALUES ('7329', 'expert132', '145810.00');
INSERT INTO `mx_balance` VALUES ('7330', 'expert132', '145910.00');
INSERT INTO `mx_balance` VALUES ('7331', 'expert132', '145810.00');
INSERT INTO `mx_balance` VALUES ('7332', 'expert132', '145710.00');
INSERT INTO `mx_balance` VALUES ('7333', 'expert132', '145610.00');
INSERT INTO `mx_balance` VALUES ('7334', 'expert132', '145510.00');
INSERT INTO `mx_balance` VALUES ('7335', 'expert132', '145710.00');
INSERT INTO `mx_balance` VALUES ('7336', 'expert132', '145910.00');
INSERT INTO `mx_balance` VALUES ('7337', 'expert132', '146110.00');
INSERT INTO `mx_balance` VALUES ('7338', 'expert132', '146310.00');
INSERT INTO `mx_balance` VALUES ('7339', 'sn704', '46100.00');
INSERT INTO `mx_balance` VALUES ('7340', 'sn704', '45650.00');
INSERT INTO `mx_balance` VALUES ('7341', 'sn704', '41150.00');
INSERT INTO `mx_balance` VALUES ('7342', 'sn704', '32150.00');
INSERT INTO `mx_balance` VALUES ('7343', 'sn704', '23150.00');
INSERT INTO `mx_balance` VALUES ('7344', 'sn704', '22700.00');
INSERT INTO `mx_balance` VALUES ('7345', 'sn704', '13700.00');
INSERT INTO `mx_balance` VALUES ('7346', 'sn704', '13250.00');
INSERT INTO `mx_balance` VALUES ('7347', 'sn704', '8750.00');
INSERT INTO `mx_balance` VALUES ('7348', 'sn704', '13750.00');
INSERT INTO `mx_balance` VALUES ('7349', 'sn704', '14250.00');
INSERT INTO `mx_balance` VALUES ('7350', 'sn704', '14750.00');
INSERT INTO `mx_balance` VALUES ('7351', 'sn704', '15250.00');
INSERT INTO `mx_balance` VALUES ('7352', 'sn704', '15350.00');
INSERT INTO `mx_balance` VALUES ('7353', 'sn701', '42847.00');
INSERT INTO `mx_balance` VALUES ('7354', 'expert132', '146260.00');
INSERT INTO `mx_balance` VALUES ('7355', 'expert132', '146010.00');
INSERT INTO `mx_balance` VALUES ('7356', 'expert132', '146260.00');
INSERT INTO `mx_balance` VALUES ('7357', 'expert132', '146010.00');
INSERT INTO `mx_balance` VALUES ('7358', 'expert132', '146260.00');
INSERT INTO `mx_balance` VALUES ('7359', 'expert132', '146010.00');
INSERT INTO `mx_balance` VALUES ('7360', 'sn701', '42837.00');
INSERT INTO `mx_balance` VALUES ('7361', 'sn701', '42827.00');
INSERT INTO `mx_balance` VALUES ('7362', 'sn701', '42807.00');
INSERT INTO `mx_balance` VALUES ('7363', 'sn701', '42797.00');
INSERT INTO `mx_balance` VALUES ('7364', 'sn701', '42777.00');
INSERT INTO `mx_balance` VALUES ('7365', 'sn701', '42757.00');
INSERT INTO `mx_balance` VALUES ('7366', 'expert132', '145920.00');
INSERT INTO `mx_balance` VALUES ('7367', 'expert132', '145830.00');
INSERT INTO `mx_balance` VALUES ('7368', 'expert132', '145740.00');
INSERT INTO `mx_balance` VALUES ('7369', 'expert132', '145650.00');
INSERT INTO `mx_balance` VALUES ('7370', 'expert132', '145560.00');
INSERT INTO `mx_balance` VALUES ('7371', 'expert132', '145470.00');
INSERT INTO `mx_balance` VALUES ('7372', 'expert132', '145380.00');
INSERT INTO `mx_balance` VALUES ('7373', 'expert132', '145290.00');
INSERT INTO `mx_balance` VALUES ('7374', 'expert132', '145200.00');
INSERT INTO `mx_balance` VALUES ('7375', 'expert132', '145110.00');
INSERT INTO `mx_balance` VALUES ('7376', 'sn701', '42747.00');
INSERT INTO `mx_balance` VALUES ('7377', 'sn701', '42737.00');
INSERT INTO `mx_balance` VALUES ('7378', 'sn701', '42727.00');
INSERT INTO `mx_balance` VALUES ('7379', 'sn701', '42717.00');
INSERT INTO `mx_balance` VALUES ('7380', 'sn701', '42707.00');
INSERT INTO `mx_balance` VALUES ('7381', 'sn701', '42697.00');
INSERT INTO `mx_balance` VALUES ('7382', 'sn701', '42687.00');
INSERT INTO `mx_balance` VALUES ('7383', 'sn703', '48905.00');
INSERT INTO `mx_balance` VALUES ('7384', 'sn703', '48900.00');
INSERT INTO `mx_balance` VALUES ('7385', 'sn701', '42647.00');
INSERT INTO `mx_balance` VALUES ('7386', 'sn701', '42637.00');
INSERT INTO `mx_balance` VALUES ('7387', 'sn703', '48850.00');
INSERT INTO `mx_balance` VALUES ('7388', 'sn703', '48800.00');
INSERT INTO `mx_balance` VALUES ('7389', 'sn701', '42607.00');
INSERT INTO `mx_balance` VALUES ('7390', 'sn701', '42597.00');
INSERT INTO `mx_balance` VALUES ('7391', 'sn701', '42577.00');
INSERT INTO `mx_balance` VALUES ('7392', 'sn703', '48900.00');
INSERT INTO `mx_balance` VALUES ('7393', 'sn701', '42547.00');
INSERT INTO `mx_balance` VALUES ('7394', 'sn701', '42537.00');
INSERT INTO `mx_balance` VALUES ('7395', 'sn701', '42527.00');
INSERT INTO `mx_balance` VALUES ('7396', 'sn701', '42517.00');
INSERT INTO `mx_balance` VALUES ('7397', 'sn701', '42487.00');
INSERT INTO `mx_balance` VALUES ('7398', 'sn701', '42477.00');
INSERT INTO `mx_balance` VALUES ('7399', 'sn701', '42457.00');
INSERT INTO `mx_balance` VALUES ('7400', 'sn701', '42437.00');
INSERT INTO `mx_balance` VALUES ('7401', 'sn701', '42427.00');
INSERT INTO `mx_balance` VALUES ('7402', 'sn701', '42417.00');
INSERT INTO `mx_balance` VALUES ('7403', 'sn701', '42397.00');
INSERT INTO `mx_balance` VALUES ('7404', 'sn703', '48850.00');
INSERT INTO `mx_balance` VALUES ('7405', 'sn703', '48800.00');
INSERT INTO `mx_balance` VALUES ('7406', 'sn701', '42367.00');
INSERT INTO `mx_balance` VALUES ('7407', 'sn701', '42317.00');
INSERT INTO `mx_balance` VALUES ('7408', 'sn703', '48900.00');
INSERT INTO `mx_balance` VALUES ('7409', 'sn701', '42267.00');
INSERT INTO `mx_balance` VALUES ('7410', 'sn703', '48850.00');
INSERT INTO `mx_balance` VALUES ('7411', 'sn703', '48800.00');
INSERT INTO `mx_balance` VALUES ('7412', 'sn703', '48900.00');
INSERT INTO `mx_balance` VALUES ('7413', 'sn701', '42237.00');
INSERT INTO `mx_balance` VALUES ('7414', 'sn701', '42217.00');
INSERT INTO `mx_balance` VALUES ('7415', 'sn701', '42197.00');
INSERT INTO `mx_balance` VALUES ('7416', 'sn701', '42167.00');
INSERT INTO `mx_balance` VALUES ('7417', 'sn703', '48850.00');
INSERT INTO `mx_balance` VALUES ('7418', 'sn703', '48800.00');
INSERT INTO `mx_balance` VALUES ('7419', 'sn701', '42147.00');
INSERT INTO `mx_balance` VALUES ('7420', 'expert132', '145085.00');
INSERT INTO `mx_balance` VALUES ('7421', 'sn701', '42127.00');
INSERT INTO `mx_balance` VALUES ('7422', 'sn701', '42097.00');
INSERT INTO `mx_balance` VALUES ('7423', 'sn701', '42067.00');
INSERT INTO `mx_balance` VALUES ('7424', 'sn701', '42037.00');
INSERT INTO `mx_balance` VALUES ('7425', 'sn701', '42027.00');
INSERT INTO `mx_balance` VALUES ('7426', 'sn701', '42007.00');
INSERT INTO `mx_balance` VALUES ('7427', 'sn701', '41987.00');
INSERT INTO `mx_balance` VALUES ('7428', 'sn701', '41957.00');
INSERT INTO `mx_balance` VALUES ('7429', 'sn703', '48900.00');
INSERT INTO `mx_balance` VALUES ('7430', 'sn701', '41937.00');
INSERT INTO `mx_balance` VALUES ('7431', 'sn701', '41927.00');
INSERT INTO `mx_balance` VALUES ('7432', 'sn701', '41897.00');
INSERT INTO `mx_balance` VALUES ('7433', 'sn703', '48850.00');
INSERT INTO `mx_balance` VALUES ('7434', 'sn703', '48800.00');
INSERT INTO `mx_balance` VALUES ('7435', 'sn703', '48900.00');
INSERT INTO `mx_balance` VALUES ('7436', 'sn701', '41837.00');
INSERT INTO `mx_balance` VALUES ('7437', 'sn701', '41827.00');
INSERT INTO `mx_balance` VALUES ('7438', 'sn701', '41787.00');
INSERT INTO `mx_balance` VALUES ('7439', 'sn701', '41777.00');
INSERT INTO `mx_balance` VALUES ('7440', 'sn701', '41737.00');
INSERT INTO `mx_balance` VALUES ('7441', 'sn701', '41707.00');
INSERT INTO `mx_balance` VALUES ('7442', 'sn701', '41687.00');
INSERT INTO `mx_balance` VALUES ('7443', 'sn701', '41647.00');
INSERT INTO `mx_balance` VALUES ('7444', 'sn701', '41617.00');
INSERT INTO `mx_balance` VALUES ('7445', 'sn701', '41597.00');
INSERT INTO `mx_balance` VALUES ('7446', 'sn703', '48870.00');
INSERT INTO `mx_balance` VALUES ('7447', 'sn703', '48840.00');
INSERT INTO `mx_balance` VALUES ('7448', 'sn701', '41567.00');
INSERT INTO `mx_balance` VALUES ('7449', 'sn703', '48820.00');
INSERT INTO `mx_balance` VALUES ('7450', 'sn703', '48800.00');
INSERT INTO `mx_balance` VALUES ('7451', 'sn703', '48790.00');
INSERT INTO `mx_balance` VALUES ('7452', 'sn701', '41527.00');
INSERT INTO `mx_balance` VALUES ('7453', 'sn703', '48890.00');
INSERT INTO `mx_balance` VALUES ('7454', 'sn703', '48880.00');
INSERT INTO `mx_balance` VALUES ('7455', 'sn703', '48870.00');
INSERT INTO `mx_balance` VALUES ('7456', 'sn701', '41497.00');
INSERT INTO `mx_balance` VALUES ('7457', 'sn701', '41477.00');
INSERT INTO `mx_balance` VALUES ('7458', 'sn701', '41457.00');
INSERT INTO `mx_balance` VALUES ('7459', 'sn701', '41447.00');
INSERT INTO `mx_balance` VALUES ('7460', 'sn701', '41427.00');
INSERT INTO `mx_balance` VALUES ('7461', 'sn703', '48860.00');
INSERT INTO `mx_balance` VALUES ('7462', 'sn701', '41397.00');
INSERT INTO `mx_balance` VALUES ('7463', 'sn701', '41367.00');
INSERT INTO `mx_balance` VALUES ('7464', 'sn703', '48850.00');
INSERT INTO `mx_balance` VALUES ('7465', 'sn701', '41327.00');
INSERT INTO `mx_balance` VALUES ('7466', 'sn701', '41297.00');
INSERT INTO `mx_balance` VALUES ('7467', 'sn701', '41257.00');
INSERT INTO `mx_balance` VALUES ('7468', 'sn701', '41247.00');
INSERT INTO `mx_balance` VALUES ('7469', 'sn701', '41217.00');
INSERT INTO `mx_balance` VALUES ('7470', 'sn701', '41157.00');
INSERT INTO `mx_balance` VALUES ('7471', 'sn701', '41147.00');
INSERT INTO `mx_balance` VALUES ('7472', 'sn701', '41137.00');
INSERT INTO `mx_balance` VALUES ('7473', 'sn701', '41097.00');
INSERT INTO `mx_balance` VALUES ('7474', 'sn701', '41077.00');
INSERT INTO `mx_balance` VALUES ('7475', 'sn701', '41067.00');
INSERT INTO `mx_balance` VALUES ('7476', 'sn701', '41057.00');
INSERT INTO `mx_balance` VALUES ('7477', 'sn701', '41027.00');
INSERT INTO `mx_balance` VALUES ('7478', 'sn703', '48820.00');
INSERT INTO `mx_balance` VALUES ('7479', 'sn701', '41017.00');
INSERT INTO `mx_balance` VALUES ('7480', 'sn701', '41007.00');
INSERT INTO `mx_balance` VALUES ('7481', 'sn701', '40997.00');
INSERT INTO `mx_balance` VALUES ('7482', 'sn701', '40937.00');
INSERT INTO `mx_balance` VALUES ('7483', 'sn703', '48780.00');
INSERT INTO `mx_balance` VALUES ('7484', 'sn703', '48760.00');
INSERT INTO `mx_balance` VALUES ('7485', 'sn701', '40907.00');
INSERT INTO `mx_balance` VALUES ('7486', 'sn703', '48710.00');
INSERT INTO `mx_balance` VALUES ('7487', 'sn701', '40877.00');
INSERT INTO `mx_balance` VALUES ('7488', 'sn703', '48660.00');
INSERT INTO `mx_balance` VALUES ('7489', 'sn703', '48650.00');
INSERT INTO `mx_balance` VALUES ('7490', 'sn703', '48750.00');
INSERT INTO `mx_balance` VALUES ('7491', 'sn703', '48730.00');
INSERT INTO `mx_balance` VALUES ('7492', 'sn701', '40867.00');
INSERT INTO `mx_balance` VALUES ('7493', 'sn703', '48720.00');
INSERT INTO `mx_balance` VALUES ('7494', 'sn703', '48710.00');
INSERT INTO `mx_balance` VALUES ('7495', 'sn703', '48700.00');
INSERT INTO `mx_balance` VALUES ('7496', 'sn701', '40837.00');
INSERT INTO `mx_balance` VALUES ('7497', 'sn701', '40827.00');
INSERT INTO `mx_balance` VALUES ('7498', 'sn701', '40797.00');
INSERT INTO `mx_balance` VALUES ('7499', 'sn701', '40767.00');
INSERT INTO `mx_balance` VALUES ('7500', 'sn703', '48680.00');
INSERT INTO `mx_balance` VALUES ('7501', 'sn701', '40757.00');
INSERT INTO `mx_balance` VALUES ('7502', 'sn701', '40727.00');
INSERT INTO `mx_balance` VALUES ('7503', 'sn701', '40707.00');
INSERT INTO `mx_balance` VALUES ('7504', 'sn701', '40697.00');
INSERT INTO `mx_balance` VALUES ('7505', 'sn703', '48660.00');
INSERT INTO `mx_balance` VALUES ('7506', 'sn701', '40657.00');
INSERT INTO `mx_balance` VALUES ('7507', 'sn701', '40647.00');
INSERT INTO `mx_balance` VALUES ('7508', 'sn701', '40607.00');
INSERT INTO `mx_balance` VALUES ('7509', 'sn701', '40587.00');
INSERT INTO `mx_balance` VALUES ('7510', 'sn701', '40557.00');
INSERT INTO `mx_balance` VALUES ('7511', 'sn701', '40547.00');
INSERT INTO `mx_balance` VALUES ('7512', 'sn701', '40537.00');
INSERT INTO `mx_balance` VALUES ('7513', 'sn703', '48620.00');
INSERT INTO `mx_balance` VALUES ('7514', 'sn703', '48600.00');
INSERT INTO `mx_balance` VALUES ('7515', 'sn703', '48580.00');
INSERT INTO `mx_balance` VALUES ('7516', 'sn701', '40527.00');
INSERT INTO `mx_balance` VALUES ('7517', 'sn701', '40507.00');
INSERT INTO `mx_balance` VALUES ('7518', 'sn701', '40487.00');
INSERT INTO `mx_balance` VALUES ('7519', 'sn701', '40467.00');
INSERT INTO `mx_balance` VALUES ('7520', 'sn701', '40447.00');
INSERT INTO `mx_balance` VALUES ('7521', 'sn701', '40427.00');
INSERT INTO `mx_balance` VALUES ('7522', 'sn701', '40417.00');
INSERT INTO `mx_balance` VALUES ('7523', 'sn701', '40407.00');
INSERT INTO `mx_balance` VALUES ('7524', 'sn701', '40397.00');
INSERT INTO `mx_balance` VALUES ('7525', 'sn701', '40387.00');
INSERT INTO `mx_balance` VALUES ('7526', 'sn701', '40367.00');
INSERT INTO `mx_balance` VALUES ('7527', 'sn701', '40357.00');
INSERT INTO `mx_balance` VALUES ('7528', 'sn701', '40337.00');
INSERT INTO `mx_balance` VALUES ('7529', 'sn701', '40317.00');
INSERT INTO `mx_balance` VALUES ('7530', 'sn701', '40297.00');
INSERT INTO `mx_balance` VALUES ('7531', 'sn701', '40277.00');
INSERT INTO `mx_balance` VALUES ('7532', 'sn701', '40237.00');
INSERT INTO `mx_balance` VALUES ('7533', 'sn701', '40207.00');
INSERT INTO `mx_balance` VALUES ('7534', 'sn701', '40177.00');
INSERT INTO `mx_balance` VALUES ('7535', 'sn703', '48560.00');
INSERT INTO `mx_balance` VALUES ('7536', 'sn703', '48510.00');
INSERT INTO `mx_balance` VALUES ('7537', 'sn703', '48490.00');
INSERT INTO `mx_balance` VALUES ('7538', 'sn701', '40167.00');
INSERT INTO `mx_balance` VALUES ('7539', 'sn701', '40147.00');
INSERT INTO `mx_balance` VALUES ('7540', 'sn702', '48810.00');
INSERT INTO `mx_balance` VALUES ('7541', 'sn701', '40117.00');
INSERT INTO `mx_balance` VALUES ('7542', 'sn701', '40087.00');
INSERT INTO `mx_balance` VALUES ('7543', 'sn701', '40067.00');
INSERT INTO `mx_balance` VALUES ('7544', 'sn701', '40057.00');
INSERT INTO `mx_balance` VALUES ('7545', 'sn701', '39977.00');
INSERT INTO `mx_balance` VALUES ('7546', 'sn701', '39857.00');
INSERT INTO `mx_balance` VALUES ('7547', 'sn702', '48770.00');
INSERT INTO `mx_balance` VALUES ('7548', 'sn702', '48730.00');
INSERT INTO `mx_balance` VALUES ('7549', 'sn702', '48690.00');
INSERT INTO `mx_balance` VALUES ('7550', 'sn702', '48650.00');
INSERT INTO `mx_balance` VALUES ('7551', 'sn702', '48550.00');
INSERT INTO `mx_balance` VALUES ('7552', 'sn702', '48510.00');
INSERT INTO `mx_balance` VALUES ('7553', 'sn702', '48500.00');
INSERT INTO `mx_balance` VALUES ('7554', 'sn702', '48460.00');
INSERT INTO `mx_balance` VALUES ('7555', 'sn702', '48440.00');
INSERT INTO `mx_balance` VALUES ('7556', 'sn702', '48420.00');
INSERT INTO `mx_balance` VALUES ('7557', 'sn703', '48470.00');
INSERT INTO `mx_balance` VALUES ('7558', 'sn702', '48410.00');
INSERT INTO `mx_balance` VALUES ('7559', 'sn702', '48370.00');
INSERT INTO `mx_balance` VALUES ('7560', 'sn702', '48350.00');
INSERT INTO `mx_balance` VALUES ('7561', 'sn703', '48450.00');
INSERT INTO `mx_balance` VALUES ('7562', 'sn702', '48310.00');
INSERT INTO `mx_balance` VALUES ('7563', 'sn704', '10000.00');
INSERT INTO `mx_balance` VALUES ('7564', 'sn702', '48290.00');
INSERT INTO `mx_balance` VALUES ('7565', 'sn702', '48270.00');
INSERT INTO `mx_balance` VALUES ('7566', 'sn703', '48420.00');
INSERT INTO `mx_balance` VALUES ('7567', 'sn702', '48170.00');
INSERT INTO `mx_balance` VALUES ('7568', 'sn703', '48400.00');
INSERT INTO `mx_balance` VALUES ('7569', 'sn703', '48360.00');
INSERT INTO `mx_balance` VALUES ('7570', 'sn702', '48160.00');
INSERT INTO `mx_balance` VALUES ('7571', 'sn702', '48120.00');
INSERT INTO `mx_balance` VALUES ('7572', 'sn703', '48350.00');
INSERT INTO `mx_balance` VALUES ('7573', 'sn702', '48080.00');
INSERT INTO `mx_balance` VALUES ('7574', 'sn703', '48320.00');
INSERT INTO `mx_balance` VALUES ('7575', 'sn703', '48305.00');
INSERT INTO `mx_balance` VALUES ('7576', 'sn702', '48040.00');
INSERT INTO `mx_balance` VALUES ('7577', 'sn703', '48255.00');
INSERT INTO `mx_balance` VALUES ('7578', 'sn703', '48235.00');
INSERT INTO `mx_balance` VALUES ('7579', 'sn703', '48225.00');
INSERT INTO `mx_balance` VALUES ('7580', 'sn703', '48175.00');
INSERT INTO `mx_balance` VALUES ('7581', 'sn703', '48135.00');
INSERT INTO `mx_balance` VALUES ('7582', 'sn703', '48085.00');
INSERT INTO `mx_balance` VALUES ('7583', 'Sn704', '9980.00');
INSERT INTO `mx_balance` VALUES ('7584', 'sn703', '48075.00');
INSERT INTO `mx_balance` VALUES ('7585', 'sn703', '48055.00');
INSERT INTO `mx_balance` VALUES ('7586', 'sn702', '47990.00');
INSERT INTO `mx_balance` VALUES ('7587', 'sn702', '47890.00');
INSERT INTO `mx_balance` VALUES ('7588', 'sn702', '47870.00');
INSERT INTO `mx_balance` VALUES ('7589', 'sn702', '47720.00');
INSERT INTO `mx_balance` VALUES ('7590', 'Sn704', '9970.00');
INSERT INTO `mx_balance` VALUES ('7591', 'sn701', '39797.00');
INSERT INTO `mx_balance` VALUES ('7592', 'sn701', '39747.00');
INSERT INTO `mx_balance` VALUES ('7593', 'Sn704', '9930.00');
INSERT INTO `mx_balance` VALUES ('7594', 'Sn704', '9920.00');
INSERT INTO `mx_balance` VALUES ('7595', 'Sn704', '9870.00');
INSERT INTO `mx_balance` VALUES ('7596', 'Sn704', '9830.00');
INSERT INTO `mx_balance` VALUES ('7597', 'Sn704', '9780.00');
INSERT INTO `mx_balance` VALUES ('7598', 'Sn704', '9730.00');
INSERT INTO `mx_balance` VALUES ('7599', 'Sn704', '9680.00');
INSERT INTO `mx_balance` VALUES ('7600', 'Sn704', '9780.00');
INSERT INTO `mx_balance` VALUES ('7601', 'sn701', '38747.00');
INSERT INTO `mx_balance` VALUES ('7602', 'sn701', '38247.00');
INSERT INTO `mx_balance` VALUES ('7603', 'sn701', '38097.00');
INSERT INTO `mx_balance` VALUES ('7604', 'sn701', '38597.00');
INSERT INTO `mx_balance` VALUES ('7605', 'sn701', '36097.00');
INSERT INTO `mx_balance` VALUES ('7606', 'sn701', '32797.00');
INSERT INTO `mx_balance` VALUES ('7607', 'sn701', '32777.00');
INSERT INTO `mx_balance` VALUES ('7608', 'sn701', '31777.00');
INSERT INTO `mx_balance` VALUES ('7609', 'sn703', '48025.00');
INSERT INTO `mx_balance` VALUES ('7610', 'sn701', '31687.00');
INSERT INTO `mx_balance` VALUES ('7611', 'sn701', '33687.00');
INSERT INTO `mx_balance` VALUES ('7612', 'sn701', '33597.00');
INSERT INTO `mx_balance` VALUES ('7613', 'sn701', '33587.00');
INSERT INTO `mx_balance` VALUES ('7614', 'sn701', '33497.00');
INSERT INTO `mx_balance` VALUES ('7615', 'sn701', '33397.00');
INSERT INTO `mx_balance` VALUES ('7616', 'sn701', '33297.00');
INSERT INTO `mx_balance` VALUES ('7617', 'sn701', '33267.00');
INSERT INTO `mx_balance` VALUES ('7618', 'sn703', '48015.00');
INSERT INTO `mx_balance` VALUES ('7619', 'sn701', '33177.00');
INSERT INTO `mx_balance` VALUES ('7620', 'sn703', '48005.00');
INSERT INTO `mx_balance` VALUES ('7621', 'sn703', '47985.00');
INSERT INTO `mx_balance` VALUES ('7622', 'sn701', '33147.00');
INSERT INTO `mx_balance` VALUES ('7623', 'sn703', '47975.00');
INSERT INTO `mx_balance` VALUES ('7624', 'sn701', '33057.00');
INSERT INTO `mx_balance` VALUES ('7625', 'sn703', '47955.00');
INSERT INTO `mx_balance` VALUES ('7626', 'sn703', '47935.00');
INSERT INTO `mx_balance` VALUES ('7627', 'sn701', '33047.00');
INSERT INTO `mx_balance` VALUES ('7628', 'sn701', '33027.00');
INSERT INTO `mx_balance` VALUES ('7629', 'sn701', '33007.00');
INSERT INTO `mx_balance` VALUES ('7630', 'sn701', '32997.00');
INSERT INTO `mx_balance` VALUES ('7631', 'sn701', '32987.00');
INSERT INTO `mx_balance` VALUES ('7632', 'sn701', '32937.00');
INSERT INTO `mx_balance` VALUES ('7633', 'sn701', '32887.00');
INSERT INTO `mx_balance` VALUES ('7634', 'sn701', '32837.00');
INSERT INTO `mx_balance` VALUES ('7635', 'sn701', '32787.00');
INSERT INTO `mx_balance` VALUES ('7636', 'sn701', '32737.00');
INSERT INTO `mx_balance` VALUES ('7637', 'sn701', '32707.00');
INSERT INTO `mx_balance` VALUES ('7638', 'sn701', '32687.00');
INSERT INTO `mx_balance` VALUES ('7639', 'sn701', '32667.00');
INSERT INTO `mx_balance` VALUES ('7640', 'sn701', '32637.00');
INSERT INTO `mx_balance` VALUES ('7641', 'sn701', '32597.00');
INSERT INTO `mx_balance` VALUES ('7642', 'sn701', '32587.00');
INSERT INTO `mx_balance` VALUES ('7643', 'sn701', '32577.00');
INSERT INTO `mx_balance` VALUES ('7644', 'sn701', '32557.00');
INSERT INTO `mx_balance` VALUES ('7645', 'sn701', '32537.00');
INSERT INTO `mx_balance` VALUES ('7646', 'sn701', '32517.00');
INSERT INTO `mx_balance` VALUES ('7647', 'sn701', '32497.00');
INSERT INTO `mx_balance` VALUES ('7648', 'sn701', '32477.00');
INSERT INTO `mx_balance` VALUES ('7649', 'sn701', '32457.00');
INSERT INTO `mx_balance` VALUES ('7650', 'sn701', '32437.00');
INSERT INTO `mx_balance` VALUES ('7651', 'sn701', '32417.00');
INSERT INTO `mx_balance` VALUES ('7652', 'sn701', '32397.00');
INSERT INTO `mx_balance` VALUES ('7653', 'sn702', '47700.00');
INSERT INTO `mx_balance` VALUES ('7654', 'sn701', '32367.00');
INSERT INTO `mx_balance` VALUES ('7655', 'sn701', '32357.00');
INSERT INTO `mx_balance` VALUES ('7656', 'sn701', '32347.00');
INSERT INTO `mx_balance` VALUES ('7657', 'sn701', '32337.00');
INSERT INTO `mx_balance` VALUES ('7658', 'sn701', '32327.00');
INSERT INTO `mx_balance` VALUES ('7659', 'sn701', '32317.00');
INSERT INTO `mx_balance` VALUES ('7660', 'expert132', '145045.00');
INSERT INTO `mx_balance` VALUES ('7661', 'expert132', '144995.00');
INSERT INTO `mx_balance` VALUES ('7662', 'expert132', '144895.00');
INSERT INTO `mx_balance` VALUES ('7663', 'expert132', '144795.00');
INSERT INTO `mx_balance` VALUES ('7664', 'expert132', '144745.00');
INSERT INTO `mx_balance` VALUES ('7665', 'sn702', '47690.00');
INSERT INTO `mx_balance` VALUES ('7666', 'sn703', '47925.00');
INSERT INTO `mx_balance` VALUES ('7667', 'sn701', '32247.00');
INSERT INTO `mx_balance` VALUES ('7668', 'sn701', '32207.00');
INSERT INTO `mx_balance` VALUES ('7669', 'sn701', '32197.00');
INSERT INTO `mx_balance` VALUES ('7670', 'sn701', '32147.00');
INSERT INTO `mx_balance` VALUES ('7671', 'Sn704', '9775.00');
INSERT INTO `mx_balance` VALUES ('7672', 'Sn704', '9770.00');
INSERT INTO `mx_balance` VALUES ('7673', 'sn703', '47905.00');
INSERT INTO `mx_balance` VALUES ('7674', 'sn703', '47855.00');
INSERT INTO `mx_balance` VALUES ('7675', 'sn703', '47805.00');
INSERT INTO `mx_balance` VALUES ('7676', 'sn703', '47755.00');
INSERT INTO `mx_balance` VALUES ('7677', 'sn703', '47705.00');
INSERT INTO `mx_balance` VALUES ('7678', 'sn703', '47655.00');
INSERT INTO `mx_balance` VALUES ('7679', 'sn703', '47605.00');
INSERT INTO `mx_balance` VALUES ('7680', 'sn703', '47555.00');
INSERT INTO `mx_balance` VALUES ('7681', 'sn703', '47505.00');
INSERT INTO `mx_balance` VALUES ('7682', 'sn703', '47455.00');
INSERT INTO `mx_balance` VALUES ('7683', 'sn703', '47405.00');
INSERT INTO `mx_balance` VALUES ('7684', 'sn702', '47640.00');
INSERT INTO `mx_balance` VALUES ('7685', 'sn701', '32138.00');
INSERT INTO `mx_balance` VALUES ('7686', 'sn701', '32118.00');
INSERT INTO `mx_balance` VALUES ('7687', 'sn701', '32098.00');
INSERT INTO `mx_balance` VALUES ('7688', 'sn701', '32078.00');
INSERT INTO `mx_balance` VALUES ('7689', 'sn701', '32178.00');
INSERT INTO `mx_balance` VALUES ('7690', 'sn701', '32158.00');
INSERT INTO `mx_balance` VALUES ('7691', 'sn701', '32148.00');
INSERT INTO `mx_balance` VALUES ('7692', 'sn701', '32118.00');
INSERT INTO `mx_balance` VALUES ('7693', 'sn701', '32218.00');
INSERT INTO `mx_balance` VALUES ('7694', 'sn701', '32198.00');
INSERT INTO `mx_balance` VALUES ('7695', 'sn701', '32168.00');
INSERT INTO `mx_balance` VALUES ('7696', 'sn701', '32148.00');
INSERT INTO `mx_balance` VALUES ('7697', 'sn701', '32128.00');
INSERT INTO `mx_balance` VALUES ('7698', 'sn702', '47610.00');
INSERT INTO `mx_balance` VALUES ('7699', 'sn701', '32228.00');
INSERT INTO `mx_balance` VALUES ('7700', 'sn701', '32208.00');
INSERT INTO `mx_balance` VALUES ('7701', 'sn701', '32178.00');
INSERT INTO `mx_balance` VALUES ('7702', 'sn702', '47580.00');
INSERT INTO `mx_balance` VALUES ('7703', 'sn702', '47550.00');
INSERT INTO `mx_balance` VALUES ('7704', 'sn701', '32148.00');
INSERT INTO `mx_balance` VALUES ('7705', 'sn702', '47540.00');
INSERT INTO `mx_balance` VALUES ('7706', 'sn701', '32118.00');
INSERT INTO `mx_balance` VALUES ('7707', 'sn702', '47510.00');
INSERT INTO `mx_balance` VALUES ('7708', 'sn701', '32098.00');
INSERT INTO `mx_balance` VALUES ('7709', 'sn702', '47490.00');
INSERT INTO `mx_balance` VALUES ('7710', 'sn701', '32078.00');
INSERT INTO `mx_balance` VALUES ('7711', 'sn702', '47460.00');
INSERT INTO `mx_balance` VALUES ('7712', 'sn702', '47430.00');
INSERT INTO `mx_balance` VALUES ('7713', 'sn701', '32048.00');
INSERT INTO `mx_balance` VALUES ('7714', 'sn701', '32028.00');
INSERT INTO `mx_balance` VALUES ('7715', 'sn702', '47370.00');
INSERT INTO `mx_balance` VALUES ('7716', 'sn702', '47470.00');
INSERT INTO `mx_balance` VALUES ('7717', 'sn702', '47440.00');
INSERT INTO `mx_balance` VALUES ('7718', 'sn702', '47410.00');
INSERT INTO `mx_balance` VALUES ('7719', 'sn702', '47370.00');
INSERT INTO `mx_balance` VALUES ('7720', 'sn701', '32008.00');
INSERT INTO `mx_balance` VALUES ('7721', 'sn701', '31988.00');
INSERT INTO `mx_balance` VALUES ('7722', 'sn701', '31978.00');
INSERT INTO `mx_balance` VALUES ('7723', 'sn702', '47470.00');
INSERT INTO `mx_balance` VALUES ('7724', 'sn702', '47440.00');
INSERT INTO `mx_balance` VALUES ('7725', 'sn702', '47420.00');
INSERT INTO `mx_balance` VALUES ('7726', 'sn701', '31968.00');
INSERT INTO `mx_balance` VALUES ('7727', 'sn702', '47520.00');
INSERT INTO `mx_balance` VALUES ('7728', 'sn702', '47490.00');
INSERT INTO `mx_balance` VALUES ('7729', 'sn702', '47460.00');
INSERT INTO `mx_balance` VALUES ('7730', 'sn702', '47440.00');
INSERT INTO `mx_balance` VALUES ('7731', 'sn702', '47840.00');
INSERT INTO `mx_balance` VALUES ('7732', 'sn702', '47810.00');
INSERT INTO `mx_balance` VALUES ('7733', 'sn702', '47780.00');
INSERT INTO `mx_balance` VALUES ('7734', 'sn702', '47760.00');
INSERT INTO `mx_balance` VALUES ('7735', 'sn702', '47750.00');
INSERT INTO `mx_balance` VALUES ('7736', 'sn702', '47710.00');
INSERT INTO `mx_balance` VALUES ('7737', 'sn702', '47680.00');
INSERT INTO `mx_balance` VALUES ('7738', 'sn702', '47670.00');
INSERT INTO `mx_balance` VALUES ('7739', 'sn702', '47630.00');
INSERT INTO `mx_balance` VALUES ('7740', 'sn702', '47600.00');
INSERT INTO `mx_balance` VALUES ('7741', 'sn702', '47590.00');
INSERT INTO `mx_balance` VALUES ('7742', 'sn703', '47399.00');
INSERT INTO `mx_balance` VALUES ('7743', 'sn703', '47409.00');
INSERT INTO `mx_balance` VALUES ('7744', 'sn703', '47399.00');
INSERT INTO `mx_balance` VALUES ('7745', 'sn702', '47690.00');
INSERT INTO `mx_balance` VALUES ('7746', 'sn703', '47449.00');
INSERT INTO `mx_balance` VALUES ('7747', 'sn703', '47439.00');
INSERT INTO `mx_balance` VALUES ('7748', 'sn703', '47434.00');
INSERT INTO `mx_balance` VALUES ('7749', 'sn703', '47424.00');
INSERT INTO `mx_balance` VALUES ('7750', 'sn703', '47414.00');
INSERT INTO `mx_balance` VALUES ('7751', 'sn703', '47814.00');
INSERT INTO `mx_balance` VALUES ('7752', 'sn703', '47804.00');
INSERT INTO `mx_balance` VALUES ('7753', 'sn703', '47794.00');
INSERT INTO `mx_balance` VALUES ('7754', 'sn703', '47784.00');
INSERT INTO `mx_balance` VALUES ('7755', 'sn703', '47884.00');
INSERT INTO `mx_balance` VALUES ('7756', 'sn703', '47874.00');
INSERT INTO `mx_balance` VALUES ('7757', 'sn703', '47864.00');
INSERT INTO `mx_balance` VALUES ('7758', 'sn703', '47854.00');
INSERT INTO `mx_balance` VALUES ('7759', 'sn703', '47954.00');
INSERT INTO `mx_balance` VALUES ('7760', 'sn703', '47944.00');
INSERT INTO `mx_balance` VALUES ('7761', 'sn703', '47934.00');
INSERT INTO `mx_balance` VALUES ('7762', 'sn703', '47884.00');
INSERT INTO `mx_balance` VALUES ('7763', 'sn703', '47834.00');
INSERT INTO `mx_balance` VALUES ('7764', 'sn703', '48234.00');
INSERT INTO `mx_balance` VALUES ('7765', 'sn703', '48224.00');
INSERT INTO `mx_balance` VALUES ('7766', 'sn703', '48214.00');
INSERT INTO `mx_balance` VALUES ('7767', 'sn703', '48204.00');
INSERT INTO `mx_balance` VALUES ('7768', 'sn702', '47670.00');
INSERT INTO `mx_balance` VALUES ('7769', 'sn703', '48194.00');
INSERT INTO `mx_balance` VALUES ('7770', 'sn702', '47650.00');
INSERT INTO `mx_balance` VALUES ('7771', 'sn703', '48144.00');
INSERT INTO `mx_balance` VALUES ('7772', 'sn703', '48094.00');
INSERT INTO `mx_balance` VALUES ('7773', 'sn703', '48084.00');
INSERT INTO `mx_balance` VALUES ('7774', 'sn701', '31958.00');
INSERT INTO `mx_balance` VALUES ('7775', 'sn702', '47630.00');
INSERT INTO `mx_balance` VALUES ('7776', 'sn703', '48184.00');
INSERT INTO `mx_balance` VALUES ('7777', 'sn703', '48164.00');
INSERT INTO `mx_balance` VALUES ('7778', 'sn701', '31948.00');
INSERT INTO `mx_balance` VALUES ('7779', 'sn703', '48154.00');
INSERT INTO `mx_balance` VALUES ('7780', 'sn701', '31928.00');
INSERT INTO `mx_balance` VALUES ('7781', 'sn701', '31908.00');
INSERT INTO `mx_balance` VALUES ('7782', 'sn703', '48104.00');
INSERT INTO `mx_balance` VALUES ('7783', 'sn703', '48054.00');
INSERT INTO `mx_balance` VALUES ('7784', 'sn701', '31878.00');
INSERT INTO `mx_balance` VALUES ('7785', 'sn703', '48154.00');
INSERT INTO `mx_balance` VALUES ('7786', 'sn701', '31848.00');
INSERT INTO `mx_balance` VALUES ('7787', 'sn701', '31828.00');
INSERT INTO `mx_balance` VALUES ('7788', 'sn703', '48054.00');
INSERT INTO `mx_balance` VALUES ('7789', 'sn703', '47954.00');
INSERT INTO `mx_balance` VALUES ('7790', 'sn702', '47620.00');
INSERT INTO `mx_balance` VALUES ('7791', 'sn702', '47600.00');
INSERT INTO `mx_balance` VALUES ('7792', 'sn703', '48154.00');
INSERT INTO `mx_balance` VALUES ('7793', 'sn703', '48104.00');
INSERT INTO `mx_balance` VALUES ('7794', 'sn703', '48054.00');
INSERT INTO `mx_balance` VALUES ('7795', 'sn703', '48154.00');
INSERT INTO `mx_balance` VALUES ('7796', 'sn703', '48104.00');
INSERT INTO `mx_balance` VALUES ('7797', 'sn703', '48054.00');
INSERT INTO `mx_balance` VALUES ('7798', 'sn703', '48154.00');
INSERT INTO `mx_balance` VALUES ('7799', 'sn703', '48114.00');
INSERT INTO `mx_balance` VALUES ('7800', 'sn703', '48094.00');
INSERT INTO `mx_balance` VALUES ('7801', 'sn703', '48054.00');
INSERT INTO `mx_balance` VALUES ('7802', 'sn703', '48154.00');
INSERT INTO `mx_balance` VALUES ('7803', 'sn703', '48144.00');
INSERT INTO `mx_balance` VALUES ('7804', 'sn701', '31798.00');
INSERT INTO `mx_balance` VALUES ('7805', 'sn701', '31778.00');
INSERT INTO `mx_balance` VALUES ('7806', 'sn701', '31728.00');
INSERT INTO `mx_balance` VALUES ('7807', 'Sn704', '9765.00');
INSERT INTO `mx_balance` VALUES ('7808', 'Sn704', '9760.00');
INSERT INTO `mx_balance` VALUES ('7809', 'sn702', '47570.00');
INSERT INTO `mx_balance` VALUES ('7810', 'Sn704', '9770.00');
INSERT INTO `mx_balance` VALUES ('7811', 'Sn704', '9670.00');
INSERT INTO `mx_balance` VALUES ('7812', 'sn703', '48124.00');
INSERT INTO `mx_balance` VALUES ('7813', 'sn703', '48074.00');
INSERT INTO `mx_balance` VALUES ('7814', 'sn703', '48024.00');
INSERT INTO `mx_balance` VALUES ('7815', 'Sn704', '9665.00');
INSERT INTO `mx_balance` VALUES ('7816', 'sn703', '48124.00');
INSERT INTO `mx_balance` VALUES ('7817', 'Sn704', '9765.00');
INSERT INTO `mx_balance` VALUES ('7818', 'Sn704', '9760.00');
INSERT INTO `mx_balance` VALUES ('7819', 'Sn704', '9750.00');
INSERT INTO `mx_balance` VALUES ('7820', 'Sn704', '9760.00');
INSERT INTO `mx_balance` VALUES ('7821', 'Sn704', '9755.00');
INSERT INTO `mx_balance` VALUES ('7822', 'Sn704', '9750.00');
INSERT INTO `mx_balance` VALUES ('7823', 'Sn704', '9746.00');
INSERT INTO `mx_balance` VALUES ('7824', 'Sn704', '9740.00');
INSERT INTO `mx_balance` VALUES ('7825', 'sn703', '48074.00');
INSERT INTO `mx_balance` VALUES ('7826', 'sn703', '48024.00');
INSERT INTO `mx_balance` VALUES ('7827', 'sn703', '48124.00');
INSERT INTO `mx_balance` VALUES ('7828', 'sn701', '31688.00');
INSERT INTO `mx_balance` VALUES ('7829', 'Sn704', '9640.00');
INSERT INTO `mx_balance` VALUES ('7830', 'sn703', '48074.00');
INSERT INTO `mx_balance` VALUES ('7831', 'sn703', '48024.00');
INSERT INTO `mx_balance` VALUES ('7832', 'Sn704', '9740.00');
INSERT INTO `mx_balance` VALUES ('7833', 'Sn704', '9640.00');
INSERT INTO `mx_balance` VALUES ('7834', 'Sn704', '9740.00');
INSERT INTO `mx_balance` VALUES ('7835', 'sn703', '48124.00');
INSERT INTO `mx_balance` VALUES ('7836', 'Sn704', '9640.00');
INSERT INTO `mx_balance` VALUES ('7837', 'Sn704', '9740.00');
INSERT INTO `mx_balance` VALUES ('7838', 'Sn704', '9690.00');
INSERT INTO `mx_balance` VALUES ('7839', 'sn703', '48123.00');
INSERT INTO `mx_balance` VALUES ('7840', 'Sn704', '9640.00');
INSERT INTO `mx_balance` VALUES ('7841', 'sn703', '48073.00');
INSERT INTO `mx_balance` VALUES ('7842', 'sn703', '48023.00');
INSERT INTO `mx_balance` VALUES ('7843', 'Sn704', '9635.00');
INSERT INTO `mx_balance` VALUES ('7844', 'sn703', '47973.00');
INSERT INTO `mx_balance` VALUES ('7845', 'sn703', '47923.00');
INSERT INTO `mx_balance` VALUES ('7846', 'sn703', '48023.00');
INSERT INTO `mx_balance` VALUES ('7847', 'sn703', '48123.00');
INSERT INTO `mx_balance` VALUES ('7848', 'Sn704', '9625.00');
INSERT INTO `mx_balance` VALUES ('7849', 'Sn704', '9595.00');
INSERT INTO `mx_balance` VALUES ('7850', 'Sn704', '9565.00');
INSERT INTO `mx_balance` VALUES ('7851', 'Sn704', '9525.00');
INSERT INTO `mx_balance` VALUES ('7852', 'Sn704', '9495.00');
INSERT INTO `mx_balance` VALUES ('7853', 'Sn704', '9485.00');
INSERT INTO `mx_balance` VALUES ('7854', 'Sn704', '9482.00');
INSERT INTO `mx_balance` VALUES ('7855', 'Sn704', '9382.00');
INSERT INTO `mx_balance` VALUES ('7856', 'Sn704', '9482.00');
INSERT INTO `mx_balance` VALUES ('7857', 'expert132', '144645.00');
INSERT INTO `mx_balance` VALUES ('7858', 'expert132', '144545.00');
INSERT INTO `mx_balance` VALUES ('7859', 'expert132', '144445.00');
INSERT INTO `mx_balance` VALUES ('7860', 'expert132', '144745.00');
INSERT INTO `mx_balance` VALUES ('7861', 'expert132', '144645.00');
INSERT INTO `mx_balance` VALUES ('7862', 'expert132', '144545.00');
INSERT INTO `mx_balance` VALUES ('7863', 'expert132', '144445.00');
INSERT INTO `mx_balance` VALUES ('7864', 'Sn704', '9382.00');
INSERT INTO `mx_balance` VALUES ('7865', 'sn703', '48118.00');
INSERT INTO `mx_balance` VALUES ('7866', 'Sn704', '9482.00');
INSERT INTO `mx_balance` VALUES ('7867', 'sn703', '48108.00');
INSERT INTO `mx_balance` VALUES ('7868', 'sn703', '48103.00');
INSERT INTO `mx_balance` VALUES ('7869', 'sn703', '48093.00');
INSERT INTO `mx_balance` VALUES ('7870', 'sn703', '48043.00');
INSERT INTO `mx_balance` VALUES ('7871', 'sn703', '47993.00');
INSERT INTO `mx_balance` VALUES ('7872', 'sn703', '48093.00');
INSERT INTO `mx_balance` VALUES ('7873', 'Sn704', '9432.00');
INSERT INTO `mx_balance` VALUES ('7874', 'Sn704', '9382.00');
INSERT INTO `mx_balance` VALUES ('7875', 'Sn704', '9482.00');
INSERT INTO `mx_balance` VALUES ('7876', 'sn703', '48043.00');
INSERT INTO `mx_balance` VALUES ('7877', 'sn703', '47993.00');
INSERT INTO `mx_balance` VALUES ('7878', 'sn703', '48093.00');
INSERT INTO `mx_balance` VALUES ('7879', 'sn703', '48043.00');
INSERT INTO `mx_balance` VALUES ('7880', 'sn703', '47993.00');
INSERT INTO `mx_balance` VALUES ('7881', 'sn703', '48093.00');
INSERT INTO `mx_balance` VALUES ('7882', 'sn703', '48083.00');
INSERT INTO `mx_balance` VALUES ('7883', 'Sn701', '31678.00');
INSERT INTO `mx_balance` VALUES ('7884', 'expert132', '144395.00');
INSERT INTO `mx_balance` VALUES ('7885', 'expert132', '144345.00');
INSERT INTO `mx_balance` VALUES ('7886', 'expert132', '144445.00');
INSERT INTO `mx_balance` VALUES ('7887', 'Sn701', '31658.00');
INSERT INTO `mx_balance` VALUES ('7888', 'Sn701', '31628.00');
INSERT INTO `mx_balance` VALUES ('7889', 'Sn701', '31618.00');
INSERT INTO `mx_balance` VALUES ('7890', 'Sn701', '31598.00');
INSERT INTO `mx_balance` VALUES ('7891', 'Sn701', '31588.00');
INSERT INTO `mx_balance` VALUES ('7892', 'Sn701', '31578.00');
INSERT INTO `mx_balance` VALUES ('7893', 'Sn701', '31678.00');
INSERT INTO `mx_balance` VALUES ('7894', 'Sn701', '31648.00');
INSERT INTO `mx_balance` VALUES ('7895', 'Sn701', '31638.00');
INSERT INTO `mx_balance` VALUES ('7896', 'Sn701', '31738.00');
INSERT INTO `mx_balance` VALUES ('7897', 'Sn701', '31718.00');
INSERT INTO `mx_balance` VALUES ('7898', 'Sn701', '31698.00');
INSERT INTO `mx_balance` VALUES ('7899', 'Sn701', '31678.00');
INSERT INTO `mx_balance` VALUES ('7900', 'sn703', '48033.00');
INSERT INTO `mx_balance` VALUES ('7901', 'sn703', '47983.00');
INSERT INTO `mx_balance` VALUES ('7902', 'sn703', '48083.00');
INSERT INTO `mx_balance` VALUES ('7903', 'Sn701', '31668.00');
INSERT INTO `mx_balance` VALUES ('7904', 'sn703', '48073.00');
INSERT INTO `mx_balance` VALUES ('7905', 'sn703', '48063.00');
INSERT INTO `mx_balance` VALUES ('7906', 'Sn701', '31628.00');
INSERT INTO `mx_balance` VALUES ('7907', 'sn703', '48163.00');
INSERT INTO `mx_balance` VALUES ('7908', 'Sn701', '31588.00');
INSERT INTO `mx_balance` VALUES ('7909', 'Sn701', '31548.00');
INSERT INTO `mx_balance` VALUES ('7910', 'Sn701', '31538.00');
INSERT INTO `mx_balance` VALUES ('7911', 'sn703', '48153.00');
INSERT INTO `mx_balance` VALUES ('7912', 'sn703', '48143.00');
INSERT INTO `mx_balance` VALUES ('7913', 'sn703', '48133.00');
INSERT INTO `mx_balance` VALUES ('7914', 'sn703', '48123.00');
INSERT INTO `mx_balance` VALUES ('7915', 'sn703', '48103.00');
INSERT INTO `mx_balance` VALUES ('7916', 'sn703', '48093.00');
INSERT INTO `mx_balance` VALUES ('7917', 'sn703', '48043.00');
INSERT INTO `mx_balance` VALUES ('7918', 'sn703', '47993.00');
INSERT INTO `mx_balance` VALUES ('7919', 'sn702', '47540.00');
INSERT INTO `mx_balance` VALUES ('7920', 'sn703', '48093.00');
INSERT INTO `mx_balance` VALUES ('7921', 'sn703', '48083.00');
INSERT INTO `mx_balance` VALUES ('7922', 'sn701', '31528.00');
INSERT INTO `mx_balance` VALUES ('7923', 'sn701', '31508.00');
INSERT INTO `mx_balance` VALUES ('7924', 'sn702', '47510.00');
INSERT INTO `mx_balance` VALUES ('7925', 'sn701', '31708.00');
INSERT INTO `mx_balance` VALUES ('7926', 'sn701', '31638.00');
INSERT INTO `mx_balance` VALUES ('7927', 'sn701', '31628.00');
INSERT INTO `mx_balance` VALUES ('7928', 'sn701', '31728.00');
INSERT INTO `mx_balance` VALUES ('7929', 'sn703', '48033.00');
INSERT INTO `mx_balance` VALUES ('7930', 'sn701', '31668.00');
INSERT INTO `mx_balance` VALUES ('7931', 'sn703', '47983.00');
INSERT INTO `mx_balance` VALUES ('7932', 'sn701', '31638.00');
INSERT INTO `mx_balance` VALUES ('7933', 'sn701', '31838.00');
INSERT INTO `mx_balance` VALUES ('7934', 'sn701', '31688.00');
INSERT INTO `mx_balance` VALUES ('7935', 'sn701', '31668.00');
INSERT INTO `mx_balance` VALUES ('7936', 'sn703', '48083.00');
INSERT INTO `mx_balance` VALUES ('7937', 'sn701', '32068.00');
INSERT INTO `mx_balance` VALUES ('7938', 'sn701', '31888.00');
INSERT INTO `mx_balance` VALUES ('7939', 'sn701', '31838.00');
INSERT INTO `mx_balance` VALUES ('7940', 'sn701', '31938.00');
INSERT INTO `mx_balance` VALUES ('7941', 'sn701', '31898.00');
INSERT INTO `mx_balance` VALUES ('7942', 'sn701', '31778.00');
INSERT INTO `mx_balance` VALUES ('7943', 'sn701', '31878.00');
INSERT INTO `mx_balance` VALUES ('7944', 'sn701', '31778.00');
INSERT INTO `mx_balance` VALUES ('7945', 'sn701', '31738.00');
INSERT INTO `mx_balance` VALUES ('7946', 'sn701', '31688.00');
INSERT INTO `mx_balance` VALUES ('7947', 'sn701', '31678.00');
INSERT INTO `mx_balance` VALUES ('7948', 'sn701', '31668.00');
INSERT INTO `mx_balance` VALUES ('7949', 'sn701', '31658.00');
INSERT INTO `mx_balance` VALUES ('7950', 'sn701', '31758.00');
INSERT INTO `mx_balance` VALUES ('7951', 'sn701', '31958.00');
INSERT INTO `mx_balance` VALUES ('7952', 'sn701', '31838.00');
INSERT INTO `mx_balance` VALUES ('7953', 'sn701', '31788.00');
INSERT INTO `mx_balance` VALUES ('7954', 'sn703', '48073.00');
INSERT INTO `mx_balance` VALUES ('7955', 'sn703', '48063.00');
INSERT INTO `mx_balance` VALUES ('7956', 'sn701', '31888.00');
INSERT INTO `mx_balance` VALUES ('7957', 'sn701', '31988.00');
INSERT INTO `mx_balance` VALUES ('7958', 'sn701', '31868.00');
INSERT INTO `mx_balance` VALUES ('7959', 'sn701', '31818.00');
INSERT INTO `mx_balance` VALUES ('7960', 'sn701', '31808.00');
INSERT INTO `mx_balance` VALUES ('7961', 'sn703', '48053.00');
INSERT INTO `mx_balance` VALUES ('7962', 'sn701', '31908.00');
INSERT INTO `mx_balance` VALUES ('7963', 'sn701', '32008.00');
INSERT INTO `mx_balance` VALUES ('7964', 'sn703', '48043.00');
INSERT INTO `mx_balance` VALUES ('7965', 'sn701', '31928.00');
INSERT INTO `mx_balance` VALUES ('7966', 'sn701', '31818.00');
INSERT INTO `mx_balance` VALUES ('7967', 'sn701', '31808.00');
INSERT INTO `mx_balance` VALUES ('7968', 'sn701', '32208.00');
INSERT INTO `mx_balance` VALUES ('7969', 'sn701', '32148.00');
INSERT INTO `mx_balance` VALUES ('7970', 'sn701', '31998.00');
INSERT INTO `mx_balance` VALUES ('7971', 'sn701', '31988.00');
INSERT INTO `mx_balance` VALUES ('7972', 'sn703', '48033.00');
INSERT INTO `mx_balance` VALUES ('7973', 'sn701', '32088.00');
INSERT INTO `mx_balance` VALUES ('7974', 'sn703', '48023.00');
INSERT INTO `mx_balance` VALUES ('7975', 'sn701', '32038.00');
INSERT INTO `mx_balance` VALUES ('7976', 'sn701', '32028.00');
INSERT INTO `mx_balance` VALUES ('7977', 'sn701', '32128.00');
INSERT INTO `mx_balance` VALUES ('7978', 'sn703', '48123.00');
INSERT INTO `mx_balance` VALUES ('7979', 'sn701', '32068.00');
INSERT INTO `mx_balance` VALUES ('7980', 'sn701', '32048.00');
INSERT INTO `mx_balance` VALUES ('7981', 'sn701', '32038.00');
INSERT INTO `mx_balance` VALUES ('7982', 'sn703', '48113.00');
INSERT INTO `mx_balance` VALUES ('7983', 'sn701', '32138.00');
INSERT INTO `mx_balance` VALUES ('7984', 'sn703', '48103.00');
INSERT INTO `mx_balance` VALUES ('7985', 'sn701', '32078.00');
INSERT INTO `mx_balance` VALUES ('7986', 'sn701', '32068.00');
INSERT INTO `mx_balance` VALUES ('7987', 'sn701', '32058.00');
INSERT INTO `mx_balance` VALUES ('7988', 'sn701', '32158.00');
INSERT INTO `mx_balance` VALUES ('7989', 'sn703', '48093.00');
INSERT INTO `mx_balance` VALUES ('7990', 'sn701', '32098.00');
INSERT INTO `mx_balance` VALUES ('7991', 'sn702', '47490.00');
INSERT INTO `mx_balance` VALUES ('7992', 'sn701', '32078.00');
INSERT INTO `mx_balance` VALUES ('7993', 'sn701', '32068.00');
INSERT INTO `mx_balance` VALUES ('7994', 'sn701', '32168.00');
INSERT INTO `mx_balance` VALUES ('7995', 'sn703', '48073.00');
INSERT INTO `mx_balance` VALUES ('7996', 'sn701', '32098.00');
INSERT INTO `mx_balance` VALUES ('7997', 'sn701', '32078.00');
INSERT INTO `mx_balance` VALUES ('7998', 'sn701', '32058.00');
INSERT INTO `mx_balance` VALUES ('7999', 'sn701', '32048.00');
INSERT INTO `mx_balance` VALUES ('8000', 'sn703', '47973.00');
INSERT INTO `mx_balance` VALUES ('8001', 'sn702', '47470.00');
INSERT INTO `mx_balance` VALUES ('8002', 'sn701', '32148.00');
INSERT INTO `mx_balance` VALUES ('8003', 'sn703', '48173.00');
INSERT INTO `mx_balance` VALUES ('8004', 'sn702', '47410.00');
INSERT INTO `mx_balance` VALUES ('8005', 'sn702', '47380.00');
INSERT INTO `mx_balance` VALUES ('8006', 'sn702', '47480.00');
INSERT INTO `mx_balance` VALUES ('8007', 'sn703', '48163.00');
INSERT INTO `mx_balance` VALUES ('8008', 'sn702', '47460.00');
INSERT INTO `mx_balance` VALUES ('8009', 'sn703', '48153.00');
INSERT INTO `mx_balance` VALUES ('8010', 'sn702', '47420.00');
INSERT INTO `mx_balance` VALUES ('8011', 'sn703', '48143.00');
INSERT INTO `mx_balance` VALUES ('8012', 'sn703', '48123.00');
INSERT INTO `mx_balance` VALUES ('8013', 'sn702', '47620.00');
INSERT INTO `mx_balance` VALUES ('8014', 'sn703', '48113.00');
INSERT INTO `mx_balance` VALUES ('8015', 'sn702', '47600.00');
INSERT INTO `mx_balance` VALUES ('8016', 'sn703', '48103.00');
INSERT INTO `mx_balance` VALUES ('8017', 'sn703', '48153.00');
INSERT INTO `mx_balance` VALUES ('8018', 'sn703', '48133.00');
INSERT INTO `mx_balance` VALUES ('8019', 'sn703', '48123.00');
INSERT INTO `mx_balance` VALUES ('8020', 'sn702', '47590.00');
INSERT INTO `mx_balance` VALUES ('8021', 'sn703', '48103.00');
INSERT INTO `mx_balance` VALUES ('8022', 'sn703', '48083.00');
INSERT INTO `mx_balance` VALUES ('8023', 'sn701', '32118.00');
INSERT INTO `mx_balance` VALUES ('8024', 'sn701', '32068.00');
INSERT INTO `mx_balance` VALUES ('8025', 'sn701', '32058.00');
INSERT INTO `mx_balance` VALUES ('8026', 'sn703', '48073.00');
INSERT INTO `mx_balance` VALUES ('8027', 'sn701', '32018.00');
INSERT INTO `mx_balance` VALUES ('8028', 'sn703', '48023.00');
INSERT INTO `mx_balance` VALUES ('8029', 'sn703', '48013.00');
INSERT INTO `mx_balance` VALUES ('8030', 'sn701', '31998.00');
INSERT INTO `mx_balance` VALUES ('8031', 'sn702', '47580.00');
INSERT INTO `mx_balance` VALUES ('8032', 'sn703', '47913.00');
INSERT INTO `mx_balance` VALUES ('8033', 'sn703', '47903.00');
INSERT INTO `mx_balance` VALUES ('8034', 'sn701', '31988.00');
INSERT INTO `mx_balance` VALUES ('8035', 'sn703', '47893.00');
INSERT INTO `mx_balance` VALUES ('8036', 'sn703', '47883.00');
INSERT INTO `mx_balance` VALUES ('8037', 'sn701', '31948.00');
INSERT INTO `mx_balance` VALUES ('8038', 'sn701', '31928.00');
INSERT INTO `mx_balance` VALUES ('8039', 'sn702', '47570.00');
INSERT INTO `mx_balance` VALUES ('8040', 'sn702', '47560.00');
INSERT INTO `mx_balance` VALUES ('8041', 'sn701', '31918.00');
INSERT INTO `mx_balance` VALUES ('8042', 'sn703', '47873.00');
INSERT INTO `mx_balance` VALUES ('8043', 'sn703', '47863.00');
INSERT INTO `mx_balance` VALUES ('8044', 'sn701', '31908.00');
INSERT INTO `mx_balance` VALUES ('8045', 'sn701', '31898.00');
INSERT INTO `mx_balance` VALUES ('8046', 'sn701', '31868.00');
INSERT INTO `mx_balance` VALUES ('8047', 'sn703', '47853.00');
INSERT INTO `mx_balance` VALUES ('8048', 'sn701', '31818.00');
INSERT INTO `mx_balance` VALUES ('8049', 'sn701', '31798.00');
INSERT INTO `mx_balance` VALUES ('8050', 'sn701', '31778.00');
INSERT INTO `mx_balance` VALUES ('8051', 'sn703', '47843.00');
INSERT INTO `mx_balance` VALUES ('8052', 'sn703', '47833.00');
INSERT INTO `mx_balance` VALUES ('8053', 'sn701', '31748.00');
INSERT INTO `mx_balance` VALUES ('8054', 'sn702', '47550.00');
INSERT INTO `mx_balance` VALUES ('8055', 'sn703', '47823.00');
INSERT INTO `mx_balance` VALUES ('8056', 'sn702', '47540.00');
INSERT INTO `mx_balance` VALUES ('8057', 'sn703', '47813.00');
INSERT INTO `mx_balance` VALUES ('8058', 'sn703', '47803.00');
INSERT INTO `mx_balance` VALUES ('8059', 'sn703', '47793.00');
INSERT INTO `mx_balance` VALUES ('8060', 'sn702', '47520.00');
INSERT INTO `mx_balance` VALUES ('8061', 'sn703', '47783.00');
INSERT INTO `mx_balance` VALUES ('8062', 'sn701', '31728.00');
INSERT INTO `mx_balance` VALUES ('8063', 'sn703', '47773.00');
INSERT INTO `mx_balance` VALUES ('8064', 'sn701', '31708.00');
INSERT INTO `mx_balance` VALUES ('8065', 'sn703', '47753.00');
INSERT INTO `mx_balance` VALUES ('8066', 'sn703', '47743.00');
INSERT INTO `mx_balance` VALUES ('8067', 'sn701', '31698.00');
INSERT INTO `mx_balance` VALUES ('8068', 'sn703', '47733.00');
INSERT INTO `mx_balance` VALUES ('8069', 'sn701', '31678.00');
INSERT INTO `mx_balance` VALUES ('8070', 'sn701', '31668.00');
INSERT INTO `mx_balance` VALUES ('8071', 'sn703', '47713.00');
INSERT INTO `mx_balance` VALUES ('8072', 'sn701', '31648.00');
INSERT INTO `mx_balance` VALUES ('8073', 'sn701', '31638.00');
INSERT INTO `mx_balance` VALUES ('8074', 'sn703', '47693.00');
INSERT INTO `mx_balance` VALUES ('8075', 'sn701', '31608.00');
INSERT INTO `mx_balance` VALUES ('8076', 'sn701', '31558.00');
INSERT INTO `mx_balance` VALUES ('8077', 'sn701', '31548.00');
INSERT INTO `mx_balance` VALUES ('8078', 'sn701', '31518.00');
INSERT INTO `mx_balance` VALUES ('8079', 'sn701', '31468.00');
INSERT INTO `mx_balance` VALUES ('8080', 'sn701', '31438.00');
INSERT INTO `mx_balance` VALUES ('8081', 'sn701', '31428.00');
INSERT INTO `mx_balance` VALUES ('8082', 'sn701', '31378.00');
INSERT INTO `mx_balance` VALUES ('8083', 'sn701', '31358.00');
INSERT INTO `mx_balance` VALUES ('8084', 'sn701', '31338.00');
INSERT INTO `mx_balance` VALUES ('8085', 'sn703', '47643.00');
INSERT INTO `mx_balance` VALUES ('8086', 'sn701', '31258.00');
INSERT INTO `mx_balance` VALUES ('8087', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8088', 'sn703', '47633.00');
INSERT INTO `mx_balance` VALUES ('8089', 'sn701', '31228.00');
INSERT INTO `mx_balance` VALUES ('8090', 'sn701', '31208.00');
INSERT INTO `mx_balance` VALUES ('8091', 'sn701', '31198.00');
INSERT INTO `mx_balance` VALUES ('8092', 'sn701', '31148.00');
INSERT INTO `mx_balance` VALUES ('8093', 'sn701', '31138.00');
INSERT INTO `mx_balance` VALUES ('8094', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8095', 'sn701', '31228.00');
INSERT INTO `mx_balance` VALUES ('8096', 'sn701', '31198.00');
INSERT INTO `mx_balance` VALUES ('8097', 'sn701', '31188.00');
INSERT INTO `mx_balance` VALUES ('8098', 'sn701', '31288.00');
INSERT INTO `mx_balance` VALUES ('8099', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8100', 'sn701', '31218.00');
INSERT INTO `mx_balance` VALUES ('8101', 'sn701', '31318.00');
INSERT INTO `mx_balance` VALUES ('8102', 'sn701', '31268.00');
INSERT INTO `mx_balance` VALUES ('8103', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8104', 'sn701', '31178.00');
INSERT INTO `mx_balance` VALUES ('8105', 'sn701', '31158.00');
INSERT INTO `mx_balance` VALUES ('8106', 'sn701', '31148.00');
INSERT INTO `mx_balance` VALUES ('8107', 'sn701', '31138.00');
INSERT INTO `mx_balance` VALUES ('8108', 'sn701', '31338.00');
INSERT INTO `mx_balance` VALUES ('8109', 'sn701', '31288.00');
INSERT INTO `mx_balance` VALUES ('8110', 'Sn705', '10000.00');
INSERT INTO `mx_balance` VALUES ('8111', 'sn701', '31268.00');
INSERT INTO `mx_balance` VALUES ('8112', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8113', 'sn701', '31208.00');
INSERT INTO `mx_balance` VALUES ('8114', 'sn701', '31308.00');
INSERT INTO `mx_balance` VALUES ('8115', 'sn701', '31248.00');
INSERT INTO `mx_balance` VALUES ('8116', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8117', 'sn701', '31208.00');
INSERT INTO `mx_balance` VALUES ('8118', 'sn701', '31308.00');
INSERT INTO `mx_balance` VALUES ('8119', 'sn701', '31298.00');
INSERT INTO `mx_balance` VALUES ('8120', 'sn701', '31258.00');
INSERT INTO `mx_balance` VALUES ('8121', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8122', 'sn703', '47623.00');
INSERT INTO `mx_balance` VALUES ('8123', 'Sn705', '20000.00');
INSERT INTO `mx_balance` VALUES ('8124', 'sn701', '31338.00');
INSERT INTO `mx_balance` VALUES ('8125', 'sn703', '47603.00');
INSERT INTO `mx_balance` VALUES ('8126', 'sn703', '47593.00');
INSERT INTO `mx_balance` VALUES ('8127', 'sn701', '31288.00');
INSERT INTO `mx_balance` VALUES ('8128', 'sn701', '31278.00');
INSERT INTO `mx_balance` VALUES ('8129', 'sn701', '31198.00');
INSERT INTO `mx_balance` VALUES ('8130', 'sn701', '31148.00');
INSERT INTO `mx_balance` VALUES ('8131', 'sn701', '31088.00');
INSERT INTO `mx_balance` VALUES ('8132', 'sn701', '31068.00');
INSERT INTO `mx_balance` VALUES ('8133', 'sn701', '31268.00');
INSERT INTO `mx_balance` VALUES ('8134', 'sn701', '31468.00');
INSERT INTO `mx_balance` VALUES ('8135', 'sn701', '31568.00');
INSERT INTO `mx_balance` VALUES ('8136', 'sn701', '31518.00');
INSERT INTO `mx_balance` VALUES ('8137', 'sn701', '31378.00');
INSERT INTO `mx_balance` VALUES ('8138', 'sn701', '31318.00');
INSERT INTO `mx_balance` VALUES ('8139', 'sn701', '31308.00');
INSERT INTO `mx_balance` VALUES ('8140', 'sn701', '31268.00');
INSERT INTO `mx_balance` VALUES ('8141', 'sn701', '31238.00');
INSERT INTO `mx_balance` VALUES ('8142', 'sn701', '31198.00');
INSERT INTO `mx_balance` VALUES ('8143', 'sn701', '31178.00');
INSERT INTO `mx_balance` VALUES ('8144', 'sn701', '31158.00');
INSERT INTO `mx_balance` VALUES ('8145', 'sn701', '31258.00');
INSERT INTO `mx_balance` VALUES ('8146', 'sn701', '31358.00');
INSERT INTO `mx_balance` VALUES ('8147', 'sn701', '31308.00');
INSERT INTO `mx_balance` VALUES ('8148', 'sn701', '31188.00');
INSERT INTO `mx_balance` VALUES ('8149', 'sn701', '31158.00');
INSERT INTO `mx_balance` VALUES ('8150', 'sn701', '31108.00');
INSERT INTO `mx_balance` VALUES ('8151', 'sn701', '31078.00');
INSERT INTO `mx_balance` VALUES ('8152', 'sn701', '31048.00');
INSERT INTO `mx_balance` VALUES ('8153', 'sn701', '31038.00');
INSERT INTO `mx_balance` VALUES ('8154', 'sn701', '31008.00');
INSERT INTO `mx_balance` VALUES ('8155', 'sn701', '30808.00');
INSERT INTO `mx_balance` VALUES ('8156', 'sn701', '30788.00');
INSERT INTO `mx_balance` VALUES ('8157', 'sn701', '30728.00');
INSERT INTO `mx_balance` VALUES ('8158', 'sn701', '30708.00');
INSERT INTO `mx_balance` VALUES ('8159', 'sn701', '30688.00');
INSERT INTO `mx_balance` VALUES ('8160', 'sn701', '31488.00');
INSERT INTO `mx_balance` VALUES ('8161', 'sn701', '31388.00');
INSERT INTO `mx_balance` VALUES ('8162', 'sn701', '31358.00');
INSERT INTO `mx_balance` VALUES ('8163', 'sn701', '31338.00');
INSERT INTO `mx_balance` VALUES ('8164', 'sn703', '47573.00');
INSERT INTO `mx_balance` VALUES ('8165', 'sn701', '31318.00');
INSERT INTO `mx_balance` VALUES ('8166', 'sn701', '31278.00');
INSERT INTO `mx_balance` VALUES ('8167', 'sn701', '31198.00');
INSERT INTO `mx_balance` VALUES ('8168', 'sn701', '31118.00');
INSERT INTO `mx_balance` VALUES ('8169', 'sn701', '31038.00');
INSERT INTO `mx_balance` VALUES ('8170', 'sn701', '31028.00');
INSERT INTO `mx_balance` VALUES ('8171', 'sn701', '30998.00');
INSERT INTO `mx_balance` VALUES ('8172', 'sn701', '30968.00');
INSERT INTO `mx_balance` VALUES ('8173', 'sn701', '30948.00');
INSERT INTO `mx_balance` VALUES ('8174', 'sn701', '30928.00');
INSERT INTO `mx_balance` VALUES ('8175', 'sn701', '30908.00');
INSERT INTO `mx_balance` VALUES ('8176', 'sn703', '47568.00');
INSERT INTO `mx_balance` VALUES ('8177', 'sn703', '47558.00');
INSERT INTO `mx_balance` VALUES ('8178', 'sn703', '47548.00');
INSERT INTO `mx_balance` VALUES ('8179', 'sn701', '30888.00');
INSERT INTO `mx_balance` VALUES ('8180', 'sn701', '30878.00');
INSERT INTO `mx_balance` VALUES ('8181', 'sn701', '30858.00');
INSERT INTO `mx_balance` VALUES ('8182', 'sn701', '30838.00');
INSERT INTO `mx_balance` VALUES ('8183', 'sn701', '30828.00');
INSERT INTO `mx_balance` VALUES ('8184', 'sn701', '30798.00');
INSERT INTO `mx_balance` VALUES ('8185', 'sn703', '47538.00');
INSERT INTO `mx_balance` VALUES ('8186', 'sn701', '30748.00');
INSERT INTO `mx_balance` VALUES ('8187', 'sn701', '30718.00');
INSERT INTO `mx_balance` VALUES ('8188', 'sn701', '30648.00');
INSERT INTO `mx_balance` VALUES ('8189', 'sn701', '30628.00');
INSERT INTO `mx_balance` VALUES ('8190', 'sn701', '30608.00');
INSERT INTO `mx_balance` VALUES ('8191', 'sn701', '30598.00');
INSERT INTO `mx_balance` VALUES ('8192', 'sn701', '30548.00');
INSERT INTO `mx_balance` VALUES ('8193', 'sn701', '30538.00');
INSERT INTO `mx_balance` VALUES ('8194', 'sn701', '30528.00');
INSERT INTO `mx_balance` VALUES ('8195', 'sn703', '47528.00');
INSERT INTO `mx_balance` VALUES ('8196', 'sn701', '30518.00');
INSERT INTO `mx_balance` VALUES ('8197', 'sn701', '30468.00');
INSERT INTO `mx_balance` VALUES ('8198', 'sn701', '30398.00');
INSERT INTO `mx_balance` VALUES ('8199', 'sn701', '30378.00');
INSERT INTO `mx_balance` VALUES ('8200', 'sn701', '30328.00');
INSERT INTO `mx_balance` VALUES ('8201', 'sn701', '30428.00');
INSERT INTO `mx_balance` VALUES ('8202', 'sn701', '30398.00');
INSERT INTO `mx_balance` VALUES ('8203', 'sn701', '30368.00');
INSERT INTO `mx_balance` VALUES ('8204', 'sn703', '47523.00');
INSERT INTO `mx_balance` VALUES ('8205', 'sn701', '30358.00');
INSERT INTO `mx_balance` VALUES ('8206', 'sn701', '30258.00');
INSERT INTO `mx_balance` VALUES ('8207', 'sn701', '30168.00');
INSERT INTO `mx_balance` VALUES ('8208', 'sn701', '30158.00');
INSERT INTO `mx_balance` VALUES ('8209', 'sn701', '30138.00');
INSERT INTO `mx_balance` VALUES ('8210', 'sn703', '47518.00');
INSERT INTO `mx_balance` VALUES ('8211', 'sn701', '30238.00');
INSERT INTO `mx_balance` VALUES ('8212', 'sn701', '30208.00');
INSERT INTO `mx_balance` VALUES ('8213', 'sn701', '30188.00');
INSERT INTO `mx_balance` VALUES ('8214', 'sn701', '30148.00');
INSERT INTO `mx_balance` VALUES ('8215', 'sn701', '30138.00');
INSERT INTO `mx_balance` VALUES ('8216', 'sn701', '30088.00');
INSERT INTO `mx_balance` VALUES ('8217', 'sn701', '30078.00');
INSERT INTO `mx_balance` VALUES ('8218', 'sn701', '30178.00');
INSERT INTO `mx_balance` VALUES ('8219', 'sn701', '30138.00');
INSERT INTO `mx_balance` VALUES ('8220', 'sn701', '30098.00');
INSERT INTO `mx_balance` VALUES ('8221', 'sn701', '30058.00');
INSERT INTO `mx_balance` VALUES ('8222', 'sn701', '30038.00');
INSERT INTO `mx_balance` VALUES ('8223', 'sn701', '29948.00');
INSERT INTO `mx_balance` VALUES ('8224', 'sn701', '29938.00');
INSERT INTO `mx_balance` VALUES ('8225', 'sn701', '30038.00');
INSERT INTO `mx_balance` VALUES ('8226', 'sn701', '30008.00');
INSERT INTO `mx_balance` VALUES ('8227', 'sn701', '29998.00');
INSERT INTO `mx_balance` VALUES ('8228', 'sn701', '29938.00');
INSERT INTO `mx_balance` VALUES ('8229', 'sn701', '29918.00');
INSERT INTO `mx_balance` VALUES ('8230', 'sn701', '29908.00');
INSERT INTO `mx_balance` VALUES ('8231', 'sn701', '29868.00');
INSERT INTO `mx_balance` VALUES ('8232', 'sn701', '29858.00');
INSERT INTO `mx_balance` VALUES ('8233', 'sn701', '29838.00');
INSERT INTO `mx_balance` VALUES ('8234', 'sn701', '29828.00');
INSERT INTO `mx_balance` VALUES ('8235', 'expert132', '144345.00');
INSERT INTO `mx_balance` VALUES ('8236', 'expert132', '144295.00');
INSERT INTO `mx_balance` VALUES ('8237', 'expert132', '144245.00');
INSERT INTO `mx_balance` VALUES ('8238', 'expert132', '144195.00');
INSERT INTO `mx_balance` VALUES ('8239', 'expert132', '144145.00');
INSERT INTO `mx_balance` VALUES ('8240', 'expert132', '144095.00');
INSERT INTO `mx_balance` VALUES ('8241', 'expert132', '144045.00');
INSERT INTO `mx_balance` VALUES ('8242', 'expert132', '143995.00');
INSERT INTO `mx_balance` VALUES ('8243', 'expert132', '143945.00');
INSERT INTO `mx_balance` VALUES ('8244', 'expert132', '143895.00');
INSERT INTO `mx_balance` VALUES ('8245', 'expert132', '143845.00');
INSERT INTO `mx_balance` VALUES ('8246', 'expert132', '144145.00');
INSERT INTO `mx_balance` VALUES ('8247', 'expert132', '144095.00');
INSERT INTO `mx_balance` VALUES ('8248', 'expert132', '144045.00');
INSERT INTO `mx_balance` VALUES ('8249', 'expert132', '143995.00');
INSERT INTO `mx_balance` VALUES ('8250', 'expert132', '143945.00');
INSERT INTO `mx_balance` VALUES ('8251', 'expert132', '144045.00');
INSERT INTO `mx_balance` VALUES ('8252', 'expert132', '144145.00');
INSERT INTO `mx_balance` VALUES ('8253', 'expert132', '144345.00');
INSERT INTO `mx_balance` VALUES ('8254', 'expert132', '144545.00');
INSERT INTO `mx_balance` VALUES ('8255', 'expert132', '144645.00');
INSERT INTO `mx_balance` VALUES ('8256', 'expert132', '144595.00');
INSERT INTO `mx_balance` VALUES ('8257', 'expert132', '144795.00');
INSERT INTO `mx_balance` VALUES ('8258', 'expert132', '144745.00');
INSERT INTO `mx_balance` VALUES ('8259', 'expert132', '145045.00');
INSERT INTO `mx_balance` VALUES ('8260', 'expert132', '144995.00');
INSERT INTO `mx_balance` VALUES ('8261', 'expert132', '145395.00');
INSERT INTO `mx_balance` VALUES ('8262', 'sn703', '47508.00');
INSERT INTO `mx_balance` VALUES ('8263', 'sn703', '47498.00');
INSERT INTO `mx_balance` VALUES ('8264', 'sn703', '47483.00');
INSERT INTO `mx_balance` VALUES ('8265', 'sn703', '47473.00');
INSERT INTO `mx_balance` VALUES ('8266', 'sn703', '47468.00');
INSERT INTO `mx_balance` VALUES ('8267', 'sn703', '47458.00');
INSERT INTO `mx_balance` VALUES ('8268', 'sn703', '47448.00');
INSERT INTO `mx_balance` VALUES ('8269', 'sn703', '47443.00');
INSERT INTO `mx_balance` VALUES ('8270', 'sn703', '47438.00');
INSERT INTO `mx_balance` VALUES ('8271', 'sn703', '47428.00');
INSERT INTO `mx_balance` VALUES ('8272', 'sn701', '29818.00');
INSERT INTO `mx_balance` VALUES ('8273', 'sn701', '29798.00');
INSERT INTO `mx_balance` VALUES ('8274', 'sn701', '29788.00');
INSERT INTO `mx_balance` VALUES ('8275', 'sn701', '29778.00');
INSERT INTO `mx_balance` VALUES ('8276', 'sn701', '29768.00');
INSERT INTO `mx_balance` VALUES ('8277', 'sn701', '29758.00');
INSERT INTO `mx_balance` VALUES ('8278', 'sn701', '29748.00');
INSERT INTO `mx_balance` VALUES ('8279', 'sn701', '29738.00');
INSERT INTO `mx_balance` VALUES ('8280', 'sn701', '29728.00');
INSERT INTO `mx_balance` VALUES ('8281', 'sn701', '29718.00');
INSERT INTO `mx_balance` VALUES ('8282', 'sn701', '29668.00');
INSERT INTO `mx_balance` VALUES ('8283', 'sn701', '29638.00');
INSERT INTO `mx_balance` VALUES ('8284', 'sn701', '29628.00');
INSERT INTO `mx_balance` VALUES ('8285', 'sn701', '29528.00');
INSERT INTO `mx_balance` VALUES ('8286', 'sn701', '29508.00');
INSERT INTO `mx_balance` VALUES ('8287', 'sn701', '29498.00');
INSERT INTO `mx_balance` VALUES ('8288', 'sn701', '29488.00');
INSERT INTO `mx_balance` VALUES ('8289', 'sn701', '29368.00');
INSERT INTO `mx_balance` VALUES ('8290', 'sn701', '29358.00');
INSERT INTO `mx_balance` VALUES ('8291', 'sn701', '29268.00');
INSERT INTO `mx_balance` VALUES ('8292', 'sn701', '29258.00');
INSERT INTO `mx_balance` VALUES ('8293', 'sn701', '29158.00');
INSERT INTO `mx_balance` VALUES ('8294', 'sn701', '29148.00');
INSERT INTO `mx_balance` VALUES ('8295', 'sn701', '29048.00');
INSERT INTO `mx_balance` VALUES ('8296', 'sn703', '47368.00');
INSERT INTO `mx_balance` VALUES ('8297', 'sn703', '47328.00');
INSERT INTO `mx_balance` VALUES ('8298', 'sn703', '47268.00');
INSERT INTO `mx_balance` VALUES ('8299', 'sn701', '29038.00');
INSERT INTO `mx_balance` VALUES ('8300', 'sn703', '47368.00');
INSERT INTO `mx_balance` VALUES ('8301', 'sn703', '47288.00');
INSERT INTO `mx_balance` VALUES ('8302', 'sn703', '47228.00');
INSERT INTO `mx_balance` VALUES ('8303', 'sn703', '47168.00');
INSERT INTO `mx_balance` VALUES ('8304', 'sn703', '47268.00');
INSERT INTO `mx_balance` VALUES ('8305', 'sn703', '47168.00');
INSERT INTO `mx_balance` VALUES ('8306', 'sn703', '47068.00');
INSERT INTO `mx_balance` VALUES ('8307', 'sn703', '46948.00');
INSERT INTO `mx_balance` VALUES ('8308', 'sn703', '46828.00');
INSERT INTO `mx_balance` VALUES ('8309', 'sn703', '46928.00');
INSERT INTO `mx_balance` VALUES ('8310', 'sn703', '46728.00');
INSERT INTO `mx_balance` VALUES ('8311', 'sn703', '46568.00');
INSERT INTO `mx_balance` VALUES ('8312', 'sn703', '46768.00');
INSERT INTO `mx_balance` VALUES ('8313', 'sn703', '46748.00');
INSERT INTO `mx_balance` VALUES ('8314', 'sn703', '46728.00');
INSERT INTO `mx_balance` VALUES ('8315', 'sn701', '29018.00');
INSERT INTO `mx_balance` VALUES ('8316', 'sn703', '46718.00');
INSERT INTO `mx_balance` VALUES ('8317', 'sn701', '28998.00');
INSERT INTO `mx_balance` VALUES ('8318', 'Sn704', '9477.00');
INSERT INTO `mx_balance` VALUES ('8319', 'sn702', '47510.00');
INSERT INTO `mx_balance` VALUES ('8320', 'Sn704', '9472.00');
INSERT INTO `mx_balance` VALUES ('8321', 'sn702', '47500.00');
INSERT INTO `mx_balance` VALUES ('8322', 'sn703', '46668.00');
INSERT INTO `mx_balance` VALUES ('8323', 'sn703', '46618.00');
INSERT INTO `mx_balance` VALUES ('8324', 'sn703', '46718.00');
INSERT INTO `mx_balance` VALUES ('8325', 'sn703', '46668.00');
INSERT INTO `mx_balance` VALUES ('8326', 'sn703', '46618.00');
INSERT INTO `mx_balance` VALUES ('8327', 'sn701', '28968.00');
INSERT INTO `mx_balance` VALUES ('8328', 'sn701', '28958.00');
INSERT INTO `mx_balance` VALUES ('8329', 'sn703', '46718.00');
INSERT INTO `mx_balance` VALUES ('8330', 'sn701', '28928.00');
INSERT INTO `mx_balance` VALUES ('8331', 'sn702', '47470.00');
INSERT INTO `mx_balance` VALUES ('8332', 'sn701', '28918.00');
INSERT INTO `mx_balance` VALUES ('8333', 'sn701', '28858.00');
INSERT INTO `mx_balance` VALUES ('8334', 'sn701', '28848.00');
INSERT INTO `mx_balance` VALUES ('8335', 'sn701', '28828.00');
INSERT INTO `mx_balance` VALUES ('8336', 'sn701', '28788.00');
INSERT INTO `mx_balance` VALUES ('8337', 'sn701', '28758.00');
INSERT INTO `mx_balance` VALUES ('8338', 'sn701', '28748.00');
INSERT INTO `mx_balance` VALUES ('8339', 'sn702', '47430.00');
INSERT INTO `mx_balance` VALUES ('8340', 'sn701', '28708.00');
INSERT INTO `mx_balance` VALUES ('8341', 'sn701', '28698.00');
INSERT INTO `mx_balance` VALUES ('8342', 'sn701', '28668.00');
INSERT INTO `mx_balance` VALUES ('8343', 'sn701', '28658.00');
INSERT INTO `mx_balance` VALUES ('8344', 'sn701', '28648.00');
INSERT INTO `mx_balance` VALUES ('8345', 'sn703', '46708.00');
INSERT INTO `mx_balance` VALUES ('8346', 'sn703', '46698.00');
INSERT INTO `mx_balance` VALUES ('8347', 'sn701', '28628.00');
INSERT INTO `mx_balance` VALUES ('8348', 'sn702', '47390.00');
INSERT INTO `mx_balance` VALUES ('8349', 'sn702', '47350.00');
INSERT INTO `mx_balance` VALUES ('8350', 'sn702', '47310.00');
INSERT INTO `mx_balance` VALUES ('8351', 'sn703', '46688.00');
INSERT INTO `mx_balance` VALUES ('8352', 'sn703', '46658.00');
INSERT INTO `mx_balance` VALUES ('8353', 'sn702', '47270.00');
INSERT INTO `mx_balance` VALUES ('8354', 'sn701', '28578.00');
INSERT INTO `mx_balance` VALUES ('8355', 'sn701', '28558.00');
INSERT INTO `mx_balance` VALUES ('8356', 'sn701', '28658.00');
INSERT INTO `mx_balance` VALUES ('8357', 'sn701', '28648.00');
INSERT INTO `mx_balance` VALUES ('8358', 'sn703', '46648.00');
INSERT INTO `mx_balance` VALUES ('8359', 'sn702', '47230.00');
INSERT INTO `mx_balance` VALUES ('8360', 'sn702', '47210.00');
INSERT INTO `mx_balance` VALUES ('8361', 'sn702', '47200.00');
INSERT INTO `mx_balance` VALUES ('8362', 'sn702', '47100.00');
INSERT INTO `mx_balance` VALUES ('8363', 'sn702', '47020.00');
INSERT INTO `mx_balance` VALUES ('8364', 'sn702', '47010.00');
INSERT INTO `mx_balance` VALUES ('8365', 'sn702', '47110.00');
INSERT INTO `mx_balance` VALUES ('8366', 'sn702', '47010.00');
INSERT INTO `mx_balance` VALUES ('8367', 'sn702', '46850.00');
INSERT INTO `mx_balance` VALUES ('8368', 'sn702', '46840.00');
INSERT INTO `mx_balance` VALUES ('8369', 'sn702', '47340.00');
INSERT INTO `mx_balance` VALUES ('8370', 'sn701', '28638.00');
INSERT INTO `mx_balance` VALUES ('8371', 'sn702', '47240.00');
INSERT INTO `mx_balance` VALUES ('8372', 'sn702', '47170.00');
INSERT INTO `mx_balance` VALUES ('8373', 'sn702', '47370.00');
INSERT INTO `mx_balance` VALUES ('8374', 'sn702', '47270.00');
INSERT INTO `mx_balance` VALUES ('8375', 'sn702', '47200.00');
INSERT INTO `mx_balance` VALUES ('8376', 'sn702', '47180.00');
INSERT INTO `mx_balance` VALUES ('8377', 'sn702', '47170.00');
INSERT INTO `mx_balance` VALUES ('8378', 'sn702', '47270.00');
INSERT INTO `mx_balance` VALUES ('8379', 'sn701', '28618.00');
INSERT INTO `mx_balance` VALUES ('8380', 'sn702', '47170.00');
INSERT INTO `mx_balance` VALUES ('8381', 'sn702', '47100.00');
INSERT INTO `mx_balance` VALUES ('8382', 'sn701', '28608.00');
INSERT INTO `mx_balance` VALUES ('8383', 'sn702', '47070.00');
INSERT INTO `mx_balance` VALUES ('8384', 'sn702', '47060.00');
INSERT INTO `mx_balance` VALUES ('8385', 'sn702', '47160.00');
INSERT INTO `mx_balance` VALUES ('8386', 'sn702', '47060.00');
INSERT INTO `mx_balance` VALUES ('8387', 'sn702', '46980.00');
INSERT INTO `mx_balance` VALUES ('8388', 'sn701', '28598.00');
INSERT INTO `mx_balance` VALUES ('8389', 'sn702', '46960.00');
INSERT INTO `mx_balance` VALUES ('8390', 'sn702', '46910.00');
INSERT INTO `mx_balance` VALUES ('8391', 'sn702', '46880.00');
INSERT INTO `mx_balance` VALUES ('8392', 'sn702', '46870.00');
INSERT INTO `mx_balance` VALUES ('8393', 'sn702', '46820.00');
INSERT INTO `mx_balance` VALUES ('8394', 'sn701', '28698.00');
INSERT INTO `mx_balance` VALUES ('8395', 'sn702', '47320.00');
INSERT INTO `mx_balance` VALUES ('8396', 'sn702', '47220.00');
INSERT INTO `mx_balance` VALUES ('8397', 'sn702', '47150.00');
INSERT INTO `mx_balance` VALUES ('8398', 'sn702', '47100.00');
INSERT INTO `mx_balance` VALUES ('8399', 'sn702', '47070.00');
INSERT INTO `mx_balance` VALUES ('8400', 'sn701', '28678.00');
INSERT INTO `mx_balance` VALUES ('8401', 'sn702', '47040.00');
INSERT INTO `mx_balance` VALUES ('8402', 'sn702', '47540.00');
INSERT INTO `mx_balance` VALUES ('8403', 'sn702', '47640.00');
INSERT INTO `mx_balance` VALUES ('8404', 'sn701', '28658.00');
INSERT INTO `mx_balance` VALUES ('8405', 'sn702', '47540.00');
INSERT INTO `mx_balance` VALUES ('8406', 'sn702', '47520.00');
INSERT INTO `mx_balance` VALUES ('8407', 'sn702', '47500.00');
INSERT INTO `mx_balance` VALUES ('8408', 'sn702', '47430.00');
INSERT INTO `mx_balance` VALUES ('8409', 'sn702', '47530.00');
INSERT INTO `mx_balance` VALUES ('8410', 'sn702', '47430.00');
INSERT INTO `mx_balance` VALUES ('8411', 'sn701', '28628.00');
INSERT INTO `mx_balance` VALUES ('8412', 'sn702', '47360.00');
INSERT INTO `mx_balance` VALUES ('8413', 'sn702', '47310.00');
INSERT INTO `mx_balance` VALUES ('8414', 'sn703', '46618.00');
INSERT INTO `mx_balance` VALUES ('8415', 'sn702', '47280.00');
INSERT INTO `mx_balance` VALUES ('8416', 'sn703', '46718.00');
INSERT INTO `mx_balance` VALUES ('8417', 'sn702', '47380.00');
INSERT INTO `mx_balance` VALUES ('8418', 'sn702', '47280.00');
INSERT INTO `mx_balance` VALUES ('8419', 'sn702', '47210.00');
INSERT INTO `mx_balance` VALUES ('8420', 'sn702', '47160.00');
INSERT INTO `mx_balance` VALUES ('8421', 'sn702', '47130.00');
INSERT INTO `mx_balance` VALUES ('8422', 'sn702', '47080.00');
INSERT INTO `mx_balance` VALUES ('8423', 'sn702', '47180.00');
INSERT INTO `mx_balance` VALUES ('8424', 'sn702', '47280.00');
INSERT INTO `mx_balance` VALUES ('8425', 'sn702', '47380.00');
INSERT INTO `mx_balance` VALUES ('8426', 'sn702', '47480.00');
INSERT INTO `mx_balance` VALUES ('8427', 'sn702', '47380.00');
INSERT INTO `mx_balance` VALUES ('8428', 'sn702', '47280.00');
INSERT INTO `mx_balance` VALUES ('8429', 'sn702', '47180.00');
INSERT INTO `mx_balance` VALUES ('8430', 'sn702', '47110.00');
INSERT INTO `mx_balance` VALUES ('8431', 'sn702', '47060.00');
INSERT INTO `mx_balance` VALUES ('8432', 'sn703', '46698.00');
INSERT INTO `mx_balance` VALUES ('8433', 'sn702', '47030.00');
INSERT INTO `mx_balance` VALUES ('8434', 'sn703', '46678.00');
INSERT INTO `mx_balance` VALUES ('8435', 'sn702', '46930.00');
INSERT INTO `mx_balance` VALUES ('8436', 'sn702', '46860.00');
INSERT INTO `mx_balance` VALUES ('8437', 'sn702', '46960.00');
INSERT INTO `mx_balance` VALUES ('8438', 'sn702', '46860.00');
INSERT INTO `mx_balance` VALUES ('8439', 'sn702', '46790.00');
INSERT INTO `mx_balance` VALUES ('8440', 'sn702', '46760.00');
INSERT INTO `mx_balance` VALUES ('8441', 'sn702', '46710.00');
INSERT INTO `mx_balance` VALUES ('8442', 'sn703', '46658.00');
INSERT INTO `mx_balance` VALUES ('8443', 'sn703', '46648.00');
INSERT INTO `mx_balance` VALUES ('8444', 'sn702', '46670.00');
INSERT INTO `mx_balance` VALUES ('8445', 'sn702', '46630.00');
INSERT INTO `mx_balance` VALUES ('8446', 'sn701', '28618.00');
INSERT INTO `mx_balance` VALUES ('8447', 'sn702', '46620.00');
INSERT INTO `mx_balance` VALUES ('8448', 'sn702', '46610.00');
INSERT INTO `mx_balance` VALUES ('8449', 'sn701', '28608.00');
INSERT INTO `mx_balance` VALUES ('8450', 'sn703', '46628.00');
INSERT INTO `mx_balance` VALUES ('8451', 'sn703', '46618.00');
INSERT INTO `mx_balance` VALUES ('8452', 'sn702', '46710.00');
INSERT INTO `mx_balance` VALUES ('8453', 'sn702', '46810.00');
INSERT INTO `mx_balance` VALUES ('8454', 'sn702', '46710.00');
INSERT INTO `mx_balance` VALUES ('8455', 'sn702', '46640.00');
INSERT INTO `mx_balance` VALUES ('8456', 'sn702', '46740.00');
INSERT INTO `mx_balance` VALUES ('8457', 'sn702', '46640.00');
INSERT INTO `mx_balance` VALUES ('8458', 'sn702', '46570.00');
INSERT INTO `mx_balance` VALUES ('8459', 'sn702', '46970.00');
INSERT INTO `mx_balance` VALUES ('8460', 'sn702', '46920.00');
INSERT INTO `mx_balance` VALUES ('8461', 'sn702', '46820.00');
INSERT INTO `mx_balance` VALUES ('8462', 'sn702', '46770.00');
INSERT INTO `mx_balance` VALUES ('8463', 'sn702', '46700.00');
INSERT INTO `mx_balance` VALUES ('8464', 'sn702', '46800.00');
INSERT INTO `mx_balance` VALUES ('8465', 'sn702', '46700.00');
INSERT INTO `mx_balance` VALUES ('8466', 'sn702', '46630.00');
INSERT INTO `mx_balance` VALUES ('8467', 'sn702', '46730.00');
INSERT INTO `mx_balance` VALUES ('8468', 'sn702', '46630.00');
INSERT INTO `mx_balance` VALUES ('8469', 'sn702', '46560.00');
INSERT INTO `mx_balance` VALUES ('8470', 'sn702', '46550.00');
INSERT INTO `mx_balance` VALUES ('8471', 'sn701', '28598.00');
INSERT INTO `mx_balance` VALUES ('8472', 'sn702', '46650.00');
INSERT INTO `mx_balance` VALUES ('8473', 'sn703', '46598.00');
INSERT INTO `mx_balance` VALUES ('8474', 'sn701', '28588.00');
INSERT INTO `mx_balance` VALUES ('8475', 'sn702', '46640.00');
INSERT INTO `mx_balance` VALUES ('8476', 'sn703', '46578.00');
INSERT INTO `mx_balance` VALUES ('8477', 'sn702', '46630.00');
INSERT INTO `mx_balance` VALUES ('8478', 'sn702', '46620.00');
INSERT INTO `mx_balance` VALUES ('8479', 'sn702', '46610.00');
INSERT INTO `mx_balance` VALUES ('8480', 'sn702', '46600.00');
INSERT INTO `mx_balance` VALUES ('8481', 'sn702', '46590.00');
INSERT INTO `mx_balance` VALUES ('8482', 'sn702', '46570.00');
INSERT INTO `mx_balance` VALUES ('8483', 'sn702', '46560.00');
INSERT INTO `mx_balance` VALUES ('8484', 'sn702', '46550.00');
INSERT INTO `mx_balance` VALUES ('8485', 'sn702', '46450.00');
INSERT INTO `mx_balance` VALUES ('8486', 'sn702', '46380.00');
INSERT INTO `mx_balance` VALUES ('8487', 'sn702', '46360.00');
INSERT INTO `mx_balance` VALUES ('8488', 'sn702', '46350.00');
INSERT INTO `mx_balance` VALUES ('8489', 'sn702', '46450.00');
INSERT INTO `mx_balance` VALUES ('8490', 'sn702', '46350.00');
INSERT INTO `mx_balance` VALUES ('8491', 'sn702', '46280.00');
INSERT INTO `mx_balance` VALUES ('8492', 'sn702', '46260.00');
INSERT INTO `mx_balance` VALUES ('8493', 'sn701', '28578.00');
INSERT INTO `mx_balance` VALUES ('8494', 'sn702', '46240.00');
INSERT INTO `mx_balance` VALUES ('8495', 'sn702', '46340.00');
INSERT INTO `mx_balance` VALUES ('8496', 'sn702', '46440.00');
INSERT INTO `mx_balance` VALUES ('8497', 'sn701', '28568.00');
INSERT INTO `mx_balance` VALUES ('8498', 'sn702', '46420.00');
INSERT INTO `mx_balance` VALUES ('8499', 'sn702', '46390.00');
INSERT INTO `mx_balance` VALUES ('8500', 'sn702', '46380.00');
INSERT INTO `mx_balance` VALUES ('8501', 'sn702', '46480.00');
INSERT INTO `mx_balance` VALUES ('8502', 'sn702', '46470.00');
INSERT INTO `mx_balance` VALUES ('8503', 'sn702', '46450.00');
INSERT INTO `mx_balance` VALUES ('8504', 'sn702', '46430.00');
INSERT INTO `mx_balance` VALUES ('8505', 'sn702', '46530.00');
INSERT INTO `mx_balance` VALUES ('8506', 'sn702', '46520.00');
INSERT INTO `mx_balance` VALUES ('8507', 'sn702', '46510.00');
INSERT INTO `mx_balance` VALUES ('8508', 'sn702', '46490.00');
INSERT INTO `mx_balance` VALUES ('8509', 'sn702', '46590.00');
INSERT INTO `mx_balance` VALUES ('8510', 'sn702', '46580.00');
INSERT INTO `mx_balance` VALUES ('8511', 'sn702', '46560.00');
INSERT INTO `mx_balance` VALUES ('8512', 'sn702', '46540.00');
INSERT INTO `mx_balance` VALUES ('8513', 'sn702', '46640.00');
INSERT INTO `mx_balance` VALUES ('8514', 'sn702', '46630.00');
INSERT INTO `mx_balance` VALUES ('8515', 'sn702', '46610.00');
INSERT INTO `mx_balance` VALUES ('8516', 'sn702', '46590.00');
INSERT INTO `mx_balance` VALUES ('8517', 'sn702', '46690.00');
INSERT INTO `mx_balance` VALUES ('8518', 'sn702', '46670.00');
INSERT INTO `mx_balance` VALUES ('8519', 'sn702', '46650.00');
INSERT INTO `mx_balance` VALUES ('8520', 'sn702', '46640.00');
INSERT INTO `mx_balance` VALUES ('8521', 'sn702', '46630.00');
INSERT INTO `mx_balance` VALUES ('8522', 'sn702', '46730.00');
INSERT INTO `mx_balance` VALUES ('8523', 'sn702', '46720.00');
INSERT INTO `mx_balance` VALUES ('8524', 'sn702', '46710.00');
INSERT INTO `mx_balance` VALUES ('8525', 'sn703', '46558.00');
INSERT INTO `mx_balance` VALUES ('8526', 'sn702', '46690.00');
INSERT INTO `mx_balance` VALUES ('8527', 'sn702', '46670.00');
INSERT INTO `mx_balance` VALUES ('8528', 'sn702', '46660.00');
INSERT INTO `mx_balance` VALUES ('8529', 'sn702', '46650.00');
INSERT INTO `mx_balance` VALUES ('8530', 'sn702', '46750.00');
INSERT INTO `mx_balance` VALUES ('8531', 'sn702', '46740.00');
INSERT INTO `mx_balance` VALUES ('8532', 'sn702', '46720.00');
INSERT INTO `mx_balance` VALUES ('8533', 'sn702', '46700.00');
INSERT INTO `mx_balance` VALUES ('8534', 'sn702', '46690.00');
INSERT INTO `mx_balance` VALUES ('8535', 'sn702', '46790.00');
INSERT INTO `mx_balance` VALUES ('8536', 'sn702', '46780.00');
INSERT INTO `mx_balance` VALUES ('8537', 'sn702', '46760.00');
INSERT INTO `mx_balance` VALUES ('8538', 'sn703', '46538.00');
INSERT INTO `mx_balance` VALUES ('8539', 'sn702', '46740.00');
INSERT INTO `mx_balance` VALUES ('8540', 'sn702', '46720.00');
INSERT INTO `mx_balance` VALUES ('8541', 'sn702', '46820.00');
INSERT INTO `mx_balance` VALUES ('8542', 'sn702', '46800.00');
INSERT INTO `mx_balance` VALUES ('8543', 'sn702', '46780.00');
INSERT INTO `mx_balance` VALUES ('8544', 'sn702', '46880.00');
INSERT INTO `mx_balance` VALUES ('8545', 'sn702', '46860.00');
INSERT INTO `mx_balance` VALUES ('8546', 'sn702', '46840.00');
INSERT INTO `mx_balance` VALUES ('8547', 'sn702', '46830.00');
INSERT INTO `mx_balance` VALUES ('8548', 'sn701', '28558.00');
INSERT INTO `mx_balance` VALUES ('8549', 'sn702', '46800.00');
INSERT INTO `mx_balance` VALUES ('8550', 'sn701', '28548.00');
INSERT INTO `mx_balance` VALUES ('8551', 'sn701', '28538.00');
INSERT INTO `mx_balance` VALUES ('8552', 'sn702', '46790.00');
INSERT INTO `mx_balance` VALUES ('8553', 'sn701', '28518.00');
INSERT INTO `mx_balance` VALUES ('8554', 'sn703', '46528.00');
INSERT INTO `mx_balance` VALUES ('8555', 'sn702', '46780.00');
INSERT INTO `mx_balance` VALUES ('8556', 'sn702', '46760.00');
INSERT INTO `mx_balance` VALUES ('8557', 'sn702', '46750.00');
INSERT INTO `mx_balance` VALUES ('8558', 'sn702', '46740.00');
INSERT INTO `mx_balance` VALUES ('8559', 'sn702', '46720.00');
INSERT INTO `mx_balance` VALUES ('8560', 'sn702', '46700.00');
INSERT INTO `mx_balance` VALUES ('8561', 'sn702', '46680.00');
INSERT INTO `mx_balance` VALUES ('8562', 'sn702', '46670.00');
INSERT INTO `mx_balance` VALUES ('8563', 'sn702', '46650.00');
INSERT INTO `mx_balance` VALUES ('8564', 'sn703', '46518.00');
INSERT INTO `mx_balance` VALUES ('8565', 'sn703', '46508.00');
INSERT INTO `mx_balance` VALUES ('8566', 'sn703', '46498.00');
INSERT INTO `mx_balance` VALUES ('8567', 'sn701', '28488.00');
INSERT INTO `mx_balance` VALUES ('8568', 'sn701', '28468.00');
INSERT INTO `mx_balance` VALUES ('8569', 'sn701', '28448.00');
INSERT INTO `mx_balance` VALUES ('8570', 'sn701', '28428.00');
INSERT INTO `mx_balance` VALUES ('8571', 'sn701', '28418.00');
INSERT INTO `mx_balance` VALUES ('8572', 'sn701', '28398.00');
INSERT INTO `mx_balance` VALUES ('8573', 'sn701', '28368.00');
INSERT INTO `mx_balance` VALUES ('8574', 'sn701', '28338.00');
INSERT INTO `mx_balance` VALUES ('8575', 'sn701', '28318.00');
INSERT INTO `mx_balance` VALUES ('8576', 'sn701', '28298.00');
INSERT INTO `mx_balance` VALUES ('8577', 'sn701', '28288.00');
INSERT INTO `mx_balance` VALUES ('8578', 'sn701', '28278.00');
INSERT INTO `mx_balance` VALUES ('8579', 'sn701', '28268.00');
INSERT INTO `mx_balance` VALUES ('8580', 'sn701', '28248.00');
INSERT INTO `mx_balance` VALUES ('8581', 'sn701', '28228.00');
INSERT INTO `mx_balance` VALUES ('8582', 'sn701', '28198.00');
INSERT INTO `mx_balance` VALUES ('8583', 'sn701', '28188.00');
INSERT INTO `mx_balance` VALUES ('8584', 'sn701', '28178.00');
INSERT INTO `mx_balance` VALUES ('8585', 'Sn704', '9467.00');
INSERT INTO `mx_balance` VALUES ('8586', 'Sn704', '9377.00');
INSERT INTO `mx_balance` VALUES ('8587', 'Sn704', '9367.00');
INSERT INTO `mx_balance` VALUES ('8588', 'Sn704', '9327.00');
INSERT INTO `mx_balance` VALUES ('8589', 'Sn704', '9167.00');
INSERT INTO `mx_balance` VALUES ('8590', 'Sn704', '9137.00');
INSERT INTO `mx_balance` VALUES ('8591', 'sn701', '28168.00');
INSERT INTO `mx_balance` VALUES ('8592', 'sn701', '28148.00');
INSERT INTO `mx_balance` VALUES ('8593', 'Sn704', '9027.00');
INSERT INTO `mx_balance` VALUES ('8594', 'Sn704', '8917.00');
INSERT INTO `mx_balance` VALUES ('8595', 'Sn704', '8797.00');
INSERT INTO `mx_balance` VALUES ('8596', 'sn701', '28128.00');
INSERT INTO `mx_balance` VALUES ('8597', 'Sn704', '8897.00');
INSERT INTO `mx_balance` VALUES ('8598', 'Sn704', '8997.00');
INSERT INTO `mx_balance` VALUES ('8599', 'sn701', '28118.00');
INSERT INTO `mx_balance` VALUES ('8600', 'sn702', '46640.00');
INSERT INTO `mx_balance` VALUES ('8601', 'sn702', '46630.00');
INSERT INTO `mx_balance` VALUES ('8602', 'sn702', '46620.00');
INSERT INTO `mx_balance` VALUES ('8603', 'sn701', '28078.00');
INSERT INTO `mx_balance` VALUES ('8604', 'sn702', '46610.00');
INSERT INTO `mx_balance` VALUES ('8605', 'sn701', '28038.00');
INSERT INTO `mx_balance` VALUES ('8606', 'sn701', '27998.00');
INSERT INTO `mx_balance` VALUES ('8607', 'sn702', '46600.00');
INSERT INTO `mx_balance` VALUES ('8608', 'sn702', '46590.00');
INSERT INTO `mx_balance` VALUES ('8609', 'sn702', '46580.00');
INSERT INTO `mx_balance` VALUES ('8610', 'sn701', '27968.00');
INSERT INTO `mx_balance` VALUES ('8611', 'sn702', '46570.00');
INSERT INTO `mx_balance` VALUES ('8612', 'sn702', '46560.00');
INSERT INTO `mx_balance` VALUES ('8613', 'sn702', '46540.00');
INSERT INTO `mx_balance` VALUES ('8614', 'sn702', '46490.00');
INSERT INTO `mx_balance` VALUES ('8615', 'Sn704', '8957.00');
INSERT INTO `mx_balance` VALUES ('8616', 'sn702', '46440.00');
INSERT INTO `mx_balance` VALUES ('8617', 'sn702', '46420.00');
INSERT INTO `mx_balance` VALUES ('8618', 'Sn704', '8917.00');
INSERT INTO `mx_balance` VALUES ('8619', 'Sn704', '8897.00');
INSERT INTO `mx_balance` VALUES ('8620', 'sn701', '27938.00');
INSERT INTO `mx_balance` VALUES ('8621', 'sn702', '46320.00');
INSERT INTO `mx_balance` VALUES ('8622', 'sn702', '46300.00');
INSERT INTO `mx_balance` VALUES ('8623', 'sn702', '46200.00');
INSERT INTO `mx_balance` VALUES ('8624', 'Sn704', '8867.00');
INSERT INTO `mx_balance` VALUES ('8625', 'sn701', '27848.00');
INSERT INTO `mx_balance` VALUES ('8626', 'sn702', '46180.00');
INSERT INTO `mx_balance` VALUES ('8627', 'Sn704', '8847.00');
INSERT INTO `mx_balance` VALUES ('8628', 'sn701', '27768.00');
INSERT INTO `mx_balance` VALUES ('8629', 'sn702', '46150.00');
INSERT INTO `mx_balance` VALUES ('8630', 'sn702', '46050.00');
INSERT INTO `mx_balance` VALUES ('8631', 'sn701', '27668.00');
INSERT INTO `mx_balance` VALUES ('8632', 'Sn704', '8797.00');
INSERT INTO `mx_balance` VALUES ('8633', 'sn702', '46030.00');
INSERT INTO `mx_balance` VALUES ('8634', 'Sn704', '8777.00');
INSERT INTO `mx_balance` VALUES ('8635', 'sn702', '46020.00');
INSERT INTO `mx_balance` VALUES ('8636', 'sn702', '45920.00');
INSERT INTO `mx_balance` VALUES ('8637', 'Sn704', '8767.00');
INSERT INTO `mx_balance` VALUES ('8638', 'Sn704', '8747.00');
INSERT INTO `mx_balance` VALUES ('8639', 'Sn704', '8707.00');
INSERT INTO `mx_balance` VALUES ('8640', 'Sn704', '8697.00');
INSERT INTO `mx_balance` VALUES ('8641', 'Sn704', '8677.00');
INSERT INTO `mx_balance` VALUES ('8642', 'Sn704', '8667.00');
INSERT INTO `mx_balance` VALUES ('8643', 'Sn704', '8647.00');
INSERT INTO `mx_balance` VALUES ('8644', 'Sn704', '8597.00');
INSERT INTO `mx_balance` VALUES ('8645', 'sn701', '27648.00');
INSERT INTO `mx_balance` VALUES ('8646', 'sn701', '27628.00');
INSERT INTO `mx_balance` VALUES ('8647', 'sn701', '27618.00');
INSERT INTO `mx_balance` VALUES ('8648', 'sn703', '46478.00');
INSERT INTO `mx_balance` VALUES ('8649', 'sn703', '46458.00');
INSERT INTO `mx_balance` VALUES ('8650', 'sn701', '27598.00');
INSERT INTO `mx_balance` VALUES ('8651', 'sn701', '27588.00');
INSERT INTO `mx_balance` VALUES ('8652', 'sn701', '27578.00');
INSERT INTO `mx_balance` VALUES ('8653', 'sn701', '27568.00');
INSERT INTO `mx_balance` VALUES ('8654', 'sn701', '27558.00');
INSERT INTO `mx_balance` VALUES ('8655', 'sn701', '27658.00');
INSERT INTO `mx_balance` VALUES ('8656', 'sn701', '27638.00');
INSERT INTO `mx_balance` VALUES ('8657', 'sn701', '27618.00');
INSERT INTO `mx_balance` VALUES ('8658', 'sn701', '27718.00');
INSERT INTO `mx_balance` VALUES ('8659', 'sn701', '27698.00');
INSERT INTO `mx_balance` VALUES ('8660', 'sn701', '27678.00');
INSERT INTO `mx_balance` VALUES ('8661', 'sn701', '27668.00');
INSERT INTO `mx_balance` VALUES ('8662', 'sn701', '27658.00');
INSERT INTO `mx_balance` VALUES ('8663', 'sn701', '27758.00');
INSERT INTO `mx_balance` VALUES ('8664', 'sn701', '27738.00');
INSERT INTO `mx_balance` VALUES ('8665', 'sn701', '27708.00');
INSERT INTO `mx_balance` VALUES ('8666', 'sn701', '27698.00');
INSERT INTO `mx_balance` VALUES ('8667', 'sn701', '27798.00');
INSERT INTO `mx_balance` VALUES ('8668', 'sn701', '27768.00');
INSERT INTO `mx_balance` VALUES ('8669', 'sn701', '27758.00');
INSERT INTO `mx_balance` VALUES ('8670', 'sn701', '27738.00');
INSERT INTO `mx_balance` VALUES ('8671', 'sn701', '27688.00');
INSERT INTO `mx_balance` VALUES ('8672', 'sn701', '27788.00');
INSERT INTO `mx_balance` VALUES ('8673', 'sn701', '27748.00');
INSERT INTO `mx_balance` VALUES ('8674', 'sn701', '27718.00');
INSERT INTO `mx_balance` VALUES ('8675', 'sn701', '27818.00');
INSERT INTO `mx_balance` VALUES ('8676', 'sn701', '27918.00');
INSERT INTO `mx_balance` VALUES ('8677', 'sn701', '27878.00');
INSERT INTO `mx_balance` VALUES ('8678', 'sn701', '27848.00');
INSERT INTO `mx_balance` VALUES ('8679', 'sn701', '27948.00');
INSERT INTO `mx_balance` VALUES ('8680', 'sn701', '27918.00');
INSERT INTO `mx_balance` VALUES ('8681', 'sn701', '27878.00');
INSERT INTO `mx_balance` VALUES ('8682', 'sn701', '27858.00');
INSERT INTO `mx_balance` VALUES ('8683', 'sn701', '27828.00');
INSERT INTO `mx_balance` VALUES ('8684', 'sn701', '27928.00');
INSERT INTO `mx_balance` VALUES ('8685', 'sn701', '27908.00');
INSERT INTO `mx_balance` VALUES ('8686', 'sn701', '27878.00');
INSERT INTO `mx_balance` VALUES ('8687', 'sn701', '27858.00');
INSERT INTO `mx_balance` VALUES ('8688', 'sn701', '27848.00');
INSERT INTO `mx_balance` VALUES ('8689', 'sn701', '27948.00');
INSERT INTO `mx_balance` VALUES ('8690', 'sn701', '27918.00');
INSERT INTO `mx_balance` VALUES ('8691', 'sn701', '27898.00');
INSERT INTO `mx_balance` VALUES ('8692', 'sn701', '27858.00');
INSERT INTO `mx_balance` VALUES ('8693', 'sn701', '27838.00');
INSERT INTO `mx_balance` VALUES ('8694', 'sn701', '27938.00');
INSERT INTO `mx_balance` VALUES ('8695', 'sn701', '27908.00');
INSERT INTO `mx_balance` VALUES ('8696', 'sn701', '27898.00');
INSERT INTO `mx_balance` VALUES ('8697', 'sn701', '27868.00');
INSERT INTO `mx_balance` VALUES ('8698', 'sn701', '27848.00');
INSERT INTO `mx_balance` VALUES ('8699', 'sn701', '27828.00');
INSERT INTO `mx_balance` VALUES ('8700', 'sn703', '46448.00');
INSERT INTO `mx_balance` VALUES ('8701', 'sn701', '27798.00');
INSERT INTO `mx_balance` VALUES ('8702', 'sn701', '27898.00');
INSERT INTO `mx_balance` VALUES ('8703', 'sn701', '27868.00');
INSERT INTO `mx_balance` VALUES ('8704', 'sn701', '27858.00');
INSERT INTO `mx_balance` VALUES ('8705', 'sn701', '27828.00');
INSERT INTO `mx_balance` VALUES ('8706', 'sn701', '27808.00');
INSERT INTO `mx_balance` VALUES ('8707', 'sn701', '27768.00');
INSERT INTO `mx_balance` VALUES ('8708', 'sn701', '27748.00');
INSERT INTO `mx_balance` VALUES ('8709', 'sn701', '27848.00');
INSERT INTO `mx_balance` VALUES ('8710', 'sn701', '27828.00');
INSERT INTO `mx_balance` VALUES ('8711', 'sn701', '27778.00');
INSERT INTO `mx_balance` VALUES ('8712', 'sn701', '27748.00');
INSERT INTO `mx_balance` VALUES ('8713', 'sn701', '27738.00');
INSERT INTO `mx_balance` VALUES ('8714', 'sn701', '27718.00');
INSERT INTO `mx_balance` VALUES ('8715', 'sn701', '27678.00');
INSERT INTO `mx_balance` VALUES ('8716', 'sn701', '27778.00');
INSERT INTO `mx_balance` VALUES ('8717', 'sn701', '27878.00');
INSERT INTO `mx_balance` VALUES ('8718', 'sn701', '27978.00');
INSERT INTO `mx_balance` VALUES ('8719', 'sn701', '27938.00');
INSERT INTO `mx_balance` VALUES ('8720', 'sn701', '27918.00');
INSERT INTO `mx_balance` VALUES ('8721', 'sn701', '27888.00');
INSERT INTO `mx_balance` VALUES ('8722', 'sn701', '27858.00');
INSERT INTO `mx_balance` VALUES ('8723', 'sn701', '27958.00');
INSERT INTO `mx_balance` VALUES ('8724', 'sn701', '27928.00');
INSERT INTO `mx_balance` VALUES ('8725', 'sn701', '27908.00');
INSERT INTO `mx_balance` VALUES ('8726', 'sn701', '27878.00');
INSERT INTO `mx_balance` VALUES ('8727', 'sn701', '27978.00');
INSERT INTO `mx_balance` VALUES ('8728', 'sn701', '28078.00');
INSERT INTO `mx_balance` VALUES ('8729', 'sn701', '28048.00');
INSERT INTO `mx_balance` VALUES ('8730', 'sn701', '28038.00');
INSERT INTO `mx_balance` VALUES ('8731', 'sn701', '28028.00');
INSERT INTO `mx_balance` VALUES ('8732', 'sn701', '27978.00');
INSERT INTO `mx_balance` VALUES ('8733', 'sn701', '27958.00');
INSERT INTO `mx_balance` VALUES ('8734', 'sn701', '27948.00');
INSERT INTO `mx_balance` VALUES ('8735', 'sn701', '27938.00');
INSERT INTO `mx_balance` VALUES ('8736', 'sn701', '27918.00');
INSERT INTO `mx_balance` VALUES ('8737', 'sn701', '27888.00');
INSERT INTO `mx_balance` VALUES ('8738', 'sn701', '27878.00');
INSERT INTO `mx_balance` VALUES ('8739', 'sn701', '27868.00');
INSERT INTO `mx_balance` VALUES ('8740', 'sn701', '27848.00');
INSERT INTO `mx_balance` VALUES ('8741', 'sn701', '27788.00');
INSERT INTO `mx_balance` VALUES ('8742', 'sn701', '27758.00');
INSERT INTO `mx_balance` VALUES ('8743', 'sn701', '27728.00');
INSERT INTO `mx_balance` VALUES ('8744', 'sn701', '27718.00');
INSERT INTO `mx_balance` VALUES ('8745', 'sn701', '27698.00');
INSERT INTO `mx_balance` VALUES ('8746', 'sn701', '27638.00');
INSERT INTO `mx_balance` VALUES ('8747', 'sn701', '27618.00');
INSERT INTO `mx_balance` VALUES ('8748', 'sn701', '27578.00');
INSERT INTO `mx_balance` VALUES ('8749', 'sn701', '27558.00');
INSERT INTO `mx_balance` VALUES ('8750', 'sn701', '27498.00');
INSERT INTO `mx_balance` VALUES ('8751', 'sn701', '27488.00');
INSERT INTO `mx_balance` VALUES ('8752', 'sn701', '27458.00');
INSERT INTO `mx_balance` VALUES ('8753', 'sn701', '27418.00');
INSERT INTO `mx_balance` VALUES ('8754', 'sn701', '27398.00');
INSERT INTO `mx_balance` VALUES ('8755', 'sn701', '27388.00');
INSERT INTO `mx_balance` VALUES ('8756', 'sn701', '27378.00');
INSERT INTO `mx_balance` VALUES ('8757', 'sn701', '27358.00');
INSERT INTO `mx_balance` VALUES ('8758', 'sn701', '27348.00');
INSERT INTO `mx_balance` VALUES ('8759', 'sn701', '27288.00');
INSERT INTO `mx_balance` VALUES ('8760', 'sn701', '27258.00');
INSERT INTO `mx_balance` VALUES ('8761', 'sn701', '27238.00');
INSERT INTO `mx_balance` VALUES ('8762', 'sn701', '27198.00');
INSERT INTO `mx_balance` VALUES ('8763', 'sn701', '27188.00');
INSERT INTO `mx_balance` VALUES ('8764', 'sn703', '46428.00');
INSERT INTO `mx_balance` VALUES ('8765', 'sn701', '27158.00');
INSERT INTO `mx_balance` VALUES ('8766', 'sn701', '27138.00');
INSERT INTO `mx_balance` VALUES ('8767', 'sn701', '27118.00');
INSERT INTO `mx_balance` VALUES ('8768', 'sn701', '27098.00');
INSERT INTO `mx_balance` VALUES ('8769', 'sn701', '27078.00');
INSERT INTO `mx_balance` VALUES ('8770', 'sn703', '46418.00');
INSERT INTO `mx_balance` VALUES ('8771', 'sn701', '27068.00');
INSERT INTO `mx_balance` VALUES ('8772', 'sn701', '27048.00');
INSERT INTO `mx_balance` VALUES ('8773', 'sn701', '27028.00');
INSERT INTO `mx_balance` VALUES ('8774', 'sn701', '27018.00');
INSERT INTO `mx_balance` VALUES ('8775', 'sn703', '46408.00');
INSERT INTO `mx_balance` VALUES ('8776', 'sn701', '27008.00');
INSERT INTO `mx_balance` VALUES ('8777', 'sn702', '45900.00');
INSERT INTO `mx_balance` VALUES ('8778', 'sn701', '26988.00');
INSERT INTO `mx_balance` VALUES ('8779', 'sn701', '26968.00');
INSERT INTO `mx_balance` VALUES ('8780', 'sn701', '26948.00');
INSERT INTO `mx_balance` VALUES ('8781', 'sn701', '26928.00');
INSERT INTO `mx_balance` VALUES ('8782', 'sn702', '45880.00');
INSERT INTO `mx_balance` VALUES ('8783', 'sn702', '45860.00');
INSERT INTO `mx_balance` VALUES ('8784', 'sn701', '26918.00');
INSERT INTO `mx_balance` VALUES ('8785', 'sn701', '26908.00');
INSERT INTO `mx_balance` VALUES ('8786', 'Sn704', '8592.00');
INSERT INTO `mx_balance` VALUES ('8787', 'Sn704', '8587.00');
INSERT INTO `mx_balance` VALUES ('8788', 'sn702', '45830.00');
INSERT INTO `mx_balance` VALUES ('8789', 'sn701', '26898.00');
INSERT INTO `mx_balance` VALUES ('8790', 'Sn704', '8597.00');
INSERT INTO `mx_balance` VALUES ('8791', 'sn702', '45810.00');
INSERT INTO `mx_balance` VALUES ('8792', 'sn702', '45800.00');
INSERT INTO `mx_balance` VALUES ('8793', 'sn702', '45790.00');
INSERT INTO `mx_balance` VALUES ('8794', 'sn703', '46398.00');
INSERT INTO `mx_balance` VALUES ('8795', 'sn702', '45770.00');
INSERT INTO `mx_balance` VALUES ('8796', 'sn702', '45760.00');
INSERT INTO `mx_balance` VALUES ('8797', 'sn701', '26878.00');
INSERT INTO `mx_balance` VALUES ('8798', 'sn701', '26858.00');
INSERT INTO `mx_balance` VALUES ('8799', 'sn701', '26828.00');
INSERT INTO `mx_balance` VALUES ('8800', 'sn701', '26808.00');
INSERT INTO `mx_balance` VALUES ('8801', 'sn701', '26798.00');
INSERT INTO `mx_balance` VALUES ('8802', 'sn701', '26768.00');
INSERT INTO `mx_balance` VALUES ('8803', 'sn701', '26748.00');
INSERT INTO `mx_balance` VALUES ('8804', 'sn701', '26718.00');
INSERT INTO `mx_balance` VALUES ('8805', 'sn703', '46378.00');
INSERT INTO `mx_balance` VALUES ('8806', 'sn701', '26698.00');
INSERT INTO `mx_balance` VALUES ('8807', 'sn703', '46278.00');
INSERT INTO `mx_balance` VALUES ('8808', 'sn701', '26668.00');
INSERT INTO `mx_balance` VALUES ('8809', 'sn701', '26648.00');
INSERT INTO `mx_balance` VALUES ('8810', 'sn701', '26598.00');
INSERT INTO `mx_balance` VALUES ('8811', 'Sn701', '26578.00');
INSERT INTO `mx_balance` VALUES ('8812', 'Sn701', '26568.00');
INSERT INTO `mx_balance` VALUES ('8813', 'Sn701', '26558.00');
INSERT INTO `mx_balance` VALUES ('8814', 'Sn701', '26538.00');
INSERT INTO `mx_balance` VALUES ('8815', 'sn703', '46268.00');
INSERT INTO `mx_balance` VALUES ('8816', 'Sn701', '26518.00');
INSERT INTO `mx_balance` VALUES ('8817', 'Sn704', '8592.00');
INSERT INTO `mx_balance` VALUES ('8818', 'Sn704', '8587.00');
INSERT INTO `mx_balance` VALUES ('8819', 'Sn701', '26478.00');
INSERT INTO `mx_balance` VALUES ('8820', 'Sn701', '26578.00');
INSERT INTO `mx_balance` VALUES ('8821', 'Sn701', '26498.00');
INSERT INTO `mx_balance` VALUES ('8822', 'Sn701', '26418.00');
INSERT INTO `mx_balance` VALUES ('8823', 'Sn701', '26518.00');
INSERT INTO `mx_balance` VALUES ('8824', 'Sn701', '26498.00');
INSERT INTO `mx_balance` VALUES ('8825', 'Sn701', '26488.00');
INSERT INTO `mx_balance` VALUES ('8826', 'sn703', '46168.00');
INSERT INTO `mx_balance` VALUES ('8827', 'sn703', '46118.00');
INSERT INTO `mx_balance` VALUES ('8828', 'sn703', '46318.00');
INSERT INTO `mx_balance` VALUES ('8829', 'sn703', '46418.00');
INSERT INTO `mx_balance` VALUES ('8830', 'sn703', '46318.00');
INSERT INTO `mx_balance` VALUES ('8831', 'Sn701', '26418.00');
INSERT INTO `mx_balance` VALUES ('8832', 'Sn701', '26618.00');
INSERT INTO `mx_balance` VALUES ('8833', 'sn703', '46518.00');
INSERT INTO `mx_balance` VALUES ('8834', 'Sn701', '26558.00');
INSERT INTO `mx_balance` VALUES ('8835', 'sn703', '46368.00');
INSERT INTO `mx_balance` VALUES ('8836', 'sn703', '46568.00');
INSERT INTO `mx_balance` VALUES ('8837', 'Sn701', '26488.00');
INSERT INTO `mx_balance` VALUES ('8838', 'Sn701', '26478.00');
INSERT INTO `mx_balance` VALUES ('8839', 'Sn701', '26398.00');
INSERT INTO `mx_balance` VALUES ('8840', 'sn703', '46368.00');
INSERT INTO `mx_balance` VALUES ('8841', 'sn703', '46258.00');
INSERT INTO `mx_balance` VALUES ('8842', 'Sn701', '26598.00');
INSERT INTO `mx_balance` VALUES ('8843', 'sn703', '46218.00');
INSERT INTO `mx_balance` VALUES ('8844', 'sn703', '46258.00');
INSERT INTO `mx_balance` VALUES ('8845', 'Sn701', '26498.00');
INSERT INTO `mx_balance` VALUES ('8846', 'sn703', '46658.00');
INSERT INTO `mx_balance` VALUES ('8847', 'Sn701', '26418.00');
INSERT INTO `mx_balance` VALUES ('8848', 'Sn701', '26408.00');
INSERT INTO `mx_balance` VALUES ('8849', 'Sn701', '26608.00');
INSERT INTO `mx_balance` VALUES ('8850', 'Sn701', '26708.00');
INSERT INTO `mx_balance` VALUES ('8851', 'Sn701', '26608.00');
INSERT INTO `mx_balance` VALUES ('8852', 'Sn701', '26598.00');
INSERT INTO `mx_balance` VALUES ('8853', 'Sn701', '26698.00');
INSERT INTO `mx_balance` VALUES ('8854', 'Sn704', '8582.00');
INSERT INTO `mx_balance` VALUES ('8855', 'Sn701', '26608.00');
INSERT INTO `mx_balance` VALUES ('8856', 'Sn701', '26588.00');
INSERT INTO `mx_balance` VALUES ('8857', 'Sn701', '26688.00');
INSERT INTO `mx_balance` VALUES ('8858', 'Sn701', '26668.00');
INSERT INTO `mx_balance` VALUES ('8859', 'Sn701', '26588.00');
INSERT INTO `mx_balance` VALUES ('8860', 'Sn701', '26688.00');
INSERT INTO `mx_balance` VALUES ('8861', 'Sn701', '26598.00');
INSERT INTO `mx_balance` VALUES ('8862', 'Sn701', '26698.00');
INSERT INTO `mx_balance` VALUES ('8863', 'Sn701', '26688.00');
INSERT INTO `mx_balance` VALUES ('8864', 'Sn701', '26638.00');
INSERT INTO `mx_balance` VALUES ('8865', 'Sn701', '26628.00');
INSERT INTO `mx_balance` VALUES ('8866', 'Sn701', '26618.00');
INSERT INTO `mx_balance` VALUES ('8867', 'Sn701', '26718.00');
INSERT INTO `mx_balance` VALUES ('8868', 'Sn701', '26648.00');
INSERT INTO `mx_balance` VALUES ('8869', 'Sn701', '26628.00');
INSERT INTO `mx_balance` VALUES ('8870', 'Sn701', '26618.00');
INSERT INTO `mx_balance` VALUES ('8871', 'Sn701', '26918.00');
INSERT INTO `mx_balance` VALUES ('8872', 'Sn701', '26888.00');
INSERT INTO `mx_balance` VALUES ('8873', 'Sn701', '26848.00');
INSERT INTO `mx_balance` VALUES ('8874', 'Sn701', '26828.00');
INSERT INTO `mx_balance` VALUES ('8875', 'Sn701', '26928.00');
INSERT INTO `mx_balance` VALUES ('8876', 'Sn701', '26908.00');
INSERT INTO `mx_balance` VALUES ('8877', 'Sn701', '26858.00');
INSERT INTO `mx_balance` VALUES ('8878', 'Sn701', '26818.00');
INSERT INTO `mx_balance` VALUES ('8879', 'Sn701', '26798.00');
INSERT INTO `mx_balance` VALUES ('8880', 'Sn701', '26898.00');
INSERT INTO `mx_balance` VALUES ('8881', 'Sn701', '26998.00');
INSERT INTO `mx_balance` VALUES ('8882', 'Sn701', '26948.00');
INSERT INTO `mx_balance` VALUES ('8883', 'Sn701', '26898.00');
INSERT INTO `mx_balance` VALUES ('8884', 'Sn701', '26888.00');
INSERT INTO `mx_balance` VALUES ('8885', 'Sn701', '26988.00');
INSERT INTO `mx_balance` VALUES ('8886', 'Sn701', '27088.00');
INSERT INTO `mx_balance` VALUES ('8887', 'Sn701', '27038.00');
INSERT INTO `mx_balance` VALUES ('8888', 'Sn701', '26988.00');
INSERT INTO `mx_balance` VALUES ('8889', 'Sn701', '26968.00');
INSERT INTO `mx_balance` VALUES ('8890', 'Sn701', '26958.00');
INSERT INTO `mx_balance` VALUES ('8891', 'Sn701', '26908.00');
INSERT INTO `mx_balance` VALUES ('8892', 'Sn701', '27008.00');
INSERT INTO `mx_balance` VALUES ('8893', 'Sn701', '26998.00');
INSERT INTO `mx_balance` VALUES ('8894', 'sn701', '26988.00');
INSERT INTO `mx_balance` VALUES ('8895', 'sn701', '26948.00');
INSERT INTO `mx_balance` VALUES ('8896', 'sn701', '26838.00');
INSERT INTO `mx_balance` VALUES ('8897', 'sn701', '26828.00');
INSERT INTO `mx_balance` VALUES ('8898', 'sn701', '26818.00');
INSERT INTO `mx_balance` VALUES ('8899', 'sn701', '26798.00');
INSERT INTO `mx_balance` VALUES ('8900', 'sn701', '26758.00');
INSERT INTO `mx_balance` VALUES ('8901', 'Sn704', '8532.00');
INSERT INTO `mx_balance` VALUES ('8902', 'Sn704', '8482.00');
INSERT INTO `mx_balance` VALUES ('8903', 'sn702', '45730.00');
INSERT INTO `mx_balance` VALUES ('8904', 'Sn704', '8422.00');
INSERT INTO `mx_balance` VALUES ('8905', 'Sn704', '8362.00');
INSERT INTO `mx_balance` VALUES ('8906', 'Sn704', '8302.00');
INSERT INTO `mx_balance` VALUES ('8907', 'Sn704', '8312.00');
INSERT INTO `mx_balance` VALUES ('8908', 'Sn704', '8302.00');
INSERT INTO `mx_balance` VALUES ('8909', 'sn701', '26748.00');
INSERT INTO `mx_balance` VALUES ('8910', 'sn701', '26728.00');
INSERT INTO `mx_balance` VALUES ('8911', 'sn702', '45720.00');
INSERT INTO `mx_balance` VALUES ('8912', 'sn702', '45710.00');
INSERT INTO `mx_balance` VALUES ('8913', 'sn701', '26718.00');
INSERT INTO `mx_balance` VALUES ('8914', 'sn702', '45700.00');
INSERT INTO `mx_balance` VALUES ('8915', 'sn701', '26708.00');
INSERT INTO `mx_balance` VALUES ('8916', 'sn701', '26698.00');
INSERT INTO `mx_balance` VALUES ('8917', 'sn703', '46618.00');
INSERT INTO `mx_balance` VALUES ('8918', 'sn703', '46608.00');
INSERT INTO `mx_balance` VALUES ('8919', 'sn703', '46548.00');
INSERT INTO `mx_balance` VALUES ('8920', 'sn703', '46528.00');
INSERT INTO `mx_balance` VALUES ('8921', 'sn703', '46518.00');
INSERT INTO `mx_balance` VALUES ('8922', 'sn703', '46468.00');
INSERT INTO `mx_balance` VALUES ('8923', 'sn703', '46458.00');
INSERT INTO `mx_balance` VALUES ('8924', 'sn703', '46438.00');
INSERT INTO `mx_balance` VALUES ('8925', 'sn701', '26688.00');
INSERT INTO `mx_balance` VALUES ('8926', 'sn703', '46368.00');
INSERT INTO `mx_balance` VALUES ('8927', 'sn701', '26668.00');
INSERT INTO `mx_balance` VALUES ('8928', 'sn703', '46338.00');
INSERT INTO `mx_balance` VALUES ('8929', 'sn701', '26648.00');
INSERT INTO `mx_balance` VALUES ('8930', 'sn703', '46298.00');
INSERT INTO `mx_balance` VALUES ('8931', 'sn703', '46398.00');
INSERT INTO `mx_balance` VALUES ('8932', 'sn703', '46358.00');
INSERT INTO `mx_balance` VALUES ('8933', 'sn703', '46458.00');
INSERT INTO `mx_balance` VALUES ('8934', 'sn703', '46418.00');
INSERT INTO `mx_balance` VALUES ('8935', 'sn703', '46518.00');
INSERT INTO `mx_balance` VALUES ('8936', 'sn703', '46468.00');
INSERT INTO `mx_balance` VALUES ('8937', 'sn703', '46418.00');
INSERT INTO `mx_balance` VALUES ('8938', 'sn703', '46518.00');
INSERT INTO `mx_balance` VALUES ('8939', 'sn703', '46448.00');
INSERT INTO `mx_balance` VALUES ('8940', 'sn703', '46378.00');
INSERT INTO `mx_balance` VALUES ('8941', 'sn703', '46368.00');
INSERT INTO `mx_balance` VALUES ('8942', 'sn703', '46468.00');
INSERT INTO `mx_balance` VALUES ('8943', 'sn701', '26638.00');
INSERT INTO `mx_balance` VALUES ('8944', 'sn701', '26628.00');
INSERT INTO `mx_balance` VALUES ('8945', 'sn701', '26608.00');
INSERT INTO `mx_balance` VALUES ('8946', 'sn701', '26598.00');
INSERT INTO `mx_balance` VALUES ('8947', 'sn701', '26588.00');
INSERT INTO `mx_balance` VALUES ('8948', 'sn701', '26568.00');
INSERT INTO `mx_balance` VALUES ('8949', 'sn705', '19900.00');
INSERT INTO `mx_balance` VALUES ('8950', 'sn701', '26558.00');
INSERT INTO `mx_balance` VALUES ('8951', 'sn705', '20000.00');
INSERT INTO `mx_balance` VALUES ('8952', 'sn701', '26538.00');
INSERT INTO `mx_balance` VALUES ('8953', 'Sn704', '8102.00');
INSERT INTO `mx_balance` VALUES ('8954', 'Sn704', '7902.00');
INSERT INTO `mx_balance` VALUES ('8955', 'sn701', '26528.00');
INSERT INTO `mx_balance` VALUES ('8956', 'sn701', '26518.00');
INSERT INTO `mx_balance` VALUES ('8957', 'sn701', '26508.00');
INSERT INTO `mx_balance` VALUES ('8958', 'sn701', '26448.00');
INSERT INTO `mx_balance` VALUES ('8959', 'sn701', '26388.00');
INSERT INTO `mx_balance` VALUES ('8960', 'sn701', '26378.00');
INSERT INTO `mx_balance` VALUES ('8961', 'sn701', '26578.00');
INSERT INTO `mx_balance` VALUES ('8962', 'sn701', '26478.00');
INSERT INTO `mx_balance` VALUES ('8963', 'sn701', '26778.00');
INSERT INTO `mx_balance` VALUES ('8964', 'sn701', '26718.00');
INSERT INTO `mx_balance` VALUES ('8965', 'sn701', '26618.00');
INSERT INTO `mx_balance` VALUES ('8966', 'sn701', '26578.00');
INSERT INTO `mx_balance` VALUES ('8967', 'sn701', '26778.00');
INSERT INTO `mx_balance` VALUES ('8968', 'sn702', '45680.00');
INSERT INTO `mx_balance` VALUES ('8969', 'sn701', '26628.00');
INSERT INTO `mx_balance` VALUES ('8970', 'sn701', '26568.00');
INSERT INTO `mx_balance` VALUES ('8971', 'sn701', '27068.00');
INSERT INTO `mx_balance` VALUES ('8972', 'sn701', '26818.00');
INSERT INTO `mx_balance` VALUES ('8973', 'sn701', '26758.00');
INSERT INTO `mx_balance` VALUES ('8974', 'sn701', '26718.00');
INSERT INTO `mx_balance` VALUES ('8975', 'sn701', '27218.00');
INSERT INTO `mx_balance` VALUES ('8976', 'sn701', '27188.00');
INSERT INTO `mx_balance` VALUES ('8977', 'sn701', '27168.00');
INSERT INTO `mx_balance` VALUES ('8978', 'sn701', '27128.00');
INSERT INTO `mx_balance` VALUES ('8979', 'sn701', '27088.00');
INSERT INTO `mx_balance` VALUES ('8980', 'sn701', '27188.00');
INSERT INTO `mx_balance` VALUES ('8981', 'sn702', '45670.00');
INSERT INTO `mx_balance` VALUES ('8982', 'sn701', '26988.00');
INSERT INTO `mx_balance` VALUES ('8983', 'sn701', '26948.00');
INSERT INTO `mx_balance` VALUES ('8984', 'sn701', '27148.00');
INSERT INTO `mx_balance` VALUES ('8985', 'sn701', '27128.00');
INSERT INTO `mx_balance` VALUES ('8986', 'sn701', '26928.00');
INSERT INTO `mx_balance` VALUES ('8987', 'sn701', '26888.00');
INSERT INTO `mx_balance` VALUES ('8988', 'sn701', '27388.00');
INSERT INTO `mx_balance` VALUES ('8989', 'sn701', '27188.00');
INSERT INTO `mx_balance` VALUES ('8990', 'sn701', '27688.00');
INSERT INTO `mx_balance` VALUES ('8991', 'sn701', '27638.00');
INSERT INTO `mx_balance` VALUES ('8992', 'sn701', '27618.00');
INSERT INTO `mx_balance` VALUES ('8993', 'sn701', '27588.00');
INSERT INTO `mx_balance` VALUES ('8994', 'sn701', '27568.00');
INSERT INTO `mx_balance` VALUES ('8995', 'sn701', '27558.00');
INSERT INTO `mx_balance` VALUES ('8996', 'sn701', '27548.00');
INSERT INTO `mx_balance` VALUES ('8997', 'sn702', '45650.00');
INSERT INTO `mx_balance` VALUES ('8998', 'sn705', '19990.00');
INSERT INTO `mx_balance` VALUES ('8999', 'sn705', '19960.00');
INSERT INTO `mx_balance` VALUES ('9000', 'sn705', '19950.00');
INSERT INTO `mx_balance` VALUES ('9001', 'sn705', '19920.00');
INSERT INTO `mx_balance` VALUES ('9002', 'sn705', '19910.00');
INSERT INTO `mx_balance` VALUES ('9003', 'sn705', '19890.00');
INSERT INTO `mx_balance` VALUES ('9004', 'sn701', '27528.00');
INSERT INTO `mx_balance` VALUES ('9005', 'sn701', '27508.00');
INSERT INTO `mx_balance` VALUES ('9006', 'sn701', '27478.00');
INSERT INTO `mx_balance` VALUES ('9007', 'sn701', '27468.00');
INSERT INTO `mx_balance` VALUES ('9008', 'sn701', '27368.00');
INSERT INTO `mx_balance` VALUES ('9009', 'sn701', '27348.00');
INSERT INTO `mx_balance` VALUES ('9010', 'Sn704', '7802.00');
INSERT INTO `mx_balance` VALUES ('9011', 'Sn704', '7792.00');
INSERT INTO `mx_balance` VALUES ('9012', 'Sn704', '7782.00');
INSERT INTO `mx_balance` VALUES ('9013', 'sn701', '27328.00');
INSERT INTO `mx_balance` VALUES ('9014', 'Sn704', '7792.00');
INSERT INTO `mx_balance` VALUES ('9015', 'Sn704', '7892.00');
INSERT INTO `mx_balance` VALUES ('9016', 'sn701', '27228.00');
INSERT INTO `mx_balance` VALUES ('9017', 'sn701', '27078.00');
INSERT INTO `mx_balance` VALUES ('9018', 'sn701', '27058.00');
INSERT INTO `mx_balance` VALUES ('9019', 'sn701', '27258.00');
INSERT INTO `mx_balance` VALUES ('9020', 'sn701', '27158.00');
INSERT INTO `mx_balance` VALUES ('9021', 'sn701', '27138.00');
INSERT INTO `mx_balance` VALUES ('9022', 'sn701', '27088.00');
INSERT INTO `mx_balance` VALUES ('9023', 'sn701', '26988.00');
INSERT INTO `mx_balance` VALUES ('9024', 'sn701', '26958.00');
INSERT INTO `mx_balance` VALUES ('9025', 'sn701', '26858.00');
INSERT INTO `mx_balance` VALUES ('9026', 'sn701', '26828.00');
INSERT INTO `mx_balance` VALUES ('9027', 'sn701', '26678.00');
INSERT INTO `mx_balance` VALUES ('9028', 'sn701', '26578.00');
INSERT INTO `mx_balance` VALUES ('9029', 'sn701', '26538.00');
INSERT INTO `mx_balance` VALUES ('9030', 'sn701', '26488.00');
INSERT INTO `mx_balance` VALUES ('9031', 'sn701', '26438.00');
INSERT INTO `mx_balance` VALUES ('9032', 'sn701', '26408.00');
INSERT INTO `mx_balance` VALUES ('9033', 'sn701', '26508.00');
INSERT INTO `mx_balance` VALUES ('9034', 'sn701', '26808.00');
INSERT INTO `mx_balance` VALUES ('9035', 'sn701', '26768.00');
INSERT INTO `mx_balance` VALUES ('9036', 'sn702', '45600.00');
INSERT INTO `mx_balance` VALUES ('9037', 'sn701', '26668.00');
INSERT INTO `mx_balance` VALUES ('9038', 'sn701', '26518.00');
INSERT INTO `mx_balance` VALUES ('9039', 'sn705', '19840.00');
INSERT INTO `mx_balance` VALUES ('9040', 'sn701', '26438.00');
INSERT INTO `mx_balance` VALUES ('9041', 'sn701', '26638.00');
INSERT INTO `mx_balance` VALUES ('9042', 'sn701', '26538.00');
INSERT INTO `mx_balance` VALUES ('9043', 'sn701', '26438.00');
INSERT INTO `mx_balance` VALUES ('9044', 'sn701', '26338.00');
INSERT INTO `mx_balance` VALUES ('9045', 'sn701', '26188.00');
INSERT INTO `mx_balance` VALUES ('9046', 'sn701', '26148.00');
INSERT INTO `mx_balance` VALUES ('9047', 'sn701', '26108.00');
INSERT INTO `mx_balance` VALUES ('9048', 'sn701', '26408.00');
INSERT INTO `mx_balance` VALUES ('9049', 'sn705', '19790.00');
INSERT INTO `mx_balance` VALUES ('9050', 'Sn704', '7862.00');
INSERT INTO `mx_balance` VALUES ('9051', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9052', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9053', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9054', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9055', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9056', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9057', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9058', 'Sn704', '7792.00');
INSERT INTO `mx_balance` VALUES ('9059', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9060', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9061', 'Sn704', '7342.00');
INSERT INTO `mx_balance` VALUES ('9062', 'Sn704', '6842.00');
INSERT INTO `mx_balance` VALUES ('9063', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9064', 'Sn704', '7792.00');
INSERT INTO `mx_balance` VALUES ('9065', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9066', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9067', 'Sn704', '7792.00');
INSERT INTO `mx_balance` VALUES ('9068', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9069', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9070', 'Sn704', '7342.00');
INSERT INTO `mx_balance` VALUES ('9071', 'Sn704', '6842.00');
INSERT INTO `mx_balance` VALUES ('9072', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9073', 'Sn704', '7792.00');
INSERT INTO `mx_balance` VALUES ('9074', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9075', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9076', 'Sn704', '7792.00');
INSERT INTO `mx_balance` VALUES ('9077', 'Sn704', '7742.00');
INSERT INTO `mx_balance` VALUES ('9078', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9079', 'sn701', '26378.00');
INSERT INTO `mx_balance` VALUES ('9080', 'sn701', '26358.00');
INSERT INTO `mx_balance` VALUES ('9081', 'sn701', '26328.00');
INSERT INTO `mx_balance` VALUES ('9082', 'sn701', '26298.00');
INSERT INTO `mx_balance` VALUES ('9083', 'sn701', '26268.00');
INSERT INTO `mx_balance` VALUES ('9084', 'sn701', '26248.00');
INSERT INTO `mx_balance` VALUES ('9085', 'sn701', '26218.00');
INSERT INTO `mx_balance` VALUES ('9086', 'sn701', '26158.00');
INSERT INTO `mx_balance` VALUES ('9087', 'sn701', '26138.00');
INSERT INTO `mx_balance` VALUES ('9088', 'sn702', '45580.00');
INSERT INTO `mx_balance` VALUES ('9089', 'sn701', '26098.00');
INSERT INTO `mx_balance` VALUES ('9090', 'sn701', '26038.00');
INSERT INTO `mx_balance` VALUES ('9091', 'sn701', '26008.00');
INSERT INTO `mx_balance` VALUES ('9092', 'sn701', '25978.00');
INSERT INTO `mx_balance` VALUES ('9093', 'sn701', '25948.00');
INSERT INTO `mx_balance` VALUES ('9094', 'sn701', '25918.00');
INSERT INTO `mx_balance` VALUES ('9095', 'sn702', '45560.00');
INSERT INTO `mx_balance` VALUES ('9096', 'sn701', '25888.00');
INSERT INTO `mx_balance` VALUES ('9097', 'sn701', '25868.00');
INSERT INTO `mx_balance` VALUES ('9098', 'sn701', '25838.00');
INSERT INTO `mx_balance` VALUES ('9099', 'sn701', '25808.00');
INSERT INTO `mx_balance` VALUES ('9100', 'sn701', '25778.00');
INSERT INTO `mx_balance` VALUES ('9101', 'sn705', '19770.00');
INSERT INTO `mx_balance` VALUES ('9102', 'sn705', '19760.00');
INSERT INTO `mx_balance` VALUES ('9103', 'sn701', '25738.00');
INSERT INTO `mx_balance` VALUES ('9104', 'sn701', '25708.00');
INSERT INTO `mx_balance` VALUES ('9105', 'sn701', '25678.00');
INSERT INTO `mx_balance` VALUES ('9106', 'sn701', '25658.00');
INSERT INTO `mx_balance` VALUES ('9107', 'sn701', '25628.00');
INSERT INTO `mx_balance` VALUES ('9108', 'sn701', '25618.00');
INSERT INTO `mx_balance` VALUES ('9109', 'sn701', '25598.00');
INSERT INTO `mx_balance` VALUES ('9110', 'sn701', '25578.00');
INSERT INTO `mx_balance` VALUES ('9111', 'sn701', '25548.00');
INSERT INTO `mx_balance` VALUES ('9112', 'sn701', '25528.00');
INSERT INTO `mx_balance` VALUES ('9113', 'sn701', '25498.00');
INSERT INTO `mx_balance` VALUES ('9114', 'sn702', '45540.00');
INSERT INTO `mx_balance` VALUES ('9115', 'sn701', '25478.00');
INSERT INTO `mx_balance` VALUES ('9116', 'sn701', '25458.00');
INSERT INTO `mx_balance` VALUES ('9117', 'sn701', '25448.00');
INSERT INTO `mx_balance` VALUES ('9118', 'sn701', '25428.00');
INSERT INTO `mx_balance` VALUES ('9119', 'sn701', '25408.00');
INSERT INTO `mx_balance` VALUES ('9120', 'sn702', '45520.00');
INSERT INTO `mx_balance` VALUES ('9121', 'sn701', '25378.00');
INSERT INTO `mx_balance` VALUES ('9122', 'sn701', '25348.00');
INSERT INTO `mx_balance` VALUES ('9123', 'sn701', '25338.00');
INSERT INTO `mx_balance` VALUES ('9124', 'sn701', '25318.00');
INSERT INTO `mx_balance` VALUES ('9125', 'sn701', '25288.00');
INSERT INTO `mx_balance` VALUES ('9126', 'Sn704', '7837.00');
INSERT INTO `mx_balance` VALUES ('9127', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9128', 'sn701', '25258.00');
INSERT INTO `mx_balance` VALUES ('9129', 'sn701', '25248.00');
INSERT INTO `mx_balance` VALUES ('9130', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9131', 'Sn704', '7837.00');
INSERT INTO `mx_balance` VALUES ('9132', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9133', 'sn702', '45480.00');
INSERT INTO `mx_balance` VALUES ('9134', 'Sn704', '7842.00');
INSERT INTO `mx_balance` VALUES ('9135', 'sn701', '25198.00');
INSERT INTO `mx_balance` VALUES ('9136', 'sn701', '25148.00');
INSERT INTO `mx_balance` VALUES ('9137', 'sn701', '25048.00');
INSERT INTO `mx_balance` VALUES ('9138', 'sn701', '24898.00');
INSERT INTO `mx_balance` VALUES ('9139', 'sn701', '24868.00');
INSERT INTO `mx_balance` VALUES ('9140', 'sn701', '24828.00');
INSERT INTO `mx_balance` VALUES ('9141', 'sn701', '24928.00');
INSERT INTO `mx_balance` VALUES ('9142', 'sn701', '25128.00');
INSERT INTO `mx_balance` VALUES ('9143', 'sn701', '25078.00');
INSERT INTO `mx_balance` VALUES ('9144', 'sn701', '24978.00');
INSERT INTO `mx_balance` VALUES ('9145', 'sn701', '24958.00');
INSERT INTO `mx_balance` VALUES ('9146', 'sn701', '25058.00');
INSERT INTO `mx_balance` VALUES ('9147', 'sn701', '24958.00');
INSERT INTO `mx_balance` VALUES ('9148', 'sn701', '24858.00');
INSERT INTO `mx_balance` VALUES ('9149', 'sn701', '24758.00');
INSERT INTO `mx_balance` VALUES ('9150', 'sn701', '24708.00');
INSERT INTO `mx_balance` VALUES ('9151', 'sn701', '24808.00');
INSERT INTO `mx_balance` VALUES ('9152', 'sn701', '24798.00');
INSERT INTO `mx_balance` VALUES ('9153', 'sn701', '24778.00');
INSERT INTO `mx_balance` VALUES ('9154', 'sn701', '24758.00');
INSERT INTO `mx_balance` VALUES ('9155', 'sn701', '24748.00');
INSERT INTO `mx_balance` VALUES ('9156', 'sn701', '24718.00');
INSERT INTO `mx_balance` VALUES ('9157', 'sn701', '24698.00');
INSERT INTO `mx_balance` VALUES ('9158', 'sn702', '45470.00');
INSERT INTO `mx_balance` VALUES ('9159', 'sn701', '24678.00');
INSERT INTO `mx_balance` VALUES ('9160', 'sn701', '24658.00');
INSERT INTO `mx_balance` VALUES ('9161', 'sn705', '19710.00');
INSERT INTO `mx_balance` VALUES ('9162', 'sn701', '24628.00');
INSERT INTO `mx_balance` VALUES ('9163', 'sn705', '19660.00');
INSERT INTO `mx_balance` VALUES ('9164', 'sn705', '19510.00');
INSERT INTO `mx_balance` VALUES ('9165', 'sn702', '45370.00');
INSERT INTO `mx_balance` VALUES ('9166', 'sn705', '19460.00');
INSERT INTO `mx_balance` VALUES ('9167', 'sn705', '19410.00');
INSERT INTO `mx_balance` VALUES ('9168', 'sn705', '19360.00');
INSERT INTO `mx_balance` VALUES ('9169', 'sn705', '19310.00');
INSERT INTO `mx_balance` VALUES ('9170', 'sn702', '45350.00');
INSERT INTO `mx_balance` VALUES ('9171', 'sn701', '24528.00');
INSERT INTO `mx_balance` VALUES ('9172', 'sn701', '24508.00');
INSERT INTO `mx_balance` VALUES ('9173', 'sn701', '24488.00');
INSERT INTO `mx_balance` VALUES ('9174', 'sn701', '24478.00');
INSERT INTO `mx_balance` VALUES ('9175', 'sn701', '24458.00');
INSERT INTO `mx_balance` VALUES ('9176', 'sn701', '24448.00');
INSERT INTO `mx_balance` VALUES ('9177', 'sn701', '24438.00');
INSERT INTO `mx_balance` VALUES ('9178', 'sn702', '45250.00');
INSERT INTO `mx_balance` VALUES ('9179', 'sn702', '45200.00');
INSERT INTO `mx_balance` VALUES ('9180', 'sn702', '45300.00');
INSERT INTO `mx_balance` VALUES ('9181', 'sn705', '19250.00');
INSERT INTO `mx_balance` VALUES ('9182', 'sn705', '19240.00');
INSERT INTO `mx_balance` VALUES ('9183', 'sn705', '19210.00');
INSERT INTO `mx_balance` VALUES ('9184', 'sn705', '19180.00');
INSERT INTO `mx_balance` VALUES ('9185', 'sn705', '19170.00');
INSERT INTO `mx_balance` VALUES ('9186', 'sn705', '19150.00');
INSERT INTO `mx_balance` VALUES ('9187', 'sn705', '19130.00');
INSERT INTO `mx_balance` VALUES ('9188', 'sn705', '19090.00');
INSERT INTO `mx_balance` VALUES ('9189', 'sn705', '19060.00');
INSERT INTO `mx_balance` VALUES ('9190', 'sn705', '19010.00');
INSERT INTO `mx_balance` VALUES ('9191', 'sn705', '18990.00');
INSERT INTO `mx_balance` VALUES ('9192', 'sn705', '18940.00');
INSERT INTO `mx_balance` VALUES ('9193', 'sn705', '18900.00');
INSERT INTO `mx_balance` VALUES ('9194', 'sn705', '18850.00');
INSERT INTO `mx_balance` VALUES ('9195', 'sn705', '18810.00');
INSERT INTO `mx_balance` VALUES ('9196', 'sn705', '18800.00');
INSERT INTO `mx_balance` VALUES ('9197', 'sn705', '18750.00');
INSERT INTO `mx_balance` VALUES ('9198', 'sn702', '45270.00');
INSERT INTO `mx_balance` VALUES ('9199', 'sn702', '45230.00');
INSERT INTO `mx_balance` VALUES ('9200', 'sn702', '45220.00');
INSERT INTO `mx_balance` VALUES ('9201', 'sn701', '24398.00');
INSERT INTO `mx_balance` VALUES ('9202', 'sn705', '18700.00');
INSERT INTO `mx_balance` VALUES ('9203', 'sn705', '18640.00');
INSERT INTO `mx_balance` VALUES ('9204', 'Sn704', '7837.00');
INSERT INTO `mx_balance` VALUES ('9205', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9206', 'Sn704', '7827.00');
INSERT INTO `mx_balance` VALUES ('9207', 'Sn704', '7837.00');
INSERT INTO `mx_balance` VALUES ('9208', 'Sn704', '7787.00');
INSERT INTO `mx_balance` VALUES ('9209', 'Sn704', '7737.00');
INSERT INTO `mx_balance` VALUES ('9210', 'Sn704', '7837.00');
INSERT INTO `mx_balance` VALUES ('9211', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9212', 'sn701', '24368.00');
INSERT INTO `mx_balance` VALUES ('9213', 'sn701', '24348.00');
INSERT INTO `mx_balance` VALUES ('9214', 'sn705', '18540.00');
INSERT INTO `mx_balance` VALUES ('9215', 'sn705', '18530.00');
INSERT INTO `mx_balance` VALUES ('9216', 'sn705', '18520.00');
INSERT INTO `mx_balance` VALUES ('9217', 'sn705', '18510.00');
INSERT INTO `mx_balance` VALUES ('9218', 'sn705', '18480.00');
INSERT INTO `mx_balance` VALUES ('9219', 'sn705', '18430.00');
INSERT INTO `mx_balance` VALUES ('9220', 'sn705', '18420.00');
INSERT INTO `mx_balance` VALUES ('9221', 'sn705', '18410.00');
INSERT INTO `mx_balance` VALUES ('9222', 'sn705', '18400.00');
INSERT INTO `mx_balance` VALUES ('9223', 'sn705', '18290.00');
INSERT INTO `mx_balance` VALUES ('9224', 'sn705', '18280.00');
INSERT INTO `mx_balance` VALUES ('9225', 'sn705', '18080.00');
INSERT INTO `mx_balance` VALUES ('9226', 'sn705', '18030.00');
INSERT INTO `mx_balance` VALUES ('9227', 'sn705', '18010.00');
INSERT INTO `mx_balance` VALUES ('9228', 'sn701', '24318.00');
INSERT INTO `mx_balance` VALUES ('9229', 'sn705', '17860.00');
INSERT INTO `mx_balance` VALUES ('9230', 'sn705', '17840.00');
INSERT INTO `mx_balance` VALUES ('9231', 'sn705', '17740.00');
INSERT INTO `mx_balance` VALUES ('9232', 'sn705', '17540.00');
INSERT INTO `mx_balance` VALUES ('9233', 'sn701', '24278.00');
INSERT INTO `mx_balance` VALUES ('9234', 'sn701', '24248.00');
INSERT INTO `mx_balance` VALUES ('9235', 'sn701', '24188.00');
INSERT INTO `mx_balance` VALUES ('9236', 'sn701', '24148.00');
INSERT INTO `mx_balance` VALUES ('9237', 'sn701', '24128.00');
INSERT INTO `mx_balance` VALUES ('9238', 'sn701', '24228.00');
INSERT INTO `mx_balance` VALUES ('9239', 'sn701', '24168.00');
INSERT INTO `mx_balance` VALUES ('9240', 'sn701', '24138.00');
INSERT INTO `mx_balance` VALUES ('9241', 'sn701', '24098.00');
INSERT INTO `mx_balance` VALUES ('9242', 'sn701', '24018.00');
INSERT INTO `mx_balance` VALUES ('9243', 'sn701', '23958.00');
INSERT INTO `mx_balance` VALUES ('9244', 'sn701', '23938.00');
INSERT INTO `mx_balance` VALUES ('9245', 'sn701', '23908.00');
INSERT INTO `mx_balance` VALUES ('9246', 'sn701', '23888.00');
INSERT INTO `mx_balance` VALUES ('9247', 'sn701', '23878.00');
INSERT INTO `mx_balance` VALUES ('9248', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9249', 'sn701', '23858.00');
INSERT INTO `mx_balance` VALUES ('9250', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9251', 'Sn704', '7332.00');
INSERT INTO `mx_balance` VALUES ('9252', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9253', 'sn701', '23848.00');
INSERT INTO `mx_balance` VALUES ('9254', 'sn701', '23828.00');
INSERT INTO `mx_balance` VALUES ('9255', 'sn701', '23808.00');
INSERT INTO `mx_balance` VALUES ('9256', 'sn701', '23908.00');
INSERT INTO `mx_balance` VALUES ('9257', 'sn701', '24008.00');
INSERT INTO `mx_balance` VALUES ('9258', 'sn701', '23978.00');
INSERT INTO `mx_balance` VALUES ('9259', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9260', 'sn701', '23948.00');
INSERT INTO `mx_balance` VALUES ('9261', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9262', 'sn701', '24048.00');
INSERT INTO `mx_balance` VALUES ('9263', 'sn701', '24028.00');
INSERT INTO `mx_balance` VALUES ('9264', 'sn701', '24008.00');
INSERT INTO `mx_balance` VALUES ('9265', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9266', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9267', 'sn701', '24108.00');
INSERT INTO `mx_balance` VALUES ('9268', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9269', 'sn701', '24088.00');
INSERT INTO `mx_balance` VALUES ('9270', 'sn701', '24058.00');
INSERT INTO `mx_balance` VALUES ('9271', 'sn701', '24038.00');
INSERT INTO `mx_balance` VALUES ('9272', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9273', 'Sn704', '7332.00');
INSERT INTO `mx_balance` VALUES ('9274', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9275', 'Sn704', '7632.00');
INSERT INTO `mx_balance` VALUES ('9276', 'sn701', '24008.00');
INSERT INTO `mx_balance` VALUES ('9277', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9278', 'Sn704', '6832.00');
INSERT INTO `mx_balance` VALUES ('9279', 'sn701', '23968.00');
INSERT INTO `mx_balance` VALUES ('9280', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9281', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9282', 'sn701', '23938.00');
INSERT INTO `mx_balance` VALUES ('9283', 'sn701', '23918.00');
INSERT INTO `mx_balance` VALUES ('9284', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9285', 'sn701', '24018.00');
INSERT INTO `mx_balance` VALUES ('9286', 'sn701', '23968.00');
INSERT INTO `mx_balance` VALUES ('9287', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9288', 'sn701', '23948.00');
INSERT INTO `mx_balance` VALUES ('9289', 'sn701', '23898.00');
INSERT INTO `mx_balance` VALUES ('9290', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9291', 'Sn704', '6832.00');
INSERT INTO `mx_balance` VALUES ('9292', 'sn701', '23848.00');
INSERT INTO `mx_balance` VALUES ('9293', 'sn701', '23798.00');
INSERT INTO `mx_balance` VALUES ('9294', 'sn701', '23778.00');
INSERT INTO `mx_balance` VALUES ('9295', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9296', 'sn701', '23878.00');
INSERT INTO `mx_balance` VALUES ('9297', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9298', 'sn701', '23828.00');
INSERT INTO `mx_balance` VALUES ('9299', 'sn701', '23798.00');
INSERT INTO `mx_balance` VALUES ('9300', 'sn701', '23778.00');
INSERT INTO `mx_balance` VALUES ('9301', 'sn705', '17490.00');
INSERT INTO `mx_balance` VALUES ('9302', 'sn701', '23878.00');
INSERT INTO `mx_balance` VALUES ('9303', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9304', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9305', 'sn701', '23828.00');
INSERT INTO `mx_balance` VALUES ('9306', 'sn705', '17460.00');
INSERT INTO `mx_balance` VALUES ('9307', 'sn705', '17410.00');
INSERT INTO `mx_balance` VALUES ('9308', 'sn701', '23778.00');
INSERT INTO `mx_balance` VALUES ('9309', 'sn701', '23748.00');
INSERT INTO `mx_balance` VALUES ('9310', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9311', 'sn701', '23848.00');
INSERT INTO `mx_balance` VALUES ('9312', 'sn705', '17310.00');
INSERT INTO `mx_balance` VALUES ('9313', 'sn705', '17260.00');
INSERT INTO `mx_balance` VALUES ('9314', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9315', 'sn705', '17210.00');
INSERT INTO `mx_balance` VALUES ('9316', 'sn705', '17310.00');
INSERT INTO `mx_balance` VALUES ('9317', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9318', 'sn705', '17260.00');
INSERT INTO `mx_balance` VALUES ('9319', 'sn705', '17240.00');
INSERT INTO `mx_balance` VALUES ('9320', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9321', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9322', 'Sn704', '7772.00');
INSERT INTO `mx_balance` VALUES ('9323', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9324', 'sn705', '17190.00');
INSERT INTO `mx_balance` VALUES ('9325', 'sn705', '17140.00');
INSERT INTO `mx_balance` VALUES ('9326', 'sn705', '17090.00');
INSERT INTO `mx_balance` VALUES ('9327', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9328', 'sn705', '17190.00');
INSERT INTO `mx_balance` VALUES ('9329', 'sn705', '17140.00');
INSERT INTO `mx_balance` VALUES ('9330', 'sn701', '23838.00');
INSERT INTO `mx_balance` VALUES ('9331', 'sn701', '23828.00');
INSERT INTO `mx_balance` VALUES ('9332', 'Sn704', '6832.00');
INSERT INTO `mx_balance` VALUES ('9333', 'sn705', '17090.00');
INSERT INTO `mx_balance` VALUES ('9334', 'sn701', '23818.00');
INSERT INTO `mx_balance` VALUES ('9335', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9336', 'sn705', '17190.00');
INSERT INTO `mx_balance` VALUES ('9337', 'sn705', '17140.00');
INSERT INTO `mx_balance` VALUES ('9338', 'sn701', '23808.00');
INSERT INTO `mx_balance` VALUES ('9339', 'sn701', '23798.00');
INSERT INTO `mx_balance` VALUES ('9340', 'sn701', '23778.00');
INSERT INTO `mx_balance` VALUES ('9341', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9342', 'sn705', '17090.00');
INSERT INTO `mx_balance` VALUES ('9343', 'sn701', '23748.00');
INSERT INTO `mx_balance` VALUES ('9344', 'sn701', '23718.00');
INSERT INTO `mx_balance` VALUES ('9345', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9346', 'sn705', '17190.00');
INSERT INTO `mx_balance` VALUES ('9347', 'sn705', '17140.00');
INSERT INTO `mx_balance` VALUES ('9348', 'sn701', '23678.00');
INSERT INTO `mx_balance` VALUES ('9349', 'sn701', '23668.00');
INSERT INTO `mx_balance` VALUES ('9350', 'sn701', '23658.00');
INSERT INTO `mx_balance` VALUES ('9351', 'Sn704', '7332.00');
INSERT INTO `mx_balance` VALUES ('9352', 'sn701', '23638.00');
INSERT INTO `mx_balance` VALUES ('9353', 'sn701', '23608.00');
INSERT INTO `mx_balance` VALUES ('9354', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9355', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9356', 'sn701', '23588.00');
INSERT INTO `mx_balance` VALUES ('9357', 'sn701', '23568.00');
INSERT INTO `mx_balance` VALUES ('9358', 'sn705', '17100.00');
INSERT INTO `mx_balance` VALUES ('9359', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9360', 'sn701', '23558.00');
INSERT INTO `mx_balance` VALUES ('9361', 'sn701', '23518.00');
INSERT INTO `mx_balance` VALUES ('9362', 'sn701', '23498.00');
INSERT INTO `mx_balance` VALUES ('9363', 'sn701', '23478.00');
INSERT INTO `mx_balance` VALUES ('9364', 'sn701', '23408.00');
INSERT INTO `mx_balance` VALUES ('9365', 'sn705', '16900.00');
INSERT INTO `mx_balance` VALUES ('9366', 'sn701', '23308.00');
INSERT INTO `mx_balance` VALUES ('9367', 'sn705', '16650.00');
INSERT INTO `mx_balance` VALUES ('9368', 'sn701', '23258.00');
INSERT INTO `mx_balance` VALUES ('9369', 'sn701', '23358.00');
INSERT INTO `mx_balance` VALUES ('9370', 'sn705', '16400.00');
INSERT INTO `mx_balance` VALUES ('9371', 'sn705', '16200.00');
INSERT INTO `mx_balance` VALUES ('9372', 'sn705', '15950.00');
INSERT INTO `mx_balance` VALUES ('9373', 'sn705', '15750.00');
INSERT INTO `mx_balance` VALUES ('9374', 'sn705', '15600.00');
INSERT INTO `mx_balance` VALUES ('9375', 'sn705', '15350.00');
INSERT INTO `mx_balance` VALUES ('9376', 'sn705', '15230.00');
INSERT INTO `mx_balance` VALUES ('9377', 'sn705', '15080.00');
INSERT INTO `mx_balance` VALUES ('9378', 'Sn704', '7782.00');
INSERT INTO `mx_balance` VALUES ('9379', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9380', 'sn705', '14930.00');
INSERT INTO `mx_balance` VALUES ('9381', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9382', 'sn705', '15130.00');
INSERT INTO `mx_balance` VALUES ('9383', 'Sn704', '7782.00');
INSERT INTO `mx_balance` VALUES ('9384', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9385', 'sn705', '15010.00');
INSERT INTO `mx_balance` VALUES ('9386', 'Sn704', '7832.00');
INSERT INTO `mx_balance` VALUES ('9387', 'Sn704', '7782.00');
INSERT INTO `mx_balance` VALUES ('9388', 'Sn704', '7732.00');
INSERT INTO `mx_balance` VALUES ('9389', 'Sn704', '8032.00');
INSERT INTO `mx_balance` VALUES ('9390', 'sn702', '45210.00');
INSERT INTO `mx_balance` VALUES ('9391', 'sn701', '23348.00');
INSERT INTO `mx_balance` VALUES ('9392', 'sn701', '23338.00');
INSERT INTO `mx_balance` VALUES ('9393', 'sn701', '23318.00');
INSERT INTO `mx_balance` VALUES ('9394', 'sn701', '23308.00');
INSERT INTO `mx_balance` VALUES ('9395', 'sn702', '45190.00');
INSERT INTO `mx_balance` VALUES ('9396', 'sn702', '45140.00');
INSERT INTO `mx_balance` VALUES ('9397', 'sn701', '23238.00');
INSERT INTO `mx_balance` VALUES ('9398', 'sn702', '45090.00');
INSERT INTO `mx_balance` VALUES ('9399', 'sn702', '45060.00');
INSERT INTO `mx_balance` VALUES ('9400', 'sn701', '23208.00');
INSERT INTO `mx_balance` VALUES ('9401', 'sn701', '23188.00');
INSERT INTO `mx_balance` VALUES ('9402', 'sn702', '45000.00');
INSERT INTO `mx_balance` VALUES ('9403', 'sn702', '44980.00');
INSERT INTO `mx_balance` VALUES ('9404', 'sn701', '23178.00');
INSERT INTO `mx_balance` VALUES ('9405', 'sn701', '23158.00');
INSERT INTO `mx_balance` VALUES ('9406', 'sn702', '44960.00');
INSERT INTO `mx_balance` VALUES ('9407', 'sn701', '23148.00');
INSERT INTO `mx_balance` VALUES ('9408', 'sn701', '23138.00');
INSERT INTO `mx_balance` VALUES ('9409', 'sn705', '14980.00');
INSERT INTO `mx_balance` VALUES ('9410', 'sn705', '14970.00');
INSERT INTO `mx_balance` VALUES ('9411', 'sn702', '44860.00');
INSERT INTO `mx_balance` VALUES ('9412', 'sn702', '44810.00');
INSERT INTO `mx_balance` VALUES ('9413', 'sn702', '44770.00');
INSERT INTO `mx_balance` VALUES ('9414', 'sn705', '14950.00');
INSERT INTO `mx_balance` VALUES ('9415', 'sn705', '14930.00');
INSERT INTO `mx_balance` VALUES ('9416', 'sn705', '14880.00');
INSERT INTO `mx_balance` VALUES ('9417', 'sn701', '23118.00');
INSERT INTO `mx_balance` VALUES ('9418', 'sn702', '44710.00');
INSERT INTO `mx_balance` VALUES ('9419', 'sn702', '44640.00');
INSERT INTO `mx_balance` VALUES ('9420', 'sn702', '44580.00');
INSERT INTO `mx_balance` VALUES ('9421', 'sn702', '44520.00');
INSERT INTO `mx_balance` VALUES ('9422', 'sn701', '23108.00');
INSERT INTO `mx_balance` VALUES ('9423', 'sn701', '23088.00');
INSERT INTO `mx_balance` VALUES ('9424', 'sn701', '23058.00');
INSERT INTO `mx_balance` VALUES ('9425', 'sn701', '23028.00');
INSERT INTO `mx_balance` VALUES ('9426', 'sn701', '22998.00');
INSERT INTO `mx_balance` VALUES ('9427', 'sn701', '22958.00');
INSERT INTO `mx_balance` VALUES ('9428', 'sn701', '22928.00');
INSERT INTO `mx_balance` VALUES ('9429', 'sn701', '22908.00');
INSERT INTO `mx_balance` VALUES ('9430', 'sn701', '22898.00');
INSERT INTO `mx_balance` VALUES ('9431', 'sn701', '22848.00');
INSERT INTO `mx_balance` VALUES ('9432', 'sn701', '22948.00');
INSERT INTO `mx_balance` VALUES ('9433', 'sn701', '22898.00');
INSERT INTO `mx_balance` VALUES ('9434', 'sn701', '22848.00');
INSERT INTO `mx_balance` VALUES ('9435', 'sn701', '22828.00');
INSERT INTO `mx_balance` VALUES ('9436', 'sn701', '22778.00');
INSERT INTO `mx_balance` VALUES ('9437', 'sn701', '22768.00');
INSERT INTO `mx_balance` VALUES ('9438', 'sn701', '22868.00');
INSERT INTO `mx_balance` VALUES ('9439', 'sn701', '22818.00');
INSERT INTO `mx_balance` VALUES ('9440', 'sn701', '22778.00');
INSERT INTO `mx_balance` VALUES ('9441', 'sn701', '22728.00');
INSERT INTO `mx_balance` VALUES ('9442', 'sn701', '22678.00');
INSERT INTO `mx_balance` VALUES ('9443', 'sn701', '22628.00');
INSERT INTO `mx_balance` VALUES ('9444', 'sn701', '22728.00');
INSERT INTO `mx_balance` VALUES ('9445', 'sn701', '22688.00');
INSERT INTO `mx_balance` VALUES ('9446', 'sn701', '22678.00');
INSERT INTO `mx_balance` VALUES ('9447', 'sn701', '22658.00');
INSERT INTO `mx_balance` VALUES ('9448', 'sn701', '22608.00');
INSERT INTO `mx_balance` VALUES ('9449', 'sn701', '22558.00');
INSERT INTO `mx_balance` VALUES ('9450', 'sn701', '22538.00');
INSERT INTO `mx_balance` VALUES ('9451', 'sn701', '22508.00');
INSERT INTO `mx_balance` VALUES ('9452', 'sn701', '22498.00');
INSERT INTO `mx_balance` VALUES ('9453', 'sn701', '22468.00');
INSERT INTO `mx_balance` VALUES ('9454', 'sn701', '22418.00');
INSERT INTO `mx_balance` VALUES ('9455', 'sn701', '22398.00');
INSERT INTO `mx_balance` VALUES ('9456', 'sn701', '22388.00');
INSERT INTO `mx_balance` VALUES ('9457', 'sn701', '22378.00');
INSERT INTO `mx_balance` VALUES ('9458', 'sn701', '22368.00');
INSERT INTO `mx_balance` VALUES ('9459', 'sn701', '22358.00');
INSERT INTO `mx_balance` VALUES ('9460', 'sn701', '22348.00');
INSERT INTO `mx_balance` VALUES ('9461', 'sn701', '22328.00');
INSERT INTO `mx_balance` VALUES ('9462', 'sn701', '22318.00');
INSERT INTO `mx_balance` VALUES ('9463', 'sn701', '22288.00');
INSERT INTO `mx_balance` VALUES ('9464', 'sn701', '22258.00');
INSERT INTO `mx_balance` VALUES ('9465', 'sn701', '22238.00');
INSERT INTO `mx_balance` VALUES ('9466', 'sn701', '22218.00');
INSERT INTO `mx_balance` VALUES ('9467', 'Sn704', '8031.00');
INSERT INTO `mx_balance` VALUES ('9468', 'Sn704', '8020.00');
INSERT INTO `mx_balance` VALUES ('9469', 'Sn704', '8030.00');
INSERT INTO `mx_balance` VALUES ('9470', 'sn701', '22198.00');
INSERT INTO `mx_balance` VALUES ('9471', 'sn701', '22178.00');
INSERT INTO `mx_balance` VALUES ('9472', 'sn701', '22168.00');
INSERT INTO `mx_balance` VALUES ('9473', 'sn701', '22148.00');
INSERT INTO `mx_balance` VALUES ('9474', 'sn701', '22098.00');
INSERT INTO `mx_balance` VALUES ('9475', 'sn701', '22048.00');
INSERT INTO `mx_balance` VALUES ('9476', 'sn702', '44480.00');
INSERT INTO `mx_balance` VALUES ('9477', 'sn701', '22008.00');
INSERT INTO `mx_balance` VALUES ('9478', 'sn702', '44380.00');
INSERT INTO `mx_balance` VALUES ('9479', 'sn702', '44330.00');
INSERT INTO `mx_balance` VALUES ('9480', 'sn702', '44230.00');
INSERT INTO `mx_balance` VALUES ('9481', 'sn702', '44180.00');
INSERT INTO `mx_balance` VALUES ('9482', 'sn701', '21958.00');
INSERT INTO `mx_balance` VALUES ('9483', 'sn702', '44280.00');
INSERT INTO `mx_balance` VALUES ('9484', 'sn702', '44380.00');
INSERT INTO `mx_balance` VALUES ('9485', 'sn701', '21908.00');
INSERT INTO `mx_balance` VALUES ('9486', 'sn701', '22008.00');
INSERT INTO `mx_balance` VALUES ('9487', 'sn701', '21958.00');
INSERT INTO `mx_balance` VALUES ('9488', 'sn701', '22058.00');
INSERT INTO `mx_balance` VALUES ('9489', 'sn701', '22008.00');
INSERT INTO `mx_balance` VALUES ('9490', 'sn701', '22108.00');
INSERT INTO `mx_balance` VALUES ('9491', 'sn703', '46458.00');
INSERT INTO `mx_balance` VALUES ('9492', 'sn701', '22058.00');
INSERT INTO `mx_balance` VALUES ('9493', 'sn701', '22158.00');
INSERT INTO `mx_balance` VALUES ('9494', 'sn701', '22108.00');
INSERT INTO `mx_balance` VALUES ('9495', 'sn703', '46438.00');
INSERT INTO `mx_balance` VALUES ('9496', 'sn701', '22208.00');
INSERT INTO `mx_balance` VALUES ('9497', 'sn701', '22158.00');
INSERT INTO `mx_balance` VALUES ('9498', 'sn701', '22138.00');
INSERT INTO `mx_balance` VALUES ('9499', 'sn703', '46538.00');
INSERT INTO `mx_balance` VALUES ('9500', 'sn701', '22238.00');
INSERT INTO `mx_balance` VALUES ('9501', 'sn701', '22198.00');
INSERT INTO `mx_balance` VALUES ('9502', 'sn701', '22298.00');
INSERT INTO `mx_balance` VALUES ('9503', 'sn701', '22268.00');
INSERT INTO `mx_balance` VALUES ('9504', 'sn701', '22258.00');
INSERT INTO `mx_balance` VALUES ('9505', 'sn701', '22208.00');
INSERT INTO `mx_balance` VALUES ('9506', 'sn701', '22178.00');
INSERT INTO `mx_balance` VALUES ('9507', 'sn703', '46488.00');
INSERT INTO `mx_balance` VALUES ('9508', 'sn703', '46588.00');
INSERT INTO `mx_balance` VALUES ('9509', 'sn703', '46538.00');
INSERT INTO `mx_balance` VALUES ('9510', 'sn703', '46638.00');
INSERT INTO `mx_balance` VALUES ('9511', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9512', 'sn703', '46558.00');
INSERT INTO `mx_balance` VALUES ('9513', 'sn703', '46508.00');
INSERT INTO `mx_balance` VALUES ('9514', 'sn703', '46708.00');
INSERT INTO `mx_balance` VALUES ('9515', 'sn703', '46658.00');
INSERT INTO `mx_balance` VALUES ('9516', 'sn703', '46608.00');
INSERT INTO `mx_balance` VALUES ('9517', 'sn703', '46508.00');
INSERT INTO `mx_balance` VALUES ('9518', 'sn703', '46428.00');
INSERT INTO `mx_balance` VALUES ('9519', 'sn703', '46418.00');
INSERT INTO `mx_balance` VALUES ('9520', 'sn703', '46518.00');
INSERT INTO `mx_balance` VALUES ('9521', 'sn703', '46618.00');
INSERT INTO `mx_balance` VALUES ('9522', 'sn703', '46568.00');
INSERT INTO `mx_balance` VALUES ('9523', 'sn701', '22138.00');
INSERT INTO `mx_balance` VALUES ('9524', 'sn703', '46468.00');
INSERT INTO `mx_balance` VALUES ('9525', 'sn703', '46268.00');
INSERT INTO `mx_balance` VALUES ('9526', 'sn703', '46018.00');
INSERT INTO `mx_balance` VALUES ('9527', 'sn703', '45768.00');
INSERT INTO `mx_balance` VALUES ('9528', 'sn703', '45518.00');
INSERT INTO `mx_balance` VALUES ('9529', 'sn703', '45268.00');
INSERT INTO `mx_balance` VALUES ('9530', 'sn703', '45248.00');
INSERT INTO `mx_balance` VALUES ('9531', 'sn705', '14810.00');
INSERT INTO `mx_balance` VALUES ('9532', 'sn705', '14750.00');
INSERT INTO `mx_balance` VALUES ('9533', 'sn705', '14730.00');
INSERT INTO `mx_balance` VALUES ('9534', 'sn705', '14680.00');
INSERT INTO `mx_balance` VALUES ('9535', 'sn702', '44370.00');
INSERT INTO `mx_balance` VALUES ('9536', 'sn705', '14660.00');
INSERT INTO `mx_balance` VALUES ('9537', 'sn705', '14630.00');
INSERT INTO `mx_balance` VALUES ('9538', 'sn701', '22128.00');
INSERT INTO `mx_balance` VALUES ('9539', 'sn703', '45244.00');
INSERT INTO `mx_balance` VALUES ('9540', 'sn701', '22088.00');
INSERT INTO `mx_balance` VALUES ('9541', 'sn701', '22058.00');
INSERT INTO `mx_balance` VALUES ('9542', 'sn705', '14600.00');
INSERT INTO `mx_balance` VALUES ('9543', 'sn701', '22038.00');
INSERT INTO `mx_balance` VALUES ('9544', 'sn701', '22028.00');
INSERT INTO `mx_balance` VALUES ('9545', 'sn705', '14560.00');
INSERT INTO `mx_balance` VALUES ('9546', 'sn705', '14530.00');
INSERT INTO `mx_balance` VALUES ('9547', 'sn705', '14500.00');
INSERT INTO `mx_balance` VALUES ('9548', 'sn705', '14470.00');
INSERT INTO `mx_balance` VALUES ('9549', 'sn705', '14460.00');
INSERT INTO `mx_balance` VALUES ('9550', 'sn705', '14430.00');
INSERT INTO `mx_balance` VALUES ('9551', 'sn705', '14410.00');
INSERT INTO `mx_balance` VALUES ('9552', 'sn705', '14390.00');
INSERT INTO `mx_balance` VALUES ('9553', 'sn705', '14350.00');
INSERT INTO `mx_balance` VALUES ('9554', 'sn705', '14320.00');
INSERT INTO `mx_balance` VALUES ('9555', 'sn705', '14280.00');
INSERT INTO `mx_balance` VALUES ('9556', 'sn705', '14270.00');
INSERT INTO `mx_balance` VALUES ('9557', 'sn705', '14220.00');
INSERT INTO `mx_balance` VALUES ('9558', 'sn705', '14200.00');
INSERT INTO `mx_balance` VALUES ('9559', 'sn705', '14160.00');
INSERT INTO `mx_balance` VALUES ('9560', 'sn701', '22018.00');
INSERT INTO `mx_balance` VALUES ('9561', 'sn705', '14150.00');
INSERT INTO `mx_balance` VALUES ('9562', 'sn705', '14100.00');
INSERT INTO `mx_balance` VALUES ('9563', 'sn705', '14090.00');
INSERT INTO `mx_balance` VALUES ('9564', 'sn701', '21998.00');
INSERT INTO `mx_balance` VALUES ('9565', 'sn701', '21968.00');
INSERT INTO `mx_balance` VALUES ('9566', 'sn701', '21938.00');
INSERT INTO `mx_balance` VALUES ('9567', 'sn705', '14060.00');
INSERT INTO `mx_balance` VALUES ('9568', 'sn701', '21918.00');
INSERT INTO `mx_balance` VALUES ('9569', 'sn701', '21898.00');
INSERT INTO `mx_balance` VALUES ('9570', 'sn701', '21878.00');
INSERT INTO `mx_balance` VALUES ('9571', 'sn701', '21858.00');
INSERT INTO `mx_balance` VALUES ('9572', 'sn701', '21838.00');
INSERT INTO `mx_balance` VALUES ('9573', 'sn701', '21818.00');
INSERT INTO `mx_balance` VALUES ('9574', 'sn701', '21808.00');
INSERT INTO `mx_balance` VALUES ('9575', 'sn701', '21748.00');
INSERT INTO `mx_balance` VALUES ('9576', 'sn701', '21728.00');
INSERT INTO `mx_balance` VALUES ('9577', 'sn705', '14030.00');
INSERT INTO `mx_balance` VALUES ('9578', 'sn705', '13990.00');
INSERT INTO `mx_balance` VALUES ('9579', 'sn701', '21688.00');
INSERT INTO `mx_balance` VALUES ('9580', 'sn705', '13970.00');
INSERT INTO `mx_balance` VALUES ('9581', 'sn701', '21648.00');
INSERT INTO `mx_balance` VALUES ('9582', 'sn703', '45194.00');
INSERT INTO `mx_balance` VALUES ('9583', 'sn703', '45144.00');
INSERT INTO `mx_balance` VALUES ('9584', 'sn701', '21638.00');
INSERT INTO `mx_balance` VALUES ('9585', 'sn701', '21618.00');
INSERT INTO `mx_balance` VALUES ('9586', 'Sn704', '7960.00');
INSERT INTO `mx_balance` VALUES ('9587', 'Sn704', '7910.00');
INSERT INTO `mx_balance` VALUES ('9588', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9589', 'Sn704', '7960.00');
INSERT INTO `mx_balance` VALUES ('9590', 'Sn704', '7910.00');
INSERT INTO `mx_balance` VALUES ('9591', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9592', 'Sn704', '7960.00');
INSERT INTO `mx_balance` VALUES ('9593', 'Sn704', '7910.00');
INSERT INTO `mx_balance` VALUES ('9594', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9595', 'Sn704', '7910.00');
INSERT INTO `mx_balance` VALUES ('9596', 'sn701', '21608.00');
INSERT INTO `mx_balance` VALUES ('9597', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9598', 'Sn704', '7910.00');
INSERT INTO `mx_balance` VALUES ('9599', 'Sn704', '7810.00');
INSERT INTO `mx_balance` VALUES ('9600', 'sn701', '21518.00');
INSERT INTO `mx_balance` VALUES ('9601', 'sn701', '21498.00');
INSERT INTO `mx_balance` VALUES ('9602', 'sn701', '21488.00');
INSERT INTO `mx_balance` VALUES ('9603', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9604', 'Sn704', '7010.00');
INSERT INTO `mx_balance` VALUES ('9605', 'sn701', '21418.00');
INSERT INTO `mx_balance` VALUES ('9606', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9607', 'Sn704', '7510.00');
INSERT INTO `mx_balance` VALUES ('9608', 'Sn704', '7010.00');
INSERT INTO `mx_balance` VALUES ('9609', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9610', 'Sn704', '7510.00');
INSERT INTO `mx_balance` VALUES ('9611', 'Sn704', '7010.00');
INSERT INTO `mx_balance` VALUES ('9612', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9613', 'Sn704', '7510.00');
INSERT INTO `mx_balance` VALUES ('9614', 'Sn704', '7010.00');
INSERT INTO `mx_balance` VALUES ('9615', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9616', 'Sn704', '7510.00');
INSERT INTO `mx_balance` VALUES ('9617', 'Sn704', '7010.00');
INSERT INTO `mx_balance` VALUES ('9618', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9619', 'Sn704', '7960.00');
INSERT INTO `mx_balance` VALUES ('9620', 'Sn704', '7910.00');
INSERT INTO `mx_balance` VALUES ('9621', 'sn701', '21408.00');
INSERT INTO `mx_balance` VALUES ('9622', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9623', 'sn701', '21398.00');
INSERT INTO `mx_balance` VALUES ('9624', 'Sn704', '7985.00');
INSERT INTO `mx_balance` VALUES ('9625', 'Sn704', '7960.00');
INSERT INTO `mx_balance` VALUES ('9626', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9627', 'Sn704', '7985.00');
INSERT INTO `mx_balance` VALUES ('9628', 'Sn704', '7960.00');
INSERT INTO `mx_balance` VALUES ('9629', 'Sn704', '8010.00');
INSERT INTO `mx_balance` VALUES ('9630', 'sn701', '21388.00');
INSERT INTO `mx_balance` VALUES ('9631', 'sn701', '21368.00');
INSERT INTO `mx_balance` VALUES ('9632', 'sn701', '21328.00');
INSERT INTO `mx_balance` VALUES ('9633', 'sn701', '21288.00');
INSERT INTO `mx_balance` VALUES ('9634', 'sn701', '21278.00');
INSERT INTO `mx_balance` VALUES ('9635', 'Sn704', '7990.00');
INSERT INTO `mx_balance` VALUES ('9636', 'sn701', '21258.00');
INSERT INTO `mx_balance` VALUES ('9637', 'sn701', '21198.00');
INSERT INTO `mx_balance` VALUES ('9638', 'sn701', '21188.00');
INSERT INTO `mx_balance` VALUES ('9639', 'sn701', '21138.00');
INSERT INTO `mx_balance` VALUES ('9640', 'sn701', '21088.00');
INSERT INTO `mx_balance` VALUES ('9641', 'sn701', '21078.00');
INSERT INTO `mx_balance` VALUES ('9642', 'sn701', '21068.00');
INSERT INTO `mx_balance` VALUES ('9643', 'sn701', '21058.00');
INSERT INTO `mx_balance` VALUES ('9644', 'sn701', '21048.00');
INSERT INTO `mx_balance` VALUES ('9645', 'sn701', '21038.00');
INSERT INTO `mx_balance` VALUES ('9646', 'sn701', '21028.00');
INSERT INTO `mx_balance` VALUES ('9647', 'sn701', '21008.00');
INSERT INTO `mx_balance` VALUES ('9648', 'sn701', '20998.00');
INSERT INTO `mx_balance` VALUES ('9649', 'sn701', '20988.00');
INSERT INTO `mx_balance` VALUES ('9650', 'sn701', '20978.00');
INSERT INTO `mx_balance` VALUES ('9651', 'sn701', '20968.00');
INSERT INTO `mx_balance` VALUES ('9652', 'sn701', '20948.00');
INSERT INTO `mx_balance` VALUES ('9653', 'sn701', '20928.00');
INSERT INTO `mx_balance` VALUES ('9654', 'sn702', '44320.00');
INSERT INTO `mx_balance` VALUES ('9655', 'sn701', '20888.00');
INSERT INTO `mx_balance` VALUES ('9656', 'sn702', '44270.00');
INSERT INTO `mx_balance` VALUES ('9657', 'sn701', '20838.00');
INSERT INTO `mx_balance` VALUES ('9658', 'sn701', '20818.00');
INSERT INTO `mx_balance` VALUES ('9659', 'sn701', '20808.00');
INSERT INTO `mx_balance` VALUES ('9660', 'sn702', '44260.00');
INSERT INTO `mx_balance` VALUES ('9661', 'sn701', '20698.00');
INSERT INTO `mx_balance` VALUES ('9662', 'sn701', '20668.00');
INSERT INTO `mx_balance` VALUES ('9663', 'sn701', '20658.00');
INSERT INTO `mx_balance` VALUES ('9664', 'sn701', '20638.00');
INSERT INTO `mx_balance` VALUES ('9665', 'sn701', '20608.00');
INSERT INTO `mx_balance` VALUES ('9666', 'sn701', '20588.00');
INSERT INTO `mx_balance` VALUES ('9667', 'sn701', '20568.00');
INSERT INTO `mx_balance` VALUES ('9668', 'sn701', '20548.00');
INSERT INTO `mx_balance` VALUES ('9669', 'sn701', '20448.00');
INSERT INTO `mx_balance` VALUES ('9670', 'sn701', '20428.00');
INSERT INTO `mx_balance` VALUES ('9671', 'Sn704', '7940.00');
INSERT INTO `mx_balance` VALUES ('9672', 'Sn704', '7890.00');
INSERT INTO `mx_balance` VALUES ('9673', 'Sn704', '7990.00');
INSERT INTO `mx_balance` VALUES ('9674', 'sn705', '13880.00');
INSERT INTO `mx_balance` VALUES ('9675', 'sn705', '13860.00');
INSERT INTO `mx_balance` VALUES ('9676', 'Sn704', '7890.00');
INSERT INTO `mx_balance` VALUES ('9677', 'Sn704', '7840.00');
INSERT INTO `mx_balance` VALUES ('9678', 'Sn704', '7790.00');
INSERT INTO `mx_balance` VALUES ('9679', 'Sn704', '7890.00');
INSERT INTO `mx_balance` VALUES ('9680', 'Sn704', '7990.00');
INSERT INTO `mx_balance` VALUES ('9681', 'Sn704', '7940.00');
INSERT INTO `mx_balance` VALUES ('9682', 'Sn704', '7890.00');
INSERT INTO `mx_balance` VALUES ('9683', 'sn701', '20398.00');
INSERT INTO `mx_balance` VALUES ('9684', 'Sn704', '7990.00');
INSERT INTO `mx_balance` VALUES ('9685', 'Sn704', '7940.00');
INSERT INTO `mx_balance` VALUES ('9686', 'Sn704', '7890.00');
INSERT INTO `mx_balance` VALUES ('9687', 'Sn704', '7990.00');
INSERT INTO `mx_balance` VALUES ('9688', 'sn705', '13660.00');
INSERT INTO `mx_balance` VALUES ('9689', 'sn705', '13560.00');
INSERT INTO `mx_balance` VALUES ('9690', 'sn705', '13460.00');
INSERT INTO `mx_balance` VALUES ('9691', 'sn705', '13560.00');
INSERT INTO `mx_balance` VALUES ('9692', 'sn705', '13460.00');
INSERT INTO `mx_balance` VALUES ('9693', 'sn705', '13560.00');
INSERT INTO `mx_balance` VALUES ('9694', 'sn705', '13660.00');
INSERT INTO `mx_balance` VALUES ('9695', 'sn705', '13560.00');
INSERT INTO `mx_balance` VALUES ('9696', 'sn701', '20368.00');
INSERT INTO `mx_balance` VALUES ('9697', 'sn703', '45094.00');
INSERT INTO `mx_balance` VALUES ('9698', 'sn703', '45044.00');
INSERT INTO `mx_balance` VALUES ('9699', 'sn703', '45144.00');
INSERT INTO `mx_balance` VALUES ('9700', 'sn703', '45094.00');
INSERT INTO `mx_balance` VALUES ('9701', 'sn703', '45044.00');
INSERT INTO `mx_balance` VALUES ('9702', 'sn703', '45144.00');
INSERT INTO `mx_balance` VALUES ('9703', 'sn701', '20338.00');
INSERT INTO `mx_balance` VALUES ('9704', 'sn705', '13460.00');
INSERT INTO `mx_balance` VALUES ('9705', 'sn705', '13560.00');
INSERT INTO `mx_balance` VALUES ('9706', 'expert132', '145345.00');
INSERT INTO `mx_balance` VALUES ('9707', 'expert132', '145295.00');
INSERT INTO `mx_balance` VALUES ('9708', 'sn705', '13510.00');
INSERT INTO `mx_balance` VALUES ('9709', 'sn705', '13460.00');
INSERT INTO `mx_balance` VALUES ('9710', 'expert132', '145195.00');
INSERT INTO `mx_balance` VALUES ('9711', 'expert132', '145285.00');
INSERT INTO `mx_balance` VALUES ('9712', 'sn705', '13550.00');
INSERT INTO `mx_balance` VALUES ('9713', 'sn702', '44250.00');
INSERT INTO `mx_balance` VALUES ('9714', 'sn702', '44240.00');
INSERT INTO `mx_balance` VALUES ('9715', 'sn702', '44220.00');
INSERT INTO `mx_balance` VALUES ('9716', 'sn702', '44200.00');
INSERT INTO `mx_balance` VALUES ('9717', 'sn705', '13540.00');
INSERT INTO `mx_balance` VALUES ('9718', 'sn705', '13549.00');
INSERT INTO `mx_balance` VALUES ('9719', 'sn703', '45143.00');
INSERT INTO `mx_balance` VALUES ('9720', 'sn702', '44190.00');
INSERT INTO `mx_balance` VALUES ('9721', 'sn701', '20238.00');
INSERT INTO `mx_balance` VALUES ('9722', 'sn701', '20218.00');
INSERT INTO `mx_balance` VALUES ('9723', 'sn701', '20308.00');
INSERT INTO `mx_balance` VALUES ('9724', 'sn701', '20208.00');
INSERT INTO `mx_balance` VALUES ('9725', 'sn701', '20188.00');
INSERT INTO `mx_balance` VALUES ('9726', 'sn701', '20278.00');
INSERT INTO `mx_balance` VALUES ('9727', 'sn701', '20248.00');
INSERT INTO `mx_balance` VALUES ('9728', 'sn701', '20228.00');
INSERT INTO `mx_balance` VALUES ('9729', 'sn701', '20128.00');
INSERT INTO `mx_balance` VALUES ('9730', 'sn701', '20108.00');
INSERT INTO `mx_balance` VALUES ('9731', 'sn701', '20468.00');
INSERT INTO `mx_balance` VALUES ('9732', 'sn701', '20368.00');
INSERT INTO `mx_balance` VALUES ('9733', 'sn701', '20348.00');
INSERT INTO `mx_balance` VALUES ('9734', 'sn701', '20708.00');
INSERT INTO `mx_balance` VALUES ('9735', 'sn701', '20608.00');
INSERT INTO `mx_balance` VALUES ('9736', 'sn701', '20508.00');
INSERT INTO `mx_balance` VALUES ('9737', 'sn701', '20468.00');
INSERT INTO `mx_balance` VALUES ('9738', 'sn701', '20558.00');
INSERT INTO `mx_balance` VALUES ('9739', 'sn701', '20458.00');
INSERT INTO `mx_balance` VALUES ('9740', 'sn701', '20438.00');
INSERT INTO `mx_balance` VALUES ('9741', 'sn701', '20888.00');
INSERT INTO `mx_balance` VALUES ('9742', 'sn701', '20788.00');
INSERT INTO `mx_balance` VALUES ('9743', 'sn701', '20748.00');
INSERT INTO `mx_balance` VALUES ('9744', 'sn701', '20648.00');
INSERT INTO `mx_balance` VALUES ('9745', 'sn701', '20628.00');
INSERT INTO `mx_balance` VALUES ('9746', 'sn701', '21528.00');
INSERT INTO `mx_balance` VALUES ('9747', 'sn701', '21428.00');
INSERT INTO `mx_balance` VALUES ('9748', 'sn703', '45133.00');
INSERT INTO `mx_balance` VALUES ('9749', 'sn703', '45123.00');
INSERT INTO `mx_balance` VALUES ('9750', 'sn701', '21328.00');
INSERT INTO `mx_balance` VALUES ('9751', 'sn703', '45113.00');
INSERT INTO `mx_balance` VALUES ('9752', 'sn701', '21268.00');
INSERT INTO `mx_balance` VALUES ('9753', 'sn703', '45103.00');
INSERT INTO `mx_balance` VALUES ('9754', 'sn703', '45093.00');
INSERT INTO `mx_balance` VALUES ('9755', 'sn701', '21168.00');
INSERT INTO `mx_balance` VALUES ('9756', 'sn703', '45083.00');
INSERT INTO `mx_balance` VALUES ('9757', 'sn703', '45073.00');
INSERT INTO `mx_balance` VALUES ('9758', 'sn701', '21028.00');
INSERT INTO `mx_balance` VALUES ('9759', 'sn701', '20928.00');
INSERT INTO `mx_balance` VALUES ('9760', 'sn701', '20828.00');
INSERT INTO `mx_balance` VALUES ('9761', 'sn701', '20728.00');
INSERT INTO `mx_balance` VALUES ('9762', 'sn703', '45053.00');
INSERT INTO `mx_balance` VALUES ('9763', 'sn703', '45043.00');
INSERT INTO `mx_balance` VALUES ('9764', 'sn701', '20628.00');
INSERT INTO `mx_balance` VALUES ('9765', 'sn701', '20608.00');
INSERT INTO `mx_balance` VALUES ('9766', 'sn701', '20508.00');
INSERT INTO `mx_balance` VALUES ('9767', 'sn701', '20488.00');
INSERT INTO `mx_balance` VALUES ('9768', 'sn701', '20388.00');
INSERT INTO `mx_balance` VALUES ('9769', 'sn701', '20358.00');
INSERT INTO `mx_balance` VALUES ('9770', 'sn702', '44160.00');
INSERT INTO `mx_balance` VALUES ('9771', 'sn701', '20298.00');
INSERT INTO `mx_balance` VALUES ('9772', 'sn701', '20258.00');
INSERT INTO `mx_balance` VALUES ('9773', 'sn701', '19958.00');
INSERT INTO `mx_balance` VALUES ('9774', 'sn701', '19938.00');
INSERT INTO `mx_balance` VALUES ('9775', 'sn705', '13349.00');
INSERT INTO `mx_balance` VALUES ('9776', 'sn701', '19908.00');
INSERT INTO `mx_balance` VALUES ('9777', 'sn701', '19878.00');
INSERT INTO `mx_balance` VALUES ('9778', 'sn701', '19868.00');
INSERT INTO `mx_balance` VALUES ('9779', 'sn701', '19848.00');
INSERT INTO `mx_balance` VALUES ('9780', 'sn701', '19828.00');
INSERT INTO `mx_balance` VALUES ('9781', 'sn701', '19808.00');
INSERT INTO `mx_balance` VALUES ('9782', 'sn705', '13319.00');
INSERT INTO `mx_balance` VALUES ('9783', 'sn701', '19778.00');
INSERT INTO `mx_balance` VALUES ('9784', 'sn705', '13309.00');
INSERT INTO `mx_balance` VALUES ('9785', 'sn701', '19758.00');
INSERT INTO `mx_balance` VALUES ('9786', 'sn702', '44110.00');
INSERT INTO `mx_balance` VALUES ('9787', 'sn705', '13279.00');
INSERT INTO `mx_balance` VALUES ('9788', 'sn701', '19738.00');
INSERT INTO `mx_balance` VALUES ('9789', 'sn702', '44050.00');
INSERT INTO `mx_balance` VALUES ('9790', 'sn701', '19728.00');
INSERT INTO `mx_balance` VALUES ('9791', 'sn702', '44030.00');
INSERT INTO `mx_balance` VALUES ('9792', 'sn702', '43930.00');
INSERT INTO `mx_balance` VALUES ('9793', 'sn702', '43890.00');
INSERT INTO `mx_balance` VALUES ('9794', 'sn702', '43880.00');
INSERT INTO `mx_balance` VALUES ('9795', 'sn703', '45033.00');
INSERT INTO `mx_balance` VALUES ('9796', 'sn703', '45023.00');
INSERT INTO `mx_balance` VALUES ('9797', 'sn703', '45013.00');
INSERT INTO `mx_balance` VALUES ('9798', 'sn703', '45003.00');
INSERT INTO `mx_balance` VALUES ('9799', 'sn703', '44983.00');
INSERT INTO `mx_balance` VALUES ('9800', 'sn703', '44973.00');
INSERT INTO `mx_balance` VALUES ('9801', 'sn703', '44963.00');
INSERT INTO `mx_balance` VALUES ('9802', 'sn703', '44953.00');
INSERT INTO `mx_balance` VALUES ('9803', 'sn703', '44943.00');
INSERT INTO `mx_balance` VALUES ('9804', 'sn703', '44933.00');
INSERT INTO `mx_balance` VALUES ('9805', 'Sn704', '7985.00');
INSERT INTO `mx_balance` VALUES ('9806', 'Sn704', '7980.00');
INSERT INTO `mx_balance` VALUES ('9807', 'Sn704', '7989.00');
INSERT INTO `mx_balance` VALUES ('9808', 'sn701', '19648.00');
INSERT INTO `mx_balance` VALUES ('9809', 'sn701', '19448.00');
INSERT INTO `mx_balance` VALUES ('9810', 'sn701', '19328.00');
INSERT INTO `mx_balance` VALUES ('9811', 'sn701', '19508.00');
INSERT INTO `mx_balance` VALUES ('9812', 'sn701', '19308.00');
INSERT INTO `mx_balance` VALUES ('9813', 'sn701', '19128.00');
INSERT INTO `mx_balance` VALUES ('9814', 'sn701', '19108.00');
INSERT INTO `mx_balance` VALUES ('9815', 'sn701', '19378.00');
INSERT INTO `mx_balance` VALUES ('9816', 'sn701', '19158.00');
INSERT INTO `mx_balance` VALUES ('9817', 'sn701', '19148.00');
INSERT INTO `mx_balance` VALUES ('9818', 'sn701', '19108.00');
INSERT INTO `mx_balance` VALUES ('9819', 'sn701', '19068.00');
INSERT INTO `mx_balance` VALUES ('9820', 'sn705', '13269.00');
INSERT INTO `mx_balance` VALUES ('9821', 'sn701', '18818.00');
INSERT INTO `mx_balance` VALUES ('9822', 'sn701', '18798.00');
INSERT INTO `mx_balance` VALUES ('9823', 'sn701', '18618.00');
INSERT INTO `mx_balance` VALUES ('9824', 'sn701', '18578.00');
INSERT INTO `mx_balance` VALUES ('9825', 'sn701', '18848.00');
INSERT INTO `mx_balance` VALUES ('9826', 'sn701', '18748.00');
INSERT INTO `mx_balance` VALUES ('9827', 'sn701', '18688.00');
INSERT INTO `mx_balance` VALUES ('9828', 'sn701', '18778.00');
INSERT INTO `mx_balance` VALUES ('9829', 'sn701', '18728.00');
INSERT INTO `mx_balance` VALUES ('9830', 'sn701', '18678.00');
INSERT INTO `mx_balance` VALUES ('9831', 'sn701', '18638.00');
INSERT INTO `mx_balance` VALUES ('9832', 'sn701', '18608.00');
INSERT INTO `mx_balance` VALUES ('9833', 'sn701', '18588.00');
INSERT INTO `mx_balance` VALUES ('9834', 'sn701', '18548.00');
INSERT INTO `mx_balance` VALUES ('9835', 'sn701', '18498.00');
INSERT INTO `mx_balance` VALUES ('9836', 'sn701', '18448.00');
INSERT INTO `mx_balance` VALUES ('9837', 'sn701', '18438.00');
INSERT INTO `mx_balance` VALUES ('9838', 'sn701', '18388.00');
INSERT INTO `mx_balance` VALUES ('9839', 'sn701', '18358.00');
INSERT INTO `mx_balance` VALUES ('9840', 'sn701', '18328.00');
INSERT INTO `mx_balance` VALUES ('9841', 'sn701', '18308.00');
INSERT INTO `mx_balance` VALUES ('9842', 'sn701', '18288.00');
INSERT INTO `mx_balance` VALUES ('9843', 'sn701', '18268.00');
INSERT INTO `mx_balance` VALUES ('9844', 'sn701', '18258.00');
INSERT INTO `mx_balance` VALUES ('9845', 'sn701', '18198.00');
INSERT INTO `mx_balance` VALUES ('9846', 'sn701', '18148.00');
INSERT INTO `mx_balance` VALUES ('9847', 'sn701', '18128.00');
INSERT INTO `mx_balance` VALUES ('9848', 'sn701', '18078.00');
INSERT INTO `mx_balance` VALUES ('9849', 'sn701', '18018.00');
INSERT INTO `mx_balance` VALUES ('9850', 'sn701', '17958.00');
INSERT INTO `mx_balance` VALUES ('9851', 'sn705', '13219.00');
INSERT INTO `mx_balance` VALUES ('9852', 'sn701', '17908.00');
INSERT INTO `mx_balance` VALUES ('9853', 'sn705', '13209.00');
INSERT INTO `mx_balance` VALUES ('9854', 'sn701', '17868.00');
INSERT INTO `mx_balance` VALUES ('9855', 'sn702', '43870.00');
INSERT INTO `mx_balance` VALUES ('9856', 'sn701', '17818.00');
INSERT INTO `mx_balance` VALUES ('9857', 'sn701', '17788.00');
INSERT INTO `mx_balance` VALUES ('9858', 'sn701', '17738.00');
INSERT INTO `mx_balance` VALUES ('9859', 'sn701', '17698.00');
INSERT INTO `mx_balance` VALUES ('9860', 'sn701', '17658.00');
INSERT INTO `mx_balance` VALUES ('9861', 'sn701', '17648.00');
INSERT INTO `mx_balance` VALUES ('9862', 'sn701', '17598.00');
INSERT INTO `mx_balance` VALUES ('9863', 'sn701', '17568.00');
INSERT INTO `mx_balance` VALUES ('9864', 'sn701', '17548.00');
INSERT INTO `mx_balance` VALUES ('9865', 'sn701', '17508.00');
INSERT INTO `mx_balance` VALUES ('9866', 'sn701', '17458.00');
INSERT INTO `mx_balance` VALUES ('9867', 'sn701', '17448.00');
INSERT INTO `mx_balance` VALUES ('9868', 'sn701', '17418.00');
INSERT INTO `mx_balance` VALUES ('9869', 'sn701', '17508.00');
INSERT INTO `mx_balance` VALUES ('9870', 'sn701', '17468.00');
INSERT INTO `mx_balance` VALUES ('9871', 'sn701', '17418.00');
INSERT INTO `mx_balance` VALUES ('9872', 'sn701', '17368.00');
INSERT INTO `mx_balance` VALUES ('9873', 'sn701', '17268.00');
INSERT INTO `mx_balance` VALUES ('9874', 'sn701', '17238.00');
INSERT INTO `mx_balance` VALUES ('9875', 'sn703', '44923.00');
INSERT INTO `mx_balance` VALUES ('9876', 'sn701', '17088.00');
INSERT INTO `mx_balance` VALUES ('9877', 'sn701', '17038.00');
INSERT INTO `mx_balance` VALUES ('9878', 'sn701', '17128.00');
INSERT INTO `mx_balance` VALUES ('9879', 'sn701', '16978.00');
INSERT INTO `mx_balance` VALUES ('9880', 'sn701', '17068.00');
INSERT INTO `mx_balance` VALUES ('9881', 'sn701', '16958.00');
INSERT INTO `mx_balance` VALUES ('9882', 'sn701', '16948.00');
INSERT INTO `mx_balance` VALUES ('9883', 'sn701', '16938.00');
INSERT INTO `mx_balance` VALUES ('9884', 'sn701', '16888.00');
INSERT INTO `mx_balance` VALUES ('9885', 'sn701', '16978.00');
INSERT INTO `mx_balance` VALUES ('9886', 'sn701', '16938.00');
INSERT INTO `mx_balance` VALUES ('9887', 'sn701', '16868.00');
INSERT INTO `mx_balance` VALUES ('9888', 'sn701', '16858.00');
INSERT INTO `mx_balance` VALUES ('9889', 'sn701', '16808.00');
INSERT INTO `mx_balance` VALUES ('9890', 'sn701', '16768.00');
INSERT INTO `mx_balance` VALUES ('9891', 'sn701', '16738.00');
INSERT INTO `mx_balance` VALUES ('9892', 'sn701', '16728.00');
INSERT INTO `mx_balance` VALUES ('9893', 'sn703', '44893.00');
INSERT INTO `mx_balance` VALUES ('9894', 'sn703', '44883.00');
INSERT INTO `mx_balance` VALUES ('9895', 'sn703', '44873.00');
INSERT INTO `mx_balance` VALUES ('9896', 'sn705', '13189.00');
INSERT INTO `mx_balance` VALUES ('9897', 'sn703', '44863.00');
INSERT INTO `mx_balance` VALUES ('9898', 'sn705', '13169.00');
INSERT INTO `mx_balance` VALUES ('9899', 'sn705', '13149.00');
INSERT INTO `mx_balance` VALUES ('9900', 'sn703', '44853.00');
INSERT INTO `mx_balance` VALUES ('9901', 'sn705', '13049.00');
INSERT INTO `mx_balance` VALUES ('9902', 'sn705', '12899.00');
INSERT INTO `mx_balance` VALUES ('9903', 'sn705', '12799.00');
INSERT INTO `mx_balance` VALUES ('9904', 'sn705', '12769.00');
INSERT INTO `mx_balance` VALUES ('9905', 'sn703', '44813.00');
INSERT INTO `mx_balance` VALUES ('9906', 'sn703', '44793.00');
INSERT INTO `mx_balance` VALUES ('9907', 'sn701', '16698.00');
INSERT INTO `mx_balance` VALUES ('9908', 'sn703', '44783.00');
INSERT INTO `mx_balance` VALUES ('9909', 'sn701', '16668.00');
INSERT INTO `mx_balance` VALUES ('9910', 'sn705', '12719.00');
INSERT INTO `mx_balance` VALUES ('9911', 'sn703', '44773.00');
INSERT INTO `mx_balance` VALUES ('9912', 'sn705', '12669.00');
INSERT INTO `mx_balance` VALUES ('9913', 'sn705', '12639.00');
INSERT INTO `mx_balance` VALUES ('9914', 'sn705', '12609.00');
INSERT INTO `mx_balance` VALUES ('9915', 'sn703', '44763.00');
INSERT INTO `mx_balance` VALUES ('9916', 'sn703', '44753.00');
INSERT INTO `mx_balance` VALUES ('9917', 'sn701', '16658.00');
INSERT INTO `mx_balance` VALUES ('9918', 'sn703', '44743.00');
INSERT INTO `mx_balance` VALUES ('9919', 'sn703', '44723.00');
INSERT INTO `mx_balance` VALUES ('9920', 'sn701', '16638.00');
INSERT INTO `mx_balance` VALUES ('9921', 'sn701', '16608.00');
INSERT INTO `mx_balance` VALUES ('9922', 'sn701', '16588.00');
INSERT INTO `mx_balance` VALUES ('9923', 'sn701', '16558.00');
INSERT INTO `mx_balance` VALUES ('9924', 'sn701', '16538.00');
INSERT INTO `mx_balance` VALUES ('9925', 'sn701', '16528.00');
INSERT INTO `mx_balance` VALUES ('9926', 'sn701', '16508.00');
INSERT INTO `mx_balance` VALUES ('9927', 'sn701', '16478.00');
INSERT INTO `mx_balance` VALUES ('9928', 'sn701', '16468.00');
INSERT INTO `mx_balance` VALUES ('9929', 'sn701', '16418.00');
INSERT INTO `mx_balance` VALUES ('9930', 'sn703', '44693.00');
INSERT INTO `mx_balance` VALUES ('9931', 'sn703', '44643.00');
INSERT INTO `mx_balance` VALUES ('9932', 'sn701', '16388.00');
INSERT INTO `mx_balance` VALUES ('9933', 'sn702', '43860.00');
INSERT INTO `mx_balance` VALUES ('9934', 'sn702', '43850.00');
INSERT INTO `mx_balance` VALUES ('9935', 'sn701', '16368.00');
INSERT INTO `mx_balance` VALUES ('9936', 'sn701', '16338.00');
INSERT INTO `mx_balance` VALUES ('9937', 'sn703', '44633.00');
INSERT INTO `mx_balance` VALUES ('9938', 'sn701', '16308.00');
INSERT INTO `mx_balance` VALUES ('9939', 'sn701', '16288.00');
INSERT INTO `mx_balance` VALUES ('9940', 'sn701', '16278.00');
INSERT INTO `mx_balance` VALUES ('9941', 'sn701', '16218.00');
INSERT INTO `mx_balance` VALUES ('9942', 'sn703', '44623.00');
INSERT INTO `mx_balance` VALUES ('9943', 'sn703', '44603.00');
INSERT INTO `mx_balance` VALUES ('9944', 'sn703', '44593.00');
INSERT INTO `mx_balance` VALUES ('9945', 'sn701', '16208.00');
INSERT INTO `mx_balance` VALUES ('9946', 'sn701', '16198.00');
INSERT INTO `mx_balance` VALUES ('9947', 'sn701', '14198.00');
INSERT INTO `mx_balance` VALUES ('9948', 'sn701', '14158.00');
INSERT INTO `mx_balance` VALUES ('9949', 'sn701', '14118.00');
INSERT INTO `mx_balance` VALUES ('9950', 'sn705', '12589.00');
INSERT INTO `mx_balance` VALUES ('9951', 'sn705', '12529.00');
INSERT INTO `mx_balance` VALUES ('9952', 'sn701', '14068.00');
INSERT INTO `mx_balance` VALUES ('9953', 'sn701', '13968.00');
INSERT INTO `mx_balance` VALUES ('9954', 'sn701', '13868.00');
INSERT INTO `mx_balance` VALUES ('9955', 'sn701', '13768.00');
INSERT INTO `mx_balance` VALUES ('9956', 'sn701', '13718.00');
INSERT INTO `mx_balance` VALUES ('9957', 'sn701', '13668.00');
INSERT INTO `mx_balance` VALUES ('9958', 'sn701', '13568.00');
INSERT INTO `mx_balance` VALUES ('9959', 'sn701', '13468.00');
INSERT INTO `mx_balance` VALUES ('9960', 'sn701', '13368.00');
INSERT INTO `mx_balance` VALUES ('9961', 'sn703', '44563.00');
INSERT INTO `mx_balance` VALUES ('9962', 'sn703', '44523.00');
INSERT INTO `mx_balance` VALUES ('9963', 'sn703', '44483.00');
INSERT INTO `mx_balance` VALUES ('9964', 'sn701', '13328.00');
INSERT INTO `mx_balance` VALUES ('9965', 'sn701', '13298.00');
INSERT INTO `mx_balance` VALUES ('9966', 'sn701', '13268.00');
INSERT INTO `mx_balance` VALUES ('9967', 'sn701', '13218.00');
INSERT INTO `mx_balance` VALUES ('9968', 'sn701', '13188.00');
INSERT INTO `mx_balance` VALUES ('9969', 'sn701', '13178.00');
INSERT INTO `mx_balance` VALUES ('9970', 'sn701', '13138.00');
INSERT INTO `mx_balance` VALUES ('9971', 'sn701', '13108.00');
INSERT INTO `mx_balance` VALUES ('9972', 'sn701', '13058.00');
INSERT INTO `mx_balance` VALUES ('9973', 'sn701', '13038.00');
INSERT INTO `mx_balance` VALUES ('9974', 'sn701', '12978.00');
INSERT INTO `mx_balance` VALUES ('9975', 'sn701', '12958.00');
INSERT INTO `mx_balance` VALUES ('9976', 'sn701', '12908.00');
INSERT INTO `mx_balance` VALUES ('9977', 'sn701', '12888.00');
INSERT INTO `mx_balance` VALUES ('9978', 'sn701', '12978.00');
INSERT INTO `mx_balance` VALUES ('9979', 'sn701', '12928.00');
INSERT INTO `mx_balance` VALUES ('9980', 'sn701', '12828.00');
INSERT INTO `mx_balance` VALUES ('9981', 'sn701', '12788.00');
INSERT INTO `mx_balance` VALUES ('9982', 'sn701', '12728.00');
INSERT INTO `mx_balance` VALUES ('9983', 'sn701', '12818.00');
INSERT INTO `mx_balance` VALUES ('9984', 'sn701', '12908.00');
INSERT INTO `mx_balance` VALUES ('9985', 'sn701', '12808.00');
INSERT INTO `mx_balance` VALUES ('9986', 'sn701', '12748.00');
INSERT INTO `mx_balance` VALUES ('9987', 'sn701', '12728.00');
INSERT INTO `mx_balance` VALUES ('9988', 'sn701', '12688.00');
INSERT INTO `mx_balance` VALUES ('9989', 'sn701', '12778.00');
INSERT INTO `mx_balance` VALUES ('9990', 'sn701', '12738.00');
INSERT INTO `mx_balance` VALUES ('9991', 'sn701', '12708.00');
INSERT INTO `mx_balance` VALUES ('9992', 'sn701', '12688.00');
INSERT INTO `mx_balance` VALUES ('9993', 'sn701', '12588.00');
INSERT INTO `mx_balance` VALUES ('9994', 'sn701', '12528.00');
INSERT INTO `mx_balance` VALUES ('9995', 'sn701', '12508.00');
INSERT INTO `mx_balance` VALUES ('9996', 'sn701', '12468.00');
INSERT INTO `mx_balance` VALUES ('9997', 'sn701', '12558.00');
INSERT INTO `mx_balance` VALUES ('9998', 'sn701', '12458.00');
INSERT INTO `mx_balance` VALUES ('9999', 'sn701', '12398.00');
INSERT INTO `mx_balance` VALUES ('10000', 'sn701', '12368.00');
INSERT INTO `mx_balance` VALUES ('10001', 'sn701', '12288.00');
INSERT INTO `mx_balance` VALUES ('10002', 'sn701', '12268.00');
INSERT INTO `mx_balance` VALUES ('10003', 'sn701', '12208.00');
INSERT INTO `mx_balance` VALUES ('10004', 'sn701', '12168.00');
INSERT INTO `mx_balance` VALUES ('10005', 'sn701', '12088.00');
INSERT INTO `mx_balance` VALUES ('10006', 'sn701', '12048.00');
INSERT INTO `mx_balance` VALUES ('10007', 'sn701', '12018.00');
INSERT INTO `mx_balance` VALUES ('10008', 'sn701', '11998.00');
INSERT INTO `mx_balance` VALUES ('10009', 'sn701', '11968.00');
INSERT INTO `mx_balance` VALUES ('10010', 'sn701', '11958.00');
INSERT INTO `mx_balance` VALUES ('10011', 'sn703', '44423.00');
INSERT INTO `mx_balance` VALUES ('10012', 'sn703', '44393.00');
INSERT INTO `mx_balance` VALUES ('10013', 'sn701', '11938.00');
INSERT INTO `mx_balance` VALUES ('10014', 'sn701', '11918.00');
INSERT INTO `mx_balance` VALUES ('10015', 'sn701', '11878.00');
INSERT INTO `mx_balance` VALUES ('10016', 'sn705', '12469.00');
INSERT INTO `mx_balance` VALUES ('10017', 'sn705', '12409.00');
INSERT INTO `mx_balance` VALUES ('10018', 'sn705', '12379.00');
INSERT INTO `mx_balance` VALUES ('10019', 'sn705', '12319.00');
INSERT INTO `mx_balance` VALUES ('10020', 'sn705', '12289.00');
INSERT INTO `mx_balance` VALUES ('10021', 'sn705', '12249.00');
INSERT INTO `mx_balance` VALUES ('10022', 'sn705', '12149.00');
INSERT INTO `mx_balance` VALUES ('10023', 'sn705', '12089.00');
INSERT INTO `mx_balance` VALUES ('10024', 'sn705', '12059.00');
INSERT INTO `mx_balance` VALUES ('10025', 'sn705', '11969.00');
INSERT INTO `mx_balance` VALUES ('10026', 'sn705', '11919.00');
INSERT INTO `mx_balance` VALUES ('10027', 'sn705', '11819.00');
INSERT INTO `mx_balance` VALUES ('10028', 'sn705', '11799.00');
INSERT INTO `mx_balance` VALUES ('10029', 'sn705', '11699.00');
INSERT INTO `mx_balance` VALUES ('10030', 'sn705', '11599.00');
INSERT INTO `mx_balance` VALUES ('10031', 'sn705', '11499.00');
INSERT INTO `mx_balance` VALUES ('10032', 'sn705', '11449.00');
INSERT INTO `mx_balance` VALUES ('10033', 'sn703', '44363.00');
INSERT INTO `mx_balance` VALUES ('10034', 'sn703', '44333.00');
INSERT INTO `mx_balance` VALUES ('10035', 'sn705', '11349.00');
INSERT INTO `mx_balance` VALUES ('10036', 'sn703', '44293.00');
INSERT INTO `mx_balance` VALUES ('10037', 'sn703', '44233.00');
INSERT INTO `mx_balance` VALUES ('10038', 'sn703', '44133.00');
INSERT INTO `mx_balance` VALUES ('10039', 'sn703', '43933.00');
INSERT INTO `mx_balance` VALUES ('10040', 'sn705', '11149.00');
INSERT INTO `mx_balance` VALUES ('10041', 'sn703', '43853.00');
INSERT INTO `mx_balance` VALUES ('10042', 'sn701', '11848.00');
INSERT INTO `mx_balance` VALUES ('10043', 'sn701', '11808.00');
INSERT INTO `mx_balance` VALUES ('10044', 'sn701', '11798.00');
INSERT INTO `mx_balance` VALUES ('10045', 'sn701', '11788.00');
INSERT INTO `mx_balance` VALUES ('10046', 'sn703', '43833.00');
INSERT INTO `mx_balance` VALUES ('10047', 'sn701', '11768.00');
INSERT INTO `mx_balance` VALUES ('10048', 'sn701', '11738.00');
INSERT INTO `mx_balance` VALUES ('10049', 'sn701', '11698.00');
INSERT INTO `mx_balance` VALUES ('10050', 'Sn705', '21149.00');
INSERT INTO `mx_balance` VALUES ('10051', 'sn701', '31698.00');
INSERT INTO `mx_balance` VALUES ('10052', 'sn701', '51698.00');
INSERT INTO `mx_balance` VALUES ('10053', 'sn701', '71698.00');
INSERT INTO `mx_balance` VALUES ('10054', 'sn701', '51698.00');
INSERT INTO `mx_balance` VALUES ('10055', 'sn701', '51638.00');
INSERT INTO `mx_balance` VALUES ('10056', 'sn701', '51598.00');
INSERT INTO `mx_balance` VALUES ('10057', 'sn701', '51568.00');
INSERT INTO `mx_balance` VALUES ('10058', 'sn703', '43653.00');
INSERT INTO `mx_balance` VALUES ('10059', 'sn701', '51548.00');
INSERT INTO `mx_balance` VALUES ('10060', 'sn701', '51518.00');
INSERT INTO `mx_balance` VALUES ('10061', 'sn703', '43643.00');
INSERT INTO `mx_balance` VALUES ('10062', 'sn701', '51498.00');
INSERT INTO `mx_balance` VALUES ('10063', 'sn701', '51488.00');
INSERT INTO `mx_balance` VALUES ('10064', 'sn701', '51438.00');
INSERT INTO `mx_balance` VALUES ('10065', 'sn701', '51378.00');
INSERT INTO `mx_balance` VALUES ('10066', 'sn701', '51338.00');
INSERT INTO `mx_balance` VALUES ('10067', 'sn701', '51318.00');
INSERT INTO `mx_balance` VALUES ('10068', 'sn701', '51278.00');
INSERT INTO `mx_balance` VALUES ('10069', 'sn701', '51268.00');
INSERT INTO `mx_balance` VALUES ('10070', 'sn701', '51248.00');
INSERT INTO `mx_balance` VALUES ('10071', 'sn701', '51238.00');
INSERT INTO `mx_balance` VALUES ('10072', 'sn701', '51228.00');
INSERT INTO `mx_balance` VALUES ('10073', 'sn701', '51218.00');
INSERT INTO `mx_balance` VALUES ('10074', 'sn703', '43603.00');
INSERT INTO `mx_balance` VALUES ('10075', 'sn703', '43583.00');
INSERT INTO `mx_balance` VALUES ('10076', 'sn703', '43573.00');
INSERT INTO `mx_balance` VALUES ('10077', 'sn703', '43513.00');
INSERT INTO `mx_balance` VALUES ('10078', 'sn701', '51168.00');
INSERT INTO `mx_balance` VALUES ('10079', 'sn703', '43453.00');
INSERT INTO `mx_balance` VALUES ('10080', 'sn703', '43403.00');
INSERT INTO `mx_balance` VALUES ('10081', 'sn701', '51138.00');
INSERT INTO `mx_balance` VALUES ('10082', 'sn703', '43343.00');
INSERT INTO `mx_balance` VALUES ('10083', 'sn701', '51128.00');
INSERT INTO `mx_balance` VALUES ('10084', 'sn701', '51098.00');
INSERT INTO `mx_balance` VALUES ('10085', 'sn701', '51088.00');
INSERT INTO `mx_balance` VALUES ('10086', 'sn701', '51068.00');
INSERT INTO `mx_balance` VALUES ('10087', 'sn701', '51038.00');
INSERT INTO `mx_balance` VALUES ('10088', 'sn701', '51018.00');
INSERT INTO `mx_balance` VALUES ('10089', 'sn701', '50998.00');
INSERT INTO `mx_balance` VALUES ('10090', 'sn701', '50958.00');
INSERT INTO `mx_balance` VALUES ('10091', 'sn701', '51048.00');
INSERT INTO `mx_balance` VALUES ('10092', 'sn701', '51018.00');
INSERT INTO `mx_balance` VALUES ('10093', 'sn701', '50958.00');
INSERT INTO `mx_balance` VALUES ('10094', 'sn701', '50938.00');
INSERT INTO `mx_balance` VALUES ('10095', 'sn701', '50898.00');
INSERT INTO `mx_balance` VALUES ('10096', 'sn701', '50878.00');
INSERT INTO `mx_balance` VALUES ('10097', 'sn701', '50858.00');
INSERT INTO `mx_balance` VALUES ('10098', 'sn701', '50838.00');
INSERT INTO `mx_balance` VALUES ('10099', 'sn701', '50818.00');
INSERT INTO `mx_balance` VALUES ('10100', 'sn701', '50778.00');
INSERT INTO `mx_balance` VALUES ('10101', 'sn701', '50768.00');
INSERT INTO `mx_balance` VALUES ('10102', 'sn701', '50748.00');
INSERT INTO `mx_balance` VALUES ('10103', 'sn701', '50738.00');
INSERT INTO `mx_balance` VALUES ('10104', 'sn701', '50718.00');
INSERT INTO `mx_balance` VALUES ('10105', 'sn701', '50668.00');
INSERT INTO `mx_balance` VALUES ('10106', 'sn701', '50648.00');
INSERT INTO `mx_balance` VALUES ('10107', 'sn701', '50638.00');
INSERT INTO `mx_balance` VALUES ('10108', 'sn701', '50618.00');
INSERT INTO `mx_balance` VALUES ('10109', 'sn701', '50588.00');
INSERT INTO `mx_balance` VALUES ('10110', 'sn701', '50568.00');
INSERT INTO `mx_balance` VALUES ('10111', 'sn701', '50548.00');
INSERT INTO `mx_balance` VALUES ('10112', '021001001', '10220.00');
INSERT INTO `mx_balance` VALUES ('10113', '021001001', '10120.00');
INSERT INTO `mx_balance` VALUES ('10114', '021001001', '10020.00');

-- ----------------------------
-- Table structure for `mx_barcode`
-- ----------------------------
DROP TABLE IF EXISTS `mx_barcode`;
CREATE TABLE `mx_barcode` (
  `br` bigint(20) default '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_barcode
-- ----------------------------

-- ----------------------------
-- Table structure for `mx_category`
-- ----------------------------
DROP TABLE IF EXISTS `mx_category`;
CREATE TABLE `mx_category` (
  `categoryID` int(11) NOT NULL auto_increment,
  `seoUri` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `categoryTitle` varchar(250) character set utf8 collate utf8_unicode_ci NOT NULL,
  `synopsis` text character set utf8 collate utf8_unicode_ci NOT NULL,
  `colorCode` varchar(20) default NULL,
  `imageName` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `headerTitle` varchar(250) default NULL,
  `headerImage` varchar(255) default NULL,
  `headerSyn` text,
  `parentID` int(11) NOT NULL default '0',
  `xOrder` int(11) NOT NULL,
  `metaDesc` varchar(160) NOT NULL,
  `metaKeyword` varchar(256) NOT NULL,
  `dateAdded` datetime NOT NULL default '0000-00-00 00:00:00',
  `dateModified` datetime NOT NULL default '0000-00-00 00:00:00',
  `modifiedBy` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_category
-- ----------------------------

-- ----------------------------
-- Table structure for `mx_info`
-- ----------------------------
DROP TABLE IF EXISTS `mx_info`;
CREATE TABLE `mx_info` (
  `gst` varchar(200) default NULL,
  `adID` int(11) default NULL,
  `version` int(11) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_info
-- ----------------------------
INSERT INTO `mx_info` VALUES ('fdsdfsfd', '1', '3');

-- ----------------------------
-- Table structure for `mx_key`
-- ----------------------------
DROP TABLE IF EXISTS `mx_key`;
CREATE TABLE `mx_key` (
  `keyID` int(11) NOT NULL auto_increment,
  `adminID` int(11) default NULL,
  `lotTime` time default NULL,
  `dateAdded` datetime default NULL,
  PRIMARY KEY  (`keyID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_key
-- ----------------------------
INSERT INTO `mx_key` VALUES ('1', '1', '12:15:00', '2021-08-09 12:15:01');
INSERT INTO `mx_key` VALUES ('2', '1', '12:30:00', '2021-08-09 12:30:01');

-- ----------------------------
-- Table structure for `mx_lottary`
-- ----------------------------
DROP TABLE IF EXISTS `mx_lottary`;
CREATE TABLE `mx_lottary` (
  `lotID` bigint(200) NOT NULL auto_increment,
  `gameID` int(11) default NULL,
  `cv` int(11) default NULL,
  `point` int(11) default NULL,
  `sernum` varchar(20) default NULL,
  `lotnum` varchar(20) default NULL,
  `cellID` varchar(20) default NULL,
  `uID` int(11) default NULL,
  `details` varchar(255) default NULL,
  `lotdate` date default NULL,
  `lotTime` time default NULL,
  `barcode` varchar(100) default NULL,
  `tranID` varchar(100) default NULL,
  `ticketTot` decimal(9,2) default NULL,
  `qtytot` int(11) default NULL,
  `printTime` time default NULL,
  `startPoint` decimal(9,2) default NULL,
  `endPoint` decimal(9,2) default NULL,
  `winPoint` decimal(9,2) default '0.00',
  `multx` int(11) default NULL,
  `dateAdded` datetime default NULL,
  `dateModified` datetime default NULL,
  `status` tinyint(1) default '1',
  `isadvance` int(11) default NULL,
  `printFlag` int(11) default NULL,
  `contribute` decimal(5,2) default NULL,
  `serviceChrg` decimal(5,2) default NULL,
  `curAdvDraw` varchar(20) default NULL,
  PRIMARY KEY  (`lotID`),
  UNIQUE KEY `idx1` (`lotID`),
  KEY `idx2` (`lotdate`,`lotTime`),
  KEY `idex3` (`tranID`),
  KEY `idx4` (`cellID`),
  KEY `idx5` (`uID`),
  KEY `idx6` (`cv`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_lottary
-- ----------------------------
INSERT INTO `mx_lottary` VALUES ('1', '1', '10', null, null, null, '0', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('2', '1', '10', null, null, null, '1', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('3', '1', '10', null, null, null, '2', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('4', '1', '10', null, null, null, '3', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('5', '1', '10', null, null, null, '4', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('6', '1', '10', null, null, null, '5', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('7', '1', '10', null, null, null, '6', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('8', '1', '10', null, null, null, '7', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('9', '1', '10', null, null, null, '8', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('10', '1', '10', null, null, null, '9', '0', null, '2023-08-10', '12:04:00', '26804', '26804', '100.00', null, '12:03:00', '10220.00', '10120.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('11', '1', '10', null, null, null, '0', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('12', '1', '10', null, null, null, '1', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('13', '1', '10', null, null, null, '2', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('14', '1', '10', null, null, null, '3', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('15', '1', '10', null, null, null, '4', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('16', '1', '10', null, null, null, '5', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('17', '1', '10', null, null, null, '6', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('18', '1', '10', null, null, null, '7', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('19', '1', '10', null, null, null, '8', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);
INSERT INTO `mx_lottary` VALUES ('20', '1', '10', null, null, null, '9', '0', null, '2023-08-10', '12:04:00', '7389', '7389', '100.00', null, '12:03:00', '10120.00', '10020.00', '0.00', '1', null, null, '1', null, null, null, null, null);

-- ----------------------------
-- Table structure for `mx_multiple`
-- ----------------------------
DROP TABLE IF EXISTS `mx_multiple`;
CREATE TABLE `mx_multiple` (
  `multiID` int(11) NOT NULL auto_increment,
  `gameID` int(11) default NULL,
  `lotTime` time default NULL,
  `lotdate` date default NULL,
  `multiple` int(11) default NULL,
  `dateAdded` datetime default NULL,
  `dateModified` datetime default NULL,
  `status` tinyint(1) default '1',
  PRIMARY KEY  (`multiID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_multiple
-- ----------------------------
INSERT INTO `mx_multiple` VALUES ('1', '1', '02:42:00', '2023-05-10', '4', '2023-05-10 14:27:46', null, '1');
INSERT INTO `mx_multiple` VALUES ('2', '1', '02:54:00', '2023-05-12', '3', '2023-05-12 14:46:02', null, '1');

-- ----------------------------
-- Table structure for `mx_page`
-- ----------------------------
DROP TABLE IF EXISTS `mx_page`;
CREATE TABLE `mx_page` (
  `pageID` int(11) NOT NULL auto_increment,
  `seoUri` varchar(255) NOT NULL,
  `pageTitle` varchar(255) NOT NULL,
  `subTitle` varchar(255) default NULL,
  `synopsis` text,
  `pageContent` text,
  `pageImage` varchar(100) NOT NULL,
  `templateFile` varchar(100) NOT NULL,
  `headerTitle` varchar(255) default NULL,
  `headerImage` varchar(255) default NULL,
  `headerSyn` text,
  `dateAdded` datetime NOT NULL,
  `dateModified` datetime NOT NULL default '0000-00-00 00:00:00',
  `modifiedBy` int(11) default NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`pageID`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mx_page
-- ----------------------------
INSERT INTO `mx_page` VALUES ('1', 'agent', 'Agent', null, null, '<p>\r\n	Today we have started thinking about this company very seriously. If you think of today in India, the educated unemployed youth is rich in abundance. If the five lakh young people are employed in one year, pandhra can get lakhs of educated unemployed young students, so that we can think of how much job is needed right now. Today, if you want to start a business, you have to spend lakhs of rupees but even if you do not have enough money, then how to do business and how to live? The big question is standing in front of the people. It was so expensive today that ordinary people could not afford it. The company has planned that at least one million people can work here and earn money.</p>\r\n', '0595251001520679797.jpg', 'agent', null, '', null, '2018-03-10 16:33:17', '2020-12-28 17:03:22', null, '1');
INSERT INTO `mx_page` VALUES ('11', 'agent-balance', 'Agent Balance', null, null, '', '', 'agent-balance', null, '', null, '2019-11-18 06:50:30', '2020-12-29 10:48:33', null, '1');
INSERT INTO `mx_page` VALUES ('2', 'ticket', 'Ticket', null, null, '<p>\r\n	This is contact info</p>\r\n', '0868140001520680804.jpg', 'ticket', null, '', null, '2018-03-10 16:41:08', '2018-04-27 13:19:28', null, '1');
INSERT INTO `mx_page` VALUES ('3', 'balance', 'Balance', null, null, '', '', 'balance', null, '', null, '2018-04-27 13:17:03', '2020-12-29 10:52:53', null, '1');
INSERT INTO `mx_page` VALUES ('4', 'barcode', 'Barcode', null, null, '', '', 'barcode', null, '', null, '2018-04-27 13:17:55', '2020-12-29 11:04:51', null, '1');
INSERT INTO `mx_page` VALUES ('5', 'game-history', 'game history', null, null, '<p>\r\n	.</p>\r\n', '', 'game-history', null, '', null, '2018-04-27 13:18:36', '2020-12-29 11:05:49', null, '1');
INSERT INTO `mx_page` VALUES ('6', 'all-modal', 'All Modal', null, null, '', '', 'all-modal', null, '', null, '2018-10-12 13:09:53', '2020-12-29 11:10:29', null, '1');
INSERT INTO `mx_page` VALUES ('7', 'result-single', 'result single', null, null, '', '', 'result-single', null, '', null, '2018-10-26 05:43:24', '2020-12-29 11:15:46', null, '1');
INSERT INTO `mx_page` VALUES ('8', 'r-play', 'R-play', null, null, '', '', 'r-play', null, '', null, '2018-10-26 05:43:44', '2020-12-29 11:16:42', null, '1');
INSERT INTO `mx_page` VALUES ('9', 'report', 'report', null, null, null, '', 'report', null, '', null, '2018-11-15 13:26:29', '2018-12-22 06:41:54', null, '1');
INSERT INTO `mx_page` VALUES ('10', 'agent-list', 'Agent List', null, null, '', '', 'agent-list', null, '', null, '2019-10-01 06:22:04', '2019-10-01 06:27:01', null, '1');
INSERT INTO `mx_page` VALUES ('12', 'retailer-list', 'Retailer List', null, null, null, '', 'retailer-list', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('13', 'ticket-list', 'Ticket List', null, null, null, '', 'ticket-list', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('14', 'user-ticket', 'User Ticket', null, null, null, '', 'user-ticket', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('15', 'all-result', 'all result', null, null, null, '', 'all-result', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('16', 'live-list', 'Live List', null, null, null, '', 'live-list', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('17', 'user-sell-ticket', 'User Sell Ticket', null, null, null, '', 'user-sell-ticket', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('18', 'agent-list1', 'Agent List1', null, null, null, '', 'agent-list1', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('19', 'wining-list', 'Wining List', null, null, null, '', 'wining-list', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('20', 'log-data', 'log data', null, null, null, '', 'log-data', null, null, null, '2019-10-01 06:22:04', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('21', 'result', 'Result', null, null, null, '', 'result', null, null, null, '2021-01-27 13:31:14', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('22', 'lot-result', 'Lot Result', null, null, null, '', 'lot-result', null, null, null, '2021-01-28 17:36:43', '0000-00-00 00:00:00', null, '1');
INSERT INTO `mx_page` VALUES ('23', 'live-betting', 'live-betting', null, null, null, '', 'live-betting', null, null, null, '2021-12-08 19:07:03', '2021-12-08 19:07:03', null, '1');
INSERT INTO `mx_page` VALUES ('24', 'dashboard', 'Dashboard', null, null, null, '', 'dashboard', null, null, null, '2022-07-22 12:28:04', '0000-00-00 00:00:00', null, '1');

-- ----------------------------
-- Table structure for `mx_percentage`
-- ----------------------------
DROP TABLE IF EXISTS `mx_percentage`;
CREATE TABLE `mx_percentage` (
  `perID` int(11) NOT NULL auto_increment,
  `per` int(11) default NULL,
  `dateAdded` datetime default NULL,
  PRIMARY KEY  (`perID`)
) ENGINE=InnoDB AUTO_INCREMENT=4230 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_percentage
-- ----------------------------
INSERT INTO `mx_percentage` VALUES ('4229', '0', '2022-06-06 08:29:44');

-- ----------------------------
-- Table structure for `mx_post`
-- ----------------------------
DROP TABLE IF EXISTS `mx_post`;
CREATE TABLE `mx_post` (
  `postID` int(11) NOT NULL auto_increment,
  `postTitle` varchar(255) NOT NULL,
  `seoUri` varchar(255) NOT NULL,
  `synopsis` text NOT NULL,
  `postDesc` text NOT NULL,
  `postThumb` varchar(100) NOT NULL,
  `postImage` varchar(100) NOT NULL,
  `metaTitle` text NOT NULL,
  `metaDesc` text NOT NULL,
  `metaKeyword` text NOT NULL,
  `featuredPost` tinyint(1) NOT NULL default '0',
  `langCode` varchar(2) NOT NULL,
  `parentLID` int(11) NOT NULL default '0',
  `dateAdded` datetime NOT NULL,
  `dateModified` datetime NOT NULL,
  `datePublish` datetime NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`postID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_post
-- ----------------------------

-- ----------------------------
-- Table structure for `mx_result`
-- ----------------------------
DROP TABLE IF EXISTS `mx_result`;
CREATE TABLE `mx_result` (
  `lotID` bigint(200) NOT NULL auto_increment,
  `cellID` int(11) default NULL,
  `sernum` varchar(20) default NULL,
  `lotnum` varchar(20) default NULL,
  `uID` int(11) NOT NULL,
  `lotdate` date default NULL,
  `lotTime` time default NULL,
  `dateAdded` datetime default NULL,
  `dateModified` datetime default NULL,
  `status` tinyint(1) default '1',
  PRIMARY KEY  (`lotID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_result
-- ----------------------------

-- ----------------------------
-- Table structure for `mx_result_tran`
-- ----------------------------
DROP TABLE IF EXISTS `mx_result_tran`;
CREATE TABLE `mx_result_tran` (
  `lotID` bigint(200) NOT NULL auto_increment,
  `gameID` int(11) default NULL,
  `cellID` varchar(2011) default NULL,
  `uID` int(11) NOT NULL default '1',
  `lotdate` date default NULL,
  `lotTime` time default NULL,
  `xval` int(11) NOT NULL default '0',
  `dateAdded` datetime default NULL,
  `dateModified` datetime default NULL,
  `status` tinyint(1) default '1',
  PRIMARY KEY  (`lotID`),
  KEY `idx2` (`cellID`(767),`lotdate`,`lotTime`),
  KEY `idx3` (`uID`)
) ENGINE=InnoDB AUTO_INCREMENT=5893 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of mx_result_tran
-- ----------------------------
INSERT INTO `mx_result_tran` VALUES ('1', '1', '2', '1', '2023-04-20', '12:03:00', '0', '2023-04-20 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2', '1', '8', '1', '2023-04-20', '12:06:00', '0', '2023-04-20 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3', '1', '6', '1', '2023-04-20', '12:09:00', '0', '2023-04-20 12:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('4', '1', '2', '1', '2023-04-20', '12:12:00', '0', '2023-04-20 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('5', '1', '5', '1', '2023-04-20', '12:15:00', '0', '2023-04-20 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('6', '1', '4', '1', '2023-04-20', '12:18:00', '0', '2023-04-20 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('7', '1', '2', '1', '2023-04-20', '12:21:00', '0', '2023-04-20 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('8', '1', '9', '1', '2023-04-20', '12:24:00', '0', '2023-04-20 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('9', '1', '0', '1', '2023-04-20', '12:27:00', '0', '2023-04-20 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('10', '1', '0', '1', '2023-04-20', '12:30:00', '0', '2023-04-20 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('11', '1', '9', '1', '2023-04-20', '12:33:00', '0', '2023-04-20 12:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('12', '1', '4', '1', '2023-04-20', '12:36:00', '0', '2023-04-20 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('13', '1', '8', '1', '2023-04-20', '12:39:00', '0', '2023-04-20 12:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('14', '1', '5', '1', '2023-04-20', '12:42:00', '0', '2023-04-20 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('15', '1', '6', '1', '2023-04-20', '12:45:00', '0', '2023-04-20 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('16', '1', '2', '1', '2023-04-20', '12:48:00', '0', '2023-04-20 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('17', '1', '2', '1', '2023-04-20', '12:51:00', '0', '2023-04-20 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('18', '1', '9', '1', '2023-04-20', '12:54:00', '0', '2023-04-20 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('19', '1', '5', '1', '2023-04-20', '12:57:00', '0', '2023-04-20 12:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('20', '1', '2', '1', '2023-04-20', '01:00:00', '0', '2023-04-20 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('21', '1', '6', '1', '2023-04-20', '01:03:00', '0', '2023-04-20 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('22', '1', '5', '1', '2023-04-20', '01:06:00', '0', '2023-04-20 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('23', '1', '2', '1', '2023-04-20', '01:09:00', '0', '2023-04-20 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('24', '1', '1', '1', '2023-04-20', '01:12:00', '0', '2023-04-20 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('25', '1', '8', '1', '2023-04-20', '01:15:00', '0', '2023-04-20 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('26', '1', '7', '1', '2023-04-20', '01:18:00', '0', '2023-04-20 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('27', '1', '5', '1', '2023-04-20', '01:21:00', '0', '2023-04-20 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('28', '1', '2', '1', '2023-04-20', '01:24:00', '0', '2023-04-20 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('29', '1', '4', '1', '2023-04-20', '01:27:00', '0', '2023-04-20 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('30', '1', '2', '1', '2023-04-20', '01:30:00', '0', '2023-04-20 01:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('31', '1', '7', '1', '2023-04-20', '01:33:00', '0', '2023-04-20 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('32', '1', '1', '1', '2023-04-20', '01:36:00', '0', '2023-04-20 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('33', '1', '5', '1', '2023-04-20', '01:39:00', '0', '2023-04-20 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('34', '1', '9', '1', '2023-04-20', '01:42:00', '0', '2023-04-20 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('35', '1', '4', '1', '2023-04-20', '01:45:00', '0', '2023-04-20 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('36', '1', '0', '1', '2023-04-20', '01:48:00', '0', '2023-04-20 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('37', '1', '8', '1', '2023-04-20', '01:51:00', '0', '2023-04-20 01:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('38', '1', '6', '1', '2023-04-20', '01:54:00', '0', '2023-04-20 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('39', '1', '7', '1', '2023-04-20', '01:57:00', '0', '2023-04-20 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('40', '1', '5', '1', '2023-04-20', '02:00:00', '0', '2023-04-20 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('41', '1', '2', '1', '2023-04-20', '02:03:00', '0', '2023-04-20 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('42', '1', '7', '1', '2023-04-20', '02:06:00', '0', '2023-04-20 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('43', '1', '7', '1', '2023-04-20', '02:09:00', '0', '2023-04-20 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('44', '1', '3', '1', '2023-04-20', '02:12:00', '0', '2023-04-20 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('45', '1', '3', '1', '2023-04-20', '02:15:00', '0', '2023-04-20 02:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('46', '1', '6', '1', '2023-04-20', '02:18:00', '0', '2023-04-20 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('47', '1', '4', '1', '2023-04-20', '02:21:00', '0', '2023-04-20 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('48', '1', '8', '1', '2023-04-20', '02:24:00', '0', '2023-04-20 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('49', '1', '1', '1', '2023-04-20', '02:27:00', '0', '2023-04-20 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('50', '1', '0', '1', '2023-04-20', '02:30:00', '0', '2023-04-20 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('51', '1', '2', '1', '2023-04-20', '02:33:00', '0', '2023-04-20 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('52', '1', '2', '1', '2023-04-20', '02:36:00', '0', '2023-04-20 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('53', '1', '4', '1', '2023-04-20', '02:39:00', '0', '2023-04-20 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('54', '1', '3', '1', '2023-04-20', '02:42:00', '0', '2023-04-20 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('55', '1', '4', '1', '2023-04-20', '02:45:00', '0', '2023-04-20 02:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('56', '1', '7', '1', '2023-04-20', '02:48:00', '0', '2023-04-20 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('57', '1', '6', '1', '2023-04-20', '02:51:00', '0', '2023-04-20 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('58', '1', '9', '1', '2023-04-20', '02:54:00', '0', '2023-04-20 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('59', '1', '5', '1', '2023-04-20', '02:57:00', '0', '2023-04-20 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('60', '1', '1', '1', '2023-04-20', '03:00:00', '0', '2023-04-20 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('61', '1', '5', '1', '2023-04-20', '03:03:00', '0', '2023-04-20 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('62', '1', '5', '1', '2023-04-20', '03:06:00', '0', '2023-04-20 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('63', '1', '8', '1', '2023-04-20', '03:09:00', '0', '2023-04-20 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('64', '1', '6', '1', '2023-04-20', '03:12:00', '0', '2023-04-20 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('65', '1', '0', '1', '2023-04-20', '03:15:00', '0', '2023-04-20 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('66', '1', '7', '1', '2023-04-20', '03:18:00', '0', '2023-04-20 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('67', '1', '6', '1', '2023-04-20', '03:21:00', '0', '2023-04-20 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('68', '1', '9', '1', '2023-04-20', '03:24:00', '0', '2023-04-20 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('69', '1', '2', '1', '2023-04-20', '03:27:00', '0', '2023-04-20 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('70', '1', '4', '1', '2023-04-20', '03:30:00', '0', '2023-04-20 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('71', '1', '7', '1', '2023-04-20', '03:33:00', '0', '2023-04-20 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('72', '1', '4', '1', '2023-04-20', '03:36:00', '0', '2023-04-20 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('73', '1', '8', '1', '2023-04-20', '03:39:00', '0', '2023-04-20 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('74', '1', '9', '1', '2023-04-20', '03:42:00', '0', '2023-04-20 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('75', '1', '9', '1', '2023-04-20', '03:45:00', '0', '2023-04-20 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('76', '1', '7', '1', '2023-04-20', '03:48:00', '0', '2023-04-20 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('77', '1', '5', '1', '2023-04-20', '03:51:00', '0', '2023-04-20 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('78', '1', '0', '1', '2023-04-20', '03:54:00', '0', '2023-04-20 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('79', '1', '3', '1', '2023-04-20', '03:57:00', '0', '2023-04-20 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('80', '1', '5', '1', '2023-04-20', '04:00:00', '0', '2023-04-20 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('81', '1', '5', '1', '2023-04-20', '04:03:00', '0', '2023-04-20 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('82', '1', '6', '1', '2023-04-20', '04:06:00', '0', '2023-04-20 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('83', '1', '6', '1', '2023-04-20', '04:09:00', '0', '2023-04-20 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('84', '1', '0', '1', '2023-04-20', '04:12:00', '0', '2023-04-20 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('85', '1', '5', '1', '2023-04-20', '04:15:00', '0', '2023-04-20 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('86', '1', '4', '1', '2023-04-20', '04:18:00', '0', '2023-04-20 04:18:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('87', '1', '1', '1', '2023-04-20', '04:21:00', '0', '2023-04-20 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('88', '1', '5', '1', '2023-04-20', '04:24:00', '0', '2023-04-20 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('89', '1', '4', '1', '2023-04-20', '04:27:00', '0', '2023-04-20 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('90', '1', '2', '1', '2023-04-20', '04:30:00', '0', '2023-04-20 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('91', '1', '8', '1', '2023-04-20', '04:33:00', '0', '2023-04-20 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('92', '1', '4', '1', '2023-04-20', '04:36:00', '0', '2023-04-20 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('93', '1', '6', '1', '2023-04-20', '04:39:00', '0', '2023-04-20 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('94', '1', '1', '1', '2023-04-20', '04:42:00', '0', '2023-04-20 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('95', '1', '0', '1', '2023-04-20', '04:45:00', '0', '2023-04-20 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('96', '1', '6', '1', '2023-04-20', '04:48:00', '0', '2023-04-20 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('97', '1', '2', '1', '2023-04-20', '04:51:00', '0', '2023-04-20 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('98', '1', '4', '1', '2023-04-20', '04:54:00', '0', '2023-04-20 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('99', '1', '2', '1', '2023-04-20', '04:57:00', '0', '2023-04-20 04:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('100', '1', '1', '1', '2023-04-20', '05:00:00', '0', '2023-04-20 05:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('101', '1', '5', '1', '2023-04-20', '05:03:00', '0', '2023-04-20 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('102', '1', '0', '1', '2023-04-20', '05:06:00', '0', '2023-04-20 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('103', '1', '4', '1', '2023-04-20', '05:09:00', '0', '2023-04-20 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('104', '1', '7', '1', '2023-04-20', '05:12:00', '0', '2023-04-20 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('105', '1', '9', '1', '2023-04-20', '05:15:00', '0', '2023-04-20 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('106', '1', '4', '1', '2023-04-20', '05:18:00', '0', '2023-04-20 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('107', '1', '0', '1', '2023-04-20', '05:21:00', '0', '2023-04-20 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('108', '1', '1', '1', '2023-04-20', '05:24:00', '0', '2023-04-20 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('109', '1', '3', '1', '2023-04-20', '05:27:00', '0', '2023-04-20 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('110', '1', '6', '1', '2023-04-20', '05:30:00', '0', '2023-04-20 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('111', '1', '3', '1', '2023-04-20', '05:33:00', '0', '2023-04-20 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('112', '1', '0', '1', '2023-04-20', '05:36:00', '0', '2023-04-20 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('113', '1', '0', '1', '2023-04-20', '05:39:00', '0', '2023-04-20 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('114', '1', '2', '1', '2023-04-20', '05:42:00', '0', '2023-04-20 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('115', '1', '8', '1', '2023-04-20', '05:45:00', '0', '2023-04-20 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('116', '1', '4', '1', '2023-04-20', '05:48:00', '0', '2023-04-20 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('117', '1', '6', '1', '2023-04-20', '05:51:00', '0', '2023-04-20 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('118', '1', '4', '1', '2023-04-20', '05:54:00', '0', '2023-04-20 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('119', '1', '9', '1', '2023-04-20', '05:57:00', '0', '2023-04-20 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('120', '1', '3', '1', '2023-04-20', '06:00:00', '0', '2023-04-20 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('121', '1', '5', '1', '2023-04-20', '06:03:00', '0', '2023-04-20 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('122', '1', '3', '1', '2023-04-20', '06:06:00', '0', '2023-04-20 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('123', '1', '0', '1', '2023-04-20', '06:09:00', '0', '2023-04-20 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('124', '1', '3', '1', '2023-04-20', '06:12:00', '0', '2023-04-20 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('125', '1', '7', '1', '2023-04-20', '06:15:00', '0', '2023-04-20 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('126', '1', '9', '1', '2023-04-20', '06:18:00', '0', '2023-04-20 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('127', '1', '9', '1', '2023-04-20', '06:21:00', '0', '2023-04-20 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('128', '1', '3', '1', '2023-04-20', '06:24:00', '0', '2023-04-20 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('129', '1', '7', '1', '2023-04-20', '06:27:00', '0', '2023-04-20 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('130', '1', '9', '1', '2023-04-20', '06:30:00', '0', '2023-04-20 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('131', '1', '5', '1', '2023-04-20', '06:33:00', '0', '2023-04-20 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('132', '1', '0', '1', '2023-04-20', '06:36:00', '0', '2023-04-20 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('133', '1', '5', '1', '2023-04-20', '06:39:00', '0', '2023-04-20 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('134', '1', '9', '1', '2023-04-20', '06:42:00', '0', '2023-04-20 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('135', '1', '7', '1', '2023-04-20', '06:45:00', '0', '2023-04-20 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('136', '1', '2', '1', '2023-04-20', '06:48:00', '0', '2023-04-20 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('137', '1', '6', '1', '2023-04-20', '06:51:00', '0', '2023-04-20 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('138', '1', '9', '1', '2023-04-20', '06:54:00', '0', '2023-04-20 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('139', '1', '6', '1', '2023-04-20', '06:57:00', '0', '2023-04-20 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('140', '1', '7', '1', '2023-04-20', '07:00:00', '0', '2023-04-20 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('141', '1', '7', '1', '2023-04-20', '07:03:00', '0', '2023-04-20 07:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('142', '1', '7', '1', '2023-04-20', '07:06:00', '0', '2023-04-20 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('143', '1', '4', '1', '2023-04-20', '07:09:00', '0', '2023-04-20 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('144', '1', '2', '1', '2023-04-20', '07:12:00', '0', '2023-04-20 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('145', '1', '4', '1', '2023-04-20', '07:15:00', '0', '2023-04-20 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('146', '1', '0', '1', '2023-04-20', '07:18:00', '0', '2023-04-20 07:18:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('147', '1', '4', '1', '2023-04-20', '07:21:00', '0', '2023-04-20 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('148', '1', '5', '1', '2023-04-20', '07:24:00', '0', '2023-04-20 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('149', '1', '0', '1', '2023-04-20', '07:27:00', '0', '2023-04-20 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('150', '1', '5', '1', '2023-04-20', '07:30:00', '0', '2023-04-20 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('151', '1', '4', '1', '2023-04-20', '07:33:00', '0', '2023-04-20 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('152', '1', '8', '1', '2023-04-20', '07:36:00', '0', '2023-04-20 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('153', '1', '2', '1', '2023-04-20', '07:39:00', '0', '2023-04-20 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('154', '1', '8', '1', '2023-04-20', '07:42:00', '0', '2023-04-20 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('155', '1', '5', '1', '2023-04-20', '07:45:00', '0', '2023-04-20 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('156', '1', '6', '1', '2023-04-20', '07:48:00', '0', '2023-04-20 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('157', '1', '2', '1', '2023-04-20', '07:51:00', '0', '2023-04-20 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('158', '1', '7', '1', '2023-04-20', '07:54:00', '0', '2023-04-20 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('159', '1', '3', '1', '2023-04-20', '07:57:00', '0', '2023-04-20 07:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('160', '1', '3', '1', '2023-04-20', '08:00:00', '0', '2023-04-20 08:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('161', '1', '9', '1', '2023-04-20', '08:03:00', '0', '2023-04-20 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('162', '1', '3', '1', '2023-04-20', '08:06:00', '0', '2023-04-20 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('163', '1', '4', '1', '2023-04-20', '08:09:00', '0', '2023-04-20 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('164', '1', '5', '1', '2023-04-20', '08:12:00', '0', '2023-04-20 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('165', '1', '0', '1', '2023-04-20', '08:15:00', '0', '2023-04-20 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('166', '1', '5', '1', '2023-04-20', '08:18:00', '0', '2023-04-20 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('167', '1', '0', '1', '2023-04-20', '08:21:00', '0', '2023-04-20 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('168', '1', '2', '1', '2023-04-20', '08:24:00', '0', '2023-04-20 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('169', '1', '1', '1', '2023-04-20', '08:27:00', '0', '2023-04-20 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('170', '1', '9', '1', '2023-04-20', '08:30:00', '0', '2023-04-20 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('171', '1', '6', '1', '2023-04-20', '08:33:00', '0', '2023-04-20 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('172', '1', '1', '1', '2023-04-20', '08:36:00', '0', '2023-04-20 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('173', '1', '0', '1', '2023-04-20', '08:39:00', '0', '2023-04-20 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('174', '1', '3', '1', '2023-04-20', '08:42:00', '0', '2023-04-20 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('175', '1', '1', '1', '2023-04-20', '08:45:00', '0', '2023-04-20 08:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('176', '1', '0', '1', '2023-04-20', '08:48:00', '0', '2023-04-20 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('177', '1', '5', '1', '2023-04-20', '08:51:00', '0', '2023-04-20 08:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('178', '1', '6', '1', '2023-04-20', '08:54:00', '0', '2023-04-20 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('179', '1', '8', '1', '2023-04-20', '08:57:00', '0', '2023-04-20 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('180', '1', '5', '1', '2023-04-20', '09:00:00', '0', '2023-04-20 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('181', '1', '6', '1', '2023-04-20', '09:03:00', '0', '2023-04-20 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('182', '1', '6', '1', '2023-04-20', '09:06:00', '0', '2023-04-20 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('183', '1', '8', '1', '2023-04-20', '09:09:00', '0', '2023-04-20 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('184', '1', '4', '1', '2023-04-20', '09:12:00', '0', '2023-04-20 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('185', '1', '7', '1', '2023-04-20', '09:15:00', '0', '2023-04-20 09:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('186', '1', '2', '1', '2023-04-20', '09:18:00', '0', '2023-04-20 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('187', '1', '6', '1', '2023-04-20', '09:21:00', '0', '2023-04-20 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('188', '1', '8', '1', '2023-04-20', '09:24:00', '0', '2023-04-20 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('189', '1', '5', '1', '2023-04-20', '09:27:00', '0', '2023-04-20 09:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('190', '1', '5', '1', '2023-04-20', '09:30:00', '0', '2023-04-20 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('191', '1', '8', '1', '2023-04-20', '09:33:00', '0', '2023-04-20 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('192', '1', '3', '1', '2023-04-20', '09:36:00', '0', '2023-04-20 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('193', '1', '3', '1', '2023-04-20', '09:39:00', '0', '2023-04-20 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('194', '1', '2', '1', '2023-04-20', '09:42:00', '0', '2023-04-20 09:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('195', '1', '9', '1', '2023-04-20', '09:45:00', '0', '2023-04-20 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('196', '1', '7', '1', '2023-04-21', '10:00:00', '0', '2023-04-21 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('197', '1', '7', '1', '2023-04-21', '10:03:00', '0', '2023-04-21 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('198', '1', '3', '1', '2023-04-21', '10:06:00', '0', '2023-04-21 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('199', '1', '0', '1', '2023-04-21', '10:09:00', '0', '2023-04-21 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('200', '1', '0', '1', '2023-04-21', '10:12:00', '0', '2023-04-21 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('201', '1', '0', '1', '2023-04-21', '10:15:00', '0', '2023-04-21 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('202', '1', '0', '1', '2023-04-21', '10:18:00', '0', '2023-04-21 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('203', '1', '1', '1', '2023-04-21', '10:21:00', '0', '2023-04-21 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('204', '1', '3', '1', '2023-04-21', '10:24:00', '0', '2023-04-21 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('205', '1', '5', '1', '2023-04-21', '10:27:00', '0', '2023-04-21 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('206', '1', '4', '1', '2023-04-21', '10:30:00', '0', '2023-04-21 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('207', '1', '8', '1', '2023-04-21', '10:33:00', '0', '2023-04-21 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('208', '1', '6', '1', '2023-04-21', '10:36:00', '0', '2023-04-21 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('209', '1', '7', '1', '2023-04-21', '10:39:00', '0', '2023-04-21 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('210', '1', '3', '1', '2023-04-21', '10:42:00', '0', '2023-04-21 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('211', '1', '7', '1', '2023-04-21', '10:45:00', '0', '2023-04-21 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('212', '1', '1', '1', '2023-04-21', '10:48:00', '0', '2023-04-21 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('213', '1', '0', '1', '2023-04-21', '10:51:00', '0', '2023-04-21 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('214', '1', '9', '1', '2023-04-21', '10:54:00', '0', '2023-04-21 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('215', '1', '9', '1', '2023-04-21', '10:57:00', '0', '2023-04-21 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('216', '1', '3', '1', '2023-04-21', '11:00:00', '0', '2023-04-21 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('217', '1', '9', '1', '2023-04-21', '11:03:00', '0', '2023-04-21 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('218', '1', '3', '1', '2023-04-21', '11:06:00', '0', '2023-04-21 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('219', '1', '0', '1', '2023-04-21', '11:09:00', '0', '2023-04-21 11:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('220', '1', '8', '1', '2023-04-21', '11:12:00', '0', '2023-04-21 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('221', '1', '4', '1', '2023-04-21', '11:15:00', '0', '2023-04-21 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('222', '1', '7', '1', '2023-04-21', '11:18:00', '0', '2023-04-21 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('223', '1', '0', '1', '2023-04-21', '11:21:00', '0', '2023-04-21 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('224', '1', '6', '1', '2023-04-21', '11:24:00', '0', '2023-04-21 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('225', '1', '2', '1', '2023-04-21', '11:27:00', '0', '2023-04-21 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('226', '1', '9', '1', '2023-04-21', '11:30:00', '0', '2023-04-21 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('227', '1', '0', '1', '2023-04-21', '11:33:00', '0', '2023-04-21 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('228', '1', '9', '1', '2023-04-21', '11:36:00', '0', '2023-04-21 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('229', '1', '5', '1', '2023-04-21', '11:39:00', '0', '2023-04-21 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('230', '1', '2', '1', '2023-04-21', '11:42:00', '0', '2023-04-21 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('231', '1', '5', '1', '2023-04-21', '11:45:00', '0', '2023-04-21 11:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('232', '1', '9', '1', '2023-04-21', '11:48:00', '0', '2023-04-21 11:48:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('233', '1', '4', '1', '2023-04-21', '11:51:00', '0', '2023-04-21 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('234', '1', '5', '1', '2023-04-21', '11:54:00', '0', '2023-04-21 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('235', '1', '3', '1', '2023-04-21', '11:57:00', '0', '2023-04-21 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('236', '1', '8', '1', '2023-04-21', '12:00:00', '0', '2023-04-21 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('237', '1', '1', '1', '2023-04-21', '12:03:00', '0', '2023-04-21 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('238', '1', '3', '1', '2023-04-21', '12:06:00', '0', '2023-04-21 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('239', '1', '0', '1', '2023-04-21', '12:09:00', '0', '2023-04-21 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('240', '1', '2', '1', '2023-04-21', '12:12:00', '0', '2023-04-21 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('241', '1', '3', '1', '2023-04-21', '12:15:00', '0', '2023-04-21 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('242', '1', '8', '1', '2023-04-21', '12:18:00', '0', '2023-04-21 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('243', '1', '8', '1', '2023-04-21', '12:21:00', '0', '2023-04-21 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('244', '1', '1', '1', '2023-04-21', '12:24:00', '0', '2023-04-21 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('245', '1', '0', '1', '2023-04-21', '12:27:00', '0', '2023-04-21 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('246', '1', '6', '1', '2023-04-21', '12:30:00', '0', '2023-04-21 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('247', '1', '4', '1', '2023-04-21', '12:33:00', '0', '2023-04-21 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('248', '1', '5', '1', '2023-04-21', '12:36:00', '0', '2023-04-21 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('249', '1', '8', '1', '2023-04-21', '12:39:00', '0', '2023-04-21 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('250', '1', '3', '1', '2023-04-21', '12:42:00', '0', '2023-04-21 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('251', '1', '3', '1', '2023-04-21', '12:45:00', '0', '2023-04-21 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('252', '1', '8', '1', '2023-04-21', '12:48:00', '0', '2023-04-21 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('253', '1', '9', '1', '2023-04-21', '12:51:00', '0', '2023-04-21 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('254', '1', '6', '1', '2023-04-21', '12:54:00', '0', '2023-04-21 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('255', '1', '8', '1', '2023-04-21', '12:57:00', '0', '2023-04-21 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('256', '1', '7', '1', '2023-04-21', '01:00:00', '0', '2023-04-21 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('257', '1', '7', '1', '2023-04-21', '01:03:00', '0', '2023-04-21 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('258', '1', '7', '1', '2023-04-21', '01:06:00', '0', '2023-04-21 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('259', '1', '3', '1', '2023-04-21', '01:09:00', '0', '2023-04-21 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('260', '1', '3', '1', '2023-04-21', '01:12:00', '0', '2023-04-21 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('261', '1', '7', '1', '2023-04-21', '01:15:00', '0', '2023-04-21 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('262', '1', '1', '1', '2023-04-21', '01:18:00', '0', '2023-04-21 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('263', '1', '1', '1', '2023-04-21', '01:21:00', '0', '2023-04-21 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('264', '1', '5', '1', '2023-04-21', '01:24:00', '0', '2023-04-21 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('265', '1', '4', '1', '2023-04-21', '01:27:00', '0', '2023-04-21 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('266', '1', '8', '1', '2023-04-21', '01:30:00', '0', '2023-04-21 01:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('267', '1', '7', '1', '2023-04-21', '01:33:00', '0', '2023-04-21 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('268', '1', '9', '1', '2023-04-21', '01:36:00', '0', '2023-04-21 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('269', '1', '5', '1', '2023-04-21', '01:39:00', '0', '2023-04-21 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('270', '1', '2', '1', '2023-04-21', '01:42:00', '0', '2023-04-21 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('271', '1', '6', '1', '2023-04-21', '01:45:00', '0', '2023-04-21 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('272', '1', '6', '1', '2023-04-21', '01:48:00', '0', '2023-04-21 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('273', '1', '6', '1', '2023-04-21', '01:51:00', '0', '2023-04-21 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('274', '1', '4', '1', '2023-04-21', '01:54:00', '0', '2023-04-21 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('275', '1', '2', '1', '2023-04-21', '01:57:00', '0', '2023-04-21 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('276', '1', '7', '1', '2023-04-21', '02:00:00', '0', '2023-04-21 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('277', '1', '7', '1', '2023-04-21', '02:03:00', '0', '2023-04-21 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('278', '1', '8', '1', '2023-04-21', '02:06:00', '0', '2023-04-21 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('279', '1', '8', '1', '2023-04-21', '02:09:00', '0', '2023-04-21 02:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('280', '1', '8', '1', '2023-04-21', '02:12:00', '0', '2023-04-21 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('281', '1', '6', '1', '2023-04-21', '02:15:00', '0', '2023-04-21 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('282', '1', '1', '1', '2023-04-21', '02:18:00', '0', '2023-04-21 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('283', '1', '0', '1', '2023-04-21', '02:21:00', '0', '2023-04-21 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('284', '1', '3', '1', '2023-04-21', '02:24:00', '0', '2023-04-21 02:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('285', '1', '0', '1', '2023-04-21', '02:27:00', '0', '2023-04-21 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('286', '1', '3', '1', '2023-04-21', '02:30:00', '0', '2023-04-21 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('287', '1', '3', '1', '2023-04-21', '02:33:00', '0', '2023-04-21 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('288', '1', '1', '1', '2023-04-21', '02:36:00', '0', '2023-04-21 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('289', '1', '7', '1', '2023-04-21', '02:39:00', '0', '2023-04-21 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('290', '1', '4', '1', '2023-04-21', '02:42:00', '0', '2023-04-21 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('291', '1', '9', '1', '2023-04-21', '02:45:00', '0', '2023-04-21 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('292', '1', '7', '1', '2023-04-21', '02:48:00', '0', '2023-04-21 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('293', '1', '6', '1', '2023-04-21', '02:51:00', '0', '2023-04-21 02:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('294', '1', '8', '1', '2023-04-21', '02:54:00', '0', '2023-04-21 02:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('295', '1', '2', '1', '2023-04-21', '02:57:00', '0', '2023-04-21 02:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('296', '1', '1', '1', '2023-04-21', '03:00:00', '0', '2023-04-21 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('297', '1', '6', '1', '2023-04-21', '03:03:00', '0', '2023-04-21 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('298', '1', '2', '1', '2023-04-21', '03:06:00', '0', '2023-04-21 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('299', '1', '0', '1', '2023-04-21', '03:09:00', '0', '2023-04-21 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('300', '1', '3', '1', '2023-04-21', '03:12:00', '0', '2023-04-21 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('301', '1', '4', '1', '2023-04-21', '03:15:00', '0', '2023-04-21 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('302', '1', '7', '1', '2023-04-21', '03:18:00', '0', '2023-04-21 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('303', '1', '2', '1', '2023-04-21', '03:21:00', '0', '2023-04-21 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('304', '1', '4', '1', '2023-04-21', '03:24:00', '0', '2023-04-21 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('305', '1', '0', '1', '2023-04-21', '03:27:00', '0', '2023-04-21 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('306', '1', '6', '1', '2023-04-21', '03:30:00', '0', '2023-04-21 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('307', '1', '5', '1', '2023-04-21', '03:33:00', '0', '2023-04-21 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('308', '1', '1', '1', '2023-04-21', '03:36:00', '0', '2023-04-21 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('309', '1', '4', '1', '2023-04-21', '03:39:00', '0', '2023-04-21 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('310', '1', '4', '1', '2023-04-21', '03:42:00', '0', '2023-04-21 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('311', '1', '9', '1', '2023-04-21', '03:45:00', '0', '2023-04-21 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('312', '1', '1', '1', '2023-04-21', '03:48:00', '0', '2023-04-21 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('313', '1', '6', '1', '2023-04-21', '03:51:00', '0', '2023-04-21 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('314', '1', '4', '1', '2023-04-21', '03:54:00', '0', '2023-04-21 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('315', '1', '9', '1', '2023-04-21', '03:57:00', '0', '2023-04-21 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('316', '1', '3', '1', '2023-04-21', '04:00:00', '0', '2023-04-21 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('317', '1', '8', '1', '2023-04-21', '04:03:00', '0', '2023-04-21 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('318', '1', '5', '1', '2023-04-21', '04:06:00', '0', '2023-04-21 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('319', '1', '8', '1', '2023-04-21', '04:09:00', '0', '2023-04-21 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('320', '1', '5', '1', '2023-04-21', '04:12:00', '0', '2023-04-21 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('321', '1', '2', '1', '2023-04-21', '04:15:00', '0', '2023-04-21 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('322', '1', '6', '1', '2023-04-21', '04:18:00', '0', '2023-04-21 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('323', '1', '5', '1', '2023-04-21', '04:21:00', '0', '2023-04-21 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('324', '1', '2', '1', '2023-04-21', '04:24:00', '0', '2023-04-21 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('325', '1', '4', '1', '2023-04-21', '04:27:00', '0', '2023-04-21 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('326', '1', '0', '1', '2023-04-21', '04:30:00', '0', '2023-04-21 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('327', '1', '7', '1', '2023-04-21', '04:33:00', '0', '2023-04-21 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('328', '1', '0', '1', '2023-04-21', '04:36:00', '0', '2023-04-21 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('329', '1', '4', '1', '2023-04-21', '04:39:00', '0', '2023-04-21 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('330', '1', '5', '1', '2023-04-21', '04:42:00', '0', '2023-04-21 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('331', '1', '6', '1', '2023-04-21', '04:45:00', '0', '2023-04-21 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('332', '1', '5', '1', '2023-04-21', '04:48:00', '0', '2023-04-21 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('333', '1', '2', '1', '2023-04-21', '04:51:00', '0', '2023-04-21 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('334', '1', '8', '1', '2023-04-21', '04:54:00', '0', '2023-04-21 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('335', '1', '2', '1', '2023-04-21', '04:57:00', '0', '2023-04-21 04:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('336', '1', '8', '1', '2023-04-21', '05:00:00', '0', '2023-04-21 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('337', '1', '5', '1', '2023-04-21', '05:03:00', '0', '2023-04-21 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('338', '1', '6', '1', '2023-04-21', '05:06:00', '0', '2023-04-21 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('339', '1', '5', '1', '2023-04-21', '05:09:00', '0', '2023-04-21 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('340', '1', '4', '1', '2023-04-21', '05:12:00', '0', '2023-04-21 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('341', '1', '8', '1', '2023-04-21', '05:15:00', '0', '2023-04-21 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('342', '1', '3', '1', '2023-04-21', '05:18:00', '0', '2023-04-21 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('343', '1', '2', '1', '2023-04-21', '05:21:00', '0', '2023-04-21 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('344', '1', '1', '1', '2023-04-21', '05:24:00', '0', '2023-04-21 05:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('345', '1', '6', '1', '2023-04-21', '05:27:00', '0', '2023-04-21 05:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('346', '1', '5', '1', '2023-04-21', '05:30:00', '0', '2023-04-21 05:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('347', '1', '1', '1', '2023-04-21', '05:33:00', '0', '2023-04-21 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('348', '1', '1', '1', '2023-04-21', '05:36:00', '0', '2023-04-21 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('349', '1', '8', '1', '2023-04-21', '05:39:00', '0', '2023-04-21 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('350', '1', '5', '1', '2023-04-21', '05:42:00', '0', '2023-04-21 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('351', '1', '3', '1', '2023-04-21', '05:45:00', '0', '2023-04-21 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('352', '1', '3', '1', '2023-04-21', '05:48:00', '0', '2023-04-21 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('353', '1', '6', '1', '2023-04-21', '05:51:00', '0', '2023-04-21 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('354', '1', '9', '1', '2023-04-21', '05:54:00', '0', '2023-04-21 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('355', '1', '2', '1', '2023-04-21', '05:57:00', '0', '2023-04-21 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('356', '1', '4', '1', '2023-04-21', '06:00:00', '0', '2023-04-21 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('357', '1', '1', '1', '2023-04-21', '06:03:00', '0', '2023-04-21 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('358', '1', '1', '1', '2023-04-21', '06:06:00', '0', '2023-04-21 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('359', '1', '5', '1', '2023-04-21', '06:09:00', '0', '2023-04-21 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('360', '1', '1', '1', '2023-04-21', '06:12:00', '0', '2023-04-21 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('361', '1', '7', '1', '2023-04-21', '06:15:00', '0', '2023-04-21 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('362', '1', '7', '1', '2023-04-21', '06:18:00', '0', '2023-04-21 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('363', '1', '2', '1', '2023-04-21', '06:21:00', '0', '2023-04-21 06:21:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('364', '1', '5', '1', '2023-04-21', '06:24:00', '0', '2023-04-21 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('365', '1', '0', '1', '2023-04-21', '06:27:00', '0', '2023-04-21 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('366', '1', '4', '1', '2023-04-21', '06:30:00', '0', '2023-04-21 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('367', '1', '3', '1', '2023-04-21', '06:33:00', '0', '2023-04-21 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('368', '1', '7', '1', '2023-04-21', '06:36:00', '0', '2023-04-21 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('369', '1', '9', '1', '2023-04-21', '06:39:00', '0', '2023-04-21 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('370', '1', '5', '1', '2023-04-21', '06:42:00', '0', '2023-04-21 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('371', '1', '9', '1', '2023-04-21', '06:45:00', '0', '2023-04-21 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('372', '1', '3', '1', '2023-04-21', '06:48:00', '0', '2023-04-21 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('373', '1', '8', '1', '2023-04-21', '06:51:00', '0', '2023-04-21 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('374', '1', '4', '1', '2023-04-21', '06:54:00', '0', '2023-04-21 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('375', '1', '0', '1', '2023-04-21', '06:57:00', '0', '2023-04-21 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('376', '1', '6', '1', '2023-04-21', '07:00:00', '0', '2023-04-21 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('377', '1', '7', '1', '2023-04-21', '07:03:00', '0', '2023-04-21 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('378', '1', '8', '1', '2023-04-21', '07:06:00', '0', '2023-04-21 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('379', '1', '9', '1', '2023-04-21', '07:09:00', '0', '2023-04-21 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('380', '1', '2', '1', '2023-04-21', '07:12:00', '0', '2023-04-21 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('381', '1', '0', '1', '2023-04-21', '07:15:00', '0', '2023-04-21 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('382', '1', '5', '1', '2023-04-21', '07:18:00', '0', '2023-04-21 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('383', '1', '9', '1', '2023-04-21', '07:21:00', '0', '2023-04-21 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('384', '1', '5', '1', '2023-04-21', '07:24:00', '0', '2023-04-21 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('385', '1', '5', '1', '2023-04-21', '07:27:00', '0', '2023-04-21 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('386', '1', '8', '1', '2023-04-21', '07:30:00', '0', '2023-04-21 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('387', '1', '7', '1', '2023-04-21', '07:33:00', '0', '2023-04-21 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('388', '1', '8', '1', '2023-04-21', '07:36:00', '0', '2023-04-21 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('389', '1', '1', '1', '2023-04-21', '07:39:00', '0', '2023-04-21 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('390', '1', '6', '1', '2023-04-21', '07:42:00', '0', '2023-04-21 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('391', '1', '0', '1', '2023-04-21', '07:45:00', '0', '2023-04-21 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('392', '1', '7', '1', '2023-04-21', '07:48:00', '0', '2023-04-21 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('393', '1', '8', '1', '2023-04-21', '07:51:00', '0', '2023-04-21 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('394', '1', '6', '1', '2023-04-21', '07:54:00', '0', '2023-04-21 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('395', '1', '1', '1', '2023-04-21', '07:57:00', '0', '2023-04-21 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('396', '1', '2', '1', '2023-04-21', '08:00:00', '0', '2023-04-21 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('397', '1', '9', '1', '2023-04-21', '08:03:00', '0', '2023-04-21 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('398', '1', '8', '1', '2023-04-21', '08:06:00', '0', '2023-04-21 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('399', '1', '2', '1', '2023-04-21', '08:09:00', '0', '2023-04-21 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('400', '1', '9', '1', '2023-04-21', '08:12:00', '0', '2023-04-21 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('401', '1', '3', '1', '2023-04-21', '08:15:00', '0', '2023-04-21 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('402', '1', '5', '1', '2023-04-21', '08:18:00', '0', '2023-04-21 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('403', '1', '0', '1', '2023-04-21', '08:21:00', '0', '2023-04-21 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('404', '1', '5', '1', '2023-04-21', '08:24:00', '0', '2023-04-21 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('405', '1', '9', '1', '2023-04-21', '08:27:00', '0', '2023-04-21 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('406', '1', '3', '1', '2023-04-21', '08:30:00', '0', '2023-04-21 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('407', '1', '7', '1', '2023-04-21', '08:33:00', '0', '2023-04-21 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('408', '1', '0', '1', '2023-04-21', '08:36:00', '0', '2023-04-21 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('409', '1', '5', '1', '2023-04-21', '08:39:00', '0', '2023-04-21 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('410', '1', '0', '1', '2023-04-21', '08:42:00', '0', '2023-04-21 08:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('411', '1', '4', '1', '2023-04-21', '08:45:00', '0', '2023-04-21 08:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('412', '1', '1', '1', '2023-04-21', '08:48:00', '0', '2023-04-21 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('413', '1', '2', '1', '2023-04-21', '08:51:00', '0', '2023-04-21 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('414', '1', '5', '1', '2023-04-21', '08:54:00', '0', '2023-04-21 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('415', '1', '6', '1', '2023-04-21', '08:57:00', '0', '2023-04-21 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('416', '1', '5', '1', '2023-04-21', '09:00:00', '0', '2023-04-21 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('417', '1', '0', '1', '2023-04-21', '09:03:00', '0', '2023-04-21 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('418', '1', '3', '1', '2023-04-21', '09:06:00', '0', '2023-04-21 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('419', '1', '8', '1', '2023-04-21', '09:09:00', '0', '2023-04-21 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('420', '1', '1', '1', '2023-04-21', '09:12:00', '0', '2023-04-21 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('421', '1', '8', '1', '2023-04-21', '09:15:00', '0', '2023-04-21 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('422', '1', '6', '1', '2023-04-21', '09:18:00', '0', '2023-04-21 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('423', '1', '4', '1', '2023-04-21', '09:21:00', '0', '2023-04-21 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('424', '1', '5', '1', '2023-04-21', '09:24:00', '0', '2023-04-21 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('425', '1', '0', '1', '2023-04-21', '09:27:00', '0', '2023-04-21 09:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('426', '1', '4', '1', '2023-04-21', '09:30:00', '0', '2023-04-21 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('427', '1', '5', '1', '2023-04-21', '09:33:00', '0', '2023-04-21 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('428', '1', '0', '1', '2023-04-21', '09:36:00', '0', '2023-04-21 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('429', '1', '3', '1', '2023-04-21', '09:39:00', '0', '2023-04-21 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('430', '1', '1', '1', '2023-04-21', '09:42:00', '0', '2023-04-21 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('431', '1', '9', '1', '2023-04-21', '09:45:00', '0', '2023-04-21 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('432', '1', '4', '1', '2023-04-22', '10:00:00', '0', '2023-04-22 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('433', '1', '3', '1', '2023-04-22', '10:03:00', '0', '2023-04-22 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('434', '1', '5', '1', '2023-04-22', '10:06:00', '0', '2023-04-22 10:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('435', '1', '2', '1', '2023-04-22', '10:09:00', '0', '2023-04-22 10:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('436', '1', '7', '1', '2023-04-22', '10:12:00', '0', '2023-04-22 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('437', '1', '4', '1', '2023-04-22', '10:15:00', '0', '2023-04-22 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('438', '1', '9', '1', '2023-04-22', '10:18:00', '0', '2023-04-22 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('439', '1', '5', '1', '2023-04-22', '10:21:00', '0', '2023-04-22 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('440', '1', '0', '1', '2023-04-22', '10:24:00', '0', '2023-04-22 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('441', '1', '8', '1', '2023-04-22', '10:27:00', '0', '2023-04-22 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('442', '1', '7', '1', '2023-04-22', '10:30:00', '0', '2023-04-22 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('443', '1', '1', '1', '2023-04-22', '10:33:00', '0', '2023-04-22 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('444', '1', '3', '1', '2023-04-22', '10:36:00', '0', '2023-04-22 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('445', '1', '2', '1', '2023-04-22', '10:39:00', '0', '2023-04-22 10:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('446', '1', '7', '1', '2023-04-22', '10:42:00', '0', '2023-04-22 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('447', '1', '1', '1', '2023-04-22', '10:45:00', '0', '2023-04-22 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('448', '1', '3', '1', '2023-04-22', '10:48:00', '0', '2023-04-22 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('449', '1', '9', '1', '2023-04-22', '10:51:00', '0', '2023-04-22 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('450', '1', '8', '1', '2023-04-22', '10:54:00', '0', '2023-04-22 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('451', '1', '9', '1', '2023-04-22', '10:57:00', '0', '2023-04-22 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('452', '1', '9', '1', '2023-04-22', '11:00:00', '0', '2023-04-22 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('453', '1', '1', '1', '2023-04-22', '11:03:00', '0', '2023-04-22 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('454', '1', '1', '1', '2023-04-22', '11:06:00', '0', '2023-04-22 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('455', '1', '7', '1', '2023-04-22', '11:09:00', '0', '2023-04-22 11:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('456', '1', '9', '1', '2023-04-22', '11:12:00', '0', '2023-04-22 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('457', '1', '9', '1', '2023-04-22', '11:15:00', '0', '2023-04-22 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('458', '1', '3', '1', '2023-04-22', '11:18:00', '0', '2023-04-22 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('459', '1', '9', '1', '2023-04-22', '11:21:00', '0', '2023-04-22 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('460', '1', '3', '1', '2023-04-22', '11:24:00', '0', '2023-04-22 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('461', '1', '4', '1', '2023-04-22', '11:27:00', '0', '2023-04-22 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('462', '1', '6', '1', '2023-04-22', '11:30:00', '0', '2023-04-22 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('463', '1', '6', '1', '2023-04-22', '11:33:00', '0', '2023-04-22 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('464', '1', '3', '1', '2023-04-22', '11:36:00', '0', '2023-04-22 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('465', '1', '8', '1', '2023-04-22', '11:39:00', '0', '2023-04-22 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('466', '1', '5', '1', '2023-04-22', '11:42:00', '0', '2023-04-22 11:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('467', '1', '2', '1', '2023-04-22', '11:45:00', '0', '2023-04-22 11:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('468', '1', '4', '1', '2023-04-22', '11:48:00', '0', '2023-04-22 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('469', '1', '2', '1', '2023-04-22', '11:51:00', '0', '2023-04-22 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('470', '1', '7', '1', '2023-04-22', '11:54:00', '0', '2023-04-22 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('471', '1', '8', '1', '2023-04-22', '11:57:00', '0', '2023-04-22 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('472', '1', '4', '1', '2023-04-22', '12:00:00', '0', '2023-04-22 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('473', '1', '5', '1', '2023-04-22', '12:03:00', '0', '2023-04-22 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('474', '1', '3', '1', '2023-04-22', '12:06:00', '0', '2023-04-22 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('475', '1', '0', '1', '2023-04-22', '12:09:00', '0', '2023-04-22 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('476', '1', '5', '1', '2023-04-22', '12:12:00', '0', '2023-04-22 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('477', '1', '7', '1', '2023-04-22', '12:15:00', '0', '2023-04-22 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('478', '1', '3', '1', '2023-04-22', '12:18:00', '0', '2023-04-22 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('479', '1', '3', '1', '2023-04-22', '12:21:00', '0', '2023-04-22 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('480', '1', '6', '1', '2023-04-22', '12:24:00', '0', '2023-04-22 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('481', '1', '8', '1', '2023-04-22', '12:27:00', '0', '2023-04-22 12:28:25', null, '1');
INSERT INTO `mx_result_tran` VALUES ('482', '1', '3', '1', '2023-04-22', '12:30:00', '0', '2023-04-22 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('483', '1', '3', '1', '2023-04-22', '12:33:00', '0', '2023-04-22 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('484', '1', '9', '1', '2023-04-22', '12:36:00', '0', '2023-04-22 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('485', '1', '6', '1', '2023-04-22', '12:39:00', '0', '2023-04-22 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('486', '1', '1', '1', '2023-04-22', '12:42:00', '0', '2023-04-22 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('487', '1', '7', '1', '2023-04-22', '12:45:00', '0', '2023-04-22 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('488', '1', '5', '1', '2023-04-22', '12:48:00', '0', '2023-04-22 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('489', '1', '6', '1', '2023-04-22', '12:51:00', '0', '2023-04-22 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('490', '1', '8', '1', '2023-04-22', '12:54:00', '0', '2023-04-22 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('491', '1', '6', '1', '2023-04-22', '12:57:00', '0', '2023-04-22 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('492', '1', '3', '1', '2023-04-22', '01:00:00', '0', '2023-04-22 01:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('493', '1', '1', '1', '2023-04-22', '01:03:00', '0', '2023-04-22 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('494', '1', '5', '1', '2023-04-22', '01:06:00', '0', '2023-04-22 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('495', '1', '8', '1', '2023-04-22', '01:09:00', '0', '2023-04-22 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('496', '1', '5', '1', '2023-04-22', '01:12:00', '0', '2023-04-22 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('497', '1', '5', '1', '2023-04-22', '01:15:00', '0', '2023-04-22 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('498', '1', '5', '1', '2023-04-22', '01:18:00', '0', '2023-04-22 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('499', '1', '7', '1', '2023-04-22', '01:21:00', '0', '2023-04-22 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('500', '1', '9', '1', '2023-04-22', '01:24:00', '0', '2023-04-22 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('501', '1', '8', '1', '2023-04-22', '01:27:00', '0', '2023-04-22 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('502', '1', '0', '1', '2023-04-22', '01:30:00', '0', '2023-04-22 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('503', '1', '3', '1', '2023-04-22', '01:33:00', '0', '2023-04-22 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('504', '1', '5', '1', '2023-04-22', '01:36:00', '0', '2023-04-22 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('505', '1', '8', '1', '2023-04-22', '01:39:00', '0', '2023-04-22 01:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('506', '1', '4', '1', '2023-04-22', '01:42:00', '0', '2023-04-22 01:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('507', '1', '4', '1', '2023-04-22', '01:45:00', '4', '2023-04-22 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('508', '1', '2', '1', '2023-04-22', '01:48:00', '4', '2023-04-22 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('509', '1', '0', '1', '2023-04-22', '01:51:00', '4', '2023-04-22 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('510', '1', '9', '1', '2023-04-22', '01:54:00', '4', '2023-04-22 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('511', '1', '5', '1', '2023-04-22', '01:57:00', '0', '2023-04-22 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('512', '1', '9', '1', '2023-04-22', '02:00:00', '0', '2023-04-22 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('513', '1', '8', '1', '2023-04-22', '02:03:00', '0', '2023-04-22 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('514', '1', '7', '1', '2023-04-22', '02:06:00', '0', '2023-04-22 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('515', '1', '3', '1', '2023-04-22', '02:09:00', '0', '2023-04-22 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('516', '1', '5', '1', '2023-04-22', '02:12:00', '0', '2023-04-22 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('517', '1', '7', '1', '2023-04-22', '02:15:00', '0', '2023-04-22 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('518', '1', '2', '1', '2023-04-22', '02:18:00', '0', '2023-04-22 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('519', '1', '3', '1', '2023-04-22', '02:21:00', '0', '2023-04-22 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('520', '1', '4', '1', '2023-04-22', '02:24:00', '0', '2023-04-22 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('521', '1', '6', '1', '2023-04-22', '02:27:00', '0', '2023-04-22 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('522', '1', '5', '1', '2023-04-22', '02:30:00', '0', '2023-04-22 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('523', '1', '6', '1', '2023-04-22', '02:33:00', '0', '2023-04-22 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('524', '1', '2', '1', '2023-04-22', '02:36:00', '0', '2023-04-22 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('525', '1', '8', '1', '2023-04-22', '02:39:00', '0', '2023-04-22 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('526', '1', '3', '1', '2023-04-22', '02:42:00', '0', '2023-04-22 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('527', '1', '8', '1', '2023-04-22', '02:45:00', '0', '2023-04-22 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('528', '1', '6', '1', '2023-04-22', '02:48:00', '0', '2023-04-22 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('529', '1', '4', '1', '2023-04-22', '02:51:00', '0', '2023-04-22 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('530', '1', '5', '1', '2023-04-22', '02:54:00', '0', '2023-04-22 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('531', '1', '8', '1', '2023-04-22', '02:57:00', '0', '2023-04-22 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('532', '1', '7', '1', '2023-04-22', '03:00:00', '0', '2023-04-22 03:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('533', '1', '9', '1', '2023-04-22', '03:03:00', '0', '2023-04-22 03:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('534', '1', '8', '1', '2023-04-22', '03:06:00', '0', '2023-04-22 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('535', '1', '7', '1', '2023-04-22', '03:09:00', '0', '2023-04-22 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('536', '1', '5', '1', '2023-04-22', '03:12:00', '0', '2023-04-22 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('537', '1', '8', '1', '2023-04-22', '03:15:00', '0', '2023-04-22 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('538', '1', '4', '1', '2023-04-22', '03:18:00', '0', '2023-04-22 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('539', '1', '8', '1', '2023-04-22', '03:21:00', '0', '2023-04-22 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('540', '1', '1', '1', '2023-04-22', '03:24:00', '0', '2023-04-22 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('541', '1', '6', '1', '2023-04-22', '03:27:00', '4', '2023-04-22 03:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('542', '1', '3', '1', '2023-04-22', '03:30:00', '0', '2023-04-22 03:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('543', '1', '0', '1', '2023-04-22', '03:33:00', '0', '2023-04-22 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('544', '1', '4', '1', '2023-04-22', '03:36:00', '0', '2023-04-22 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('545', '1', '9', '1', '2023-04-22', '03:39:00', '0', '2023-04-22 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('546', '1', '4', '1', '2023-04-22', '03:42:00', '0', '2023-04-22 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('547', '1', '6', '1', '2023-04-22', '03:45:00', '0', '2023-04-22 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('548', '1', '7', '1', '2023-04-22', '03:48:00', '0', '2023-04-22 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('549', '1', '4', '1', '2023-04-22', '03:51:00', '0', '2023-04-22 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('550', '1', '2', '1', '2023-04-22', '03:54:00', '0', '2023-04-22 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('551', '1', '8', '1', '2023-04-22', '03:57:00', '0', '2023-04-22 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('552', '1', '8', '1', '2023-04-22', '04:00:00', '0', '2023-04-22 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('553', '1', '3', '1', '2023-04-22', '04:03:00', '0', '2023-04-22 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('554', '1', '9', '1', '2023-04-22', '04:06:00', '0', '2023-04-22 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('555', '1', '7', '1', '2023-04-22', '04:09:00', '0', '2023-04-22 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('556', '1', '2', '1', '2023-04-22', '04:12:00', '0', '2023-04-22 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('557', '1', '1', '1', '2023-04-22', '04:15:00', '4', '2023-04-22 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('558', '1', '4', '1', '2023-04-22', '04:18:00', '4', '2023-04-22 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('559', '1', '4', '1', '2023-04-22', '04:21:00', '4', '2023-04-22 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('560', '1', '0', '1', '2023-04-22', '04:24:00', '0', '2023-04-22 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('561', '1', '8', '1', '2023-04-22', '04:27:00', '3', '2023-04-22 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('562', '1', '4', '1', '2023-04-22', '04:30:00', '0', '2023-04-22 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('563', '1', '1', '1', '2023-04-22', '04:33:00', '0', '2023-04-22 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('564', '1', '7', '1', '2023-04-22', '04:36:00', '0', '2023-04-22 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('565', '1', '9', '1', '2023-04-22', '04:39:00', '0', '2023-04-22 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('566', '1', '3', '1', '2023-04-22', '04:42:00', '0', '2023-04-22 04:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('567', '1', '8', '1', '2023-04-22', '04:45:00', '0', '2023-04-22 04:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('568', '1', '6', '1', '2023-04-22', '04:48:00', '0', '2023-04-22 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('569', '1', '6', '1', '2023-04-22', '04:51:00', '0', '2023-04-22 04:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('570', '1', '6', '1', '2023-04-22', '04:54:00', '0', '2023-04-22 04:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('571', '1', '5', '1', '2023-04-22', '04:57:00', '4', '2023-04-22 04:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('572', '1', '9', '1', '2023-04-22', '05:00:00', '3', '2023-04-22 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('573', '1', '9', '1', '2023-04-22', '05:03:00', '0', '2023-04-22 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('574', '1', '8', '1', '2023-04-22', '05:06:00', '0', '2023-04-22 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('575', '1', '7', '1', '2023-04-22', '05:09:00', '0', '2023-04-22 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('576', '1', '1', '1', '2023-04-22', '05:12:00', '0', '2023-04-22 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('577', '1', '3', '1', '2023-04-22', '05:15:00', '0', '2023-04-22 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('578', '1', '7', '1', '2023-04-22', '05:18:00', '0', '2023-04-22 05:18:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('579', '1', '7', '1', '2023-04-22', '05:21:00', '0', '2023-04-22 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('580', '1', '2', '1', '2023-04-22', '05:24:00', '4', '2023-04-22 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('581', '1', '2', '1', '2023-04-22', '05:27:00', '0', '2023-04-22 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('582', '1', '2', '1', '2023-04-22', '05:30:00', '0', '2023-04-22 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('583', '1', '2', '1', '2023-04-22', '05:33:00', '0', '2023-04-22 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('584', '1', '8', '1', '2023-04-22', '05:36:00', '0', '2023-04-22 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('585', '1', '1', '1', '2023-04-22', '05:39:00', '0', '2023-04-22 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('586', '1', '7', '1', '2023-04-22', '05:42:00', '0', '2023-04-22 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('587', '1', '5', '1', '2023-04-22', '05:45:00', '0', '2023-04-22 05:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('588', '1', '5', '1', '2023-04-22', '05:48:00', '0', '2023-04-22 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('589', '1', '6', '1', '2023-04-22', '05:51:00', '0', '2023-04-22 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('590', '1', '6', '1', '2023-04-22', '05:54:00', '0', '2023-04-22 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('591', '1', '8', '1', '2023-04-22', '05:57:00', '0', '2023-04-22 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('592', '1', '4', '1', '2023-04-22', '06:00:00', '0', '2023-04-22 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('593', '1', '1', '1', '2023-04-22', '06:03:00', '0', '2023-04-22 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('594', '1', '6', '1', '2023-04-22', '06:06:00', '0', '2023-04-22 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('595', '1', '9', '1', '2023-04-22', '06:09:00', '4', '2023-04-22 06:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('596', '1', '1', '1', '2023-04-22', '06:12:00', '0', '2023-04-22 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('597', '1', '4', '1', '2023-04-22', '06:15:00', '4', '2023-04-22 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('598', '1', '7', '1', '2023-04-22', '06:18:00', '4', '2023-04-22 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('599', '1', '0', '1', '2023-04-22', '06:21:00', '0', '2023-04-22 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('600', '1', '5', '1', '2023-04-22', '06:24:00', '4', '2023-04-22 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('601', '1', '8', '1', '2023-04-22', '06:27:00', '0', '2023-04-22 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('602', '1', '1', '1', '2023-04-22', '06:30:00', '0', '2023-04-22 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('603', '1', '8', '1', '2023-04-22', '06:33:00', '0', '2023-04-22 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('604', '1', '6', '1', '2023-04-22', '06:36:00', '0', '2023-04-22 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('605', '1', '8', '1', '2023-04-22', '06:39:00', '0', '2023-04-22 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('606', '1', '9', '1', '2023-04-22', '06:42:00', '0', '2023-04-22 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('607', '1', '4', '1', '2023-04-22', '06:45:00', '0', '2023-04-22 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('608', '1', '7', '1', '2023-04-22', '06:48:00', '0', '2023-04-22 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('609', '1', '4', '1', '2023-04-22', '06:51:00', '0', '2023-04-22 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('610', '1', '4', '1', '2023-04-22', '06:54:00', '0', '2023-04-22 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('611', '1', '2', '1', '2023-04-22', '06:57:00', '0', '2023-04-22 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('612', '1', '2', '1', '2023-04-22', '07:00:00', '0', '2023-04-22 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('613', '1', '6', '1', '2023-04-22', '07:03:00', '0', '2023-04-22 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('614', '1', '6', '1', '2023-04-22', '07:06:00', '0', '2023-04-22 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('615', '1', '4', '1', '2023-04-22', '07:09:00', '0', '2023-04-22 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('616', '1', '2', '1', '2023-04-22', '07:12:00', '0', '2023-04-22 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('617', '1', '3', '1', '2023-04-22', '07:15:00', '4', '2023-04-22 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('618', '1', '1', '1', '2023-04-22', '07:18:00', '0', '2023-04-22 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('619', '1', '2', '1', '2023-04-22', '07:21:00', '0', '2023-04-22 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('620', '1', '8', '1', '2023-04-22', '07:24:00', '0', '2023-04-22 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('621', '1', '5', '1', '2023-04-22', '07:27:00', '0', '2023-04-22 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('622', '1', '9', '1', '2023-04-22', '07:30:00', '0', '2023-04-22 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('623', '1', '2', '1', '2023-04-22', '07:33:00', '0', '2023-04-22 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('624', '1', '2', '1', '2023-04-22', '07:36:00', '4', '2023-04-22 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('625', '1', '2', '1', '2023-04-22', '07:39:00', '0', '2023-04-22 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('626', '1', '0', '1', '2023-04-22', '07:42:00', '0', '2023-04-22 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('627', '1', '4', '1', '2023-04-22', '07:45:00', '0', '2023-04-22 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('628', '1', '4', '1', '2023-04-22', '07:48:00', '0', '2023-04-22 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('629', '1', '2', '1', '2023-04-22', '07:51:00', '0', '2023-04-22 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('630', '1', '1', '1', '2023-04-22', '07:54:00', '0', '2023-04-22 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('631', '1', '4', '1', '2023-04-22', '07:57:00', '0', '2023-04-22 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('632', '1', '0', '1', '2023-04-22', '08:00:00', '4', '2023-04-22 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('633', '1', '6', '1', '2023-04-22', '08:03:00', '0', '2023-04-22 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('634', '1', '2', '1', '2023-04-22', '08:06:00', '4', '2023-04-22 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('635', '1', '8', '1', '2023-04-22', '08:09:00', '0', '2023-04-22 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('636', '1', '0', '1', '2023-04-22', '08:12:00', '0', '2023-04-22 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('637', '1', '3', '1', '2023-04-22', '08:15:00', '2', '2023-04-22 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('638', '1', '7', '1', '2023-04-22', '08:18:00', '0', '2023-04-22 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('639', '1', '9', '1', '2023-04-22', '08:21:00', '0', '2023-04-22 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('640', '1', '1', '1', '2023-04-22', '08:24:00', '0', '2023-04-22 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('641', '1', '8', '1', '2023-04-22', '08:27:00', '0', '2023-04-22 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('642', '1', '7', '1', '2023-04-22', '08:30:00', '4', '2023-04-22 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('643', '1', '2', '1', '2023-04-22', '08:33:00', '0', '2023-04-22 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('644', '1', '0', '1', '2023-04-22', '08:36:00', '0', '2023-04-22 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('645', '1', '1', '1', '2023-04-22', '08:39:00', '0', '2023-04-22 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('646', '1', '7', '1', '2023-04-22', '08:42:00', '0', '2023-04-22 08:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('647', '1', '4', '1', '2023-04-22', '08:45:00', '4', '2023-04-22 08:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('648', '1', '8', '1', '2023-04-22', '08:48:00', '0', '2023-04-22 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('649', '1', '8', '1', '2023-04-22', '08:51:00', '0', '2023-04-22 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('650', '1', '3', '1', '2023-04-22', '08:54:00', '0', '2023-04-22 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('651', '1', '4', '1', '2023-04-22', '08:57:00', '0', '2023-04-22 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('652', '1', '6', '1', '2023-04-22', '09:00:00', '0', '2023-04-22 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('653', '1', '2', '1', '2023-04-22', '09:03:00', '0', '2023-04-22 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('654', '1', '3', '1', '2023-04-22', '09:06:00', '0', '2023-04-22 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('655', '1', '0', '1', '2023-04-22', '09:09:00', '0', '2023-04-22 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('656', '1', '6', '1', '2023-04-22', '09:12:00', '0', '2023-04-22 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('657', '1', '7', '1', '2023-04-22', '09:15:00', '0', '2023-04-22 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('658', '1', '7', '1', '2023-04-22', '09:18:00', '0', '2023-04-22 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('659', '1', '0', '1', '2023-04-22', '09:21:00', '0', '2023-04-22 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('660', '1', '6', '1', '2023-04-22', '09:24:00', '0', '2023-04-22 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('661', '1', '0', '1', '2023-04-22', '09:27:00', '0', '2023-04-22 09:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('662', '1', '1', '1', '2023-04-22', '09:30:00', '0', '2023-04-22 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('663', '1', '1', '1', '2023-04-22', '09:33:00', '0', '2023-04-22 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('664', '1', '6', '1', '2023-04-22', '09:36:00', '0', '2023-04-22 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('665', '1', '2', '1', '2023-04-22', '09:39:00', '0', '2023-04-22 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('666', '1', '1', '1', '2023-04-22', '09:42:00', '0', '2023-04-22 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('667', '1', '6', '1', '2023-04-22', '09:45:00', '0', '2023-04-22 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('668', '1', '9', '1', '2023-04-23', '10:00:00', '0', '2023-04-23 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('669', '1', '3', '1', '2023-04-23', '10:03:00', '0', '2023-04-23 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('670', '1', '3', '1', '2023-04-23', '10:06:00', '0', '2023-04-23 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('671', '1', '4', '1', '2023-04-23', '10:09:00', '0', '2023-04-23 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('672', '1', '5', '1', '2023-04-23', '10:12:00', '0', '2023-04-23 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('673', '1', '1', '1', '2023-04-23', '10:15:00', '0', '2023-04-23 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('674', '1', '9', '1', '2023-04-23', '10:18:00', '0', '2023-04-23 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('675', '1', '8', '1', '2023-04-23', '10:21:00', '0', '2023-04-23 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('676', '1', '5', '1', '2023-04-23', '10:24:00', '0', '2023-04-23 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('677', '1', '2', '1', '2023-04-23', '10:27:00', '0', '2023-04-23 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('678', '1', '9', '1', '2023-04-23', '10:30:00', '0', '2023-04-23 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('679', '1', '3', '1', '2023-04-23', '10:33:00', '0', '2023-04-23 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('680', '1', '3', '1', '2023-04-23', '10:36:00', '0', '2023-04-23 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('681', '1', '1', '1', '2023-04-23', '10:39:00', '0', '2023-04-23 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('682', '1', '6', '1', '2023-04-23', '10:42:00', '0', '2023-04-23 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('683', '1', '4', '1', '2023-04-23', '10:45:00', '4', '2023-04-23 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('684', '1', '1', '1', '2023-04-23', '10:48:00', '0', '2023-04-23 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('685', '1', '0', '1', '2023-04-23', '10:51:00', '0', '2023-04-23 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('686', '1', '9', '1', '2023-04-23', '10:54:00', '0', '2023-04-23 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('687', '1', '3', '1', '2023-04-23', '10:57:00', '0', '2023-04-23 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('688', '1', '0', '1', '2023-04-23', '11:00:00', '0', '2023-04-23 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('689', '1', '0', '1', '2023-04-23', '11:03:00', '0', '2023-04-23 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('690', '1', '6', '1', '2023-04-23', '11:06:00', '0', '2023-04-23 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('691', '1', '9', '1', '2023-04-23', '11:09:00', '0', '2023-04-23 11:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('692', '1', '2', '1', '2023-04-23', '11:12:00', '0', '2023-04-23 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('693', '1', '2', '1', '2023-04-23', '11:15:00', '0', '2023-04-23 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('694', '1', '5', '1', '2023-04-23', '11:18:00', '0', '2023-04-23 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('695', '1', '7', '1', '2023-04-23', '11:21:00', '0', '2023-04-23 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('696', '1', '2', '1', '2023-04-23', '11:24:00', '0', '2023-04-23 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('697', '1', '9', '1', '2023-04-23', '11:27:00', '0', '2023-04-23 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('698', '1', '5', '1', '2023-04-23', '11:30:00', '0', '2023-04-23 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('699', '1', '1', '1', '2023-04-23', '11:33:00', '0', '2023-04-23 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('700', '1', '3', '1', '2023-04-23', '11:36:00', '4', '2023-04-23 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('701', '1', '6', '1', '2023-04-23', '11:39:00', '4', '2023-04-23 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('702', '1', '6', '1', '2023-04-23', '11:42:00', '0', '2023-04-23 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('703', '1', '0', '1', '2023-04-23', '11:45:00', '0', '2023-04-23 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('704', '1', '7', '1', '2023-04-23', '11:48:00', '0', '2023-04-23 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('705', '1', '7', '1', '2023-04-23', '11:51:00', '0', '2023-04-23 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('706', '1', '8', '1', '2023-04-23', '11:54:00', '0', '2023-04-23 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('707', '1', '2', '1', '2023-04-23', '11:57:00', '0', '2023-04-23 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('708', '1', '0', '1', '2023-04-23', '12:00:00', '0', '2023-04-23 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('709', '1', '0', '1', '2023-04-23', '12:03:00', '0', '2023-04-23 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('710', '1', '1', '1', '2023-04-23', '12:06:00', '0', '2023-04-23 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('711', '1', '1', '1', '2023-04-23', '12:09:00', '0', '2023-04-23 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('712', '1', '3', '1', '2023-04-23', '12:12:00', '0', '2023-04-23 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('713', '1', '7', '1', '2023-04-23', '12:15:00', '0', '2023-04-23 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('714', '1', '9', '1', '2023-04-23', '12:18:00', '3', '2023-04-23 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('715', '1', '0', '1', '2023-04-23', '12:21:00', '0', '2023-04-23 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('716', '1', '2', '1', '2023-04-23', '12:24:00', '0', '2023-04-23 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('717', '1', '1', '1', '2023-04-23', '12:27:00', '4', '2023-04-23 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('718', '1', '5', '1', '2023-04-23', '12:30:00', '0', '2023-04-23 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('719', '1', '8', '1', '2023-04-23', '12:33:00', '0', '2023-04-23 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('720', '1', '7', '1', '2023-04-23', '12:36:00', '0', '2023-04-23 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('721', '1', '2', '1', '2023-04-23', '12:39:00', '0', '2023-04-23 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('722', '1', '7', '1', '2023-04-23', '12:42:00', '0', '2023-04-23 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('723', '1', '8', '1', '2023-04-23', '12:45:00', '0', '2023-04-23 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('724', '1', '5', '1', '2023-04-23', '12:48:00', '4', '2023-04-23 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('725', '1', '1', '1', '2023-04-23', '12:51:00', '4', '2023-04-23 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('726', '1', '9', '1', '2023-04-23', '12:54:00', '0', '2023-04-23 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('727', '1', '8', '1', '2023-04-23', '12:57:00', '0', '2023-04-23 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('728', '1', '3', '1', '2023-04-23', '01:00:00', '0', '2023-04-23 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('729', '1', '1', '1', '2023-04-23', '01:03:00', '0', '2023-04-23 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('730', '1', '0', '1', '2023-04-23', '01:06:00', '0', '2023-04-23 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('731', '1', '2', '1', '2023-04-23', '01:09:00', '0', '2023-04-23 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('732', '1', '1', '1', '2023-04-23', '01:12:00', '0', '2023-04-23 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('733', '1', '3', '1', '2023-04-23', '01:15:00', '3', '2023-04-23 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('734', '1', '9', '1', '2023-04-23', '01:18:00', '0', '2023-04-23 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('735', '1', '0', '1', '2023-04-23', '01:21:00', '0', '2023-04-23 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('736', '1', '2', '1', '2023-04-23', '01:24:00', '0', '2023-04-23 01:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('737', '1', '2', '1', '2023-04-23', '01:27:00', '0', '2023-04-23 01:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('738', '1', '1', '1', '2023-04-23', '01:30:00', '0', '2023-04-23 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('739', '1', '5', '1', '2023-04-23', '01:33:00', '0', '2023-04-23 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('740', '1', '5', '1', '2023-04-23', '01:36:00', '0', '2023-04-23 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('741', '1', '3', '1', '2023-04-23', '01:39:00', '0', '2023-04-23 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('742', '1', '5', '1', '2023-04-23', '01:42:00', '0', '2023-04-23 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('743', '1', '9', '1', '2023-04-23', '01:45:00', '4', '2023-04-23 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('744', '1', '4', '1', '2023-04-23', '01:48:00', '4', '2023-04-23 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('745', '1', '4', '1', '2023-04-23', '01:51:00', '4', '2023-04-23 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('746', '1', '6', '1', '2023-04-23', '01:54:00', '4', '2023-04-23 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('747', '1', '3', '1', '2023-04-23', '01:57:00', '4', '2023-04-23 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('748', '1', '5', '1', '2023-04-23', '02:00:00', '0', '2023-04-23 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('749', '1', '0', '1', '2023-04-23', '02:03:00', '0', '2023-04-23 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('750', '1', '6', '1', '2023-04-23', '02:06:00', '0', '2023-04-23 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('751', '1', '6', '1', '2023-04-23', '02:09:00', '0', '2023-04-23 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('752', '1', '2', '1', '2023-04-23', '02:12:00', '0', '2023-04-23 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('753', '1', '5', '1', '2023-04-23', '02:15:00', '2', '2023-04-23 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('754', '1', '4', '1', '2023-04-23', '02:18:00', '0', '2023-04-23 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('755', '1', '3', '1', '2023-04-23', '02:21:00', '0', '2023-04-23 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('756', '1', '9', '1', '2023-04-23', '02:24:00', '0', '2023-04-23 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('757', '1', '0', '1', '2023-04-23', '02:27:00', '0', '2023-04-23 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('758', '1', '1', '1', '2023-04-23', '02:30:00', '0', '2023-04-23 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('759', '1', '9', '1', '2023-04-23', '02:33:00', '0', '2023-04-23 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('760', '1', '2', '1', '2023-04-23', '02:36:00', '0', '2023-04-23 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('761', '1', '7', '1', '2023-04-23', '02:39:00', '0', '2023-04-23 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('762', '1', '8', '1', '2023-04-23', '02:42:00', '0', '2023-04-23 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('763', '1', '5', '1', '2023-04-23', '02:45:00', '0', '2023-04-23 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('764', '1', '4', '1', '2023-04-23', '02:48:00', '0', '2023-04-23 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('765', '1', '8', '1', '2023-04-23', '02:51:00', '0', '2023-04-23 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('766', '1', '1', '1', '2023-04-23', '02:54:00', '0', '2023-04-23 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('767', '1', '8', '1', '2023-04-23', '02:57:00', '4', '2023-04-23 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('768', '1', '9', '1', '2023-04-23', '03:00:00', '0', '2023-04-23 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('769', '1', '6', '1', '2023-04-23', '03:03:00', '0', '2023-04-23 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('770', '1', '0', '1', '2023-04-23', '03:06:00', '0', '2023-04-23 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('771', '1', '9', '1', '2023-04-23', '03:09:00', '0', '2023-04-23 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('772', '1', '7', '1', '2023-04-23', '03:12:00', '4', '2023-04-23 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('773', '1', '1', '1', '2023-04-23', '03:15:00', '0', '2023-04-23 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('774', '1', '7', '1', '2023-04-23', '03:18:00', '0', '2023-04-23 03:18:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('775', '1', '8', '1', '2023-04-23', '03:21:00', '0', '2023-04-23 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('776', '1', '2', '1', '2023-04-23', '03:24:00', '0', '2023-04-23 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('777', '1', '5', '1', '2023-04-23', '03:27:00', '4', '2023-04-23 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('778', '1', '3', '1', '2023-04-23', '03:30:00', '0', '2023-04-23 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('779', '1', '7', '1', '2023-04-23', '03:33:00', '2', '2023-04-23 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('780', '1', '1', '1', '2023-04-23', '03:36:00', '0', '2023-04-23 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('781', '1', '0', '1', '2023-04-23', '03:39:00', '0', '2023-04-23 03:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('782', '1', '8', '1', '2023-04-24', '10:00:00', '0', '2023-04-24 10:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('783', '1', '1', '1', '2023-04-24', '10:03:00', '0', '2023-04-24 10:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('784', '1', '5', '1', '2023-04-24', '10:06:00', '0', '2023-04-24 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('785', '1', '0', '1', '2023-04-24', '10:09:00', '0', '2023-04-24 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('786', '1', '2', '1', '2023-04-24', '10:12:00', '0', '2023-04-24 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('787', '1', '7', '1', '2023-04-24', '10:15:00', '0', '2023-04-24 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('788', '1', '3', '1', '2023-04-24', '10:18:00', '0', '2023-04-24 10:18:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('789', '1', '1', '1', '2023-04-24', '10:21:00', '0', '2023-04-24 10:21:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('790', '1', '8', '1', '2023-04-24', '10:24:00', '0', '2023-04-24 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('791', '1', '0', '1', '2023-04-24', '10:27:00', '0', '2023-04-24 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('792', '1', '6', '1', '2023-04-24', '10:30:00', '0', '2023-04-24 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('793', '1', '5', '1', '2023-04-24', '10:33:00', '0', '2023-04-24 10:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('794', '1', '1', '1', '2023-04-24', '10:36:00', '0', '2023-04-24 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('795', '1', '1', '1', '2023-04-24', '10:39:00', '0', '2023-04-24 10:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('796', '1', '3', '1', '2023-04-24', '10:42:00', '0', '2023-04-24 10:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('797', '1', '8', '1', '2023-04-24', '10:45:00', '4', '2023-04-24 10:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('798', '1', '7', '1', '2023-04-24', '10:48:00', '0', '2023-04-24 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('799', '1', '0', '1', '2023-04-24', '10:51:00', '0', '2023-04-24 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('800', '1', '8', '1', '2023-04-24', '10:54:00', '0', '2023-04-24 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('801', '1', '7', '1', '2023-04-24', '10:57:00', '0', '2023-04-24 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('802', '1', '1', '1', '2023-04-24', '11:00:00', '0', '2023-04-24 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('803', '1', '1', '1', '2023-04-24', '11:03:00', '0', '2023-04-24 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('804', '1', '9', '1', '2023-04-24', '11:06:00', '0', '2023-04-24 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('805', '1', '6', '1', '2023-04-24', '11:09:00', '0', '2023-04-24 11:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('806', '1', '0', '1', '2023-04-24', '11:12:00', '0', '2023-04-24 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('807', '1', '9', '1', '2023-04-24', '11:15:00', '0', '2023-04-24 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('808', '1', '0', '1', '2023-04-24', '11:18:00', '0', '2023-04-24 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('809', '1', '6', '1', '2023-04-24', '11:21:00', '0', '2023-04-24 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('810', '1', '7', '1', '2023-04-24', '11:24:00', '0', '2023-04-24 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('811', '1', '1', '1', '2023-04-24', '11:27:00', '0', '2023-04-24 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('812', '1', '4', '1', '2023-04-24', '11:30:00', '0', '2023-04-24 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('813', '1', '8', '1', '2023-04-24', '11:33:00', '0', '2023-04-24 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('814', '1', '2', '1', '2023-04-24', '11:36:00', '4', '2023-04-24 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('815', '1', '2', '1', '2023-04-24', '11:39:00', '4', '2023-04-24 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('816', '1', '9', '1', '2023-04-24', '11:42:00', '0', '2023-04-24 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('817', '1', '6', '1', '2023-04-24', '11:45:00', '0', '2023-04-24 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('818', '1', '9', '1', '2023-04-24', '11:48:00', '0', '2023-04-24 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('819', '1', '1', '1', '2023-04-24', '11:51:00', '0', '2023-04-24 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('820', '1', '3', '1', '2023-04-24', '11:54:00', '0', '2023-04-24 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('821', '1', '9', '1', '2023-04-24', '11:57:00', '0', '2023-04-24 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('822', '1', '9', '1', '2023-04-24', '12:00:00', '0', '2023-04-24 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('823', '1', '5', '1', '2023-04-24', '12:03:00', '0', '2023-04-24 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('824', '1', '3', '1', '2023-04-24', '12:06:00', '0', '2023-04-24 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('825', '1', '2', '1', '2023-04-24', '12:09:00', '0', '2023-04-24 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('826', '1', '2', '1', '2023-04-24', '12:12:00', '0', '2023-04-24 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('827', '1', '6', '1', '2023-04-24', '12:15:00', '0', '2023-04-24 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('828', '1', '2', '1', '2023-04-24', '12:18:00', '0', '2023-04-24 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('829', '1', '6', '1', '2023-04-24', '12:21:00', '0', '2023-04-24 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('830', '1', '0', '1', '2023-04-24', '12:24:00', '0', '2023-04-24 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('831', '1', '4', '1', '2023-04-24', '12:27:00', '0', '2023-04-24 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('832', '1', '7', '1', '2023-04-24', '12:30:00', '0', '2023-04-24 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('833', '1', '9', '1', '2023-04-24', '12:33:00', '0', '2023-04-24 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('834', '1', '5', '1', '2023-04-24', '12:36:00', '0', '2023-04-24 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('835', '1', '0', '1', '2023-04-24', '12:39:00', '0', '2023-04-24 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('836', '1', '3', '1', '2023-04-24', '12:42:00', '0', '2023-04-24 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('837', '1', '8', '1', '2023-04-24', '12:45:00', '0', '2023-04-24 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('838', '1', '4', '1', '2023-04-24', '12:48:00', '0', '2023-04-24 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('839', '1', '7', '1', '2023-04-24', '12:51:00', '0', '2023-04-24 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('840', '1', '7', '1', '2023-04-24', '12:54:00', '0', '2023-04-24 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('841', '1', '6', '1', '2023-04-24', '12:57:00', '0', '2023-04-24 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('842', '1', '5', '1', '2023-04-24', '01:00:00', '0', '2023-04-24 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('843', '1', '1', '1', '2023-04-24', '01:03:00', '0', '2023-04-24 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('844', '1', '1', '1', '2023-04-24', '01:06:00', '0', '2023-04-24 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('845', '1', '1', '1', '2023-04-24', '01:09:00', '0', '2023-04-24 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('846', '1', '3', '1', '2023-04-24', '01:12:00', '0', '2023-04-24 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('847', '1', '5', '1', '2023-04-24', '01:15:00', '0', '2023-04-24 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('848', '1', '1', '1', '2023-04-24', '01:18:00', '0', '2023-04-24 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('849', '1', '0', '1', '2023-04-24', '01:21:00', '0', '2023-04-24 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('850', '1', '8', '1', '2023-04-24', '01:24:00', '0', '2023-04-24 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('851', '1', '2', '1', '2023-04-24', '01:27:00', '0', '2023-04-24 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('852', '1', '1', '1', '2023-04-24', '01:30:00', '0', '2023-04-24 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('853', '1', '7', '1', '2023-04-24', '01:33:00', '0', '2023-04-24 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('854', '1', '5', '1', '2023-04-24', '01:36:00', '0', '2023-04-24 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('855', '1', '0', '1', '2023-04-24', '01:39:00', '0', '2023-04-24 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('856', '1', '6', '1', '2023-04-24', '01:42:00', '0', '2023-04-24 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('857', '1', '9', '1', '2023-04-24', '01:45:00', '0', '2023-04-24 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('858', '1', '7', '1', '2023-04-24', '01:48:00', '4', '2023-04-24 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('859', '1', '4', '1', '2023-04-24', '01:51:00', '0', '2023-04-24 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('860', '1', '1', '1', '2023-04-24', '01:54:00', '0', '2023-04-24 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('861', '1', '3', '1', '2023-04-24', '01:57:00', '0', '2023-04-24 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('862', '1', '1', '1', '2023-04-24', '02:00:00', '0', '2023-04-24 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('863', '1', '3', '1', '2023-04-24', '02:03:00', '3', '2023-04-24 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('864', '1', '4', '1', '2023-04-24', '02:06:00', '0', '2023-04-24 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('865', '1', '8', '1', '2023-04-24', '02:09:00', '0', '2023-04-24 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('866', '1', '4', '1', '2023-04-24', '02:12:00', '0', '2023-04-24 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('867', '1', '7', '1', '2023-04-24', '02:15:00', '2', '2023-04-24 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('868', '1', '2', '1', '2023-04-24', '02:18:00', '0', '2023-04-24 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('869', '1', '3', '1', '2023-04-24', '02:21:00', '0', '2023-04-24 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('870', '1', '0', '1', '2023-04-24', '02:24:00', '0', '2023-04-24 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('871', '1', '8', '1', '2023-04-24', '02:27:00', '0', '2023-04-24 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('872', '1', '0', '1', '2023-04-24', '02:30:00', '2', '2023-04-24 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('873', '1', '1', '1', '2023-04-24', '02:33:00', '0', '2023-04-24 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('874', '1', '8', '1', '2023-04-24', '02:36:00', '0', '2023-04-24 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('875', '1', '1', '1', '2023-04-24', '02:39:00', '0', '2023-04-24 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('876', '1', '8', '1', '2023-04-24', '02:42:00', '3', '2023-04-24 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('877', '1', '0', '1', '2023-04-24', '02:45:00', '0', '2023-04-24 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('878', '1', '5', '1', '2023-04-24', '02:48:00', '0', '2023-04-24 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('879', '1', '0', '1', '2023-04-24', '02:51:00', '0', '2023-04-24 02:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('880', '1', '7', '1', '2023-04-24', '02:54:00', '0', '2023-04-24 02:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('881', '1', '4', '1', '2023-04-24', '02:57:00', '0', '2023-04-24 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('882', '1', '1', '1', '2023-04-24', '03:00:00', '0', '2023-04-24 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('883', '1', '1', '1', '2023-04-24', '03:03:00', '2', '2023-04-24 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('884', '1', '1', '1', '2023-04-24', '03:06:00', '0', '2023-04-24 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('885', '1', '1', '1', '2023-04-24', '03:09:00', '0', '2023-04-24 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('886', '1', '2', '1', '2023-04-24', '03:12:00', '0', '2023-04-24 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('887', '1', '1', '1', '2023-04-24', '03:15:00', '0', '2023-04-24 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('888', '1', '2', '1', '2023-04-24', '03:18:00', '0', '2023-04-24 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('889', '1', '0', '1', '2023-04-24', '03:21:00', '4', '2023-04-24 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('890', '1', '2', '1', '2023-04-24', '03:24:00', '0', '2023-04-24 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('891', '1', '7', '1', '2023-04-24', '03:27:00', '0', '2023-04-24 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('892', '1', '7', '1', '2023-04-24', '03:30:00', '0', '2023-04-24 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('893', '1', '3', '1', '2023-04-24', '03:33:00', '0', '2023-04-24 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('894', '1', '0', '1', '2023-04-24', '03:36:00', '0', '2023-04-24 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('895', '1', '7', '1', '2023-04-24', '03:39:00', '0', '2023-04-24 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('896', '1', '8', '1', '2023-04-24', '03:42:00', '0', '2023-04-24 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('897', '1', '8', '1', '2023-04-24', '03:45:00', '0', '2023-04-24 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('898', '1', '0', '1', '2023-04-24', '03:48:00', '4', '2023-04-24 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('899', '1', '3', '1', '2023-04-24', '03:51:00', '0', '2023-04-24 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('900', '1', '3', '1', '2023-04-24', '03:54:00', '0', '2023-04-24 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('901', '1', '7', '1', '2023-04-24', '03:57:00', '0', '2023-04-24 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('902', '1', '8', '1', '2023-04-24', '04:00:00', '0', '2023-04-24 04:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('903', '1', '0', '1', '2023-04-24', '04:03:00', '0', '2023-04-24 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('904', '1', '8', '1', '2023-04-24', '04:06:00', '4', '2023-04-24 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('905', '1', '8', '1', '2023-04-24', '04:09:00', '0', '2023-04-24 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('906', '1', '6', '1', '2023-04-24', '04:12:00', '0', '2023-04-24 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('907', '1', '8', '1', '2023-04-24', '04:15:00', '0', '2023-04-24 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('908', '1', '6', '1', '2023-04-24', '04:18:00', '0', '2023-04-24 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('909', '1', '6', '1', '2023-04-24', '04:21:00', '0', '2023-04-24 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('910', '1', '8', '1', '2023-04-24', '04:24:00', '0', '2023-04-24 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('911', '1', '6', '1', '2023-04-24', '04:27:00', '0', '2023-04-24 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('912', '1', '6', '1', '2023-04-24', '04:30:00', '0', '2023-04-24 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('913', '1', '5', '1', '2023-04-24', '04:33:00', '0', '2023-04-24 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('914', '1', '5', '1', '2023-04-24', '04:36:00', '0', '2023-04-24 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('915', '1', '5', '1', '2023-04-24', '04:39:00', '0', '2023-04-24 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('916', '1', '0', '1', '2023-04-24', '04:42:00', '0', '2023-04-24 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('917', '1', '7', '1', '2023-04-24', '04:45:00', '0', '2023-04-24 04:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('918', '1', '8', '1', '2023-04-24', '04:48:00', '0', '2023-04-24 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('919', '1', '8', '1', '2023-04-24', '04:51:00', '0', '2023-04-24 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('920', '1', '5', '1', '2023-04-24', '04:54:00', '0', '2023-04-24 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('921', '1', '2', '1', '2023-04-24', '04:57:00', '0', '2023-04-24 04:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('922', '1', '1', '1', '2023-04-24', '05:00:00', '0', '2023-04-24 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('923', '1', '0', '1', '2023-04-24', '05:03:00', '0', '2023-04-24 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('924', '1', '7', '1', '2023-04-24', '05:06:00', '0', '2023-04-24 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('925', '1', '8', '1', '2023-04-24', '05:09:00', '0', '2023-04-24 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('926', '1', '4', '1', '2023-04-24', '05:12:00', '0', '2023-04-24 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('927', '1', '4', '1', '2023-04-24', '05:15:00', '0', '2023-04-24 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('928', '1', '7', '1', '2023-04-24', '05:18:00', '0', '2023-04-24 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('929', '1', '3', '1', '2023-04-24', '05:21:00', '0', '2023-04-24 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('930', '1', '8', '1', '2023-04-24', '05:24:00', '0', '2023-04-24 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('931', '1', '8', '1', '2023-04-24', '05:27:00', '0', '2023-04-24 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('932', '1', '2', '1', '2023-04-24', '05:30:00', '0', '2023-04-24 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('933', '1', '6', '1', '2023-04-24', '05:33:00', '0', '2023-04-24 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('934', '1', '6', '1', '2023-04-24', '05:36:00', '0', '2023-04-24 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('935', '1', '9', '1', '2023-04-24', '05:39:00', '0', '2023-04-24 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('936', '1', '6', '1', '2023-04-24', '05:42:00', '0', '2023-04-24 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('937', '1', '1', '1', '2023-04-24', '05:45:00', '0', '2023-04-24 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('938', '1', '4', '1', '2023-04-24', '05:48:00', '0', '2023-04-24 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('939', '1', '6', '1', '2023-04-24', '05:51:00', '0', '2023-04-24 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('940', '1', '8', '1', '2023-04-24', '05:54:00', '0', '2023-04-24 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('941', '1', '3', '1', '2023-04-24', '05:57:00', '0', '2023-04-24 05:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('942', '1', '2', '1', '2023-04-24', '06:00:00', '0', '2023-04-24 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('943', '1', '7', '1', '2023-04-24', '06:03:00', '0', '2023-04-24 06:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('944', '1', '1', '1', '2023-04-24', '06:06:00', '0', '2023-04-24 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('945', '1', '6', '1', '2023-04-24', '06:09:00', '2', '2023-04-24 06:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('946', '1', '7', '1', '2023-04-24', '06:12:00', '0', '2023-04-24 06:12:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('947', '1', '1', '1', '2023-04-24', '06:15:00', '0', '2023-04-24 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('948', '1', '0', '1', '2023-04-24', '06:18:00', '0', '2023-04-24 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('949', '1', '4', '1', '2023-04-24', '06:21:00', '0', '2023-04-24 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('950', '1', '5', '1', '2023-04-24', '06:24:00', '0', '2023-04-24 06:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('951', '1', '2', '1', '2023-04-24', '06:27:00', '0', '2023-04-24 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('952', '1', '3', '1', '2023-04-24', '06:30:00', '0', '2023-04-24 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('953', '1', '7', '1', '2023-04-24', '06:33:00', '0', '2023-04-24 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('954', '1', '2', '1', '2023-04-24', '06:36:00', '0', '2023-04-24 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('955', '1', '6', '1', '2023-04-24', '06:39:00', '0', '2023-04-24 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('956', '1', '8', '1', '2023-04-24', '06:42:00', '0', '2023-04-24 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('957', '1', '8', '1', '2023-04-24', '06:45:00', '0', '2023-04-24 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('958', '1', '1', '1', '2023-04-24', '06:48:00', '0', '2023-04-24 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('959', '1', '2', '1', '2023-04-24', '06:51:00', '3', '2023-04-24 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('960', '1', '3', '1', '2023-04-24', '06:54:00', '0', '2023-04-24 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('961', '1', '0', '1', '2023-04-24', '06:57:00', '0', '2023-04-24 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('962', '1', '1', '1', '2023-04-24', '07:00:00', '0', '2023-04-24 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('963', '1', '3', '1', '2023-04-24', '07:03:00', '0', '2023-04-24 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('964', '1', '8', '1', '2023-04-24', '07:06:00', '0', '2023-04-24 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('965', '1', '6', '1', '2023-04-24', '07:09:00', '0', '2023-04-24 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('966', '1', '7', '1', '2023-04-24', '07:12:00', '0', '2023-04-24 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('967', '1', '1', '1', '2023-04-24', '07:15:00', '0', '2023-04-24 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('968', '1', '1', '1', '2023-04-24', '07:18:00', '0', '2023-04-24 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('969', '1', '2', '1', '2023-04-24', '07:21:00', '0', '2023-04-24 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('970', '1', '2', '1', '2023-04-24', '07:24:00', '0', '2023-04-24 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('971', '1', '2', '1', '2023-04-24', '07:27:00', '0', '2023-04-24 07:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('972', '1', '7', '1', '2023-04-24', '07:30:00', '0', '2023-04-24 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('973', '1', '4', '1', '2023-04-24', '07:33:00', '0', '2023-04-24 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('974', '1', '5', '1', '2023-04-24', '07:36:00', '0', '2023-04-24 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('975', '1', '5', '1', '2023-04-24', '07:39:00', '0', '2023-04-24 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('976', '1', '3', '1', '2023-04-24', '07:42:00', '0', '2023-04-24 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('977', '1', '4', '1', '2023-04-24', '07:45:00', '0', '2023-04-24 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('978', '1', '4', '1', '2023-04-24', '07:48:00', '0', '2023-04-24 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('979', '1', '4', '1', '2023-04-24', '07:51:00', '0', '2023-04-24 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('980', '1', '9', '1', '2023-04-24', '07:54:00', '2', '2023-04-24 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('981', '1', '9', '1', '2023-04-24', '07:57:00', '0', '2023-04-24 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('982', '1', '0', '1', '2023-04-24', '08:00:00', '0', '2023-04-24 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('983', '1', '3', '1', '2023-04-24', '08:03:00', '0', '2023-04-24 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('984', '1', '1', '1', '2023-04-24', '08:06:00', '0', '2023-04-24 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('985', '1', '0', '1', '2023-04-24', '08:09:00', '0', '2023-04-24 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('986', '1', '4', '1', '2023-04-24', '08:12:00', '0', '2023-04-24 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('987', '1', '8', '1', '2023-04-24', '08:15:00', '0', '2023-04-24 08:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('988', '1', '5', '1', '2023-04-24', '08:18:00', '0', '2023-04-24 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('989', '1', '4', '1', '2023-04-24', '08:21:00', '0', '2023-04-24 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('990', '1', '5', '1', '2023-04-24', '08:24:00', '0', '2023-04-24 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('991', '1', '6', '1', '2023-04-24', '08:27:00', '0', '2023-04-24 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('992', '1', '5', '1', '2023-04-24', '08:30:00', '0', '2023-04-24 08:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('993', '1', '9', '1', '2023-04-24', '08:33:00', '0', '2023-04-24 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('994', '1', '2', '1', '2023-04-24', '08:36:00', '0', '2023-04-24 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('995', '1', '6', '1', '2023-04-24', '08:39:00', '0', '2023-04-24 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('996', '1', '4', '1', '2023-04-24', '08:42:00', '0', '2023-04-24 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('997', '1', '2', '1', '2023-04-24', '08:45:00', '0', '2023-04-24 08:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('998', '1', '9', '1', '2023-04-24', '08:48:00', '0', '2023-04-24 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('999', '1', '6', '1', '2023-04-24', '08:51:00', '0', '2023-04-24 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1000', '1', '5', '1', '2023-04-24', '08:54:00', '0', '2023-04-24 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1001', '1', '5', '1', '2023-04-24', '08:57:00', '0', '2023-04-24 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1002', '1', '4', '1', '2023-04-24', '09:00:00', '0', '2023-04-24 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1003', '1', '4', '1', '2023-04-24', '09:03:00', '0', '2023-04-24 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1004', '1', '2', '1', '2023-04-24', '09:06:00', '0', '2023-04-24 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1005', '1', '8', '1', '2023-04-24', '09:09:00', '0', '2023-04-24 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1006', '1', '4', '1', '2023-04-24', '09:12:00', '0', '2023-04-24 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1007', '1', '3', '1', '2023-04-24', '09:15:00', '0', '2023-04-24 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1008', '1', '8', '1', '2023-04-24', '09:18:00', '0', '2023-04-24 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1009', '1', '6', '1', '2023-04-24', '09:21:00', '0', '2023-04-24 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1010', '1', '8', '1', '2023-04-24', '09:24:00', '0', '2023-04-24 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1011', '1', '7', '1', '2023-04-24', '09:27:00', '0', '2023-04-24 09:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1012', '1', '1', '1', '2023-04-24', '09:30:00', '0', '2023-04-24 09:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1013', '1', '2', '1', '2023-04-24', '09:33:00', '0', '2023-04-24 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1014', '1', '0', '1', '2023-04-24', '09:36:00', '0', '2023-04-24 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1015', '1', '8', '1', '2023-04-24', '09:39:00', '0', '2023-04-24 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1016', '1', '1', '1', '2023-04-24', '09:42:00', '0', '2023-04-24 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1017', '1', '2', '1', '2023-04-24', '09:45:00', '0', '2023-04-24 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1181', '1', '2', '1', '2023-04-25', '10:00:00', '0', '2023-04-25 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1182', '1', '4', '1', '2023-04-25', '10:03:00', '0', '2023-04-25 10:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1183', '1', '8', '1', '2023-04-25', '10:06:00', '0', '2023-04-25 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1184', '1', '3', '1', '2023-04-25', '10:09:00', '0', '2023-04-25 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1185', '1', '6', '1', '2023-04-25', '10:12:00', '0', '2023-04-25 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1186', '1', '3', '1', '2023-04-25', '10:15:00', '0', '2023-04-25 10:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1187', '1', '5', '1', '2023-04-25', '10:18:00', '0', '2023-04-25 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1188', '1', '7', '1', '2023-04-25', '10:21:00', '0', '2023-04-25 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1189', '1', '8', '1', '2023-04-25', '10:24:00', '0', '2023-04-25 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1190', '1', '2', '1', '2023-04-25', '10:27:00', '0', '2023-04-25 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1191', '1', '4', '1', '2023-04-25', '10:30:00', '0', '2023-04-25 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1192', '1', '6', '1', '2023-04-25', '10:33:00', '0', '2023-04-25 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1193', '1', '9', '1', '2023-04-25', '10:36:00', '0', '2023-04-25 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1194', '1', '2', '1', '2023-04-25', '10:39:00', '0', '2023-04-25 10:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1195', '1', '0', '1', '2023-04-25', '10:42:00', '0', '2023-04-25 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1196', '1', '4', '1', '2023-04-25', '10:45:00', '0', '2023-04-25 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1197', '1', '5', '1', '2023-04-25', '10:48:00', '0', '2023-04-25 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1198', '1', '7', '1', '2023-04-25', '10:51:00', '0', '2023-04-25 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1199', '1', '1', '1', '2023-04-25', '10:54:00', '0', '2023-04-25 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1200', '1', '2', '1', '2023-04-25', '10:57:00', '0', '2023-04-25 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1201', '1', '4', '1', '2023-04-25', '11:00:00', '0', '2023-04-25 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1202', '1', '0', '1', '2023-04-25', '11:03:00', '0', '2023-04-25 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1203', '1', '8', '1', '2023-04-25', '11:06:00', '0', '2023-04-25 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1204', '1', '3', '1', '2023-04-25', '11:09:00', '0', '2023-04-25 11:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1205', '1', '5', '1', '2023-04-25', '11:12:00', '0', '2023-04-25 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1206', '1', '1', '1', '2023-04-25', '11:15:00', '3', '2023-04-25 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1207', '1', '2', '1', '2023-04-25', '11:18:00', '0', '2023-04-25 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1208', '1', '6', '1', '2023-04-25', '11:21:00', '0', '2023-04-25 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1209', '1', '6', '1', '2023-04-25', '11:24:00', '0', '2023-04-25 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1210', '1', '3', '1', '2023-04-25', '11:27:00', '3', '2023-04-25 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1211', '1', '3', '1', '2023-04-25', '11:30:00', '0', '2023-04-25 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1212', '1', '5', '1', '2023-04-25', '11:33:00', '0', '2023-04-25 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1213', '1', '0', '1', '2023-04-25', '11:36:00', '0', '2023-04-25 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1214', '1', '9', '1', '2023-04-25', '11:39:00', '0', '2023-04-25 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1215', '1', '9', '1', '2023-04-25', '11:42:00', '0', '2023-04-25 11:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1216', '1', '3', '1', '2023-04-25', '11:45:00', '0', '2023-04-25 11:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1217', '1', '6', '1', '2023-04-25', '11:48:00', '0', '2023-04-25 11:48:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1218', '1', '1', '1', '2023-04-25', '11:51:00', '0', '2023-04-25 11:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1219', '1', '1', '1', '2023-04-25', '11:54:00', '0', '2023-04-25 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1220', '1', '3', '1', '2023-04-25', '11:57:00', '0', '2023-04-25 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1221', '1', '8', '1', '2023-04-25', '12:00:00', '0', '2023-04-25 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1222', '1', '8', '1', '2023-04-25', '12:03:00', '0', '2023-04-25 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1223', '1', '2', '1', '2023-04-25', '12:06:00', '0', '2023-04-25 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1224', '1', '7', '1', '2023-04-25', '12:09:00', '0', '2023-04-25 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1225', '1', '8', '1', '2023-04-25', '12:12:00', '0', '2023-04-25 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1226', '1', '3', '1', '2023-04-25', '12:15:00', '0', '2023-04-25 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1227', '1', '1', '1', '2023-04-25', '12:18:00', '0', '2023-04-25 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1228', '1', '8', '1', '2023-04-25', '12:21:00', '0', '2023-04-25 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1229', '1', '2', '1', '2023-04-25', '12:24:00', '0', '2023-04-25 12:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1230', '1', '0', '1', '2023-04-25', '12:27:00', '0', '2023-04-25 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1231', '1', '2', '1', '2023-04-25', '12:30:00', '0', '2023-04-25 12:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1232', '1', '0', '1', '2023-04-25', '12:33:00', '0', '2023-04-25 12:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1233', '1', '6', '1', '2023-04-25', '12:36:00', '0', '2023-04-25 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1234', '1', '4', '1', '2023-04-25', '12:39:00', '0', '2023-04-25 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1235', '1', '2', '1', '2023-04-25', '12:42:00', '0', '2023-04-25 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1236', '1', '2', '1', '2023-04-25', '12:45:00', '0', '2023-04-25 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1237', '1', '5', '1', '2023-04-25', '12:48:00', '0', '2023-04-25 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1238', '1', '2', '1', '2023-04-25', '12:51:00', '0', '2023-04-25 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1239', '1', '5', '1', '2023-04-25', '12:54:00', '0', '2023-04-25 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1240', '1', '8', '1', '2023-04-25', '12:57:00', '0', '2023-04-25 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1241', '1', '0', '1', '2023-04-25', '01:00:00', '0', '2023-04-25 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1242', '1', '2', '1', '2023-04-25', '01:03:00', '0', '2023-04-25 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1243', '1', '1', '1', '2023-04-25', '01:06:00', '0', '2023-04-25 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1244', '1', '0', '1', '2023-04-25', '01:09:00', '0', '2023-04-25 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1245', '1', '1', '1', '2023-04-25', '01:12:00', '0', '2023-04-25 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1246', '1', '5', '1', '2023-04-25', '01:15:00', '0', '2023-04-25 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1247', '1', '2', '1', '2023-04-25', '01:18:00', '0', '2023-04-25 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1248', '1', '7', '1', '2023-04-25', '01:21:00', '0', '2023-04-25 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1249', '1', '1', '1', '2023-04-25', '01:24:00', '0', '2023-04-25 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1250', '1', '1', '1', '2023-04-25', '01:27:00', '0', '2023-04-25 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1251', '1', '1', '1', '2023-04-25', '01:30:00', '4', '2023-04-25 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1252', '1', '3', '1', '2023-04-25', '01:33:00', '0', '2023-04-25 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1253', '1', '0', '1', '2023-04-25', '01:36:00', '0', '2023-04-25 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1254', '1', '9', '1', '2023-04-25', '01:39:00', '0', '2023-04-25 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1255', '1', '7', '1', '2023-04-25', '01:42:00', '0', '2023-04-25 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1256', '1', '3', '1', '2023-04-25', '01:45:00', '0', '2023-04-25 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1257', '1', '7', '1', '2023-04-25', '01:48:00', '0', '2023-04-25 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1258', '1', '0', '1', '2023-04-25', '01:51:00', '0', '2023-04-25 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1259', '1', '3', '1', '2023-04-25', '01:54:00', '0', '2023-04-25 01:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1260', '1', '5', '1', '2023-04-25', '01:57:00', '0', '2023-04-25 01:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1261', '1', '2', '1', '2023-04-25', '02:00:00', '0', '2023-04-25 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1262', '1', '3', '1', '2023-04-25', '02:03:00', '0', '2023-04-25 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1263', '1', '5', '1', '2023-04-25', '02:06:00', '0', '2023-04-25 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1264', '1', '5', '1', '2023-04-25', '02:09:00', '0', '2023-04-25 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1265', '1', '9', '1', '2023-04-25', '02:12:00', '0', '2023-04-25 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1266', '1', '0', '1', '2023-04-25', '02:15:00', '2', '2023-04-25 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1267', '1', '8', '1', '2023-04-25', '02:18:00', '0', '2023-04-25 02:18:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1268', '1', '1', '1', '2023-04-25', '02:21:00', '0', '2023-04-25 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1269', '1', '1', '1', '2023-04-25', '02:24:00', '0', '2023-04-25 02:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1270', '1', '9', '1', '2023-04-25', '02:27:00', '0', '2023-04-25 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1271', '1', '0', '1', '2023-04-25', '02:30:00', '0', '2023-04-25 02:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1272', '1', '0', '1', '2023-04-25', '02:33:00', '0', '2023-04-25 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1273', '1', '8', '1', '2023-04-25', '02:36:00', '0', '2023-04-25 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1274', '1', '8', '1', '2023-04-25', '02:39:00', '0', '2023-04-25 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1275', '1', '8', '1', '2023-04-25', '02:42:00', '3', '2023-04-25 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1276', '1', '1', '1', '2023-04-25', '02:45:00', '0', '2023-04-25 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1277', '1', '5', '1', '2023-04-25', '02:48:00', '0', '2023-04-25 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1278', '1', '9', '1', '2023-04-25', '02:51:00', '0', '2023-04-25 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1279', '1', '2', '1', '2023-04-25', '02:54:00', '0', '2023-04-25 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1280', '1', '4', '1', '2023-04-25', '02:57:00', '0', '2023-04-25 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1281', '1', '1', '1', '2023-04-25', '03:00:00', '0', '2023-04-25 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1282', '1', '8', '1', '2023-04-25', '03:03:00', '0', '2023-04-25 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1283', '1', '8', '1', '2023-04-25', '03:06:00', '0', '2023-04-25 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1284', '1', '8', '1', '2023-04-25', '03:09:00', '0', '2023-04-25 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1285', '1', '2', '1', '2023-04-25', '03:12:00', '0', '2023-04-25 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1286', '1', '0', '1', '2023-04-25', '03:15:00', '0', '2023-04-25 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1287', '1', '5', '1', '2023-04-25', '03:18:00', '0', '2023-04-25 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1288', '1', '3', '1', '2023-04-25', '03:21:00', '0', '2023-04-25 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1289', '1', '1', '1', '2023-04-25', '03:24:00', '0', '2023-04-25 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1290', '1', '1', '1', '2023-04-25', '03:27:00', '0', '2023-04-25 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1291', '1', '5', '1', '2023-04-25', '03:30:00', '0', '2023-04-25 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1292', '1', '0', '1', '2023-04-25', '03:33:00', '0', '2023-04-25 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1293', '1', '1', '1', '2023-04-25', '03:36:00', '0', '2023-04-25 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1294', '1', '9', '1', '2023-04-25', '03:39:00', '0', '2023-04-25 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1295', '1', '0', '1', '2023-04-25', '03:42:00', '0', '2023-04-25 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1296', '1', '7', '1', '2023-04-25', '03:45:00', '0', '2023-04-25 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1297', '1', '6', '1', '2023-04-25', '03:48:00', '0', '2023-04-25 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1298', '1', '5', '1', '2023-04-25', '03:51:00', '0', '2023-04-25 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1299', '1', '5', '1', '2023-04-25', '03:54:00', '0', '2023-04-25 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1300', '1', '4', '1', '2023-04-25', '03:57:00', '0', '2023-04-25 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1301', '1', '5', '1', '2023-04-25', '04:00:00', '0', '2023-04-25 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1302', '1', '5', '1', '2023-04-25', '04:03:00', '0', '2023-04-25 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1303', '1', '7', '1', '2023-04-25', '04:06:00', '0', '2023-04-25 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1304', '1', '6', '1', '2023-04-25', '04:09:00', '0', '2023-04-25 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1305', '1', '7', '1', '2023-04-25', '04:12:00', '0', '2023-04-25 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1306', '1', '8', '1', '2023-04-25', '04:15:00', '0', '2023-04-25 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1307', '1', '9', '1', '2023-04-25', '04:18:00', '0', '2023-04-25 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1308', '1', '0', '1', '2023-04-25', '04:21:00', '0', '2023-04-25 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1309', '1', '2', '1', '2023-04-25', '04:24:00', '0', '2023-04-25 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1310', '1', '2', '1', '2023-04-25', '04:27:00', '0', '2023-04-25 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1311', '1', '2', '1', '2023-04-25', '04:30:00', '0', '2023-04-25 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1312', '1', '1', '1', '2023-04-25', '04:33:00', '0', '2023-04-25 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1313', '1', '4', '1', '2023-04-25', '04:36:00', '0', '2023-04-25 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1314', '1', '8', '1', '2023-04-25', '04:39:00', '0', '2023-04-25 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1315', '1', '9', '1', '2023-04-25', '04:42:00', '0', '2023-04-25 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1316', '1', '8', '1', '2023-04-25', '04:45:00', '0', '2023-04-25 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1317', '1', '8', '1', '2023-04-25', '04:48:00', '0', '2023-04-25 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1318', '1', '9', '1', '2023-04-25', '04:51:00', '0', '2023-04-25 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1319', '1', '3', '1', '2023-04-25', '04:54:00', '0', '2023-04-25 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1320', '1', '3', '1', '2023-04-25', '04:57:00', '0', '2023-04-25 04:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1321', '1', '2', '1', '2023-04-25', '05:00:00', '0', '2023-04-25 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1322', '1', '8', '1', '2023-04-25', '05:03:00', '0', '2023-04-25 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1323', '1', '7', '1', '2023-04-25', '05:06:00', '0', '2023-04-25 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1324', '1', '6', '1', '2023-04-25', '05:09:00', '4', '2023-04-25 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1325', '1', '9', '1', '2023-04-25', '05:12:00', '0', '2023-04-25 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1326', '1', '9', '1', '2023-04-25', '05:15:00', '0', '2023-04-25 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1327', '1', '7', '1', '2023-04-25', '05:18:00', '0', '2023-04-25 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1328', '1', '5', '1', '2023-04-25', '05:21:00', '0', '2023-04-25 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1329', '1', '0', '1', '2023-04-25', '05:24:00', '0', '2023-04-25 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1330', '1', '3', '1', '2023-04-25', '05:27:00', '0', '2023-04-25 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1331', '1', '9', '1', '2023-04-25', '05:30:00', '0', '2023-04-25 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1332', '1', '1', '1', '2023-04-25', '05:33:00', '0', '2023-04-25 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1333', '1', '7', '1', '2023-04-25', '05:36:00', '0', '2023-04-25 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1334', '1', '6', '1', '2023-04-25', '05:39:00', '0', '2023-04-25 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1335', '1', '9', '1', '2023-04-25', '05:42:00', '0', '2023-04-25 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1336', '1', '9', '1', '2023-04-25', '05:45:00', '0', '2023-04-25 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1337', '1', '5', '1', '2023-04-25', '05:48:00', '0', '2023-04-25 05:48:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1338', '1', '5', '1', '2023-04-25', '05:51:00', '0', '2023-04-25 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1339', '1', '6', '1', '2023-04-25', '05:54:00', '0', '2023-04-25 05:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1340', '1', '4', '1', '2023-04-25', '05:57:00', '0', '2023-04-25 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1341', '1', '9', '1', '2023-04-25', '06:00:00', '0', '2023-04-25 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1342', '1', '7', '1', '2023-04-25', '06:03:00', '0', '2023-04-25 06:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1343', '1', '4', '1', '2023-04-25', '06:06:00', '0', '2023-04-25 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1344', '1', '5', '1', '2023-04-25', '06:09:00', '0', '2023-04-25 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1345', '1', '1', '1', '2023-04-25', '06:12:00', '0', '2023-04-25 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1346', '1', '4', '1', '2023-04-25', '06:15:00', '0', '2023-04-25 06:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1347', '1', '4', '1', '2023-04-25', '06:18:00', '0', '2023-04-25 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1348', '1', '5', '1', '2023-04-25', '06:21:00', '4', '2023-04-25 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1349', '1', '0', '1', '2023-04-25', '06:24:00', '0', '2023-04-25 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1350', '1', '8', '1', '2023-04-25', '06:27:00', '0', '2023-04-25 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1351', '1', '5', '1', '2023-04-25', '06:30:00', '0', '2023-04-25 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1352', '1', '3', '1', '2023-04-25', '06:33:00', '0', '2023-04-25 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1353', '1', '8', '1', '2023-04-25', '06:36:00', '0', '2023-04-25 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1354', '1', '5', '1', '2023-04-25', '06:39:00', '0', '2023-04-25 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1355', '1', '2', '1', '2023-04-25', '06:42:00', '0', '2023-04-25 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1356', '1', '6', '1', '2023-04-25', '06:45:00', '0', '2023-04-25 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1357', '1', '4', '1', '2023-04-25', '06:48:00', '0', '2023-04-25 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1358', '1', '9', '1', '2023-04-25', '06:51:00', '3', '2023-04-25 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1359', '1', '9', '1', '2023-04-25', '06:54:00', '0', '2023-04-25 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1360', '1', '5', '1', '2023-04-25', '06:57:00', '0', '2023-04-25 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1361', '1', '7', '1', '2023-04-25', '07:00:00', '0', '2023-04-25 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1362', '1', '0', '1', '2023-04-25', '07:03:00', '0', '2023-04-25 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1363', '1', '1', '1', '2023-04-25', '07:06:00', '0', '2023-04-25 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1364', '1', '9', '1', '2023-04-25', '07:09:00', '0', '2023-04-25 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1365', '1', '3', '1', '2023-04-25', '07:12:00', '0', '2023-04-25 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1366', '1', '8', '1', '2023-04-25', '07:15:00', '4', '2023-04-25 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1367', '1', '8', '1', '2023-04-25', '07:18:00', '0', '2023-04-25 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1368', '1', '5', '1', '2023-04-25', '07:21:00', '0', '2023-04-25 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1369', '1', '1', '1', '2023-04-25', '07:24:00', '0', '2023-04-25 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1370', '1', '8', '1', '2023-04-25', '07:27:00', '0', '2023-04-25 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1371', '1', '7', '1', '2023-04-25', '07:30:00', '0', '2023-04-25 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1372', '1', '3', '1', '2023-04-25', '07:33:00', '0', '2023-04-25 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1373', '1', '8', '1', '2023-04-25', '07:36:00', '0', '2023-04-25 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1374', '1', '4', '1', '2023-04-25', '07:39:00', '0', '2023-04-25 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1375', '1', '0', '1', '2023-04-25', '07:42:00', '0', '2023-04-25 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1376', '1', '3', '1', '2023-04-25', '07:45:00', '0', '2023-04-25 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1377', '1', '8', '1', '2023-04-25', '07:48:00', '0', '2023-04-25 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1378', '1', '3', '1', '2023-04-25', '07:51:00', '0', '2023-04-25 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1379', '1', '4', '1', '2023-04-25', '07:54:00', '2', '2023-04-25 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1380', '1', '1', '1', '2023-04-25', '07:57:00', '0', '2023-04-25 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1381', '1', '2', '1', '2023-04-25', '08:00:00', '0', '2023-04-25 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1382', '1', '6', '1', '2023-04-25', '08:03:00', '0', '2023-04-25 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1383', '1', '9', '1', '2023-04-25', '08:06:00', '0', '2023-04-25 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1384', '1', '6', '1', '2023-04-25', '08:09:00', '0', '2023-04-25 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1385', '1', '6', '1', '2023-04-25', '08:12:00', '0', '2023-04-25 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1386', '1', '3', '1', '2023-04-25', '08:15:00', '0', '2023-04-25 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1387', '1', '4', '1', '2023-04-25', '08:18:00', '0', '2023-04-25 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1388', '1', '5', '1', '2023-04-25', '08:21:00', '0', '2023-04-25 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1389', '1', '3', '1', '2023-04-25', '08:24:00', '0', '2023-04-25 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1390', '1', '3', '1', '2023-04-25', '08:27:00', '0', '2023-04-25 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1391', '1', '2', '1', '2023-04-25', '08:30:00', '0', '2023-04-25 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1392', '1', '7', '1', '2023-04-25', '08:33:00', '0', '2023-04-25 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1393', '1', '8', '1', '2023-04-25', '08:36:00', '0', '2023-04-25 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1394', '1', '8', '1', '2023-04-25', '08:39:00', '0', '2023-04-25 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1395', '1', '2', '1', '2023-04-25', '08:42:00', '0', '2023-04-25 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1396', '1', '9', '1', '2023-04-25', '08:45:00', '0', '2023-04-25 08:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1397', '1', '7', '1', '2023-04-25', '08:48:00', '0', '2023-04-25 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1398', '1', '9', '1', '2023-04-25', '08:51:00', '0', '2023-04-25 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1399', '1', '7', '1', '2023-04-25', '08:54:00', '0', '2023-04-25 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1400', '1', '6', '1', '2023-04-25', '08:57:00', '0', '2023-04-25 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1401', '1', '8', '1', '2023-04-25', '09:00:00', '0', '2023-04-25 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1402', '1', '9', '1', '2023-04-25', '09:03:00', '0', '2023-04-25 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1403', '1', '7', '1', '2023-04-25', '09:06:00', '0', '2023-04-25 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1404', '1', '0', '1', '2023-04-25', '09:09:00', '0', '2023-04-25 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1405', '1', '5', '1', '2023-04-25', '09:12:00', '0', '2023-04-25 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1406', '1', '1', '1', '2023-04-25', '09:15:00', '0', '2023-04-25 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1407', '1', '7', '1', '2023-04-25', '09:18:00', '0', '2023-04-25 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1408', '1', '6', '1', '2023-04-25', '09:21:00', '0', '2023-04-25 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1409', '1', '3', '1', '2023-04-25', '09:24:00', '0', '2023-04-25 09:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1410', '1', '3', '1', '2023-04-25', '09:27:00', '0', '2023-04-25 09:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1411', '1', '1', '1', '2023-04-25', '09:30:00', '0', '2023-04-25 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1412', '1', '2', '1', '2023-04-25', '09:33:00', '0', '2023-04-25 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1413', '1', '9', '1', '2023-04-25', '09:36:00', '0', '2023-04-25 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1414', '1', '6', '1', '2023-04-25', '09:39:00', '0', '2023-04-25 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1415', '1', '2', '1', '2023-04-25', '09:42:00', '0', '2023-04-25 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1416', '1', '9', '1', '2023-04-25', '09:45:00', '0', '2023-04-25 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1556', '1', '8', '1', '2023-04-26', '10:00:00', '0', '2023-04-26 10:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1557', '1', '7', '1', '2023-04-26', '10:03:00', '0', '2023-04-26 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1558', '1', '3', '1', '2023-04-26', '10:06:00', '0', '2023-04-26 10:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1559', '1', '7', '1', '2023-04-26', '10:09:00', '0', '2023-04-26 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1560', '1', '1', '1', '2023-04-26', '10:12:00', '0', '2023-04-26 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1561', '1', '5', '1', '2023-04-26', '10:15:00', '0', '2023-04-26 10:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1562', '1', '0', '1', '2023-04-26', '10:18:00', '0', '2023-04-26 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1563', '1', '8', '1', '2023-04-26', '10:21:00', '0', '2023-04-26 10:21:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1564', '1', '1', '1', '2023-04-26', '10:24:00', '0', '2023-04-26 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1565', '1', '6', '1', '2023-04-26', '10:27:00', '0', '2023-04-26 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1566', '1', '6', '1', '2023-04-26', '10:30:00', '0', '2023-04-26 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1567', '1', '3', '1', '2023-04-26', '10:33:00', '0', '2023-04-26 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1568', '1', '7', '1', '2023-04-26', '10:36:00', '0', '2023-04-26 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1569', '1', '7', '1', '2023-04-26', '10:39:00', '0', '2023-04-26 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1570', '1', '7', '1', '2023-04-26', '10:42:00', '0', '2023-04-26 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1571', '1', '6', '1', '2023-04-26', '10:45:00', '0', '2023-04-26 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1572', '1', '4', '1', '2023-04-26', '10:48:00', '0', '2023-04-26 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1573', '1', '0', '1', '2023-04-26', '10:51:00', '0', '2023-04-26 10:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1574', '1', '5', '1', '2023-04-26', '10:54:00', '0', '2023-04-26 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1575', '1', '2', '1', '2023-04-26', '10:57:00', '0', '2023-04-26 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1576', '1', '8', '1', '2023-04-26', '11:00:00', '0', '2023-04-26 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1577', '1', '8', '1', '2023-04-26', '11:03:00', '0', '2023-04-26 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1578', '1', '5', '1', '2023-04-26', '11:06:00', '0', '2023-04-26 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1579', '1', '4', '1', '2023-04-26', '11:09:00', '0', '2023-04-26 11:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1580', '1', '3', '1', '2023-04-26', '11:12:00', '0', '2023-04-26 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1581', '1', '4', '1', '2023-04-26', '11:15:00', '0', '2023-04-26 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1582', '1', '4', '1', '2023-04-26', '11:18:00', '0', '2023-04-26 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1583', '1', '8', '1', '2023-04-26', '11:21:00', '0', '2023-04-26 11:21:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1584', '1', '1', '1', '2023-04-26', '11:24:00', '0', '2023-04-26 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1585', '1', '5', '1', '2023-04-26', '11:27:00', '0', '2023-04-26 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1586', '1', '0', '1', '2023-04-26', '11:30:00', '0', '2023-04-26 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1587', '1', '3', '1', '2023-04-26', '11:33:00', '0', '2023-04-26 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1588', '1', '3', '1', '2023-04-26', '11:36:00', '0', '2023-04-26 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1589', '1', '3', '1', '2023-04-26', '11:39:00', '0', '2023-04-26 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1590', '1', '1', '1', '2023-04-26', '11:42:00', '0', '2023-04-26 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1591', '1', '3', '1', '2023-04-26', '11:45:00', '0', '2023-04-26 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1592', '1', '8', '1', '2023-04-26', '11:48:00', '0', '2023-04-26 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1593', '1', '1', '1', '2023-04-26', '11:51:00', '0', '2023-04-26 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1594', '1', '4', '1', '2023-04-26', '11:54:00', '0', '2023-04-26 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1595', '1', '4', '1', '2023-04-26', '11:57:00', '0', '2023-04-26 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1596', '1', '3', '1', '2023-04-26', '12:00:00', '0', '2023-04-26 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1597', '1', '8', '1', '2023-04-26', '12:03:00', '2', '2023-04-26 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1598', '1', '1', '1', '2023-04-26', '12:06:00', '0', '2023-04-26 12:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1599', '1', '1', '1', '2023-04-26', '12:09:00', '0', '2023-04-26 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1600', '1', '2', '1', '2023-04-26', '12:12:00', '0', '2023-04-26 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1601', '1', '1', '1', '2023-04-26', '12:15:00', '0', '2023-04-26 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1602', '1', '5', '1', '2023-04-26', '12:18:00', '0', '2023-04-26 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1603', '1', '1', '1', '2023-04-26', '12:21:00', '0', '2023-04-26 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1604', '1', '9', '1', '2023-04-26', '12:24:00', '0', '2023-04-26 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1605', '1', '4', '1', '2023-04-26', '12:27:00', '0', '2023-04-26 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1606', '1', '0', '1', '2023-04-26', '12:30:00', '0', '2023-04-26 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1607', '1', '8', '1', '2023-04-26', '12:33:00', '0', '2023-04-26 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1608', '1', '7', '1', '2023-04-26', '12:36:00', '0', '2023-04-26 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1609', '1', '0', '1', '2023-04-26', '12:39:00', '0', '2023-04-26 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1610', '1', '1', '1', '2023-04-26', '12:42:00', '0', '2023-04-26 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1611', '1', '0', '1', '2023-04-26', '12:45:00', '0', '2023-04-26 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1612', '1', '2', '1', '2023-04-26', '12:48:00', '0', '2023-04-26 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1613', '1', '2', '1', '2023-04-26', '12:51:00', '0', '2023-04-26 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1614', '1', '8', '1', '2023-04-26', '12:54:00', '0', '2023-04-26 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1615', '1', '2', '1', '2023-04-26', '12:57:00', '0', '2023-04-26 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1616', '1', '8', '1', '2023-04-26', '01:00:00', '4', '2023-04-26 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1617', '1', '8', '1', '2023-04-26', '01:03:00', '0', '2023-04-26 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1618', '1', '1', '1', '2023-04-26', '01:06:00', '0', '2023-04-26 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1619', '1', '4', '1', '2023-04-26', '01:09:00', '0', '2023-04-26 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1620', '1', '0', '1', '2023-04-26', '01:12:00', '0', '2023-04-26 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1621', '1', '5', '1', '2023-04-26', '01:15:00', '0', '2023-04-26 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1622', '1', '4', '1', '2023-04-26', '01:18:00', '0', '2023-04-26 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1623', '1', '0', '1', '2023-04-26', '01:21:00', '0', '2023-04-26 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1624', '1', '4', '1', '2023-04-26', '01:24:00', '0', '2023-04-26 01:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1625', '1', '2', '1', '2023-04-26', '01:27:00', '0', '2023-04-26 01:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1626', '1', '1', '1', '2023-04-26', '01:30:00', '0', '2023-04-26 01:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1627', '1', '2', '1', '2023-04-26', '01:33:00', '0', '2023-04-26 01:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1628', '1', '4', '1', '2023-04-26', '01:36:00', '0', '2023-04-26 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1629', '1', '1', '1', '2023-04-26', '01:39:00', '0', '2023-04-26 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1630', '1', '3', '1', '2023-04-26', '01:42:00', '0', '2023-04-26 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1631', '1', '8', '1', '2023-04-26', '01:45:00', '0', '2023-04-26 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1632', '1', '3', '1', '2023-04-26', '01:48:00', '0', '2023-04-26 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1633', '1', '0', '1', '2023-04-26', '01:51:00', '0', '2023-04-26 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1634', '1', '1', '1', '2023-04-26', '01:54:00', '0', '2023-04-26 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1635', '1', '6', '1', '2023-04-26', '01:57:00', '0', '2023-04-26 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1636', '1', '6', '1', '2023-04-26', '02:00:00', '0', '2023-04-26 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1637', '1', '6', '1', '2023-04-26', '02:03:00', '0', '2023-04-26 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1638', '1', '8', '1', '2023-04-26', '02:06:00', '0', '2023-04-26 02:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1639', '1', '0', '1', '2023-04-26', '02:09:00', '3', '2023-04-26 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1640', '1', '3', '1', '2023-04-26', '02:12:00', '0', '2023-04-26 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1641', '1', '3', '1', '2023-04-26', '02:15:00', '0', '2023-04-26 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1642', '1', '5', '1', '2023-04-26', '02:18:00', '0', '2023-04-26 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1643', '1', '9', '1', '2023-04-26', '02:21:00', '0', '2023-04-26 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1644', '1', '8', '1', '2023-04-26', '02:24:00', '0', '2023-04-26 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1645', '1', '0', '1', '2023-04-26', '02:27:00', '0', '2023-04-26 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1646', '1', '3', '1', '2023-04-26', '02:30:00', '0', '2023-04-26 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1647', '1', '5', '1', '2023-04-26', '02:33:00', '0', '2023-04-26 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1648', '1', '1', '1', '2023-04-26', '02:36:00', '0', '2023-04-26 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1649', '1', '2', '1', '2023-04-26', '02:39:00', '0', '2023-04-26 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1650', '1', '9', '1', '2023-04-26', '02:42:00', '0', '2023-04-26 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1651', '1', '4', '1', '2023-04-26', '02:45:00', '0', '2023-04-26 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1652', '1', '7', '1', '2023-04-26', '02:48:00', '0', '2023-04-26 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1653', '1', '5', '1', '2023-04-26', '02:51:00', '0', '2023-04-26 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1654', '1', '6', '1', '2023-04-26', '02:54:00', '0', '2023-04-26 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1655', '1', '4', '1', '2023-04-26', '02:57:00', '0', '2023-04-26 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1656', '1', '5', '1', '2023-04-26', '03:00:00', '0', '2023-04-26 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1657', '1', '5', '1', '2023-04-26', '03:03:00', '0', '2023-04-26 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1658', '1', '9', '1', '2023-04-26', '03:06:00', '0', '2023-04-26 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1659', '1', '2', '1', '2023-04-26', '03:09:00', '0', '2023-04-26 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1660', '1', '4', '1', '2023-04-26', '03:12:00', '0', '2023-04-26 03:12:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1661', '1', '5', '1', '2023-04-26', '03:15:00', '0', '2023-04-26 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1662', '1', '4', '1', '2023-04-26', '03:18:00', '0', '2023-04-26 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1663', '1', '3', '1', '2023-04-26', '03:21:00', '0', '2023-04-26 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1664', '1', '2', '1', '2023-04-26', '03:24:00', '0', '2023-04-26 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1665', '1', '6', '1', '2023-04-26', '03:27:00', '0', '2023-04-26 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1666', '1', '4', '1', '2023-04-26', '03:30:00', '0', '2023-04-26 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1667', '1', '0', '1', '2023-04-26', '03:33:00', '0', '2023-04-26 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1668', '1', '2', '1', '2023-04-26', '03:36:00', '0', '2023-04-26 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1669', '1', '4', '1', '2023-04-26', '03:39:00', '0', '2023-04-26 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1670', '1', '2', '1', '2023-04-26', '03:42:00', '0', '2023-04-26 03:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1671', '1', '7', '1', '2023-04-26', '03:45:00', '0', '2023-04-26 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1672', '1', '5', '1', '2023-04-26', '03:48:00', '0', '2023-04-26 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1673', '1', '3', '1', '2023-04-26', '03:51:00', '2', '2023-04-26 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1674', '1', '4', '1', '2023-04-26', '03:54:00', '0', '2023-04-26 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1675', '1', '5', '1', '2023-04-26', '03:57:00', '0', '2023-04-26 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1676', '1', '3', '1', '2023-04-26', '04:00:00', '0', '2023-04-26 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1677', '1', '5', '1', '2023-04-26', '04:03:00', '2', '2023-04-26 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1678', '1', '1', '1', '2023-04-26', '04:06:00', '0', '2023-04-26 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1679', '1', '8', '1', '2023-04-26', '04:09:00', '0', '2023-04-26 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1680', '1', '2', '1', '2023-04-26', '04:12:00', '0', '2023-04-26 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1681', '1', '9', '1', '2023-04-26', '04:15:00', '0', '2023-04-26 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1682', '1', '1', '1', '2023-04-26', '04:18:00', '0', '2023-04-26 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1683', '1', '9', '1', '2023-04-26', '04:21:00', '0', '2023-04-26 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1684', '1', '2', '1', '2023-04-26', '04:24:00', '0', '2023-04-26 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1685', '1', '5', '1', '2023-04-26', '04:27:00', '0', '2023-04-26 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1686', '1', '1', '1', '2023-04-26', '04:30:00', '0', '2023-04-26 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1687', '1', '2', '1', '2023-04-26', '04:33:00', '0', '2023-04-26 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1688', '1', '0', '1', '2023-04-26', '04:36:00', '0', '2023-04-26 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1689', '1', '0', '1', '2023-04-26', '04:39:00', '0', '2023-04-26 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1690', '1', '6', '1', '2023-04-26', '04:42:00', '0', '2023-04-26 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1691', '1', '4', '1', '2023-04-26', '04:45:00', '3', '2023-04-26 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1692', '1', '7', '1', '2023-04-26', '04:48:00', '0', '2023-04-26 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1693', '1', '9', '1', '2023-04-26', '04:51:00', '0', '2023-04-26 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1694', '1', '0', '1', '2023-04-26', '04:54:00', '0', '2023-04-26 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1695', '1', '7', '1', '2023-04-26', '04:57:00', '0', '2023-04-26 04:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1696', '1', '3', '1', '2023-04-26', '05:00:00', '0', '2023-04-26 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1697', '1', '2', '1', '2023-04-26', '05:03:00', '0', '2023-04-26 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1698', '1', '9', '1', '2023-04-26', '05:06:00', '0', '2023-04-26 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1699', '1', '1', '1', '2023-04-26', '05:09:00', '0', '2023-04-26 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1700', '1', '0', '1', '2023-04-26', '05:12:00', '0', '2023-04-26 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1701', '1', '9', '1', '2023-04-26', '05:15:00', '0', '2023-04-26 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1702', '1', '0', '1', '2023-04-26', '05:18:00', '0', '2023-04-26 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1703', '1', '7', '1', '2023-04-26', '05:21:00', '0', '2023-04-26 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1704', '1', '6', '1', '2023-04-26', '05:24:00', '0', '2023-04-26 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1705', '1', '9', '1', '2023-04-26', '05:27:00', '0', '2023-04-26 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1706', '1', '6', '1', '2023-04-26', '05:30:00', '0', '2023-04-26 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1707', '1', '8', '1', '2023-04-26', '05:33:00', '2', '2023-04-26 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1708', '1', '2', '1', '2023-04-26', '05:36:00', '0', '2023-04-26 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1709', '1', '1', '1', '2023-04-26', '05:39:00', '0', '2023-04-26 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1710', '1', '8', '1', '2023-04-26', '05:42:00', '0', '2023-04-26 05:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1711', '1', '3', '1', '2023-04-26', '05:45:00', '0', '2023-04-26 05:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1712', '1', '8', '1', '2023-04-26', '05:48:00', '0', '2023-04-26 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1713', '1', '7', '1', '2023-04-26', '05:51:00', '0', '2023-04-26 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1714', '1', '3', '1', '2023-04-26', '05:54:00', '0', '2023-04-26 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1715', '1', '1', '1', '2023-04-26', '05:57:00', '0', '2023-04-26 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1716', '1', '7', '1', '2023-04-26', '06:00:00', '0', '2023-04-26 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1717', '1', '3', '1', '2023-04-26', '06:03:00', '0', '2023-04-26 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1718', '1', '5', '1', '2023-04-26', '06:06:00', '0', '2023-04-26 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1719', '1', '5', '1', '2023-04-26', '06:09:00', '0', '2023-04-26 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1720', '1', '0', '1', '2023-04-26', '06:12:00', '0', '2023-04-26 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1721', '1', '3', '1', '2023-04-26', '06:15:00', '0', '2023-04-26 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1722', '1', '7', '1', '2023-04-26', '06:18:00', '0', '2023-04-26 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1723', '1', '1', '1', '2023-04-26', '06:21:00', '0', '2023-04-26 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1724', '1', '6', '1', '2023-04-26', '06:24:00', '0', '2023-04-26 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1725', '1', '3', '1', '2023-04-26', '06:27:00', '0', '2023-04-26 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1726', '1', '6', '1', '2023-04-26', '06:30:00', '0', '2023-04-26 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1727', '1', '3', '1', '2023-04-26', '06:33:00', '0', '2023-04-26 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1728', '1', '2', '1', '2023-04-26', '06:36:00', '0', '2023-04-26 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1729', '1', '1', '1', '2023-04-26', '06:39:00', '0', '2023-04-26 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1730', '1', '2', '1', '2023-04-26', '06:42:00', '0', '2023-04-26 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1731', '1', '5', '1', '2023-04-26', '06:45:00', '0', '2023-04-26 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1732', '1', '4', '1', '2023-04-26', '06:48:00', '2', '2023-04-26 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1733', '1', '7', '1', '2023-04-26', '06:51:00', '0', '2023-04-26 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1734', '1', '5', '1', '2023-04-26', '06:54:00', '0', '2023-04-26 06:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1735', '1', '3', '1', '2023-04-26', '06:57:00', '0', '2023-04-26 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1736', '1', '5', '1', '2023-04-26', '07:00:00', '0', '2023-04-26 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1737', '1', '1', '1', '2023-04-26', '07:03:00', '0', '2023-04-26 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1738', '1', '8', '1', '2023-04-26', '07:06:00', '0', '2023-04-26 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1739', '1', '9', '1', '2023-04-26', '07:09:00', '0', '2023-04-26 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1740', '1', '9', '1', '2023-04-26', '07:12:00', '0', '2023-04-26 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1741', '1', '5', '1', '2023-04-26', '07:15:00', '0', '2023-04-26 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1742', '1', '7', '1', '2023-04-26', '07:18:00', '0', '2023-04-26 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1743', '1', '6', '1', '2023-04-26', '07:21:00', '0', '2023-04-26 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1744', '1', '5', '1', '2023-04-26', '07:24:00', '0', '2023-04-26 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1745', '1', '7', '1', '2023-04-26', '07:27:00', '0', '2023-04-26 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1746', '1', '1', '1', '2023-04-26', '07:30:00', '0', '2023-04-26 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1747', '1', '4', '1', '2023-04-26', '07:33:00', '0', '2023-04-26 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1748', '1', '9', '1', '2023-04-26', '07:36:00', '0', '2023-04-26 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1749', '1', '1', '1', '2023-04-26', '07:39:00', '0', '2023-04-26 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1750', '1', '3', '1', '2023-04-26', '07:42:00', '0', '2023-04-26 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1751', '1', '9', '1', '2023-04-26', '07:45:00', '0', '2023-04-26 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1752', '1', '9', '1', '2023-04-26', '07:48:00', '0', '2023-04-26 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1753', '1', '2', '1', '2023-04-26', '07:51:00', '0', '2023-04-26 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1754', '1', '9', '1', '2023-04-26', '07:54:00', '0', '2023-04-26 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1755', '1', '3', '1', '2023-04-26', '07:57:00', '0', '2023-04-26 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1756', '1', '4', '1', '2023-04-26', '08:00:00', '0', '2023-04-26 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1757', '1', '6', '1', '2023-04-26', '08:03:00', '0', '2023-04-26 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1758', '1', '6', '1', '2023-04-26', '08:06:00', '0', '2023-04-26 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1759', '1', '1', '1', '2023-04-26', '08:09:00', '0', '2023-04-26 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1760', '1', '6', '1', '2023-04-26', '08:12:00', '0', '2023-04-26 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1761', '1', '1', '1', '2023-04-26', '08:15:00', '0', '2023-04-26 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1762', '1', '2', '1', '2023-04-26', '08:18:00', '0', '2023-04-26 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1763', '1', '7', '1', '2023-04-26', '08:21:00', '0', '2023-04-26 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1764', '1', '5', '1', '2023-04-26', '08:24:00', '0', '2023-04-26 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1765', '1', '2', '1', '2023-04-26', '08:27:00', '0', '2023-04-26 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1766', '1', '1', '1', '2023-04-26', '08:30:00', '0', '2023-04-26 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1767', '1', '6', '1', '2023-04-26', '08:33:00', '0', '2023-04-26 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1768', '1', '0', '1', '2023-04-26', '08:36:00', '0', '2023-04-26 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1769', '1', '9', '1', '2023-04-26', '08:39:00', '0', '2023-04-26 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1770', '1', '0', '1', '2023-04-26', '08:42:00', '0', '2023-04-26 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1771', '1', '6', '1', '2023-04-26', '08:45:00', '0', '2023-04-26 08:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1772', '1', '9', '1', '2023-04-26', '08:48:00', '0', '2023-04-26 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1773', '1', '0', '1', '2023-04-26', '08:51:00', '0', '2023-04-26 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1774', '1', '7', '1', '2023-04-26', '08:54:00', '0', '2023-04-26 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1775', '1', '6', '1', '2023-04-26', '08:57:00', '0', '2023-04-26 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1776', '1', '3', '1', '2023-04-26', '09:00:00', '0', '2023-04-26 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1777', '1', '5', '1', '2023-04-26', '09:03:00', '0', '2023-04-26 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1778', '1', '4', '1', '2023-04-26', '09:06:00', '0', '2023-04-26 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1779', '1', '6', '1', '2023-04-26', '09:09:00', '0', '2023-04-26 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1780', '1', '4', '1', '2023-04-26', '09:12:00', '0', '2023-04-26 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1781', '1', '5', '1', '2023-04-26', '09:15:00', '0', '2023-04-26 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1782', '1', '3', '1', '2023-04-26', '09:18:00', '0', '2023-04-26 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1783', '1', '0', '1', '2023-04-26', '09:21:00', '0', '2023-04-26 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1784', '1', '3', '1', '2023-04-26', '09:24:00', '0', '2023-04-26 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1785', '1', '5', '1', '2023-04-26', '09:27:00', '0', '2023-04-26 09:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1786', '1', '7', '1', '2023-04-26', '09:30:00', '0', '2023-04-26 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1787', '1', '8', '1', '2023-04-26', '09:33:00', '0', '2023-04-26 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1788', '1', '3', '1', '2023-04-26', '09:36:00', '0', '2023-04-26 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1789', '1', '3', '1', '2023-04-26', '09:39:00', '0', '2023-04-26 09:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1790', '1', '3', '1', '2023-04-26', '09:42:00', '0', '2023-04-26 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1791', '1', '2', '1', '2023-04-26', '09:45:00', '0', '2023-04-26 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1792', '1', '6', '1', '2023-04-26', '09:54:00', '0', '2023-04-26 09:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('1793', '1', '2', '1', '2023-04-26', '09:57:00', '0', '2023-04-26 09:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2020', '1', '3', '1', '2023-04-27', '11:18:00', '0', '2023-04-27 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2021', '1', '7', '1', '2023-04-27', '11:21:00', '0', '2023-04-27 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2022', '1', '4', '1', '2023-04-27', '11:24:00', '0', '2023-04-27 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2023', '1', '0', '1', '2023-04-27', '11:27:00', '0', '2023-04-27 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2024', '1', '7', '1', '2023-04-27', '11:30:00', '0', '2023-04-27 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2025', '1', '2', '1', '2023-04-27', '11:33:00', '0', '2023-04-27 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2026', '1', '1', '1', '2023-04-27', '11:36:00', '0', '2023-04-27 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2027', '1', '5', '1', '2023-04-27', '11:39:00', '0', '2023-04-27 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2028', '1', '0', '1', '2023-04-27', '11:42:00', '0', '2023-04-27 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2029', '1', '8', '1', '2023-04-27', '11:45:00', '0', '2023-04-27 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2030', '1', '1', '1', '2023-04-27', '11:48:00', '0', '2023-04-27 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2031', '1', '6', '1', '2023-04-27', '11:51:00', '0', '2023-04-27 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2032', '1', '8', '1', '2023-04-27', '11:54:00', '0', '2023-04-27 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2033', '1', '1', '1', '2023-04-27', '11:57:00', '0', '2023-04-27 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2034', '1', '3', '1', '2023-04-27', '12:00:00', '0', '2023-04-27 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2035', '1', '7', '1', '2023-04-27', '12:03:00', '2', '2023-04-27 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2036', '1', '7', '1', '2023-04-27', '12:06:00', '0', '2023-04-27 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2037', '1', '4', '1', '2023-04-27', '12:09:00', '0', '2023-04-27 12:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2038', '1', '9', '1', '2023-04-27', '12:12:00', '0', '2023-04-27 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2039', '1', '5', '1', '2023-04-27', '12:15:00', '0', '2023-04-27 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2040', '1', '0', '1', '2023-04-27', '12:18:00', '0', '2023-04-27 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2041', '1', '3', '1', '2023-04-27', '12:21:00', '0', '2023-04-27 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2042', '1', '4', '1', '2023-04-27', '12:24:00', '0', '2023-04-27 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2043', '1', '2', '1', '2023-04-27', '12:27:00', '0', '2023-04-27 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2044', '1', '4', '1', '2023-04-27', '12:30:00', '0', '2023-04-27 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2045', '1', '0', '1', '2023-04-27', '12:33:00', '0', '2023-04-27 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2046', '1', '8', '1', '2023-04-27', '12:36:00', '0', '2023-04-27 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2047', '1', '5', '1', '2023-04-27', '12:39:00', '0', '2023-04-27 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2048', '1', '6', '1', '2023-04-27', '12:42:00', '0', '2023-04-27 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2049', '1', '4', '1', '2023-04-27', '12:45:00', '0', '2023-04-27 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2050', '1', '5', '1', '2023-04-27', '12:48:00', '0', '2023-04-27 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2051', '1', '9', '1', '2023-04-27', '12:51:00', '0', '2023-04-27 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2052', '1', '3', '1', '2023-04-27', '12:54:00', '0', '2023-04-27 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2053', '1', '5', '1', '2023-04-27', '12:57:00', '0', '2023-04-27 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2054', '1', '9', '1', '2023-04-27', '01:00:00', '4', '2023-04-27 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2055', '1', '0', '1', '2023-04-27', '01:03:00', '0', '2023-04-27 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2056', '1', '7', '1', '2023-04-27', '01:06:00', '0', '2023-04-27 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2057', '1', '7', '1', '2023-04-27', '01:09:00', '0', '2023-04-27 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2058', '1', '7', '1', '2023-04-27', '01:12:00', '0', '2023-04-27 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2059', '1', '1', '1', '2023-04-27', '01:15:00', '0', '2023-04-27 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2060', '1', '2', '1', '2023-04-27', '01:18:00', '0', '2023-04-27 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2061', '1', '0', '1', '2023-04-27', '01:21:00', '0', '2023-04-27 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2062', '1', '1', '1', '2023-04-27', '01:24:00', '0', '2023-04-27 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2063', '1', '8', '1', '2023-04-27', '01:27:00', '0', '2023-04-27 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2064', '1', '1', '1', '2023-04-27', '01:30:00', '0', '2023-04-27 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2065', '1', '1', '1', '2023-04-27', '01:33:00', '0', '2023-04-27 01:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2066', '1', '6', '1', '2023-04-27', '01:36:00', '0', '2023-04-27 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2067', '1', '7', '1', '2023-04-27', '01:39:00', '0', '2023-04-27 01:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2068', '1', '5', '1', '2023-04-27', '01:42:00', '0', '2023-04-27 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2069', '1', '1', '1', '2023-04-27', '01:45:00', '0', '2023-04-27 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2070', '1', '3', '1', '2023-04-27', '01:48:00', '0', '2023-04-27 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2071', '1', '4', '1', '2023-04-27', '01:51:00', '0', '2023-04-27 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2072', '1', '3', '1', '2023-04-27', '01:54:00', '0', '2023-04-27 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2073', '1', '9', '1', '2023-04-27', '01:57:00', '0', '2023-04-27 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2074', '1', '2', '1', '2023-04-27', '02:00:00', '0', '2023-04-27 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2075', '1', '2', '1', '2023-04-27', '02:03:00', '0', '2023-04-27 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2076', '1', '2', '1', '2023-04-27', '02:06:00', '0', '2023-04-27 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2077', '1', '9', '1', '2023-04-27', '02:09:00', '0', '2023-04-27 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2078', '1', '2', '1', '2023-04-27', '02:12:00', '0', '2023-04-27 02:12:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2079', '1', '7', '1', '2023-04-27', '02:15:00', '0', '2023-04-27 02:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2080', '1', '4', '1', '2023-04-27', '02:18:00', '0', '2023-04-27 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2081', '1', '3', '1', '2023-04-27', '02:21:00', '0', '2023-04-27 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2082', '1', '8', '1', '2023-04-27', '02:24:00', '0', '2023-04-27 02:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2083', '1', '9', '1', '2023-04-27', '02:27:00', '0', '2023-04-27 02:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2084', '1', '7', '1', '2023-04-27', '02:30:00', '0', '2023-04-27 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2085', '1', '8', '1', '2023-04-27', '02:33:00', '0', '2023-04-27 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2086', '1', '1', '1', '2023-04-27', '02:36:00', '0', '2023-04-27 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2087', '1', '4', '1', '2023-04-27', '02:39:00', '0', '2023-04-27 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2088', '1', '7', '1', '2023-04-27', '02:42:00', '0', '2023-04-27 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2089', '1', '0', '1', '2023-04-27', '02:45:00', '0', '2023-04-27 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2090', '1', '5', '1', '2023-04-27', '02:48:00', '0', '2023-04-27 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2091', '1', '6', '1', '2023-04-27', '02:51:00', '0', '2023-04-27 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2092', '1', '1', '1', '2023-04-27', '02:54:00', '0', '2023-04-27 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2093', '1', '9', '1', '2023-04-27', '02:57:00', '0', '2023-04-27 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2094', '1', '9', '1', '2023-04-27', '03:00:00', '0', '2023-04-27 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2095', '1', '7', '1', '2023-04-27', '03:03:00', '0', '2023-04-27 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2096', '1', '0', '1', '2023-04-27', '03:06:00', '0', '2023-04-27 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2097', '1', '6', '1', '2023-04-27', '03:09:00', '0', '2023-04-27 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2098', '1', '5', '1', '2023-04-27', '03:12:00', '0', '2023-04-27 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2099', '1', '2', '1', '2023-04-27', '03:15:00', '0', '2023-04-27 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2100', '1', '4', '1', '2023-04-27', '03:18:00', '0', '2023-04-27 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2101', '1', '7', '1', '2023-04-27', '03:21:00', '0', '2023-04-27 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2102', '1', '3', '1', '2023-04-27', '03:24:00', '0', '2023-04-27 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2103', '1', '9', '1', '2023-04-27', '03:27:00', '0', '2023-04-27 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2104', '1', '2', '1', '2023-04-27', '03:30:00', '0', '2023-04-27 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2105', '1', '6', '1', '2023-04-27', '03:33:00', '0', '2023-04-27 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2106', '1', '9', '1', '2023-04-27', '03:36:00', '0', '2023-04-27 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2107', '1', '8', '1', '2023-04-27', '03:39:00', '0', '2023-04-27 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2108', '1', '1', '1', '2023-04-27', '03:42:00', '0', '2023-04-27 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2109', '1', '9', '1', '2023-04-27', '03:45:00', '0', '2023-04-27 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2110', '1', '7', '1', '2023-04-27', '03:48:00', '0', '2023-04-27 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2111', '1', '8', '1', '2023-04-27', '03:51:00', '0', '2023-04-27 03:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2112', '1', '0', '1', '2023-04-27', '03:54:00', '0', '2023-04-27 03:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2113', '1', '4', '1', '2023-04-27', '03:57:00', '0', '2023-04-27 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2114', '1', '1', '1', '2023-04-27', '04:00:00', '0', '2023-04-27 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2115', '1', '2', '1', '2023-04-27', '04:03:00', '0', '2023-04-27 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2116', '1', '4', '1', '2023-04-27', '04:06:00', '0', '2023-04-27 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2117', '1', '4', '1', '2023-04-27', '04:09:00', '0', '2023-04-27 04:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2118', '1', '3', '1', '2023-04-27', '04:12:00', '0', '2023-04-27 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2119', '1', '6', '1', '2023-04-27', '04:15:00', '0', '2023-04-27 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2120', '1', '0', '1', '2023-04-27', '04:18:00', '0', '2023-04-27 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2121', '1', '7', '1', '2023-04-27', '04:21:00', '0', '2023-04-27 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2122', '1', '1', '1', '2023-04-27', '04:24:00', '0', '2023-04-27 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2123', '1', '7', '1', '2023-04-27', '04:27:00', '0', '2023-04-27 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2124', '1', '3', '1', '2023-04-27', '04:30:00', '0', '2023-04-27 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2125', '1', '2', '1', '2023-04-27', '04:33:00', '0', '2023-04-27 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2126', '1', '5', '1', '2023-04-27', '04:36:00', '0', '2023-04-27 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2127', '1', '4', '1', '2023-04-27', '04:39:00', '0', '2023-04-27 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2128', '1', '4', '1', '2023-04-27', '04:42:00', '0', '2023-04-27 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2129', '1', '2', '1', '2023-04-27', '04:45:00', '0', '2023-04-27 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2130', '1', '7', '1', '2023-04-27', '04:48:00', '0', '2023-04-27 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2131', '1', '3', '1', '2023-04-27', '04:51:00', '0', '2023-04-27 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2132', '1', '0', '1', '2023-04-27', '04:54:00', '0', '2023-04-27 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2133', '1', '5', '1', '2023-04-27', '04:57:00', '0', '2023-04-27 04:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2134', '1', '4', '1', '2023-04-27', '05:00:00', '0', '2023-04-27 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2135', '1', '7', '1', '2023-04-27', '05:03:00', '0', '2023-04-27 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2136', '1', '3', '1', '2023-04-27', '05:06:00', '0', '2023-04-27 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2137', '1', '0', '1', '2023-04-27', '05:09:00', '0', '2023-04-27 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2138', '1', '5', '1', '2023-04-27', '05:12:00', '0', '2023-04-27 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2139', '1', '8', '1', '2023-04-27', '05:15:00', '0', '2023-04-27 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2140', '1', '4', '1', '2023-04-27', '05:18:00', '0', '2023-04-27 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2141', '1', '0', '1', '2023-04-27', '05:21:00', '0', '2023-04-27 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2142', '1', '6', '1', '2023-04-27', '05:24:00', '0', '2023-04-27 05:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2143', '1', '7', '1', '2023-04-27', '05:27:00', '0', '2023-04-27 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2144', '1', '4', '1', '2023-04-27', '05:30:00', '0', '2023-04-27 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2145', '1', '6', '1', '2023-04-27', '05:33:00', '0', '2023-04-27 05:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2146', '1', '8', '1', '2023-04-27', '05:36:00', '0', '2023-04-27 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2147', '1', '0', '1', '2023-04-27', '05:39:00', '0', '2023-04-27 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2148', '1', '5', '1', '2023-04-27', '05:42:00', '0', '2023-04-27 05:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2149', '1', '6', '1', '2023-04-27', '05:45:00', '0', '2023-04-27 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2150', '1', '9', '1', '2023-04-27', '05:48:00', '0', '2023-04-27 05:48:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2151', '1', '6', '1', '2023-04-27', '05:51:00', '0', '2023-04-27 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2152', '1', '2', '1', '2023-04-27', '05:54:00', '4', '2023-04-27 05:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2153', '1', '9', '1', '2023-04-27', '05:57:00', '0', '2023-04-27 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2154', '1', '9', '1', '2023-04-27', '06:00:00', '0', '2023-04-27 06:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2155', '1', '6', '1', '2023-04-27', '06:03:00', '0', '2023-04-27 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2156', '1', '2', '1', '2023-04-27', '06:06:00', '0', '2023-04-27 06:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2157', '1', '9', '1', '2023-04-27', '06:09:00', '0', '2023-04-27 06:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2158', '1', '7', '1', '2023-04-27', '06:12:00', '0', '2023-04-27 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2159', '1', '3', '1', '2023-04-27', '06:15:00', '0', '2023-04-27 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2160', '1', '8', '1', '2023-04-27', '06:18:00', '0', '2023-04-27 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2161', '1', '8', '1', '2023-04-27', '06:21:00', '4', '2023-04-27 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2162', '1', '0', '1', '2023-04-27', '06:24:00', '0', '2023-04-27 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2163', '1', '2', '1', '2023-04-27', '06:27:00', '0', '2023-04-27 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2164', '1', '5', '1', '2023-04-27', '06:30:00', '0', '2023-04-27 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2165', '1', '6', '1', '2023-04-27', '06:33:00', '0', '2023-04-27 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2166', '1', '5', '1', '2023-04-27', '06:36:00', '4', '2023-04-27 06:36:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2167', '1', '3', '1', '2023-04-27', '06:39:00', '0', '2023-04-27 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2168', '1', '7', '1', '2023-04-27', '06:42:00', '0', '2023-04-27 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2169', '1', '0', '1', '2023-04-27', '06:45:00', '0', '2023-04-27 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2170', '1', '6', '1', '2023-04-27', '06:48:00', '0', '2023-04-27 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2171', '1', '4', '1', '2023-04-27', '06:51:00', '0', '2023-04-27 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2172', '1', '1', '1', '2023-04-27', '06:54:00', '0', '2023-04-27 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2173', '1', '9', '1', '2023-04-27', '06:57:00', '0', '2023-04-27 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2174', '1', '9', '1', '2023-04-27', '07:00:00', '0', '2023-04-27 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2175', '1', '6', '1', '2023-04-27', '07:03:00', '4', '2023-04-27 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2176', '1', '3', '1', '2023-04-27', '07:06:00', '0', '2023-04-27 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2177', '1', '6', '1', '2023-04-27', '07:09:00', '0', '2023-04-27 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2178', '1', '5', '1', '2023-04-27', '07:12:00', '0', '2023-04-27 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2179', '1', '8', '1', '2023-04-27', '07:15:00', '0', '2023-04-27 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2180', '1', '1', '1', '2023-04-27', '07:18:00', '0', '2023-04-27 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2181', '1', '0', '1', '2023-04-27', '07:21:00', '0', '2023-04-27 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2182', '1', '9', '1', '2023-04-27', '07:24:00', '0', '2023-04-27 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2183', '1', '8', '1', '2023-04-27', '07:27:00', '0', '2023-04-27 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2184', '1', '3', '1', '2023-04-27', '07:30:00', '0', '2023-04-27 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2185', '1', '4', '1', '2023-04-27', '07:33:00', '0', '2023-04-27 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2186', '1', '5', '1', '2023-04-27', '07:36:00', '0', '2023-04-27 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2187', '1', '1', '1', '2023-04-27', '07:39:00', '0', '2023-04-27 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2188', '1', '3', '1', '2023-04-27', '07:42:00', '4', '2023-04-27 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2189', '1', '3', '1', '2023-04-27', '07:45:00', '0', '2023-04-27 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2190', '1', '8', '1', '2023-04-27', '07:48:00', '0', '2023-04-27 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2191', '1', '3', '1', '2023-04-27', '07:51:00', '0', '2023-04-27 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2192', '1', '5', '1', '2023-04-27', '07:54:00', '0', '2023-04-27 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2193', '1', '8', '1', '2023-04-27', '07:57:00', '0', '2023-04-27 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2194', '1', '3', '1', '2023-04-27', '08:00:00', '0', '2023-04-27 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2195', '1', '8', '1', '2023-04-27', '08:03:00', '0', '2023-04-27 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2196', '1', '7', '1', '2023-04-27', '08:06:00', '0', '2023-04-27 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2197', '1', '3', '1', '2023-04-27', '08:09:00', '0', '2023-04-27 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2198', '1', '8', '1', '2023-04-27', '08:12:00', '0', '2023-04-27 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2199', '1', '5', '1', '2023-04-27', '08:15:00', '0', '2023-04-27 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2200', '1', '1', '1', '2023-04-27', '08:18:00', '0', '2023-04-27 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2201', '1', '1', '1', '2023-04-27', '08:21:00', '0', '2023-04-27 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2202', '1', '5', '1', '2023-04-27', '08:24:00', '0', '2023-04-27 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2203', '1', '5', '1', '2023-04-27', '08:27:00', '0', '2023-04-27 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2204', '1', '8', '1', '2023-04-27', '08:30:00', '0', '2023-04-27 08:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2205', '1', '0', '1', '2023-04-27', '08:33:00', '0', '2023-04-27 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2206', '1', '7', '1', '2023-04-27', '08:36:00', '0', '2023-04-27 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2207', '1', '6', '1', '2023-04-27', '08:39:00', '0', '2023-04-27 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2208', '1', '0', '1', '2023-04-27', '08:42:00', '0', '2023-04-27 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2209', '1', '7', '1', '2023-04-27', '08:45:00', '0', '2023-04-27 08:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2210', '1', '1', '1', '2023-04-27', '08:48:00', '0', '2023-04-27 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2211', '1', '3', '1', '2023-04-27', '08:51:00', '0', '2023-04-27 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2212', '1', '3', '1', '2023-04-27', '08:54:00', '0', '2023-04-27 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2213', '1', '1', '1', '2023-04-27', '08:57:00', '0', '2023-04-27 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2214', '1', '2', '1', '2023-04-27', '09:00:00', '0', '2023-04-27 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2215', '1', '4', '1', '2023-04-27', '09:03:00', '0', '2023-04-27 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2216', '1', '8', '1', '2023-04-27', '09:06:00', '0', '2023-04-27 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2217', '1', '4', '1', '2023-04-27', '09:09:00', '0', '2023-04-27 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2218', '1', '7', '1', '2023-04-27', '09:12:00', '0', '2023-04-27 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2219', '1', '9', '1', '2023-04-27', '09:15:00', '0', '2023-04-27 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2220', '1', '3', '1', '2023-04-27', '09:18:00', '0', '2023-04-27 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2221', '1', '6', '1', '2023-04-27', '09:21:00', '0', '2023-04-27 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2222', '1', '7', '1', '2023-04-27', '09:24:00', '0', '2023-04-27 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2223', '1', '7', '1', '2023-04-27', '09:27:00', '0', '2023-04-27 09:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2224', '1', '3', '1', '2023-04-27', '09:30:00', '0', '2023-04-27 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2225', '1', '7', '1', '2023-04-27', '09:33:00', '0', '2023-04-27 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2226', '1', '0', '1', '2023-04-27', '09:36:00', '0', '2023-04-27 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2227', '1', '1', '1', '2023-04-27', '09:39:00', '0', '2023-04-27 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2228', '1', '1', '1', '2023-04-27', '09:42:00', '0', '2023-04-27 09:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2229', '1', '9', '1', '2023-04-27', '09:45:00', '0', '2023-04-27 09:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2230', '1', '5', '1', '2023-04-27', '09:48:00', '0', '2023-04-27 09:48:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2231', '1', '4', '1', '2023-04-27', '09:51:00', '0', '2023-04-27 09:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2232', '1', '6', '1', '2023-04-27', '09:54:00', '0', '2023-04-27 09:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2233', '1', '9', '1', '2023-04-27', '09:57:00', '0', '2023-04-27 09:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2234', '1', '6', '1', '2023-04-27', '10:00:00', '0', '2023-04-27 10:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2235', '1', '0', '1', '2023-04-27', '10:03:00', '0', '2023-04-27 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2236', '1', '8', '1', '2023-04-27', '10:06:00', '0', '2023-04-27 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2237', '1', '8', '1', '2023-04-27', '10:09:00', '0', '2023-04-27 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2238', '1', '8', '1', '2023-04-27', '10:12:00', '0', '2023-04-27 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2239', '1', '0', '1', '2023-04-27', '10:15:00', '0', '2023-04-27 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2240', '1', '5', '1', '2023-04-27', '10:18:00', '0', '2023-04-27 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2241', '1', '6', '1', '2023-04-27', '10:21:00', '0', '2023-04-27 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2242', '1', '6', '1', '2023-04-27', '10:24:00', '0', '2023-04-27 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2243', '1', '1', '1', '2023-04-27', '10:27:00', '0', '2023-04-27 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2244', '1', '3', '1', '2023-04-27', '10:30:00', '0', '2023-04-27 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2245', '1', '8', '1', '2023-04-27', '10:33:00', '0', '2023-04-27 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2246', '1', '9', '1', '2023-04-27', '10:36:00', '0', '2023-04-27 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2247', '1', '4', '1', '2023-04-27', '10:39:00', '0', '2023-04-27 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2248', '1', '8', '1', '2023-04-27', '10:42:00', '0', '2023-04-27 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2249', '1', '4', '1', '2023-04-27', '10:45:00', '0', '2023-04-27 10:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2250', '1', '9', '1', '2023-04-27', '10:48:00', '0', '2023-04-27 10:48:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2251', '1', '4', '1', '2023-04-27', '10:51:00', '0', '2023-04-27 10:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2252', '1', '6', '1', '2023-04-27', '10:54:00', '0', '2023-04-27 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2253', '1', '2', '1', '2023-04-27', '10:57:00', '0', '2023-04-27 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2254', '1', '0', '1', '2023-04-27', '11:00:00', '0', '2023-04-27 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2255', '1', '3', '1', '2023-04-27', '11:03:00', '0', '2023-04-27 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2256', '1', '8', '1', '2023-04-27', '11:06:00', '0', '2023-04-27 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2257', '1', '5', '1', '2023-04-27', '11:09:00', '0', '2023-04-27 11:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2258', '1', '2', '1', '2023-04-27', '11:12:00', '0', '2023-04-27 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2259', '1', '0', '1', '2023-04-27', '11:15:00', '0', '2023-04-27 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2406', '1', '7', '1', '2023-04-28', '10:00:00', '0', '2023-04-28 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2407', '1', '3', '1', '2023-04-28', '10:03:00', '0', '2023-04-28 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2408', '1', '6', '1', '2023-04-28', '10:06:00', '0', '2023-04-28 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2409', '1', '9', '1', '2023-04-28', '10:09:00', '0', '2023-04-28 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2410', '1', '6', '1', '2023-04-28', '10:12:00', '0', '2023-04-28 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2411', '1', '6', '1', '2023-04-28', '10:15:00', '0', '2023-04-28 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2412', '1', '6', '1', '2023-04-28', '10:18:00', '0', '2023-04-28 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2413', '1', '9', '1', '2023-04-28', '10:21:00', '0', '2023-04-28 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2414', '1', '1', '1', '2023-04-28', '10:24:00', '0', '2023-04-28 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2415', '1', '8', '1', '2023-04-28', '10:27:00', '0', '2023-04-28 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2416', '1', '7', '1', '2023-04-28', '10:30:00', '0', '2023-04-28 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2417', '1', '6', '1', '2023-04-28', '10:33:00', '0', '2023-04-28 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2418', '1', '4', '1', '2023-04-28', '10:36:00', '0', '2023-04-28 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2419', '1', '9', '1', '2023-04-28', '10:39:00', '0', '2023-04-28 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2420', '1', '9', '1', '2023-04-28', '10:42:00', '0', '2023-04-28 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2421', '1', '7', '1', '2023-04-28', '10:45:00', '0', '2023-04-28 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2422', '1', '1', '1', '2023-04-28', '10:48:00', '0', '2023-04-28 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2423', '1', '3', '1', '2023-04-28', '10:51:00', '0', '2023-04-28 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2424', '1', '1', '1', '2023-04-28', '10:54:00', '0', '2023-04-28 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2425', '1', '2', '1', '2023-04-28', '10:57:00', '0', '2023-04-28 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2426', '1', '3', '1', '2023-04-28', '11:00:00', '0', '2023-04-28 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2427', '1', '6', '1', '2023-04-28', '11:03:00', '0', '2023-04-28 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2428', '1', '6', '1', '2023-04-28', '11:06:00', '0', '2023-04-28 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2429', '1', '5', '1', '2023-04-28', '11:09:00', '0', '2023-04-28 11:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2430', '1', '6', '1', '2023-04-28', '11:12:00', '0', '2023-04-28 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2431', '1', '9', '1', '2023-04-28', '11:15:00', '0', '2023-04-28 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2432', '1', '8', '1', '2023-04-28', '11:18:00', '0', '2023-04-28 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2433', '1', '1', '1', '2023-04-28', '11:21:00', '0', '2023-04-28 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2434', '1', '5', '1', '2023-04-28', '11:24:00', '0', '2023-04-28 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2435', '1', '0', '1', '2023-04-28', '11:27:00', '0', '2023-04-28 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2436', '1', '3', '1', '2023-04-28', '11:30:00', '0', '2023-04-28 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2437', '1', '6', '1', '2023-04-28', '11:33:00', '0', '2023-04-28 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2438', '1', '3', '1', '2023-04-28', '11:36:00', '0', '2023-04-28 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2439', '1', '8', '1', '2023-04-28', '11:39:00', '0', '2023-04-28 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2440', '1', '2', '1', '2023-04-28', '11:42:00', '0', '2023-04-28 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2441', '1', '2', '1', '2023-04-28', '11:45:00', '0', '2023-04-28 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2442', '1', '8', '1', '2023-04-28', '11:48:00', '0', '2023-04-28 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2443', '1', '9', '1', '2023-04-28', '11:51:00', '0', '2023-04-28 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2444', '1', '6', '1', '2023-04-28', '11:54:00', '0', '2023-04-28 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2445', '1', '0', '1', '2023-04-28', '11:57:00', '0', '2023-04-28 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2446', '1', '3', '1', '2023-04-28', '12:00:00', '0', '2023-04-28 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2447', '1', '7', '1', '2023-04-28', '12:03:00', '0', '2023-04-28 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2448', '1', '9', '1', '2023-04-28', '12:06:00', '0', '2023-04-28 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2449', '1', '3', '1', '2023-04-28', '12:09:00', '0', '2023-04-28 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2450', '1', '7', '1', '2023-04-28', '12:12:00', '0', '2023-04-28 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2451', '1', '0', '1', '2023-04-28', '12:15:00', '0', '2023-04-28 12:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2452', '1', '3', '1', '2023-04-28', '12:18:00', '0', '2023-04-28 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2453', '1', '3', '1', '2023-04-28', '12:21:00', '0', '2023-04-28 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2454', '1', '8', '1', '2023-04-28', '12:24:00', '0', '2023-04-28 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2455', '1', '8', '1', '2023-04-28', '12:27:00', '0', '2023-04-28 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2456', '1', '8', '1', '2023-04-28', '12:30:00', '0', '2023-04-28 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2457', '1', '3', '1', '2023-04-28', '12:33:00', '0', '2023-04-28 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2458', '1', '6', '1', '2023-04-28', '12:36:00', '0', '2023-04-28 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2459', '1', '9', '1', '2023-04-28', '12:39:00', '0', '2023-04-28 12:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2460', '1', '9', '1', '2023-04-28', '12:42:00', '0', '2023-04-28 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2461', '1', '1', '1', '2023-04-28', '12:45:00', '0', '2023-04-28 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2462', '1', '4', '1', '2023-04-28', '12:48:00', '0', '2023-04-28 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2463', '1', '6', '1', '2023-04-28', '12:51:00', '0', '2023-04-28 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2464', '1', '4', '1', '2023-04-28', '12:54:00', '0', '2023-04-28 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2465', '1', '3', '1', '2023-04-28', '12:57:00', '0', '2023-04-28 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2466', '1', '4', '1', '2023-04-28', '01:00:00', '0', '2023-04-28 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2467', '1', '1', '1', '2023-04-28', '01:03:00', '0', '2023-04-28 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2468', '1', '3', '1', '2023-04-28', '01:06:00', '0', '2023-04-28 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2469', '1', '6', '1', '2023-04-28', '01:09:00', '0', '2023-04-28 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2470', '1', '0', '1', '2023-04-28', '01:12:00', '0', '2023-04-28 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2471', '1', '8', '1', '2023-04-28', '01:15:00', '0', '2023-04-28 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2472', '1', '8', '1', '2023-04-28', '01:18:00', '0', '2023-04-28 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2473', '1', '0', '1', '2023-04-28', '01:21:00', '0', '2023-04-28 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2474', '1', '1', '1', '2023-04-28', '01:24:00', '0', '2023-04-28 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2475', '1', '3', '1', '2023-04-28', '01:27:00', '0', '2023-04-28 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2476', '1', '1', '1', '2023-04-28', '01:30:00', '0', '2023-04-28 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2477', '1', '5', '1', '2023-04-28', '01:33:00', '0', '2023-04-28 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2478', '1', '4', '1', '2023-04-28', '01:36:00', '0', '2023-04-28 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2479', '1', '1', '1', '2023-04-28', '01:39:00', '0', '2023-04-28 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2480', '1', '9', '1', '2023-04-28', '01:42:00', '0', '2023-04-28 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2481', '1', '8', '1', '2023-04-28', '01:45:00', '0', '2023-04-28 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2482', '1', '5', '1', '2023-04-28', '01:48:00', '0', '2023-04-28 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2483', '1', '5', '1', '2023-04-28', '01:51:00', '0', '2023-04-28 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2484', '1', '7', '1', '2023-04-28', '01:54:00', '0', '2023-04-28 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2485', '1', '5', '1', '2023-04-28', '01:57:00', '0', '2023-04-28 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2486', '1', '1', '1', '2023-04-28', '02:00:00', '0', '2023-04-28 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2487', '1', '9', '1', '2023-04-28', '02:03:00', '0', '2023-04-28 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2488', '1', '3', '1', '2023-04-28', '02:06:00', '0', '2023-04-28 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2489', '1', '4', '1', '2023-04-28', '02:09:00', '0', '2023-04-28 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2490', '1', '2', '1', '2023-04-28', '02:12:00', '0', '2023-04-28 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2491', '1', '2', '1', '2023-04-28', '02:15:00', '0', '2023-04-28 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2492', '1', '0', '1', '2023-04-28', '02:18:00', '0', '2023-04-28 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2493', '1', '5', '1', '2023-04-28', '02:21:00', '0', '2023-04-28 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2494', '1', '6', '1', '2023-04-28', '02:24:00', '0', '2023-04-28 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2495', '1', '0', '1', '2023-04-28', '02:27:00', '0', '2023-04-28 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2496', '1', '5', '1', '2023-04-28', '02:30:00', '0', '2023-04-28 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2497', '1', '7', '1', '2023-04-28', '02:33:00', '0', '2023-04-28 02:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2498', '1', '8', '1', '2023-04-28', '02:36:00', '0', '2023-04-28 02:36:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2499', '1', '8', '1', '2023-04-28', '02:39:00', '0', '2023-04-28 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2500', '1', '2', '1', '2023-04-28', '02:42:00', '0', '2023-04-28 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2501', '1', '6', '1', '2023-04-28', '02:45:00', '0', '2023-04-28 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2502', '1', '3', '1', '2023-04-28', '02:48:00', '0', '2023-04-28 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2503', '1', '5', '1', '2023-04-28', '02:51:00', '0', '2023-04-28 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2504', '1', '3', '1', '2023-04-28', '02:54:00', '0', '2023-04-28 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2505', '1', '8', '1', '2023-04-28', '02:57:00', '0', '2023-04-28 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2506', '1', '4', '1', '2023-04-28', '03:00:00', '0', '2023-04-28 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2507', '1', '8', '1', '2023-04-28', '03:03:00', '0', '2023-04-28 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2508', '1', '1', '1', '2023-04-28', '03:06:00', '0', '2023-04-28 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2509', '1', '0', '1', '2023-04-28', '03:09:00', '0', '2023-04-28 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2510', '1', '6', '1', '2023-04-28', '03:12:00', '0', '2023-04-28 03:12:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2511', '1', '3', '1', '2023-04-28', '03:15:00', '0', '2023-04-28 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2512', '1', '1', '1', '2023-04-28', '03:18:00', '0', '2023-04-28 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2513', '1', '0', '1', '2023-04-28', '03:21:00', '0', '2023-04-28 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2514', '1', '1', '1', '2023-04-28', '03:24:00', '0', '2023-04-28 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2515', '1', '4', '1', '2023-04-28', '03:27:00', '0', '2023-04-28 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2516', '1', '6', '1', '2023-04-28', '03:30:00', '0', '2023-04-28 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2517', '1', '6', '1', '2023-04-28', '03:33:00', '0', '2023-04-28 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2518', '1', '4', '1', '2023-04-28', '03:36:00', '0', '2023-04-28 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2519', '1', '7', '1', '2023-04-28', '03:39:00', '0', '2023-04-28 03:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2520', '1', '4', '1', '2023-04-28', '03:42:00', '0', '2023-04-28 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2521', '1', '0', '1', '2023-04-28', '03:45:00', '0', '2023-04-28 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2522', '1', '6', '1', '2023-04-28', '03:48:00', '0', '2023-04-28 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2523', '1', '7', '1', '2023-04-28', '03:51:00', '0', '2023-04-28 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2524', '1', '0', '1', '2023-04-28', '03:54:00', '0', '2023-04-28 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2525', '1', '7', '1', '2023-04-28', '03:57:00', '4', '2023-04-28 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2526', '1', '6', '1', '2023-04-28', '04:00:00', '3', '2023-04-28 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2527', '1', '5', '1', '2023-04-28', '04:03:00', '2', '2023-04-28 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2528', '1', '7', '1', '2023-04-28', '04:06:00', '0', '2023-04-28 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2529', '1', '6', '1', '2023-04-28', '04:09:00', '0', '2023-04-28 04:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2530', '1', '0', '1', '2023-04-28', '04:12:00', '0', '2023-04-28 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2531', '1', '8', '1', '2023-04-28', '04:15:00', '0', '2023-04-28 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2532', '1', '7', '1', '2023-04-28', '04:18:00', '0', '2023-04-28 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2533', '1', '4', '1', '2023-04-28', '04:21:00', '0', '2023-04-28 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2534', '1', '2', '1', '2023-04-28', '04:24:00', '0', '2023-04-28 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2535', '1', '8', '1', '2023-04-28', '04:27:00', '0', '2023-04-28 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2536', '1', '4', '1', '2023-04-28', '04:30:00', '0', '2023-04-28 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2537', '1', '0', '1', '2023-04-28', '04:33:00', '0', '2023-04-28 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2538', '1', '9', '1', '2023-04-28', '04:36:00', '0', '2023-04-28 04:36:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2539', '1', '3', '1', '2023-04-28', '04:39:00', '0', '2023-04-28 04:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2540', '1', '5', '1', '2023-04-28', '04:42:00', '0', '2023-04-28 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2541', '1', '1', '1', '2023-04-28', '04:45:00', '0', '2023-04-28 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2542', '1', '1', '1', '2023-04-28', '04:48:00', '0', '2023-04-28 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2543', '1', '4', '1', '2023-04-28', '04:51:00', '0', '2023-04-28 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2544', '1', '7', '1', '2023-04-28', '04:54:00', '0', '2023-04-28 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2545', '1', '7', '1', '2023-04-28', '04:57:00', '0', '2023-04-28 04:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2546', '1', '8', '1', '2023-04-28', '05:00:00', '0', '2023-04-28 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2547', '1', '5', '1', '2023-04-28', '05:03:00', '0', '2023-04-28 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2548', '1', '3', '1', '2023-04-28', '05:06:00', '0', '2023-04-28 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2549', '1', '1', '1', '2023-04-28', '05:09:00', '0', '2023-04-28 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2550', '1', '1', '1', '2023-04-28', '05:12:00', '0', '2023-04-28 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2551', '1', '4', '1', '2023-04-28', '05:15:00', '0', '2023-04-28 05:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2552', '1', '0', '1', '2023-04-28', '05:18:00', '0', '2023-04-28 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2553', '1', '8', '1', '2023-04-28', '05:21:00', '0', '2023-04-28 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2554', '1', '1', '1', '2023-04-28', '05:24:00', '0', '2023-04-28 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2555', '1', '7', '1', '2023-04-28', '05:27:00', '0', '2023-04-28 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2556', '1', '7', '1', '2023-04-28', '05:30:00', '0', '2023-04-28 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2557', '1', '0', '1', '2023-04-28', '05:33:00', '0', '2023-04-28 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2558', '1', '7', '1', '2023-04-28', '05:36:00', '0', '2023-04-28 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2559', '1', '0', '1', '2023-04-28', '05:39:00', '0', '2023-04-28 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2560', '1', '8', '1', '2023-04-28', '05:42:00', '0', '2023-04-28 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2561', '1', '2', '1', '2023-04-28', '05:45:00', '0', '2023-04-28 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2562', '1', '7', '1', '2023-04-28', '05:48:00', '0', '2023-04-28 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2563', '1', '2', '1', '2023-04-28', '05:51:00', '0', '2023-04-28 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2564', '1', '0', '1', '2023-04-28', '05:54:00', '4', '2023-04-28 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2565', '1', '6', '1', '2023-04-28', '05:57:00', '0', '2023-04-28 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2566', '1', '8', '1', '2023-04-28', '06:00:00', '0', '2023-04-28 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2567', '1', '2', '1', '2023-04-28', '06:03:00', '0', '2023-04-28 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2568', '1', '3', '1', '2023-04-28', '06:06:00', '0', '2023-04-28 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2569', '1', '0', '1', '2023-04-28', '06:09:00', '0', '2023-04-28 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2570', '1', '9', '1', '2023-04-28', '06:12:00', '0', '2023-04-28 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2571', '1', '1', '1', '2023-04-28', '06:15:00', '0', '2023-04-28 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2572', '1', '9', '1', '2023-04-28', '06:18:00', '0', '2023-04-28 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2573', '1', '5', '1', '2023-04-28', '06:21:00', '4', '2023-04-28 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2574', '1', '4', '1', '2023-04-28', '06:24:00', '0', '2023-04-28 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2575', '1', '3', '1', '2023-04-28', '06:27:00', '0', '2023-04-28 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2576', '1', '6', '1', '2023-04-28', '06:30:00', '0', '2023-04-28 06:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2577', '1', '3', '1', '2023-04-28', '06:33:00', '0', '2023-04-28 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2578', '1', '7', '1', '2023-04-28', '06:36:00', '4', '2023-04-28 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2579', '1', '0', '1', '2023-04-28', '06:39:00', '0', '2023-04-28 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2580', '1', '2', '1', '2023-04-28', '06:42:00', '0', '2023-04-28 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2581', '1', '9', '1', '2023-04-28', '06:45:00', '0', '2023-04-28 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2582', '1', '3', '1', '2023-04-28', '06:48:00', '0', '2023-04-28 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2583', '1', '1', '1', '2023-04-28', '06:51:00', '0', '2023-04-28 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2584', '1', '5', '1', '2023-04-28', '06:54:00', '0', '2023-04-28 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2585', '1', '0', '1', '2023-04-28', '06:57:00', '0', '2023-04-28 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2586', '1', '3', '1', '2023-04-28', '07:00:00', '0', '2023-04-28 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2587', '1', '2', '1', '2023-04-28', '07:03:00', '0', '2023-04-28 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2588', '1', '1', '1', '2023-04-28', '07:06:00', '0', '2023-04-28 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2589', '1', '0', '1', '2023-04-28', '07:09:00', '3', '2023-04-28 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2590', '1', '0', '1', '2023-04-28', '07:12:00', '0', '2023-04-28 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2591', '1', '6', '1', '2023-04-28', '07:15:00', '0', '2023-04-28 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2592', '1', '2', '1', '2023-04-28', '07:18:00', '0', '2023-04-28 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2593', '1', '6', '1', '2023-04-28', '07:21:00', '0', '2023-04-28 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2594', '1', '6', '1', '2023-04-28', '07:24:00', '0', '2023-04-28 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2595', '1', '2', '1', '2023-04-28', '07:27:00', '0', '2023-04-28 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2596', '1', '7', '1', '2023-04-28', '07:30:00', '0', '2023-04-28 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2597', '1', '9', '1', '2023-04-28', '07:33:00', '0', '2023-04-28 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2598', '1', '7', '1', '2023-04-28', '07:36:00', '0', '2023-04-28 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2599', '1', '5', '1', '2023-04-28', '07:39:00', '0', '2023-04-28 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2600', '1', '2', '1', '2023-04-28', '07:42:00', '0', '2023-04-28 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2601', '1', '8', '1', '2023-04-28', '07:45:00', '0', '2023-04-28 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2602', '1', '3', '1', '2023-04-28', '07:48:00', '0', '2023-04-28 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2603', '1', '5', '1', '2023-04-28', '07:51:00', '0', '2023-04-28 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2604', '1', '7', '1', '2023-04-28', '07:54:00', '0', '2023-04-28 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2605', '1', '4', '1', '2023-04-28', '07:57:00', '0', '2023-04-28 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2606', '1', '4', '1', '2023-04-28', '08:00:00', '0', '2023-04-28 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2607', '1', '9', '1', '2023-04-28', '08:03:00', '0', '2023-04-28 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2608', '1', '4', '1', '2023-04-28', '08:06:00', '0', '2023-04-28 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2609', '1', '4', '1', '2023-04-28', '08:09:00', '0', '2023-04-28 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2610', '1', '0', '1', '2023-04-28', '08:12:00', '0', '2023-04-28 08:12:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2611', '1', '0', '1', '2023-04-28', '08:15:00', '0', '2023-04-28 08:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2612', '1', '3', '1', '2023-04-28', '08:18:00', '0', '2023-04-28 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2613', '1', '4', '1', '2023-04-28', '08:21:00', '0', '2023-04-28 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2614', '1', '9', '1', '2023-04-28', '08:24:00', '0', '2023-04-28 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2615', '1', '3', '1', '2023-04-28', '08:27:00', '0', '2023-04-28 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2616', '1', '6', '1', '2023-04-28', '08:30:00', '0', '2023-04-28 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2617', '1', '9', '1', '2023-04-28', '08:33:00', '0', '2023-04-28 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2618', '1', '1', '1', '2023-04-28', '08:36:00', '0', '2023-04-28 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2619', '1', '1', '1', '2023-04-28', '08:39:00', '0', '2023-04-28 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2620', '1', '3', '1', '2023-04-28', '08:42:00', '0', '2023-04-28 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2621', '1', '2', '1', '2023-04-28', '08:45:00', '0', '2023-04-28 08:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2622', '1', '4', '1', '2023-04-28', '08:48:00', '0', '2023-04-28 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2623', '1', '5', '1', '2023-04-28', '08:51:00', '0', '2023-04-28 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2624', '1', '6', '1', '2023-04-28', '08:54:00', '0', '2023-04-28 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2625', '1', '7', '1', '2023-04-28', '08:57:00', '0', '2023-04-28 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2626', '1', '8', '1', '2023-04-28', '09:00:00', '0', '2023-04-28 09:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2627', '1', '9', '1', '2023-04-28', '09:03:00', '0', '2023-04-28 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2628', '1', '0', '1', '2023-04-28', '09:06:00', '0', '2023-04-28 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2629', '1', '5', '1', '2023-04-28', '09:09:00', '0', '2023-04-28 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2630', '1', '0', '1', '2023-04-28', '09:12:00', '0', '2023-04-28 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2631', '1', '4', '1', '2023-04-28', '09:15:00', '0', '2023-04-28 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2632', '1', '4', '1', '2023-04-28', '09:18:00', '0', '2023-04-28 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2633', '1', '6', '1', '2023-04-28', '09:21:00', '0', '2023-04-28 09:21:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2634', '1', '6', '1', '2023-04-28', '09:24:00', '0', '2023-04-28 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2635', '1', '3', '1', '2023-04-28', '09:27:00', '0', '2023-04-28 09:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2636', '1', '4', '1', '2023-04-28', '09:30:00', '0', '2023-04-28 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2637', '1', '9', '1', '2023-04-28', '09:33:00', '0', '2023-04-28 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2638', '1', '9', '1', '2023-04-28', '09:36:00', '0', '2023-04-28 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2639', '1', '7', '1', '2023-04-28', '09:39:00', '0', '2023-04-28 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2640', '1', '2', '1', '2023-04-28', '09:42:00', '0', '2023-04-28 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2641', '1', '0', '1', '2023-04-28', '09:45:00', '0', '2023-04-28 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2642', '1', '2', '1', '2023-04-29', '10:00:00', '0', '2023-04-29 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2643', '1', '7', '1', '2023-04-29', '10:03:00', '0', '2023-04-29 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2644', '1', '3', '1', '2023-04-29', '10:06:00', '0', '2023-04-29 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2645', '1', '0', '1', '2023-04-29', '10:09:00', '0', '2023-04-29 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2646', '1', '1', '1', '2023-04-29', '10:12:00', '0', '2023-04-29 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2647', '1', '8', '1', '2023-04-29', '10:15:00', '0', '2023-04-29 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2648', '1', '8', '1', '2023-04-29', '10:18:00', '0', '2023-04-29 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2649', '1', '6', '1', '2023-04-29', '10:21:00', '0', '2023-04-29 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2650', '1', '9', '1', '2023-04-29', '10:24:00', '0', '2023-04-29 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2651', '1', '4', '1', '2023-04-29', '10:27:00', '0', '2023-04-29 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2652', '1', '3', '1', '2023-04-29', '10:30:00', '0', '2023-04-29 10:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2653', '1', '4', '1', '2023-04-29', '10:33:00', '0', '2023-04-29 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2654', '1', '3', '1', '2023-04-29', '10:36:00', '0', '2023-04-29 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2655', '1', '7', '1', '2023-04-29', '10:39:00', '0', '2023-04-29 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2656', '1', '5', '1', '2023-04-29', '10:42:00', '0', '2023-04-29 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2657', '1', '4', '1', '2023-04-29', '10:45:00', '0', '2023-04-29 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2658', '1', '1', '1', '2023-04-29', '10:48:00', '0', '2023-04-29 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2659', '1', '2', '1', '2023-04-29', '10:51:00', '0', '2023-04-29 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2660', '1', '3', '1', '2023-04-29', '10:54:00', '0', '2023-04-29 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2661', '1', '9', '1', '2023-04-29', '10:57:00', '0', '2023-04-29 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2662', '1', '9', '1', '2023-04-29', '11:00:00', '0', '2023-04-29 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2663', '1', '8', '1', '2023-04-29', '11:03:00', '0', '2023-04-29 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2664', '1', '8', '1', '2023-04-29', '11:06:00', '0', '2023-04-29 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2665', '1', '0', '1', '2023-04-29', '11:09:00', '0', '2023-04-29 11:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2666', '1', '8', '1', '2023-04-29', '11:12:00', '0', '2023-04-29 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2667', '1', '2', '1', '2023-04-29', '11:15:00', '0', '2023-04-29 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2668', '1', '1', '1', '2023-04-29', '11:18:00', '0', '2023-04-29 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2669', '1', '0', '1', '2023-04-29', '11:21:00', '0', '2023-04-29 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2670', '1', '9', '1', '2023-04-29', '11:24:00', '0', '2023-04-29 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2671', '1', '9', '1', '2023-04-29', '11:27:00', '0', '2023-04-29 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2672', '1', '2', '1', '2023-04-29', '11:30:00', '0', '2023-04-29 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2673', '1', '9', '1', '2023-04-29', '11:33:00', '0', '2023-04-29 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2674', '1', '6', '1', '2023-04-29', '11:36:00', '0', '2023-04-29 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2675', '1', '5', '1', '2023-04-29', '11:39:00', '0', '2023-04-29 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2676', '1', '5', '1', '2023-04-29', '11:42:00', '0', '2023-04-29 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2677', '1', '1', '1', '2023-04-29', '11:45:00', '0', '2023-04-29 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2678', '1', '6', '1', '2023-04-29', '11:48:00', '0', '2023-04-29 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2679', '1', '0', '1', '2023-04-29', '11:51:00', '0', '2023-04-29 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2680', '1', '3', '1', '2023-04-29', '11:54:00', '0', '2023-04-29 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2681', '1', '1', '1', '2023-04-29', '11:57:00', '0', '2023-04-29 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2682', '1', '7', '1', '2023-04-29', '12:00:00', '0', '2023-04-29 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2683', '1', '7', '1', '2023-04-29', '12:03:00', '0', '2023-04-29 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2684', '1', '5', '1', '2023-04-29', '12:06:00', '0', '2023-04-29 12:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2685', '1', '7', '1', '2023-04-29', '12:09:00', '0', '2023-04-29 12:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2686', '1', '9', '1', '2023-04-29', '12:12:00', '0', '2023-04-29 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2687', '1', '1', '1', '2023-04-29', '12:15:00', '0', '2023-04-29 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2688', '1', '9', '1', '2023-04-29', '12:18:00', '0', '2023-04-29 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2689', '1', '8', '1', '2023-04-29', '12:21:00', '0', '2023-04-29 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2690', '1', '1', '1', '2023-04-29', '12:24:00', '2', '2023-04-29 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2691', '1', '4', '1', '2023-04-29', '12:27:00', '0', '2023-04-29 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2692', '1', '0', '1', '2023-04-29', '12:30:00', '0', '2023-04-29 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2693', '1', '6', '1', '2023-04-29', '12:33:00', '0', '2023-04-29 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2694', '1', '1', '1', '2023-04-29', '12:36:00', '0', '2023-04-29 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2695', '1', '2', '1', '2023-04-29', '12:39:00', '0', '2023-04-29 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2696', '1', '1', '1', '2023-04-29', '12:42:00', '0', '2023-04-29 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2697', '1', '4', '1', '2023-04-29', '12:45:00', '0', '2023-04-29 12:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2698', '1', '1', '1', '2023-04-29', '12:48:00', '0', '2023-04-29 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2699', '1', '2', '1', '2023-04-29', '12:51:00', '0', '2023-04-29 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2700', '1', '7', '1', '2023-04-29', '12:54:00', '0', '2023-04-29 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2701', '1', '4', '1', '2023-04-29', '12:57:00', '0', '2023-04-29 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2702', '1', '7', '1', '2023-04-29', '01:00:00', '0', '2023-04-29 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2703', '1', '1', '1', '2023-04-29', '01:03:00', '0', '2023-04-29 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2704', '1', '2', '1', '2023-04-29', '01:06:00', '3', '2023-04-29 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2705', '1', '4', '1', '2023-04-29', '01:09:00', '0', '2023-04-29 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2706', '1', '2', '1', '2023-04-29', '01:12:00', '0', '2023-04-29 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2707', '1', '4', '1', '2023-04-29', '01:15:00', '0', '2023-04-29 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2708', '1', '3', '1', '2023-04-29', '01:18:00', '0', '2023-04-29 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2709', '1', '5', '1', '2023-04-29', '01:21:00', '0', '2023-04-29 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2710', '1', '1', '1', '2023-04-29', '01:24:00', '0', '2023-04-29 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2711', '1', '6', '1', '2023-04-29', '01:27:00', '0', '2023-04-29 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2712', '1', '2', '1', '2023-04-29', '01:30:00', '0', '2023-04-29 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2713', '1', '1', '1', '2023-04-29', '01:33:00', '0', '2023-04-29 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2714', '1', '6', '1', '2023-04-29', '01:36:00', '0', '2023-04-29 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2715', '1', '7', '1', '2023-04-29', '01:39:00', '0', '2023-04-29 01:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2716', '1', '6', '1', '2023-04-29', '01:42:00', '0', '2023-04-29 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2717', '1', '6', '1', '2023-04-29', '01:45:00', '0', '2023-04-29 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2718', '1', '6', '1', '2023-04-29', '01:48:00', '0', '2023-04-29 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2719', '1', '8', '1', '2023-04-29', '01:51:00', '0', '2023-04-29 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2720', '1', '4', '1', '2023-04-29', '01:54:00', '0', '2023-04-29 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2721', '1', '8', '1', '2023-04-29', '01:57:00', '0', '2023-04-29 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2722', '1', '6', '1', '2023-04-29', '02:00:00', '0', '2023-04-29 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2723', '1', '6', '1', '2023-04-29', '02:03:00', '0', '2023-04-29 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2724', '1', '3', '1', '2023-04-29', '02:06:00', '0', '2023-04-29 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2725', '1', '2', '1', '2023-04-29', '02:09:00', '0', '2023-04-29 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2726', '1', '6', '1', '2023-04-29', '02:12:00', '0', '2023-04-29 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2727', '1', '6', '1', '2023-04-29', '02:15:00', '0', '2023-04-29 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2728', '1', '0', '1', '2023-04-29', '02:18:00', '0', '2023-04-29 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2729', '1', '4', '1', '2023-04-29', '02:21:00', '0', '2023-04-29 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2730', '1', '9', '1', '2023-04-29', '02:24:00', '0', '2023-04-29 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2731', '1', '9', '1', '2023-04-29', '02:27:00', '0', '2023-04-29 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2732', '1', '5', '1', '2023-04-29', '02:30:00', '0', '2023-04-29 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2733', '1', '0', '1', '2023-04-29', '02:33:00', '0', '2023-04-29 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2734', '1', '8', '1', '2023-04-29', '02:36:00', '0', '2023-04-29 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2735', '1', '5', '1', '2023-04-29', '02:39:00', '0', '2023-04-29 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2736', '1', '1', '1', '2023-04-29', '02:42:00', '0', '2023-04-29 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2737', '1', '5', '1', '2023-04-29', '02:45:00', '0', '2023-04-29 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2738', '1', '3', '1', '2023-04-29', '02:48:00', '0', '2023-04-29 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2739', '1', '0', '1', '2023-04-29', '02:51:00', '0', '2023-04-29 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2740', '1', '8', '1', '2023-04-29', '02:54:00', '0', '2023-04-29 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2741', '1', '1', '1', '2023-04-29', '02:57:00', '0', '2023-04-29 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2742', '1', '5', '1', '2023-04-29', '03:00:00', '0', '2023-04-29 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2743', '1', '9', '1', '2023-04-29', '03:03:00', '0', '2023-04-29 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2744', '1', '6', '1', '2023-04-29', '03:06:00', '0', '2023-04-29 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2745', '1', '4', '1', '2023-04-29', '03:09:00', '0', '2023-04-29 03:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2746', '1', '3', '1', '2023-04-29', '03:12:00', '0', '2023-04-29 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2747', '1', '8', '1', '2023-04-29', '03:15:00', '0', '2023-04-29 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2748', '1', '3', '1', '2023-04-29', '03:18:00', '0', '2023-04-29 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2749', '1', '2', '1', '2023-04-29', '03:21:00', '0', '2023-04-29 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2750', '1', '5', '1', '2023-04-29', '03:24:00', '0', '2023-04-29 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2751', '1', '5', '1', '2023-04-29', '03:27:00', '0', '2023-04-29 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2752', '1', '1', '1', '2023-04-29', '03:30:00', '0', '2023-04-29 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2753', '1', '3', '1', '2023-04-29', '03:33:00', '0', '2023-04-29 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2754', '1', '0', '1', '2023-04-29', '03:36:00', '0', '2023-04-29 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2755', '1', '7', '1', '2023-04-29', '03:39:00', '0', '2023-04-29 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2756', '1', '7', '1', '2023-04-29', '03:42:00', '0', '2023-04-29 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2757', '1', '3', '1', '2023-04-29', '03:45:00', '0', '2023-04-29 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2758', '1', '9', '1', '2023-04-29', '03:48:00', '0', '2023-04-29 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2759', '1', '2', '1', '2023-04-29', '03:51:00', '0', '2023-04-29 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2760', '1', '2', '1', '2023-04-29', '03:54:00', '0', '2023-04-29 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2761', '1', '9', '1', '2023-04-29', '03:57:00', '0', '2023-04-29 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2762', '1', '7', '1', '2023-04-29', '04:00:00', '0', '2023-04-29 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2763', '1', '6', '1', '2023-04-29', '04:03:00', '0', '2023-04-29 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2764', '1', '6', '1', '2023-04-29', '04:06:00', '0', '2023-04-29 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2765', '1', '3', '1', '2023-04-29', '04:09:00', '0', '2023-04-29 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2766', '1', '6', '1', '2023-04-29', '04:12:00', '0', '2023-04-29 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2767', '1', '8', '1', '2023-04-29', '04:15:00', '2', '2023-04-29 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2768', '1', '9', '1', '2023-04-29', '04:18:00', '0', '2023-04-29 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2769', '1', '8', '1', '2023-04-29', '04:21:00', '0', '2023-04-29 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2770', '1', '9', '1', '2023-04-29', '04:24:00', '0', '2023-04-29 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2771', '1', '8', '1', '2023-04-29', '04:27:00', '0', '2023-04-29 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2772', '1', '1', '1', '2023-04-29', '04:30:00', '0', '2023-04-29 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2773', '1', '4', '1', '2023-04-29', '04:33:00', '0', '2023-04-29 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2774', '1', '1', '1', '2023-04-29', '04:36:00', '0', '2023-04-29 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2775', '1', '7', '1', '2023-04-29', '04:39:00', '0', '2023-04-29 04:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2776', '1', '3', '1', '2023-04-29', '04:42:00', '0', '2023-04-29 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2777', '1', '9', '1', '2023-04-29', '04:45:00', '0', '2023-04-29 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2778', '1', '8', '1', '2023-04-29', '04:48:00', '0', '2023-04-29 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2779', '1', '1', '1', '2023-04-29', '04:51:00', '0', '2023-04-29 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2780', '1', '3', '1', '2023-04-29', '04:54:00', '0', '2023-04-29 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2781', '1', '1', '1', '2023-04-29', '04:57:00', '0', '2023-04-29 04:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2782', '1', '3', '1', '2023-04-29', '05:00:00', '0', '2023-04-29 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2783', '1', '3', '1', '2023-04-29', '05:03:00', '0', '2023-04-29 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2784', '1', '2', '1', '2023-04-29', '05:06:00', '0', '2023-04-29 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2785', '1', '2', '1', '2023-04-29', '05:09:00', '0', '2023-04-29 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2786', '1', '7', '1', '2023-04-29', '05:12:00', '0', '2023-04-29 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2787', '1', '2', '1', '2023-04-29', '05:15:00', '0', '2023-04-29 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2788', '1', '1', '1', '2023-04-29', '05:18:00', '0', '2023-04-29 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2789', '1', '2', '1', '2023-04-29', '05:21:00', '0', '2023-04-29 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2790', '1', '4', '1', '2023-04-29', '05:24:00', '0', '2023-04-29 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2791', '1', '8', '1', '2023-04-29', '05:27:00', '0', '2023-04-29 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2792', '1', '1', '1', '2023-04-29', '05:30:00', '0', '2023-04-29 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2793', '1', '9', '1', '2023-04-29', '05:33:00', '0', '2023-04-29 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2794', '1', '1', '1', '2023-04-29', '05:36:00', '0', '2023-04-29 05:36:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2795', '1', '6', '1', '2023-04-29', '05:39:00', '0', '2023-04-29 05:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2796', '1', '6', '1', '2023-04-29', '05:42:00', '0', '2023-04-29 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2797', '1', '8', '1', '2023-04-29', '05:45:00', '0', '2023-04-29 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2798', '1', '3', '1', '2023-04-29', '05:48:00', '0', '2023-04-29 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2799', '1', '8', '1', '2023-04-29', '05:51:00', '0', '2023-04-29 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2800', '1', '2', '1', '2023-04-29', '05:54:00', '0', '2023-04-29 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2801', '1', '2', '1', '2023-04-29', '05:57:00', '0', '2023-04-29 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2802', '1', '7', '1', '2023-04-29', '06:00:00', '0', '2023-04-29 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2803', '1', '3', '1', '2023-04-29', '06:03:00', '0', '2023-04-29 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2804', '1', '0', '1', '2023-04-29', '06:06:00', '0', '2023-04-29 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2805', '1', '6', '1', '2023-04-29', '06:09:00', '0', '2023-04-29 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2806', '1', '9', '1', '2023-04-29', '06:12:00', '0', '2023-04-29 06:12:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2807', '1', '1', '1', '2023-04-29', '06:15:00', '0', '2023-04-29 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2808', '1', '1', '1', '2023-04-29', '06:18:00', '0', '2023-04-29 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2809', '1', '8', '1', '2023-04-29', '06:21:00', '0', '2023-04-29 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2810', '1', '1', '1', '2023-04-29', '06:24:00', '0', '2023-04-29 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2811', '1', '8', '1', '2023-04-29', '06:27:00', '0', '2023-04-29 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2812', '1', '6', '1', '2023-04-29', '06:30:00', '0', '2023-04-29 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2813', '1', '7', '1', '2023-04-29', '06:33:00', '0', '2023-04-29 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2814', '1', '7', '1', '2023-04-29', '06:36:00', '0', '2023-04-29 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2815', '1', '1', '1', '2023-04-29', '06:39:00', '0', '2023-04-29 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2816', '1', '2', '1', '2023-04-29', '06:42:00', '0', '2023-04-29 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2817', '1', '0', '1', '2023-04-29', '06:45:00', '0', '2023-04-29 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2818', '1', '6', '1', '2023-04-29', '06:48:00', '0', '2023-04-29 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2819', '1', '2', '1', '2023-04-29', '06:51:00', '0', '2023-04-29 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2820', '1', '9', '1', '2023-04-29', '06:54:00', '0', '2023-04-29 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2821', '1', '0', '1', '2023-04-29', '06:57:00', '0', '2023-04-29 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2822', '1', '7', '1', '2023-04-29', '07:00:00', '0', '2023-04-29 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2823', '1', '3', '1', '2023-04-29', '07:03:00', '0', '2023-04-29 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2824', '1', '8', '1', '2023-04-29', '07:06:00', '0', '2023-04-29 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2825', '1', '5', '1', '2023-04-29', '07:09:00', '0', '2023-04-29 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2826', '1', '1', '1', '2023-04-29', '07:12:00', '0', '2023-04-29 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2827', '1', '8', '1', '2023-04-29', '07:15:00', '0', '2023-04-29 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2828', '1', '1', '1', '2023-04-29', '07:18:00', '0', '2023-04-29 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2829', '1', '3', '1', '2023-04-29', '07:21:00', '0', '2023-04-29 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2830', '1', '6', '1', '2023-04-29', '07:24:00', '0', '2023-04-29 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2831', '1', '0', '1', '2023-04-29', '07:27:00', '0', '2023-04-29 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2832', '1', '7', '1', '2023-04-29', '07:30:00', '0', '2023-04-29 07:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2833', '1', '6', '1', '2023-04-29', '07:33:00', '0', '2023-04-29 07:33:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2834', '1', '0', '1', '2023-04-29', '07:36:00', '0', '2023-04-29 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2835', '1', '4', '1', '2023-04-29', '07:39:00', '0', '2023-04-29 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2836', '1', '1', '1', '2023-04-29', '07:42:00', '0', '2023-04-29 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2837', '1', '7', '1', '2023-04-29', '07:45:00', '0', '2023-04-29 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2838', '1', '9', '1', '2023-04-29', '07:48:00', '2', '2023-04-29 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2839', '1', '4', '1', '2023-04-29', '07:51:00', '0', '2023-04-29 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2840', '1', '1', '1', '2023-04-29', '07:54:00', '0', '2023-04-29 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2841', '1', '0', '1', '2023-04-29', '07:57:00', '0', '2023-04-29 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2842', '1', '4', '1', '2023-04-29', '08:00:00', '0', '2023-04-29 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2843', '1', '7', '1', '2023-04-29', '08:03:00', '0', '2023-04-29 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2844', '1', '5', '1', '2023-04-29', '08:06:00', '0', '2023-04-29 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2845', '1', '9', '1', '2023-04-29', '08:09:00', '0', '2023-04-29 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2846', '1', '6', '1', '2023-04-29', '08:12:00', '0', '2023-04-29 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2847', '1', '6', '1', '2023-04-29', '08:15:00', '0', '2023-04-29 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2848', '1', '8', '1', '2023-04-29', '08:18:00', '0', '2023-04-29 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2849', '1', '0', '1', '2023-04-29', '08:21:00', '0', '2023-04-29 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2850', '1', '6', '1', '2023-04-29', '08:24:00', '0', '2023-04-29 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2851', '1', '0', '1', '2023-04-29', '08:27:00', '0', '2023-04-29 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2852', '1', '6', '1', '2023-04-29', '08:30:00', '0', '2023-04-29 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2853', '1', '6', '1', '2023-04-29', '08:33:00', '0', '2023-04-29 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2854', '1', '2', '1', '2023-04-29', '08:36:00', '0', '2023-04-29 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2855', '1', '3', '1', '2023-04-29', '08:39:00', '0', '2023-04-29 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2856', '1', '6', '1', '2023-04-29', '08:42:00', '0', '2023-04-29 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2857', '1', '7', '1', '2023-04-29', '08:45:00', '0', '2023-04-29 08:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2858', '1', '1', '1', '2023-04-29', '08:48:00', '0', '2023-04-29 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2859', '1', '8', '1', '2023-04-29', '08:51:00', '0', '2023-04-29 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2860', '1', '7', '1', '2023-04-29', '08:54:00', '0', '2023-04-29 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2861', '1', '6', '1', '2023-04-29', '08:57:00', '0', '2023-04-29 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2862', '1', '4', '1', '2023-04-29', '09:00:00', '0', '2023-04-29 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2863', '1', '9', '1', '2023-04-29', '09:03:00', '0', '2023-04-29 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2864', '1', '5', '1', '2023-04-29', '09:06:00', '0', '2023-04-29 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2865', '1', '6', '1', '2023-04-29', '09:09:00', '0', '2023-04-29 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2866', '1', '3', '1', '2023-04-29', '09:12:00', '0', '2023-04-29 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2867', '1', '6', '1', '2023-04-29', '09:15:00', '0', '2023-04-29 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2868', '1', '7', '1', '2023-04-29', '09:18:00', '0', '2023-04-29 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2869', '1', '5', '1', '2023-04-29', '09:21:00', '0', '2023-04-29 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2870', '1', '4', '1', '2023-04-29', '09:24:00', '0', '2023-04-29 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2871', '1', '8', '1', '2023-04-29', '09:27:00', '0', '2023-04-29 09:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2872', '1', '2', '1', '2023-04-29', '09:30:00', '0', '2023-04-29 09:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2873', '1', '6', '1', '2023-04-29', '09:33:00', '0', '2023-04-29 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2874', '1', '7', '1', '2023-04-29', '09:36:00', '0', '2023-04-29 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2875', '1', '3', '1', '2023-04-29', '09:39:00', '0', '2023-04-29 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2876', '1', '2', '1', '2023-04-29', '09:42:00', '0', '2023-04-29 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2877', '1', '1', '1', '2023-04-29', '09:45:00', '0', '2023-04-29 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2878', '1', '6', '1', '2023-04-30', '10:00:00', '0', '2023-04-30 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2879', '1', '3', '1', '2023-04-30', '10:03:00', '0', '2023-04-30 10:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2880', '1', '9', '1', '2023-04-30', '10:06:00', '0', '2023-04-30 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2881', '1', '4', '1', '2023-04-30', '10:09:00', '0', '2023-04-30 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2882', '1', '2', '1', '2023-04-30', '10:12:00', '0', '2023-04-30 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2883', '1', '3', '1', '2023-04-30', '10:15:00', '0', '2023-04-30 10:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2884', '1', '8', '1', '2023-04-30', '10:18:00', '0', '2023-04-30 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2885', '1', '9', '1', '2023-04-30', '10:21:00', '0', '2023-04-30 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2886', '1', '3', '1', '2023-04-30', '10:24:00', '0', '2023-04-30 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2887', '1', '5', '1', '2023-04-30', '10:27:00', '0', '2023-04-30 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2888', '1', '5', '1', '2023-04-30', '10:30:00', '0', '2023-04-30 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2889', '1', '8', '1', '2023-04-30', '10:33:00', '0', '2023-04-30 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2890', '1', '3', '1', '2023-04-30', '10:36:00', '0', '2023-04-30 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2891', '1', '6', '1', '2023-04-30', '10:39:00', '0', '2023-04-30 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2892', '1', '0', '1', '2023-04-30', '10:42:00', '0', '2023-04-30 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2893', '1', '9', '1', '2023-04-30', '10:45:00', '0', '2023-04-30 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2894', '1', '2', '1', '2023-04-30', '10:48:00', '0', '2023-04-30 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2895', '1', '6', '1', '2023-04-30', '10:51:00', '0', '2023-04-30 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2896', '1', '0', '1', '2023-04-30', '10:54:00', '0', '2023-04-30 10:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2897', '1', '7', '1', '2023-04-30', '10:57:00', '0', '2023-04-30 10:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2898', '1', '5', '1', '2023-04-30', '11:00:00', '0', '2023-04-30 11:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2899', '1', '6', '1', '2023-04-30', '11:03:00', '0', '2023-04-30 11:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2900', '1', '5', '1', '2023-04-30', '11:06:00', '0', '2023-04-30 11:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2901', '1', '1', '1', '2023-04-30', '11:09:00', '0', '2023-04-30 11:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2902', '1', '7', '1', '2023-04-30', '11:12:00', '0', '2023-04-30 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2903', '1', '7', '1', '2023-04-30', '11:15:00', '0', '2023-04-30 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2904', '1', '8', '1', '2023-04-30', '11:18:00', '0', '2023-04-30 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2905', '1', '6', '1', '2023-04-30', '11:21:00', '0', '2023-04-30 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2906', '1', '3', '1', '2023-04-30', '11:24:00', '0', '2023-04-30 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2907', '1', '1', '1', '2023-04-30', '11:27:00', '0', '2023-04-30 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2908', '1', '0', '1', '2023-04-30', '11:30:00', '0', '2023-04-30 11:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2909', '1', '4', '1', '2023-04-30', '11:33:00', '0', '2023-04-30 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2910', '1', '4', '1', '2023-04-30', '11:36:00', '0', '2023-04-30 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2911', '1', '4', '1', '2023-04-30', '11:39:00', '0', '2023-04-30 11:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2912', '1', '2', '1', '2023-04-30', '11:42:00', '0', '2023-04-30 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2913', '1', '2', '1', '2023-04-30', '11:45:00', '0', '2023-04-30 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2914', '1', '2', '1', '2023-04-30', '11:48:00', '0', '2023-04-30 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2915', '1', '4', '1', '2023-04-30', '11:51:00', '0', '2023-04-30 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2916', '1', '9', '1', '2023-04-30', '11:54:00', '0', '2023-04-30 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2917', '1', '1', '1', '2023-04-30', '11:57:00', '0', '2023-04-30 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2918', '1', '1', '1', '2023-04-30', '12:00:00', '0', '2023-04-30 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2919', '1', '0', '1', '2023-04-30', '12:03:00', '0', '2023-04-30 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2920', '1', '1', '1', '2023-04-30', '12:06:00', '0', '2023-04-30 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2921', '1', '7', '1', '2023-04-30', '12:09:00', '0', '2023-04-30 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2922', '1', '1', '1', '2023-04-30', '12:12:00', '0', '2023-04-30 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2923', '1', '6', '1', '2023-04-30', '12:15:00', '0', '2023-04-30 12:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2924', '1', '4', '1', '2023-04-30', '12:18:00', '0', '2023-04-30 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2925', '1', '0', '1', '2023-04-30', '12:21:00', '0', '2023-04-30 12:21:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2926', '1', '3', '1', '2023-04-30', '12:24:00', '2', '2023-04-30 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2927', '1', '0', '1', '2023-04-30', '12:27:00', '0', '2023-04-30 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2928', '1', '4', '1', '2023-04-30', '12:30:00', '0', '2023-04-30 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2929', '1', '2', '1', '2023-04-30', '12:33:00', '0', '2023-04-30 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2930', '1', '0', '1', '2023-04-30', '12:36:00', '0', '2023-04-30 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2931', '1', '3', '1', '2023-04-30', '12:39:00', '0', '2023-04-30 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2932', '1', '2', '1', '2023-04-30', '12:42:00', '0', '2023-04-30 12:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2933', '1', '9', '1', '2023-04-30', '12:45:00', '0', '2023-04-30 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2934', '1', '9', '1', '2023-04-30', '12:48:00', '0', '2023-04-30 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2935', '1', '2', '1', '2023-04-30', '12:51:00', '0', '2023-04-30 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2936', '1', '6', '1', '2023-04-30', '12:54:00', '0', '2023-04-30 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2937', '1', '4', '1', '2023-04-30', '12:57:00', '0', '2023-04-30 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2938', '1', '8', '1', '2023-04-30', '01:00:00', '0', '2023-04-30 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2939', '1', '6', '1', '2023-04-30', '01:03:00', '0', '2023-04-30 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2940', '1', '5', '1', '2023-04-30', '01:06:00', '3', '2023-04-30 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2941', '1', '0', '1', '2023-04-30', '01:09:00', '0', '2023-04-30 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2942', '1', '5', '1', '2023-04-30', '01:12:00', '0', '2023-04-30 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2943', '1', '0', '1', '2023-04-30', '01:15:00', '0', '2023-04-30 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2944', '1', '0', '1', '2023-04-30', '01:18:00', '0', '2023-04-30 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2945', '1', '6', '1', '2023-04-30', '01:21:00', '0', '2023-04-30 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2946', '1', '0', '1', '2023-04-30', '01:24:00', '0', '2023-04-30 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2947', '1', '7', '1', '2023-04-30', '01:27:00', '0', '2023-04-30 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2948', '1', '4', '1', '2023-04-30', '01:30:00', '0', '2023-04-30 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2949', '1', '5', '1', '2023-04-30', '01:33:00', '0', '2023-04-30 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2950', '1', '5', '1', '2023-04-30', '01:36:00', '0', '2023-04-30 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2951', '1', '9', '1', '2023-04-30', '01:39:00', '0', '2023-04-30 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2952', '1', '2', '1', '2023-04-30', '01:42:00', '0', '2023-04-30 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2953', '1', '9', '1', '2023-04-30', '01:45:00', '0', '2023-04-30 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2954', '1', '1', '1', '2023-04-30', '01:48:00', '0', '2023-04-30 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2955', '1', '5', '1', '2023-04-30', '01:51:00', '4', '2023-04-30 01:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2956', '1', '4', '1', '2023-04-30', '01:54:00', '0', '2023-04-30 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2957', '1', '2', '1', '2023-04-30', '01:57:00', '0', '2023-04-30 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2958', '1', '8', '1', '2023-04-30', '02:00:00', '0', '2023-04-30 02:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2959', '1', '7', '1', '2023-04-30', '02:03:00', '0', '2023-04-30 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2960', '1', '8', '1', '2023-04-30', '02:06:00', '0', '2023-04-30 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2961', '1', '5', '1', '2023-04-30', '02:09:00', '0', '2023-04-30 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2962', '1', '6', '1', '2023-04-30', '02:12:00', '2', '2023-04-30 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2963', '1', '2', '1', '2023-04-30', '02:15:00', '0', '2023-04-30 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2964', '1', '6', '1', '2023-04-30', '02:18:00', '0', '2023-04-30 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2965', '1', '7', '1', '2023-04-30', '02:21:00', '0', '2023-04-30 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2966', '1', '4', '1', '2023-04-30', '02:24:00', '0', '2023-04-30 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2967', '1', '7', '1', '2023-04-30', '02:27:00', '0', '2023-04-30 02:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2968', '1', '4', '1', '2023-04-30', '02:30:00', '0', '2023-04-30 02:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2969', '1', '3', '1', '2023-04-30', '02:33:00', '0', '2023-04-30 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2970', '1', '0', '1', '2023-04-30', '02:36:00', '0', '2023-04-30 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2971', '1', '6', '1', '2023-04-30', '02:39:00', '0', '2023-04-30 02:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2972', '1', '9', '1', '2023-04-30', '02:42:00', '0', '2023-04-30 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2973', '1', '6', '1', '2023-04-30', '02:45:00', '0', '2023-04-30 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2974', '1', '1', '1', '2023-04-30', '02:48:00', '0', '2023-04-30 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2975', '1', '7', '1', '2023-04-30', '02:51:00', '0', '2023-04-30 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2976', '1', '0', '1', '2023-04-30', '02:54:00', '0', '2023-04-30 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2977', '1', '2', '1', '2023-04-30', '02:57:00', '0', '2023-04-30 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2978', '1', '1', '1', '2023-04-30', '03:00:00', '0', '2023-04-30 03:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2979', '1', '3', '1', '2023-04-30', '03:03:00', '0', '2023-04-30 03:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2980', '1', '8', '1', '2023-04-30', '03:06:00', '0', '2023-04-30 03:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2981', '1', '8', '1', '2023-04-30', '03:09:00', '0', '2023-04-30 03:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2982', '1', '6', '1', '2023-04-30', '03:12:00', '0', '2023-04-30 03:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2983', '1', '2', '1', '2023-04-30', '03:15:00', '0', '2023-04-30 03:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2984', '1', '0', '1', '2023-04-30', '03:18:00', '0', '2023-04-30 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2985', '1', '8', '1', '2023-04-30', '03:21:00', '0', '2023-04-30 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2986', '1', '6', '1', '2023-04-30', '03:24:00', '0', '2023-04-30 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2987', '1', '7', '1', '2023-04-30', '03:27:00', '0', '2023-04-30 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2988', '1', '7', '1', '2023-04-30', '03:30:00', '0', '2023-04-30 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2989', '1', '0', '1', '2023-04-30', '03:33:00', '0', '2023-04-30 03:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2990', '1', '6', '1', '2023-04-30', '03:36:00', '0', '2023-04-30 03:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2991', '1', '6', '1', '2023-04-30', '03:39:00', '0', '2023-04-30 03:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2992', '1', '0', '1', '2023-04-30', '03:42:00', '0', '2023-04-30 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2993', '1', '7', '1', '2023-04-30', '03:45:00', '0', '2023-04-30 03:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2994', '1', '9', '1', '2023-04-30', '03:48:00', '0', '2023-04-30 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2995', '1', '6', '1', '2023-04-30', '03:51:00', '0', '2023-04-30 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2996', '1', '2', '1', '2023-04-30', '03:54:00', '0', '2023-04-30 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2997', '1', '1', '1', '2023-04-30', '03:57:00', '2', '2023-04-30 03:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2998', '1', '5', '1', '2023-04-30', '04:00:00', '0', '2023-04-30 04:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('2999', '1', '9', '1', '2023-04-30', '04:03:00', '0', '2023-04-30 04:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3000', '1', '4', '1', '2023-04-30', '04:06:00', '0', '2023-04-30 04:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3001', '1', '5', '1', '2023-04-30', '04:09:00', '0', '2023-04-30 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3002', '1', '4', '1', '2023-04-30', '04:12:00', '0', '2023-04-30 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3003', '1', '9', '1', '2023-04-30', '04:15:00', '0', '2023-04-30 04:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3004', '1', '0', '1', '2023-04-30', '04:18:00', '0', '2023-04-30 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3005', '1', '8', '1', '2023-04-30', '04:21:00', '0', '2023-04-30 04:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3006', '1', '5', '1', '2023-04-30', '04:24:00', '0', '2023-04-30 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3007', '1', '4', '1', '2023-04-30', '04:27:00', '0', '2023-04-30 04:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3008', '1', '1', '1', '2023-04-30', '04:30:00', '0', '2023-04-30 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3009', '1', '7', '1', '2023-04-30', '04:33:00', '0', '2023-04-30 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3010', '1', '4', '1', '2023-04-30', '04:36:00', '0', '2023-04-30 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3011', '1', '5', '1', '2023-04-30', '04:39:00', '0', '2023-04-30 04:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3012', '1', '5', '1', '2023-04-30', '04:42:00', '0', '2023-04-30 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3013', '1', '8', '1', '2023-04-30', '04:45:00', '0', '2023-04-30 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3014', '1', '3', '1', '2023-04-30', '04:48:00', '0', '2023-04-30 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3015', '1', '1', '1', '2023-04-30', '04:51:00', '0', '2023-04-30 04:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3016', '1', '7', '1', '2023-04-30', '04:54:00', '0', '2023-04-30 04:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3017', '1', '1', '1', '2023-04-30', '04:57:00', '0', '2023-04-30 04:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3018', '1', '1', '1', '2023-04-30', '05:00:00', '0', '2023-04-30 05:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3019', '1', '7', '1', '2023-04-30', '05:03:00', '0', '2023-04-30 05:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3020', '1', '2', '1', '2023-04-30', '05:06:00', '0', '2023-04-30 05:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3021', '1', '6', '1', '2023-04-30', '05:09:00', '0', '2023-04-30 05:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3022', '1', '2', '1', '2023-04-30', '05:12:00', '0', '2023-04-30 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3023', '1', '9', '1', '2023-04-30', '05:15:00', '0', '2023-04-30 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3024', '1', '5', '1', '2023-04-30', '05:18:00', '0', '2023-04-30 05:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3025', '1', '4', '1', '2023-04-30', '05:21:00', '0', '2023-04-30 05:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3026', '1', '5', '1', '2023-04-30', '05:24:00', '0', '2023-04-30 05:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3027', '1', '4', '1', '2023-04-30', '05:27:00', '0', '2023-04-30 05:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3028', '1', '0', '1', '2023-04-30', '05:30:00', '0', '2023-04-30 05:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3029', '1', '7', '1', '2023-04-30', '05:33:00', '0', '2023-04-30 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3030', '1', '3', '1', '2023-04-30', '05:36:00', '0', '2023-04-30 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3031', '1', '5', '1', '2023-04-30', '05:39:00', '0', '2023-04-30 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3032', '1', '5', '1', '2023-04-30', '05:42:00', '0', '2023-04-30 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3033', '1', '6', '1', '2023-04-30', '05:45:00', '0', '2023-04-30 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3034', '1', '2', '1', '2023-04-30', '05:48:00', '0', '2023-04-30 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3035', '1', '4', '1', '2023-04-30', '05:51:00', '0', '2023-04-30 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3036', '1', '2', '1', '2023-04-30', '05:54:00', '0', '2023-04-30 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3037', '1', '2', '1', '2023-04-30', '05:57:00', '0', '2023-04-30 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3038', '1', '2', '1', '2023-04-30', '06:00:00', '0', '2023-04-30 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3039', '1', '3', '1', '2023-04-30', '06:03:00', '0', '2023-04-30 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3040', '1', '0', '1', '2023-04-30', '06:06:00', '0', '2023-04-30 06:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3041', '1', '7', '1', '2023-04-30', '06:09:00', '0', '2023-04-30 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3042', '1', '9', '1', '2023-04-30', '06:12:00', '0', '2023-04-30 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3043', '1', '0', '1', '2023-04-30', '06:15:00', '0', '2023-04-30 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3044', '1', '0', '1', '2023-04-30', '06:18:00', '0', '2023-04-30 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3045', '1', '3', '1', '2023-04-30', '06:21:00', '4', '2023-04-30 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3046', '1', '1', '1', '2023-04-30', '06:24:00', '0', '2023-04-30 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3047', '1', '3', '1', '2023-04-30', '06:27:00', '0', '2023-04-30 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3048', '1', '7', '1', '2023-04-30', '06:30:00', '0', '2023-04-30 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3049', '1', '6', '1', '2023-04-30', '06:33:00', '0', '2023-04-30 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3050', '1', '3', '1', '2023-04-30', '06:36:00', '0', '2023-04-30 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3051', '1', '7', '1', '2023-04-30', '06:39:00', '0', '2023-04-30 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3052', '1', '1', '1', '2023-04-30', '06:42:00', '0', '2023-04-30 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3053', '1', '0', '1', '2023-04-30', '06:45:00', '0', '2023-04-30 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3054', '1', '2', '1', '2023-04-30', '06:48:00', '0', '2023-04-30 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3055', '1', '7', '1', '2023-04-30', '06:51:00', '0', '2023-04-30 06:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3056', '1', '7', '1', '2023-04-30', '06:54:00', '0', '2023-04-30 06:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3057', '1', '2', '1', '2023-04-30', '06:57:00', '0', '2023-04-30 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3058', '1', '4', '1', '2023-04-30', '07:00:00', '0', '2023-04-30 07:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3059', '1', '4', '1', '2023-04-30', '07:03:00', '0', '2023-04-30 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3060', '1', '9', '1', '2023-04-30', '07:06:00', '0', '2023-04-30 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3061', '1', '2', '1', '2023-04-30', '07:09:00', '0', '2023-04-30 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3062', '1', '2', '1', '2023-04-30', '07:12:00', '0', '2023-04-30 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3063', '1', '5', '1', '2023-04-30', '07:15:00', '0', '2023-04-30 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3064', '1', '0', '1', '2023-04-30', '07:18:00', '0', '2023-04-30 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3065', '1', '3', '1', '2023-04-30', '07:21:00', '0', '2023-04-30 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3066', '1', '7', '1', '2023-04-30', '07:24:00', '2', '2023-04-30 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3067', '1', '8', '1', '2023-04-30', '07:27:00', '0', '2023-04-30 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3068', '1', '9', '1', '2023-04-30', '07:30:00', '0', '2023-04-30 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3069', '1', '9', '1', '2023-04-30', '07:33:00', '0', '2023-04-30 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3070', '1', '2', '1', '2023-04-30', '07:36:00', '0', '2023-04-30 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3071', '1', '1', '1', '2023-04-30', '07:39:00', '0', '2023-04-30 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3072', '1', '2', '1', '2023-04-30', '07:42:00', '0', '2023-04-30 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3073', '1', '5', '1', '2023-04-30', '07:45:00', '0', '2023-04-30 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3074', '1', '0', '1', '2023-04-30', '07:48:00', '0', '2023-04-30 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3075', '1', '5', '1', '2023-04-30', '07:51:00', '0', '2023-04-30 07:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3076', '1', '5', '1', '2023-04-30', '07:54:00', '0', '2023-04-30 07:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3077', '1', '2', '1', '2023-04-30', '07:57:00', '0', '2023-04-30 07:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3078', '1', '2', '1', '2023-04-30', '08:00:00', '0', '2023-04-30 08:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3079', '1', '8', '1', '2023-04-30', '08:03:00', '0', '2023-04-30 08:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3080', '1', '4', '1', '2023-04-30', '08:06:00', '0', '2023-04-30 08:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3081', '1', '6', '1', '2023-04-30', '08:09:00', '0', '2023-04-30 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3082', '1', '8', '1', '2023-04-30', '08:12:00', '0', '2023-04-30 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3083', '1', '2', '1', '2023-04-30', '08:15:00', '0', '2023-04-30 08:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3084', '1', '0', '1', '2023-04-30', '08:18:00', '0', '2023-04-30 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3085', '1', '6', '1', '2023-04-30', '08:21:00', '0', '2023-04-30 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3086', '1', '0', '1', '2023-04-30', '08:24:00', '0', '2023-04-30 08:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3087', '1', '9', '1', '2023-04-30', '08:27:00', '0', '2023-04-30 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3088', '1', '6', '1', '2023-04-30', '08:30:00', '0', '2023-04-30 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3089', '1', '5', '1', '2023-04-30', '08:33:00', '0', '2023-04-30 15:01:49', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3090', '1', '6', '1', '2023-04-30', '08:36:00', '0', '2023-04-30 15:05:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3091', '1', '1', '1', '2023-04-30', '08:39:00', '0', '2023-04-30 08:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3092', '1', '4', '1', '2023-04-30', '08:42:00', '0', '2023-04-30 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3093', '1', '5', '1', '2023-04-30', '08:45:00', '0', '2023-04-30 08:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3094', '1', '9', '1', '2023-04-30', '08:48:00', '0', '2023-04-30 08:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3095', '1', '3', '1', '2023-04-30', '08:51:00', '0', '2023-04-30 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3096', '1', '6', '1', '2023-04-30', '08:54:00', '0', '2023-04-30 08:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3097', '1', '1', '1', '2023-04-30', '08:57:00', '0', '2023-04-30 08:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3098', '1', '3', '1', '2023-04-30', '09:00:00', '0', '2023-04-30 09:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3099', '1', '9', '1', '2023-04-30', '09:03:00', '0', '2023-04-30 09:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3100', '1', '5', '1', '2023-04-30', '09:06:00', '0', '2023-04-30 09:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3101', '1', '6', '1', '2023-04-30', '09:09:00', '0', '2023-04-30 09:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3102', '1', '1', '1', '2023-04-30', '09:12:00', '0', '2023-04-30 09:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3103', '1', '8', '1', '2023-04-30', '09:15:00', '0', '2023-04-30 09:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3104', '1', '2', '1', '2023-04-30', '09:18:00', '0', '2023-04-30 09:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3105', '1', '1', '1', '2023-04-30', '09:21:00', '0', '2023-04-30 09:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3106', '1', '4', '1', '2023-04-30', '09:24:00', '0', '2023-04-30 09:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3107', '1', '4', '1', '2023-04-30', '09:27:00', '0', '2023-04-30 09:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3108', '1', '5', '1', '2023-04-30', '09:30:00', '0', '2023-04-30 09:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3109', '1', '6', '1', '2023-04-30', '09:33:00', '0', '2023-04-30 09:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3110', '1', '1', '1', '2023-04-30', '09:36:00', '0', '2023-04-30 09:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3111', '1', '0', '1', '2023-04-30', '09:39:00', '0', '2023-04-30 09:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3112', '1', '6', '1', '2023-04-30', '09:42:00', '0', '2023-04-30 09:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3113', '1', '9', '1', '2023-04-30', '09:45:00', '0', '2023-04-30 09:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3114', '1', '0', '1', '2023-05-01', '10:00:00', '0', '2023-05-01 10:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3115', '1', '0', '1', '2023-05-01', '10:03:00', '0', '2023-05-01 10:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3116', '1', '8', '1', '2023-05-01', '10:06:00', '0', '2023-05-01 10:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3117', '1', '8', '1', '2023-05-01', '10:09:00', '0', '2023-05-01 10:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3118', '1', '5', '1', '2023-05-01', '10:12:00', '0', '2023-05-01 10:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3119', '1', '6', '1', '2023-05-01', '10:15:00', '0', '2023-05-01 10:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3120', '1', '2', '1', '2023-05-01', '10:18:00', '0', '2023-05-01 10:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3121', '1', '2', '1', '2023-05-01', '10:21:00', '0', '2023-05-01 10:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3122', '1', '8', '1', '2023-05-01', '10:24:00', '0', '2023-05-01 10:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3123', '1', '3', '1', '2023-05-01', '10:27:00', '0', '2023-05-01 10:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3124', '1', '9', '1', '2023-05-01', '10:30:00', '0', '2023-05-01 10:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3125', '1', '0', '1', '2023-05-01', '10:33:00', '0', '2023-05-01 10:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3126', '1', '4', '1', '2023-05-01', '10:36:00', '0', '2023-05-01 10:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3127', '1', '9', '1', '2023-05-01', '10:39:00', '0', '2023-05-01 10:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3128', '1', '2', '1', '2023-05-01', '10:42:00', '0', '2023-05-01 10:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3129', '1', '5', '1', '2023-05-01', '10:45:00', '0', '2023-05-01 10:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3130', '1', '9', '1', '2023-05-01', '10:48:00', '0', '2023-05-01 10:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3131', '1', '1', '1', '2023-05-01', '10:51:00', '0', '2023-05-01 10:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3132', '1', '7', '1', '2023-05-01', '10:54:00', '0', '2023-05-01 10:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3133', '1', '1', '1', '2023-05-01', '10:57:00', '0', '2023-05-01 10:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3134', '1', '7', '1', '2023-05-01', '11:00:00', '0', '2023-05-01 11:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3135', '1', '9', '1', '2023-05-01', '11:03:00', '0', '2023-05-01 11:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3136', '1', '0', '1', '2023-05-01', '11:06:00', '0', '2023-05-01 11:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3137', '1', '3', '1', '2023-05-01', '11:09:00', '0', '2023-05-01 11:09:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3138', '1', '0', '1', '2023-05-01', '11:12:00', '0', '2023-05-01 11:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3139', '1', '9', '1', '2023-05-01', '11:15:00', '0', '2023-05-01 11:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3140', '1', '3', '1', '2023-05-01', '11:18:00', '0', '2023-05-01 11:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3141', '1', '8', '1', '2023-05-01', '11:21:00', '0', '2023-05-01 11:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3142', '1', '6', '1', '2023-05-01', '11:24:00', '0', '2023-05-01 11:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3143', '1', '7', '1', '2023-05-01', '11:27:00', '0', '2023-05-01 11:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3144', '1', '2', '1', '2023-05-01', '11:30:00', '0', '2023-05-01 11:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3145', '1', '7', '1', '2023-05-01', '11:33:00', '0', '2023-05-01 11:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3146', '1', '7', '1', '2023-05-01', '11:36:00', '0', '2023-05-01 11:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3147', '1', '7', '1', '2023-05-01', '11:39:00', '0', '2023-05-01 11:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3148', '1', '2', '1', '2023-05-01', '11:42:00', '0', '2023-05-01 11:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3149', '1', '6', '1', '2023-05-01', '11:45:00', '0', '2023-05-01 11:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3150', '1', '3', '1', '2023-05-01', '11:48:00', '0', '2023-05-01 11:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3151', '1', '0', '1', '2023-05-01', '11:51:00', '0', '2023-05-01 11:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3152', '1', '4', '1', '2023-05-01', '11:54:00', '0', '2023-05-01 11:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3153', '1', '3', '1', '2023-05-01', '11:57:00', '0', '2023-05-01 11:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3154', '1', '9', '1', '2023-05-01', '12:00:00', '0', '2023-05-01 12:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3155', '1', '3', '1', '2023-05-01', '12:03:00', '0', '2023-05-01 12:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3156', '1', '0', '1', '2023-05-01', '12:06:00', '0', '2023-05-01 12:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3157', '1', '3', '1', '2023-05-01', '12:09:00', '0', '2023-05-01 12:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3158', '1', '9', '1', '2023-05-01', '12:12:00', '0', '2023-05-01 12:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3159', '1', '3', '1', '2023-05-01', '12:15:00', '0', '2023-05-01 12:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3160', '1', '0', '1', '2023-05-01', '12:18:00', '0', '2023-05-01 12:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3161', '1', '6', '1', '2023-05-01', '12:21:00', '0', '2023-05-01 12:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3162', '1', '1', '1', '2023-05-01', '12:24:00', '0', '2023-05-01 12:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3163', '1', '3', '1', '2023-05-01', '12:27:00', '0', '2023-05-01 12:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3164', '1', '6', '1', '2023-05-01', '12:30:00', '0', '2023-05-01 12:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3165', '1', '3', '1', '2023-05-01', '12:33:00', '0', '2023-05-01 12:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3166', '1', '1', '1', '2023-05-01', '12:36:00', '0', '2023-05-01 12:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3167', '1', '9', '1', '2023-05-01', '12:39:00', '0', '2023-05-01 12:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3168', '1', '1', '1', '2023-05-01', '12:42:00', '0', '2023-05-01 12:42:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3169', '1', '2', '1', '2023-05-01', '12:45:00', '0', '2023-05-01 12:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3170', '1', '5', '1', '2023-05-01', '12:48:00', '0', '2023-05-01 12:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3171', '1', '6', '1', '2023-05-01', '12:51:00', '0', '2023-05-01 12:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3172', '1', '3', '1', '2023-05-01', '12:54:00', '0', '2023-05-01 12:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3173', '1', '5', '1', '2023-05-01', '12:57:00', '0', '2023-05-01 12:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3174', '1', '3', '1', '2023-05-01', '01:00:00', '0', '2023-05-01 01:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3175', '1', '9', '1', '2023-05-01', '01:03:00', '0', '2023-05-01 01:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3176', '1', '6', '1', '2023-05-01', '01:06:00', '0', '2023-05-01 01:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3177', '1', '0', '1', '2023-05-01', '01:09:00', '0', '2023-05-01 01:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3178', '1', '5', '1', '2023-05-01', '01:12:00', '0', '2023-05-01 01:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3179', '1', '0', '1', '2023-05-01', '01:15:00', '0', '2023-05-01 01:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3180', '1', '0', '1', '2023-05-01', '01:18:00', '0', '2023-05-01 01:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3181', '1', '0', '1', '2023-05-01', '01:21:00', '0', '2023-05-01 01:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3182', '1', '7', '1', '2023-05-01', '01:24:00', '0', '2023-05-01 01:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3183', '1', '9', '1', '2023-05-01', '01:27:00', '0', '2023-05-01 01:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3184', '1', '5', '1', '2023-05-01', '01:30:00', '0', '2023-05-01 01:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3185', '1', '9', '1', '2023-05-01', '01:33:00', '0', '2023-05-01 01:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3186', '1', '7', '1', '2023-05-01', '01:36:00', '0', '2023-05-01 01:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3187', '1', '4', '1', '2023-05-01', '01:39:00', '0', '2023-05-01 01:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3188', '1', '6', '1', '2023-05-01', '01:42:00', '0', '2023-05-01 01:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3189', '1', '7', '1', '2023-05-01', '01:45:00', '0', '2023-05-01 01:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3190', '1', '2', '1', '2023-05-01', '01:48:00', '0', '2023-05-01 01:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3191', '1', '1', '1', '2023-05-01', '01:51:00', '4', '2023-05-01 01:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3192', '1', '3', '1', '2023-05-01', '01:54:00', '0', '2023-05-01 01:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3193', '1', '3', '1', '2023-05-01', '01:57:00', '0', '2023-05-01 01:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3194', '1', '9', '1', '2023-05-01', '02:00:00', '0', '2023-05-01 02:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3195', '1', '7', '1', '2023-05-01', '02:03:00', '0', '2023-05-01 02:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3196', '1', '3', '1', '2023-05-01', '02:06:00', '0', '2023-05-01 02:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3197', '1', '6', '1', '2023-05-01', '02:09:00', '0', '2023-05-01 02:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3198', '1', '7', '1', '2023-05-01', '02:12:00', '2', '2023-05-01 02:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3199', '1', '1', '1', '2023-05-01', '02:15:00', '0', '2023-05-01 02:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3200', '1', '0', '1', '2023-05-01', '02:18:00', '0', '2023-05-01 02:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3201', '1', '6', '1', '2023-05-01', '02:21:00', '0', '2023-05-01 02:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3202', '1', '9', '1', '2023-05-01', '02:24:00', '0', '2023-05-01 02:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3203', '1', '2', '1', '2023-05-01', '02:27:00', '0', '2023-05-01 02:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3204', '1', '7', '1', '2023-05-01', '02:30:00', '0', '2023-05-01 02:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3205', '1', '0', '1', '2023-05-01', '02:33:00', '0', '2023-05-01 02:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3206', '1', '5', '1', '2023-05-01', '02:36:00', '0', '2023-05-01 02:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3207', '1', '7', '1', '2023-05-01', '02:39:00', '0', '2023-05-01 02:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3208', '1', '2', '1', '2023-05-01', '02:42:00', '0', '2023-05-01 02:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3209', '1', '5', '1', '2023-05-01', '02:45:00', '0', '2023-05-01 02:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3210', '1', '8', '1', '2023-05-01', '02:48:00', '0', '2023-05-01 02:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3211', '1', '3', '1', '2023-05-01', '02:51:00', '0', '2023-05-01 02:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3212', '1', '7', '1', '2023-05-01', '02:54:00', '0', '2023-05-01 02:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3213', '1', '4', '1', '2023-05-01', '02:57:00', '0', '2023-05-01 02:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3214', '1', '1', '1', '2023-05-01', '03:00:00', '0', '2023-05-01 03:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3215', '1', '2', '1', '2023-05-01', '03:03:00', '0', '2023-05-01 03:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3216', '1', '2', '1', '2023-05-01', '03:06:00', '0', '2023-05-01 03:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3217', '1', '3', '1', '2023-05-01', '03:09:00', '0', '2023-05-01 03:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3218', '1', '0', '1', '2023-05-01', '03:12:00', '0', '2023-05-01 03:12:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3219', '1', '9', '1', '2023-05-01', '03:15:00', '0', '2023-05-01 03:15:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3220', '1', '9', '1', '2023-05-01', '03:18:00', '0', '2023-05-01 03:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3221', '1', '5', '1', '2023-05-01', '03:21:00', '0', '2023-05-01 03:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3222', '1', '0', '1', '2023-05-01', '03:24:00', '0', '2023-05-01 03:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3223', '1', '3', '1', '2023-05-01', '03:27:00', '0', '2023-05-01 03:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3224', '1', '2', '1', '2023-05-01', '03:30:00', '0', '2023-05-01 03:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3225', '1', '4', '1', '2023-05-01', '03:33:00', '0', '2023-05-01 10:02:37', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3226', '1', '7', '1', '2023-05-01', '03:36:00', '0', '2023-05-01 03:36:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3227', '1', '1', '1', '2023-05-01', '03:39:00', '0', '2023-05-01 10:07:42', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3228', '1', '8', '1', '2023-05-01', '03:42:00', '0', '2023-05-01 03:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3229', '1', '3', '1', '2023-05-01', '03:45:00', '0', '2023-05-01 10:14:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3230', '1', '2', '1', '2023-05-01', '03:48:00', '0', '2023-05-01 03:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3231', '1', '9', '1', '2023-05-01', '03:51:00', '0', '2023-05-01 03:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3232', '1', '9', '1', '2023-05-01', '03:54:00', '0', '2023-05-01 03:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3233', '1', '0', '1', '2023-05-01', '03:57:00', '0', '2023-05-01 10:26:35', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3234', '1', '4', '1', '2023-05-01', '04:00:00', '0', '2023-05-01 10:29:40', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3235', '1', '7', '1', '2023-05-01', '04:03:00', '0', '2023-05-01 10:32:43', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3236', '1', '7', '1', '2023-05-01', '04:06:00', '0', '2023-05-01 10:35:38', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3237', '1', '8', '1', '2023-05-01', '04:09:00', '3', '2023-05-01 04:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3238', '1', '4', '1', '2023-05-01', '04:12:00', '4', '2023-05-01 04:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3239', '1', '5', '1', '2023-05-01', '04:15:00', '0', '2023-05-01 10:44:32', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3240', '1', '1', '1', '2023-05-01', '04:18:00', '4', '2023-05-01 04:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3241', '1', '3', '1', '2023-05-01', '04:21:00', '0', '2023-05-01 10:50:38', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3242', '1', '6', '1', '2023-05-01', '04:24:00', '3', '2023-05-01 04:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3243', '1', '5', '1', '2023-05-01', '04:27:00', '0', '2023-05-01 10:56:32', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3244', '1', '7', '1', '2023-05-01', '04:30:00', '4', '2023-05-01 04:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3245', '1', '9', '1', '2023-05-01', '04:33:00', '0', '2023-05-01 04:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3246', '1', '4', '1', '2023-05-01', '04:36:00', '0', '2023-05-01 04:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3247', '1', '5', '1', '2023-05-01', '04:39:00', '0', '2023-05-01 11:08:49', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3248', '1', '8', '1', '2023-05-01', '04:42:00', '0', '2023-05-01 04:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3249', '1', '2', '1', '2023-05-01', '04:45:00', '0', '2023-05-01 04:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3250', '1', '5', '1', '2023-05-01', '04:48:00', '4', '2023-05-01 04:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3251', '1', '6', '1', '2023-05-01', '04:51:00', '0', '2023-05-01 11:20:10', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3252', '1', '9', '1', '2023-05-01', '04:54:00', '0', '2023-05-01 04:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3253', '1', '7', '1', '2023-05-01', '04:57:00', '0', '2023-05-01 11:25:03', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3254', '1', '6', '1', '2023-05-01', '05:00:00', '0', '2023-05-01 05:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3255', '1', '3', '1', '2023-05-01', '05:03:00', '4', '2023-05-01 05:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3256', '1', '9', '1', '2023-05-01', '05:06:00', '0', '2023-05-01 05:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3257', '1', '6', '1', '2023-05-01', '05:09:00', '0', '2023-05-01 05:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3258', '1', '8', '1', '2023-05-01', '05:12:00', '0', '2023-05-01 05:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3259', '1', '1', '1', '2023-05-01', '05:15:00', '0', '2023-05-01 05:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3260', '1', '7', '1', '2023-05-01', '05:18:00', '0', '2023-05-01 05:18:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3261', '1', '6', '1', '2023-05-01', '05:21:00', '0', '2023-05-01 05:21:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3262', '1', '8', '1', '2023-05-01', '05:24:00', '0', '2023-05-01 05:24:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3263', '1', '5', '1', '2023-05-01', '05:27:00', '0', '2023-05-01 05:27:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3264', '1', '2', '1', '2023-05-01', '05:30:00', '0', '2023-05-01 05:30:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3265', '1', '4', '1', '2023-05-01', '05:33:00', '0', '2023-05-01 05:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3266', '1', '7', '1', '2023-05-01', '05:36:00', '0', '2023-05-01 05:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3267', '1', '1', '1', '2023-05-01', '05:39:00', '0', '2023-05-01 05:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3268', '1', '6', '1', '2023-05-01', '05:42:00', '0', '2023-05-01 05:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3269', '1', '1', '1', '2023-05-01', '05:45:00', '0', '2023-05-01 05:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3270', '1', '3', '1', '2023-05-01', '05:48:00', '0', '2023-05-01 05:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3271', '1', '3', '1', '2023-05-01', '05:51:00', '0', '2023-05-01 05:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3272', '1', '0', '1', '2023-05-01', '05:54:00', '0', '2023-05-01 05:54:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3273', '1', '5', '1', '2023-05-01', '05:57:00', '0', '2023-05-01 05:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3274', '1', '9', '1', '2023-05-01', '06:00:00', '0', '2023-05-01 06:00:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3275', '1', '5', '1', '2023-05-01', '06:03:00', '0', '2023-05-01 06:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3276', '1', '2', '1', '2023-05-01', '06:06:00', '0', '2023-05-01 06:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3277', '1', '0', '1', '2023-05-01', '06:09:00', '0', '2023-05-01 06:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3278', '1', '0', '1', '2023-05-01', '06:12:00', '0', '2023-05-01 06:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3279', '1', '6', '1', '2023-05-01', '06:15:00', '0', '2023-05-01 06:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3280', '1', '6', '1', '2023-05-01', '06:18:00', '0', '2023-05-01 06:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3281', '1', '9', '1', '2023-05-01', '06:21:00', '0', '2023-05-01 06:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3282', '1', '1', '1', '2023-05-01', '06:24:00', '0', '2023-05-01 06:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3283', '1', '1', '1', '2023-05-01', '06:27:00', '0', '2023-05-01 06:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3284', '1', '8', '1', '2023-05-01', '06:30:00', '0', '2023-05-01 06:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3285', '1', '4', '1', '2023-05-01', '06:33:00', '0', '2023-05-01 06:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3286', '1', '3', '1', '2023-05-01', '06:36:00', '0', '2023-05-01 06:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3287', '1', '9', '1', '2023-05-01', '06:39:00', '0', '2023-05-01 06:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3288', '1', '5', '1', '2023-05-01', '06:42:00', '0', '2023-05-01 06:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3289', '1', '5', '1', '2023-05-01', '06:45:00', '0', '2023-05-01 06:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3290', '1', '4', '1', '2023-05-01', '06:48:00', '0', '2023-05-01 06:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3291', '1', '6', '1', '2023-05-01', '06:51:00', '0', '2023-05-01 06:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3292', '1', '6', '1', '2023-05-01', '06:54:00', '0', '2023-05-01 06:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3293', '1', '6', '1', '2023-05-01', '06:57:00', '0', '2023-05-01 06:57:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3294', '1', '7', '1', '2023-05-01', '07:00:00', '0', '2023-05-01 07:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3295', '1', '0', '1', '2023-05-01', '07:03:00', '0', '2023-05-01 07:03:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3296', '1', '4', '1', '2023-05-01', '07:06:00', '0', '2023-05-01 07:06:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3297', '1', '3', '1', '2023-05-01', '07:09:00', '0', '2023-05-01 07:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3298', '1', '5', '1', '2023-05-01', '07:12:00', '0', '2023-05-01 07:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3299', '1', '4', '1', '2023-05-01', '07:15:00', '0', '2023-05-01 07:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3300', '1', '8', '1', '2023-05-01', '07:18:00', '0', '2023-05-01 07:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3301', '1', '1', '1', '2023-05-01', '07:21:00', '0', '2023-05-01 07:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3302', '1', '4', '1', '2023-05-01', '07:24:00', '0', '2023-05-01 07:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3303', '1', '6', '1', '2023-05-01', '07:27:00', '0', '2023-05-01 07:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3304', '1', '2', '1', '2023-05-01', '07:30:00', '0', '2023-05-01 07:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3305', '1', '1', '1', '2023-05-01', '07:33:00', '0', '2023-05-01 07:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3306', '1', '2', '1', '2023-05-01', '07:36:00', '0', '2023-05-01 07:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3307', '1', '8', '1', '2023-05-01', '07:39:00', '0', '2023-05-01 07:39:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3308', '1', '0', '1', '2023-05-01', '07:42:00', '0', '2023-05-01 07:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3309', '1', '9', '1', '2023-05-01', '07:45:00', '0', '2023-05-01 07:45:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3310', '1', '0', '1', '2023-05-01', '07:48:00', '0', '2023-05-01 07:48:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3311', '1', '2', '1', '2023-05-01', '07:51:00', '0', '2023-05-01 07:51:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3312', '1', '3', '1', '2023-05-01', '07:54:00', '0', '2023-05-01 07:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3313', '1', '4', '1', '2023-05-01', '07:57:00', '0', '2023-05-01 07:57:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3314', '1', '0', '1', '2023-05-01', '08:00:00', '0', '2023-05-01 08:00:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3315', '1', '7', '1', '2023-05-01', '08:03:00', '0', '2023-05-01 08:03:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3316', '1', '5', '1', '2023-05-01', '08:06:00', '0', '2023-05-01 08:06:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3317', '1', '5', '1', '2023-05-01', '08:09:00', '0', '2023-05-01 08:09:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3318', '1', '2', '1', '2023-05-01', '08:12:00', '0', '2023-05-01 08:12:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3319', '1', '4', '1', '2023-05-01', '08:15:00', '0', '2023-05-01 08:15:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3320', '1', '8', '1', '2023-05-01', '08:18:00', '0', '2023-05-01 08:18:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3321', '1', '8', '1', '2023-05-01', '08:21:00', '0', '2023-05-01 08:21:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3322', '1', '8', '1', '2023-05-01', '08:24:00', '0', '2023-05-01 08:24:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3323', '1', '6', '1', '2023-05-01', '08:27:00', '0', '2023-05-01 08:27:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3324', '1', '4', '1', '2023-05-01', '08:30:00', '0', '2023-05-01 08:30:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3325', '1', '2', '1', '2023-05-01', '08:33:00', '0', '2023-05-01 08:33:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3326', '1', '7', '1', '2023-05-01', '08:36:00', '0', '2023-05-01 08:36:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3327', '1', '2', '1', '2023-05-01', '08:39:00', '0', '2023-05-01 08:39:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3328', '1', '4', '1', '2023-05-01', '08:42:00', '0', '2023-05-01 08:42:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3329', '1', '1', '1', '2023-05-01', '08:45:00', '0', '2023-05-01 08:45:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3330', '1', '9', '1', '2023-05-01', '08:48:00', '0', '2023-05-01 08:48:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3331', '1', '5', '1', '2023-05-01', '08:51:00', '0', '2023-05-01 08:51:01', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3332', '1', '3', '1', '2023-05-01', '08:54:00', '0', '2023-05-01 08:54:02', null, '1');
INSERT INTO `mx_result_tran` VALUES ('3333', '1', '9', '1', '2023-05-01', '08:57:00', '0', '2023-05-01